//>>built
require({cache:{"dojo/data/ItemFileWriteStore":function(){define(["../_base/lang","../_base/declare","../_base/array","../_base/json","../_base/kernel","./ItemFileReadStore","../date/stamp"],function(_1,_2,_3,_4,_5,_6,_7){return _2("dojo.data.ItemFileWriteStore",_6,{constructor:function(_8){this._features["dojo.data.api.Write"]=true;this._features["dojo.data.api.Notification"]=true;this._pending={_newItems:{},_modifiedItems:{},_deletedItems:{}};if(!this._datatypeMap["Date"].serialize){this._datatypeMap["Date"].serialize=function(_9){return _7.toISOString(_9,{zulu:true});};}if(_8&&(_8.referenceIntegrity===false)){this.referenceIntegrity=false;}this._saveInProgress=false;},referenceIntegrity:true,_assert:function(_a){if(!_a){throw new Error("assertion failed in ItemFileWriteStore");}},_getIdentifierAttribute:function(){return this.getFeatures()["dojo.data.api.Identity"];},newItem:function(_b,_c){this._assert(!this._saveInProgress);if(!this._loadFinished){this._forceLoad();}if(typeof _b!="object"&&typeof _b!="undefined"){throw new Error("newItem() was passed something other than an object");}var _d=null;var _e=this._getIdentifierAttribute();if(_e===Number){_d=this._arrayOfAllItems.length;}else{_d=_b[_e];if(typeof _d==="undefined"){throw new Error("newItem() was not passed an identity for the new item");}if(_1.isArray(_d)){throw new Error("newItem() was not passed an single-valued identity");}}if(this._itemsByIdentity){this._assert(typeof this._itemsByIdentity[_d]==="undefined");}this._assert(typeof this._pending._newItems[_d]==="undefined");this._assert(typeof this._pending._deletedItems[_d]==="undefined");var _f={};_f[this._storeRefPropName]=this;_f[this._itemNumPropName]=this._arrayOfAllItems.length;if(this._itemsByIdentity){this._itemsByIdentity[_d]=_f;_f[_e]=[_d];}this._arrayOfAllItems.push(_f);var _10=null;if(_c&&_c.parent&&_c.attribute){_10={item:_c.parent,attribute:_c.attribute,oldValue:undefined};var _11=this.getValues(_c.parent,_c.attribute);if(_11&&_11.length>0){var _12=_11.slice(0,_11.length);if(_11.length===1){_10.oldValue=_11[0];}else{_10.oldValue=_11.slice(0,_11.length);}_12.push(_f);this._setValueOrValues(_c.parent,_c.attribute,_12,false);_10.newValue=this.getValues(_c.parent,_c.attribute);}else{this._setValueOrValues(_c.parent,_c.attribute,_f,false);_10.newValue=_f;}}else{_f[this._rootItemPropName]=true;this._arrayOfTopLevelItems.push(_f);}this._pending._newItems[_d]=_f;for(var key in _b){if(key===this._storeRefPropName||key===this._itemNumPropName){throw new Error("encountered bug in ItemFileWriteStore.newItem");}var _13=_b[key];if(!_1.isArray(_13)){_13=[_13];}_f[key]=_13;if(this.referenceIntegrity){for(var i=0;i<_13.length;i++){var val=_13[i];if(this.isItem(val)){this._addReferenceToMap(val,_f,key);}}}}this.onNew(_f,_10);return _f;},_removeArrayElement:function(_14,_15){var _16=_3.indexOf(_14,_15);if(_16!=-1){_14.splice(_16,1);return true;}return false;},deleteItem:function(_17){this._assert(!this._saveInProgress);this._assertIsItem(_17);var _18=_17[this._itemNumPropName];var _19=this.getIdentity(_17);if(this.referenceIntegrity){var _1a=this.getAttributes(_17);if(_17[this._reverseRefMap]){_17["backup_"+this._reverseRefMap]=_1.clone(_17[this._reverseRefMap]);}_3.forEach(_1a,function(_1b){_3.forEach(this.getValues(_17,_1b),function(_1c){if(this.isItem(_1c)){if(!_17["backupRefs_"+this._reverseRefMap]){_17["backupRefs_"+this._reverseRefMap]=[];}_17["backupRefs_"+this._reverseRefMap].push({id:this.getIdentity(_1c),attr:_1b});this._removeReferenceFromMap(_1c,_17,_1b);}},this);},this);var _1d=_17[this._reverseRefMap];if(_1d){for(var _1e in _1d){var _1f=null;if(this._itemsByIdentity){_1f=this._itemsByIdentity[_1e];}else{_1f=this._arrayOfAllItems[_1e];}if(_1f){for(var _20 in _1d[_1e]){var _21=this.getValues(_1f,_20)||[];var _22=_3.filter(_21,function(_23){return !(this.isItem(_23)&&this.getIdentity(_23)==_19);},this);this._removeReferenceFromMap(_17,_1f,_20);if(_22.length<_21.length){this._setValueOrValues(_1f,_20,_22,true);}}}}}}this._arrayOfAllItems[_18]=null;_17[this._storeRefPropName]=null;if(this._itemsByIdentity){delete this._itemsByIdentity[_19];}this._pending._deletedItems[_19]=_17;if(_17[this._rootItemPropName]){this._removeArrayElement(this._arrayOfTopLevelItems,_17);}this.onDelete(_17);return true;},setValue:function(_24,_25,_26){return this._setValueOrValues(_24,_25,_26,true);},setValues:function(_27,_28,_29){return this._setValueOrValues(_27,_28,_29,true);},unsetAttribute:function(_2a,_2b){return this._setValueOrValues(_2a,_2b,[],true);},_setValueOrValues:function(_2c,_2d,_2e,_2f){this._assert(!this._saveInProgress);this._assertIsItem(_2c);this._assert(_1.isString(_2d));this._assert(typeof _2e!=="undefined");var _30=this._getIdentifierAttribute();if(_2d==_30){throw new Error("ItemFileWriteStore does not have support for changing the value of an item's identifier.");}var _31=this._getValueOrValues(_2c,_2d);var _32=this.getIdentity(_2c);if(!this._pending._modifiedItems[_32]){var _33={};for(var key in _2c){if((key===this._storeRefPropName)||(key===this._itemNumPropName)||(key===this._rootItemPropName)){_33[key]=_2c[key];}else{if(key===this._reverseRefMap){_33[key]=_1.clone(_2c[key]);}else{_33[key]=_2c[key].slice(0,_2c[key].length);}}}this._pending._modifiedItems[_32]=_33;}var _34=false;if(_1.isArray(_2e)&&_2e.length===0){_34=delete _2c[_2d];_2e=undefined;if(this.referenceIntegrity&&_31){var _35=_31;if(!_1.isArray(_35)){_35=[_35];}for(var i=0;i<_35.length;i++){var _36=_35[i];if(this.isItem(_36)){this._removeReferenceFromMap(_36,_2c,_2d);}}}}else{var _37;if(_1.isArray(_2e)){_37=_2e.slice(0,_2e.length);}else{_37=[_2e];}if(this.referenceIntegrity){if(_31){var _35=_31;if(!_1.isArray(_35)){_35=[_35];}var map={};_3.forEach(_35,function(_38){if(this.isItem(_38)){var id=this.getIdentity(_38);map[id.toString()]=true;}},this);_3.forEach(_37,function(_39){if(this.isItem(_39)){var id=this.getIdentity(_39);if(map[id.toString()]){delete map[id.toString()];}else{this._addReferenceToMap(_39,_2c,_2d);}}},this);for(var rId in map){var _3a;if(this._itemsByIdentity){_3a=this._itemsByIdentity[rId];}else{_3a=this._arrayOfAllItems[rId];}this._removeReferenceFromMap(_3a,_2c,_2d);}}else{for(var i=0;i<_37.length;i++){var _36=_37[i];if(this.isItem(_36)){this._addReferenceToMap(_36,_2c,_2d);}}}}_2c[_2d]=_37;_34=true;}if(_2f){this.onSet(_2c,_2d,_31,_2e);}return _34;},_addReferenceToMap:function(_3b,_3c,_3d){var _3e=this.getIdentity(_3c);var _3f=_3b[this._reverseRefMap];if(!_3f){_3f=_3b[this._reverseRefMap]={};}var _40=_3f[_3e];if(!_40){_40=_3f[_3e]={};}_40[_3d]=true;},_removeReferenceFromMap:function(_41,_42,_43){var _44=this.getIdentity(_42);var _45=_41[this._reverseRefMap];var _46;if(_45){for(_46 in _45){if(_46==_44){delete _45[_46][_43];if(this._isEmpty(_45[_46])){delete _45[_46];}}}if(this._isEmpty(_45)){delete _41[this._reverseRefMap];}}},_dumpReferenceMap:function(){var i;for(i=0;i<this._arrayOfAllItems.length;i++){var _47=this._arrayOfAllItems[i];if(_47&&_47[this._reverseRefMap]){}}},_getValueOrValues:function(_48,_49){var _4a=undefined;if(this.hasAttribute(_48,_49)){var _4b=this.getValues(_48,_49);if(_4b.length==1){_4a=_4b[0];}else{_4a=_4b;}}return _4a;},_flatten:function(_4c){if(this.isItem(_4c)){return {_reference:this.getIdentity(_4c)};}else{if(typeof _4c==="object"){for(var _4d in this._datatypeMap){var _4e=this._datatypeMap[_4d];if(_1.isObject(_4e)&&!_1.isFunction(_4e)){if(_4c instanceof _4e.type){if(!_4e.serialize){throw new Error("ItemFileWriteStore:  No serializer defined for type mapping: ["+_4d+"]");}return {_type:_4d,_value:_4e.serialize(_4c)};}}else{if(_4c instanceof _4e){return {_type:_4d,_value:_4c.toString()};}}}}return _4c;}},_getNewFileContentString:function(){var _4f={};var _50=this._getIdentifierAttribute();if(_50!==Number){_4f.identifier=_50;}if(this._labelAttr){_4f.label=this._labelAttr;}_4f.items=[];for(var i=0;i<this._arrayOfAllItems.length;++i){var _51=this._arrayOfAllItems[i];if(_51!==null){var _52={};for(var key in _51){if(key!==this._storeRefPropName&&key!==this._itemNumPropName&&key!==this._reverseRefMap&&key!==this._rootItemPropName){var _53=this.getValues(_51,key);if(_53.length==1){_52[key]=this._flatten(_53[0]);}else{var _54=[];for(var j=0;j<_53.length;++j){_54.push(this._flatten(_53[j]));_52[key]=_54;}}}}_4f.items.push(_52);}}var _55=true;return _4.toJson(_4f,_55);},_isEmpty:function(_56){var _57=true;if(_1.isObject(_56)){var i;for(i in _56){_57=false;break;}}else{if(_1.isArray(_56)){if(_56.length>0){_57=false;}}}return _57;},save:function(_58){this._assert(!this._saveInProgress);this._saveInProgress=true;var _59=this;var _5a=function(){_59._pending={_newItems:{},_modifiedItems:{},_deletedItems:{}};_59._saveInProgress=false;if(_58&&_58.onComplete){var _5b=_58.scope||_5.global;_58.onComplete.call(_5b);}};var _5c=function(err){_59._saveInProgress=false;if(_58&&_58.onError){var _5d=_58.scope||_5.global;_58.onError.call(_5d,err);}};if(this._saveEverything){var _5e=this._getNewFileContentString();this._saveEverything(_5a,_5c,_5e);}if(this._saveCustom){this._saveCustom(_5a,_5c);}if(!this._saveEverything&&!this._saveCustom){_5a();}},revert:function(){this._assert(!this._saveInProgress);var _5f;for(_5f in this._pending._modifiedItems){var _60=this._pending._modifiedItems[_5f];var _61=null;if(this._itemsByIdentity){_61=this._itemsByIdentity[_5f];}else{_61=this._arrayOfAllItems[_5f];}_60[this._storeRefPropName]=this;for(var key in _61){delete _61[key];}_1.mixin(_61,_60);}var _62;for(_5f in this._pending._deletedItems){_62=this._pending._deletedItems[_5f];_62[this._storeRefPropName]=this;var _63=_62[this._itemNumPropName];if(_62["backup_"+this._reverseRefMap]){_62[this._reverseRefMap]=_62["backup_"+this._reverseRefMap];delete _62["backup_"+this._reverseRefMap];}this._arrayOfAllItems[_63]=_62;if(this._itemsByIdentity){this._itemsByIdentity[_5f]=_62;}if(_62[this._rootItemPropName]){this._arrayOfTopLevelItems.push(_62);}}for(_5f in this._pending._deletedItems){_62=this._pending._deletedItems[_5f];if(_62["backupRefs_"+this._reverseRefMap]){_3.forEach(_62["backupRefs_"+this._reverseRefMap],function(_64){var _65;if(this._itemsByIdentity){_65=this._itemsByIdentity[_64.id];}else{_65=this._arrayOfAllItems[_64.id];}this._addReferenceToMap(_65,_62,_64.attr);},this);delete _62["backupRefs_"+this._reverseRefMap];}}for(_5f in this._pending._newItems){var _66=this._pending._newItems[_5f];_66[this._storeRefPropName]=null;this._arrayOfAllItems[_66[this._itemNumPropName]]=null;if(_66[this._rootItemPropName]){this._removeArrayElement(this._arrayOfTopLevelItems,_66);}if(this._itemsByIdentity){delete this._itemsByIdentity[_5f];}}this._pending={_newItems:{},_modifiedItems:{},_deletedItems:{}};return true;},isDirty:function(_67){if(_67){var _68=this.getIdentity(_67);return new Boolean(this._pending._newItems[_68]||this._pending._modifiedItems[_68]||this._pending._deletedItems[_68]).valueOf();}else{return !this._isEmpty(this._pending._newItems)||!this._isEmpty(this._pending._modifiedItems)||!this._isEmpty(this._pending._deletedItems);}},onSet:function(_69,_6a,_6b,_6c){},onNew:function(_6d,_6e){},onDelete:function(_6f){},close:function(_70){if(this.clearOnClose){if(!this.isDirty()){this.inherited(arguments);}else{throw new Error("dojo.data.ItemFileWriteStore: There are unsaved changes present in the store.  Please save or revert the changes before invoking close.");}}}});});},"dojo/data/ItemFileReadStore":function(){define(["../_base/kernel","../_base/lang","../_base/declare","../_base/array","../_base/xhr","../Evented","./util/filter","./util/simpleFetch","../date/stamp"],function(_71,_72,_73,_74,xhr,_75,_76,_77,_78){var _79=_73("dojo.data.ItemFileReadStore",[_75],{constructor:function(_7a){this._arrayOfAllItems=[];this._arrayOfTopLevelItems=[];this._loadFinished=false;this._jsonFileUrl=_7a.url;this._ccUrl=_7a.url;this.url=_7a.url;this._jsonData=_7a.data;this.data=null;this._datatypeMap=_7a.typeMap||{};if(!this._datatypeMap["Date"]){this._datatypeMap["Date"]={type:Date,deserialize:function(_7b){return _78.fromISOString(_7b);}};}this._features={"dojo.data.api.Read":true,"dojo.data.api.Identity":true};this._itemsByIdentity=null;this._storeRefPropName="_S";this._itemNumPropName="_0";this._rootItemPropName="_RI";this._reverseRefMap="_RRM";this._loadInProgress=false;this._queuedFetches=[];if(_7a.urlPreventCache!==undefined){this.urlPreventCache=_7a.urlPreventCache?true:false;}if(_7a.hierarchical!==undefined){this.hierarchical=_7a.hierarchical?true:false;}if(_7a.clearOnClose){this.clearOnClose=true;}if("failOk" in _7a){this.failOk=_7a.failOk?true:false;}},url:"",_ccUrl:"",data:null,typeMap:null,clearOnClose:false,urlPreventCache:false,failOk:false,hierarchical:true,_assertIsItem:function(_7c){if(!this.isItem(_7c)){throw new Error(this.declaredClass+": Invalid item argument.");}},_assertIsAttribute:function(_7d){if(typeof _7d!=="string"){throw new Error(this.declaredClass+": Invalid attribute argument.");}},getValue:function(_7e,_7f,_80){var _81=this.getValues(_7e,_7f);return (_81.length>0)?_81[0]:_80;},getValues:function(_82,_83){this._assertIsItem(_82);this._assertIsAttribute(_83);return (_82[_83]||[]).slice(0);},getAttributes:function(_84){this._assertIsItem(_84);var _85=[];for(var key in _84){if((key!==this._storeRefPropName)&&(key!==this._itemNumPropName)&&(key!==this._rootItemPropName)&&(key!==this._reverseRefMap)){_85.push(key);}}return _85;},hasAttribute:function(_86,_87){this._assertIsItem(_86);this._assertIsAttribute(_87);return (_87 in _86);},containsValue:function(_88,_89,_8a){var _8b=undefined;if(typeof _8a==="string"){_8b=_76.patternToRegExp(_8a,false);}return this._containsValue(_88,_89,_8a,_8b);},_containsValue:function(_8c,_8d,_8e,_8f){return _74.some(this.getValues(_8c,_8d),function(_90){if(_90!==null&&!_72.isObject(_90)&&_8f){if(_90.toString().match(_8f)){return true;}}else{if(_8e===_90){return true;}}});},isItem:function(_91){if(_91&&_91[this._storeRefPropName]===this){if(this._arrayOfAllItems[_91[this._itemNumPropName]]===_91){return true;}}return false;},isItemLoaded:function(_92){return this.isItem(_92);},loadItem:function(_93){this._assertIsItem(_93.item);},getFeatures:function(){return this._features;},getLabel:function(_94){if(this._labelAttr&&this.isItem(_94)){return this.getValue(_94,this._labelAttr);}return undefined;},getLabelAttributes:function(_95){if(this._labelAttr){return [this._labelAttr];}return null;},filter:function(_96,_97,_98){var _99=[],i,key;if(_96.query){var _9a,_9b=_96.queryOptions?_96.queryOptions.ignoreCase:false;var _9c={};for(key in _96.query){_9a=_96.query[key];if(typeof _9a==="string"){_9c[key]=_76.patternToRegExp(_9a,_9b);}else{if(_9a instanceof RegExp){_9c[key]=_9a;}}}for(i=0;i<_97.length;++i){var _9d=true;var _9e=_97[i];if(_9e===null){_9d=false;}else{for(key in _96.query){_9a=_96.query[key];if(!this._containsValue(_9e,key,_9a,_9c[key])){_9d=false;}}}if(_9d){_99.push(_9e);}}_98(_99,_96);}else{for(i=0;i<_97.length;++i){var _9f=_97[i];if(_9f!==null){_99.push(_9f);}}_98(_99,_96);}},_fetchItems:function(_a0,_a1,_a2){var _a3=this;if(this._loadFinished){this.filter(_a0,this._getItemsArray(_a0.queryOptions),_a1);}else{if(this._jsonFileUrl!==this._ccUrl){_71.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");this._ccUrl=this._jsonFileUrl;this.url=this._jsonFileUrl;}else{if(this.url!==this._ccUrl){this._jsonFileUrl=this.url;this._ccUrl=this.url;}}if(this.data!=null){this._jsonData=this.data;this.data=null;}if(this._jsonFileUrl){if(this._loadInProgress){this._queuedFetches.push({args:_a0,filter:_72.hitch(_a3,"filter"),findCallback:_72.hitch(_a3,_a1)});}else{this._loadInProgress=true;var _a4={url:_a3._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk};var _a5=xhr.get(_a4);_a5.addCallback(function(_a6){try{_a3._getItemsFromLoadedData(_a6);_a3._loadFinished=true;_a3._loadInProgress=false;_a3.filter(_a0,_a3._getItemsArray(_a0.queryOptions),_a1);_a3._handleQueuedFetches();}catch(e){_a3._loadFinished=true;_a3._loadInProgress=false;_a2(e,_a0);}});_a5.addErrback(function(_a7){_a3._loadInProgress=false;_a2(_a7,_a0);});var _a8=null;if(_a0.abort){_a8=_a0.abort;}_a0.abort=function(){var df=_a5;if(df&&df.fired===-1){df.cancel();df=null;}if(_a8){_a8.call(_a0);}};}}else{if(this._jsonData){try{this._loadFinished=true;this._getItemsFromLoadedData(this._jsonData);this._jsonData=null;_a3.filter(_a0,this._getItemsArray(_a0.queryOptions),_a1);}catch(e){_a2(e,_a0);}}else{_a2(new Error(this.declaredClass+": No JSON source data was provided as either URL or a nested Javascript object."),_a0);}}}},_handleQueuedFetches:function(){if(this._queuedFetches.length>0){for(var i=0;i<this._queuedFetches.length;i++){var _a9=this._queuedFetches[i],_aa=_a9.args,_ab=_a9.filter,_ac=_a9.findCallback;if(_ab){_ab(_aa,this._getItemsArray(_aa.queryOptions),_ac);}else{this.fetchItemByIdentity(_aa);}}this._queuedFetches=[];}},_getItemsArray:function(_ad){if(_ad&&_ad.deep){return this._arrayOfAllItems;}return this._arrayOfTopLevelItems;},close:function(_ae){if(this.clearOnClose&&this._loadFinished&&!this._loadInProgress){if(((this._jsonFileUrl==""||this._jsonFileUrl==null)&&(this.url==""||this.url==null))&&this.data==null){}this._arrayOfAllItems=[];this._arrayOfTopLevelItems=[];this._loadFinished=false;this._itemsByIdentity=null;this._loadInProgress=false;this._queuedFetches=[];}},_getItemsFromLoadedData:function(_af){var _b0=false,_b1=this;function _b2(_b3){return (_b3!==null)&&(typeof _b3==="object")&&(!_72.isArray(_b3)||_b0)&&(!_72.isFunction(_b3))&&(_b3.constructor==Object||_72.isArray(_b3))&&(typeof _b3._reference==="undefined")&&(typeof _b3._type==="undefined")&&(typeof _b3._value==="undefined")&&_b1.hierarchical;};function _b4(_b5){_b1._arrayOfAllItems.push(_b5);for(var _b6 in _b5){var _b7=_b5[_b6];if(_b7){if(_72.isArray(_b7)){var _b8=_b7;for(var k=0;k<_b8.length;++k){var _b9=_b8[k];if(_b2(_b9)){_b4(_b9);}}}else{if(_b2(_b7)){_b4(_b7);}}}}};this._labelAttr=_af.label;var i,_ba;this._arrayOfAllItems=[];this._arrayOfTopLevelItems=_af.items;for(i=0;i<this._arrayOfTopLevelItems.length;++i){_ba=this._arrayOfTopLevelItems[i];if(_72.isArray(_ba)){_b0=true;}_b4(_ba);_ba[this._rootItemPropName]=true;}var _bb={},key;for(i=0;i<this._arrayOfAllItems.length;++i){_ba=this._arrayOfAllItems[i];for(key in _ba){if(key!==this._rootItemPropName){var _bc=_ba[key];if(_bc!==null){if(!_72.isArray(_bc)){_ba[key]=[_bc];}}else{_ba[key]=[null];}}_bb[key]=key;}}while(_bb[this._storeRefPropName]){this._storeRefPropName+="_";}while(_bb[this._itemNumPropName]){this._itemNumPropName+="_";}while(_bb[this._reverseRefMap]){this._reverseRefMap+="_";}var _bd;var _be=_af.identifier;if(_be){this._itemsByIdentity={};this._features["dojo.data.api.Identity"]=_be;for(i=0;i<this._arrayOfAllItems.length;++i){_ba=this._arrayOfAllItems[i];_bd=_ba[_be];var _bf=_bd[0];if(!Object.hasOwnProperty.call(this._itemsByIdentity,_bf)){this._itemsByIdentity[_bf]=_ba;}else{if(this._jsonFileUrl){throw new Error(this.declaredClass+":  The json data as specified by: ["+this._jsonFileUrl+"] is malformed.  Items within the list have identifier: ["+_be+"].  Value collided: ["+_bf+"]");}else{if(this._jsonData){throw new Error(this.declaredClass+":  The json data provided by the creation arguments is malformed.  Items within the list have identifier: ["+_be+"].  Value collided: ["+_bf+"]");}}}}}else{this._features["dojo.data.api.Identity"]=Number;}for(i=0;i<this._arrayOfAllItems.length;++i){_ba=this._arrayOfAllItems[i];_ba[this._storeRefPropName]=this;_ba[this._itemNumPropName]=i;}for(i=0;i<this._arrayOfAllItems.length;++i){_ba=this._arrayOfAllItems[i];for(key in _ba){_bd=_ba[key];for(var j=0;j<_bd.length;++j){_bc=_bd[j];if(_bc!==null&&typeof _bc=="object"){if(("_type" in _bc)&&("_value" in _bc)){var _c0=_bc._type;var _c1=this._datatypeMap[_c0];if(!_c1){throw new Error("dojo.data.ItemFileReadStore: in the typeMap constructor arg, no object class was specified for the datatype '"+_c0+"'");}else{if(_72.isFunction(_c1)){_bd[j]=new _c1(_bc._value);}else{if(_72.isFunction(_c1.deserialize)){_bd[j]=_c1.deserialize(_bc._value);}else{throw new Error("dojo.data.ItemFileReadStore: Value provided in typeMap was neither a constructor, nor a an object with a deserialize function");}}}}if(_bc._reference){var _c2=_bc._reference;if(!_72.isObject(_c2)){_bd[j]=this._getItemByIdentity(_c2);}else{for(var k=0;k<this._arrayOfAllItems.length;++k){var _c3=this._arrayOfAllItems[k],_c4=true;for(var _c5 in _c2){if(_c3[_c5]!=_c2[_c5]){_c4=false;}}if(_c4){_bd[j]=_c3;}}}if(this.referenceIntegrity){var _c6=_bd[j];if(this.isItem(_c6)){this._addReferenceToMap(_c6,_ba,key);}}}else{if(this.isItem(_bc)){if(this.referenceIntegrity){this._addReferenceToMap(_bc,_ba,key);}}}}}}}},_addReferenceToMap:function(_c7,_c8,_c9){},getIdentity:function(_ca){var _cb=this._features["dojo.data.api.Identity"];if(_cb===Number){return _ca[this._itemNumPropName];}else{var _cc=_ca[_cb];if(_cc){return _cc[0];}}return null;},fetchItemByIdentity:function(_cd){var _ce,_cf;if(!this._loadFinished){var _d0=this;if(this._jsonFileUrl!==this._ccUrl){_71.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");this._ccUrl=this._jsonFileUrl;this.url=this._jsonFileUrl;}else{if(this.url!==this._ccUrl){this._jsonFileUrl=this.url;this._ccUrl=this.url;}}if(this.data!=null&&this._jsonData==null){this._jsonData=this.data;this.data=null;}if(this._jsonFileUrl){if(this._loadInProgress){this._queuedFetches.push({args:_cd});}else{this._loadInProgress=true;var _d1={url:_d0._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk};var _d2=xhr.get(_d1);_d2.addCallback(function(_d3){var _d4=_cd.scope?_cd.scope:_71.global;try{_d0._getItemsFromLoadedData(_d3);_d0._loadFinished=true;_d0._loadInProgress=false;_ce=_d0._getItemByIdentity(_cd.identity);if(_cd.onItem){_cd.onItem.call(_d4,_ce);}_d0._handleQueuedFetches();}catch(error){_d0._loadInProgress=false;if(_cd.onError){_cd.onError.call(_d4,error);}}});_d2.addErrback(function(_d5){_d0._loadInProgress=false;if(_cd.onError){var _d6=_cd.scope?_cd.scope:_71.global;_cd.onError.call(_d6,_d5);}});}}else{if(this._jsonData){_d0._getItemsFromLoadedData(_d0._jsonData);_d0._jsonData=null;_d0._loadFinished=true;_ce=_d0._getItemByIdentity(_cd.identity);if(_cd.onItem){_cf=_cd.scope?_cd.scope:_71.global;_cd.onItem.call(_cf,_ce);}}}}else{_ce=this._getItemByIdentity(_cd.identity);if(_cd.onItem){_cf=_cd.scope?_cd.scope:_71.global;_cd.onItem.call(_cf,_ce);}}},_getItemByIdentity:function(_d7){var _d8=null;if(this._itemsByIdentity){if(Object.hasOwnProperty.call(this._itemsByIdentity,_d7)){_d8=this._itemsByIdentity[_d7];}}else{if(Object.hasOwnProperty.call(this._arrayOfAllItems,_d7)){_d8=this._arrayOfAllItems[_d7];}}if(_d8===undefined){_d8=null;}return _d8;},getIdentityAttributes:function(_d9){var _da=this._features["dojo.data.api.Identity"];if(_da===Number){return null;}else{return [_da];}},_forceLoad:function(){var _db=this;if(this._jsonFileUrl!==this._ccUrl){_71.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");this._ccUrl=this._jsonFileUrl;this.url=this._jsonFileUrl;}else{if(this.url!==this._ccUrl){this._jsonFileUrl=this.url;this._ccUrl=this.url;}}if(this.data!=null){this._jsonData=this.data;this.data=null;}if(this._jsonFileUrl){var _dc={url:this._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk,sync:true};var _dd=xhr.get(_dc);_dd.addCallback(function(_de){try{if(_db._loadInProgress!==true&&!_db._loadFinished){_db._getItemsFromLoadedData(_de);_db._loadFinished=true;}else{if(_db._loadInProgress){throw new Error(this.declaredClass+":  Unable to perform a synchronous load, an async load is in progress.");}}}catch(e){throw e;}});_dd.addErrback(function(_df){throw _df;});}else{if(this._jsonData){_db._getItemsFromLoadedData(_db._jsonData);_db._jsonData=null;_db._loadFinished=true;}}}});_72.extend(_79,_77);return _79;});},"dojo/data/util/filter":function(){define(["../../_base/lang"],function(_e0){var _e1={};_e0.setObject("dojo.data.util.filter",_e1);_e1.patternToRegExp=function(_e2,_e3){var rxp="^";var c=null;for(var i=0;i<_e2.length;i++){c=_e2.charAt(i);switch(c){case "\\":rxp+=c;i++;rxp+=_e2.charAt(i);break;case "*":rxp+=".*";break;case "?":rxp+=".";break;case "$":case "^":case "/":case "+":case ".":case "|":case "(":case ")":case "{":case "}":case "[":case "]":rxp+="\\";default:rxp+=c;}}rxp+="$";if(_e3){return new RegExp(rxp,"mi");}else{return new RegExp(rxp,"m");}};return _e1;});},"dojo/data/util/simpleFetch":function(){define(["../../_base/lang","../../_base/kernel","./sorter"],function(_e4,_e5,_e6){var _e7={};_e4.setObject("dojo.data.util.simpleFetch",_e7);_e7.errorHandler=function(_e8,_e9){if(_e9.onError){var _ea=_e9.scope||_e5.global;_e9.onError.call(_ea,_e8,_e9);}};_e7.fetchHandler=function(_eb,_ec){var _ed=_ec.abort||null,_ee=false,_ef=_ec.start?_ec.start:0,_f0=(_ec.count&&(_ec.count!==Infinity))?(_ef+_ec.count):_eb.length;_ec.abort=function(){_ee=true;if(_ed){_ed.call(_ec);}};var _f1=_ec.scope||_e5.global;if(!_ec.store){_ec.store=this;}if(_ec.onBegin){_ec.onBegin.call(_f1,_eb.length,_ec);}if(_ec.sort){_eb.sort(_e6.createSortFunction(_ec.sort,this));}if(_ec.onItem){for(var i=_ef;(i<_eb.length)&&(i<_f0);++i){var _f2=_eb[i];if(!_ee){_ec.onItem.call(_f1,_f2,_ec);}}}if(_ec.onComplete&&!_ee){var _f3=null;if(!_ec.onItem){_f3=_eb.slice(_ef,_f0);}_ec.onComplete.call(_f1,_f3,_ec);}};_e7.fetch=function(_f4){_f4=_f4||{};if(!_f4.store){_f4.store=this;}this._fetchItems(_f4,_e4.hitch(this,"fetchHandler"),_e4.hitch(this,"errorHandler"));return _f4;};return _e7;});},"dojo/data/util/sorter":function(){define(["../../_base/lang"],function(_f5){var _f6={};_f5.setObject("dojo.data.util.sorter",_f6);_f6.basicComparator=function(a,b){var r=-1;if(a===null){a=undefined;}if(b===null){b=undefined;}if(a==b){r=0;}else{if(a>b||a==null){r=1;}}return r;};_f6.createSortFunction=function(_f7,_f8){var _f9=[];function _fa(_fb,dir,_fc,s){return function(_fd,_fe){var a=s.getValue(_fd,_fb);var b=s.getValue(_fe,_fb);return dir*_fc(a,b);};};var _ff;var map=_f8.comparatorMap;var bc=_f6.basicComparator;for(var i=0;i<_f7.length;i++){_ff=_f7[i];var attr=_ff.attribute;if(attr){var dir=(_ff.descending)?-1:1;var comp=bc;if(map){if(typeof attr!=="string"&&("toString" in attr)){attr=attr.toString();}comp=map[attr]||bc;}_f9.push(_fa(attr,dir,comp,_f8));}}return function(rowA,rowB){var i=0;while(i<_f9.length){var ret=_f9[i++](rowA,rowB);if(ret!==0){return ret;}}return 0;};};return _f6;});},"dojo/date/stamp":function(){define(["../_base/lang","../_base/array"],function(lang,_100){var _101={};lang.setObject("dojo.date.stamp",_101);_101.fromISOString=function(_102,_103){if(!_101._isoRegExp){_101._isoRegExp=/^(?:(\d{4})(?:-(\d{2})(?:-(\d{2}))?)?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(.\d+)?)?((?:[+-](\d{2}):(\d{2}))|Z)?)?$/;}var _104=_101._isoRegExp.exec(_102),_105=null;if(_104){_104.shift();if(_104[1]){_104[1]--;}if(_104[6]){_104[6]*=1000;}if(_103){_103=new Date(_103);_100.forEach(_100.map(["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],function(prop){return _103["get"+prop]();}),function(_106,_107){_104[_107]=_104[_107]||_106;});}_105=new Date(_104[0]||1970,_104[1]||0,_104[2]||1,_104[3]||0,_104[4]||0,_104[5]||0,_104[6]||0);if(_104[0]<100){_105.setFullYear(_104[0]||1970);}var _108=0,_109=_104[7]&&_104[7].charAt(0);if(_109!="Z"){_108=((_104[8]||0)*60)+(Number(_104[9])||0);if(_109!="-"){_108*=-1;}}if(_109){_108-=_105.getTimezoneOffset();}if(_108){_105.setTime(_105.getTime()+_108*60000);}}return _105;};_101.toISOString=function(_10a,_10b){var _10c=function(n){return (n<10)?"0"+n:n;};_10b=_10b||{};var _10d=[],_10e=_10b.zulu?"getUTC":"get",date="";if(_10b.selector!="time"){var year=_10a[_10e+"FullYear"]();date=["0000".substr((year+"").length)+year,_10c(_10a[_10e+"Month"]()+1),_10c(_10a[_10e+"Date"]())].join("-");}_10d.push(date);if(_10b.selector!="date"){var time=[_10c(_10a[_10e+"Hours"]()),_10c(_10a[_10e+"Minutes"]()),_10c(_10a[_10e+"Seconds"]())].join(":");var _10f=_10a[_10e+"Milliseconds"]();if(_10b.milliseconds){time+="."+(_10f<100?"0":"")+_10c(_10f);}if(_10b.zulu){time+="Z";}else{if(_10b.selector!="time"){var _110=_10a.getTimezoneOffset();var _111=Math.abs(_110);time+=(_110>0?"-":"+")+_10c(Math.floor(_111/60))+":"+_10c(_111%60);}}_10d.push(time);}return _10d.join("T");};return _101;});},"dojox/grid/EnhancedGrid":function(){define(["dojo/_base/kernel","../main","dojo/_base/declare","dojo/_base/lang","dojo/_base/array","dojo/_base/sniff","dojo/dom","dojo/dom-geometry","./DataGrid","./DataSelection","./enhanced/_PluginManager","./enhanced/plugins/_SelectionPreserver","dojo/i18n!./enhanced/nls/EnhancedGrid"],function(dojo,_112,_113,lang,_114,has,dom,_115,_116,_117,_118,_119,nls){dojo.experimental("dojox.grid.EnhancedGrid");var _11a=_113("dojox.grid.EnhancedGrid",_116,{plugins:null,pluginMgr:null,_pluginMgrClass:_118,postMixInProperties:function(){this._nls=nls;this.inherited(arguments);},postCreate:function(){this.pluginMgr=new this._pluginMgrClass(this);this.pluginMgr.preInit();this.inherited(arguments);this.pluginMgr.postInit();},plugin:function(name){return this.pluginMgr.getPlugin(name);},startup:function(){this.inherited(arguments);this.pluginMgr.startup();},createSelection:function(){this.selection=new _112.grid.enhanced.DataSelection(this);},canSort:function(_11b,_11c){return true;},doKeyEvent:function(e){try{var view=this.focus.focusView;view.content.decorateEvent(e);if(!e.cell){view.header.decorateEvent(e);}}catch(e){}this.inherited(arguments);},doApplyCellEdit:function(_11d,_11e,_11f){if(!_11f){this.invalidated[_11e]=true;return;}this.inherited(arguments);},mixin:function(_120,_121){var _122={};for(var p in _121){if(p=="_inherited"||p=="declaredClass"||p=="constructor"||_121["privates"]&&_121["privates"][p]){continue;}_122[p]=_121[p];}lang.mixin(_120,_122);},_copyAttr:function(idx,attr){if(!attr){return;}return this.inherited(arguments);},_getHeaderHeight:function(){this.inherited(arguments);return _115.getMarginBox(this.viewsHeaderNode).h;},_fetch:function(_123,_124){if(this.items){return this.inherited(arguments);}_123=_123||0;if(this.store&&!this._pending_requests[_123]){if(!this._isLoaded&&!this._isLoading){this._isLoading=true;this.showMessage(this.loadingMessage);}this._pending_requests[_123]=true;try{var req={start:_123,count:this.rowsPerPage,query:this.query,sort:this.getSortProps(),queryOptions:this.queryOptions,isRender:_124,onBegin:lang.hitch(this,"_onFetchBegin"),onComplete:lang.hitch(this,"_onFetchComplete"),onError:lang.hitch(this,"_onFetchError")};this._storeLayerFetch(req);}catch(e){this._onFetchError(e,{start:_123,count:this.rowsPerPage});}}return 0;},_storeLayerFetch:function(req){this.store.fetch(req);},getCellByField:function(_125){return _114.filter(this.layout.cells,function(cell){return cell.field==_125;})[0];},onMouseUp:function(e){},createView:function(){var view=this.inherited(arguments);if(has("mozilla")){var _126=function(_127,_128){for(var n=_127;n&&_128(n);n=n.parentNode){}return n;};var _129=function(_12a){var name=_12a.toUpperCase();return function(node){return node.tagName!=name;};};var func=view.header.getCellX;view.header.getCellX=function(e){var x=func.call(view.header,e);var n=_126(e.target,_129("th"));if(n&&n!==e.target&&dom.isDescendant(e.target,n)){x+=n.firstChild.offsetLeft;}return x;};}return view;},destroy:function(){delete this._nls;this.pluginMgr.destroy();this.inherited(arguments);}});_113("dojox.grid.enhanced.DataSelection",_117,{constructor:function(grid){if(grid.keepSelection){if(this.preserver){this.preserver.destroy();}this.preserver=new _119(this);}},_range:function(_12b,inTo){this.grid._selectingRange=true;this.inherited(arguments);this.grid._selectingRange=false;this.onChanged();},deselectAll:function(_12c){this.grid._selectingRange=true;this.inherited(arguments);this.grid._selectingRange=false;this.onChanged();}});_11a.markupFactory=function(_12d,node,ctor,_12e){return _112.grid._Grid.markupFactory(_12d,node,ctor,lang.partial(_116.cell_markupFactory,_12e));};_11a.registerPlugin=function(_12f,_130){_118.registerPlugin(_12f,_130);};return _11a;});},"dojox/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dojox;});},"dojox/grid/DataGrid":function(){define(["../main","dojo/_base/array","dojo/_base/lang","dojo/_base/json","dojo/_base/sniff","dojo/_base/declare","./_Grid","./DataSelection","dojo/_base/html","dojo/has","dojo/has!dojo-bidi?./bidi/_BidiMixin"],function(_131,_132,lang,json,has,_133,_134,_135,html){var _136=_133("dojox.grid.DataGrid",_134,{store:null,query:null,queryOptions:null,fetchText:"...",sortFields:null,updateDelay:1,items:null,_store_connects:null,_by_idty:null,_by_idx:null,_cache:null,_pages:null,_pending_requests:null,_bop:-1,_eop:-1,_requests:0,rowCount:0,_isLoaded:false,_isLoading:false,keepSelection:false,postCreate:function(){this._pages=[];this._store_connects=[];this._by_idty={};this._by_idx=[];this._cache=[];this._pending_requests={};this._setStore(this.store);this.inherited(arguments);},destroy:function(){this.selection.destroy();this.inherited(arguments);},createSelection:function(){this.selection=new _135(this);},get:function(_137,_138){if(_138&&this.field=="_item"&&!this.fields){return _138;}else{if(_138&&this.fields){var ret=[];var s=this.grid.store;_132.forEach(this.fields,function(f){ret=ret.concat(s.getValues(_138,f));});return ret;}else{if(!_138&&typeof _137==="string"){return this.inherited(arguments);}}}return (!_138?this.defaultValue:(!this.field?this.value:(this.field=="_item"?_138:this.grid.store.getValue(_138,this.field))));},_checkUpdateStatus:function(){if(this.updateDelay>0){var _139=false;if(this._endUpdateDelay){clearTimeout(this._endUpdateDelay);delete this._endUpdateDelay;_139=true;}if(!this.updating){this.beginUpdate();_139=true;}if(_139){var _13a=this;this._endUpdateDelay=setTimeout(function(){delete _13a._endUpdateDelay;_13a.endUpdate();},this.updateDelay);}}},_onSet:function(item,_13b,_13c,_13d){this._checkUpdateStatus();var idx=this.getItemIndex(item);if(idx>-1){this.updateRow(idx);}},_createItem:function(item,_13e){var idty=this._hasIdentity?this.store.getIdentity(item):json.toJson(this.query)+":idx:"+_13e+":sort:"+json.toJson(this.getSortProps());var o=this._by_idty[idty]={idty:idty,item:item};return o;},_addItem:function(item,_13f,_140){this._by_idx[_13f]=this._createItem(item,_13f);if(!_140){this.updateRow(_13f);}},_onNew:function(item,_141){this._checkUpdateStatus();var _142=this.get("rowCount");this._addingItem=true;this.updateRowCount(_142+1);this._addingItem=false;this._addItem(item,_142);this.showMessage();},_onDelete:function(item){this._checkUpdateStatus();var idx=this._getItemIndex(item,true);if(idx>=0){this._pages=[];this._bop=-1;this._eop=-1;var o=this._by_idx[idx];this._by_idx.splice(idx,1);delete this._by_idty[o.idty];this.updateRowCount(this.get("rowCount")-1);if(this.get("rowCount")===0){this.showMessage(this.noDataMessage);}}if(this.selection.isSelected(idx)){this.selection.deselect(idx);this.selection.selected.splice(idx,1);}},_onRevert:function(){this._refresh();},setStore:function(_143,_144,_145){if(this._requestsPending(0)){return;}this._setQuery(_144,_145);this._setStore(_143);this._refresh(true);},setQuery:function(_146,_147){if(this._requestsPending(0)){return;}this._setQuery(_146,_147);this._refresh(true);},setItems:function(_148){this.items=_148;this._setStore(this.store);this._refresh(true);},_setQuery:function(_149,_14a){this.query=_149;this.queryOptions=_14a||this.queryOptions;},_setStore:function(_14b){if(this.store&&this._store_connects){_132.forEach(this._store_connects,this.disconnect,this);}this.store=_14b;if(this.store){var f=this.store.getFeatures();var h=[];this._canEdit=!!f["dojo.data.api.Write"]&&!!f["dojo.data.api.Identity"];this._hasIdentity=!!f["dojo.data.api.Identity"];if(!!f["dojo.data.api.Notification"]&&!this.items){h.push(this.connect(this.store,"onSet","_onSet"));h.push(this.connect(this.store,"onNew","_onNew"));h.push(this.connect(this.store,"onDelete","_onDelete"));}if(this._canEdit){h.push(this.connect(this.store,"revert","_onRevert"));}this._store_connects=h;}},_onFetchBegin:function(size,req){if(!this.scroller){return;}if(this.rowCount!=size){if(req.isRender){this.scroller.init(size,this.keepRows,this.rowsPerPage);this.rowCount=size;this._setAutoHeightAttr(this.autoHeight,true);this._skipRowRenormalize=true;this.prerender();this._skipRowRenormalize=false;}else{this.updateRowCount(size);}}if(!size){this.views.render();this._resize();this.showMessage(this.noDataMessage);this.focus.initFocusView();}else{this.showMessage();}},_onFetchComplete:function(_14c,req){if(!this.scroller){return;}if(_14c&&_14c.length>0){_132.forEach(_14c,function(item,idx){this._addItem(item,req.start+idx,true);},this);this.updateRows(req.start,_14c.length);if(req.isRender){this.setScrollTop(0);this.postrender();}else{if(this._lastScrollTop){this.setScrollTop(this._lastScrollTop);}}if(has("ie")){html.setSelectable(this.domNode,this.selectable);}}delete this._lastScrollTop;if(!this._isLoaded){this._isLoading=false;this._isLoaded=true;}this._pending_requests[req.start]=false;},_onFetchError:function(err,req){delete this._lastScrollTop;if(!this._isLoaded){this._isLoading=false;this._isLoaded=true;this.showMessage(this.errorMessage);}this._pending_requests[req.start]=false;this.onFetchError(err,req);},onFetchError:function(err,req){},_fetch:function(_14d,_14e){_14d=_14d||0;if(this.store&&!this._pending_requests[_14d]){if(!this._isLoaded&&!this._isLoading){this._isLoading=true;this.showMessage(this.loadingMessage);}this._pending_requests[_14d]=true;try{if(this.items){var _14f=this.items;var _150=this.store;this.rowsPerPage=_14f.length;var req={start:_14d,count:this.rowsPerPage,isRender:_14e};this._onFetchBegin(_14f.length,req);var _151=0;_132.forEach(_14f,function(i){if(!_150.isItemLoaded(i)){_151++;}});if(_151===0){this._onFetchComplete(_14f,req);}else{var _152=function(item){_151--;if(_151===0){this._onFetchComplete(_14f,req);}};_132.forEach(_14f,function(i){if(!_150.isItemLoaded(i)){_150.loadItem({item:i,onItem:_152,scope:this});}},this);}}else{this.store.fetch({start:_14d,count:this.rowsPerPage,query:this.query,sort:this.getSortProps(),queryOptions:this.queryOptions,isRender:_14e,onBegin:lang.hitch(this,"_onFetchBegin"),onComplete:lang.hitch(this,"_onFetchComplete"),onError:lang.hitch(this,"_onFetchError")});}}catch(e){this._onFetchError(e,{start:_14d,count:this.rowsPerPage});}}},_clearData:function(){this.updateRowCount(0);this._by_idty={};this._by_idx=[];this._pages=[];this._bop=this._eop=-1;this._isLoaded=false;this._isLoading=false;},getItem:function(idx){var data=this._by_idx[idx];if(!data||(data&&!data.item)){this._preparePage(idx);return null;}return data.item;},getItemIndex:function(item){return this._getItemIndex(item,false);},_getItemIndex:function(item,_153){if(!_153&&!this.store.isItem(item)){return -1;}var idty=this._hasIdentity?this.store.getIdentity(item):null;for(var i=0,l=this._by_idx.length;i<l;i++){var d=this._by_idx[i];if(d&&((idty&&d.idty==idty)||(d.item===item))){return i;}}return -1;},filter:function(_154,_155){this.query=_154;if(_155){this._clearData();}this._fetch();},_getItemAttr:function(idx,attr){var item=this.getItem(idx);return (!item?this.fetchText:this.store.getValue(item,attr));},_render:function(){if(this.domNode.parentNode){this.scroller.init(this.get("rowCount"),this.keepRows,this.rowsPerPage);this.prerender();this._fetch(0,true);}},_requestsPending:function(_156){return this._pending_requests[_156];},_rowToPage:function(_157){return (this.rowsPerPage?Math.floor(_157/this.rowsPerPage):_157);},_pageToRow:function(_158){return (this.rowsPerPage?this.rowsPerPage*_158:_158);},_preparePage:function(_159){if((_159<this._bop||_159>=this._eop)&&!this._addingItem){var _15a=this._rowToPage(_159);this._needPage(_15a);this._bop=_15a*this.rowsPerPage;this._eop=this._bop+(this.rowsPerPage||this.get("rowCount"));}},_needPage:function(_15b){if(!this._pages[_15b]){this._pages[_15b]=true;this._requestPage(_15b);}},_requestPage:function(_15c){var row=this._pageToRow(_15c);var _15d=Math.min(this.rowsPerPage,this.get("rowCount")-row);if(_15d>0){this._requests++;if(!this._requestsPending(row)){setTimeout(lang.hitch(this,"_fetch",row,false),1);}}},getCellName:function(_15e){return _15e.field;},_refresh:function(_15f){this._clearData();this._fetch(0,_15f);},sort:function(){this.edit.apply();this._lastScrollTop=this.scrollTop;this._refresh();},canSort:function(){return (!this._isLoading);},getSortProps:function(){var c=this.getCell(this.getSortIndex());if(!c){if(this.sortFields){return this.sortFields;}return null;}else{var desc=c["sortDesc"];var si=!(this.sortInfo>0);if(typeof desc=="undefined"){desc=si;}else{desc=si?!desc:desc;}return [{attribute:c.field,descending:desc}];}},styleRowState:function(_160){if(this.store&&this.store.getState){var _161=this.store.getState(_160.index),c="";for(var i=0,ss=["inflight","error","inserting"],s;s=ss[i];i++){if(_161[s]){c=" dojoxGridRow-"+s;break;}}_160.customClasses+=c;}},onStyleRow:function(_162){this.styleRowState(_162);this.inherited(arguments);},canEdit:function(_163,_164){return this._canEdit;},_copyAttr:function(idx,attr){var row={};var _165={};var src=this.getItem(idx);return this.store.getValue(src,attr);},doStartEdit:function(_166,_167){if(!this._cache[_167]){this._cache[_167]=this._copyAttr(_167,_166.field);}this.onStartEdit(_166,_167);},doApplyCellEdit:function(_168,_169,_16a){this.store.fetchItemByIdentity({identity:this._by_idx[_169].idty,onItem:lang.hitch(this,function(item){var _16b=this.store.getValue(item,_16a);if(typeof _16b=="number"){_168=isNaN(_168)?_168:parseFloat(_168);}else{if(typeof _16b=="boolean"){_168=_168=="true"?true:_168=="false"?false:_168;}else{if(_16b instanceof Date){var _16c=new Date(_168);_168=isNaN(_16c.getTime())?_168:_16c;}}}this.store.setValue(item,_16a,_168);this.onApplyCellEdit(_168,_169,_16a);})});},doCancelEdit:function(_16d){var _16e=this._cache[_16d];if(_16e){this.updateRow(_16d);delete this._cache[_16d];}this.onCancelEdit.apply(this,arguments);},doApplyEdit:function(_16f,_170){var _171=this._cache[_16f];this.onApplyEdit(_16f);},removeSelectedRows:function(){if(this._canEdit){this.edit.apply();var fx=lang.hitch(this,function(_172){if(_172.length){_132.forEach(_172,this.store.deleteItem,this.store);this.selection.clear();}});if(this.allItemsSelected){this.store.fetch({query:this.query,queryOptions:this.queryOptions,onComplete:fx});}else{fx(this.selection.getSelected());}}}});_136.cell_markupFactory=function(_173,node,_174){var _175=lang.trim(html.attr(node,"field")||"");if(_175){_174.field=_175;}_174.field=_174.field||_174.name;var _176=lang.trim(html.attr(node,"fields")||"");if(_176){_174.fields=_176.split(",");}if(_173){_173(node,_174);}};_136.markupFactory=function(_177,node,ctor,_178){return _134.markupFactory(_177,node,ctor,lang.partial(_136.cell_markupFactory,_178));};return _136;});},"dojox/grid/_Grid":function(){define(["dojo/_base/kernel","../main","dojo/_base/declare","./_Events","./_Scroller","./_Layout","./_View","./_ViewManager","./_RowManager","./_FocusManager","./_EditManager","./Selection","./_RowSelector","./util","dijit/_Widget","dijit/_TemplatedMixin","dijit/CheckedMenuItem","dojo/text!./resources/_Grid.html","dojo/string","dojo/_base/array","dojo/_base/lang","dojo/_base/sniff","dojox/html/metrics","dojo/_base/html","dojo/query","dojo/dnd/common","dojo/i18n!dijit/nls/loading"],function(dojo,_179,_17a,_17b,_17c,_17d,_17e,_17f,_180,_181,_182,_183,_184,util,_185,_186,_187,_188,_189,_18a,lang,has,_18b,html,_18c){if(!dojo.isCopyKey){dojo.isCopyKey=dojo.dnd.getCopyKeyState;}var _18d=_17a("dojox.grid._Grid",[_185,_186,_17b],{templateString:_188,classTag:"dojoxGrid",rowCount:5,keepRows:75,rowsPerPage:25,autoWidth:false,initialWidth:"",autoHeight:"",rowHeight:0,autoRender:true,defaultHeight:"15em",height:"",structure:null,elasticView:-1,singleClickEdit:false,selectionMode:"extended",rowSelector:"",columnReordering:false,headerMenu:null,placeholderLabel:"GridColumns",selectable:false,_click:null,loadingMessage:"<span class='dojoxGridLoading'>${loadingState}</span>",errorMessage:"<span class='dojoxGridError'>${errorState}</span>",noDataMessage:"",escapeHTMLInData:true,formatterScope:null,editable:false,summary:"",_setSummaryAttr:"domNode",sortInfo:0,_placeholders:null,_layoutClass:_17d,buildRendering:function(){this.inherited(arguments);if(!this.domNode.getAttribute("tabIndex")){this.domNode.tabIndex="0";}this.createScroller();this.createLayout();this.createViews();this.createManagers();this.createSelection();this.connect(this.selection,"onSelected","onSelected");this.connect(this.selection,"onDeselected","onDeselected");this.connect(this.selection,"onChanged","onSelectionChanged");_18b.initOnFontResize();this.connect(_18b,"onFontResize","textSizeChanged");util.funnelEvents(this.domNode,this,"doKeyEvent",util.keyEvents);if(this.selectionMode!="none"){this.domNode.setAttribute("aria-multiselectable",this.selectionMode=="single"?"false":"true");}html.addClass(this.domNode,this.classTag);if(!this.isLeftToRight()){html.addClass(this.domNode,this.classTag+"Rtl");}if(this.rowHeight>0){html.addClass(this.viewsNode,this.classTag+"FixedRowHeight");}},postMixInProperties:function(){this.inherited(arguments);var _18e=dojo.i18n.getLocalization("dijit","loading",this.lang);this.loadingMessage=_189.substitute(this.loadingMessage,_18e);this.errorMessage=_189.substitute(this.errorMessage,_18e);if(this.srcNodeRef&&this.srcNodeRef.style.height){this.height=this.srcNodeRef.style.height;}this._setAutoHeightAttr(this.autoHeight,true);this.lastScrollTop=this.scrollTop=0;},postCreate:function(){this._placeholders=[];this._setHeaderMenuAttr(this.headerMenu);this._setStructureAttr(this.structure);this._click=[];this.inherited(arguments);if(this.domNode&&this.autoWidth&&this.initialWidth){this.domNode.style.width=this.initialWidth;}if(this.domNode&&!this.editable){html.attr(this.domNode,"aria-readonly","true");}},destroy:function(){this.domNode.onReveal=null;this.domNode.onSizeChange=null;delete this._click;if(this.scroller){this.scroller.destroy();delete this.scroller;}this.edit.destroy();delete this.edit;this.views.destroyViews();if(this.focus){this.focus.destroy();delete this.focus;}if(this.headerMenu&&this._placeholders.length){_18a.forEach(this._placeholders,function(p){p.unReplace(true);});this.headerMenu.unBindDomNode(this.viewsHeaderNode);}this.inherited(arguments);},_setAutoHeightAttr:function(ah,_18f){if(typeof ah=="string"){if(!ah||ah=="false"){ah=false;}else{if(ah=="true"){ah=true;}else{ah=window.parseInt(ah,10);}}}if(typeof ah=="number"){if(isNaN(ah)){ah=false;}if(ah<0){ah=true;}else{if(ah===0){ah=false;}}}this.autoHeight=ah;if(typeof ah=="boolean"){this._autoHeight=ah;}else{if(typeof ah=="number"){this._autoHeight=(ah>=this.get("rowCount"));}else{this._autoHeight=false;}}if(this._started&&!_18f){this.render();}},_getRowCountAttr:function(){return this.updating&&this.invalidated&&this.invalidated.rowCount!=undefined?this.invalidated.rowCount:this.rowCount;},textSizeChanged:function(){this.render();},sizeChange:function(){this.update();},createManagers:function(){this.rows=new _180(this);this.focus=new _181(this);this.edit=new _182(this);},createSelection:function(){this.selection=new _183(this);},createScroller:function(){this.scroller=new _17c();this.scroller.grid=this;this.scroller.renderRow=lang.hitch(this,"renderRow");this.scroller.removeRow=lang.hitch(this,"rowRemoved");},createLayout:function(){this.layout=new this._layoutClass(this);this.connect(this.layout,"moveColumn","onMoveColumn");},onMoveColumn:function(){this.update();},onResizeColumn:function(_190){},createViews:function(){this.views=new _17f(this);this.views.createView=lang.hitch(this,"createView");},createView:function(_191,idx){var c=lang.getObject(_191);var view=new c({grid:this,index:idx});this.viewsNode.appendChild(view.domNode);this.viewsHeaderNode.appendChild(view.headerNode);this.views.addView(view);html.attr(this.domNode,"align",this.isLeftToRight()?"left":"right");return view;},buildViews:function(){for(var i=0,vs;(vs=this.layout.structure[i]);i++){this.createView(vs.type||_179._scopeName+".grid._View",i).setStructure(vs);}this.scroller.setContentNodes(this.views.getContentNodes());},_setStructureAttr:function(_192){var s=_192;if(s&&lang.isString(s)){dojo.deprecated("dojox.grid._Grid.set('structure', 'objVar')","use dojox.grid._Grid.set('structure', objVar) instead","2.0");s=lang.getObject(s);}this.structure=s;if(!s){if(this.layout.structure){s=this.layout.structure;}else{return;}}this.views.destroyViews();this.focus.focusView=null;if(s!==this.layout.structure){this.layout.setStructure(s);}this._structureChanged();},setStructure:function(_193){dojo.deprecated("dojox.grid._Grid.setStructure(obj)","use dojox.grid._Grid.set('structure', obj) instead.","2.0");this._setStructureAttr(_193);},getColumnTogglingItems:function(){var _194,_195=[];_194=_18a.map(this.layout.cells,function(cell){if(!cell.menuItems){cell.menuItems=[];}var self=this;var item=new _187({label:cell.name,checked:!cell.hidden,_gridCell:cell,onChange:function(_196){if(self.layout.setColumnVisibility(this._gridCell.index,_196)){var _197=this._gridCell.menuItems;if(_197.length>1){_18a.forEach(_197,function(item){if(item!==this){item.setAttribute("checked",_196);}},this);}_196=_18a.filter(self.layout.cells,function(c){if(c.menuItems.length>1){_18a.forEach(c.menuItems,"item.set('disabled', false);");}else{c.menuItems[0].set("disabled",false);}return !c.hidden;});if(_196.length==1){_18a.forEach(_196[0].menuItems,"item.set('disabled', true);");}}},destroy:function(){var _198=_18a.indexOf(this._gridCell.menuItems,this);this._gridCell.menuItems.splice(_198,1);delete this._gridCell;_187.prototype.destroy.apply(this,arguments);}});cell.menuItems.push(item);if(!cell.hidden){_195.push(item);}return item;},this);if(_195.length==1){_195[0].set("disabled",true);}return _194;},_setHeaderMenuAttr:function(menu){if(this._placeholders&&this._placeholders.length){_18a.forEach(this._placeholders,function(p){p.unReplace(true);});this._placeholders=[];}if(this.headerMenu){this.headerMenu.unBindDomNode(this.viewsHeaderNode);}this.headerMenu=menu;if(!menu){return;}this.headerMenu.bindDomNode(this.viewsHeaderNode);if(this.headerMenu.getPlaceholders){this._placeholders=this.headerMenu.getPlaceholders(this.placeholderLabel);}},setHeaderMenu:function(menu){dojo.deprecated("dojox.grid._Grid.setHeaderMenu(obj)","use dojox.grid._Grid.set('headerMenu', obj) instead.","2.0");this._setHeaderMenuAttr(menu);},setupHeaderMenu:function(){if(this._placeholders&&this._placeholders.length){_18a.forEach(this._placeholders,function(p){if(p._replaced){p.unReplace(true);}p.replace(this.getColumnTogglingItems());},this);}},_fetch:function(_199){this.setScrollTop(0);},getItem:function(_19a){return null;},showMessage:function(_19b){if(_19b){this.messagesNode.innerHTML=_19b;this.messagesNode.style.display="";}else{this.messagesNode.innerHTML="";this.messagesNode.style.display="none";}},_structureChanged:function(){this.buildViews();if(this.autoRender&&this._started){this.render();}},hasLayout:function(){return this.layout.cells.length;},resize:function(_19c,_19d){this._pendingChangeSize=_19c;this._pendingResultSize=_19d;this.sizeChange();},_getPadBorder:function(){this._padBorder=this._padBorder||html._getPadBorderExtents(this.domNode);return this._padBorder;},_getHeaderHeight:function(){var vns=this.viewsHeaderNode.style,t=vns.display=="none"?0:this.views.measureHeader();vns.height=t+"px";this.views.normalizeHeaderNodeHeight();return t;},_resize:function(_19e,_19f){_19e=_19e||this._pendingChangeSize;_19f=_19f||this._pendingResultSize;delete this._pendingChangeSize;delete this._pendingResultSize;if(!this.domNode){return;}var pn=this.domNode.parentNode;if(!pn||pn.nodeType!=1||!this.hasLayout()||pn.style.visibility=="hidden"||pn.style.display=="none"){return;}var _1a0=this._getPadBorder();var hh=undefined;var h;if(this._autoHeight){this.domNode.style.height="auto";}else{if(typeof this.autoHeight=="number"){h=hh=this._getHeaderHeight();h+=(this.scroller.averageRowHeight*this.autoHeight);this.domNode.style.height=h+"px";}else{if(this.domNode.clientHeight<=_1a0.h){if(pn==document.body){this.domNode.style.height=this.defaultHeight;}else{if(this.height){this.domNode.style.height=this.height;}else{this.fitTo="parent";}}}}}if(_19f){_19e=_19f;}if(!this._autoHeight&&_19e){html.marginBox(this.domNode,_19e);this.height=this.domNode.style.height;delete this.fitTo;}else{if(this.fitTo=="parent"){h=this._parentContentBoxHeight=(this._parentContentBoxHeight>0?this._parentContentBoxHeight:html._getContentBox(pn).h);this.domNode.style.height=Math.max(0,h)+"px";}}var _1a1=_18a.some(this.views.views,function(v){return v.flexCells;});if(!this._autoHeight&&(h||html._getContentBox(this.domNode).h)===0){this.viewsHeaderNode.style.display="none";}else{this.viewsHeaderNode.style.display="block";if(!_1a1&&hh===undefined){hh=this._getHeaderHeight();}}if(_1a1){hh=undefined;}this.adaptWidth();this.adaptHeight(hh);this.postresize();},adaptWidth:function(){var _1a2=(!this.initialWidth&&this.autoWidth);var w=_1a2?0:this.domNode.clientWidth||(this.domNode.offsetWidth-this._getPadBorder().w),vw=this.views.arrange(1,w);this.views.onEach("adaptWidth");if(_1a2){this.domNode.style.width=vw+"px";}},adaptHeight:function(_1a3){var t=_1a3===undefined?this._getHeaderHeight():_1a3;var h=(this._autoHeight?-1:Math.max(this.domNode.clientHeight-t,0)||0);this.views.onEach("setSize",[0,h]);this.views.onEach("adaptHeight");if(!this._autoHeight){var _1a4=0,_1a5=0;var _1a6=_18a.filter(this.views.views,function(v){var has=v.hasHScrollbar();if(has){_1a4++;}else{_1a5++;}return (!has);});if(_1a4>0&&_1a5>0){_18a.forEach(_1a6,function(v){v.adaptHeight(true);});}}if(this.autoHeight===true||h!=-1||(typeof this.autoHeight=="number"&&this.autoHeight>=this.get("rowCount"))){this.scroller.windowHeight=h;}else{this.scroller.windowHeight=Math.max(this.domNode.clientHeight-t,0);}},startup:function(){if(this._started){return;}this.inherited(arguments);if(this.autoRender){this.render();}},render:function(){if(!this.domNode){return;}if(!this._started){return;}if(!this.hasLayout()){this.scroller.init(0,this.keepRows,this.rowsPerPage);return;}this.update=this.defaultUpdate;this._render();},_render:function(){this.scroller.init(this.get("rowCount"),this.keepRows,this.rowsPerPage);this.prerender();this.setScrollTop(0);this.postrender();},prerender:function(){this.keepRows=this._autoHeight?0:this.keepRows;this.scroller.setKeepInfo(this.keepRows);this.views.render();this._resize();},postrender:function(){this.postresize();this.focus.initFocusView();html.setSelectable(this.domNode,this.selectable);},postresize:function(){if(this._autoHeight){var size=Math.max(this.views.measureContent())+"px";this.viewsNode.style.height=size;}},renderRow:function(_1a7,_1a8){this.views.renderRow(_1a7,_1a8,this._skipRowRenormalize);},rowRemoved:function(_1a9){this.views.rowRemoved(_1a9);},invalidated:null,updating:false,beginUpdate:function(){this.invalidated=[];this.updating=true;},endUpdate:function(){this.updating=false;var i=this.invalidated,r;if(i.all){this.update();}else{if(i.rowCount!=undefined){this.updateRowCount(i.rowCount);}else{for(r in i){this.updateRow(Number(r));}}}this.invalidated=[];},defaultUpdate:function(){if(!this.domNode){return;}if(this.updating){this.invalidated.all=true;return;}this.lastScrollTop=this.scrollTop;this.prerender();this.scroller.invalidateNodes();this.setScrollTop(this.lastScrollTop);this.postrender();},update:function(){this.render();},updateRow:function(_1aa){_1aa=Number(_1aa);if(this.updating){this.invalidated[_1aa]=true;}else{this.views.updateRow(_1aa);this.scroller.rowHeightChanged(_1aa);}},updateRows:function(_1ab,_1ac){_1ab=Number(_1ab);_1ac=Number(_1ac);var i;if(this.updating){for(i=0;i<_1ac;i++){this.invalidated[i+_1ab]=true;}}else{for(i=0;i<_1ac;i++){this.views.updateRow(i+_1ab,this._skipRowRenormalize);}this.scroller.rowHeightChanged(_1ab);}},updateRowCount:function(_1ad){if(this.updating){this.invalidated.rowCount=_1ad;}else{this.rowCount=_1ad;this._setAutoHeightAttr(this.autoHeight,true);if(this.layout.cells.length){this.scroller.updateRowCount(_1ad);}if(this.layout.cells.length){this.setScrollTop(this.scrollTop);}this._resize();}},updateRowStyles:function(_1ae){this.views.updateRowStyles(_1ae);},getRowNode:function(_1af){if(this.focus.focusView&&!(this.focus.focusView instanceof _184)){return this.focus.focusView.rowNodes[_1af];}else{for(var i=0,_1b0;(_1b0=this.views.views[i]);i++){if(!(_1b0 instanceof _184)){return _1b0.rowNodes[_1af];}}}return null;},rowHeightChanged:function(_1b1){this.views.renormalizeRow(_1b1);this.scroller.rowHeightChanged(_1b1);},fastScroll:true,delayScroll:false,scrollRedrawThreshold:(has("ie")?100:50),scrollTo:function(_1b2){if(!this.fastScroll){this.setScrollTop(_1b2);return;}var _1b3=Math.abs(this.lastScrollTop-_1b2);this.lastScrollTop=_1b2;if(_1b3>this.scrollRedrawThreshold||this.delayScroll){this.delayScroll=true;this.scrollTop=_1b2;this.views.setScrollTop(_1b2);if(this._pendingScroll){window.clearTimeout(this._pendingScroll);}var _1b4=this;this._pendingScroll=window.setTimeout(function(){delete _1b4._pendingScroll;_1b4.finishScrollJob();},200);}else{this.setScrollTop(_1b2);}},finishScrollJob:function(){this.delayScroll=false;this.setScrollTop(this.scrollTop);},setScrollTop:function(_1b5){this.scroller.scroll(this.views.setScrollTop(_1b5));},scrollToRow:function(_1b6){this.setScrollTop(this.scroller.findScrollTop(_1b6)+1);},styleRowNode:function(_1b7,_1b8){if(_1b8){this.rows.styleRowNode(_1b7,_1b8);}},_mouseOut:function(e){this.rows.setOverRow(-2);},getCell:function(_1b9){return this.layout.cells[_1b9];},setCellWidth:function(_1ba,_1bb){this.getCell(_1ba).unitWidth=_1bb;},getCellName:function(_1bc){return "Cell "+_1bc.index;},canSort:function(_1bd){},sort:function(){},getSortAsc:function(_1be){_1be=_1be==undefined?this.sortInfo:_1be;return Boolean(_1be>0);},getSortIndex:function(_1bf){_1bf=_1bf==undefined?this.sortInfo:_1bf;return Math.abs(_1bf)-1;},setSortIndex:function(_1c0,_1c1){var si=_1c0+1;if(_1c1!=undefined){si*=(_1c1?1:-1);}else{if(this.getSortIndex()==_1c0){si=-this.sortInfo;}}this.setSortInfo(si);},setSortInfo:function(_1c2){if(this.canSort(_1c2)){this.sortInfo=_1c2;this.sort();this.update();}},doKeyEvent:function(e){e.dispatch="do"+e.type;this.onKeyEvent(e);},_dispatch:function(m,e){if(m in this){return this[m](e);}return false;},dispatchKeyEvent:function(e){this._dispatch(e.dispatch,e);},dispatchContentEvent:function(e){this.edit.dispatchEvent(e)||e.sourceView.dispatchContentEvent(e)||this._dispatch(e.dispatch,e);},dispatchHeaderEvent:function(e){e.sourceView.dispatchHeaderEvent(e)||this._dispatch("doheader"+e.type,e);},dokeydown:function(e){this.onKeyDown(e);},doclick:function(e){if(e.cellNode){this.onCellClick(e);}else{this.onRowClick(e);}},dodblclick:function(e){if(e.cellNode){this.onCellDblClick(e);}else{this.onRowDblClick(e);}},docontextmenu:function(e){if(e.cellNode){this.onCellContextMenu(e);}else{this.onRowContextMenu(e);}},doheaderclick:function(e){if(e.cellNode){this.onHeaderCellClick(e);}else{this.onHeaderClick(e);}},doheaderdblclick:function(e){if(e.cellNode){this.onHeaderCellDblClick(e);}else{this.onHeaderDblClick(e);}},doheadercontextmenu:function(e){if(e.cellNode){this.onHeaderCellContextMenu(e);}else{this.onHeaderContextMenu(e);}},doStartEdit:function(_1c3,_1c4){this.onStartEdit(_1c3,_1c4);},doApplyCellEdit:function(_1c5,_1c6,_1c7){this.onApplyCellEdit(_1c5,_1c6,_1c7);},doCancelEdit:function(_1c8){this.onCancelEdit(_1c8);},doApplyEdit:function(_1c9){this.onApplyEdit(_1c9);},addRow:function(){this.updateRowCount(this.get("rowCount")+1);},removeSelectedRows:function(){if(this.allItemsSelected){this.updateRowCount(0);}else{this.updateRowCount(Math.max(0,this.get("rowCount")-this.selection.getSelected().length));}this.selection.clear();}});_18d.markupFactory=function(_1ca,node,ctor,_1cb){var _1cc=function(n){var w=html.attr(n,"width")||"auto";if((w!="auto")&&(w.slice(-2)!="em")&&(w.slice(-1)!="%")){w=parseInt(w,10)+"px";}return w;};if(!_1ca.structure&&node.nodeName.toLowerCase()=="table"){_1ca.structure=_18c("> colgroup",node).map(function(cg){var sv=html.attr(cg,"span");var v={noscroll:(html.attr(cg,"noscroll")=="true")?true:false,__span:(!!sv?parseInt(sv,10):1),cells:[]};if(html.hasAttr(cg,"width")){v.width=_1cc(cg);}return v;});if(!_1ca.structure.length){_1ca.structure.push({__span:Infinity,cells:[]});}_18c("thead > tr",node).forEach(function(tr,_1cd){var _1ce=0;var _1cf=0;var _1d0;var _1d1=null;_18c("> th",tr).map(function(th){if(!_1d1){_1d0=0;_1d1=_1ca.structure[0];}else{if(_1ce>=(_1d0+_1d1.__span)){_1cf++;_1d0+=_1d1.__span;var _1d2=_1d1;_1d1=_1ca.structure[_1cf];}}var cell={name:lang.trim(html.attr(th,"name")||th.innerHTML),colSpan:parseInt(html.attr(th,"colspan")||1,10),type:lang.trim(html.attr(th,"cellType")||""),id:lang.trim(html.attr(th,"id")||"")};_1ce+=cell.colSpan;var _1d3=html.attr(th,"rowspan");if(_1d3){cell.rowSpan=_1d3;}if(html.hasAttr(th,"width")){cell.width=_1cc(th);}if(html.hasAttr(th,"relWidth")){cell.relWidth=window.parseInt(html.attr(th,"relWidth"),10);}if(html.hasAttr(th,"hidden")){cell.hidden=(html.attr(th,"hidden")=="true"||html.attr(th,"hidden")===true);}if(_1cb){_1cb(th,cell);}cell.type=cell.type?lang.getObject(cell.type):_179.grid.cells.Cell;if(cell.type&&cell.type.markupFactory){cell.type.markupFactory(th,cell);}if(!_1d1.cells[_1cd]){_1d1.cells[_1cd]=[];}_1d1.cells[_1cd].push(cell);});});}return new ctor(_1ca,node);};return _18d;});},"dojox/grid/_Events":function(){define(["dojo/keys","dojo/dom-class","dojo/_base/declare","dojo/_base/event","dojo/_base/sniff"],function(keys,_1d4,_1d5,_1d6,has){return _1d5("dojox.grid._Events",null,{cellOverClass:"dojoxGridCellOver",onKeyEvent:function(e){this.dispatchKeyEvent(e);},onContentEvent:function(e){this.dispatchContentEvent(e);},onHeaderEvent:function(e){this.dispatchHeaderEvent(e);},onStyleRow:function(_1d7){var i=_1d7;i.customClasses+=(i.odd?" dojoxGridRowOdd":"")+(i.selected?" dojoxGridRowSelected":"")+(i.over?" dojoxGridRowOver":"");this.focus.styleRow(_1d7);this.edit.styleRow(_1d7);},onKeyDown:function(e){if(e.altKey||e.metaKey){return;}var _1d8;switch(e.keyCode){case keys.ESCAPE:this.edit.cancel();break;case keys.ENTER:if(!this.edit.isEditing()){_1d8=this.focus.getHeaderIndex();if(_1d8>=0){this.setSortIndex(_1d8);break;}else{this.selection.clickSelect(this.focus.rowIndex,dojo.isCopyKey(e),e.shiftKey);}_1d6.stop(e);}if(!e.shiftKey){var _1d9=this.edit.isEditing();this.edit.apply();if(!_1d9){this.edit.setEditCell(this.focus.cell,this.focus.rowIndex);}}if(!this.edit.isEditing()){var _1da=this.focus.focusView||this.views.views[0];_1da.content.decorateEvent(e);this.onRowClick(e);_1d6.stop(e);}break;case keys.SPACE:if(!this.edit.isEditing()){_1d8=this.focus.getHeaderIndex();if(_1d8>=0){this.setSortIndex(_1d8);break;}else{this.selection.clickSelect(this.focus.rowIndex,dojo.isCopyKey(e),e.shiftKey);this.focus._focusifyCellNode(true);this.focus.setFocusCell(this.focus.cell,this.focus.rowIndex);}_1d6.stop(e);}break;case keys.TAB:this.focus[e.shiftKey?"previousKey":"nextKey"](e);break;case keys.LEFT_ARROW:case keys.RIGHT_ARROW:if(!this.edit.isEditing()){var _1db=e.keyCode;_1d6.stop(e);_1d8=this.focus.getHeaderIndex();if(_1d8>=0&&(e.shiftKey&&e.ctrlKey)){this.focus.colSizeAdjust(e,_1d8,(_1db==keys.LEFT_ARROW?-1:1)*5);}else{var _1dc=(_1db==keys.LEFT_ARROW)?1:-1;if(this.isLeftToRight()){_1dc*=-1;}this.focus.move(0,_1dc);}}break;case keys.UP_ARROW:if(!this.edit.isEditing()&&this.focus.rowIndex!==0){_1d6.stop(e);this.focus.move(-1,0);}break;case keys.DOWN_ARROW:if(!this.edit.isEditing()&&this.focus.rowIndex+1!=this.rowCount){_1d6.stop(e);this.focus.move(1,0);}break;case keys.PAGE_UP:if(!this.edit.isEditing()&&this.focus.rowIndex!==0){_1d6.stop(e);if(this.focus.rowIndex!=this.scroller.firstVisibleRow+1){this.focus.move(this.scroller.firstVisibleRow-this.focus.rowIndex,0);}else{this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex-1));this.focus.move(this.scroller.firstVisibleRow-this.scroller.lastVisibleRow+1,0);}}break;case keys.PAGE_DOWN:if(!this.edit.isEditing()&&this.focus.rowIndex+1!=this.rowCount){_1d6.stop(e);if(this.focus.rowIndex!=this.scroller.lastVisibleRow-1){this.focus.move(this.scroller.lastVisibleRow-this.focus.rowIndex-1,0);}else{this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex+1));this.focus.move(this.scroller.lastVisibleRow-this.scroller.firstVisibleRow-1,0);}}break;default:break;}},onMouseOver:function(e){e.rowIndex==-1?this.onHeaderCellMouseOver(e):this.onCellMouseOver(e);},onMouseOut:function(e){e.rowIndex==-1?this.onHeaderCellMouseOut(e):this.onCellMouseOut(e);},onMouseDown:function(e){e.rowIndex==-1?this.onHeaderCellMouseDown(e):this.onCellMouseDown(e);},onMouseOverRow:function(e){if(!this.rows.isOver(e.rowIndex)){this.rows.setOverRow(e.rowIndex);e.rowIndex==-1?this.onHeaderMouseOver(e):this.onRowMouseOver(e);}},onMouseOutRow:function(e){if(this.rows.isOver(-1)){this.onHeaderMouseOut(e);}else{if(!this.rows.isOver(-2)){this.rows.setOverRow(-2);this.onRowMouseOut(e);}}},onMouseDownRow:function(e){if(e.rowIndex!=-1){this.onRowMouseDown(e);}},onCellMouseOver:function(e){if(e.cellNode){_1d4.add(e.cellNode,this.cellOverClass);}},onCellMouseOut:function(e){if(e.cellNode){_1d4.remove(e.cellNode,this.cellOverClass);}},onCellMouseDown:function(e){},onCellClick:function(e){this._click[0]=this._click[1];this._click[1]=e;if(!this.edit.isEditCell(e.rowIndex,e.cellIndex)){this.focus.setFocusCell(e.cell,e.rowIndex);}if(this._click.length>1&&this._click[0]==null){this._click.shift();}this.onRowClick(e);},onCellDblClick:function(e){var _1dd;if(this._click.length>1&&has("ie")){_1dd=this._click[1];}else{if(this._click.length>1&&this._click[0].rowIndex!=this._click[1].rowIndex){_1dd=this._click[0];}else{_1dd=e;}}this.focus.setFocusCell(_1dd.cell,_1dd.rowIndex);this.edit.setEditCell(_1dd.cell,_1dd.rowIndex);this.onRowDblClick(e);},onCellContextMenu:function(e){this.onRowContextMenu(e);},onCellFocus:function(_1de,_1df){this.edit.cellFocus(_1de,_1df);},onRowClick:function(e){this.edit.rowClick(e);this.selection.clickSelectEvent(e);},onRowDblClick:function(e){},onRowMouseOver:function(e){},onRowMouseOut:function(e){},onRowMouseDown:function(e){},onRowContextMenu:function(e){_1d6.stop(e);},onHeaderMouseOver:function(e){},onHeaderMouseOut:function(e){},onHeaderCellMouseOver:function(e){if(e.cellNode){_1d4.add(e.cellNode,this.cellOverClass);}},onHeaderCellMouseOut:function(e){if(e.cellNode){_1d4.remove(e.cellNode,this.cellOverClass);}},onHeaderCellMouseDown:function(e){},onHeaderClick:function(e){},onHeaderCellClick:function(e){this.setSortIndex(e.cell.index);this.onHeaderClick(e);},onHeaderDblClick:function(e){},onHeaderCellDblClick:function(e){this.onHeaderDblClick(e);},onHeaderCellContextMenu:function(e){this.onHeaderContextMenu(e);},onHeaderContextMenu:function(e){if(!this.headerMenu){_1d6.stop(e);}},onStartEdit:function(_1e0,_1e1){},onApplyCellEdit:function(_1e2,_1e3,_1e4){},onCancelEdit:function(_1e5){},onApplyEdit:function(_1e6){},onCanSelect:function(_1e7){return true;},onCanDeselect:function(_1e8){return true;},onSelected:function(_1e9){this.updateRowStyles(_1e9);},onDeselected:function(_1ea){this.updateRowStyles(_1ea);},onSelectionChanged:function(){}});});},"dojox/grid/_Scroller":function(){define(["dijit/registry","dojo/_base/declare","dojo/_base/lang","./util","dojo/_base/html"],function(_1eb,_1ec,lang,util,html){var _1ed=function(_1ee){var i=0,n,p=_1ee.parentNode;while((n=p.childNodes[i++])){if(n==_1ee){return i-1;}}return -1;};var _1ef=function(_1f0){if(!_1f0){return;}dojo.forEach(_1eb.toArray(),function(w){if(w.domNode&&html.isDescendant(w.domNode,_1f0,true)){w.destroy();}});};var _1f1=function(_1f2){var node=html.byId(_1f2);return (node&&node.tagName?node.tagName.toLowerCase():"");};var _1f3=function(_1f4,_1f5){var _1f6=[];var i=0,n;while((n=_1f4.childNodes[i])){i++;if(_1f1(n)==_1f5){_1f6.push(n);}}return _1f6;};var _1f7=function(_1f8){return _1f3(_1f8,"div");};return _1ec("dojox.grid._Scroller",null,{constructor:function(_1f9){this.setContentNodes(_1f9);this.pageHeights=[];this.pageNodes=[];this.stack=[];},rowCount:0,defaultRowHeight:32,keepRows:100,contentNode:null,scrollboxNode:null,defaultPageHeight:0,keepPages:10,pageCount:0,windowHeight:0,firstVisibleRow:0,lastVisibleRow:0,averageRowHeight:0,page:0,pageTop:0,init:function(_1fa,_1fb,_1fc){switch(arguments.length){case 3:this.rowsPerPage=_1fc;case 2:this.keepRows=_1fb;case 1:this.rowCount=_1fa;default:break;}this.defaultPageHeight=(this.grid.rowHeight>0?this.grid.rowHeight:this.defaultRowHeight)*this.rowsPerPage;this.pageCount=this._getPageCount(this.rowCount,this.rowsPerPage);this.setKeepInfo(this.keepRows);this.invalidate();if(this.scrollboxNode){this.scrollboxNode.scrollTop=0;this.scroll(0);this.scrollboxNode.onscroll=lang.hitch(this,"onscroll");}},_getPageCount:function(_1fd,_1fe){return _1fd?(Math.ceil(_1fd/_1fe)||1):0;},destroy:function(){this.invalidateNodes();delete this.contentNodes;delete this.contentNode;delete this.scrollboxNode;},setKeepInfo:function(_1ff){this.keepRows=_1ff;this.keepPages=!this.keepRows?this.keepPages:Math.max(Math.ceil(this.keepRows/this.rowsPerPage),2);},setContentNodes:function(_200){this.contentNodes=_200;this.colCount=(this.contentNodes?this.contentNodes.length:0);this.pageNodes=[];for(var i=0;i<this.colCount;i++){this.pageNodes[i]=[];}},getDefaultNodes:function(){return this.pageNodes[0]||[];},invalidate:function(){this._invalidating=true;this.invalidateNodes();this.pageHeights=[];this.height=(this.pageCount?(this.pageCount-1)*this.defaultPageHeight+this.calcLastPageHeight():0);this.resize();this._invalidating=false;},updateRowCount:function(_201){this.invalidateNodes();this.rowCount=_201;var _202=this.pageCount;if(_202===0){this.height=1;}this.pageCount=this._getPageCount(this.rowCount,this.rowsPerPage);if(this.pageCount<_202){for(var i=_202-1;i>=this.pageCount;i--){this.height-=this.getPageHeight(i);delete this.pageHeights[i];}}else{if(this.pageCount>_202){this.height+=this.defaultPageHeight*(this.pageCount-_202-1)+this.calcLastPageHeight();}}this.resize();},pageExists:function(_203){return Boolean(this.getDefaultPageNode(_203));},measurePage:function(_204){if(this.grid.rowHeight){return ((_204+1)*this.rowsPerPage>this.rowCount?this.rowCount-_204*this.rowsPerPage:this.rowsPerPage)*this.grid.rowHeight;}var n=this.getDefaultPageNode(_204);return (n&&n.innerHTML)?n.offsetHeight:undefined;},positionPage:function(_205,_206){for(var i=0;i<this.colCount;i++){this.pageNodes[i][_205].style.top=_206+"px";}},repositionPages:function(_207){var _208=this.getDefaultNodes();var last=0;for(var i=0;i<this.stack.length;i++){last=Math.max(this.stack[i],last);}var n=_208[_207];var y=(n?this.getPageNodePosition(n)+this.getPageHeight(_207):0);for(var p=_207+1;p<=last;p++){n=_208[p];if(n){if(this.getPageNodePosition(n)==y){return;}this.positionPage(p,y);}y+=this.getPageHeight(p);}},installPage:function(_209){for(var i=0;i<this.colCount;i++){this.contentNodes[i].appendChild(this.pageNodes[i][_209]);}},preparePage:function(_20a,_20b){var p=(_20b?this.popPage():null);for(var i=0;i<this.colCount;i++){var _20c=this.pageNodes[i];var _20d=(p===null?this.createPageNode():this.invalidatePageNode(p,_20c));_20d.pageIndex=_20a;_20c[_20a]=_20d;}},renderPage:function(_20e){var _20f=[];var i,j;for(i=0;i<this.colCount;i++){_20f[i]=this.pageNodes[i][_20e];}for(i=0,j=_20e*this.rowsPerPage;(i<this.rowsPerPage)&&(j<this.rowCount);i++,j++){this.renderRow(j,_20f);}},removePage:function(_210){for(var i=0,j=_210*this.rowsPerPage;i<this.rowsPerPage;i++,j++){this.removeRow(j);}},destroyPage:function(_211){for(var i=0;i<this.colCount;i++){var n=this.invalidatePageNode(_211,this.pageNodes[i]);if(n){html.destroy(n);}}},pacify:function(_212){},pacifying:false,pacifyTicks:200,setPacifying:function(_213){if(this.pacifying!=_213){this.pacifying=_213;this.pacify(this.pacifying);}},startPacify:function(){this.startPacifyTicks=new Date().getTime();},doPacify:function(){var _214=(new Date().getTime()-this.startPacifyTicks)>this.pacifyTicks;this.setPacifying(true);this.startPacify();return _214;},endPacify:function(){this.setPacifying(false);},resize:function(){if(this.scrollboxNode){this.windowHeight=this.scrollboxNode.clientHeight;}for(var i=0;i<this.colCount;i++){util.setStyleHeightPx(this.contentNodes[i],Math.max(1,this.height));}var _215=(!this._invalidating);if(!_215){var ah=this.grid.get("autoHeight");if(typeof ah=="number"&&ah<=Math.min(this.rowsPerPage,this.rowCount)){_215=true;}}if(_215){this.needPage(this.page,this.pageTop);}var _216=(this.page<this.pageCount-1)?this.rowsPerPage:((this.rowCount%this.rowsPerPage)||this.rowsPerPage);var _217=this.getPageHeight(this.page);this.averageRowHeight=(_217>0&&_216>0)?(_217/_216):0;},calcLastPageHeight:function(){if(!this.pageCount){return 0;}var _218=this.pageCount-1;var _219=((this.rowCount%this.rowsPerPage)||(this.rowsPerPage))*this.defaultRowHeight;this.pageHeights[_218]=_219;return _219;},updateContentHeight:function(inDh){this.height+=inDh;this.resize();},updatePageHeight:function(_21a,_21b,_21c){if(this.pageExists(_21a)){var oh=this.getPageHeight(_21a);var h=(this.measurePage(_21a));if(h===undefined){h=oh;}this.pageHeights[_21a]=h;if(oh!=h){this.updateContentHeight(h-oh);var ah=this.grid.get("autoHeight");if((typeof ah=="number"&&ah>this.rowCount)||(ah===true&&!_21b)){if(!_21c){this.grid.sizeChange();}else{var ns=this.grid.viewsNode.style;ns.height=parseInt(ns.height)+h-oh+"px";this.repositionPages(_21a);}}else{this.repositionPages(_21a);}}return h;}return 0;},rowHeightChanged:function(_21d,_21e){this.updatePageHeight(Math.floor(_21d/this.rowsPerPage),false,_21e);},invalidateNodes:function(){while(this.stack.length){this.destroyPage(this.popPage());}},createPageNode:function(){var p=document.createElement("div");html.attr(p,"role","presentation");p.style.position="absolute";p.style[this.grid.isLeftToRight()?"left":"right"]="0";return p;},getPageHeight:function(_21f){var ph=this.pageHeights[_21f];return (ph!==undefined?ph:this.defaultPageHeight);},pushPage:function(_220){return this.stack.push(_220);},popPage:function(){return this.stack.shift();},findPage:function(_221){var i=0,h=0;for(var ph=0;i<this.pageCount;i++,h+=ph){ph=this.getPageHeight(i);if(h+ph>=_221){break;}}this.page=i;this.pageTop=h;},buildPage:function(_222,_223,_224){this.preparePage(_222,_223);this.positionPage(_222,_224);this.installPage(_222);this.renderPage(_222);this.pushPage(_222);},needPage:function(_225,_226){var h=this.getPageHeight(_225),oh=h;if(!this.pageExists(_225)){this.buildPage(_225,(!this.grid._autoHeight&&this.keepPages&&(this.stack.length>=this.keepPages)),_226);h=this.updatePageHeight(_225,true);}else{this.positionPage(_225,_226);}return h;},onscroll:function(){this.scroll(this.scrollboxNode.scrollTop);},scroll:function(_227){this.grid.scrollTop=_227;if(this.colCount){this.startPacify();this.findPage(_227);var h=this.height;var b=this.getScrollBottom(_227);for(var p=this.page,y=this.pageTop;(p<this.pageCount)&&((b<0)||(y<b));p++){y+=this.needPage(p,y);}this.firstVisibleRow=this.getFirstVisibleRow(this.page,this.pageTop,_227);this.lastVisibleRow=this.getLastVisibleRow(p-1,y,b);if(h!=this.height){this.repositionPages(p-1);}this.endPacify();}},getScrollBottom:function(_228){return (this.windowHeight>=0?_228+this.windowHeight:-1);},processNodeEvent:function(e,_229){var t=e.target;while(t&&(t!=_229)&&t.parentNode&&(t.parentNode.parentNode!=_229)){t=t.parentNode;}if(!t||!t.parentNode||(t.parentNode.parentNode!=_229)){return false;}var page=t.parentNode;e.topRowIndex=page.pageIndex*this.rowsPerPage;e.rowIndex=e.topRowIndex+_1ed(t);e.rowTarget=t;return true;},processEvent:function(e){return this.processNodeEvent(e,this.contentNode);},renderRow:function(_22a,_22b){},removeRow:function(_22c){},getDefaultPageNode:function(_22d){return this.getDefaultNodes()[_22d];},positionPageNode:function(_22e,_22f){},getPageNodePosition:function(_230){return _230.offsetTop;},invalidatePageNode:function(_231,_232){var p=_232[_231];if(p){delete _232[_231];this.removePage(_231,p);_1ef(p);p.innerHTML="";}return p;},getPageRow:function(_233){return _233*this.rowsPerPage;},getLastPageRow:function(_234){return Math.min(this.rowCount,this.getPageRow(_234+1))-1;},getFirstVisibleRow:function(_235,_236,_237){if(!this.pageExists(_235)){return 0;}var row=this.getPageRow(_235);var _238=this.getDefaultNodes();var rows=_1f7(_238[_235]);for(var i=0,l=rows.length;i<l&&_236<_237;i++,row++){_236+=rows[i].offsetHeight;}return (row?row-1:row);},getLastVisibleRow:function(_239,_23a,_23b){if(!this.pageExists(_239)){return 0;}var _23c=this.getDefaultNodes();var row=this.getLastPageRow(_239);var rows=_1f7(_23c[_239]);for(var i=rows.length-1;i>=0&&_23a>_23b;i--,row--){_23a-=rows[i].offsetHeight;}return row+1;},findTopRow:function(_23d){var _23e=this.getDefaultNodes();var rows=_1f7(_23e[this.page]);for(var i=0,l=rows.length,t=this.pageTop,h;i<l;i++){h=rows[i].offsetHeight;t+=h;if(t>=_23d){this.offset=h-(t-_23d);return i+this.page*this.rowsPerPage;}}return -1;},findScrollTop:function(_23f){var _240=Math.floor(_23f/this.rowsPerPage);var t=0;var i,l;for(i=0;i<_240;i++){t+=this.getPageHeight(i);}this.pageTop=t;this.page=_240;this.needPage(_240,this.pageTop);var _241=this.getDefaultNodes();var rows=_1f7(_241[_240]);var r=_23f-this.rowsPerPage*_240;for(i=0,l=rows.length;i<l&&i<r;i++){t+=rows[i].offsetHeight;}return t;},dummy:0});});},"dijit/registry":function(){define(["dojo/_base/array","dojo/_base/window","./main"],function(_242,win,_243){var _244={},hash={};var _245={length:0,add:function(_246){if(hash[_246.id]){throw new Error("Tried to register widget with id=="+_246.id+" but that id is already registered");}hash[_246.id]=_246;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_247){var id;do{id=_247+"_"+(_247 in _244?++_244[_247]:_244[_247]=0);}while(hash[id]);return _243._scopeName=="dijit"?id:_243._scopeName+"_"+id;},findWidgets:function(root,_248){var _249=[];function _24a(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _24b=node.getAttribute("widgetId");if(_24b){var _24c=hash[_24b];if(_24c){_249.push(_24c);}}else{if(node!==_248){_24a(node);}}}}};_24a(root);return _249;},_destroyAll:function(){_243._curFocus=null;_243._prevFocus=null;_243._activeStack=[];_242.forEach(_245.findWidgets(win.body()),function(_24d){if(!_24d._destroyed){if(_24d.destroyRecursive){_24d.destroyRecursive();}else{if(_24d.destroy){_24d.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.nodeType==1&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};_243.registry=_245;return _245;});},"dijit/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dojox/grid/util":function(){define(["../main","dojo/_base/lang","dojo/dom","dojo/_base/sniff"],function(_24e,lang,dom,has){var dgu=lang.getObject("grid.util",true,_24e);dgu.na="...";dgu.rowIndexTag="gridRowIndex";dgu.gridViewTag="gridView";dgu.fire=function(ob,ev,args){function _24f(node,_250){if(node==null){return null;}var _251=_250?"Width":"Height";if(node["scroll"+_251]>node["client"+_251]){return node;}else{return _24f(node.parentNode,_250);}};var _252,_253,_254,_255,_256;if(has("webkit")&&(ev=="focus")){_256=ob.domNode?ob.domNode:ob;_252=_24f(_256,false);if(_252){_254=_252.scrollTop;}_253=_24f(_256,true);if(_253){_255=_253.scrollLeft;}}var fn=ob&&ev&&ob[ev];var _257=fn&&(args?fn.apply(ob,args):ob[ev]());if(has("webkit")&&(ev=="focus")){if(_252){_252.scrollTop=_254;}if(_253){_253.scrollLeft=_255;}}return _257;};dgu.setStyleHeightPx=function(_258,_259){if(_259>=0){var s=_258.style;var v=_259+"px";if(_258&&s["height"]!=v){s["height"]=v;}}};dgu.mouseEvents=["mouseover","mouseout","mousedown","mouseup","click","dblclick","contextmenu"];dgu.keyEvents=["keyup","keydown","keypress"];dgu.funnelEvents=function(_25a,_25b,_25c,_25d){var evts=(_25d?_25d:dgu.mouseEvents.concat(dgu.keyEvents));for(var i=0,l=evts.length;i<l;i++){_25b.connect(_25a,"on"+evts[i],_25c);}};dgu.removeNode=function(_25e){_25e=dom.byId(_25e);_25e&&_25e.parentNode&&_25e.parentNode.removeChild(_25e);return _25e;};dgu.arrayCompare=function(inA,inB){for(var i=0,l=inA.length;i<l;i++){if(inA[i]!=inB[i]){return false;}}return (inA.length==inB.length);};dgu.arrayInsert=function(_25f,_260,_261){if(_25f.length<=_260){_25f[_260]=_261;}else{_25f.splice(_260,0,_261);}};dgu.arrayRemove=function(_262,_263){_262.splice(_263,1);};dgu.arraySwap=function(_264,inI,inJ){var _265=_264[inI];_264[inI]=_264[inJ];_264[inJ]=_265;};return dgu;});},"dojox/grid/_Layout":function(){define(["dojo/_base/kernel","../main","dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/dom-geometry","./cells","./_RowSelector"],function(dojo,_266,_267,_268,lang,_269){return _267("dojox.grid._Layout",null,{constructor:function(_26a){this.grid=_26a;},cells:[],structure:null,defaultWidth:"6em",moveColumn:function(_26b,_26c,_26d,_26e,_26f){var _270=this.structure[_26b].cells[0];var _271=this.structure[_26c].cells[0];var cell=null;var _272=0;var _273=0;for(var i=0,c;c=_270[i];i++){if(c.index==_26d){_272=i;break;}}cell=_270.splice(_272,1)[0];cell.view=this.grid.views.views[_26c];for(i=0,c=null;c=_271[i];i++){if(c.index==_26e){_273=i;break;}}if(!_26f){_273+=1;}_271.splice(_273,0,cell);var _274=this.grid.getCell(this.grid.getSortIndex());if(_274){_274._currentlySorted=this.grid.getSortAsc();}this.cells=[];_26d=0;var v;for(i=0;v=this.structure[i];i++){for(var j=0,cs;cs=v.cells[j];j++){for(var k=0;c=cs[k];k++){c.index=_26d;this.cells.push(c);if("_currentlySorted" in c){var si=_26d+1;si*=c._currentlySorted?1:-1;this.grid.sortInfo=si;delete c._currentlySorted;}_26d++;}}}_268.forEach(this.cells,function(c){var _275=c.markup[2].split(" ");var _276=parseInt(_275[1].substring(5));if(_276!=c.index){_275[1]="idx=\""+c.index+"\"";c.markup[2]=_275.join(" ");}});this.grid.setupHeaderMenu();},setColumnVisibility:function(_277,_278){var cell=this.cells[_277];if(cell.hidden==_278){cell.hidden=!_278;var v=cell.view,w=v.viewWidth;if(w&&w!="auto"){v._togglingColumn=_269.getMarginBox(cell.getHeaderNode()).w||0;}v.update();return true;}else{return false;}},addCellDef:function(_279,_27a,_27b){var self=this;var _27c=function(_27d){var w=0;if(_27d.colSpan>1){w=0;}else{w=_27d.width||self._defaultCellProps.width||self.defaultWidth;if(!isNaN(w)){w=w+"em";}}return w;};var _27e={grid:this.grid,subrow:_279,layoutIndex:_27a,index:this.cells.length};if(_27b&&_27b instanceof _266.grid.cells._Base){var _27f=lang.clone(_27b);_27e.unitWidth=_27c(_27f._props);_27f=lang.mixin(_27f,this._defaultCellProps,_27b._props,_27e);return _27f;}var _280=_27b.type||_27b.cellType||this._defaultCellProps.type||this._defaultCellProps.cellType||_266.grid.cells.Cell;if(lang.isString(_280)){_280=lang.getObject(_280);}_27e.unitWidth=_27c(_27b);return new _280(lang.mixin({},this._defaultCellProps,_27b,_27e));},addRowDef:function(_281,_282){var _283=[];var _284=0,_285=0,_286=true;for(var i=0,def,cell;(def=_282[i]);i++){cell=this.addCellDef(_281,i,def);_283.push(cell);this.cells.push(cell);if(_286&&cell.relWidth){_284+=cell.relWidth;}else{if(cell.width){var w=cell.width;if(typeof w=="string"&&w.slice(-1)=="%"){_285+=window.parseInt(w,10);}else{if(w=="auto"){_286=false;}}}}}if(_284&&_286){_268.forEach(_283,function(cell){if(cell.relWidth){cell.width=cell.unitWidth=((cell.relWidth/_284)*(100-_285))+"%";}});}return _283;},addRowsDef:function(_287){var _288=[];if(lang.isArray(_287)){if(lang.isArrayLike(_287[0])){for(var i=0,row;_287&&(row=_287[i]);i++){_288.push(this.addRowDef(i,row));}}else{_288.push(this.addRowDef(0,_287));}}return _288;},addViewDef:function(_289){this._defaultCellProps=_289.defaultCell||{};if(_289.width&&_289.width=="auto"){delete _289.width;}return lang.mixin({},_289,{cells:this.addRowsDef(_289.rows||_289.cells)});},setStructure:function(_28a){this.fieldIndex=0;this.cells=[];var s=this.structure=[];if(this.grid.rowSelector){var sel={type:_266._scopeName+".grid._RowSelector"};if(lang.isString(this.grid.rowSelector)){var _28b=this.grid.rowSelector;if(_28b=="false"){sel=null;}else{if(_28b!="true"){sel["width"]=_28b;}}}else{if(!this.grid.rowSelector){sel=null;}}if(sel){s.push(this.addViewDef(sel));}}var _28c=function(def){return ("name" in def||"field" in def||"get" in def);};var _28d=function(def){if(lang.isArray(def)){if(lang.isArray(def[0])||_28c(def[0])){return true;}}return false;};var _28e=function(def){return (def!==null&&lang.isObject(def)&&("cells" in def||"rows" in def||("type" in def&&!_28c(def))));};if(lang.isArrayLike(_28a)){var _28f=false;for(var i=0,st;(st=_28a[i]);i++){if(_28e(st)){_28f=true;break;}}if(!_28f){s.push(this.addViewDef({cells:_28a}));}else{for(i=0;(st=_28a[i]);i++){if(_28d(st)){s.push(this.addViewDef({cells:st}));}else{if(_28e(st)){s.push(this.addViewDef(st));}}}}}else{if(_28e(_28a)){s.push(this.addViewDef(_28a));}}this.cellCount=this.cells.length;this.grid.setupHeaderMenu();}});});},"dojox/grid/cells":function(){define(["../main","./cells/_base"],function(_290){return _290.grid.cells;});},"dojox/grid/cells/_base":function(){define(["dojo/_base/kernel","dojo/_base/declare","dojo/_base/lang","dojo/_base/event","dojo/_base/connect","dojo/_base/array","dojo/_base/sniff","dojo/dom","dojo/dom-attr","dojo/dom-construct","dijit/_Widget","../util"],function(dojo,_291,lang,_292,_293,_294,has,dom,_295,_296,_297,util){var _298=_291("dojox.grid._DeferredTextWidget",_297,{deferred:null,_destroyOnRemove:true,postCreate:function(){if(this.deferred){this.deferred.addBoth(lang.hitch(this,function(text){if(this.domNode){this.domNode.innerHTML=text;}}));}}});var _299=function(_29a){try{util.fire(_29a,"focus");util.fire(_29a,"select");}catch(e){}};var _29b=function(){setTimeout(lang.hitch.apply(dojo,arguments),0);};var _29c=_291("dojox.grid.cells._Base",null,{styles:"",classes:"",editable:false,alwaysEditing:false,formatter:null,defaultValue:"...",value:null,hidden:false,noresize:false,draggable:true,_valueProp:"value",_formatPending:false,constructor:function(_29d){this._props=_29d||{};lang.mixin(this,_29d);if(this.draggable===undefined){this.draggable=true;}},_defaultFormat:function(_29e,_29f){var s=this.grid.formatterScope||this;var f=this.formatter;if(f&&s&&typeof f=="string"){f=this.formatter=s[f];}var v=(_29e!=this.defaultValue&&f)?f.apply(s,_29f):_29e;if(typeof v=="undefined"){return this.defaultValue;}if(v&&v.addBoth){v=new _298({deferred:v},_296.create("span",{innerHTML:this.defaultValue}));}if(v&&v.declaredClass&&v.startup){return "<div class='dojoxGridStubNode' linkWidget='"+v.id+"' cellIdx='"+this.index+"'>"+this.defaultValue+"</div>";}return v;},format:function(_2a0,_2a1){var i=this.grid.edit.info;var d=this.get?this.get(_2a0,_2a1):(this.value||this.defaultValue);if(d&&d.replace&&this.grid.escapeHTMLInData){d=d.replace(/&/g,"&amp;").replace(/</g,"&lt;");}if(this.editable&&(this.alwaysEditing||(i.rowIndex==_2a0&&i.cell==this))){return this.formatEditing(i.value?i.value:d,_2a0);}else{return this._defaultFormat(d,[d,_2a0,this]);}},formatEditing:function(_2a2,_2a3){},getNode:function(_2a4){return this.view.getCellNode(_2a4,this.index);},getHeaderNode:function(){return this.view.getHeaderCellNode(this.index);},getEditNode:function(_2a5){return (this.getNode(_2a5)||0).firstChild||0;},canResize:function(){var uw=this.unitWidth;return uw&&(uw!=="auto");},isFlex:function(){var uw=this.unitWidth;return uw&&lang.isString(uw)&&(uw=="auto"||uw.slice(-1)=="%");},applyEdit:function(_2a6,_2a7){if(this.getNode(_2a7)){this.grid.edit.applyCellEdit(_2a6,this,_2a7);}},cancelEdit:function(_2a8){this.grid.doCancelEdit(_2a8);},_onEditBlur:function(_2a9){if(this.grid.edit.isEditCell(_2a9,this.index)){this.grid.edit.apply();}},registerOnBlur:function(_2aa,_2ab){if(this.commitOnBlur){_293.connect(_2aa,"onblur",function(e){setTimeout(lang.hitch(this,"_onEditBlur",_2ab),250);});}},needFormatNode:function(_2ac,_2ad){this._formatPending=true;_29b(this,"_formatNode",_2ac,_2ad);},cancelFormatNode:function(){this._formatPending=false;},_formatNode:function(_2ae,_2af){if(this._formatPending){this._formatPending=false;if(!has("ie")){dom.setSelectable(this.grid.domNode,true);}this.formatNode(this.getEditNode(_2af),_2ae,_2af);}},formatNode:function(_2b0,_2b1,_2b2){if(has("ie")){_29b(this,"focus",_2b2,_2b0);}else{this.focus(_2b2,_2b0);}},dispatchEvent:function(m,e){if(m in this){return this[m](e);}},getValue:function(_2b3){return this.getEditNode(_2b3)[this._valueProp];},setValue:function(_2b4,_2b5){var n=this.getEditNode(_2b4);if(n){n[this._valueProp]=_2b5;}},focus:function(_2b6,_2b7){_299(_2b7||this.getEditNode(_2b6));},save:function(_2b8){this.value=this.value||this.getValue(_2b8);},restore:function(_2b9){this.setValue(_2b9,this.value);},_finish:function(_2ba){dom.setSelectable(this.grid.domNode,false);this.cancelFormatNode();},apply:function(_2bb){this.applyEdit(this.getValue(_2bb),_2bb);this._finish(_2bb);},cancel:function(_2bc){this.cancelEdit(_2bc);this._finish(_2bc);}});_29c.markupFactory=function(node,_2bd){var _2be=lang.trim(_295.get(node,"formatter")||"");if(_2be){_2bd.formatter=lang.getObject(_2be)||_2be;}var get=lang.trim(_295.get(node,"get")||"");if(get){_2bd.get=lang.getObject(get);}var _2bf=function(attr,cell,_2c0){var _2c1=lang.trim(_295.get(node,attr)||"");if(_2c1){cell[_2c0||attr]=!(_2c1.toLowerCase()=="false");}};_2bf("sortDesc",_2bd);_2bf("editable",_2bd);_2bf("alwaysEditing",_2bd);_2bf("noresize",_2bd);_2bf("draggable",_2bd);var _2c2=lang.trim(_295.get(node,"loadingText")||_295.get(node,"defaultValue")||"");if(_2c2){_2bd.defaultValue=_2c2;}var _2c3=function(attr,cell,_2c4){var _2c5=lang.trim(_295.get(node,attr)||"")||undefined;if(_2c5){cell[_2c4||attr]=_2c5;}};_2c3("styles",_2bd);_2c3("headerStyles",_2bd);_2c3("cellStyles",_2bd);_2c3("classes",_2bd);_2c3("headerClasses",_2bd);_2c3("cellClasses",_2bd);};var Cell=_29c.Cell=_291("dojox.grid.cells.Cell",_29c,{constructor:function(){this.keyFilter=this.keyFilter;},keyFilter:null,formatEditing:function(_2c6,_2c7){this.needFormatNode(_2c6,_2c7);if(_2c6&&_2c6.replace){_2c6=_2c6.replace(/"/g,"&quot;");}return "<input class=\"dojoxGridInput\" type=\"text\" value=\""+_2c6+"\">";},formatNode:function(_2c8,_2c9,_2ca){this.inherited(arguments);this.registerOnBlur(_2c8,_2ca);},doKey:function(e){if(this.keyFilter){var key=String.fromCharCode(e.charCode);if(key.search(this.keyFilter)==-1){_292.stop(e);}}},_finish:function(_2cb){this.inherited(arguments);var n=this.getEditNode(_2cb);try{util.fire(n,"blur");}catch(e){}}});Cell.markupFactory=function(node,_2cc){_29c.markupFactory(node,_2cc);var _2cd=lang.trim(_295.get(node,"keyFilter")||"");if(_2cd){_2cc.keyFilter=new RegExp(_2cd);}};var _2ce=_29c.RowIndex=_291("dojox.grid.cells.RowIndex",Cell,{name:"Row",postscript:function(){this.editable=false;},get:function(_2cf){return _2cf+1;}});_2ce.markupFactory=function(node,_2d0){Cell.markupFactory(node,_2d0);};var _2d1=_29c.Select=_291("dojox.grid.cells.Select",Cell,{options:null,values:null,returnIndex:-1,constructor:function(_2d2){this.values=this.values||this.options;},formatEditing:function(_2d3,_2d4){this.needFormatNode(_2d3,_2d4);var h=["<select class=\"dojoxGridSelect\">"];for(var i=0,o,v;((o=this.options[i])!==undefined)&&((v=this.values[i])!==undefined);i++){v=v.replace?v.replace(/&/g,"&amp;").replace(/</g,"&lt;"):v;o=o.replace?o.replace(/&/g,"&amp;").replace(/</g,"&lt;"):o;h.push("<option",(_2d3==v?" selected":"")," value=\""+v+"\"",">",o,"</option>");}h.push("</select>");return h.join("");},_defaultFormat:function(_2d5,_2d6){var v=this.inherited(arguments);if(!this.formatter&&this.values&&this.options){var i=_294.indexOf(this.values,v);if(i>=0){v=this.options[i];}}return v;},getValue:function(_2d7){var n=this.getEditNode(_2d7);if(n){var i=n.selectedIndex,o=n.options[i];return this.returnIndex>-1?i:o.value||o.innerHTML;}}});_2d1.markupFactory=function(node,cell){Cell.markupFactory(node,cell);var _2d8=lang.trim(_295.get(node,"options")||"");if(_2d8){var o=_2d8.split(",");if(o[0]!=_2d8){cell.options=o;}}var _2d9=lang.trim(_295.get(node,"values")||"");if(_2d9){var v=_2d9.split(",");if(v[0]!=_2d9){cell.values=v;}}};var _2da=_29c.AlwaysEdit=_291("dojox.grid.cells.AlwaysEdit",Cell,{alwaysEditing:true,_formatNode:function(_2db,_2dc){this.formatNode(this.getEditNode(_2dc),_2db,_2dc);},applyStaticValue:function(_2dd){var e=this.grid.edit;e.applyCellEdit(this.getValue(_2dd),this,_2dd);e.start(this,_2dd,true);}});_2da.markupFactory=function(node,cell){Cell.markupFactory(node,cell);};var Bool=_29c.Bool=_291("dojox.grid.cells.Bool",_2da,{_valueProp:"checked",formatEditing:function(_2de,_2df){return "<input class=\"dojoxGridInput\" type=\"checkbox\""+(_2de?" checked=\"checked\"":"")+" style=\"width: auto\" />";},doclick:function(e){if(e.target.tagName=="INPUT"){this.applyStaticValue(e.rowIndex);}}});Bool.markupFactory=function(node,cell){_2da.markupFactory(node,cell);};return _29c;});},"dijit/_Widget":function(){define(["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_2e0,_2e1,_2e2,_2e3,has,_2e4,lang,_2e5,_2e6,_2e7,_2e8,_2e9,_2ea){function _2eb(){};function _2ec(_2ed){return function(obj,_2ee,_2ef,_2f0){if(obj&&typeof _2ee=="string"&&obj[_2ee]==_2eb){return obj.on(_2ee.substring(2).toLowerCase(),lang.hitch(_2ef,_2f0));}return _2ed.apply(_2e2,arguments);};};_2e0.around(_2e2,"connect",_2ec);if(_2e4.connect){_2e0.around(_2e4,"connect",_2ec);}var _2f1=_2e3("dijit._Widget",[_2e8,_2e9,_2ea],{onClick:_2eb,onDblClick:_2eb,onKeyDown:_2eb,onKeyPress:_2eb,onKeyUp:_2eb,onMouseDown:_2eb,onMouseMove:_2eb,onMouseOut:_2eb,onMouseOver:_2eb,onMouseLeave:_2eb,onMouseEnter:_2eb,onMouseUp:_2eb,constructor:function(_2f2){this._toConnect={};for(var name in _2f2){if(this[name]===_2eb){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_2f2[name];delete _2f2[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_2eb){return _2e2.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_2f3){_2e4.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_2f3);},attr:function(name,_2f4){var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_2e4.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_2e5("[widgetId]",this.containerNode).map(_2e7.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(has("dijit-legacy-requires")){_2e6(0,function(){var _2f5=["dijit/_base"];require(_2f5);});}return _2f1;});},"dijit/_WidgetBase":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","dojo/has!dojo-bidi?./_BidiMixin","./registry"],function(_2f6,_2f7,_2f8,_2f9,_2fa,_2fb,dom,_2fc,_2fd,_2fe,_2ff,_300,has,_301,lang,on,_302,_303,_304,win,_305,_306,_307){has.add("dijit-legacy-requires",!_301.isAsync);has.add("dojo-bidi",false);if(has("dijit-legacy-requires")){_302(0,function(){var _308=["dijit/_base/manager"];_2f6(_308);});}var _309={};function _30a(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _30b(attr){return function(val){_2fc[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};function _30c(a,b){return a===b||(a!==a&&b!==b);};var _30d=_2fb("dijit._WidgetBase",[_303,_305],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_30b("lang"),dir:"",_setDirAttr:_30b("dir"),"class":"",_setClassAttr:{node:"domNode",type:"class"},_setTypeAttr:null,style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){this._set("ownerDocument",val);},attributeMap:{},_blankGif:_2f9.blankGif||_2f6.toUrl("dojo/resources/blank.gif"),textDir:"",_introspect:function(){var ctor=this.constructor;if(!ctor._setterAttrs){var _30e=ctor.prototype,_30f=ctor._setterAttrs=[],_310=(ctor._onMap={});for(var name in _30e.attributeMap){_30f.push(name);}for(name in _30e){if(/^on/.test(name)){_310[name.substring(2).toLowerCase()]=name;}if(/^_set[A-Z](.*)Attr$/.test(name)){name=name.charAt(4).toLowerCase()+name.substr(5,name.length-9);if(!_30e.attributeMap||!(name in _30e.attributeMap)){_30f.push(name);}}}}},postscript:function(_311,_312){this.create(_311,_312);},create:function(_313,_314){this._introspect();this.srcNodeRef=dom.byId(_314);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&this.srcNodeRef.id&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_313){this.params=_313;lang.mixin(this,_313);}this.postMixInProperties();if(!this.id){this.id=_307.getUniqueId(this.declaredClass.replace(/\./g,"_"));if(this.params){delete this.params.id;}}this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:document);this.ownerDocumentBody=win.body(this.ownerDocument);_307.add(this);this.buildRendering();var _315;if(this.domNode){this._applyAttributes();var _316=this.srcNodeRef;if(_316&&_316.parentNode&&this.domNode!==_316){_316.parentNode.replaceChild(this.domNode,_316);_315=true;}this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(_315){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var _317={};for(var key in this.params||{}){_317[key]=this._get(key);}_2f7.forEach(this.constructor._setterAttrs,function(key){if(!(key in _317)){var val=this._get(key);if(val){this.set(key,val);}}},this);for(key in _317){this.set(key,_317[key]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");}if(this.baseClass){var _318=this.baseClass.split(" ");if(!this.isLeftToRight()){_318=_318.concat(_2f7.map(_318,function(name){return name+"Rtl";}));}_2fd.add(this.domNode,_318);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_2f7.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_319){this._beingDestroyed=true;this.destroyDescendants(_319);this.destroy(_319);},destroy:function(_31a){this._beingDestroyed=true;this.uninitialize();function _31b(w){if(w.destroyRecursive){w.destroyRecursive(_31a);}else{if(w.destroy){w.destroy(_31a);}}};_2f7.forEach(this._connects,lang.hitch(this,"disconnect"));_2f7.forEach(this._supportingWidgets,_31b);if(this.domNode){_2f7.forEach(_307.findWidgets(this.domNode,this.containerNode),_31b);}this.destroyRendering(_31a);_307.remove(this.id);this._destroyed=true;},destroyRendering:function(_31c){if(this.bgIframe){this.bgIframe.destroy(_31c);delete this.bgIframe;}if(this.domNode){if(_31c){_2fc.remove(this.domNode,"widgetId");}else{_2fe.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_31c){_2fe.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_31d){_2f7.forEach(this.getChildren(),function(_31e){if(_31e.destroyRecursive){_31e.destroyRecursive(_31d);}});},uninitialize:function(){return false;},_setStyleAttr:function(_31f){var _320=this.domNode;if(lang.isObject(_31f)){_300.set(_320,_31f);}else{if(_320.style.cssText){_320.style.cssText+="; "+_31f;}else{_320.style.cssText=_31f;}}this._set("style",_31f);},_attrToDom:function(attr,_321,_322){_322=arguments.length>=3?_322:this.attributeMap[attr];_2f7.forEach(lang.isArray(_322)?_322:[_322],function(_323){var _324=this[_323.node||_323||"domNode"];var type=_323.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_321)){_321=lang.hitch(this,_321);}var _325=_323.attribute?_323.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);if(_324.tagName){_2fc.set(_324,_325,_321);}else{_324.set(_325,_321);}break;case "innerText":_324.innerHTML="";_324.appendChild(this.ownerDocument.createTextNode(_321));break;case "textContent":_324.textContent=_321;break;case "innerHTML":_324.innerHTML=_321;break;case "class":_2fd.replace(_324,_321,this[attr]);break;case "toggleClass":_2fd.toggle(_324,_323.className||attr,_321);break;}},this);},get:function(name){var _326=this._getAttrNames(name);return this[_326.g]?this[_326.g]():this._get(name);},set:function(name,_327){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _328=this._getAttrNames(name),_329=this[_328.s];if(lang.isFunction(_329)){var _32a=_329.apply(this,Array.prototype.slice.call(arguments,1));}else{var _32b=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_32b]&&this[_32b].tagName,_32c=tag&&(_309[tag]||(_309[tag]=_30a(this[_32b]))),map=name in this.attributeMap?this.attributeMap[name]:_328.s in this?this[_328.s]:((_32c&&_328.l in _32c&&typeof _327!="function")||/^aria-|^data-|^role$/.test(name))?_32b:null;if(map!=null){this._attrToDom(name,_327,map);}this._set(name,_327);}return _32a||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_32d){var _32e=this[name];this[name]=_32d;if(this._created&&!_30c(_32e,_32d)){if(this._watchCallbacks){this._watchCallbacks(name,_32e,_32d);}this.emit("attrmodified-"+name,{detail:{prevValue:_32e,newValue:_32d}});}},_get:function(name){return this[name];},emit:function(type,_32f,_330){_32f=_32f||{};if(_32f.bubbles===undefined){_32f.bubbles=true;}if(_32f.cancelable===undefined){_32f.cancelable=true;}if(!_32f.detail){_32f.detail={};}_32f.detail.widget=this;var ret,_331=this["on"+type];if(_331){ret=_331.apply(this,_330?_330:[_32f]);}if(this._started&&!this._beingDestroyed){on.emit(this.domNode,type.toLowerCase(),_32f);}return ret;},on:function(type,func){var _332=this._onMap(type);if(_332){return _2f8.after(this,_332,func,true);}return this.own(on(this.domNode,type,func))[0];},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[typeof type=="string"&&type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_307.findWidgets(this.containerNode):[];},getParent:function(){return _307.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_333,_334){return this.own(_2fa.connect(obj,_333,this,_334))[0];},disconnect:function(_335){_335.remove();},subscribe:function(t,_336){return this.own(_304.subscribe(t,lang.hitch(this,_336)))[0];},unsubscribe:function(_337){_337.remove();},isLeftToRight:function(){return this.dir?(this.dir.toLowerCase()=="ltr"):_2ff.isBodyLtr(this.ownerDocument);},isFocusable:function(){return this.focus&&(_300.get(this.domNode,"display")!="none");},placeAt:function(_338,_339){var _33a=!_338.tagName&&_307.byId(_338);if(_33a&&_33a.addChild&&(!_339||typeof _339==="number")){_33a.addChild(this,_339);}else{var ref=_33a&&("domNode" in _33a)?(_33a.containerNode&&!/after|before|replace/.test(_339||"")?_33a.containerNode:_33a.domNode):dom.byId(_338,this.ownerDocument);_2fe.place(this.domNode,ref,_339);if(!this._started&&(this.getParent()||{})._started){this.startup();}}return this;},defer:function(fcn,_33b){var _33c=setTimeout(lang.hitch(this,function(){if(!_33c){return;}_33c=null;if(!this._destroyed){lang.hitch(this,fcn)();}}),_33b||0);return {remove:function(){if(_33c){clearTimeout(_33c);_33c=null;}return null;}};}});if(has("dojo-bidi")){_30d.extend(_306);}return _30d;});},"dojo/Stateful":function(){define(["./_base/declare","./_base/lang","./_base/array","./when"],function(_33d,lang,_33e,when){return _33d("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});},postscript:function(_33f){if(_33f){this.set(_33f);}},_get:function(name,_340){return typeof this[_340.g]==="function"?this[_340.g]():this[name];},get:function(name){return this._get(name,this._getAttrNames(name));},set:function(name,_341){if(typeof name==="object"){for(var x in name){if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){this.set(x,name[x]);}}return this;}var _342=this._getAttrNames(name),_343=this._get(name,_342),_344=this[_342.s],_345;if(typeof _344==="function"){_345=_344.apply(this,Array.prototype.slice.call(arguments,1));}else{this[name]=_341;}if(this._watchCallbacks){var self=this;when(_345,function(){self._watchCallbacks(name,_343,_341);});}return this;},_changeAttrValue:function(name,_346){var _347=this.get(name);this[name]=_346;if(this._watchCallbacks){this._watchCallbacks(name,_347,_346);}return this;},watch:function(name,_348){var _349=this._watchCallbacks;if(!_349){var self=this;_349=this._watchCallbacks=function(name,_34a,_34b,_34c){var _34d=function(_34e){if(_34e){_34e=_34e.slice();for(var i=0,l=_34e.length;i<l;i++){_34e[i].call(self,name,_34a,_34b);}}};_34d(_349["_"+name]);if(!_34c){_34d(_349["*"]);}};}if(!_348&&typeof name==="function"){_348=name;name="*";}else{name="_"+name;}var _34f=_349[name];if(typeof _34f!=="object"){_34f=_349[name]=[];}_34f.push(_348);var _350={};_350.unwatch=_350.remove=function(){var _351=_33e.indexOf(_34f,_348);if(_351>-1){_34f.splice(_351,1);}};return _350;}});});},"dijit/Destroyable":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_352,_353,_354){return _354("dijit.Destroyable",null,{destroy:function(_355){this._destroyed=true;},own:function(){var _356=["destroyRecursive","destroy","remove"];_352.forEach(arguments,function(_357){var _358;var odh=_353.before(this,"destroy",function(_359){_357[_358](_359);});var hdhs=[];function _35a(){odh.remove();_352.forEach(hdhs,function(hdh){hdh.remove();});};if(_357.then){_358="cancel";_357.then(_35a,_35a);}else{_352.forEach(_356,function(_35b){if(typeof _357[_35b]==="function"){if(!_358){_358=_35b;}hdhs.push(_353.after(_357,_35b,_35a,true));}});}},this);return arguments;}});});},"dijit/_OnDijitClickMixin":function(){define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","./a11yclick"],function(on,_35c,keys,_35d,has,_35e){var ret=_35d("dijit._OnDijitClickMixin",null,{connect:function(obj,_35f,_360){return this.inherited(arguments,[obj,_35f=="ondijitclick"?_35e:_35f,_360]);}});ret.a11yclick=_35e;return ret;});},"dijit/a11yclick":function(){define(["dojo/keys","dojo/mouse","dojo/on","dojo/touch"],function(keys,_361,on,_362){function _363(e){if((e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!/input|button|textarea/i.test(e.target.nodeName)){for(var node=e.target;node;node=node.parentNode){if(node.dojoClick){return true;}}}};var _364;on(document,"keydown",function(e){if(_363(e)){_364=e.target;e.preventDefault();}else{_364=null;}});on(document,"keyup",function(e){if(_363(e)&&e.target==_364){_364=null;on.emit(e.target,"click",{cancelable:true,bubbles:true,ctrlKey:e.ctrlKey,shiftKey:e.shiftKey,metaKey:e.metaKey,altKey:e.altKey,_origType:e.type});}});var _365=function(node,_366){node.dojoClick=true;return on(node,"click",_366);};_365.click=_365;_365.press=function(node,_367){var _368=on(node,_362.press,function(evt){if(evt.type=="mousedown"&&!_361.isLeft(evt)){return;}_367(evt);}),_369=on(node,"keydown",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_367(evt);}});return {remove:function(){_368.remove();_369.remove();}};};_365.release=function(node,_36a){var _36b=on(node,_362.release,function(evt){if(evt.type=="mouseup"&&!_361.isLeft(evt)){return;}_36a(evt);}),_36c=on(node,"keyup",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_36a(evt);}});return {remove:function(){_36b.remove();_36c.remove();}};};_365.move=_362.move;return _365;});},"dojo/touch":function(){define(["./_base/kernel","./aspect","./dom","./dom-class","./_base/lang","./on","./has","./mouse","./domReady","./_base/window"],function(dojo,_36d,dom,_36e,lang,on,has,_36f,_370,win){var ios4=has("ios")<5;var _371=has("pointer-events")||has("MSPointer"),_372=(function(){var _373={};for(var type in {down:1,move:1,up:1,cancel:1,over:1,out:1}){_373[type]=has("MSPointer")?"MSPointer"+type.charAt(0).toUpperCase()+type.slice(1):"pointer"+type;}return _373;})();var _374=has("touch-events");var _375,_376,_377=false,_378,_379,_37a,_37b,_37c,_37d;var _37e;function _37f(_380,_381,_382){if(_371&&_382){return function(node,_383){return on(node,_382,_383);};}else{if(_374){return function(node,_384){var _385=on(node,_381,function(evt){_384.call(this,evt);_37e=(new Date()).getTime();}),_386=on(node,_380,function(evt){if(!_37e||(new Date()).getTime()>_37e+1000){_384.call(this,evt);}});return {remove:function(){_385.remove();_386.remove();}};};}else{return function(node,_387){return on(node,_380,_387);};}}};function _388(node){do{if(node.dojoClick!==undefined){return node;}}while(node=node.parentNode);};function _389(e,_38a,_38b){if(_36f.isRight(e)){return;}var _38c=_388(e.target);_376=!e.target.disabled&&_38c&&_38c.dojoClick;if(_376){_377=(_376=="useTarget");_378=(_377?_38c:e.target);if(_377){e.preventDefault();}_379=e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX;_37a=e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY;_37b=(typeof _376=="object"?_376.x:(typeof _376=="number"?_376:0))||4;_37c=(typeof _376=="object"?_376.y:(typeof _376=="number"?_376:0))||4;if(!_375){_375=true;var _38d=function _38d(e){if(_377){_376=dom.isDescendant(win.doc.elementFromPoint((e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX),(e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY)),_378);}else{_376=_376&&(e.changedTouches?e.changedTouches[0].target:e.target)==_378&&Math.abs((e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX)-_379)<=_37b&&Math.abs((e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY)-_37a)<=_37c;}};win.doc.addEventListener(_38a,function(e){if(_36f.isRight(e)){return;}_38d(e);if(_377){e.preventDefault();}},true);win.doc.addEventListener(_38b,function(e){if(_36f.isRight(e)){return;}_38d(e);if(_376){_37d=(new Date()).getTime();var _38e=(_377?_378:e.target);if(_38e.tagName==="LABEL"){_38e=dom.byId(_38e.getAttribute("for"))||_38e;}var src=(e.changedTouches)?e.changedTouches[0]:e;var _38f=function _38f(type){var evt=document.createEvent("MouseEvents");evt._dojo_click=true;evt.initMouseEvent(type,true,true,e.view,e.detail,src.screenX,src.screenY,src.clientX,src.clientY,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,0,null);return evt;};var _390=_38f("mousedown");var _391=_38f("mouseup");var _392=_38f("click");setTimeout(function(){on.emit(_38e,"mousedown",_390);on.emit(_38e,"mouseup",_391);on.emit(_38e,"click",_392);_37d=(new Date()).getTime();},0);}},true);var _393=function _393(type){win.doc.addEventListener(type,function(e){var _394=e.target;if(_376&&!e._dojo_click&&(new Date()).getTime()<=_37d+1000&&!(_394.tagName=="INPUT"&&_36e.contains(_394,"dijitOffScreen"))){e.stopPropagation();e.stopImmediatePropagation&&e.stopImmediatePropagation();if(type=="click"&&(_394.tagName!="INPUT"||(_394.type=="radio"&&(_36e.contains(_394,"dijitCheckBoxInput")||_36e.contains(_394,"mblRadioButton")))||(_394.type=="checkbox"&&(_36e.contains(_394,"dijitCheckBoxInput")||_36e.contains(_394,"mblCheckBox"))))&&_394.tagName!="TEXTAREA"&&_394.tagName!="AUDIO"&&_394.tagName!="VIDEO"){e.preventDefault();}}},true);};_393("click");_393("mousedown");_393("mouseup");}}};var _395;if(has("touch")){if(_371){_370(function(){win.doc.addEventListener(_372.down,function(evt){_389(evt,_372.move,_372.up);},true);});}else{_370(function(){_395=win.body();win.doc.addEventListener("touchstart",function(evt){_37e=(new Date()).getTime();var _396=_395;_395=evt.target;on.emit(_396,"dojotouchout",{relatedTarget:_395,bubbles:true});on.emit(_395,"dojotouchover",{relatedTarget:_396,bubbles:true});_389(evt,"touchmove","touchend");},true);function _397(evt){var _398=lang.delegate(evt,{bubbles:true});if(has("ios")>=6){_398.touches=evt.touches;_398.altKey=evt.altKey;_398.changedTouches=evt.changedTouches;_398.ctrlKey=evt.ctrlKey;_398.metaKey=evt.metaKey;_398.shiftKey=evt.shiftKey;_398.targetTouches=evt.targetTouches;}return _398;};on(win.doc,"touchmove",function(evt){_37e=(new Date()).getTime();var _399=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));if(_399){if(_395!==_399){on.emit(_395,"dojotouchout",{relatedTarget:_399,bubbles:true});on.emit(_399,"dojotouchover",{relatedTarget:_395,bubbles:true});_395=_399;}if(!on.emit(_399,"dojotouchmove",_397(evt))){evt.preventDefault();}}});on(win.doc,"touchend",function(evt){_37e=(new Date()).getTime();var node=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset))||win.body();on.emit(node,"dojotouchend",_397(evt));});});}}var _39a={press:_37f("mousedown","touchstart",_372.down),move:_37f("mousemove","dojotouchmove",_372.move),release:_37f("mouseup","dojotouchend",_372.up),cancel:_37f(_36f.leave,"touchcancel",_371?_372.cancel:null),over:_37f("mouseover","dojotouchover",_372.over),out:_37f("mouseout","dojotouchout",_372.out),enter:_36f._eventHandler(_37f("mouseover","dojotouchover",_372.over)),leave:_36f._eventHandler(_37f("mouseout","dojotouchout",_372.out))};1&&(dojo.touch=_39a);return _39a;});},"dijit/_FocusMixin":function(){define(["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_39b,_39c,_39d,lang){lang.extend(_39c,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _39d("dijit._FocusMixin",null,{_focusManager:_39b});});},"dijit/focus":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/domReady","dojo/sniff","dojo/Stateful","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_39e,_39f,dom,_3a0,_3a1,_3a2,_3a3,lang,on,_3a4,has,_3a5,win,_3a6,a11y,_3a7,_3a8){var _3a9;var _3aa;var _3ab=_39f([_3a5,_3a3],{curNode:null,activeStack:[],constructor:function(){var _3ac=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_39e.before(_3a2,"empty",_3ac);_39e.before(_3a2,"destroy",_3ac);},registerIframe:function(_3ad){return this.registerWin(_3ad.contentWindow,_3ad);},registerWin:function(_3ae,_3af){var _3b0=this,body=_3ae.document&&_3ae.document.body;if(body){var _3b1=has("pointer-events")?"pointerdown":has("MSPointer")?"MSPointerDown":has("touch-events")?"mousedown, touchstart":"mousedown";var mdh=on(_3ae.document,_3b1,function(evt){if(evt&&evt.target&&evt.target.parentNode==null){return;}_3b0._onTouchNode(_3af||evt.target,"mouse");});var fih=on(body,"focusin",function(evt){if(!evt.target.tagName){return;}var tag=evt.target.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isFocusable(evt.target)){_3b0._onFocusNode(_3af||evt.target);}else{_3b0._onTouchNode(_3af||evt.target);}});var foh=on(body,"focusout",function(evt){_3b0._onBlurNode(_3af||evt.target);});return {remove:function(){mdh.remove();fih.remove();foh.remove();mdh=fih=foh=null;body=null;}};}},_onBlurNode:function(node){var now=(new Date()).getTime();if(now<_3a9+100){return;}if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);}this._clearFocusTimer=setTimeout(lang.hitch(this,function(){this.set("prevNode",this.curNode);this.set("curNode",null);}),0);if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}if(now<_3aa+100){return;}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);}),0);},_onTouchNode:function(node,by){_3aa=(new Date()).getTime();if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}if(_3a1.contains(node,"dijitPopup")){node=node.firstChild;}var _3b2=[];try{while(node){var _3b3=_3a0.get(node,"dijitPopupParent");if(_3b3){node=_3a7.byId(_3b3).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_3a6.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_3b4=id&&_3a7.byId(id);if(_3b4&&!(by=="mouse"&&_3b4.get("disabled"))){_3b2.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_3b2,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}_3a9=(new Date()).getTime();if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);delete this._clearFocusTimer;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("prevNode",this.curNode);this.set("curNode",node);},_setStack:function(_3b5,by){var _3b6=this.activeStack,_3b7=_3b6.length-1,_3b8=_3b5.length-1;if(_3b5[_3b8]==_3b6[_3b7]){return;}this.set("activeStack",_3b5);var _3b9,i;for(i=_3b7;i>=0&&_3b6[i]!=_3b5[i];i--){_3b9=_3a7.byId(_3b6[i]);if(_3b9){_3b9._hasBeenBlurred=true;_3b9.set("focused",false);if(_3b9._focusManager==this){_3b9._onBlur(by);}this.emit("widget-blur",_3b9,by);}}for(i++;i<=_3b8;i++){_3b9=_3a7.byId(_3b5[i]);if(_3b9){_3b9.set("focused",true);if(_3b9._focusManager==this){_3b9._onFocus(by);}this.emit("widget-focus",_3b9,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _3ba=new _3ab();_3a4(function(){var _3bb=_3ba.registerWin(_3a6.get(document));if(has("ie")){on(window,"unload",function(){if(_3bb){_3bb.remove();_3bb=null;}});}});_3a8.focus=function(node){_3ba.focus(node);};for(var attr in _3ba){if(!/^_/.test(attr)){_3a8.focus[attr]=typeof _3ba[attr]=="function"?lang.hitch(_3ba,attr):_3ba[attr];}}_3ba.watch(function(attr,_3bc,_3bd){_3a8.focus[attr]=_3bd;});return _3ba;});},"dojo/window":function(){define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style","./dom-construct"],function(lang,has,_3be,dom,geom,_3bf,_3c0){has.add("rtl-adjust-position-for-verticalScrollBar",function(win,doc){var body=_3be.body(doc),_3c1=_3c0.create("div",{style:{overflow:"scroll",overflowX:"visible",direction:"rtl",visibility:"hidden",position:"absolute",left:"0",top:"0",width:"64px",height:"64px"}},body,"last"),div=_3c0.create("div",{style:{overflow:"hidden",direction:"ltr"}},_3c1,"last"),ret=geom.position(div).x!=0;_3c1.removeChild(div);body.removeChild(_3c1);return ret;});has.add("position-fixed-support",function(win,doc){var body=_3be.body(doc),_3c2=_3c0.create("span",{style:{visibility:"hidden",position:"fixed",left:"1px",top:"1px"}},body,"last"),_3c3=_3c0.create("span",{style:{position:"fixed",left:"0",top:"0"}},_3c2,"last"),ret=geom.position(_3c3).x!=geom.position(_3c2).x;_3c2.removeChild(_3c3);body.removeChild(_3c2);return ret;});var _3c4={getBox:function(doc){doc=doc||_3be.doc;var _3c5=(doc.compatMode=="BackCompat")?_3be.body(doc):doc.documentElement,_3c6=geom.docScroll(doc),w,h;if(has("touch")){var _3c7=_3c4.get(doc);w=_3c7.innerWidth||_3c5.clientWidth;h=_3c7.innerHeight||_3c5.clientHeight;}else{w=_3c5.clientWidth;h=_3c5.clientHeight;}return {l:_3c6.x,t:_3c6.y,w:w,h:h};},get:function(doc){if(has("ie")&&_3c4!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;},scrollIntoView:function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_3be.doc,body=_3be.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie")||has("trident"),isWK=has("webkit");if(node==body||node==html){return;}if(!(has("mozilla")||isIE||isWK||has("opera")||has("trident")||has("edge"))&&("scrollIntoView" in node)){node.scrollIntoView(false);return;}var _3c8=doc.compatMode=="BackCompat",_3c9=Math.min(body.clientWidth||html.clientWidth,html.clientWidth||body.clientWidth),_3ca=Math.min(body.clientHeight||html.clientHeight,html.clientHeight||body.clientHeight),_3cb=(isWK||_3c8)?body:html,_3cc=pos||geom.position(node),el=node.parentNode,_3cd=function(el){return (isIE<=6||(isIE==7&&_3c8))?false:(has("position-fixed-support")&&(_3bf.get(el,"position").toLowerCase()=="fixed"));},self=this,_3ce=function(el,x,y){if(el.tagName=="BODY"||el.tagName=="HTML"){self.get(el.ownerDocument).scrollBy(x,y);}else{x&&(el.scrollLeft+=x);y&&(el.scrollTop+=y);}};if(_3cd(node)){return;}while(el){if(el==body){el=_3cb;}var _3cf=geom.position(el),_3d0=_3cd(el),rtl=_3bf.getComputedStyle(el).direction.toLowerCase()=="rtl";if(el==_3cb){_3cf.w=_3c9;_3cf.h=_3ca;if(_3cb==html&&(isIE||has("trident"))&&rtl){_3cf.x+=_3cb.offsetWidth-_3cf.w;}_3cf.x=0;_3cf.y=0;}else{var pb=geom.getPadBorderExtents(el);_3cf.w-=pb.w;_3cf.h-=pb.h;_3cf.x+=pb.l;_3cf.y+=pb.t;var _3d1=el.clientWidth,_3d2=_3cf.w-_3d1;if(_3d1>0&&_3d2>0){if(rtl&&has("rtl-adjust-position-for-verticalScrollBar")){_3cf.x+=_3d2;}_3cf.w=_3d1;}_3d1=el.clientHeight;_3d2=_3cf.h-_3d1;if(_3d1>0&&_3d2>0){_3cf.h=_3d1;}}if(_3d0){if(_3cf.y<0){_3cf.h+=_3cf.y;_3cf.y=0;}if(_3cf.x<0){_3cf.w+=_3cf.x;_3cf.x=0;}if(_3cf.y+_3cf.h>_3ca){_3cf.h=_3ca-_3cf.y;}if(_3cf.x+_3cf.w>_3c9){_3cf.w=_3c9-_3cf.x;}}var l=_3cc.x-_3cf.x,t=_3cc.y-_3cf.y,r=l+_3cc.w-_3cf.w,bot=t+_3cc.h-_3cf.h;var s,old;if(r*l>0&&(!!el.scrollLeft||el==_3cb||el.scrollWidth>el.offsetHeight)){s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_3c8)||has("trident")>=5)){s=-s;}old=el.scrollLeft;_3ce(el,s,0);s=el.scrollLeft-old;_3cc.x-=s;}if(bot*t>0&&(!!el.scrollTop||el==_3cb||el.scrollHeight>el.offsetHeight)){s=Math.ceil(Math[t<0?"max":"min"](t,bot));old=el.scrollTop;_3ce(el,0,s);s=el.scrollTop-old;_3cc.y-=s;}el=(el!=_3cb)&&!_3d0&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}}};1&&lang.setObject("dojo.window",_3c4);return _3c4;});},"dijit/a11y":function(){define(["dojo/_base/array","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/sniff","./main"],function(_3d3,dom,_3d4,_3d5,lang,has,_3d6){var _3d7;var a11y={_isElementShown:function(elem){var s=_3d5.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_3d4.get(elem,"type")!="hidden");},hasDefaultTabStop:function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _3d4.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _3d8=elem.contentDocument;if("designMode" in _3d8&&_3d8.designMode=="on"){return true;}body=_3d8.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}},effectiveTabIndex:function(elem){if(_3d4.get(elem,"disabled")){return _3d7;}else{if(_3d4.has(elem,"tabIndex")){return +_3d4.get(elem,"tabIndex");}else{return a11y.hasDefaultTabStop(elem)?0:_3d7;}}},isTabNavigable:function(elem){return a11y.effectiveTabIndex(elem)>=0;},isFocusable:function(elem){return a11y.effectiveTabIndex(elem)>=-1;},_getTabNavigable:function(root){var _3d9,last,_3da,_3db,_3dc,_3dd,_3de={};function _3df(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _3e0=a11y._isElementShown,_3e1=a11y.effectiveTabIndex;var _3e2=function(_3e3){for(var _3e4=_3e3.firstChild;_3e4;_3e4=_3e4.nextSibling){if(_3e4.nodeType!=1||(has("ie")<=9&&_3e4.scopeName!=="HTML")||!_3e0(_3e4)){continue;}var _3e5=_3e1(_3e4);if(_3e5>=0){if(_3e5==0){if(!_3d9){_3d9=_3e4;}last=_3e4;}else{if(_3e5>0){if(!_3da||_3e5<_3db){_3db=_3e5;_3da=_3e4;}if(!_3dc||_3e5>=_3dd){_3dd=_3e5;_3dc=_3e4;}}}var rn=_3df(_3e4);if(_3d4.get(_3e4,"checked")&&rn){_3de[rn]=_3e4;}}if(_3e4.nodeName.toUpperCase()!="SELECT"){_3e2(_3e4);}}};if(_3e0(root)){_3e2(root);}function rs(node){return _3de[_3df(node)]||node;};return {first:rs(_3d9),last:rs(last),lowest:rs(_3da),highest:rs(_3dc)};},getFirstInTabbingOrder:function(root,doc){var _3e6=a11y._getTabNavigable(dom.byId(root,doc));return _3e6.lowest?_3e6.lowest:_3e6.first;},getLastInTabbingOrder:function(root,doc){var _3e7=a11y._getTabNavigable(dom.byId(root,doc));return _3e7.last?_3e7.last:_3e7.highest;}};1&&lang.mixin(_3d6,a11y);return a11y;});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./domReady","./sniff","./_base/window"],function(_3e8,lang,_3e9,has,_3ea){var html=_3ea.doc.documentElement,ie=has("ie"),_3eb=has("trident"),_3ec=has("opera"),maj=Math.floor,ff=has("ff"),_3ed=_3e8.boxModel.replace(/-/,""),_3ee={"dj_quirks":has("quirks"),"dj_opera":_3ec,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_edge":has("edge"),"dj_gecko":has("mozilla"),"dj_ios":has("ios"),"dj_android":has("android")};if(ie){_3ee["dj_ie"]=true;_3ee["dj_ie"+maj(ie)]=true;_3ee["dj_iequirks"]=has("quirks");}if(_3eb){_3ee["dj_trident"]=true;_3ee["dj_trident"+maj(_3eb)]=true;}if(ff){_3ee["dj_ff"+maj(ff)]=true;}_3ee["dj_"+_3ed]=true;var _3ef="";for(var clz in _3ee){if(_3ee[clz]){_3ef+=clz+" ";}}html.className=lang.trim(html.className+" "+_3ef);_3e9(function(){if(!_3e8.isBodyLtr()){var _3f0="dj_rtl dijitRtl "+_3ef.replace(/ /g,"-rtl ");html.className=lang.trim(html.className+" "+_3f0+"dj_rtl dijitRtl "+_3ef.replace(/ /g,"-rtl "));}});return has;});},"dijit/hccss":function(){define(["dojo/dom-class","dojo/hccss","dojo/domReady","dojo/_base/window"],function(_3f1,has,_3f2,win){_3f2(function(){if(has("highcontrast")){_3f1.add(win.body(),"dijit_a11y");}});return has;});},"dojo/hccss":function(){define(["require","./_base/config","./dom-class","./dom-style","./has","./domReady","./_base/window"],function(_3f3,_3f4,_3f5,_3f6,has,_3f7,win){has.add("highcontrast",function(){var div=win.doc.createElement("div");try{div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url(\""+(_3f4.blankGif||_3f3.toUrl("./resources/blank.gif"))+"\");";win.body().appendChild(div);var cs=_3f6.getComputedStyle(div),_3f8=cs.backgroundImage;return cs.borderTopColor==cs.borderRightColor||(_3f8&&(_3f8=="none"||_3f8=="url(invalid-url:)"));}catch(e){console.warn("hccss: exception detecting high-contrast mode, document is likely hidden: "+e.toString());return false;}finally{if(has("ie")<=8){div.outerHTML="";}else{win.body().removeChild(div);}}});_3f7(function(){if(has("highcontrast")){_3f5.add(win.body(),"dj_a11y");}});return has;});},"dojox/grid/_RowSelector":function(){define(["dojo/_base/declare","./_View"],function(_3f9,_3fa){return _3f9("dojox.grid._RowSelector",_3fa,{defaultWidth:"2em",noscroll:true,padBorderWidth:2,buildRendering:function(){this.inherited("buildRendering",arguments);this.scrollboxNode.style.overflow="hidden";this.headerNode.style.visibility="hidden";},getWidth:function(){return this.viewWidth||this.defaultWidth;},buildRowContent:function(_3fb,_3fc){var w=this.contentWidth||0;_3fc.innerHTML="<table class=\"dojoxGridRowbarTable\" style=\"width:"+w+"px;height:1px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"><tr><td class=\"dojoxGridRowbarInner\">&nbsp;</td></tr></table>";},renderHeader:function(){},updateRow:function(){},resize:function(){this.adaptHeight();},adaptWidth:function(){if(!("contentWidth" in this)&&this.contentNode&&this.contentNode.offsetWidth>0){this.contentWidth=this.contentNode.offsetWidth-this.padBorderWidth;}},doStyleRowNode:function(_3fd,_3fe){var n=["dojoxGridRowbar dojoxGridNonNormalizedCell"];if(this.grid.rows.isOver(_3fd)){n.push("dojoxGridRowbarOver");}if(this.grid.selection.isSelected(_3fd)){n.push("dojoxGridRowbarSelected");}_3fe.className=n.join(" ");},domouseover:function(e){this.grid.onMouseOverRow(e);},domouseout:function(e){if(!this.isIntraRowEvent(e)){this.grid.onMouseOutRow(e);}}});});},"dojox/grid/_View":function(){define(["dojo","dijit/registry","../main","dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/_base/connect","dojo/_base/sniff","dojo/query","dojo/_base/window","dojo/text!./resources/View.html","dojo/dnd/Source","dijit/_Widget","dijit/_TemplatedMixin","dojox/html/metrics","./util","dojo/_base/html","./_Builder","dojo/dnd/Avatar","dojo/dnd/Manager"],function(dojo,_3ff,_400,_401,_402,lang,_403,has,_404,win,_405,_406,_407,_408,_409,util,html,_40a,_40b,_40c){var _40d=function(_40e,_40f){return _40e.style.cssText==undefined?_40e.getAttribute("style"):_40e.style.cssText;};var _410=_401("dojox.grid._View",[_407,_408],{defaultWidth:"18em",viewWidth:"",templateString:_405,classTag:"dojoxGrid",marginBottom:0,rowPad:2,_togglingColumn:-1,_headerBuilderClass:_40a._HeaderBuilder,_contentBuilderClass:_40a._ContentBuilder,postMixInProperties:function(){this.rowNodes={};},postCreate:function(){this.connect(this.scrollboxNode,"onscroll","doscroll");util.funnelEvents(this.contentNode,this,"doContentEvent",["mouseover","mouseout","click","dblclick","contextmenu","mousedown"]);util.funnelEvents(this.headerNode,this,"doHeaderEvent",["dblclick","mouseover","mouseout","mousemove","mousedown","click","contextmenu"]);this.content=new this._contentBuilderClass(this);this.header=new this._headerBuilderClass(this);if(!this.grid.isLeftToRight()){this.headerNodeContainer.style.width="";}},destroy:function(){html.destroy(this.headerNode);delete this.headerNode;for(var i in this.rowNodes){this._cleanupRowWidgets(this.rowNodes[i]);html.destroy(this.rowNodes[i]);}this.rowNodes={};if(this.source){this.source.destroy();}this.inherited(arguments);},focus:function(){if(has("ie")||has("webkit")||has("opera")){this.hiddenFocusNode.focus();}else{this.scrollboxNode.focus();}},setStructure:function(_411){var vs=(this.structure=_411);if(vs.width&&!isNaN(vs.width)){this.viewWidth=vs.width+"em";}else{this.viewWidth=vs.width||(vs.noscroll?"auto":this.viewWidth);}this._onBeforeRow=vs.onBeforeRow||function(){};this._onAfterRow=vs.onAfterRow||function(){};this.noscroll=vs.noscroll;if(this.noscroll){this.scrollboxNode.style.overflow="hidden";}this.simpleStructure=Boolean(vs.cells.length==1);this.testFlexCells();this.updateStructure();},_cleanupRowWidgets:function(_412){if(_412){_402.forEach(_404("[widgetId]",_412).map(_3ff.byNode),function(w){if(w._destroyOnRemove){w.destroy();delete w;}else{if(w.domNode&&w.domNode.parentNode){w.domNode.parentNode.removeChild(w.domNode);}}});}},onBeforeRow:function(_413,_414){this._onBeforeRow(_413,_414);if(_413>=0){this._cleanupRowWidgets(this.getRowNode(_413));}},onAfterRow:function(_415,_416,_417){this._onAfterRow(_415,_416,_417);var g=this.grid;_402.forEach(_404(".dojoxGridStubNode",_417),function(n){if(n&&n.parentNode){var lw=n.getAttribute("linkWidget");var _418=window.parseInt(html.attr(n,"cellIdx"),10);var _419=g.getCell(_418);var w=_3ff.byId(lw);if(w){n.parentNode.replaceChild(w.domNode,n);if(!w._started){w.startup();}dojo.destroy(n);}else{n.innerHTML="";}}},this);},testFlexCells:function(){this.flexCells=false;for(var j=0,row;(row=this.structure.cells[j]);j++){for(var i=0,cell;(cell=row[i]);i++){cell.view=this;this.flexCells=this.flexCells||cell.isFlex();}}return this.flexCells;},updateStructure:function(){this.header.update();this.content.update();},getScrollbarWidth:function(){var _41a=this.hasVScrollbar();var _41b=html.style(this.scrollboxNode,"overflow");if(this.noscroll||!_41b||_41b=="hidden"){_41a=false;}else{if(_41b=="scroll"){_41a=true;}}return (_41a?_409.getScrollbar().w:0);},getColumnsWidth:function(){var h=this.headerContentNode;return h&&h.firstChild?(h.firstChild.offsetWidth||html.style(h.firstChild,"width")):0;},setColumnsWidth:function(_41c){this.headerContentNode.firstChild.style.width=_41c+"px";if(this.viewWidth){this.viewWidth=_41c+"px";}},getWidth:function(){return this.viewWidth||(this.getColumnsWidth()+this.getScrollbarWidth())+"px";},getContentWidth:function(){return Math.max(0,html._getContentBox(this.domNode).w-this.getScrollbarWidth())+"px";},render:function(){this.scrollboxNode.style.height="";this.renderHeader();if(this._togglingColumn>=0){this.setColumnsWidth(this.getColumnsWidth()-this._togglingColumn);this._togglingColumn=-1;}var _41d=this.grid.layout.cells;var _41e=lang.hitch(this,function(node,_41f){!this.grid.isLeftToRight()&&(_41f=!_41f);var inc=_41f?-1:1;var idx=this.header.getCellNodeIndex(node)+inc;var cell=_41d[idx];while(cell&&cell.getHeaderNode()&&cell.getHeaderNode().style.display=="none"){idx+=inc;cell=_41d[idx];}if(cell){return cell.getHeaderNode();}return null;});if(this.grid.columnReordering&&this.simpleStructure){if(this.source){this.source.destroy();}var _420="dojoxGrid_bottomMarker";var _421="dojoxGrid_topMarker";if(this.bottomMarker){html.destroy(this.bottomMarker);}this.bottomMarker=html.byId(_420);if(this.topMarker){html.destroy(this.topMarker);}this.topMarker=html.byId(_421);if(!this.bottomMarker){this.bottomMarker=html.create("div",{"id":_420,"class":"dojoxGridColPlaceBottom"},win.body());this._hide(this.bottomMarker);this.topMarker=html.create("div",{"id":_421,"class":"dojoxGridColPlaceTop"},win.body());this._hide(this.topMarker);}this.arrowDim=html.contentBox(this.bottomMarker);var _422=html.contentBox(this.headerContentNode.firstChild.rows[0]).h;this.source=new _406(this.headerContentNode.firstChild.rows[0],{horizontal:true,accept:["gridColumn_"+this.grid.id],viewIndex:this.index,generateText:false,onMouseDown:lang.hitch(this,function(e){this.header.decorateEvent(e);if((this.header.overRightResizeArea(e)||this.header.overLeftResizeArea(e))&&this.header.canResize(e)&&!this.header.moveable){this.header.beginColumnResize(e);}else{if(this.grid.headerMenu){this.grid.headerMenu.onCancel(true);}if(e.button===(has("ie")<9?1:0)){_406.prototype.onMouseDown.call(this.source,e);}}}),onMouseOver:lang.hitch(this,function(e){var src=this.source;if(src._getChildByEvent(e)){_406.prototype.onMouseOver.apply(src,arguments);}}),_markTargetAnchor:lang.hitch(this,function(_423){var src=this.source;if(src.current==src.targetAnchor&&src.before==_423){return;}if(src.targetAnchor&&_41e(src.targetAnchor,src.before)){src._removeItemClass(_41e(src.targetAnchor,src.before),src.before?"After":"Before");}_406.prototype._markTargetAnchor.call(src,_423);var _424=_423?src.targetAnchor:_41e(src.targetAnchor,src.before);var _425=0;if(!_424){_424=src.targetAnchor;_425=html.contentBox(_424).w+this.arrowDim.w/2+2;}var pos=html.position(_424,true);var left=Math.floor(pos.x-this.arrowDim.w/2+_425);html.style(this.bottomMarker,"visibility","visible");html.style(this.topMarker,"visibility","visible");html.style(this.bottomMarker,{"left":left+"px","top":(_422+pos.y)+"px"});html.style(this.topMarker,{"left":left+"px","top":(pos.y-this.arrowDim.h)+"px"});if(src.targetAnchor&&_41e(src.targetAnchor,src.before)){src._addItemClass(_41e(src.targetAnchor,src.before),src.before?"After":"Before");}}),_unmarkTargetAnchor:lang.hitch(this,function(){var src=this.source;if(!src.targetAnchor){return;}if(src.targetAnchor&&_41e(src.targetAnchor,src.before)){src._removeItemClass(_41e(src.targetAnchor,src.before),src.before?"After":"Before");}this._hide(this.bottomMarker);this._hide(this.topMarker);_406.prototype._unmarkTargetAnchor.call(src);}),destroy:lang.hitch(this,function(){_403.disconnect(this._source_conn);_403.unsubscribe(this._source_sub);_406.prototype.destroy.call(this.source);if(this.bottomMarker){html.destroy(this.bottomMarker);delete this.bottomMarker;}if(this.topMarker){html.destroy(this.topMarker);delete this.topMarker;}}),onDndCancel:lang.hitch(this,function(){_406.prototype.onDndCancel.call(this.source);this._hide(this.bottomMarker);this._hide(this.topMarker);})});this._source_conn=_403.connect(this.source,"onDndDrop",this,"_onDndDrop");this._source_sub=_403.subscribe("/dnd/drop/before",this,"_onDndDropBefore");this.source.startup();}},_hide:function(node){html.style(node,{top:"-10000px","visibility":"hidden"});},_onDndDropBefore:function(_426,_427,copy){if(_40c.manager().target!==this.source){return;}this.source._targetNode=this.source.targetAnchor;this.source._beforeTarget=this.source.before;var _428=this.grid.views.views;var _429=_428[_426.viewIndex];var _42a=_428[this.index];if(_42a!=_429){_429.convertColPctToFixed();_42a.convertColPctToFixed();}},_onDndDrop:function(_42b,_42c,copy){if(_40c.manager().target!==this.source){if(_40c.manager().source===this.source){this._removingColumn=true;}return;}this._hide(this.bottomMarker);this._hide(this.topMarker);var _42d=function(n){return n?html.attr(n,"idx"):null;};var w=html.marginBox(_42c[0]).w;if(_42b.viewIndex!==this.index){var _42e=this.grid.views.views;var _42f=_42e[_42b.viewIndex];var _430=_42e[this.index];if(_42f.viewWidth&&_42f.viewWidth!="auto"){_42f.setColumnsWidth(_42f.getColumnsWidth()-w);}if(_430.viewWidth&&_430.viewWidth!="auto"){_430.setColumnsWidth(_430.getColumnsWidth());}}var stn=this.source._targetNode;var stb=this.source._beforeTarget;!this.grid.isLeftToRight()&&(stb=!stb);var _431=this.grid.layout;var idx=this.index;delete this.source._targetNode;delete this.source._beforeTarget;_431.moveColumn(_42b.viewIndex,idx,_42d(_42c[0]),_42d(stn),stb);},renderHeader:function(){this.headerContentNode.innerHTML=this.header.generateHtml(this._getHeaderContent);if(this.flexCells){this.contentWidth=this.getContentWidth();this.headerContentNode.firstChild.style.width=this.contentWidth;}util.fire(this,"onAfterRow",[-1,this.structure.cells,this.headerContentNode]);},_getHeaderContent:function(_432){var n=_432.name||_432.grid.getCellName(_432);if(/^\s+$/.test(n)){n="&nbsp;";}var ret=["<div class=\"dojoxGridSortNode"];if(_432.index!=_432.grid.getSortIndex()){ret.push("\">");}else{ret=ret.concat([" ",_432.grid.sortInfo>0?"dojoxGridSortUp":"dojoxGridSortDown","\"><div class=\"dojoxGridArrowButtonChar\">",_432.grid.sortInfo>0?"&#9650;":"&#9660;","</div><div class=\"dojoxGridArrowButtonNode\" role=\"presentation\"></div>","<div class=\"dojoxGridColCaption\">"]);}ret=ret.concat([n,"</div></div>"]);return ret.join("");},resize:function(){this.adaptHeight();this.adaptWidth();},hasHScrollbar:function(_433){var _434=this._hasHScroll||false;if(this._hasHScroll==undefined||_433){if(this.noscroll){this._hasHScroll=false;}else{var _435=html.style(this.scrollboxNode,"overflow");if(_435=="hidden"){this._hasHScroll=false;}else{if(_435=="scroll"){this._hasHScroll=true;}else{this._hasHScroll=(this.scrollboxNode.offsetWidth-this.getScrollbarWidth()<this.contentNode.offsetWidth);}}}}if(_434!==this._hasHScroll){this.grid.update();}return this._hasHScroll;},hasVScrollbar:function(_436){var _437=this._hasVScroll||false;if(this._hasVScroll==undefined||_436){if(this.noscroll){this._hasVScroll=false;}else{var _438=html.style(this.scrollboxNode,"overflow");if(_438=="hidden"){this._hasVScroll=false;}else{if(_438=="scroll"){this._hasVScroll=true;}else{this._hasVScroll=(this.scrollboxNode.scrollHeight>this.scrollboxNode.clientHeight);}}}}if(_437!==this._hasVScroll){this.grid.update();}return this._hasVScroll;},convertColPctToFixed:function(){var _439=false;this.grid.initialWidth="";var _43a=_404("th",this.headerContentNode);var _43b=_402.map(_43a,function(c,vIdx){var w=c.style.width;html.attr(c,"vIdx",vIdx);if(w&&w.slice(-1)=="%"){_439=true;}else{if(w&&w.slice(-2)=="px"){return window.parseInt(w,10);}}return html.contentBox(c).w;});if(_439){_402.forEach(this.grid.layout.cells,function(cell,idx){if(cell.view==this){var _43c=cell.view.getHeaderCellNode(cell.index);if(_43c&&html.hasAttr(_43c,"vIdx")){var vIdx=window.parseInt(html.attr(_43c,"vIdx"));this.setColWidth(idx,_43b[vIdx]);html.removeAttr(_43c,"vIdx");}}},this);return true;}return false;},adaptHeight:function(_43d){if(!this.grid._autoHeight){var h=(this.domNode.style.height&&parseInt(this.domNode.style.height.replace(/px/,""),10))||this.domNode.clientHeight;var self=this;var _43e=function(){var v;for(var i=0;i<self.grid.views.views.length;++i){v=self.grid.views.views[i];if(v!==self&&v.hasHScrollbar()){return true;}}return false;};if(_43d||(this.noscroll&&_43e())){h-=_409.getScrollbar().h;}util.setStyleHeightPx(this.scrollboxNode,h);}this.hasVScrollbar(true);},adaptWidth:function(){if(this.flexCells){this.contentWidth=this.getContentWidth();this.headerContentNode.firstChild.style.width=this.contentWidth;}var w=this.scrollboxNode.offsetWidth-this.getScrollbarWidth();if(!this._removingColumn){w=Math.max(w,this.getColumnsWidth())+"px";}else{w=Math.min(w,this.getColumnsWidth())+"px";this._removingColumn=false;}var cn=this.contentNode;cn.style.width=w;this.hasHScrollbar(true);},setSize:function(w,h){var ds=this.domNode.style;var hs=this.headerNode.style;if(w){ds.width=w;hs.width=w;}ds.height=(h>=0?h+"px":"");},renderRow:function(_43f){var _440=this.createRowNode(_43f);this.buildRow(_43f,_440);return _440;},createRowNode:function(_441){var node=document.createElement("div");node.className=this.classTag+"Row";if(this instanceof _400.grid._RowSelector){html.attr(node,"role","presentation");}else{html.attr(node,"role","row");if(this.grid.selectionMode!="none"){node.setAttribute("aria-selected","false");}}node[util.gridViewTag]=this.id;node[util.rowIndexTag]=_441;this.rowNodes[_441]=node;return node;},buildRow:function(_442,_443){this.buildRowContent(_442,_443);this.styleRow(_442,_443);},buildRowContent:function(_444,_445){_445.innerHTML=this.content.generateHtml(_444,_444);if(this.flexCells&&this.contentWidth){_445.firstChild.style.width=this.contentWidth;}util.fire(this,"onAfterRow",[_444,this.structure.cells,_445]);},rowRemoved:function(_446){if(_446>=0){this._cleanupRowWidgets(this.getRowNode(_446));}this.grid.edit.save(this,_446);delete this.rowNodes[_446];},getRowNode:function(_447){return this.rowNodes[_447];},getCellNode:function(_448,_449){var row=this.getRowNode(_448);if(row){return this.content.getCellNode(row,_449);}},getHeaderCellNode:function(_44a){if(this.headerContentNode){return this.header.getCellNode(this.headerContentNode,_44a);}},styleRow:function(_44b,_44c){_44c._style=_40d(_44c);this.styleRowNode(_44b,_44c);},styleRowNode:function(_44d,_44e){if(_44e){this.doStyleRowNode(_44d,_44e);}},doStyleRowNode:function(_44f,_450){this.grid.styleRowNode(_44f,_450);},updateRow:function(_451){var _452=this.getRowNode(_451);if(_452){_452.style.height="";this.buildRow(_451,_452);}return _452;},updateRowStyles:function(_453){this.styleRowNode(_453,this.getRowNode(_453));},lastTop:0,firstScroll:0,_nativeScroll:false,doscroll:function(_454){if(has("ff")>=13||has("chrome")){this._nativeScroll=true;}var _455=this.grid.isLeftToRight();if(this.firstScroll<2){if((!_455&&this.firstScroll==1)||(_455&&this.firstScroll===0)){var s=html.marginBox(this.headerNodeContainer);if(has("ie")){this.headerNodeContainer.style.width=s.w+this.getScrollbarWidth()+"px";}else{if(has("mozilla")){this.headerNodeContainer.style.width=s.w-this.getScrollbarWidth()+"px";this.scrollboxNode.scrollLeft=_455?this.scrollboxNode.clientWidth-this.scrollboxNode.scrollWidth:this.scrollboxNode.scrollWidth-this.scrollboxNode.clientWidth;}}}this.firstScroll++;}this.headerNode.scrollLeft=this.scrollboxNode.scrollLeft;var top=this.scrollboxNode.scrollTop;if(top!==this.lastTop){this.grid.scrollTo(top);}this._nativeScroll=false;},setScrollTop:function(_456){this.lastTop=_456;if(!this._nativeScroll){this.scrollboxNode.scrollTop=_456;}return this.scrollboxNode.scrollTop;},doContentEvent:function(e){if(this.content.decorateEvent(e)){this.grid.onContentEvent(e);}},doHeaderEvent:function(e){if(this.header.decorateEvent(e)){this.grid.onHeaderEvent(e);}},dispatchContentEvent:function(e){return this.content.dispatchEvent(e);},dispatchHeaderEvent:function(e){return this.header.dispatchEvent(e);},setColWidth:function(_457,_458){this.grid.setCellWidth(_457,_458+"px");},update:function(){if(!this.domNode){return;}this.content.update();this.grid.update();var left=this.scrollboxNode.scrollLeft;this.scrollboxNode.scrollLeft=left;this.headerNode.scrollLeft=left;}});var _459=_401("dojox.grid._GridAvatar",_40b,{construct:function(){var dd=win.doc;var a=dd.createElement("table");a.cellPadding=a.cellSpacing="0";a.className="dojoxGridDndAvatar";a.style.position="absolute";a.style.zIndex=1999;a.style.margin="0px";var b=dd.createElement("tbody");var tr=dd.createElement("tr");var td=dd.createElement("td");var img=dd.createElement("td");tr.className="dojoxGridDndAvatarItem";img.className="dojoxGridDndAvatarItemImage";img.style.width="16px";var _45a=this.manager.source,node;if(_45a.creator){node=_45a._normalizedCreator(_45a.getItem(this.manager.nodes[0].id).data,"avatar").node;}else{node=this.manager.nodes[0].cloneNode(true);var _45b,_45c;if(node.tagName.toLowerCase()=="tr"){_45b=dd.createElement("table");_45c=dd.createElement("tbody");_45c.appendChild(node);_45b.appendChild(_45c);node=_45b;}else{if(node.tagName.toLowerCase()=="th"){_45b=dd.createElement("table");_45c=dd.createElement("tbody");var r=dd.createElement("tr");_45b.cellPadding=_45b.cellSpacing="0";r.appendChild(node);_45c.appendChild(r);_45b.appendChild(_45c);node=_45b;}}}node.id="";td.appendChild(node);tr.appendChild(img);tr.appendChild(td);html.style(tr,"opacity",0.9);b.appendChild(tr);a.appendChild(b);this.node=a;var m=_40c.manager();this.oldOffsetY=m.OFFSET_Y;m.OFFSET_Y=1;},destroy:function(){_40c.manager().OFFSET_Y=this.oldOffsetY;this.inherited(arguments);}});var _45d=_40c.manager().makeAvatar;_40c.manager().makeAvatar=function(){var src=this.source;if(src.viewIndex!==undefined&&!html.hasClass(win.body(),"dijit_a11y")){return new _459(this);}return _45d.call(_40c.manager());};return _410;});},"dojo/text":function(){define(["./_base/kernel","require","./has","./request"],function(dojo,_45e,has,_45f){var _460;if(1){_460=function(url,sync,load){_45f(url,{sync:!!sync,headers:{"X-Requested-With":null}}).then(load);};}else{if(_45e.getText){_460=_45e.getText;}else{console.error("dojo/text plugin failed to load because loader does not support getText");}}var _461={},_462=function(text){if(text){text=text.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");var _463=text.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_463){text=_463[1];}}else{text="";}return text;},_464={},_465={};dojo.cache=function(_466,url,_467){var key;if(typeof _466=="string"){if(/\//.test(_466)){key=_466;_467=url;}else{key=_45e.toUrl(_466.replace(/\./g,"/")+(url?("/"+url):""));}}else{key=_466+"";_467=url;}var val=(_467!=undefined&&typeof _467!="string")?_467.value:_467,_468=_467&&_467.sanitize;if(typeof val=="string"){_461[key]=val;return _468?_462(val):val;}else{if(val===null){delete _461[key];return null;}else{if(!(key in _461)){_460(key,true,function(text){_461[key]=text;});}return _468?_462(_461[key]):_461[key];}}};return {dynamic:true,normalize:function(id,_469){var _46a=id.split("!"),url=_46a[0];return (/^\./.test(url)?_469(url):url)+(_46a[1]?"!"+_46a[1]:"");},load:function(id,_46b,load){var _46c=id.split("!"),_46d=_46c.length>1,_46e=_46c[0],url=_46b.toUrl(_46c[0]),_46f="url:"+url,text=_464,_470=function(text){load(_46d?_462(text):text);};if(_46e in _461){text=_461[_46e];}else{if(_46b.cache&&_46f in _46b.cache){text=_46b.cache[_46f];}else{if(url in _461){text=_461[url];}}}if(text===_464){if(_465[url]){_465[url].push(_470);}else{var _471=_465[url]=[_470];_460(url,!_46b.async,function(text){_461[_46e]=_461[url]=text;for(var i=0;i<_471.length;){_471[i++](text);}delete _465[url];});}}else{_470(text);}}};});},"dojo/request":function(){define(["./request/default!"],function(_472){return _472;});},"dojo/request/default":function(){define(["exports","require","../has"],function(_473,_474,has){var _475=has("config-requestProvider"),_476;if(1||has("host-webworker")){_476="./xhr";}else{if(0){_476="./node";}}if(!_475){_475=_476;}_473.getPlatformDefaultId=function(){return _476;};_473.load=function(id,_477,_478,_479){_474([id=="platform"?_476:_475],function(_47a){_478(_47a);});};});},"dojo/dnd/Source":function(){define(["../_base/array","../_base/declare","../_base/kernel","../_base/lang","../dom-class","../dom-geometry","../mouse","../ready","../topic","./common","./Selector","./Manager"],function(_47b,_47c,_47d,lang,_47e,_47f,_480,_481,_482,dnd,_483,_484){if(!_47d.isAsync){_481(0,function(){var _485=["dojo/dnd/AutoSource","dojo/dnd/Target"];require(_485);});}var _486=_47c("dojo.dnd.Source",_483,{isSource:true,horizontal:false,copyOnly:false,selfCopy:false,selfAccept:true,skipForm:false,withHandles:false,autoSync:false,delay:0,accept:["text"],generateText:true,constructor:function(node,_487){lang.mixin(this,lang.mixin({},_487));var type=this.accept;if(type.length){this.accept={};for(var i=0;i<type.length;++i){this.accept[type[i]]=1;}}this.isDragging=false;this.mouseDown=false;this.targetAnchor=null;this.targetBox=null;this.before=true;this._lastX=0;this._lastY=0;this.sourceState="";if(this.isSource){_47e.add(this.node,"dojoDndSource");}this.targetState="";if(this.accept){_47e.add(this.node,"dojoDndTarget");}if(this.horizontal){_47e.add(this.node,"dojoDndHorizontal");}this.topics=[_482.subscribe("/dnd/source/over",lang.hitch(this,"onDndSourceOver")),_482.subscribe("/dnd/start",lang.hitch(this,"onDndStart")),_482.subscribe("/dnd/drop",lang.hitch(this,"onDndDrop")),_482.subscribe("/dnd/cancel",lang.hitch(this,"onDndCancel"))];},checkAcceptance:function(_488,_489){if(this==_488){return !this.copyOnly||this.selfAccept;}for(var i=0;i<_489.length;++i){var type=_488.getItem(_489[i].id).type;var flag=false;for(var j=0;j<type.length;++j){if(type[j] in this.accept){flag=true;break;}}if(!flag){return false;}}return true;},copyState:function(_48a,self){if(_48a){return true;}if(arguments.length<2){self=this==_484.manager().target;}if(self){if(this.copyOnly){return this.selfCopy;}}else{return this.copyOnly;}return false;},destroy:function(){_486.superclass.destroy.call(this);_47b.forEach(this.topics,function(t){t.remove();});this.targetAnchor=null;},onMouseMove:function(e){if(this.isDragging&&this.targetState=="Disabled"){return;}_486.superclass.onMouseMove.call(this,e);var m=_484.manager();if(!this.isDragging){if(this.mouseDown&&this.isSource&&(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay)){var _48b=this.getSelectedNodes();if(_48b.length){m.startDrag(this,_48b,this.copyState(dnd.getCopyKeyState(e),true));}}}if(this.isDragging){var _48c=false;if(this.current){if(!this.targetBox||this.targetAnchor!=this.current){this.targetBox=_47f.position(this.current,true);}if(this.horizontal){_48c=(e.pageX-this.targetBox.x<this.targetBox.w/2)==_47f.isBodyLtr(this.current.ownerDocument);}else{_48c=(e.pageY-this.targetBox.y)<(this.targetBox.h/2);}}if(this.current!=this.targetAnchor||_48c!=this.before){this._markTargetAnchor(_48c);m.canDrop(!this.current||m.source!=this||!(this.current.id in this.selection));}}},onMouseDown:function(e){if(!this.mouseDown&&this._legalMouseDown(e)&&(!this.skipForm||!dnd.isFormElement(e))){this.mouseDown=true;this._lastX=e.pageX;this._lastY=e.pageY;_486.superclass.onMouseDown.call(this,e);}},onMouseUp:function(e){if(this.mouseDown){this.mouseDown=false;_486.superclass.onMouseUp.call(this,e);}},onDndSourceOver:function(_48d){if(this!==_48d){this.mouseDown=false;if(this.targetAnchor){this._unmarkTargetAnchor();}}else{if(this.isDragging){var m=_484.manager();m.canDrop(this.targetState!="Disabled"&&(!this.current||m.source!=this||!(this.current.id in this.selection)));}}},onDndStart:function(_48e,_48f,copy){if(this.autoSync){this.sync();}if(this.isSource){this._changeState("Source",this==_48e?(copy?"Copied":"Moved"):"");}var _490=this.accept&&this.checkAcceptance(_48e,_48f);this._changeState("Target",_490?"":"Disabled");if(this==_48e){_484.manager().overSource(this);}this.isDragging=true;},onDndDrop:function(_491,_492,copy,_493){if(this==_493){this.onDrop(_491,_492,copy);}this.onDndCancel();},onDndCancel:function(){if(this.targetAnchor){this._unmarkTargetAnchor();this.targetAnchor=null;}this.before=true;this.isDragging=false;this.mouseDown=false;this._changeState("Source","");this._changeState("Target","");},onDrop:function(_494,_495,copy){if(this!=_494){this.onDropExternal(_494,_495,copy);}else{this.onDropInternal(_495,copy);}},onDropExternal:function(_496,_497,copy){var _498=this._normalizedCreator;if(this.creator){this._normalizedCreator=function(node,hint){return _498.call(this,_496.getItem(node.id).data,hint);};}else{if(copy){this._normalizedCreator=function(node){var t=_496.getItem(node.id);var n=node.cloneNode(true);n.id=dnd.getUniqueId();return {node:n,data:t.data,type:t.type};};}else{this._normalizedCreator=function(node){var t=_496.getItem(node.id);_496.delItem(node.id);return {node:node,data:t.data,type:t.type};};}}this.selectNone();if(!copy&&!this.creator){_496.selectNone();}this.insertNodes(true,_497,this.before,this.current);if(!copy&&this.creator){_496.deleteSelectedNodes();}this._normalizedCreator=_498;},onDropInternal:function(_499,copy){var _49a=this._normalizedCreator;if(this.current&&this.current.id in this.selection){return;}if(copy){if(this.creator){this._normalizedCreator=function(node,hint){return _49a.call(this,this.getItem(node.id).data,hint);};}else{this._normalizedCreator=function(node){var t=this.getItem(node.id);var n=node.cloneNode(true);n.id=dnd.getUniqueId();return {node:n,data:t.data,type:t.type};};}}else{if(!this.current){return;}this._normalizedCreator=function(node){var t=this.getItem(node.id);return {node:node,data:t.data,type:t.type};};}this._removeSelection();this.insertNodes(true,_499,this.before,this.current);this._normalizedCreator=_49a;},onDraggingOver:function(){},onDraggingOut:function(){},onOverEvent:function(){_486.superclass.onOverEvent.call(this);_484.manager().overSource(this);if(this.isDragging&&this.targetState!="Disabled"){this.onDraggingOver();}},onOutEvent:function(){_486.superclass.onOutEvent.call(this);_484.manager().outSource(this);if(this.isDragging&&this.targetState!="Disabled"){this.onDraggingOut();}},_markTargetAnchor:function(_49b){if(this.current==this.targetAnchor&&this.before==_49b){return;}if(this.targetAnchor){this._removeItemClass(this.targetAnchor,this.before?"Before":"After");}this.targetAnchor=this.current;this.targetBox=null;this.before=_49b;if(this.targetAnchor){this._addItemClass(this.targetAnchor,this.before?"Before":"After");}},_unmarkTargetAnchor:function(){if(!this.targetAnchor){return;}this._removeItemClass(this.targetAnchor,this.before?"Before":"After");this.targetAnchor=null;this.targetBox=null;this.before=true;},_markDndStatus:function(copy){this._changeState("Source",copy?"Copied":"Moved");},_legalMouseDown:function(e){if(e.type!="touchstart"&&!_480.isLeft(e)){return false;}if(!this.withHandles){return true;}for(var node=e.target;node&&node!==this.node;node=node.parentNode){if(_47e.contains(node,"dojoDndHandle")){return true;}if(_47e.contains(node,"dojoDndItem")||_47e.contains(node,"dojoDndIgnore")){break;}}return false;}});return _486;});},"dojo/dnd/common":function(){define(["../sniff","../_base/kernel","../_base/lang","../dom"],function(has,_49c,lang,dom){var _49d=lang.getObject("dojo.dnd",true);_49d.getCopyKeyState=function(evt){return evt[has("mac")?"metaKey":"ctrlKey"];};_49d._uniqueId=0;_49d.getUniqueId=function(){var id;do{id=_49c._scopeName+"Unique"+(++_49d._uniqueId);}while(dom.byId(id));return id;};_49d._empty={};_49d.isFormElement=function(e){var t=e.target;if(t.nodeType==3){t=t.parentNode;}return " a button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;};return _49d;});},"dojo/dnd/Selector":function(){define(["../_base/array","../_base/declare","../_base/kernel","../_base/lang","../dom","../dom-construct","../mouse","../_base/NodeList","../on","../touch","./common","./Container"],function(_49e,_49f,_4a0,lang,dom,_4a1,_4a2,_4a3,on,_4a4,dnd,_4a5){var _4a6=_49f("dojo.dnd.Selector",_4a5,{constructor:function(node,_4a7){if(!_4a7){_4a7={};}this.singular=_4a7.singular;this.autoSync=_4a7.autoSync;this.selection={};this.anchor=null;this.simpleSelection=false;this.events.push(on(this.node,_4a4.press,lang.hitch(this,"onMouseDown")),on(this.node,_4a4.release,lang.hitch(this,"onMouseUp")));},singular:false,getSelectedNodes:function(){var t=new _4a3();var e=dnd._empty;for(var i in this.selection){if(i in e){continue;}t.push(dom.byId(i));}return t;},selectNone:function(){return this._removeSelection()._removeAnchor();},selectAll:function(){this.forInItems(function(data,id){this._addItemClass(dom.byId(id),"Selected");this.selection[id]=1;},this);return this._removeAnchor();},deleteSelectedNodes:function(){var e=dnd._empty;for(var i in this.selection){if(i in e){continue;}var n=dom.byId(i);this.delItem(i);_4a1.destroy(n);}this.anchor=null;this.selection={};return this;},forInSelectedItems:function(f,o){o=o||_4a0.global;var s=this.selection,e=dnd._empty;for(var i in s){if(i in e){continue;}f.call(o,this.getItem(i),i,this);}},sync:function(){_4a6.superclass.sync.call(this);if(this.anchor){if(!this.getItem(this.anchor.id)){this.anchor=null;}}var t=[],e=dnd._empty;for(var i in this.selection){if(i in e){continue;}if(!this.getItem(i)){t.push(i);}}_49e.forEach(t,function(i){delete this.selection[i];},this);return this;},insertNodes:function(_4a8,data,_4a9,_4aa){var _4ab=this._normalizedCreator;this._normalizedCreator=function(item,hint){var t=_4ab.call(this,item,hint);if(_4a8){if(!this.anchor){this.anchor=t.node;this._removeItemClass(t.node,"Selected");this._addItemClass(this.anchor,"Anchor");}else{if(this.anchor!=t.node){this._removeItemClass(t.node,"Anchor");this._addItemClass(t.node,"Selected");}}this.selection[t.node.id]=1;}else{this._removeItemClass(t.node,"Selected");this._removeItemClass(t.node,"Anchor");}return t;};_4a6.superclass.insertNodes.call(this,data,_4a9,_4aa);this._normalizedCreator=_4ab;return this;},destroy:function(){_4a6.superclass.destroy.call(this);this.selection=this.anchor=null;},onMouseDown:function(e){if(this.autoSync){this.sync();}if(!this.current){return;}if(!this.singular&&!dnd.getCopyKeyState(e)&&!e.shiftKey&&(this.current.id in this.selection)){this.simpleSelection=true;if(_4a2.isLeft(e)){e.stopPropagation();e.preventDefault();}return;}if(!this.singular&&e.shiftKey){if(!dnd.getCopyKeyState(e)){this._removeSelection();}var c=this.getAllNodes();if(c.length){if(!this.anchor){this.anchor=c[0];this._addItemClass(this.anchor,"Anchor");}this.selection[this.anchor.id]=1;if(this.anchor!=this.current){var i=0,node;for(;i<c.length;++i){node=c[i];if(node==this.anchor||node==this.current){break;}}for(++i;i<c.length;++i){node=c[i];if(node==this.anchor||node==this.current){break;}this._addItemClass(node,"Selected");this.selection[node.id]=1;}this._addItemClass(this.current,"Selected");this.selection[this.current.id]=1;}}}else{if(this.singular){if(this.anchor==this.current){if(dnd.getCopyKeyState(e)){this.selectNone();}}else{this.selectNone();this.anchor=this.current;this._addItemClass(this.anchor,"Anchor");this.selection[this.current.id]=1;}}else{if(dnd.getCopyKeyState(e)){if(this.anchor==this.current){delete this.selection[this.anchor.id];this._removeAnchor();}else{if(this.current.id in this.selection){this._removeItemClass(this.current,"Selected");delete this.selection[this.current.id];}else{if(this.anchor){this._removeItemClass(this.anchor,"Anchor");this._addItemClass(this.anchor,"Selected");}this.anchor=this.current;this._addItemClass(this.current,"Anchor");this.selection[this.current.id]=1;}}}else{if(!(this.current.id in this.selection)){this.selectNone();this.anchor=this.current;this._addItemClass(this.current,"Anchor");this.selection[this.current.id]=1;}}}}e.stopPropagation();e.preventDefault();},onMouseUp:function(){if(!this.simpleSelection){return;}this.simpleSelection=false;this.selectNone();if(this.current){this.anchor=this.current;this._addItemClass(this.anchor,"Anchor");this.selection[this.current.id]=1;}},onMouseMove:function(){this.simpleSelection=false;},onOverEvent:function(){this.onmousemoveEvent=on(this.node,_4a4.move,lang.hitch(this,"onMouseMove"));},onOutEvent:function(){if(this.onmousemoveEvent){this.onmousemoveEvent.remove();delete this.onmousemoveEvent;}},_removeSelection:function(){var e=dnd._empty;for(var i in this.selection){if(i in e){continue;}var node=dom.byId(i);if(node){this._removeItemClass(node,"Selected");}}this.selection={};return this;},_removeAnchor:function(){if(this.anchor){this._removeItemClass(this.anchor,"Anchor");this.anchor=null;}return this;}});return _4a6;});},"dojo/dnd/Container":function(){define(["../_base/array","../_base/declare","../_base/kernel","../_base/lang","../_base/window","../dom","../dom-class","../dom-construct","../Evented","../has","../on","../query","../touch","./common"],function(_4ac,_4ad,_4ae,lang,win,dom,_4af,_4b0,_4b1,has,on,_4b2,_4b3,dnd){var _4b4=_4ad("dojo.dnd.Container",_4b1,{skipForm:false,allowNested:false,constructor:function(node,_4b5){this.node=dom.byId(node);if(!_4b5){_4b5={};}this.creator=_4b5.creator||null;this.skipForm=_4b5.skipForm;this.parent=_4b5.dropParent&&dom.byId(_4b5.dropParent);this.map={};this.current=null;this.containerState="";_4af.add(this.node,"dojoDndContainer");if(!(_4b5&&_4b5._skipStartup)){this.startup();}this.events=[on(this.node,_4b3.over,lang.hitch(this,"onMouseOver")),on(this.node,_4b3.out,lang.hitch(this,"onMouseOut")),on(this.node,"dragstart",lang.hitch(this,"onSelectStart")),on(this.node,"selectstart",lang.hitch(this,"onSelectStart"))];},creator:function(){},getItem:function(key){return this.map[key];},setItem:function(key,data){this.map[key]=data;},delItem:function(key){delete this.map[key];},forInItems:function(f,o){o=o||_4ae.global;var m=this.map,e=dnd._empty;for(var i in m){if(i in e){continue;}f.call(o,m[i],i,this);}return o;},clearItems:function(){this.map={};},getAllNodes:function(){return _4b2((this.allowNested?"":"> ")+".dojoDndItem",this.parent);},sync:function(){var map={};this.getAllNodes().forEach(function(node){if(node.id){var item=this.getItem(node.id);if(item){map[node.id]=item;return;}}else{node.id=dnd.getUniqueId();}var type=node.getAttribute("dndType"),data=node.getAttribute("dndData");map[node.id]={data:data||node.innerHTML,type:type?type.split(/\s*,\s*/):["text"]};},this);this.map=map;return this;},insertNodes:function(data,_4b6,_4b7){if(!this.parent.firstChild){_4b7=null;}else{if(_4b6){if(!_4b7){_4b7=this.parent.firstChild;}}else{if(_4b7){_4b7=_4b7.nextSibling;}}}var i,t;if(_4b7){for(i=0;i<data.length;++i){t=this._normalizedCreator(data[i]);this.setItem(t.node.id,{data:t.data,type:t.type});_4b7.parentNode.insertBefore(t.node,_4b7);}}else{for(i=0;i<data.length;++i){t=this._normalizedCreator(data[i]);this.setItem(t.node.id,{data:t.data,type:t.type});this.parent.appendChild(t.node);}}return this;},destroy:function(){_4ac.forEach(this.events,function(_4b8){_4b8.remove();});this.clearItems();this.node=this.parent=this.current=null;},markupFactory:function(_4b9,node,Ctor){_4b9._skipStartup=true;return new Ctor(node,_4b9);},startup:function(){if(!this.parent){this.parent=this.node;if(this.parent.tagName.toLowerCase()=="table"){var c=this.parent.getElementsByTagName("tbody");if(c&&c.length){this.parent=c[0];}}}this.defaultCreator=dnd._defaultCreator(this.parent);this.sync();},onMouseOver:function(e){var n=e.relatedTarget;while(n){if(n==this.node){break;}try{n=n.parentNode;}catch(x){n=null;}}if(!n){this._changeState("Container","Over");this.onOverEvent();}n=this._getChildByEvent(e);if(this.current==n){return;}if(this.current){this._removeItemClass(this.current,"Over");}if(n){this._addItemClass(n,"Over");}this.current=n;},onMouseOut:function(e){for(var n=e.relatedTarget;n;){if(n==this.node){return;}try{n=n.parentNode;}catch(x){n=null;}}if(this.current){this._removeItemClass(this.current,"Over");this.current=null;}this._changeState("Container","");this.onOutEvent();},onSelectStart:function(e){if(!this.withHandles&&(!this.skipForm||!dnd.isFormElement(e))){e.stopPropagation();e.preventDefault();}},onOverEvent:function(){},onOutEvent:function(){},_changeState:function(type,_4ba){var _4bb="dojoDnd"+type;var _4bc=type.toLowerCase()+"State";_4af.replace(this.node,_4bb+_4ba,_4bb+this[_4bc]);this[_4bc]=_4ba;},_addItemClass:function(node,type){_4af.add(node,"dojoDndItem"+type);},_removeItemClass:function(node,type){_4af.remove(node,"dojoDndItem"+type);},_getChildByEvent:function(e){var node=e.target;if(node){for(var _4bd=node.parentNode;_4bd;node=_4bd,_4bd=node.parentNode){if((_4bd==this.parent||this.allowNested)&&_4af.contains(node,"dojoDndItem")){return node;}}}return null;},_normalizedCreator:function(item,hint){var t=(this.creator||this.defaultCreator).call(this,item,hint);if(!lang.isArray(t.type)){t.type=["text"];}if(!t.node.id){t.node.id=dnd.getUniqueId();}_4af.add(t.node,"dojoDndItem");return t;}});dnd._createNode=function(tag){if(!tag){return dnd._createSpan;}return function(text){return _4b0.create(tag,{innerHTML:text});};};dnd._createTrTd=function(text){var tr=_4b0.create("tr");_4b0.create("td",{innerHTML:text},tr);return tr;};dnd._createSpan=function(text){return _4b0.create("span",{innerHTML:text});};dnd._defaultCreatorNodes={ul:"li",ol:"li",div:"div",p:"div"};dnd._defaultCreator=function(node){var tag=node.tagName.toLowerCase();var c=tag=="tbody"||tag=="thead"?dnd._createTrTd:dnd._createNode(dnd._defaultCreatorNodes[tag]);return function(item,hint){var _4be=item&&lang.isObject(item),data,type,n;if(_4be&&item.tagName&&item.nodeType&&item.getAttribute){data=item.getAttribute("dndData")||item.innerHTML;type=item.getAttribute("dndType");type=type?type.split(/\s*,\s*/):["text"];n=item;}else{data=(_4be&&item.data)?item.data:item;type=(_4be&&item.type)?item.type:["text"];n=(hint=="avatar"?dnd._createSpan:c)(String(data));}if(!n.id){n.id=dnd.getUniqueId();}return {node:n,data:data,type:type};};};return _4b4;});},"dojo/dnd/Manager":function(){define(["../_base/array","../_base/declare","../_base/lang","../_base/window","../dom-class","../Evented","../has","../keys","../on","../topic","../touch","./common","./autoscroll","./Avatar"],function(_4bf,_4c0,lang,win,_4c1,_4c2,has,keys,on,_4c3,_4c4,dnd,_4c5,_4c6){var _4c7=_4c0("dojo.dnd.Manager",[_4c2],{constructor:function(){this.avatar=null;this.source=null;this.nodes=[];this.copy=true;this.target=null;this.canDropFlag=false;this.events=[];},OFFSET_X:has("touch")?4:16,OFFSET_Y:has("touch")?4:16,overSource:function(_4c8){if(this.avatar){this.target=(_4c8&&_4c8.targetState!="Disabled")?_4c8:null;this.canDropFlag=Boolean(this.target);this.avatar.update();}_4c3.publish("/dnd/source/over",_4c8);},outSource:function(_4c9){if(this.avatar){if(this.target==_4c9){this.target=null;this.canDropFlag=false;this.avatar.update();_4c3.publish("/dnd/source/over",null);}}else{_4c3.publish("/dnd/source/over",null);}},startDrag:function(_4ca,_4cb,copy){_4c5.autoScrollStart(win.doc);this.source=_4ca;this.nodes=_4cb;this.copy=Boolean(copy);this.avatar=this.makeAvatar();win.body().appendChild(this.avatar.node);_4c3.publish("/dnd/start",_4ca,_4cb,this.copy);function _4cc(e){e.preventDefault();e.stopPropagation();};this.events=[on(win.doc,_4c4.move,lang.hitch(this,"onMouseMove")),on(win.doc,_4c4.release,lang.hitch(this,"onMouseUp")),on(win.doc,"keydown",lang.hitch(this,"onKeyDown")),on(win.doc,"keyup",lang.hitch(this,"onKeyUp")),on(win.doc,"dragstart",_4cc),on(win.body(),"selectstart",_4cc)];var c="dojoDnd"+(copy?"Copy":"Move");_4c1.add(win.body(),c);},canDrop:function(flag){var _4cd=Boolean(this.target&&flag);if(this.canDropFlag!=_4cd){this.canDropFlag=_4cd;this.avatar.update();}},stopDrag:function(){_4c1.remove(win.body(),["dojoDndCopy","dojoDndMove"]);_4bf.forEach(this.events,function(_4ce){_4ce.remove();});this.events=[];this.avatar.destroy();this.avatar=null;this.source=this.target=null;this.nodes=[];},makeAvatar:function(){return new _4c6(this);},updateAvatar:function(){this.avatar.update();},onMouseMove:function(e){var a=this.avatar;if(a){_4c5.autoScrollNodes(e);var s=a.node.style;s.left=(e.pageX+this.OFFSET_X)+"px";s.top=(e.pageY+this.OFFSET_Y)+"px";var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));if(this.copy!=copy){this._setCopyStatus(copy);}}if(has("touch")){e.preventDefault();}},onMouseUp:function(e){if(this.avatar){if(this.target&&this.canDropFlag){var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));_4c3.publish("/dnd/drop/before",this.source,this.nodes,copy,this.target,e);_4c3.publish("/dnd/drop",this.source,this.nodes,copy,this.target,e);}else{_4c3.publish("/dnd/cancel");}this.stopDrag();}},onKeyDown:function(e){if(this.avatar){switch(e.keyCode){case keys.CTRL:var copy=Boolean(this.source.copyState(true));if(this.copy!=copy){this._setCopyStatus(copy);}break;case keys.ESCAPE:_4c3.publish("/dnd/cancel");this.stopDrag();break;}}},onKeyUp:function(e){if(this.avatar&&e.keyCode==keys.CTRL){var copy=Boolean(this.source.copyState(false));if(this.copy!=copy){this._setCopyStatus(copy);}}},_setCopyStatus:function(copy){this.copy=copy;this.source._markDndStatus(this.copy);this.updateAvatar();_4c1.replace(win.body(),"dojoDnd"+(this.copy?"Copy":"Move"),"dojoDnd"+(this.copy?"Move":"Copy"));}});dnd._manager=null;_4c7.manager=dnd.manager=function(){if(!dnd._manager){dnd._manager=new _4c7();}return dnd._manager;};return _4c7;});},"dojo/dnd/autoscroll":function(){define(["../_base/lang","../sniff","../_base/window","../dom-geometry","../dom-style","../window"],function(lang,has,win,_4cf,_4d0,_4d1){var _4d2={};lang.setObject("dojo.dnd.autoscroll",_4d2);_4d2.getViewport=_4d1.getBox;_4d2.V_TRIGGER_AUTOSCROLL=32;_4d2.H_TRIGGER_AUTOSCROLL=32;_4d2.V_AUTOSCROLL_VALUE=16;_4d2.H_AUTOSCROLL_VALUE=16;var _4d3,doc=win.doc,_4d4=Infinity,_4d5=Infinity;_4d2.autoScrollStart=function(d){doc=d;_4d3=_4d1.getBox(doc);var html=win.body(doc).parentNode;_4d4=Math.max(html.scrollHeight-_4d3.h,0);_4d5=Math.max(html.scrollWidth-_4d3.w,0);};_4d2.autoScroll=function(e){var v=_4d3||_4d1.getBox(doc),html=win.body(doc).parentNode,dx=0,dy=0;if(e.clientX<_4d2.H_TRIGGER_AUTOSCROLL){dx=-_4d2.H_AUTOSCROLL_VALUE;}else{if(e.clientX>v.w-_4d2.H_TRIGGER_AUTOSCROLL){dx=Math.min(_4d2.H_AUTOSCROLL_VALUE,_4d5-html.scrollLeft);}}if(e.clientY<_4d2.V_TRIGGER_AUTOSCROLL){dy=-_4d2.V_AUTOSCROLL_VALUE;}else{if(e.clientY>v.h-_4d2.V_TRIGGER_AUTOSCROLL){dy=Math.min(_4d2.V_AUTOSCROLL_VALUE,_4d4-html.scrollTop);}}window.scrollBy(dx,dy);};_4d2._validNodes={"div":1,"p":1,"td":1};_4d2._validOverflow={"auto":1,"scroll":1};_4d2.autoScrollNodes=function(e){var b,t,w,h,rx,ry,dx=0,dy=0,_4d6,_4d7;for(var n=e.target;n;){if(n.nodeType==1&&(n.tagName.toLowerCase() in _4d2._validNodes)){var s=_4d0.getComputedStyle(n),_4d8=(s.overflowX.toLowerCase() in _4d2._validOverflow),_4d9=(s.overflowY.toLowerCase() in _4d2._validOverflow);if(_4d8||_4d9){b=_4cf.getContentBox(n,s);t=_4cf.position(n,true);}if(_4d8){w=Math.min(_4d2.H_TRIGGER_AUTOSCROLL,b.w/2);rx=e.pageX-t.x;if(has("webkit")||has("opera")){rx+=win.body().scrollLeft;}dx=0;if(rx>0&&rx<b.w){if(rx<w){dx=-w;}else{if(rx>b.w-w){dx=w;}}_4d6=n.scrollLeft;n.scrollLeft=n.scrollLeft+dx;}}if(_4d9){h=Math.min(_4d2.V_TRIGGER_AUTOSCROLL,b.h/2);ry=e.pageY-t.y;if(has("webkit")||has("opera")){ry+=win.body().scrollTop;}dy=0;if(ry>0&&ry<b.h){if(ry<h){dy=-h;}else{if(ry>b.h-h){dy=h;}}_4d7=n.scrollTop;n.scrollTop=n.scrollTop+dy;}}if(dx||dy){return;}}try{n=n.parentNode;}catch(x){n=null;}}_4d2.autoScroll(e);};return _4d2;});},"dojo/dnd/Avatar":function(){define(["../_base/declare","../_base/window","../dom","../dom-attr","../dom-class","../dom-construct","../hccss","../query"],function(_4da,win,dom,_4db,_4dc,_4dd,has,_4de){return _4da("dojo.dnd.Avatar",null,{constructor:function(_4df){this.manager=_4df;this.construct();},construct:function(){var a=_4dd.create("table",{"class":"dojoDndAvatar",style:{position:"absolute",zIndex:"1999",margin:"0px"}}),_4e0=this.manager.source,node,b=_4dd.create("tbody",null,a),tr=_4dd.create("tr",null,b),td=_4dd.create("td",null,tr),k=Math.min(5,this.manager.nodes.length),i=0;if(has("highcontrast")){_4dd.create("span",{id:"a11yIcon",innerHTML:this.manager.copy?"+":"<"},td);}_4dd.create("span",{innerHTML:_4e0.generateText?this._generateText():""},td);_4db.set(tr,{"class":"dojoDndAvatarHeader",style:{opacity:0.9}});for(;i<k;++i){if(_4e0.creator){node=_4e0._normalizedCreator(_4e0.getItem(this.manager.nodes[i].id).data,"avatar").node;}else{node=this.manager.nodes[i].cloneNode(true);if(node.tagName.toLowerCase()=="tr"){var _4e1=_4dd.create("table"),_4e2=_4dd.create("tbody",null,_4e1);_4e2.appendChild(node);node=_4e1;}}node.id="";tr=_4dd.create("tr",null,b);td=_4dd.create("td",null,tr);td.appendChild(node);_4db.set(tr,{"class":"dojoDndAvatarItem",style:{opacity:(9-i)/10}});}this.node=a;},destroy:function(){_4dd.destroy(this.node);this.node=false;},update:function(){_4dc.toggle(this.node,"dojoDndAvatarCanDrop",this.manager.canDropFlag);if(has("highcontrast")){var icon=dom.byId("a11yIcon");var text="+";if(this.manager.canDropFlag&&!this.manager.copy){text="< ";}else{if(!this.manager.canDropFlag&&!this.manager.copy){text="o";}else{if(!this.manager.canDropFlag){text="x";}}}icon.innerHTML=text;}_4de(("tr.dojoDndAvatarHeader td span"+(has("highcontrast")?" span":"")),this.node).forEach(function(node){node.innerHTML=this.manager.source.generateText?this._generateText():"";},this);},_generateText:function(){return this.manager.nodes.length.toString();}});});},"dijit/_TemplatedMixin":function(){define(["dojo/cache","dojo/_base/declare","dojo/dom-construct","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_AttachMixin"],function(_4e3,_4e4,_4e5,lang,on,has,_4e6,_4e7){var _4e8=_4e4("dijit._TemplatedMixin",_4e7,{templateString:null,templatePath:null,_skipNodeCache:false,searchContainerNode:true,_stringRepl:function(tmpl){var _4e9=this.declaredClass,_4ea=this;return _4e6.substitute(tmpl,this,function(_4eb,key){if(key.charAt(0)=="!"){_4eb=lang.getObject(key.substr(1),false,_4ea);}if(typeof _4eb=="undefined"){throw new Error(_4e9+" template:"+key);}if(_4eb==null){return "";}return key.charAt(0)=="!"?_4eb:this._escapeValue(""+_4eb);},this);},_escapeValue:function(val){return val.replace(/["'<>&]/g,function(val){return {"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#x27;"}[val];});},buildRendering:function(){if(!this._rendered){if(!this.templateString){this.templateString=_4e3(this.templatePath,{sanitize:true});}var _4ec=_4e8.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);var node;if(lang.isString(_4ec)){node=_4e5.toDom(this._stringRepl(_4ec),this.ownerDocument);if(node.nodeType!=1){throw new Error("Invalid template: "+_4ec);}}else{node=_4ec.cloneNode(true);}this.domNode=node;}this.inherited(arguments);if(!this._rendered){this._fillContent(this.srcNodeRef);}this._rendered=true;},_fillContent:function(_4ed){var dest=this.containerNode;if(_4ed&&dest){while(_4ed.hasChildNodes()){dest.appendChild(_4ed.firstChild);}}}});_4e8._templateCache={};_4e8.getCachedTemplate=function(_4ee,_4ef,doc){var _4f0=_4e8._templateCache;var key=_4ee;var _4f1=_4f0[key];if(_4f1){try{if(!_4f1.ownerDocument||_4f1.ownerDocument==(doc||document)){return _4f1;}}catch(e){}_4e5.destroy(_4f1);}_4ee=_4e6.trim(_4ee);if(_4ef||_4ee.match(/\$\{([^\}]+)\}/g)){return (_4f0[key]=_4ee);}else{var node=_4e5.toDom(_4ee,doc);if(node.nodeType!=1){throw new Error("Invalid template: "+_4ee);}return (_4f0[key]=node);}};if(has("ie")){on(window,"unload",function(){var _4f2=_4e8._templateCache;for(var key in _4f2){var _4f3=_4f2[key];if(typeof _4f3=="object"){_4e5.destroy(_4f3);}delete _4f2[key];}});}return _4e8;});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo){return dojo.cache;});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(_4f4,lang){var _4f5=/[&<>'"\/]/g;var _4f6={"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#x27;","/":"&#x2F;"};var _4f7={};lang.setObject("dojo.string",_4f7);_4f7.escape=function(str){if(!str){return "";}return str.replace(_4f5,function(c){return _4f6[c];});};_4f7.codePointAt=String.prototype.codePointAt?function(str,_4f8){return String.prototype.codePointAt.call(str,_4f8);}:function(str,_4f9){if(str==null){throw new TypeError("codePointAt called on null or undefined");}var size;var _4fa;var _4fb;var _4fc;str=String(str);size=str.length;_4fc=_4f9?Number(_4f9):0;if(_4fc!=_4fc){_4fc=0;}if(_4fc<0||_4fc>=size){return undefined;}_4fa=str.charCodeAt(_4fc);if(_4fa>=55296&&_4fa<=56319&&size>_4fc+1){_4fb=str.charCodeAt(_4fc+1);if(_4fb>=56320&&_4fb<=57343){return (_4fa-55296)*1024+_4fb-56320+65536;}}return _4fa;};_4f7.fromCodePoint=String.fromCodePoint||function(){var _4fd=[];var _4fe=0;var _4ff="";var _500;var _501;for(_501=0,len=arguments.length;_501!==len;++_501){_500=+arguments[_501];if(!(_500<1114111&&(_500>>>0)===_500)){throw RangeError("Invalid code point: "+_500);}if(_500<=65535){_4fe=_4fd.push(_500);}else{_500-=65536;_4fe=_4fd.push((_500>>10)+55296,(_500%1024)+56320);}if(_4fe>=16383){_4ff+=String.fromCharCode.apply(null,_4fd);_4fd.length=0;}}return _4ff+String.fromCharCode.apply(null,_4fd);};_4f7.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};_4f7.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=_4f7.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};_4f7.substitute=function(_502,map,_503,_504){_504=_504||_4f4.global;_503=_503?lang.hitch(_504,_503):function(v){return v;};return _502.replace(/\$\{([^\s\:\}]*)(?:\:([^\s\:\}]+))?\}/g,function(_505,key,_506){if(key==""){return "$";}var _507=lang.getObject(key,false,map);if(_506){_507=lang.getObject(_506,false,_504).call(_504,_507,key);}var _508=_503(_507,key);if(typeof _508==="undefined"){throw new Error("string.substitute could not find key \""+key+"\" in template");}return _508.toString();});};_4f7.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return _4f7;});},"dijit/_AttachMixin":function(){define(["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/mouse","dojo/on","dojo/touch","./_WidgetBase"],function(_509,_50a,_50b,_50c,lang,_50d,on,_50e,_50f){var _510=lang.delegate(_50e,{"mouseenter":_50d.enter,"mouseleave":_50d.leave,"keypress":_50b._keypress});var _511;var _512=_50c("dijit._AttachMixin",null,{constructor:function(){this._attachPoints=[];this._attachEvents=[];},buildRendering:function(){this.inherited(arguments);this._attachTemplateNodes(this.domNode);this._beforeFillContent();},_beforeFillContent:function(){},_attachTemplateNodes:function(_513){var node=_513;while(true){if(node.nodeType==1&&(this._processTemplateNode(node,function(n,p){return n.getAttribute(p);},this._attach)||this.searchContainerNode)&&node.firstChild){node=node.firstChild;}else{if(node==_513){return;}while(!node.nextSibling){node=node.parentNode;if(node==_513){return;}}node=node.nextSibling;}}},_processTemplateNode:function(_514,_515,_516){var ret=true;var _517=this.attachScope||this,_518=_515(_514,"dojoAttachPoint")||_515(_514,"data-dojo-attach-point");if(_518){var _519,_51a=_518.split(/\s*,\s*/);while((_519=_51a.shift())){if(lang.isArray(_517[_519])){_517[_519].push(_514);}else{_517[_519]=_514;}ret=(_519!="containerNode");this._attachPoints.push(_519);}}var _51b=_515(_514,"dojoAttachEvent")||_515(_514,"data-dojo-attach-event");if(_51b){var _51c,_51d=_51b.split(/\s*,\s*/);var trim=lang.trim;while((_51c=_51d.shift())){if(_51c){var _51e=null;if(_51c.indexOf(":")!=-1){var _51f=_51c.split(":");_51c=trim(_51f[0]);_51e=trim(_51f[1]);}else{_51c=trim(_51c);}if(!_51e){_51e=_51c;}this._attachEvents.push(_516(_514,_51c,lang.hitch(_517,_51e)));}}}return ret;},_attach:function(node,type,func){type=type.replace(/^on/,"").toLowerCase();if(type=="dijitclick"){type=_511||(_511=_509("./a11yclick"));}else{type=_510[type]||type;}return on(node,type,func);},_detachTemplateNodes:function(){var _520=this.attachScope||this;_50a.forEach(this._attachPoints,function(_521){delete _520[_521];});this._attachPoints=[];_50a.forEach(this._attachEvents,function(_522){_522.remove();});this._attachEvents=[];},destroyRendering:function(){this._detachTemplateNodes();this.inherited(arguments);}});lang.extend(_50f,{dojoAttachEvent:"",dojoAttachPoint:""});return _512;});},"dojox/html/metrics":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/sniff","dojo/ready","dojo/_base/unload","dojo/_base/window","dojo/dom-geometry"],function(_523,lang,has,_524,_525,_526,_527){var dhm=lang.getObject("dojox.html.metrics",true);var _528=lang.getObject("dojox");dhm.getFontMeasurements=function(){var _529={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var _52a;if(has("ie")){_52a=_526.doc.documentElement.style.fontSize||"";if(!_52a){_526.doc.documentElement.style.fontSize="100%";}}var div=_526.doc.createElement("div");var ds=div.style;ds.position="absolute";ds.left="-100px";ds.top="0";ds.width="30px";ds.height="1000em";ds.borderWidth="0";ds.margin="0";ds.padding="0";ds.outline="0";ds.lineHeight="1";ds.overflow="hidden";_526.body().appendChild(div);for(var p in _529){ds.fontSize=p;_529[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}if(has("ie")){_526.doc.documentElement.style.fontSize=_52a;}_526.body().removeChild(div);div=null;return _529;};var _52b=null;dhm.getCachedFontMeasurements=function(_52c){if(_52c||!_52b){_52b=dhm.getFontMeasurements();}return _52b;};var _52d=null,_52e={};dhm.getTextBox=function(text,_52f,_530){var m,s;if(!_52d){m=_52d=_526.doc.createElement("div");m.style.whiteSpace="nowrap";var c=_526.doc.createElement("div");c.appendChild(m);s=c.style;s.overflow="scroll";s.position="absolute";s.left="0px";s.top="-10000px";s.width="1px";s.height="1px";s.visibility="hidden";s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";_526.body().appendChild(c);}else{m=_52d;}m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(arguments.length>1&&_52f){for(var i in _52f){if(i in _52e){continue;}s[i]=_52f[i];}}if(arguments.length>2&&_530){m.className=_530;}m.innerHTML=text;var box=_527.position(m);box.w=m.parentNode.scrollWidth;return box;};var _531={w:16,h:16};dhm.getScrollbar=function(){return {w:_531.w,h:_531.h};};dhm._fontResizeNode=null;dhm.initOnFontResize=function(_532){var f=dhm._fontResizeNode=_526.doc.createElement("iframe");var fs=f.style;fs.position="absolute";fs.width="5em";fs.height="10em";fs.top="-10000px";fs.display="none";if(has("ie")){f.onreadystatechange=function(){if(f.contentWindow.document.readyState=="complete"){f.onresize=f.contentWindow.parent[_528._scopeName].html.metrics._fontresize;}};}else{f.onload=function(){f.contentWindow.onresize=f.contentWindow.parent[_528._scopeName].html.metrics._fontresize;};}f.setAttribute("src","javascript:'<html><head><script>if(\"loadFirebugConsole\" in window){window.loadFirebugConsole();}</script></head><body></body></html>'");_526.body().appendChild(f);dhm.initOnFontResize=function(){};};dhm.onFontResize=function(){};dhm._fontresize=function(){dhm.onFontResize();};_525.addOnUnload(function(){var f=dhm._fontResizeNode;if(f){if(has("ie")&&f.onresize){f.onresize=null;}else{if(f.contentWindow&&f.contentWindow.onresize){f.contentWindow.onresize=null;}}dhm._fontResizeNode=null;}});_524(function(){try{var n=_526.doc.createElement("div");n.style.cssText="top:0;left:0;width:100px;height:100px;overflow:scroll;position:absolute;visibility:hidden;";_526.body().appendChild(n);_531.w=n.offsetWidth-n.clientWidth;_531.h=n.offsetHeight-n.clientHeight;_526.body().removeChild(n);delete n;}catch(e){}if("fontSizeWatch" in _523.config&&!!_523.config.fontSizeWatch){dhm.initOnFontResize();}});return dhm;});},"dojox/grid/_Builder":function(){define(["../main","dojo/_base/array","dojo/_base/lang","dojo/_base/window","dojo/_base/event","dojo/_base/sniff","dojo/_base/connect","dojo/dnd/Moveable","dojox/html/metrics","./util","dojo/_base/html","dojo/dom-geometry"],function(_533,_534,lang,win,_535,has,_536,_537,_538,util,html,_539){var dg=_533.grid;var _53a=function(td){return td.cellIndex>=0?td.cellIndex:_534.indexOf(td.parentNode.cells,td);};var _53b=function(tr){return tr.rowIndex>=0?tr.rowIndex:_534.indexOf(tr.parentNode.childNodes,tr);};var _53c=function(_53d,_53e){return _53d&&((_53d.rows||0)[_53e]||_53d.childNodes[_53e]);};var _53f=function(node){for(var n=node;n&&n.tagName!="TABLE";n=n.parentNode){}return n;};var _540=function(_541,_542){for(var n=_541;n&&_542(n);n=n.parentNode){}return n;};var _543=function(_544){var name=_544.toUpperCase();return function(node){return node.tagName!=name;};};var _545=util.rowIndexTag;var _546=util.gridViewTag;var _547=dg._Builder=lang.extend(function(view){if(view){this.view=view;this.grid=view.grid;}},{view:null,_table:"<table class=\"dojoxGridRowTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"",getTableArray:function(){var html=[this._table];if(this.view.viewWidth){html.push([" style=\"width:",this.view.viewWidth,";\""].join(""));}html.push(">");return html;},generateCellMarkup:function(_548,_549,_54a,_54b){var _54c=[],html;if(_54b){var _54d=_548.index!=_548.grid.getSortIndex()?"":_548.grid.sortInfo>0?"aria-sort=\"ascending\"":"aria-sort=\"descending\"";if(!_548.id){_548.id=this.grid.id+"Hdr"+_548.index;}html=["<th tabIndex=\"-1\" aria-readonly=\"true\" role=\"columnheader\"",_54d," id=\"",_548.id,"\""];}else{var _54e=this.grid.editable&&!_548.editable?"aria-readonly=\"true\"":"";html=["<td tabIndex=\"-1\" role=\"gridcell\"",_54e];}if(_548.colSpan){html.push(" colspan=\"",_548.colSpan,"\"");}if(_548.rowSpan){html.push(" rowspan=\"",_548.rowSpan,"\"");}html.push(" class=\"dojoxGridCell ");if(_548.classes){html.push(_548.classes," ");}if(_54a){html.push(_54a," ");}_54c.push(html.join(""));_54c.push("");html=["\" idx=\"",_548.index,"\" style=\""];if(_549&&_549[_549.length-1]!=";"){_549+=";";}html.push(_548.styles,_549||"",_548.hidden?"display:none;":"");if(_548.unitWidth){html.push("width:",_548.unitWidth,";");}_54c.push(html.join(""));_54c.push("");html=["\""];if(_548.attrs){html.push(" ",_548.attrs);}html.push(">");_54c.push(html.join(""));_54c.push("");_54c.push(_54b?"</th>":"</td>");return _54c;},isCellNode:function(_54f){return Boolean(_54f&&_54f!=win.doc&&html.attr(_54f,"idx"));},getCellNodeIndex:function(_550){return _550?Number(html.attr(_550,"idx")):-1;},getCellNode:function(_551,_552){for(var i=0,row;((row=_53c(_551.firstChild,i))&&row.cells);i++){for(var j=0,cell;(cell=row.cells[j]);j++){if(this.getCellNodeIndex(cell)==_552){return cell;}}}return null;},findCellTarget:function(_553,_554){var n=_553;while(n&&(!this.isCellNode(n)||(n.offsetParent&&_546 in n.offsetParent.parentNode&&n.offsetParent.parentNode[_546]!=this.view.id))&&(n!=_554)){n=n.parentNode;}return n!=_554?n:null;},baseDecorateEvent:function(e){e.dispatch="do"+e.type;e.grid=this.grid;e.sourceView=this.view;e.cellNode=this.findCellTarget(e.target,e.rowNode);e.cellIndex=this.getCellNodeIndex(e.cellNode);e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);},findTarget:function(_555,_556){var n=_555;while(n&&(n!=this.domNode)&&(!(_556 in n)||(_546 in n&&n[_546]!=this.view.id))){n=n.parentNode;}return (n!=this.domNode)?n:null;},findRowTarget:function(_557){return this.findTarget(_557,_545);},isIntraNodeEvent:function(e){try{return (e.cellNode&&e.relatedTarget&&html.isDescendant(e.relatedTarget,e.cellNode));}catch(x){return false;}},isIntraRowEvent:function(e){try{var row=e.relatedTarget&&this.findRowTarget(e.relatedTarget);return !row&&(e.rowIndex==-1)||row&&(e.rowIndex==row.gridRowIndex);}catch(x){return false;}},dispatchEvent:function(e){if(e.dispatch in this){return this[e.dispatch](e);}return false;},domouseover:function(e){if(e.cellNode&&(e.cellNode!=this.lastOverCellNode)){this.lastOverCellNode=e.cellNode;this.grid.onMouseOver(e);}this.grid.onMouseOverRow(e);},domouseout:function(e){if(e.cellNode&&(e.cellNode==this.lastOverCellNode)&&!this.isIntraNodeEvent(e,this.lastOverCellNode)){this.lastOverCellNode=null;this.grid.onMouseOut(e);if(!this.isIntraRowEvent(e)){this.grid.onMouseOutRow(e);}}},domousedown:function(e){if(e.cellNode){this.grid.onMouseDown(e);}this.grid.onMouseDownRow(e);},_getTextDirStyle:function(_558,_559,_55a){return "";}});var _55b=dg._ContentBuilder=lang.extend(function(view){_547.call(this,view);},_547.prototype,{update:function(){this.prepareHtml();},prepareHtml:function(){var _55c=this.grid.get,_55d=this.view.structure.cells;for(var j=0,row;(row=_55d[j]);j++){for(var i=0,cell;(cell=row[i]);i++){cell.get=cell.get||(cell.value==undefined)&&_55c;cell.markup=this.generateCellMarkup(cell,cell.cellStyles,cell.cellClasses,false);if(!this.grid.editable&&cell.editable){this.grid.editable=true;}}}},generateHtml:function(_55e,_55f){var html=this.getTableArray();var v=this.view;var _560=v.structure.cells;var item=this.grid.getItem(_55f);var dir;util.fire(this.view,"onBeforeRow",[_55f,_560]);for(var j=0,row;(row=_560[j]);j++){if(row.hidden||row.header){continue;}html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");for(var i=0,cell,m,cc,cs;(cell=row[i]);i++){m=cell.markup;cc=cell.customClasses=[];cs=cell.customStyles=[];m[5]=cell.format(_55f,item);m[1]=cc.join(" ");m[3]=cs.join(";");dir=cell.textDir||this.grid.textDir;if(dir){m[3]+=this._getTextDirStyle(dir,cell,_55f);}html.push.apply(html,m);}html.push("</tr>");}html.push("</table>");return html.join("");},decorateEvent:function(e){e.rowNode=this.findRowTarget(e.target);if(!e.rowNode){return false;}e.rowIndex=e.rowNode[_545];this.baseDecorateEvent(e);e.cell=this.grid.getCell(e.cellIndex);return true;}});var _561=dg._HeaderBuilder=lang.extend(function(view){this.moveable=null;_547.call(this,view);},_547.prototype,{_skipBogusClicks:false,overResizeWidth:4,minColWidth:1,update:function(){if(this.tableMap){this.tableMap.mapRows(this.view.structure.cells);}else{this.tableMap=new dg._TableMap(this.view.structure.cells);}},generateHtml:function(_562,_563){var dir,html=this.getTableArray(),_564=this.view.structure.cells;util.fire(this.view,"onBeforeRow",[-1,_564]);for(var j=0,row;(row=_564[j]);j++){if(row.hidden){continue;}html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");for(var i=0,cell,_565;(cell=row[i]);i++){cell.customClasses=[];cell.customStyles=[];if(this.view.simpleStructure){if(cell.draggable){if(cell.headerClasses){if(cell.headerClasses.indexOf("dojoDndItem")==-1){cell.headerClasses+=" dojoDndItem";}}else{cell.headerClasses="dojoDndItem";}}if(cell.attrs){if(cell.attrs.indexOf("dndType='gridColumn_")==-1){cell.attrs+=" dndType='gridColumn_"+this.grid.id+"'";}}else{cell.attrs="dndType='gridColumn_"+this.grid.id+"'";}}_565=this.generateCellMarkup(cell,cell.headerStyles,cell.headerClasses,true);_565[5]=(_563!=undefined?_563:_562(cell));_565[3]=cell.customStyles.join(";");dir=cell.textDir||this.grid.textDir;if(dir){_565[3]+=this._getTextDirStyle(dir,cell,_563);}_565[1]=cell.customClasses.join(" ");html.push(_565.join(""));}html.push("</tr>");}html.push("</table>");return html.join("");},getCellX:function(e){var n,x,pos;n=_540(e.target,_543("th"));if(n){pos=_539.position(n);x=e.clientX-pos.x;}else{x=e.layerX;}return x;},decorateEvent:function(e){this.baseDecorateEvent(e);e.rowIndex=-1;e.cellX=this.getCellX(e);return true;},prepareResize:function(e,mod){do{var i=e.cellIndex;e.cellNode=(i?e.cellNode.parentNode.cells[i+mod]:null);e.cellIndex=(e.cellNode?this.getCellNodeIndex(e.cellNode):-1);}while(e.cellNode&&e.cellNode.style.display=="none");return Boolean(e.cellNode);},canResize:function(e){if(!e.cellNode||e.cellNode.colSpan>1){return false;}var cell=this.grid.getCell(e.cellIndex);return !cell.noresize&&cell.canResize();},overLeftResizeArea:function(e){if(html.hasClass(win.body(),"dojoDndMove")){return false;}if(has("ie")){var tN=e.target;if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){return false;}}if(this.grid.isLeftToRight()){return (e.cellIndex>0)&&(e.cellX>0&&e.cellX<this.overResizeWidth)&&this.prepareResize(e,-1);}var t=e.cellNode&&(e.cellX>0&&e.cellX<this.overResizeWidth);return t;},overRightResizeArea:function(e){if(html.hasClass(win.body(),"dojoDndMove")){return false;}if(has("ie")){var tN=e.target;if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){return false;}}if(this.grid.isLeftToRight()){return e.cellNode&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth);}return (e.cellIndex>0)&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth)&&this.prepareResize(e,-1);},domousemove:function(e){if(!this.moveable){var c=(this.overRightResizeArea(e)?"dojoxGridColResize":(this.overLeftResizeArea(e)?"dojoxGridColResize":""));if(c&&!this.canResize(e)){c="dojoxGridColNoResize";}html.toggleClass(e.sourceView.headerNode,"dojoxGridColNoResize",(c=="dojoxGridColNoResize"));html.toggleClass(e.sourceView.headerNode,"dojoxGridColResize",(c=="dojoxGridColResize"));if(c){_535.stop(e);}}},domousedown:function(e){if(!this.moveable){if((this.overRightResizeArea(e)||this.overLeftResizeArea(e))&&this.canResize(e)){this.beginColumnResize(e);}else{this.grid.onMouseDown(e);this.grid.onMouseOverRow(e);}}},doclick:function(e){if(this._skipBogusClicks){_535.stop(e);return true;}return false;},colResizeSetup:function(e,_566){var _567=html.contentBox(e.sourceView.headerNode);if(_566){this.lineDiv=document.createElement("div");var vw=html.position(e.sourceView.headerNode,true);var _568=html.contentBox(e.sourceView.domNode);var l=e.pageX;if(!this.grid.isLeftToRight()&&has("ie")<8){l-=_538.getScrollbar().w;}html.style(this.lineDiv,{top:vw.y+"px",left:l+"px",height:(_568.h+_567.h)+"px"});html.addClass(this.lineDiv,"dojoxGridResizeColLine");this.lineDiv._origLeft=l;win.body().appendChild(this.lineDiv);}var _569=[],_56a=this.tableMap.findOverlappingNodes(e.cellNode);for(var i=0,cell;(cell=_56a[i]);i++){_569.push({node:cell,index:this.getCellNodeIndex(cell),width:cell.offsetWidth});}var view=e.sourceView;var adj=this.grid.isLeftToRight()?1:-1;var _56b=e.grid.views.views;var _56c=[];for(var j=view.idx+adj,_56d;(_56d=_56b[j]);j=j+adj){_56c.push({node:_56d.headerNode,left:window.parseInt(_56d.headerNode.style.left)});}var _56e=view.headerContentNode.firstChild;var drag={scrollLeft:e.sourceView.headerNode.scrollLeft,view:view,node:e.cellNode,index:e.cellIndex,w:html.contentBox(e.cellNode).w,vw:_567.w,table:_56e,tw:html.contentBox(_56e).w,spanners:_569,followers:_56c};return drag;},beginColumnResize:function(e){this.moverDiv=document.createElement("div");html.style(this.moverDiv,{position:"absolute",left:0});win.body().appendChild(this.moverDiv);html.addClass(this.grid.domNode,"dojoxGridColumnResizing");var m=(this.moveable=new _537(this.moverDiv));var drag=this.colResizeSetup(e,true);m.onMove=lang.hitch(this,"doResizeColumn",drag);_536.connect(m,"onMoveStop",lang.hitch(this,function(){this.endResizeColumn(drag);if(drag.node.releaseCapture){drag.node.releaseCapture();}this.moveable.destroy();delete this.moveable;this.moveable=null;html.removeClass(this.grid.domNode,"dojoxGridColumnResizing");}));if(e.cellNode.setCapture){e.cellNode.setCapture();}m.onMouseDown(e);},doResizeColumn:function(_56f,_570,_571){var _572=_571.l;var data={deltaX:_572,w:_56f.w+(this.grid.isLeftToRight()?_572:-_572),vw:_56f.vw+_572,tw:_56f.tw+_572};this.dragRecord={inDrag:_56f,mover:_570,leftTop:_571};if(data.w>=this.minColWidth){if(!_570){this.doResizeNow(_56f,data);}else{html.style(this.lineDiv,"left",(this.lineDiv._origLeft+data.deltaX)+"px");}}},endResizeColumn:function(_573){if(this.dragRecord){var _574=this.dragRecord.leftTop;var _575=this.grid.isLeftToRight()?_574.l:-_574.l;_575+=Math.max(_573.w+_575,this.minColWidth)-(_573.w+_575);if(has("webkit")&&_573.spanners.length){_575+=html._getPadBorderExtents(_573.spanners[0].node).w;}var data={deltaX:_575,w:_573.w+_575,vw:_573.vw+_575,tw:_573.tw+_575};this.doResizeNow(_573,data);delete this.dragRecord;}html.destroy(this.lineDiv);html.destroy(this.moverDiv);html.destroy(this.moverDiv);delete this.moverDiv;this._skipBogusClicks=true;_573.view.update();this._skipBogusClicks=false;this.grid.onResizeColumn(_573.index);},doResizeNow:function(_576,data){_576.view.convertColPctToFixed();if(_576.view.flexCells&&!_576.view.testFlexCells()){var t=_53f(_576.node);if(t){(t.style.width="");}}var i,s,sw,f,fl;for(i=0;(s=_576.spanners[i]);i++){sw=s.width+data.deltaX;if(sw>0){s.node.style.width=sw+"px";_576.view.setColWidth(s.index,sw);}}if(this.grid.isLeftToRight()||!has("ie")){for(i=0;(f=_576.followers[i]);i++){fl=f.left+data.deltaX;f.node.style.left=fl+"px";}}_576.node.style.width=data.w+"px";_576.view.setColWidth(_576.index,data.w);_576.view.headerNode.style.width=data.vw+"px";_576.view.setColumnsWidth(data.tw);if(!this.grid.isLeftToRight()){_576.view.headerNode.scrollLeft=_576.scrollLeft+data.deltaX;}}});dg._TableMap=lang.extend(function(rows){this.mapRows(rows);},{map:null,mapRows:function(_577){var _578=_577.length;if(!_578){return;}this.map=[];var row;for(var k=0;(row=_577[k]);k++){this.map[k]=[];}for(var j=0;(row=_577[j]);j++){for(var i=0,x=0,cell,_579,_57a;(cell=row[i]);i++){while(this.map[j][x]){x++;}this.map[j][x]={c:i,r:j};_57a=cell.rowSpan||1;_579=cell.colSpan||1;for(var y=0;y<_57a;y++){for(var s=0;s<_579;s++){this.map[j+y][x+s]=this.map[j][x];}}x+=_579;}}},dumpMap:function(){for(var j=0,row,h="";(row=this.map[j]);j++,h=""){for(var i=0,cell;(cell=row[i]);i++){h+=cell.r+","+cell.c+"   ";}}},getMapCoords:function(_57b,_57c){for(var j=0,row;(row=this.map[j]);j++){for(var i=0,cell;(cell=row[i]);i++){if(cell.c==_57c&&cell.r==_57b){return {j:j,i:i};}}}return {j:-1,i:-1};},getNode:function(_57d,_57e,_57f){var row=_57d&&_57d.rows[_57e];return row&&row.cells[_57f];},_findOverlappingNodes:function(_580,_581,_582){var _583=[];var m=this.getMapCoords(_581,_582);for(var j=0,row;(row=this.map[j]);j++){if(j==m.j){continue;}var rw=row[m.i];var n=(rw?this.getNode(_580,rw.r,rw.c):null);if(n){_583.push(n);}}return _583;},findOverlappingNodes:function(_584){return this._findOverlappingNodes(_53f(_584),_53b(_584.parentNode),_53a(_584));}});return {_Builder:_547,_HeaderBuilder:_561,_ContentBuilder:_55b};});},"dojo/dnd/Moveable":function(){define(["../_base/array","../_base/declare","../_base/lang","../dom","../dom-class","../Evented","../has","../on","../topic","../touch","./common","./Mover","../_base/window"],function(_585,_586,lang,dom,_587,_588,has,on,_589,_58a,dnd,_58b,win){var _58c;var _58d=function(){};function _58e(){if("touchAction" in document.body.style){_58c="touchAction";}else{if("msTouchAction" in document.body.style){_58c="msTouchAction";}}_58d=function _58d(node,_58f){node.style[_58c]=_58f;};_58d(arguments[0],arguments[1]);};if(has("touch-action")){_58d=_58e;}var _590=_586("dojo.dnd.Moveable",[_588],{handle:"",delay:0,skip:false,constructor:function(node,_591){this.node=dom.byId(node);_58d(this.node,"none");if(!_591){_591={};}this.handle=_591.handle?dom.byId(_591.handle):null;if(!this.handle){this.handle=this.node;}this.delay=_591.delay>0?_591.delay:0;this.skip=_591.skip;this.mover=_591.mover?_591.mover:_58b;this.events=[on(this.handle,_58a.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];},markupFactory:function(_592,node,Ctor){return new Ctor(node,_592);},destroy:function(){_585.forEach(this.events,function(_593){_593.remove();});_58d(this.node,"");this.events=this.node=this.handle=null;},onMouseDown:function(e){if(this.skip&&dnd.isFormElement(e)){return;}if(this.delay){this.events.push(on(this.handle,_58a.move,lang.hitch(this,"onMouseMove")),on(this.handle.ownerDocument,_58a.release,lang.hitch(this,"onMouseUp")));this._lastX=e.pageX;this._lastY=e.pageY;}else{this.onDragDetected(e);}e.stopPropagation();e.preventDefault();},onMouseMove:function(e){if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){this.onMouseUp(e);this.onDragDetected(e);}e.stopPropagation();e.preventDefault();},onMouseUp:function(e){for(var i=0;i<2;++i){this.events.pop().remove();}e.stopPropagation();e.preventDefault();},onSelectStart:function(e){if(!this.skip||!dnd.isFormElement(e)){e.stopPropagation();e.preventDefault();}},onDragDetected:function(e){new this.mover(this.node,e,this);},onMoveStart:function(_594){_589.publish("/dnd/move/start",_594);_587.add(win.body(),"dojoMove");_587.add(this.node,"dojoMoveItem");},onMoveStop:function(_595){_589.publish("/dnd/move/stop",_595);_587.remove(win.body(),"dojoMove");_587.remove(this.node,"dojoMoveItem");},onFirstMove:function(){},onMove:function(_596,_597){this.onMoving(_596,_597);var s=_596.node.style;s.left=_597.l+"px";s.top=_597.t+"px";this.onMoved(_596,_597);},onMoving:function(){},onMoved:function(){}});return _590;});},"dojo/dnd/Mover":function(){define(["../_base/array","../_base/declare","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(_598,_599,lang,has,win,dom,_59a,_59b,_59c,on,_59d,dnd,_59e){return _599("dojo.dnd.Mover",[_59c],{constructor:function(node,e,host){this.node=dom.byId(node);this.marginBox={l:e.pageX,t:e.pageY};this.mouseButton=e.button;var h=(this.host=host),d=node.ownerDocument;function _59f(e){e.preventDefault();e.stopPropagation();};this.events=[on(d,_59d.move,lang.hitch(this,"onFirstMove")),on(d,_59d.move,lang.hitch(this,"onMouseMove")),on(d,_59d.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",_59f),on(d.body,"selectstart",_59f)];_59e.autoScrollStart(d);if(h&&h.onMoveStart){h.onMoveStart(this);}},onMouseMove:function(e){_59e.autoScroll(e);var m=this.marginBox;this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);e.preventDefault();e.stopPropagation();},onMouseUp:function(e){if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){this.destroy();}e.preventDefault();e.stopPropagation();},onFirstMove:function(e){var s=this.node.style,l,t,h=this.host;switch(s.position){case "relative":case "absolute":l=Math.round(parseFloat(s.left))||0;t=Math.round(parseFloat(s.top))||0;break;default:s.position="absolute";var m=_59a.getMarginBox(this.node);var b=win.doc.body;var bs=_59b.getComputedStyle(b);var bm=_59a.getMarginBox(b,bs);var bc=_59a.getContentBox(b,bs);l=m.l-(bc.l-bm.l);t=m.t-(bc.t-bm.t);break;}this.marginBox.l=l-this.marginBox.l;this.marginBox.t=t-this.marginBox.t;if(h&&h.onFirstMove){h.onFirstMove(this,e);}this.events.shift().remove();},destroy:function(){_598.forEach(this.events,function(_5a0){_5a0.remove();});var h=this.host;if(h&&h.onMoveStop){h.onMoveStop(this);}this.events=this.node=this.host=null;}});});},"dojox/grid/_ViewManager":function(){define(["dojo/_base/declare","dojo/_base/sniff","dojo/dom-class"],function(_5a1,has,_5a2){return _5a1("dojox.grid._ViewManager",null,{constructor:function(_5a3){this.grid=_5a3;},defaultWidth:200,views:[],resize:function(){this.onEach("resize");},render:function(){this.onEach("render");},addView:function(_5a4){_5a4.idx=this.views.length;this.views.push(_5a4);},destroyViews:function(){for(var i=0,v;v=this.views[i];i++){v.destroy();}this.views=[];},getContentNodes:function(){var _5a5=[];for(var i=0,v;v=this.views[i];i++){_5a5.push(v.contentNode);}return _5a5;},forEach:function(_5a6){for(var i=0,v;v=this.views[i];i++){_5a6(v,i);}},onEach:function(_5a7,_5a8){_5a8=_5a8||[];for(var i=0,v;v=this.views[i];i++){if(_5a7 in v){v[_5a7].apply(v,_5a8);}}},normalizeHeaderNodeHeight:function(){var _5a9=[];for(var i=0,v;(v=this.views[i]);i++){if(v.headerContentNode.firstChild){_5a9.push(v.headerContentNode);}}this.normalizeRowNodeHeights(_5a9);},normalizeRowNodeHeights:function(_5aa){var h=0;var _5ab=[];if(this.grid.rowHeight){h=this.grid.rowHeight;}else{if(_5aa.length<=1){return;}for(var i=0,n;(n=_5aa[i]);i++){if(!_5a2.contains(n,"dojoxGridNonNormalizedCell")){_5ab[i]=n.firstChild.offsetHeight;h=Math.max(h,_5ab[i]);}}h=(h>=0?h:0);if((has("mozilla")||has("ie")>8)&&h){h++;}}for(i=0;(n=_5aa[i]);i++){if(_5ab[i]!=h){n.firstChild.style.height=h+"px";}}},resetHeaderNodeHeight:function(){for(var i=0,v,n;(v=this.views[i]);i++){n=v.headerContentNode.firstChild;if(n){n.style.height="";}}},renormalizeRow:function(_5ac){var _5ad=[];for(var i=0,v,n;(v=this.views[i])&&(n=v.getRowNode(_5ac));i++){n.firstChild.style.height="";_5ad.push(n);}this.normalizeRowNodeHeights(_5ad);},getViewWidth:function(_5ae){return this.views[_5ae].getWidth()||this.defaultWidth;},measureHeader:function(){this.resetHeaderNodeHeight();this.forEach(function(_5af){_5af.headerContentNode.style.height="";});var h=0;this.forEach(function(_5b0){h=Math.max(_5b0.headerNode.offsetHeight,h);});return h;},measureContent:function(){var h=0;this.forEach(function(_5b1){h=Math.max(_5b1.domNode.offsetHeight,h);});return h;},findClient:function(_5b2){var c=this.grid.elasticView||-1;if(c<0){for(var i=1,v;(v=this.views[i]);i++){if(v.viewWidth){for(i=1;(v=this.views[i]);i++){if(!v.viewWidth){c=i;break;}}break;}}}if(c<0){c=Math.floor(this.views.length/2);}return c;},arrange:function(l,w){var i,v,vw,len=this.views.length,self=this;var c=(w<=0?len:this.findClient());var _5b3=function(v,l){var ds=v.domNode.style;var hs=v.headerNode.style;if(!self.grid.isLeftToRight()){ds.right=l+"px";if(has("ff")<4){hs.right=l+v.getScrollbarWidth()+"px";}else{hs.right=l+"px";}if(!has("webkit")&&hs.width!="auto"){hs.width=parseInt(hs.width,10)-v.getScrollbarWidth()+"px";}}else{ds.left=l+"px";hs.left=l+"px";}ds.top=0+"px";hs.top=0;};for(i=0;(v=this.views[i])&&(i<c);i++){vw=this.getViewWidth(i);v.setSize(vw,0);_5b3(v,l);if(v.headerContentNode&&v.headerContentNode.firstChild){vw=v.getColumnsWidth()+v.getScrollbarWidth();}else{vw=v.domNode.offsetWidth;}l+=vw;}i++;var r=w;for(var j=len-1;(v=this.views[j])&&(i<=j);j--){vw=this.getViewWidth(j);v.setSize(vw,0);vw=v.domNode.offsetWidth;r-=vw;_5b3(v,r);}if(c<len){v=this.views[c];vw=Math.max(1,r-l);v.setSize(vw+"px",0);_5b3(v,l);}return l;},renderRow:function(_5b4,_5b5,_5b6){var _5b7=[];for(var i=0,v,n,_5b8;(v=this.views[i])&&(n=_5b5[i]);i++){_5b8=v.renderRow(_5b4);n.appendChild(_5b8);_5b7.push(_5b8);}if(!_5b6){this.normalizeRowNodeHeights(_5b7);}},rowRemoved:function(_5b9){this.onEach("rowRemoved",[_5b9]);},updateRow:function(_5ba,_5bb){for(var i=0,v;v=this.views[i];i++){v.updateRow(_5ba);}if(!_5bb){this.renormalizeRow(_5ba);}},updateRowStyles:function(_5bc){this.onEach("updateRowStyles",[_5bc]);},setScrollTop:function(_5bd){var top=_5bd;for(var i=0,v;v=this.views[i];i++){top=v.setScrollTop(_5bd);if(has("ie")&&v.headerNode&&v.scrollboxNode){v.headerNode.scrollLeft=v.scrollboxNode.scrollLeft;}}return top;},getFirstScrollingView:function(){for(var i=0,v;(v=this.views[i]);i++){if(v.hasHScrollbar()||v.hasVScrollbar()){return v;}}return null;}});});},"dojox/grid/_RowManager":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/dom-class"],function(_5be,lang,_5bf){var _5c0=function(_5c1,_5c2){if(_5c1.style.cssText==undefined){_5c1.setAttribute("style",_5c2);}else{_5c1.style.cssText=_5c2;}};return _5be("dojox.grid._RowManager",null,{constructor:function(_5c3){this.grid=_5c3;},linesToEms:2,overRow:-2,prepareStylingRow:function(_5c4,_5c5){return {index:_5c4,node:_5c5,odd:Boolean(_5c4&1),selected:!!this.grid.selection.isSelected(_5c4),over:this.isOver(_5c4),customStyles:"",customClasses:"dojoxGridRow"};},styleRowNode:function(_5c6,_5c7){var row=this.prepareStylingRow(_5c6,_5c7);this.grid.onStyleRow(row);this.applyStyles(row);},applyStyles:function(_5c8){var i=_5c8;i.node.className=i.customClasses;var h=i.node.style.height;_5c0(i.node,i.customStyles+";"+(i.node._style||""));i.node.style.height=h;},updateStyles:function(_5c9){this.grid.updateRowStyles(_5c9);},setOverRow:function(_5ca){var last=this.overRow;this.overRow=_5ca;if((last!=this.overRow)&&(lang.isString(last)||last>=0)){this.updateStyles(last);}this.updateStyles(this.overRow);},isOver:function(_5cb){return (this.overRow==_5cb&&!_5bf.contains(this.grid.domNode,"dojoxGridColumnResizing"));}});});},"dojox/grid/_FocusManager":function(){define(["dojo/_base/array","dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/event","dojo/_base/sniff","dojo/query","./util","dojo/_base/html"],function(_5cc,lang,_5cd,_5ce,_5cf,has,_5d0,util,html){return _5cd("dojox.grid._FocusManager",null,{constructor:function(_5d1){this.grid=_5d1;this.cell=null;this.rowIndex=-1;this._connects=[];this._headerConnects=[];this.headerMenu=this.grid.headerMenu;this._connects.push(_5ce.connect(this.grid.domNode,"onfocus",this,"doFocus"));this._connects.push(_5ce.connect(this.grid.domNode,"onblur",this,"doBlur"));this._connects.push(_5ce.connect(this.grid.domNode,"mousedown",this,"_mouseDown"));this._connects.push(_5ce.connect(this.grid.domNode,"mouseup",this,"_mouseUp"));this._connects.push(_5ce.connect(this.grid.domNode,"oncontextmenu",this,"doContextMenu"));this._connects.push(_5ce.connect(this.grid.lastFocusNode,"onfocus",this,"doLastNodeFocus"));this._connects.push(_5ce.connect(this.grid.lastFocusNode,"onblur",this,"doLastNodeBlur"));this._connects.push(_5ce.connect(this.grid,"_onFetchComplete",this,"_delayedCellFocus"));this._connects.push(_5ce.connect(this.grid,"postrender",this,"_delayedHeaderFocus"));},destroy:function(){_5cc.forEach(this._connects,_5ce.disconnect);_5cc.forEach(this._headerConnects,_5ce.disconnect);delete this.grid;delete this.cell;},_colHeadNode:null,_colHeadFocusIdx:null,_contextMenuBindNode:null,tabbingOut:false,focusClass:"dojoxGridCellFocus",focusView:null,initFocusView:function(){this.focusView=this.grid.views.getFirstScrollingView()||this.focusView||this.grid.views.views[0];this._initColumnHeaders();},isFocusCell:function(_5d2,_5d3){return (this.cell==_5d2)&&(this.rowIndex==_5d3);},isLastFocusCell:function(){if(this.cell){return (this.rowIndex==this.grid.rowCount-1)&&(this.cell.index==this.grid.layout.cellCount-1);}return false;},isFirstFocusCell:function(){if(this.cell){return (this.rowIndex===0)&&(this.cell.index===0);}return false;},isNoFocusCell:function(){return (this.rowIndex<0)||!this.cell;},isNavHeader:function(){return (!!this._colHeadNode);},getHeaderIndex:function(){if(this._colHeadNode){return _5cc.indexOf(this._findHeaderCells(),this._colHeadNode);}else{return -1;}},_focusifyCellNode:function(_5d4){var n=this.cell&&this.cell.getNode(this.rowIndex);if(n){html.toggleClass(n,this.focusClass,_5d4);if(_5d4){var sl=this.scrollIntoView();try{if(has("webkit")||!this.grid.edit.isEditing()){util.fire(n,"focus");if(sl){this.cell.view.scrollboxNode.scrollLeft=sl;}}}catch(e){}}}},_delayedCellFocus:function(){if(this.isNavHeader()||!this.grid.focused){return;}var n=this.cell&&this.cell.getNode(this.rowIndex);if(n){try{if(!this.grid.edit.isEditing()){html.toggleClass(n,this.focusClass,true);if(this._colHeadNode){this.blurHeader();}util.fire(n,"focus");}}catch(e){}}},_delayedHeaderFocus:function(){if(this.isNavHeader()){this.focusHeader();}},_initColumnHeaders:function(){_5cc.forEach(this._headerConnects,_5ce.disconnect);this._headerConnects=[];var _5d5=this._findHeaderCells();for(var i=0;i<_5d5.length;i++){this._headerConnects.push(_5ce.connect(_5d5[i],"onfocus",this,"doColHeaderFocus"));this._headerConnects.push(_5ce.connect(_5d5[i],"onblur",this,"doColHeaderBlur"));}},_findHeaderCells:function(){var _5d6=_5d0("th",this.grid.viewsHeaderNode);var _5d7=[];for(var i=0;i<_5d6.length;i++){var _5d8=_5d6[i];var _5d9=html.hasAttr(_5d8,"tabIndex");var _5da=html.attr(_5d8,"tabIndex");if(_5d9&&_5da<0){_5d7.push(_5d8);}}return _5d7;},_setActiveColHeader:function(_5db,_5dc,_5dd){this.grid.domNode.setAttribute("aria-activedescendant",_5db.id);if(_5dd!=null&&_5dd>=0&&_5dd!=_5dc){html.toggleClass(this._findHeaderCells()[_5dd],this.focusClass,false);}html.toggleClass(_5db,this.focusClass,true);this._colHeadNode=_5db;this._colHeadFocusIdx=_5dc;this._scrollHeader(this._colHeadFocusIdx);},scrollIntoView:function(){var info=(this.cell?this._scrollInfo(this.cell):null);if(!info||!info.s){return null;}var rt=this.grid.scroller.findScrollTop(this.rowIndex);if(info.n&&info.sr){if(info.n.offsetLeft+info.n.offsetWidth>info.sr.l+info.sr.w){info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;}else{if(info.n.offsetLeft<info.sr.l){info.s.scrollLeft=info.n.offsetLeft;}}}if(info.r&&info.sr){if(rt+info.r.offsetHeight>info.sr.t+info.sr.h){this.grid.setScrollTop(rt+info.r.offsetHeight-info.sr.h);}else{if(rt<info.sr.t){this.grid.setScrollTop(rt);}}}return info.s.scrollLeft;},_scrollInfo:function(cell,_5de){if(cell){var cl=cell,sbn=cl.view.scrollboxNode,sbnr={w:sbn.clientWidth,l:sbn.scrollLeft,t:sbn.scrollTop,h:sbn.clientHeight},rn=cl.view.getRowNode(this.rowIndex);return {c:cl,s:sbn,sr:sbnr,n:(_5de?_5de:cell.getNode(this.rowIndex)),r:rn};}return null;},_scrollHeader:function(_5df){var info=null;if(this._colHeadNode){var cell=this.grid.getCell(_5df);if(!cell){return;}info=this._scrollInfo(cell,cell.getNode(0));}if(info&&info.s&&info.sr&&info.n){var _5e0=info.sr.l+info.sr.w;if(info.n.offsetLeft+info.n.offsetWidth>_5e0){info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;}else{if(info.n.offsetLeft<info.sr.l){info.s.scrollLeft=info.n.offsetLeft;}else{if(has("ie")<=7&&cell&&cell.view.headerNode){cell.view.headerNode.scrollLeft=info.s.scrollLeft;}}}}},_isHeaderHidden:function(){var _5e1=this.focusView;if(!_5e1){for(var i=0,_5e2;(_5e2=this.grid.views.views[i]);i++){if(_5e2.headerNode){_5e1=_5e2;break;}}}return (_5e1&&html.getComputedStyle(_5e1.headerNode).display=="none");},colSizeAdjust:function(e,_5e3,_5e4){var _5e5=this._findHeaderCells();var view=this.focusView;if(!view||!view.header.tableMap.map){for(var i=0,_5e6;(_5e6=this.grid.views.views[i]);i++){if(_5e6.header.tableMap.map){view=_5e6;break;}}}var _5e7=_5e5[_5e3];if(!view||(_5e3==_5e5.length-1&&_5e3===0)){return;}view.content.baseDecorateEvent(e);e.cellNode=_5e7;e.cellIndex=view.content.getCellNodeIndex(e.cellNode);e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);if(view.header.canResize(e)){var _5e8={l:_5e4};var drag=view.header.colResizeSetup(e,false);view.header.doResizeColumn(drag,null,_5e8);view.update();}},styleRow:function(_5e9){return;},setFocusIndex:function(_5ea,_5eb){this.setFocusCell(this.grid.getCell(_5eb),_5ea);},setFocusCell:function(_5ec,_5ed){if(_5ec&&!this.isFocusCell(_5ec,_5ed)){this.tabbingOut=false;if(this._colHeadNode){this.blurHeader();}this._colHeadNode=this._colHeadFocusIdx=null;this.focusGridView();this._focusifyCellNode(false);this.cell=_5ec;this.rowIndex=_5ed;this._focusifyCellNode(true);}if(has("opera")){setTimeout(lang.hitch(this.grid,"onCellFocus",this.cell,this.rowIndex),1);}else{this.grid.onCellFocus(this.cell,this.rowIndex);}},next:function(){if(this.cell){var row=this.rowIndex,col=this.cell.index+1,cc=this.grid.layout.cellCount-1,rc=this.grid.rowCount-1;if(col>cc){col=0;row++;}if(row>rc){col=cc;row=rc;}if(this.grid.edit.isEditing()){var _5ee=this.grid.getCell(col);if(!this.isLastFocusCell()&&(!_5ee.editable||this.grid.canEdit&&!this.grid.canEdit(_5ee,row))){this.cell=_5ee;this.rowIndex=row;this.next();return;}}this.setFocusIndex(row,col);}},previous:function(){if(this.cell){var row=(this.rowIndex||0),col=(this.cell.index||0)-1;if(col<0){col=this.grid.layout.cellCount-1;row--;}if(row<0){row=0;col=0;}if(this.grid.edit.isEditing()){var _5ef=this.grid.getCell(col);if(!this.isFirstFocusCell()&&!_5ef.editable){this.cell=_5ef;this.rowIndex=row;this.previous();return;}}this.setFocusIndex(row,col);}},move:function(_5f0,_5f1){var _5f2=_5f1<0?-1:1;if(this.isNavHeader()){var _5f3=this._findHeaderCells();var _5f4=currentIdx=_5cc.indexOf(_5f3,this._colHeadNode);currentIdx+=_5f1;while(currentIdx>=0&&currentIdx<_5f3.length&&_5f3[currentIdx].style.display=="none"){currentIdx+=_5f2;}if((currentIdx>=0)&&(currentIdx<_5f3.length)){this._setActiveColHeader(_5f3[currentIdx],currentIdx,_5f4);}}else{if(this.cell){var sc=this.grid.scroller,r=this.rowIndex,rc=this.grid.rowCount-1,row=Math.min(rc,Math.max(0,r+_5f0));if(_5f0){if(_5f0>0){if(row>sc.getLastPageRow(sc.page)){this.grid.setScrollTop(this.grid.scrollTop+sc.findScrollTop(row)-sc.findScrollTop(r));}}else{if(_5f0<0){if(row<=sc.getPageRow(sc.page)){this.grid.setScrollTop(this.grid.scrollTop-sc.findScrollTop(r)-sc.findScrollTop(row));}}}}var cc=this.grid.layout.cellCount-1,i=this.cell.index,col=Math.min(cc,Math.max(0,i+_5f1));var cell=this.grid.getCell(col);while(col>=0&&col<cc&&cell&&cell.hidden===true){col+=_5f2;cell=this.grid.getCell(col);}if(!cell||cell.hidden===true){col=i;}var n=cell.getNode(row);if(!n&&_5f0){if((row+_5f0)>=0&&(row+_5f0)<=rc){this.move(_5f0>0?++_5f0:--_5f0,_5f1);}return;}else{if((!n||html.style(n,"display")==="none")&&_5f1){if((col+_5f1)>=0&&(col+_5f1)<=cc){this.move(_5f0,_5f1>0?++_5f1:--_5f1);}return;}}this.setFocusIndex(row,col);if(_5f0){this.grid.updateRow(r);}}}},previousKey:function(e){if(this.grid.edit.isEditing()){_5cf.stop(e);this.previous();}else{if(!this.isNavHeader()&&!this._isHeaderHidden()){this.grid.domNode.focus();_5cf.stop(e);}else{this.tabOut(this.grid.domNode);if(this._colHeadFocusIdx!=null){html.toggleClass(this._findHeaderCells()[this._colHeadFocusIdx],this.focusClass,false);this._colHeadFocusIdx=null;}this._focusifyCellNode(false);}}},nextKey:function(e){var _5f5=(this.grid.rowCount===0);if(e.target===this.grid.domNode&&this._colHeadFocusIdx==null){this.focusHeader();_5cf.stop(e);}else{if(this.isNavHeader()){this.blurHeader();if(!this.findAndFocusGridCell()){this.tabOut(this.grid.lastFocusNode);}this._colHeadNode=this._colHeadFocusIdx=null;}else{if(this.grid.edit.isEditing()){_5cf.stop(e);this.next();}else{this.tabOut(this.grid.lastFocusNode);}}}},tabOut:function(_5f6){this.tabbingOut=true;_5f6.focus();},focusGridView:function(){util.fire(this.focusView,"focus");},focusGrid:function(_5f7){this.focusGridView();this._focusifyCellNode(true);},findAndFocusGridCell:function(){var _5f8=true;var _5f9=(this.grid.rowCount===0);if(this.isNoFocusCell()&&!_5f9){var _5fa=0;var cell=this.grid.getCell(_5fa);if(cell.hidden){_5fa=this.isNavHeader()?this._colHeadFocusIdx:0;}this.setFocusIndex(0,_5fa);}else{if(this.cell&&!_5f9){if(this.focusView&&!this.focusView.rowNodes[this.rowIndex]){this.grid.scrollToRow(this.rowIndex);}this.focusGrid();}else{_5f8=false;}}this._colHeadNode=this._colHeadFocusIdx=null;return _5f8;},focusHeader:function(){var _5fb=this._findHeaderCells();var _5fc=this._colHeadFocusIdx;if(this._isHeaderHidden()){this.findAndFocusGridCell();}else{if(!this._colHeadFocusIdx){if(this.isNoFocusCell()){this._colHeadFocusIdx=0;}else{this._colHeadFocusIdx=this.cell.index;}}}this._colHeadNode=_5fb[this._colHeadFocusIdx];while(this._colHeadNode&&this._colHeadFocusIdx>=0&&this._colHeadFocusIdx<_5fb.length&&this._colHeadNode.style.display=="none"){this._colHeadFocusIdx++;this._colHeadNode=_5fb[this._colHeadFocusIdx];}if(this._colHeadNode&&this._colHeadNode.style.display!="none"){if(this.headerMenu&&this._contextMenuBindNode!=this.grid.domNode){this.headerMenu.unBindDomNode(this.grid.viewsHeaderNode);this.headerMenu.bindDomNode(this.grid.domNode);this._contextMenuBindNode=this.grid.domNode;}this._setActiveColHeader(this._colHeadNode,this._colHeadFocusIdx,_5fc);this._scrollHeader(this._colHeadFocusIdx);this._focusifyCellNode(false);}else{this.findAndFocusGridCell();}},blurHeader:function(){html.removeClass(this._colHeadNode,this.focusClass);html.removeAttr(this.grid.domNode,"aria-activedescendant");if(this.headerMenu&&this._contextMenuBindNode==this.grid.domNode){var _5fd=this.grid.viewsHeaderNode;this.headerMenu.unBindDomNode(this.grid.domNode);this.headerMenu.bindDomNode(_5fd);this._contextMenuBindNode=_5fd;}},doFocus:function(e){if(e&&e.target!=e.currentTarget){_5cf.stop(e);return;}if(this._clickFocus){return;}if(!this.tabbingOut){this.focusHeader();}this.tabbingOut=false;_5cf.stop(e);},doBlur:function(e){_5cf.stop(e);},doContextMenu:function(e){if(!this.headerMenu){_5cf.stop(e);}},doLastNodeFocus:function(e){if(this.tabbingOut){this._focusifyCellNode(false);}else{if(this.grid.rowCount>0){if(this.isNoFocusCell()){this.setFocusIndex(0,0);}this._focusifyCellNode(true);}else{this.focusHeader();}}this.tabbingOut=false;_5cf.stop(e);},doLastNodeBlur:function(e){_5cf.stop(e);},doColHeaderFocus:function(e){this._setActiveColHeader(e.target,html.attr(e.target,"idx"),this._colHeadFocusIdx);this._scrollHeader(this.getHeaderIndex());_5cf.stop(e);},doColHeaderBlur:function(e){html.toggleClass(e.target,this.focusClass,false);},_mouseDown:function(e){this._clickFocus=dojo.some(this.grid.views.views,function(v){return v.scrollboxNode===e.target;});},_mouseUp:function(e){this._clickFocus=false;}});});},"dojox/grid/_EditManager":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect","dojo/_base/sniff","./util"],function(lang,_5fe,_5ff,_600,has,util){return _5ff("dojox.grid._EditManager",null,{constructor:function(_601){this.grid=_601;this.connections=!has("ie")?[]:[_600.connect(document.body,"onfocus",lang.hitch(this,"_boomerangFocus"))];this.connections.push(_600.connect(this.grid,"onBlur",this,"apply"));this.connections.push(_600.connect(this.grid,"prerender",this,"_onPreRender"));},info:{},destroy:function(){_5fe.forEach(this.connections,_600.disconnect);},cellFocus:function(_602,_603){if(this.grid.singleClickEdit||this.isEditRow(_603)){this.setEditCell(_602,_603);}else{this.apply();}if(this.isEditing()||(_602&&_602.editable&&_602.alwaysEditing)){this._focusEditor(_602,_603);}},rowClick:function(e){if(this.isEditing()&&!this.isEditRow(e.rowIndex)){this.apply();}},styleRow:function(_604){if(_604.index==this.info.rowIndex){_604.customClasses+=" dojoxGridRowEditing";}},dispatchEvent:function(e){var c=e.cell,ed=(c&&c["editable"])?c:0;return ed&&ed.dispatchEvent(e.dispatch,e);},isEditing:function(){return this.info.rowIndex!==undefined;},isEditCell:function(_605,_606){return (this.info.rowIndex===_605)&&(this.info.cell.index==_606);},isEditRow:function(_607){return this.info.rowIndex===_607;},setEditCell:function(_608,_609){if(!this.isEditCell(_609,_608.index)&&this.grid.canEdit&&this.grid.canEdit(_608,_609)){this.start(_608,_609,this.isEditRow(_609)||_608.editable);}},_focusEditor:function(_60a,_60b){util.fire(_60a,"focus",[_60b]);},focusEditor:function(){if(this.isEditing()){this._focusEditor(this.info.cell,this.info.rowIndex);}},_boomerangWindow:500,_shouldCatchBoomerang:function(){return this._catchBoomerang>new Date().getTime();},_boomerangFocus:function(){if(this._shouldCatchBoomerang()){this.grid.focus.focusGrid();this.focusEditor();this._catchBoomerang=0;}},_doCatchBoomerang:function(){if(has("ie")){this._catchBoomerang=new Date().getTime()+this._boomerangWindow;}},start:function(_60c,_60d,_60e){if(!this._isValidInput()){return;}this.grid.beginUpdate();this.editorApply();if(this.isEditing()&&!this.isEditRow(_60d)){this.applyRowEdit();this.grid.updateRow(_60d);}if(_60e){this.info={cell:_60c,rowIndex:_60d};this.grid.doStartEdit(_60c,_60d);this.grid.updateRow(_60d);}else{this.info={};}this.grid.endUpdate();this.grid.focus.focusGrid();this._focusEditor(_60c,_60d);this._doCatchBoomerang();},_editorDo:function(_60f){var c=this.info.cell;if(c&&c.editable){c[_60f](this.info.rowIndex);}},editorApply:function(){this._editorDo("apply");},editorCancel:function(){this._editorDo("cancel");},applyCellEdit:function(_610,_611,_612){if(this.grid.canEdit(_611,_612)){this.grid.doApplyCellEdit(_610,_612,_611.field);}},applyRowEdit:function(){this.grid.doApplyEdit(this.info.rowIndex,this.info.cell.field);},apply:function(){if(this.isEditing()&&this._isValidInput()){this.grid.beginUpdate();this.editorApply();this.applyRowEdit();this.info={};this.grid.endUpdate();this.grid.focus.focusGrid();this._doCatchBoomerang();}},cancel:function(){if(this.isEditing()){this.grid.beginUpdate();this.editorCancel();this.info={};this.grid.endUpdate();this.grid.focus.focusGrid();this._doCatchBoomerang();}},save:function(_613,_614){var c=this.info.cell;if(this.isEditRow(_613)&&(!_614||c.view==_614)&&c.editable){c.save(c,this.info.rowIndex);}},restore:function(_615,_616){var c=this.info.cell;if(this.isEditRow(_616)&&c.view==_615&&c.editable){c.restore(this.info.rowIndex);}},_isValidInput:function(){var w=(this.info.cell||{}).widget;if(!w||!w.isValid){return true;}w.focused=true;return w.isValid(true);},_onPreRender:function(){if(this.isEditing()){this.info.value=this.info.cell.getValue();}}});});},"dojox/grid/Selection":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/dom-attr"],function(_617,_618,lang,_619){return _617("dojox.grid.Selection",null,{constructor:function(_61a){this.grid=_61a;this.selected=[];this.setMode(_61a.selectionMode);},mode:"extended",selected:null,updating:0,selectedIndex:-1,rangeStartIndex:-1,setMode:function(mode){if(this.selected.length){this.deselectAll();}if(mode!="extended"&&mode!="multiple"&&mode!="single"&&mode!="none"){this.mode="extended";}else{this.mode=mode;}},onCanSelect:function(_61b){return this.grid.onCanSelect(_61b);},onCanDeselect:function(_61c){return this.grid.onCanDeselect(_61c);},onSelected:function(_61d){},onDeselected:function(_61e){},onChanging:function(){},onChanged:function(){},isSelected:function(_61f){if(this.mode=="none"){return false;}return this.selected[_61f];},getFirstSelected:function(){if(!this.selected.length||this.mode=="none"){return -1;}for(var i=0,l=this.selected.length;i<l;i++){if(this.selected[i]){return i;}}return -1;},getNextSelected:function(_620){if(this.mode=="none"){return -1;}for(var i=_620+1,l=this.selected.length;i<l;i++){if(this.selected[i]){return i;}}return -1;},getSelected:function(){var _621=[];for(var i=0,l=this.selected.length;i<l;i++){if(this.selected[i]){_621.push(i);}}return _621;},getSelectedCount:function(){var c=0;for(var i=0;i<this.selected.length;i++){if(this.selected[i]){c++;}}return c;},_beginUpdate:function(){if(this.updating===0){this.onChanging();}this.updating++;},_endUpdate:function(){this.updating--;if(this.updating===0){this.onChanged();}},select:function(_622){if(this.mode=="none"){return;}if(this.mode!="multiple"){this.deselectAll(_622);this.addToSelection(_622);}else{this.toggleSelect(_622);}},addToSelection:function(_623){if(this.mode=="none"){return;}if(lang.isArray(_623)){_618.forEach(_623,this.addToSelection,this);return;}_623=Number(_623);if(this.selected[_623]){this.selectedIndex=_623;}else{if(this.onCanSelect(_623)!==false){this.selectedIndex=_623;var _624=this.grid.getRowNode(_623);if(_624){_619.set(_624,"aria-selected","true");}this._beginUpdate();this.selected[_623]=true;this.onSelected(_623);this._endUpdate();}}},deselect:function(_625){if(this.mode=="none"){return;}if(lang.isArray(_625)){_618.forEach(_625,this.deselect,this);return;}_625=Number(_625);if(this.selectedIndex==_625){this.selectedIndex=-1;}if(this.selected[_625]){if(this.onCanDeselect(_625)===false){return;}var _626=this.grid.getRowNode(_625);if(_626){_619.set(_626,"aria-selected","false");}this._beginUpdate();delete this.selected[_625];this.onDeselected(_625);this._endUpdate();}},setSelected:function(_627,_628){this[(_628?"addToSelection":"deselect")](_627);},toggleSelect:function(_629){if(lang.isArray(_629)){_618.forEach(_629,this.toggleSelect,this);return;}this.setSelected(_629,!this.selected[_629]);},_range:function(_62a,inTo,func){var s=(_62a>=0?_62a:inTo),e=inTo;if(s>e){e=s;s=inTo;}for(var i=s;i<=e;i++){func(i);}},selectRange:function(_62b,inTo){this._range(_62b,inTo,lang.hitch(this,"addToSelection"));},deselectRange:function(_62c,inTo){this._range(_62c,inTo,lang.hitch(this,"deselect"));},insert:function(_62d){this.selected.splice(_62d,0,false);if(this.selectedIndex>=_62d){this.selectedIndex++;}},remove:function(_62e){this.selected.splice(_62e,1);if(this.selectedIndex>=_62e){this.selectedIndex--;}},deselectAll:function(_62f){for(var i in this.selected){if((i!=_62f)&&(this.selected[i]===true)){this.deselect(i);}}},clickSelect:function(_630,_631,_632){if(this.mode=="none"){return;}this._beginUpdate();if(this.mode!="extended"){this.select(_630);}else{if(!_632||this.rangeStartIndex<0){this.rangeStartIndex=_630;}if(!_631){this.deselectAll(_630);}if(_632){this.selectRange(this.rangeStartIndex,_630);}else{if(_631){this.toggleSelect(_630);}else{this.addToSelection(_630);}}}this._endUpdate();},clickSelectEvent:function(e){this.clickSelect(e.rowIndex,dojo.isCopyKey(e),e.shiftKey);},clear:function(){this._beginUpdate();this.deselectAll();this._endUpdate();}});});},"dijit/CheckedMenuItem":function(){define(["dojo/_base/declare","dojo/dom-class","./MenuItem","dojo/text!./templates/CheckedMenuItem.html","./hccss"],function(_633,_634,_635,_636){return _633("dijit.CheckedMenuItem",_635,{baseClass:"dijitMenuItem dijitCheckedMenuItem",templateString:_636,checked:false,_setCheckedAttr:function(_637){this.domNode.setAttribute("aria-checked",_637?"true":"false");this._set("checked",_637);},iconClass:"",role:"menuitemcheckbox",checkedChar:"&#10003;",onChange:function(){},_onClick:function(evt){if(!this.disabled){this.set("checked",!this.checked);this.onChange(this.checked);}this.onClick(evt);}});});},"dijit/MenuItem":function(){define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/sniff","dojo/_base/lang","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_638,dom,_639,_63a,_63b,has,lang,_63c,_63d,_63e,_63f,_640){var _641=_638("dijit.MenuItem"+(has("dojo-bidi")?"_NoBidi":""),[_63c,_63d,_63e,_63f],{templateString:_640,baseClass:"dijitMenuItem",label:"",_setLabelAttr:function(val){this._set("label",val);var _642="";var text;var ndx=val.search(/{\S}/);if(ndx>=0){_642=val.charAt(ndx+1);var _643=val.substr(0,ndx);var _644=val.substr(ndx+3);text=_643+_642+_644;val=_643+"<span class=\"dijitMenuItemShortcutKey\">"+_642+"</span>"+_644;}else{text=val;}this.domNode.setAttribute("aria-label",text+(this.accelKey?" "+this.accelKey:""));this.containerNode.innerHTML=val;this._set("shortcutKey",_642);},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_645){if(_645&&!("label" in this.params)){this._set("label",_645.innerHTML);}},buildRendering:function(){this.inherited(arguments);var _646=this.id+"_text";_639.set(this.containerNode,"id",_646);if(this.accelKeyNode){_639.set(this.accelKeyNode,"id",this.id+"_accel");}dom.setSelectable(this.domNode,false);},onClick:function(){},focus:function(){try{if(has("ie")==8){this.containerNode.focus();}this.focusNode.focus();}catch(e){}},_setSelected:function(_647){_63a.toggle(this.domNode,"dijitMenuItemSelected",_647);},setLabel:function(_648){_63b.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_648);},setDisabled:function(_649){_63b.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");this.set("disabled",_649);},_setDisabledAttr:function(_64a){this.focusNode.setAttribute("aria-disabled",_64a?"true":"false");this._set("disabled",_64a);},_setAccelKeyAttr:function(_64b){if(this.accelKeyNode){this.accelKeyNode.style.display=_64b?"":"none";this.accelKeyNode.innerHTML=_64b;_639.set(this.containerNode,"colSpan",_64b?"1":"2");}this._set("accelKey",_64b);}});if(has("dojo-bidi")){_641=_638("dijit.MenuItem",_641,{_setLabelAttr:function(val){this.inherited(arguments);if(this.textDir==="auto"){this.applyTextDir(this.textDirNode);}}});}return _641;});},"dijit/_Contained":function(){define(["dojo/_base/declare","./registry"],function(_64c,_64d){return _64c("dijit._Contained",null,{_getSibling:function(_64e){var p=this.getParent();return (p&&p._getSiblingOfChild&&p._getSiblingOfChild(this,_64e=="previous"?-1:1))||null;},getPreviousSibling:function(){return this._getSibling("previous");},getNextSibling:function(){return this._getSibling("next");},getIndexInParent:function(){var p=this.getParent();if(!p||!p.getIndexOfChild){return -1;}return p.getIndexOfChild(this);}});});},"dijit/_CssStateMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/has","dojo/_base/lang","dojo/on","dojo/domReady","dojo/touch","dojo/_base/window","./a11yclick","./registry"],function(_64f,_650,dom,_651,has,lang,on,_652,_653,win,_654,_655){var _656=_650("dijit._CssStateMixin",[],{hovering:false,active:false,_applyAttributes:function(){this.inherited(arguments);_64f.forEach(["disabled","readOnly","checked","selected","focused","state","hovering","active","_opened"],function(attr){this.watch(attr,lang.hitch(this,"_setStateClass"));},this);for(var ap in this.cssStateNodes||{}){this._trackMouseState(this[ap],this.cssStateNodes[ap]);}this._trackMouseState(this.domNode,this.baseClass);this._setStateClass();},_cssMouseEvent:function(_657){if(!this.disabled){switch(_657.type){case "mouseover":case "MSPointerOver":case "pointerover":this._set("hovering",true);this._set("active",this._mouseDown);break;case "mouseout":case "MSPointerOut":case "pointerout":this._set("hovering",false);this._set("active",false);break;case "mousedown":case "touchstart":case "MSPointerDown":case "pointerdown":case "keydown":this._set("active",true);break;case "mouseup":case "dojotouchend":case "MSPointerUp":case "pointerup":case "keyup":this._set("active",false);break;}}},_setStateClass:function(){var _658=this.baseClass.split(" ");function _659(_65a){_658=_658.concat(_64f.map(_658,function(c){return c+_65a;}),"dijit"+_65a);};if(!this.isLeftToRight()){_659("Rtl");}var _65b=this.checked=="mixed"?"Mixed":(this.checked?"Checked":"");if(this.checked){_659(_65b);}if(this.state){_659(this.state);}if(this.selected){_659("Selected");}if(this._opened){_659("Opened");}if(this.disabled){_659("Disabled");}else{if(this.readOnly){_659("ReadOnly");}else{if(this.active){_659("Active");}else{if(this.hovering){_659("Hover");}}}}if(this.focused){_659("Focused");}var tn=this.stateNode||this.domNode,_65c={};_64f.forEach(tn.className.split(" "),function(c){_65c[c]=true;});if("_stateClasses" in this){_64f.forEach(this._stateClasses,function(c){delete _65c[c];});}_64f.forEach(_658,function(c){_65c[c]=true;});var _65d=[];for(var c in _65c){_65d.push(c);}tn.className=_65d.join(" ");this._stateClasses=_658;},_subnodeCssMouseEvent:function(node,_65e,evt){if(this.disabled||this.readOnly){return;}function _65f(_660){_651.toggle(node,_65e+"Hover",_660);};function _661(_662){_651.toggle(node,_65e+"Active",_662);};function _663(_664){_651.toggle(node,_65e+"Focused",_664);};switch(evt.type){case "mouseover":case "MSPointerOver":case "pointerover":_65f(true);break;case "mouseout":case "MSPointerOut":case "pointerout":_65f(false);_661(false);break;case "mousedown":case "touchstart":case "MSPointerDown":case "pointerdown":case "keydown":_661(true);break;case "mouseup":case "MSPointerUp":case "pointerup":case "dojotouchend":case "keyup":_661(false);break;case "focus":case "focusin":_663(true);break;case "blur":case "focusout":_663(false);break;}},_trackMouseState:function(node,_665){node._cssState=_665;}});_652(function(){function _666(evt,_667,_668){if(_668&&dom.isDescendant(_668,_667)){return;}for(var node=_667;node&&node!=_668;node=node.parentNode){if(node._cssState){var _669=_655.getEnclosingWidget(node);if(_669){if(node==_669.domNode){_669._cssMouseEvent(evt);}else{_669._subnodeCssMouseEvent(node,node._cssState,evt);}}}}};var body=win.body(),_66a;on(body,_653.over,function(evt){_666(evt,evt.target,evt.relatedTarget);});on(body,_653.out,function(evt){_666(evt,evt.target,evt.relatedTarget);});on(body,_654.press,function(evt){_66a=evt.target;_666(evt,_66a);});on(body,_654.release,function(evt){_666(evt,_66a);_66a=null;});on(body,"focusin, focusout",function(evt){var node=evt.target;if(node._cssState&&!node.getAttribute("widgetId")){var _66b=_655.getEnclosingWidget(node);if(_66b){_66b._subnodeCssMouseEvent(node,node._cssState,evt);}}});});return _656;});},"dojo/i18n":function(){define(["./_base/kernel","require","./has","./_base/array","./_base/config","./_base/lang","./_base/xhr","./json","module"],function(dojo,_66c,has,_66d,_66e,lang,xhr,json,_66f){has.add("dojo-preload-i18n-Api",1);1||has.add("dojo-v1x-i18n-Api",1);var _670=dojo.i18n={},_671=/(^.*(^|\/)nls)(\/|$)([^\/]*)\/?([^\/]*)/,_672=function(root,_673,_674,_675){for(var _676=[_674+_675],_677=_673.split("-"),_678="",i=0;i<_677.length;i++){_678+=(_678?"-":"")+_677[i];if(!root||root[_678]){_676.push(_674+_678+"/"+_675);_676.specificity=_678;}}return _676;},_679={},_67a=function(_67b,_67c,_67d){_67d=_67d?_67d.toLowerCase():dojo.locale;_67b=_67b.replace(/\./g,"/");_67c=_67c.replace(/\./g,"/");return (/root/i.test(_67d))?(_67b+"/nls/"+_67c):(_67b+"/nls/"+_67d+"/"+_67c);},_67e=dojo.getL10nName=function(_67f,_680,_681){return _67f=_66f.id+"!"+_67a(_67f,_680,_681);},_682=function(_683,_684,_685,_686,_687,load){_683([_684],function(root){var _688=lang.clone(root.root||root.ROOT),_689=_672(!root._v1x&&root,_687,_685,_686);_683(_689,function(){for(var i=1;i<_689.length;i++){_688=lang.mixin(lang.clone(_688),arguments[i]);}var _68a=_684+"/"+_687;_679[_68a]=_688;_688.$locale=_689.specificity;load();});});},_68b=function(id,_68c){return /^\./.test(id)?_68c(id):id;},_68d=function(_68e){var list=_66e.extraLocale||[];list=lang.isArray(list)?list:[list];list.push(_68e);return list;},load=function(id,_68f,load){var _690=_671.exec(id),_691=_690[1]+"/",_692=_690[5]||_690[4],_693=_691+_692,_694=(_690[5]&&_690[4]),_695=_694||dojo.locale||"",_696=_693+"/"+_695,_697=_694?[_695]:_68d(_695),_698=_697.length,_699=function(){if(!--_698){load(lang.delegate(_679[_696]));}},_69a=id.split("*"),_69b=_69a[1]=="preload";if(has("dojo-preload-i18n-Api")){if(_69b){if(!_679[id]){_679[id]=1;_6a5(_69a[2],json.parse(_69a[3]),1,_68f);}load(1);}if(_69b||(_6c2(id,_68f,load)&&!_679[_696])){return;}}else{if(_69b){load(1);return;}}_66d.forEach(_697,function(_69c){var _69d=_693+"/"+_69c;if(has("dojo-preload-i18n-Api")){_69e(_69d);}if(!_679[_69d]){_682(_68f,_693,_691,_692,_69c,_699);}else{_699();}});};if(has("dojo-preload-i18n-Api")||1){var _69f=_670.normalizeLocale=function(_6a0){var _6a1=_6a0?_6a0.toLowerCase():dojo.locale;return _6a1=="root"?"ROOT":_6a1;},isXd=function(mid,_6a2){return (1&&1)?_6a2.isXdUrl(_66c.toUrl(mid+".js")):true;},_6a3=0,_6a4=[],_6a5=_670._preloadLocalizations=function(_6a6,_6a7,_6a8,_6a9){_6a9=_6a9||_66c;function _6aa(mid,_6ab){if(isXd(mid,_6a9)||_6a8){_6a9([mid],_6ab);}else{_6c7([mid],_6ab,_6a9);}};function _6ac(_6ad,func){var _6ae=_6ad.split("-");while(_6ae.length){if(func(_6ae.join("-"))){return;}_6ae.pop();}func("ROOT");};function _6af(){_6a3++;};function _6b0(){--_6a3;while(!_6a3&&_6a4.length){load.apply(null,_6a4.shift());}};function _6b1(path,name,loc,_6b2){return _6b2.toAbsMid(path+name+"/"+loc);};function _6b3(_6b4){_6b4=_69f(_6b4);_6ac(_6b4,function(loc){if(_66d.indexOf(_6a7,loc)>=0){var mid=_6a6.replace(/\./g,"/")+"_"+loc;_6af();_6aa(mid,function(_6b5){for(var p in _6b5){var _6b6=_6b5[p],_6b7=p.match(/(.+)\/([^\/]+)$/),_6b8,_6b9;if(!_6b7){continue;}_6b8=_6b7[2];_6b9=_6b7[1]+"/";if(!_6b6._localized){continue;}var _6ba;if(loc==="ROOT"){var root=_6ba=_6b6._localized;delete _6b6._localized;root.root=_6b6;_679[_66c.toAbsMid(p)]=root;}else{_6ba=_6b6._localized;_679[_6b1(_6b9,_6b8,loc,_66c)]=_6b6;}if(loc!==_6b4){var _6bb=function _6bb(_6bc,_6bd,_6be,_6bf){var _6c0=[],_6c1=[];_6ac(_6b4,function(loc){if(_6bf[loc]){_6c0.push(_66c.toAbsMid(_6bc+loc+"/"+_6bd));_6c1.push(_6b1(_6bc,_6bd,loc,_66c));}});if(_6c0.length){_6af();_6a9(_6c0,function(){for(var i=_6c0.length-1;i>=0;i--){_6be=lang.mixin(lang.clone(_6be),arguments[i]);_679[_6c1[i]]=_6be;}_679[_6b1(_6bc,_6bd,_6b4,_66c)]=lang.clone(_6be);_6b0();});}else{_679[_6b1(_6bc,_6bd,_6b4,_66c)]=_6be;}};_6bb(_6b9,_6b8,_6b6,_6ba);}}_6b0();});return true;}return false;});};_6b3();_66d.forEach(dojo.config.extraLocale,_6b3);},_6c2=function(id,_6c3,load){if(_6a3){_6a4.push([id,_6c3,load]);}return _6a3;},_69e=function(){};}if(1){var _6c4={},_6c5={},_6c6,_6c7=function(deps,_6c8,_6c9){var _6ca=[];_66d.forEach(deps,function(mid){var url=_6c9.toUrl(mid+".js");function load(text){if(!_6c6){_6c6=new Function("__bundle","__checkForLegacyModules","__mid","__amdValue","var define = function(mid, factory){define.called = 1; __amdValue.result = factory || mid;},"+"\t   require = function(){define.called = 1;};"+"try{"+"define.called = 0;"+"eval(__bundle);"+"if(define.called==1)"+"return __amdValue;"+"if((__checkForLegacyModules = __checkForLegacyModules(__mid)))"+"return __checkForLegacyModules;"+"}catch(e){}"+"try{"+"return eval('('+__bundle+')');"+"}catch(e){"+"return e;"+"}");}var _6cb=_6c6(text,_69e,mid,_6c4);if(_6cb===_6c4){_6ca.push(_679[url]=_6c4.result);}else{if(_6cb instanceof Error){console.error("failed to evaluate i18n bundle; url="+url,_6cb);_6cb={};}_6ca.push(_679[url]=(/nls\/[^\/]+\/[^\/]+$/.test(url)?_6cb:{root:_6cb,_v1x:1}));}};if(_679[url]){_6ca.push(_679[url]);}else{var _6cc=_6c9.syncLoadNls(mid);if(!_6cc){_6cc=_69e(mid.replace(/nls\/([^\/]*)\/([^\/]*)$/,"nls/$2/$1"));}if(_6cc){_6ca.push(_6cc);}else{if(!xhr){try{_6c9.getText(url,true,load);}catch(e){_6ca.push(_679[url]={});}}else{xhr.get({url:url,sync:true,load:load,error:function(){_6ca.push(_679[url]={});}});}}}});_6c8&&_6c8.apply(null,_6ca);};_69e=function(_6cd){for(var _6ce,_6cf=_6cd.split("/"),_6d0=dojo.global[_6cf[0]],i=1;_6d0&&i<_6cf.length-1;_6d0=_6d0[_6cf[i++]]){}if(_6d0){_6ce=_6d0[_6cf[i]];if(!_6ce){_6ce=_6d0[_6cf[i].replace(/-/g,"_")];}if(_6ce){_679[_6cd]=_6ce;}}return _6ce;};_670.getLocalization=function(_6d1,_6d2,_6d3){var _6d4,_6d5=_67a(_6d1,_6d2,_6d3);if(_6c5[_6d5]){return _6c5[_6d5];}load(_6d5,(!isXd(_6d5,_66c)?function(deps,_6d6){_6c7(deps,_6d6,_66c);}:_66c),function(_6d7){_6c5[_6d5]=_6d7;_6d4=_6d7;});return _6d4;};}else{_670.getLocalization=function(_6d8,_6d9,_6da){var key=_6d8.replace(/\./g,"/")+"/nls/"+_6d9+"/"+(_6da||_66e.locale);return this.cache[key];};}return lang.mixin(_670,{dynamic:true,normalize:_68b,load:load,cache:_679,getL10nName:_67e});});},"dojox/grid/DataSelection":function(){define(["dojo/_base/declare","./_SelectionPreserver","./Selection"],function(_6db,_6dc,_6dd){return _6db("dojox.grid.DataSelection",_6dd,{constructor:function(grid){if(grid.keepSelection){this.preserver=new _6dc(this);}},destroy:function(){if(this.preserver){this.preserver.destroy();}},getFirstSelected:function(){var idx=_6dd.prototype.getFirstSelected.call(this);if(idx==-1){return null;}return this.grid.getItem(idx);},getNextSelected:function(_6de){var _6df=this.grid.getItemIndex(_6de);var idx=_6dd.prototype.getNextSelected.call(this,_6df);if(idx==-1){return null;}return this.grid.getItem(idx);},getSelected:function(){var _6e0=[];for(var i=0,l=this.selected.length;i<l;i++){if(this.selected[i]){_6e0.push(this.grid.getItem(i));}}return _6e0;},addToSelection:function(_6e1){if(this.mode=="none"){return;}var idx=null;if(typeof _6e1=="number"||typeof _6e1=="string"){idx=_6e1;}else{idx=this.grid.getItemIndex(_6e1);}_6dd.prototype.addToSelection.call(this,idx);},deselect:function(_6e2){if(this.mode=="none"){return;}var idx=null;if(typeof _6e2=="number"||typeof _6e2=="string"){idx=_6e2;}else{idx=this.grid.getItemIndex(_6e2);}_6dd.prototype.deselect.call(this,idx);},deselectAll:function(_6e3){var idx=null;if(_6e3||typeof _6e3=="number"){if(typeof _6e3=="number"||typeof _6e3=="string"){idx=_6e3;}else{idx=this.grid.getItemIndex(_6e3);}_6dd.prototype.deselectAll.call(this,idx);}else{this.inherited(arguments);}}});});},"dojox/grid/_SelectionPreserver":function(){define(["dojo/_base/declare","dojo/_base/connect","dojo/_base/lang","dojo/_base/array"],function(_6e4,_6e5,lang,_6e6){return _6e4("dojox.grid._SelectionPreserver",null,{constructor:function(_6e7){this.selection=_6e7;var grid=this.grid=_6e7.grid;this.reset();this._connects=[_6e5.connect(grid,"_setStore",this,"reset"),_6e5.connect(grid,"_addItem",this,"_reSelectById"),_6e5.connect(_6e7,"onSelected",lang.hitch(this,"_selectById",true)),_6e5.connect(_6e7,"onDeselected",lang.hitch(this,"_selectById",false)),_6e5.connect(_6e7,"deselectAll",this,"reset")];},destroy:function(){this.reset();_6e6.forEach(this._connects,_6e5.disconnect);delete this._connects;},reset:function(){this._selectedById={};},_reSelectById:function(item,_6e8){if(item&&this.grid._hasIdentity){this.selection.selected[_6e8]=this._selectedById[this.grid.store.getIdentity(item)];}},_selectById:function(_6e9,_6ea){if(this.selection.mode=="none"||!this.grid._hasIdentity){return;}var item=_6ea,g=this.grid;if(typeof _6ea=="number"||typeof _6ea=="string"){var _6eb=g._by_idx[_6ea];item=_6eb&&_6eb.item;}if(item){this._selectedById[g.store.getIdentity(item)]=!!_6e9;}return item;}});});},"dojox/grid/enhanced/_PluginManager":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/_base/connect","./_Events","./_FocusManager","../util"],function(dojo,lang,_6ec,_6ed,_6ee,_6ef,_6f0,util){var _6f1=_6ec("dojox.grid.enhanced._PluginManager",null,{_options:null,_plugins:null,_connects:null,constructor:function(_6f2){this.grid=_6f2;this._store=_6f2.store;this._options={};this._plugins=[];this._connects=[];this._parseProps(this.grid.plugins);_6f2.connect(_6f2,"_setStore",lang.hitch(this,function(_6f3){if(this._store!==_6f3){this.forEach("onSetStore",[_6f3,this._store]);this._store=_6f3;}}));},startup:function(){this.forEach("onStartUp");},preInit:function(){this.grid.focus.destroy();this.grid.focus=new _6f0(this.grid);new _6ef(this.grid);this._init(true);this.forEach("onPreInit");},postInit:function(){this._init(false);_6ed.forEach(this.grid.views.views,this._initView,this);this._connects.push(_6ee.connect(this.grid.views,"addView",lang.hitch(this,this._initView)));if(this._plugins.length>0){var edit=this.grid.edit;if(edit){edit.styleRow=function(_6f4){};}}this.forEach("onPostInit");},forEach:function(func,args){_6ed.forEach(this._plugins,function(p){if(!p||!p[func]){return;}p[func].apply(p,args?args:[]);});},_parseProps:function(_6f5){if(!_6f5){return;}var p,_6f6={},_6f7=this._options,grid=this.grid;var _6f8=_6f1.registry;for(p in _6f5){if(_6f5[p]){this._normalize(p,_6f5,_6f8,_6f6);}}if(_6f7.dnd){_6f7.columnReordering=false;}lang.mixin(grid,_6f7);},_normalize:function(p,_6f9,_6fa,_6fb){if(!_6fa[p]){throw new Error("Plugin "+p+" is required.");}if(_6fb[p]){throw new Error("Recursive cycle dependency is not supported.");}var _6fc=this._options;if(_6fc[p]){return _6fc[p];}_6fb[p]=true;_6fc[p]=lang.mixin({},_6fa[p],lang.isObject(_6f9[p])?_6f9[p]:{});var _6fd=_6fc[p]["dependency"];if(_6fd){if(!lang.isArray(_6fd)){_6fd=_6fc[p]["dependency"]=[_6fd];}_6ed.forEach(_6fd,function(_6fe){if(!this._normalize(_6fe,_6f9,_6fa,_6fb)){throw new Error("Plugin "+_6fe+" is required.");}},this);}delete _6fb[p];return _6fc[p];},_init:function(pre){var p,_6ff,_700=this._options;for(p in _700){_6ff=_700[p]["preInit"];if((pre?_6ff:!_6ff)&&_700[p]["class"]&&!this.pluginExisted(p)){this.loadPlugin(p);}}},loadPlugin:function(name){var _701=this._options[name];if(!_701){return null;}var _702=this.getPlugin(name);if(_702){return _702;}var _703=_701["dependency"];_6ed.forEach(_703,function(_704){if(!this.loadPlugin(_704)){throw new Error("Plugin "+_704+" is required.");}},this);var cls=_701["class"];delete _701["class"];_702=new this.getPluginClazz(cls)(this.grid,_701);this._plugins.push(_702);return _702;},_initView:function(view){if(!view){return;}util.funnelEvents(view.contentNode,view,"doContentEvent",["mouseup","mousemove"]);util.funnelEvents(view.headerNode,view,"doHeaderEvent",["mouseup"]);},pluginExisted:function(name){return !!this.getPlugin(name);},getPlugin:function(name){var _705=this._plugins;name=name.toLowerCase();for(var i=0,len=_705.length;i<len;i++){if(name==_705[i]["name"].toLowerCase()){return _705[i];}}return null;},getPluginClazz:function(_706){if(lang.isFunction(_706)){return _706;}var _707="Please make sure Plugin \""+_706+"\" is existed.";try{var cls=lang.getObject(_706);if(!cls){throw new Error(_707);}return cls;}catch(e){throw new Error(_707);}},isFixedCell:function(cell){return cell&&(cell.isRowSelector||cell.fixedPos);},destroy:function(){_6ed.forEach(this._connects,_6ee.disconnect);this.forEach("destroy");if(this.grid.unwrap){this.grid.unwrap();}delete this._connects;delete this._plugins;delete this._options;}});_6f1.registerPlugin=function(_708,_709){if(!_708){console.warn("Failed to register plugin, class missed!");return;}var cls=_6f1;cls.registry=cls.registry||{};cls.registry[_708.prototype.name]=lang.mixin({"class":_708},(_709?_709:{}));};return _6f1;});},"dojox/grid/enhanced/_Events":function(){define(["dojo/_base/kernel","dojo/_base/declare","dojo/keys","dojo/_base/html","dojo/_base/event","dojox/grid/_Events"],function(dojo,_70a,keys,html,_70b,_70c){return _70a("dojox.grid.enhanced._Events",null,{_events:null,headerCellActiveClass:"dojoxGridHeaderActive",cellActiveClass:"dojoxGridCellActive",rowActiveClass:"dojoxGridRowActive",constructor:function(_70d){this._events=new _70c();_70d.mixin(_70d,this);},dokeyup:function(e){this.focus.currentArea().keyup(e);},onKeyDown:function(e){if(e.altKey||e.metaKey){return;}var _70e=this.focus;var _70f=this.edit.isEditing();switch(e.keyCode){case keys.TAB:if(e.ctrlKey){return;}_70e.tab(e.shiftKey?-1:1,e);break;case keys.UP_ARROW:case keys.DOWN_ARROW:if(_70f){return;}_70e.currentArea().move(e.keyCode==keys.UP_ARROW?-1:1,0,e);break;case keys.LEFT_ARROW:case keys.RIGHT_ARROW:if(_70f){return;}var _710=(e.keyCode==keys.LEFT_ARROW)?1:-1;if(html._isBodyLtr()){_710*=-1;}_70e.currentArea().move(0,_710,e);break;case keys.F10:if(this.menus&&e.shiftKey){this.onRowContextMenu(e);}break;default:_70e.currentArea().keydown(e);break;}},domouseup:function(e){if(e.cellNode){this.onMouseUp(e);}else{this.onRowSelectorMouseUp(e);}},domousedown:function(e){if(!e.cellNode){this.onRowSelectorMouseDown(e);}},onMouseUp:function(e){this[e.rowIndex==-1?"onHeaderCellMouseUp":"onCellMouseUp"](e);},onCellMouseDown:function(e){html.addClass(e.cellNode,this.cellActiveClass);html.addClass(e.rowNode,this.rowActiveClass);},onCellMouseUp:function(e){html.removeClass(e.cellNode,this.cellActiveClass);html.removeClass(e.rowNode,this.rowActiveClass);},onCellClick:function(e){this._events.onCellClick.call(this,e);this.focus.contentMouseEvent(e);},onCellDblClick:function(e){if(this.pluginMgr.isFixedCell(e.cell)){return;}if(this._click.length>1&&(!this._click[0]||!this._click[1])){this._click[0]=this._click[1]=e;}this._events.onCellDblClick.call(this,e);},onRowClick:function(e){this.edit.rowClick(e);if(!e.cell||!this.plugin("indirectSelection")){this.selection.clickSelectEvent(e);}},onRowContextMenu:function(e){if(!this.edit.isEditing()&&this.menus){this.showMenu(e);}},onSelectedRegionContextMenu:function(e){if(this.selectedRegionMenu){this.selectedRegionMenu._openMyself({target:e.target,coords:e.keyCode!==keys.F10&&"pageX" in e?{x:e.pageX,y:e.pageY}:null});_70b.stop(e);}},onHeaderCellMouseOut:function(e){if(e.cellNode){html.removeClass(e.cellNode,this.cellOverClass);html.removeClass(e.cellNode,this.headerCellActiveClass);}},onHeaderCellMouseDown:function(e){if(e.cellNode){html.addClass(e.cellNode,this.headerCellActiveClass);}},onHeaderCellMouseUp:function(e){if(e.cellNode){html.removeClass(e.cellNode,this.headerCellActiveClass);}},onHeaderCellClick:function(e){this.focus.currentArea("header");if(!e.cell.isRowSelector){this._events.onHeaderCellClick.call(this,e);}this.focus.headerMouseEvent(e);},onRowSelectorMouseDown:function(e){this.focus.focusArea("rowHeader",e);},onRowSelectorMouseUp:function(e){},onMouseUpRow:function(e){if(e.rowIndex!=-1){this.onRowMouseUp(e);}},onRowMouseUp:function(e){}});});},"dojox/grid/enhanced/_FocusManager":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/_base/connect","dojo/_base/event","dojo/_base/sniff","dojo/_base/html","dojo/keys","dijit/a11y","dijit/focus","../_FocusManager"],function(dojo,lang,_711,_712,_713,_714,has,html,keys,_715,_716,_717){var _718=_711("dojox.grid.enhanced._FocusArea",null,{constructor:function(area,_719){this._fm=_719;this._evtStack=[area.name];var _71a=function(){return true;};area.onFocus=area.onFocus||_71a;area.onBlur=area.onBlur||_71a;area.onMove=area.onMove||_71a;area.onKeyUp=area.onKeyUp||_71a;area.onKeyDown=area.onKeyDown||_71a;lang.mixin(this,area);},move:function(_71b,_71c,evt){if(this.name){var i,len=this._evtStack.length;for(i=len-1;i>=0;--i){if(this._fm._areas[this._evtStack[i]].onMove(_71b,_71c,evt)===false){return false;}}}return true;},_onKeyEvent:function(evt,_71d){if(this.name){var i,len=this._evtStack.length;for(i=len-1;i>=0;--i){if(this._fm._areas[this._evtStack[i]][_71d](evt,false)===false){return false;}}for(i=0;i<len;++i){if(this._fm._areas[this._evtStack[i]][_71d](evt,true)===false){return false;}}}return true;},keydown:function(evt){return this._onKeyEvent(evt,"onKeyDown");},keyup:function(evt){return this._onKeyEvent(evt,"onKeyUp");},contentMouseEventPlanner:function(){return 0;},headerMouseEventPlanner:function(){return 0;}});return _711("dojox.grid.enhanced._FocusManager",_717,{_stopEvent:function(evt){try{if(evt&&evt.preventDefault){_714.stop(evt);}}catch(e){}},constructor:function(grid){this.grid=grid;this._areas={};this._areaQueue=[];this._contentMouseEventHandlers=[];this._headerMouseEventHandlers=[];this._currentAreaIdx=-1;this._gridBlured=true;this._connects.push(_713.connect(grid,"onBlur",this,"_doBlur"));this._connects.push(_713.connect(grid.scroller,"renderPage",this,"_delayedCellFocus"));this.addArea({name:"header",onFocus:lang.hitch(this,this.focusHeader),onBlur:lang.hitch(this,this._blurHeader),onMove:lang.hitch(this,this._navHeader),getRegions:lang.hitch(this,this._findHeaderCells),onRegionFocus:lang.hitch(this,this.doColHeaderFocus),onRegionBlur:lang.hitch(this,this.doColHeaderBlur),onKeyDown:lang.hitch(this,this._onHeaderKeyDown)});this.addArea({name:"content",onFocus:lang.hitch(this,this._focusContent),onBlur:lang.hitch(this,this._blurContent),onMove:lang.hitch(this,this._navContent),onKeyDown:lang.hitch(this,this._onContentKeyDown)});this.addArea({name:"editableCell",onFocus:lang.hitch(this,this._focusEditableCell),onBlur:lang.hitch(this,this._blurEditableCell),onKeyDown:lang.hitch(this,this._onEditableCellKeyDown),onContentMouseEvent:lang.hitch(this,this._onEditableCellMouseEvent),contentMouseEventPlanner:function(evt,_71e){return -1;}});this.placeArea("header");this.placeArea("content");this.placeArea("editableCell");this.placeArea("editableCell","above","content");},destroy:function(){for(var name in this._areas){var area=this._areas[name];_712.forEach(area._connects,_713.disconnect);area._connects=null;if(area.uninitialize){area.uninitialize();}}this.inherited(arguments);},addArea:function(area){if(area.name&&lang.isString(area.name)){if(this._areas[area.name]){_712.forEach(area._connects,_713.disconnect);}this._areas[area.name]=new _718(area,this);if(area.onHeaderMouseEvent){this._headerMouseEventHandlers.push(area.name);}if(area.onContentMouseEvent){this._contentMouseEventHandlers.push(area.name);}}},getArea:function(_71f){return this._areas[_71f];},_bindAreaEvents:function(){var area,hdl,_720=this._areas;_712.forEach(this._areaQueue,function(name){area=_720[name];if(!area._initialized&&lang.isFunction(area.initialize)){area.initialize();area._initialized=true;}if(area.getRegions){area._regions=area.getRegions()||[];_712.forEach(area._connects||[],_713.disconnect);area._connects=[];_712.forEach(area._regions,function(r){if(area.onRegionFocus){hdl=_713.connect(r,"onfocus",area.onRegionFocus);area._connects.push(hdl);}if(area.onRegionBlur){hdl=_713.connect(r,"onblur",area.onRegionBlur);area._connects.push(hdl);}});}});},removeArea:function(_721){var area=this._areas[_721];if(area){this.ignoreArea(_721);var i=_712.indexOf(this._contentMouseEventHandlers,_721);if(i>=0){this._contentMouseEventHandlers.splice(i,1);}i=_712.indexOf(this._headerMouseEventHandlers,_721);if(i>=0){this._headerMouseEventHandlers.splice(i,1);}_712.forEach(area._connects,_713.disconnect);if(area.uninitialize){area.uninitialize();}delete this._areas[_721];}},currentArea:function(_722,_723){var idx,cai=this._currentAreaIdx;if(lang.isString(_722)&&(idx=_712.indexOf(this._areaQueue,_722))>=0){if(cai!=idx){this.tabbingOut=false;if(_723&&cai>=0&&cai<this._areaQueue.length){this._areas[this._areaQueue[cai]].onBlur();}this._currentAreaIdx=idx;}}else{return (cai<0||cai>=this._areaQueue.length)?new _718({},this):this._areas[this._areaQueue[this._currentAreaIdx]];}return null;},placeArea:function(name,pos,_724){if(!this._areas[name]){return;}var idx=_712.indexOf(this._areaQueue,_724);switch(pos){case "after":if(idx>=0){++idx;}case "before":if(idx>=0){this._areaQueue.splice(idx,0,name);break;}default:this._areaQueue.push(name);break;case "above":var _725=true;case "below":var _726=this._areas[_724];if(_726){if(_725){_726._evtStack.push(name);}else{_726._evtStack.splice(0,0,name);}}}},ignoreArea:function(name){this._areaQueue=_712.filter(this._areaQueue,function(_727){return _727!=name;});},focusArea:function(_728,evt){var idx;if(typeof _728=="number"){idx=_728<0?this._areaQueue.length+_728:_728;}else{idx=_712.indexOf(this._areaQueue,lang.isString(_728)?_728:(_728&&_728.name));}if(idx<0){idx=0;}var step=idx-this._currentAreaIdx;this._gridBlured=false;if(step){this.tab(step,evt);}else{this.currentArea().onFocus(evt,step);}},tab:function(step,evt){this._gridBlured=false;this.tabbingOut=false;if(step===0){return;}var cai=this._currentAreaIdx;var dir=step>0?1:-1;if(cai<0||cai>=this._areaQueue.length){cai=(this._currentAreaIdx+=step);}else{var _729=this._areas[this._areaQueue[cai]].onBlur(evt,step);if(_729===true){cai=(this._currentAreaIdx+=step);}else{if(lang.isString(_729)&&this._areas[_729]){cai=this._currentAreaIdx=_712.indexOf(this._areaQueue,_729);}}}for(;cai>=0&&cai<this._areaQueue.length;cai+=dir){this._currentAreaIdx=cai;if(this._areaQueue[cai]&&this._areas[this._areaQueue[cai]].onFocus(evt,step)){return;}}this.tabbingOut=true;if(step<0){this._currentAreaIdx=-1;_716.focus(this.grid.domNode);}else{this._currentAreaIdx=this._areaQueue.length;_716.focus(this.grid.lastFocusNode);}},_onMouseEvent:function(type,evt){var _72a=type.toLowerCase(),_72b=this["_"+_72a+"MouseEventHandlers"],res=_712.map(_72b,function(_72c){return {"area":_72c,"idx":this._areas[_72c][_72a+"MouseEventPlanner"](evt,_72b)};},this).sort(function(a,b){return b.idx-a.idx;}),_72d=_712.map(res,function(_72e){return res.area;}),i=res.length;while(--i>=0){if(this._areas[res[i].area]["on"+type+"MouseEvent"](evt,_72d)===false){return;}}},contentMouseEvent:function(evt){this._onMouseEvent("Content",evt);},headerMouseEvent:function(evt){this._onMouseEvent("Header",evt);},initFocusView:function(){this.focusView=this.grid.views.getFirstScrollingView()||this.focusView||this.grid.views.views[0];this._bindAreaEvents();},isNavHeader:function(){return this._areaQueue[this._currentAreaIdx]=="header";},previousKey:function(e){this.tab(-1,e);},nextKey:function(e){this.tab(1,e);},setFocusCell:function(_72f,_730){if(_72f){this.currentArea(this.grid.edit.isEditing()?"editableCell":"content",true);this._focusifyCellNode(false);this.cell=_72f;this.rowIndex=_730;this._focusifyCellNode(true);}this.grid.onCellFocus(this.cell,this.rowIndex);},doFocus:function(e){if(e&&e.target==e.currentTarget&&!this.tabbingOut){if(this._gridBlured){this._gridBlured=false;if(this._currentAreaIdx<0||this._currentAreaIdx>=this._areaQueue.length){this.focusArea(0,e);}else{this.focusArea(this._currentAreaIdx,e);}}}else{this.tabbingOut=false;}_714.stop(e);},_doBlur:function(){this._gridBlured=true;},doLastNodeFocus:function(e){if(this.tabbingOut){this.tabbingOut=false;}else{this.focusArea(-1,e);}},_delayedHeaderFocus:function(){if(this.isNavHeader()&&!has("ie")){this.focusHeader();}},_delayedCellFocus:function(){},_changeMenuBindNode:function(_731,_732){var hm=this.grid.headerMenu;if(hm&&this._contextMenuBindNode==_731){hm.unBindDomNode(_731);hm.bindDomNode(_732);this._contextMenuBindNode=_732;}},focusHeader:function(evt,step){var _733=false;this.inherited(arguments);if(this._colHeadNode&&html.style(this._colHeadNode,"display")!="none"){_716.focus(this._colHeadNode);this._stopEvent(evt);_733=true;}return _733;},_blurHeader:function(evt,step){if(this._colHeadNode){html.removeClass(this._colHeadNode,this.focusClass);}html.removeAttr(this.grid.domNode,"aria-activedescendant");this._changeMenuBindNode(this.grid.domNode,this.grid.viewsHeaderNode);this._colHeadNode=this._colHeadFocusIdx=null;return true;},_navHeader:function(_734,_735,evt){var _736=_735<0?-1:1,_737=_712.indexOf(this._findHeaderCells(),this._colHeadNode);if(_737>=0&&(evt.shiftKey&&evt.ctrlKey)){this.colSizeAdjust(evt,_737,_736*5);return;}this.move(_734,_735);},_onHeaderKeyDown:function(e,_738){if(_738){var dk=keys;switch(e.keyCode){case dk.ENTER:case dk.SPACE:var _739=this.getHeaderIndex();if(_739>=0&&!this.grid.pluginMgr.isFixedCell(e.cell)){this.grid.setSortIndex(_739,null,e);_714.stop(e);}break;}}return true;},_setActiveColHeader:function(){this.inherited(arguments);_716.focus(this._colHeadNode);},findAndFocusGridCell:function(){this._focusContent();},_focusContent:function(evt,step){var _73a=true;var _73b=(this.grid.rowCount===0);if(this.isNoFocusCell()&&!_73b){for(var i=0,cell=this.grid.getCell(0);cell&&cell.hidden;cell=this.grid.getCell(++i)){}this.setFocusIndex(0,cell?i:0);}else{if(this.cell&&!_73b){if(this.focusView&&!this.focusView.rowNodes[this.rowIndex]){this.grid.scrollToRow(this.rowIndex);this.focusGrid();}else{this.setFocusIndex(this.rowIndex,this.cell.index);}}else{_73a=false;}}if(_73a){this._stopEvent(evt);}return _73a;},_blurContent:function(evt,step){this._focusifyCellNode(false);return true;},_navContent:function(_73c,_73d,evt){if((this.rowIndex===0&&_73c<0)||(this.rowIndex===this.grid.rowCount-1&&_73c>0)){return;}this._colHeadNode=null;this.move(_73c,_73d,evt);if(evt){_714.stop(evt);}},_onContentKeyDown:function(e,_73e){if(_73e){var dk=keys,s=this.grid.scroller;switch(e.keyCode){case dk.ENTER:case dk.SPACE:var g=this.grid;if(g.indirectSelection){break;}g.selection.clickSelect(this.rowIndex,_713.isCopyKey(e),e.shiftKey);g.onRowClick(e);_714.stop(e);break;case dk.PAGE_UP:if(this.rowIndex!==0){if(this.rowIndex!=s.firstVisibleRow+1){this._navContent(s.firstVisibleRow-this.rowIndex,0);}else{this.grid.setScrollTop(s.findScrollTop(this.rowIndex-1));this._navContent(s.firstVisibleRow-s.lastVisibleRow+1,0);}_714.stop(e);}break;case dk.PAGE_DOWN:if(this.rowIndex+1!=this.grid.rowCount){_714.stop(e);if(this.rowIndex!=s.lastVisibleRow-1){this._navContent(s.lastVisibleRow-this.rowIndex-1,0);}else{this.grid.setScrollTop(s.findScrollTop(this.rowIndex+1));this._navContent(s.lastVisibleRow-s.firstVisibleRow-1,0);}_714.stop(e);}break;}}return true;},_blurFromEditableCell:false,_isNavigating:false,_navElems:null,_focusEditableCell:function(evt,step){var _73f=false;if(this._isNavigating){_73f=true;}else{if(this.grid.edit.isEditing()&&this.cell){if(this._blurFromEditableCell||!this._blurEditableCell(evt,step)){this.setFocusIndex(this.rowIndex,this.cell.index);_73f=true;}this._stopEvent(evt);}}return _73f;},_applyEditableCell:function(){try{this.grid.edit.apply();}catch(e){console.warn("_FocusManager._applyEditableCell() error:",e);}},_blurEditableCell:function(evt,step){this._blurFromEditableCell=false;if(this._isNavigating){var _740=true;if(evt){var _741=this._navElems;var _742=_741.lowest||_741.first;var _743=_741.last||_741.highest||_742;var _744=has("ie")?evt.srcElement:evt.target;_740=_744==(step>0?_743:_742);}if(_740){this._isNavigating=false;html.setSelectable(this.cell.getNode(this.rowIndex),false);return "content";}return false;}else{if(this.grid.edit.isEditing()&&this.cell){if(!step||typeof step!="number"){return false;}var dir=step>0?1:-1;var cc=this.grid.layout.cellCount;for(var cell,col=this.cell.index+dir;col>=0&&col<cc;col+=dir){cell=this.grid.getCell(col);if(cell.editable){this.cell=cell;this._blurFromEditableCell=true;return false;}}if((this.rowIndex>0||dir==1)&&(this.rowIndex<this.grid.rowCount||dir==-1)){this.rowIndex+=dir;for(col=dir>0?0:cc-1;col>=0&&col<cc;col+=dir){cell=this.grid.getCell(col);if(cell.editable){this.cell=cell;break;}}this._applyEditableCell();return "content";}}}return true;},_initNavigatableElems:function(){this._navElems=_715._getTabNavigable(this.cell.getNode(this.rowIndex));},_onEditableCellKeyDown:function(e,_745){var dk=keys,g=this.grid,edit=g.edit,_746=false,_747=true;switch(e.keyCode){case dk.ENTER:if(_745&&edit.isEditing()){this._applyEditableCell();_746=true;_714.stop(e);}case dk.SPACE:if(!_745&&this._isNavigating){_747=false;break;}if(_745){if(!this.cell.editable&&this.cell.navigatable){this._initNavigatableElems();var _748=this._navElems.lowest||this._navElems.first;if(_748){this._isNavigating=true;html.setSelectable(this.cell.getNode(this.rowIndex),true);_716.focus(_748);_714.stop(e);this.currentArea("editableCell",true);break;}}if(!_746&&!edit.isEditing()&&!g.pluginMgr.isFixedCell(this.cell)){edit.setEditCell(this.cell,this.rowIndex);}if(_746){this.currentArea("content",true);}else{if(this.cell.editable&&g.canEdit()){this.currentArea("editableCell",true);}}}break;case dk.PAGE_UP:case dk.PAGE_DOWN:if(!_745&&edit.isEditing()){_747=false;}break;case dk.ESCAPE:if(!_745){edit.cancel();this.currentArea("content",true);}}return _747;},_onEditableCellMouseEvent:function(evt){if(evt.type=="click"){var cell=this.cell||evt.cell;if(cell&&!cell.editable&&cell.navigatable){this._initNavigatableElems();if(this._navElems.lowest||this._navElems.first){var _749=has("ie")?evt.srcElement:evt.target;if(_749!=cell.getNode(evt.rowIndex)){this._isNavigating=true;this.focusArea("editableCell",evt);html.setSelectable(cell.getNode(evt.rowIndex),true);_716.focus(_749);return false;}}}else{if(this.grid.singleClickEdit){this.currentArea("editableCell");return false;}}}return true;}});});},"dojox/grid/enhanced/plugins/_SelectionPreserver":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/_base/connect","../../_SelectionPreserver"],function(_74a,lang,_74b,_74c){return _74a("dojox.grid.enhanced.plugins._SelectionPreserver",_74c,{constructor:function(_74d){var grid=this.grid;grid.onSelectedById=this.onSelectedById;this._oldClearData=grid._clearData;var self=this;grid._clearData=function(){self._updateMapping(!grid._noInternalMapping);self._trustSelection=[];self._oldClearData.apply(grid,arguments);};this._connects.push(_74b.connect(_74d,"selectRange",lang.hitch(this,"_updateMapping",true,true,false)),_74b.connect(_74d,"deselectRange",lang.hitch(this,"_updateMapping",true,false,false)),_74b.connect(_74d,"deselectAll",lang.hitch(this,"_updateMapping",true,false,true)));},destroy:function(){this.inherited(arguments);this.grid._clearData=this._oldClearData;},reset:function(){this.inherited(arguments);this._idMap=[];this._trustSelection=[];this._defaultSelected=false;},_reSelectById:function(item,_74e){var s=this.selection,g=this.grid;if(item&&g._hasIdentity){var id=g.store.getIdentity(item);if(this._selectedById[id]===undefined){if(!this._trustSelection[_74e]){s.selected[_74e]=this._defaultSelected;}}else{s.selected[_74e]=this._selectedById[id];}this._idMap.push(id);g.onSelectedById(id,_74e,s.selected[_74e]);}},_selectById:function(_74f,_750){if(!this.inherited(arguments)){this._trustSelection[_750]=true;}},onSelectedById:function(id,_751,_752){},_updateMapping:function(_753,_754,_755,from,to){var s=this.selection,g=this.grid,flag=0,_756=0,i,id;for(i=g.rowCount-1;i>=0;--i){if(!g._by_idx[i]){++_756;flag+=s.selected[i]?1:-1;}else{id=g._by_idx[i].idty;if(id&&(_753||this._selectedById[id]===undefined)){this._selectedById[id]=!!s.selected[i];}}}if(_756){this._defaultSelected=flag>0;}if(!_755&&from!==undefined&&to!==undefined){_755=!g.usingPagination&&Math.abs(to-from+1)===g.rowCount;}if(_755&&(!g.usingPagination||g.selectionMode==="single")){for(i=this._idMap.length-1;i>=0;--i){this._selectedById[this._idMap[i]]=_754;}}}});});},"dojox/grid/enhanced/plugins/Filter":function(){define(["dojo/_base/declare","dojo/_base/lang","../_Plugin","./Dialog","./filter/FilterLayer","./filter/FilterBar","./filter/FilterDefDialog","./filter/FilterStatusTip","./filter/ClearFilterConfirm","../../EnhancedGrid","dojo/i18n!../nls/Filter"],function(_757,lang,_758,_759,_75a,_75b,_75c,_75d,_75e,_75f,nls){var _760=_757("dojox.grid.enhanced.plugins.Filter",_758,{name:"filter",constructor:function(grid,args){this.grid=grid;this.nls=nls;args=this.args=lang.isObject(args)?args:{};if(typeof args.ruleCount!="number"||args.ruleCount<0){args.ruleCount=3;}var rc=this.ruleCountToConfirmClearFilter=args.ruleCountToConfirmClearFilter;if(rc===undefined){this.ruleCountToConfirmClearFilter=2;}this._wrapStore();var obj={"plugin":this};this.clearFilterDialog=new _759({refNode:this.grid.domNode,title:this.nls["clearFilterDialogTitle"],content:new _75e(obj)});this.filterDefDialog=new _75c(obj);this.filterBar=new _75b(obj);this.filterStatusTip=new _75d(obj);grid.onFilterDefined=function(){};this.connect(grid.layer("filter"),"onFilterDefined",function(_761){grid.onFilterDefined(grid.getFilter(),grid.getFilterRelation());});},destroy:function(){this.inherited(arguments);try{this.grid.unwrap("filter");this.filterBar.destroyRecursive();this.filterBar=null;this.clearFilterDialog.destroyRecursive();this.clearFilterDialog=null;this.filterStatusTip.destroy();this.filterStatusTip=null;this.filterDefDialog.destroy();this.filterDefDialog=null;this.grid=null;this.args=null;}catch(e){console.warn("Filter.destroy() error:",e);}},_wrapStore:function(){var g=this.grid;var args=this.args;var _762=args.isServerSide?new _75a.ServerSideFilterLayer(args):new _75a.ClientSideFilterLayer({cacheSize:args.filterCacheSize,fetchAll:args.fetchAllOnFirstFilter,getter:this._clientFilterGetter});_75a.wrap(g,"_storeLayerFetch",_762);this.connect(g,"_onDelete",lang.hitch(_762,"invalidate"));},onSetStore:function(_763){this.filterDefDialog.clearFilter(true);},_clientFilterGetter:function(_764,cell,_765){return cell.get(_765,_764);}});_75f.registerPlugin(_760);return _760;});},"dojox/grid/enhanced/_Plugin":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/_base/connect","../EnhancedGrid"],function(dojo,lang,_766,_767,_768){return _766("dojox.grid.enhanced._Plugin",null,{name:"plugin",grid:null,option:{},_connects:[],_subscribes:[],privates:{},constructor:function(_769,_76a){this.grid=_769;this.option=_76a;this._connects=[];this._subscribes=[];this.privates=lang.mixin({},dojox.grid.enhanced._Plugin.prototype);this.init();},init:function(){},onPreInit:function(){},onPostInit:function(){},onStartUp:function(){},connect:function(obj,_76b,_76c){var conn=_768.connect(obj,_76b,this,_76c);this._connects.push(conn);return conn;},disconnect:function(_76d){_767.some(this._connects,function(conn,i,_76e){if(conn==_76d){_768.disconnect(_76d);_76e.splice(i,1);return true;}return false;});},subscribe:function(_76f,_770){var _771=_768.subscribe(_76f,this,_770);this._subscribes.push(_771);return _771;},unsubscribe:function(_772){_767.some(this._subscribes,function(_773,i,_774){if(_773==_772){_768.unsubscribe(_772);_774.splice(i,1);return true;}return false;});},onSetStore:function(_775){},destroy:function(){_767.forEach(this._connects,_768.disconnect);_767.forEach(this._subscribes,_768.unsubscribe);delete this._connects;delete this._subscribes;delete this.option;delete this.privates;}});});},"dojox/grid/enhanced/plugins/Dialog":function(){define(["dojo/_base/declare","dojo/_base/html","dojo/window","dijit/Dialog"],function(_776,html,win,_777){return _776("dojox.grid.enhanced.plugins.Dialog",_777,{refNode:null,_position:function(){if(this.refNode&&!this._relativePosition){var _778=html.position(html.byId(this.refNode)),_779=html.position(this.domNode),_77a=win.getBox();if(_779.w&&_779.h){if(_778.x<0){_778.x=0;}if(_778.x+_778.w>_77a.w){_778.w=_77a.w-_778.x;}if(_778.y<0){_778.y=0;}if(_778.y+_778.h>_77a.h){_778.h=_77a.h-_778.y;}_778.x=_778.x+_778.w/2-_779.w/2;_778.y=_778.y+_778.h/2-_779.h/2;if(_778.x>=0&&_778.x+_779.w<=_77a.w&&_778.y>=0&&_778.y+_779.h<=_77a.h){this._relativePosition=_778;}}}this.inherited(arguments);}});});},"dijit/Dialog":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/Deferred","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/i18n","dojo/keys","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/touch","dojo/window","dojo/dnd/Moveable","dojo/dnd/TimedMoveable","./focus","./_base/manager","./_Widget","./_TemplatedMixin","./_CssStateMixin","./form/_FormMixin","./_DialogMixin","./DialogUnderlay","./layout/ContentPane","./layout/utils","dojo/text!./templates/Dialog.html","./a11yclick","dojo/i18n!./nls/common"],function(_77b,_77c,_77d,_77e,_77f,dom,_780,_781,_782,fx,i18n,keys,lang,on,_783,has,_784,_785,_786,_787,_788,_789,_78a,_78b,_78c,_78d,_78e,_78f,_790,_791,_792){var _793=new _77f();_793.resolve(true);function nop(){};var _794=_77e("dijit._DialogBase"+(has("dojo-bidi")?"_NoBidi":""),[_78b,_78d,_78e,_78c],{templateString:_792,baseClass:"dijitDialog",cssStateNodes:{closeButtonNode:"dijitDialogCloseIcon"},_setTitleAttr:{node:"titleNode",type:"innerHTML"},open:false,duration:_789.defaultDuration,refocus:true,autofocus:true,_firstFocusItem:null,_lastFocusItem:null,draggable:true,_setDraggableAttr:function(val){this._set("draggable",val);},maxRatio:0.9,closable:true,_setClosableAttr:function(val){this.closeButtonNode.style.display=val?"":"none";this._set("closable",val);},postMixInProperties:function(){var _795=i18n.getLocalization("dijit","common");lang.mixin(this,_795);this.inherited(arguments);},postCreate:function(){_782.set(this.domNode,{display:"none",position:"absolute"});this.ownerDocumentBody.appendChild(this.domNode);this.inherited(arguments);_77d.after(this,"onExecute",lang.hitch(this,"hide"),true);_77d.after(this,"onCancel",lang.hitch(this,"hide"),true);on(this.closeButtonNode,_784.press,function(e){e.stopPropagation();});this._modalconnects=[];},onLoad:function(){this.resize();this._position();if(this.autofocus&&_796.isTop(this)){this._getFocusItems();_788.focus(this._firstFocusItem);}this.inherited(arguments);},focus:function(){this._getFocusItems();_788.focus(this._firstFocusItem);},_endDrag:function(){var _797=_781.position(this.domNode),_798=_785.getBox(this.ownerDocument);_797.y=Math.min(Math.max(_797.y,0),(_798.h-_797.h));_797.x=Math.min(Math.max(_797.x,0),(_798.w-_797.w));this._relativePosition=_797;this._position();},_setup:function(){var node=this.domNode;if(this.titleBar&&this.draggable){this._moveable=new ((has("ie")==6)?_787:_786)(node,{handle:this.titleBar});_77d.after(this._moveable,"onMoveStop",lang.hitch(this,"_endDrag"),true);}else{_780.add(node,"dijitDialogFixed");}this.underlayAttrs={dialogId:this.id,"class":_77c.map(this["class"].split(/\s/),function(s){return s+"_underlay";}).join(" "),_onKeyDown:lang.hitch(this,"_onKey"),ownerDocument:this.ownerDocument};},_size:function(){this.resize();},_position:function(){if(!_780.contains(this.ownerDocumentBody,"dojoMove")){var node=this.domNode,_799=_785.getBox(this.ownerDocument),p=this._relativePosition,bb=_781.position(node),l=Math.floor(_799.l+(p?Math.min(p.x,_799.w-bb.w):(_799.w-bb.w)/2)),t=Math.floor(_799.t+(p?Math.min(p.y,_799.h-bb.h):(_799.h-bb.h)/2));_782.set(node,{left:l+"px",top:t+"px"});}},_onKey:function(evt){if(evt.keyCode==keys.TAB){this._getFocusItems();var node=evt.target;if(this._firstFocusItem==this._lastFocusItem){evt.stopPropagation();evt.preventDefault();}else{if(node==this._firstFocusItem&&evt.shiftKey){_788.focus(this._lastFocusItem);evt.stopPropagation();evt.preventDefault();}else{if(node==this._lastFocusItem&&!evt.shiftKey){_788.focus(this._firstFocusItem);evt.stopPropagation();evt.preventDefault();}}}}else{if(this.closable&&evt.keyCode==keys.ESCAPE){this.onCancel();evt.stopPropagation();evt.preventDefault();}}},show:function(){if(this.open){return _793.promise;}if(!this._started){this.startup();}if(!this._alreadyInitialized){this._setup();this._alreadyInitialized=true;}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();_796.hide(this);}var win=_785.get(this.ownerDocument);this._modalconnects.push(on(win,"scroll",lang.hitch(this,"resize",null)));this._modalconnects.push(on(this.domNode,"keydown",lang.hitch(this,"_onKey")));_782.set(this.domNode,{opacity:0,display:""});this._set("open",true);this._onShow();this.resize();this._position();var _79a;this._fadeInDeferred=new _77f(lang.hitch(this,function(){_79a.stop();delete this._fadeInDeferred;}));this._fadeInDeferred.then(undefined,nop);var _79b=this._fadeInDeferred.promise;_79a=fx.fadeIn({node:this.domNode,duration:this.duration,beforeBegin:lang.hitch(this,function(){_796.show(this,this.underlayAttrs);}),onEnd:lang.hitch(this,function(){if(this.autofocus&&_796.isTop(this)){this._getFocusItems();_788.focus(this._firstFocusItem);}this._fadeInDeferred.resolve(true);delete this._fadeInDeferred;})}).play();return _79b;},hide:function(){if(!this._alreadyInitialized||!this.open){return _793.promise;}if(this._fadeInDeferred){this._fadeInDeferred.cancel();}var _79c;this._fadeOutDeferred=new _77f(lang.hitch(this,function(){_79c.stop();delete this._fadeOutDeferred;}));this._fadeOutDeferred.then(undefined,nop);this._fadeOutDeferred.then(lang.hitch(this,"onHide"));var _79d=this._fadeOutDeferred.promise;_79c=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,function(){this.domNode.style.display="none";_796.hide(this);this._fadeOutDeferred.resolve(true);delete this._fadeOutDeferred;})}).play();if(this._scrollConnected){this._scrollConnected=false;}var h;while(h=this._modalconnects.pop()){h.remove();}if(this._relativePosition){delete this._relativePosition;}this._set("open",false);return _79d;},resize:function(dim){if(this.domNode.style.display!="none"){this._checkIfSingleChild();if(!dim){if(this._shrunk){if(this._singleChild){if(typeof this._singleChildOriginalStyle!="undefined"){this._singleChild.domNode.style.cssText=this._singleChildOriginalStyle;delete this._singleChildOriginalStyle;}}_77c.forEach([this.domNode,this.containerNode,this.titleBar,this.actionBarNode],function(node){if(node){_782.set(node,{position:"static",width:"auto",height:"auto"});}});this.domNode.style.position="absolute";}var _79e=_785.getBox(this.ownerDocument);_79e.w*=this.maxRatio;_79e.h*=this.maxRatio;var bb=_781.position(this.domNode);this._shrunk=false;if(bb.w>=_79e.w){dim={w:_79e.w};_781.setMarginBox(this.domNode,dim);bb=_781.position(this.domNode);this._shrunk=true;}if(bb.h>=_79e.h){if(!dim){dim={w:bb.w};}dim.h=_79e.h;this._shrunk=true;}if(dim){if(!dim.w){dim.w=bb.w;}if(!dim.h){dim.h=bb.h;}}}if(dim){_781.setMarginBox(this.domNode,dim);var _79f=[];if(this.titleBar){_79f.push({domNode:this.titleBar,region:"top"});}if(this.actionBarNode){_79f.push({domNode:this.actionBarNode,region:"bottom"});}var _7a0={domNode:this.containerNode,region:"center"};_79f.push(_7a0);var _7a1=_791.marginBox2contentBox(this.domNode,dim);_791.layoutChildren(this.domNode,_7a1,_79f);if(this._singleChild){var cb=_791.marginBox2contentBox(this.containerNode,_7a0);this._singleChild.resize({w:cb.w,h:cb.h});}else{this.containerNode.style.overflow="auto";this._layoutChildren();}}else{this._layoutChildren();}if(!has("touch")&&!dim){this._position();}}},_layoutChildren:function(){_77c.forEach(this.getChildren(),function(_7a2){if(_7a2.resize){_7a2.resize();}});},destroy:function(){if(this._fadeInDeferred){this._fadeInDeferred.cancel();}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();}if(this._moveable){this._moveable.destroy();}var h;while(h=this._modalconnects.pop()){h.remove();}_796.hide(this);this.inherited(arguments);}});if(has("dojo-bidi")){_794=_77e("dijit._DialogBase",_794,{_setTitleAttr:function(_7a3){this._set("title",_7a3);this.titleNode.innerHTML=_7a3;this.applyTextDir(this.titleNode);},_setTextDirAttr:function(_7a4){if(this._created&&this.textDir!=_7a4){this._set("textDir",_7a4);this.set("title",this.title);}}});}var _7a5=_77e("dijit.Dialog",[_790,_794],{});_7a5._DialogBase=_794;var _796=_7a5._DialogLevelManager={_beginZIndex:950,show:function(_7a6,_7a7){ds[ds.length-1].focus=_788.curNode;var _7a8=ds[ds.length-1].dialog?ds[ds.length-1].zIndex+2:_7a5._DialogLevelManager._beginZIndex;_782.set(_7a6.domNode,"zIndex",_7a8);_78f.show(_7a7,_7a8-1);ds.push({dialog:_7a6,underlayAttrs:_7a7,zIndex:_7a8});},hide:function(_7a9){if(ds[ds.length-1].dialog==_7a9){ds.pop();var pd=ds[ds.length-1];if(ds.length==1){_78f.hide();}else{_78f.show(pd.underlayAttrs,pd.zIndex-1);}if(_7a9.refocus){var _7aa=pd.focus;if(pd.dialog&&(!_7aa||!dom.isDescendant(_7aa,pd.dialog.domNode))){pd.dialog._getFocusItems();_7aa=pd.dialog._firstFocusItem;}if(_7aa){try{_7aa.focus();}catch(e){}}}}else{var idx=_77c.indexOf(_77c.map(ds,function(elem){return elem.dialog;}),_7a9);if(idx!=-1){ds.splice(idx,1);}}},isTop:function(_7ab){return ds[ds.length-1].dialog==_7ab;}};var ds=_7a5._dialogStack=[{dialog:null,focus:null,underlayAttrs:null}];_788.watch("curNode",function(attr,_7ac,node){var _7ad=ds[ds.length-1].dialog;if(node&&_7ad&&!_7ad._fadeOutDeferred&&node.ownerDocument==_7ad.ownerDocument){do{if(node==_7ad.domNode||_780.contains(node,"dijitPopup")){return;}}while(node=node.parentNode);_7ad.focus();}});if(has("dijit-legacy-requires")){_783(0,function(){var _7ae=["dijit/TooltipDialog"];_77b(_7ae);});}return _7a5;});},"dojo/dnd/TimedMoveable":function(){define(["../_base/declare","./Moveable"],function(_7af,_7b0){var _7b1=_7b0.prototype.onMove;return _7af("dojo.dnd.TimedMoveable",_7b0,{timeout:40,constructor:function(node,_7b2){if(!_7b2){_7b2={};}if(_7b2.timeout&&typeof _7b2.timeout=="number"&&_7b2.timeout>=0){this.timeout=_7b2.timeout;}},onMoveStop:function(_7b3){if(_7b3._timer){clearTimeout(_7b3._timer);_7b1.call(this,_7b3,_7b3._leftTop);}_7b0.prototype.onMoveStop.apply(this,arguments);},onMove:function(_7b4,_7b5){_7b4._leftTop=_7b5;if(!_7b4._timer){var _7b6=this;_7b4._timer=setTimeout(function(){_7b4._timer=null;_7b1.call(_7b6,_7b4,_7b4._leftTop);},this.timeout);}}});});},"dijit/_base/manager":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_7b7,_7b8,lang,_7b9,_7ba){var _7bb={};_7b7.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_7bb[name]=_7b9[name];});lang.mixin(_7bb,{defaultDuration:_7b8["defaultDuration"]||200});lang.mixin(_7ba,_7bb);return _7ba;});},"dijit/form/_FormMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/window"],function(_7bc,_7bd,_7be,lang,on,_7bf){return _7bd("dijit.form._FormMixin",null,{state:"",_getDescendantFormWidgets:function(_7c0){var res=[];_7bc.forEach(_7c0||this.getChildren(),function(_7c1){if("value" in _7c1){res.push(_7c1);}else{res=res.concat(this._getDescendantFormWidgets(_7c1.getChildren()));}},this);return res;},reset:function(){_7bc.forEach(this._getDescendantFormWidgets(),function(_7c2){if(_7c2.reset){_7c2.reset();}});},validate:function(){var _7c3=false;return _7bc.every(_7bc.map(this._getDescendantFormWidgets(),function(_7c4){_7c4._hasBeenBlurred=true;var _7c5=_7c4.disabled||!_7c4.validate||_7c4.validate();if(!_7c5&&!_7c3){_7bf.scrollIntoView(_7c4.containerNode||_7c4.domNode);_7c4.focus();_7c3=true;}return _7c5;}),function(item){return item;});},setValues:function(val){_7be.deprecated(this.declaredClass+"::setValues() is deprecated. Use set('value', val) instead.","","2.0");return this.set("value",val);},_setValueAttr:function(obj){var map={};_7bc.forEach(this._getDescendantFormWidgets(),function(_7c6){if(!_7c6.name){return;}var _7c7=map[_7c6.name]||(map[_7c6.name]=[]);_7c7.push(_7c6);});for(var name in map){if(!map.hasOwnProperty(name)){continue;}var _7c8=map[name],_7c9=lang.getObject(name,false,obj);if(_7c9===undefined){continue;}_7c9=[].concat(_7c9);if(typeof _7c8[0].checked=="boolean"){_7bc.forEach(_7c8,function(w){w.set("value",_7bc.indexOf(_7c9,w._get("value"))!=-1);});}else{if(_7c8[0].multiple){_7c8[0].set("value",_7c9);}else{_7bc.forEach(_7c8,function(w,i){w.set("value",_7c9[i]);});}}}},getValues:function(){_7be.deprecated(this.declaredClass+"::getValues() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},_getValueAttr:function(){var obj={};_7bc.forEach(this._getDescendantFormWidgets(),function(_7ca){var name=_7ca.name;if(!name||_7ca.disabled){return;}var _7cb=_7ca.get("value");if(typeof _7ca.checked=="boolean"){if(/Radio/.test(_7ca.declaredClass)){if(_7cb!==false){lang.setObject(name,_7cb,obj);}else{_7cb=lang.getObject(name,false,obj);if(_7cb===undefined){lang.setObject(name,null,obj);}}}else{var ary=lang.getObject(name,false,obj);if(!ary){ary=[];lang.setObject(name,ary,obj);}if(_7cb!==false){ary.push(_7cb);}}}else{var prev=lang.getObject(name,false,obj);if(typeof prev!="undefined"){if(lang.isArray(prev)){prev.push(_7cb);}else{lang.setObject(name,[prev,_7cb],obj);}}else{lang.setObject(name,_7cb,obj);}}});return obj;},isValid:function(){return this.state=="";},onValidStateChange:function(){},_getState:function(){var _7cc=_7bc.map(this._descendants,function(w){return w.get("state")||"";});return _7bc.indexOf(_7cc,"Error")>=0?"Error":_7bc.indexOf(_7cc,"Incomplete")>=0?"Incomplete":"";},disconnectChildren:function(){},connectChildren:function(_7cd){this._descendants=this._getDescendantFormWidgets();_7bc.forEach(this._descendants,function(_7ce){if(!_7ce._started){_7ce.startup();}});if(!_7cd){this._onChildChange();}},_onChildChange:function(attr){if(!attr||attr=="state"||attr=="disabled"){this._set("state",this._getState());}if(!attr||attr=="value"||attr=="disabled"||attr=="checked"){if(this._onChangeDelayTimer){this._onChangeDelayTimer.remove();}this._onChangeDelayTimer=this.defer(function(){delete this._onChangeDelayTimer;this._set("value",this.get("value"));},10);}},startup:function(){this.inherited(arguments);this._descendants=this._getDescendantFormWidgets();this.value=this.get("value");this.state=this._getState();var self=this;this.own(on(this.containerNode,"attrmodified-state, attrmodified-disabled, attrmodified-value, attrmodified-checked",function(evt){if(evt.target==self.domNode){return;}self._onChildChange(evt.type.replace("attrmodified-",""));}));this.watch("state",function(attr,_7cf,_7d0){this.onValidStateChange(_7d0=="");});},destroy:function(){this.inherited(arguments);}});});},"dijit/_DialogMixin":function(){define(["dojo/_base/declare","./a11y"],function(_7d1,a11y){return _7d1("dijit._DialogMixin",null,{actionBarTemplate:"",execute:function(){},onCancel:function(){},onExecute:function(){},_onSubmit:function(){this.onExecute();this.execute(this.get("value"));},_getFocusItems:function(){var _7d2=a11y._getTabNavigable(this.domNode);this._firstFocusItem=_7d2.lowest||_7d2.first||this.closeButtonNode||this.domNode;this._lastFocusItem=_7d2.last||_7d2.highest||this._firstFocusItem;}});});},"dijit/DialogUnderlay":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/aspect","dojo/dom-attr","dojo/dom-style","dojo/on","dojo/window","./_Widget","./_TemplatedMixin","./BackgroundIframe","./Viewport","./main"],function(_7d3,lang,_7d4,_7d5,_7d6,on,_7d7,_7d8,_7d9,_7da,_7db,_7dc){var _7dd=_7d3("dijit.DialogUnderlay",[_7d8,_7d9],{templateString:"<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' tabIndex='-1' data-dojo-attach-point='node'></div></div>",dialogId:"","class":"",_modalConnects:[],_setDialogIdAttr:function(id){_7d5.set(this.node,"id",id+"_underlay");this._set("dialogId",id);},_setClassAttr:function(_7de){this.node.className="dijitDialogUnderlay "+_7de;this._set("class",_7de);},postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKeyDown")));this.inherited(arguments);},layout:function(){var is=this.node.style,os=this.domNode.style;os.display="none";var _7df=_7d7.getBox(this.ownerDocument);os.top=_7df.t+"px";os.left=_7df.l+"px";is.width=_7df.w+"px";is.height=_7df.h+"px";os.display="block";},show:function(){this.domNode.style.display="block";this.open=true;this.layout();this.bgIframe=new _7da(this.domNode);var win=_7d7.get(this.ownerDocument);this._modalConnects=[_7db.on("resize",lang.hitch(this,"layout")),on(win,"scroll",lang.hitch(this,"layout"))];},hide:function(){this.bgIframe.destroy();delete this.bgIframe;this.domNode.style.display="none";while(this._modalConnects.length){(this._modalConnects.pop()).remove();}this.open=false;},destroy:function(){while(this._modalConnects.length){(this._modalConnects.pop()).remove();}this.inherited(arguments);},_onKeyDown:function(){}});_7dd.show=function(_7e0,_7e1){var _7e2=_7dd._singleton;if(!_7e2||_7e2._destroyed){_7e2=_7dc._underlay=_7dd._singleton=new _7dd(_7e0);}else{if(_7e0){_7e2.set(_7e0);}}_7d6.set(_7e2.domNode,"zIndex",_7e1);if(!_7e2.open){_7e2.show();}};_7dd.hide=function(){var _7e3=_7dd._singleton;if(_7e3&&!_7e3._destroyed){_7e3.hide();}};return _7dd;});},"dijit/BackgroundIframe":function(){define(["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff"],function(_7e4,_7e5,_7e6,_7e7,_7e8,lang,on,has){has.add("config-bgIframe",(has("ie")||has("trident"))&&!/IEMobile\/10\.0/.test(navigator.userAgent));var _7e9=new function(){var _7ea=[];this.pop=function(){var _7eb;if(_7ea.length){_7eb=_7ea.pop();_7eb.style.display="";}else{if(has("ie")<9){var burl=_7e6["dojoBlankHtmlUrl"]||_7e4.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_7eb=document.createElement(html);}else{_7eb=_7e7.create("iframe");_7eb.src="javascript:\"\"";_7eb.className="dijitBackgroundIframe";_7eb.setAttribute("role","presentation");_7e8.set(_7eb,"opacity",0.1);}_7eb.tabIndex=-1;}return _7eb;};this.push=function(_7ec){_7ec.style.display="none";_7ea.push(_7ec);};}();_7e5.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("config-bgIframe")){var _7ed=(this.iframe=_7e9.pop());node.appendChild(_7ed);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,"resize",node));}else{_7e8.set(_7ed,{width:"100%",height:"100%"});}}};lang.extend(_7e5.BackgroundIframe,{resize:function(node){if(this.iframe){_7e8.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){this.iframe.parentNode.removeChild(this.iframe);_7e9.push(this.iframe);delete this.iframe;}}});return _7e5.BackgroundIframe;});},"dijit/Viewport":function(){define(["dojo/Evented","dojo/on","dojo/domReady","dojo/sniff","dojo/window"],function(_7ee,on,_7ef,has,_7f0){var _7f1=new _7ee();var _7f2;_7ef(function(){var _7f3=_7f0.getBox();_7f1._rlh=on(window,"resize",function(){var _7f4=_7f0.getBox();if(_7f3.h==_7f4.h&&_7f3.w==_7f4.w){return;}_7f3=_7f4;_7f1.emit("resize");});if(has("ie")==8){var _7f5=screen.deviceXDPI;setInterval(function(){if(screen.deviceXDPI!=_7f5){_7f5=screen.deviceXDPI;_7f1.emit("resize");}},500);}if(has("ios")){on(document,"focusin",function(evt){_7f2=evt.target;});on(document,"focusout",function(evt){_7f2=null;});}});_7f1.getEffectiveBox=function(doc){var box=_7f0.getBox(doc);var tag=_7f2&&_7f2.tagName&&_7f2.tagName.toLowerCase();if(has("ios")&&_7f2&&!_7f2.readOnly&&(tag=="textarea"||(tag=="input"&&/^(color|email|number|password|search|tel|text|url)$/.test(_7f2.type)))){box.h*=(orientation==0||orientation==180?0.66:0.4);var rect=_7f2.getBoundingClientRect();box.h=Math.max(box.h,rect.top+rect.height);}return box;};return _7f1;});},"dijit/layout/ContentPane":function(){define(["dojo/_base/kernel","dojo/_base/lang","../_Widget","../_Container","./_ContentPaneResizeMixin","dojo/string","dojo/html","dojo/_base/array","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/_base/xhr","dojo/i18n","dojo/when","dojo/i18n!../nls/loading"],function(_7f6,lang,_7f7,_7f8,_7f9,_7fa,html,_7fb,_7fc,_7fd,dom,_7fe,_7ff,xhr,i18n,when){return _7fc("dijit.layout.ContentPane",[_7f7,_7f8,_7f9],{href:"",content:"",extractContent:false,parseOnLoad:true,parserScope:_7f6._scopeName,preventCache:false,preload:false,refreshOnShow:false,loadingMessage:"<span class='dijitContentPaneLoading'><span class='dijitInline dijitIconLoading'></span>${loadingState}</span>",errorMessage:"<span class='dijitContentPaneError'><span class='dijitInline dijitIconError'></span>${errorState}</span>",isLoaded:false,baseClass:"dijitContentPane",ioArgs:{},onLoadDeferred:null,_setTitleAttr:null,stopParser:true,template:false,markupFactory:function(_800,node,ctor){var self=new ctor(_800,node);return !self.href&&self._contentSetter&&self._contentSetter.parseDeferred&&!self._contentSetter.parseDeferred.isFulfilled()?self._contentSetter.parseDeferred.then(function(){return self;}):self;},create:function(_801,_802){if((!_801||!_801.template)&&_802&&!("href" in _801)&&!("content" in _801)){_802=dom.byId(_802);var df=_802.ownerDocument.createDocumentFragment();while(_802.firstChild){df.appendChild(_802.firstChild);}_801=lang.delegate(_801,{content:df});}this.inherited(arguments,[_801,_802]);},postMixInProperties:function(){this.inherited(arguments);var _803=i18n.getLocalization("dijit","loading",this.lang);this.loadingMessage=_7fa.substitute(this.loadingMessage,_803);this.errorMessage=_7fa.substitute(this.errorMessage,_803);},buildRendering:function(){this.inherited(arguments);if(!this.containerNode){this.containerNode=this.domNode;}this.domNode.removeAttribute("title");},startup:function(){this.inherited(arguments);if(this._contentSetter){_7fb.forEach(this._contentSetter.parseResults,function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}},this);}},_startChildren:function(){_7fb.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});if(this._contentSetter){_7fb.forEach(this._contentSetter.parseResults,function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}},this);}},setHref:function(href){_7f6.deprecated("dijit.layout.ContentPane.setHref() is deprecated. Use set('href', ...) instead.","","2.0");return this.set("href",href);},_setHrefAttr:function(href){this.cancel();this.onLoadDeferred=new _7fd(lang.hitch(this,"cancel"));this.onLoadDeferred.then(lang.hitch(this,"onLoad"));this._set("href",href);if(this.preload||(this._created&&this._isShown())){this._load();}else{this._hrefChanged=true;}return this.onLoadDeferred;},setContent:function(data){_7f6.deprecated("dijit.layout.ContentPane.setContent() is deprecated.  Use set('content', ...) instead.","","2.0");this.set("content",data);},_setContentAttr:function(data){this._set("href","");this.cancel();this.onLoadDeferred=new _7fd(lang.hitch(this,"cancel"));if(this._created){this.onLoadDeferred.then(lang.hitch(this,"onLoad"));}this._setContent(data||"");this._isDownloaded=false;return this.onLoadDeferred;},_getContentAttr:function(){return this.containerNode.innerHTML;},cancel:function(){if(this._xhrDfd&&(this._xhrDfd.fired==-1)){this._xhrDfd.cancel();}delete this._xhrDfd;this.onLoadDeferred=null;},destroy:function(){this.cancel();this.inherited(arguments);},destroyRecursive:function(_804){if(this._beingDestroyed){return;}this.inherited(arguments);},_onShow:function(){this.inherited(arguments);if(this.href){if(!this._xhrDfd&&(!this.isLoaded||this._hrefChanged||this.refreshOnShow)){return this.refresh();}}},refresh:function(){this.cancel();this.onLoadDeferred=new _7fd(lang.hitch(this,"cancel"));this.onLoadDeferred.then(lang.hitch(this,"onLoad"));this._load();return this.onLoadDeferred;},_load:function(){this._setContent(this.onDownloadStart(),true);var self=this;var _805={preventCache:(this.preventCache||this.refreshOnShow),url:this.href,handleAs:"text"};if(lang.isObject(this.ioArgs)){lang.mixin(_805,this.ioArgs);}var hand=(this._xhrDfd=(this.ioMethod||xhr.get)(_805)),_806;hand.then(function(html){_806=html;try{self._isDownloaded=true;return self._setContent(html,false);}catch(err){self._onError("Content",err);}},function(err){if(!hand.canceled){self._onError("Download",err);}delete self._xhrDfd;return err;}).then(function(){self.onDownloadEnd();delete self._xhrDfd;return _806;});delete this._hrefChanged;},_onLoadHandler:function(data){this._set("isLoaded",true);try{this.onLoadDeferred.resolve(data);}catch(e){console.error("Error "+(this.widgetId||this.id)+" running custom onLoad code: "+e.message);}},_onUnloadHandler:function(){this._set("isLoaded",false);try{this.onUnload();}catch(e){console.error("Error "+this.widgetId+" running custom onUnload code: "+e.message);}},destroyDescendants:function(_807){if(this.isLoaded){this._onUnloadHandler();}var _808=this._contentSetter;_7fb.forEach(this.getChildren(),function(_809){if(_809.destroyRecursive){_809.destroyRecursive(_807);}else{if(_809.destroy){_809.destroy(_807);}}_809._destroyed=true;});if(_808){_7fb.forEach(_808.parseResults,function(_80a){if(!_80a._destroyed){if(_80a.destroyRecursive){_80a.destroyRecursive(_807);}else{if(_80a.destroy){_80a.destroy(_807);}}_80a._destroyed=true;}});delete _808.parseResults;}if(!_807){_7ff.empty(this.containerNode);}delete this._singleChild;},_setContent:function(cont,_80b){cont=this.preprocessContent(cont);this.destroyDescendants();var _80c=this._contentSetter;if(!(_80c&&_80c instanceof html._ContentSetter)){_80c=this._contentSetter=new html._ContentSetter({node:this.containerNode,_onError:lang.hitch(this,this._onError),onContentError:lang.hitch(this,function(e){var _80d=this.onContentError(e);try{this.containerNode.innerHTML=_80d;}catch(e){console.error("Fatal "+this.id+" could not change content due to "+e.message,e);}})});}var _80e=lang.mixin({cleanContent:this.cleanContent,extractContent:this.extractContent,parseContent:!cont.domNode&&this.parseOnLoad,parserScope:this.parserScope,startup:false,dir:this.dir,lang:this.lang,textDir:this.textDir},this._contentSetterParams||{});var p=_80c.set((lang.isObject(cont)&&cont.domNode)?cont.domNode:cont,_80e);var self=this;return when(p&&p.then?p:_80c.parseDeferred,function(){delete self._contentSetterParams;if(!_80b){if(self._started){self._startChildren();self._scheduleLayout();}self._onLoadHandler(cont);}});},preprocessContent:function(_80f){return _80f;},_onError:function(type,err,_810){this.onLoadDeferred.reject(err);var _811=this["on"+type+"Error"].call(this,err);if(_810){console.error(_810,err);}else{if(_811){this._setContent(_811,true);}}},onLoad:function(){},onUnload:function(){},onDownloadStart:function(){return this.loadingMessage;},onContentError:function(){},onDownloadError:function(){return this.errorMessage;},onDownloadEnd:function(){}});});},"dijit/_Container":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/_base/kernel"],function(_812,_813,_814,_815){return _813("dijit._Container",null,{buildRendering:function(){this.inherited(arguments);if(!this.containerNode){this.containerNode=this.domNode;}},addChild:function(_816,_817){var _818=this.containerNode;if(_817>0){_818=_818.firstChild;while(_817>0){if(_818.nodeType==1){_817--;}_818=_818.nextSibling;}if(_818){_817="before";}else{_818=this.containerNode;_817="last";}}_814.place(_816.domNode,_818,_817);if(this._started&&!_816._started){_816.startup();}},removeChild:function(_819){if(typeof _819=="number"){_819=this.getChildren()[_819];}if(_819){var node=_819.domNode;if(node&&node.parentNode){node.parentNode.removeChild(node);}}},hasChildren:function(){return this.getChildren().length>0;},_getSiblingOfChild:function(_81a,dir){var _81b=this.getChildren(),idx=_812.indexOf(_81b,_81a);return _81b[idx+dir];},getIndexOfChild:function(_81c){return _812.indexOf(this.getChildren(),_81c);}});});},"dijit/layout/_ContentPaneResizeMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/query","../registry","../Viewport","./utils"],function(_81d,_81e,_81f,_820,_821,lang,_822,_823,_824,_825){return _81e("dijit.layout._ContentPaneResizeMixin",null,{doLayout:true,isLayoutContainer:true,startup:function(){if(this._started){return;}var _826=this.getParent();this._childOfLayoutWidget=_826&&_826.isLayoutContainer;this._needLayout=!this._childOfLayoutWidget;this.inherited(arguments);if(this._isShown()){this._onShow();}if(!this._childOfLayoutWidget){this.own(_824.on("resize",lang.hitch(this,"resize")));}},_checkIfSingleChild:function(){if(!this.doLayout){return;}var _827=[],_828=false;_822("> *",this.containerNode).some(function(node){var _829=_823.byNode(node);if(_829&&_829.resize){_827.push(_829);}else{if(!/script|link|style/i.test(node.nodeName)&&node.offsetHeight){_828=true;}}});this._singleChild=_827.length==1&&!_828?_827[0]:null;_81f.toggle(this.containerNode,this.baseClass+"SingleChild",!!this._singleChild);},resize:function(_82a,_82b){this._resizeCalled=true;this._scheduleLayout(_82a,_82b);},_scheduleLayout:function(_82c,_82d){if(this._isShown()){this._layout(_82c,_82d);}else{this._needLayout=true;this._changeSize=_82c;this._resultSize=_82d;}},_layout:function(_82e,_82f){delete this._needLayout;if(!this._wasShown&&this.open!==false){this._onShow();}if(_82e){_820.setMarginBox(this.domNode,_82e);}var cn=this.containerNode;if(cn===this.domNode){var mb=_82f||{};lang.mixin(mb,_82e||{});if(!("h" in mb)||!("w" in mb)){mb=lang.mixin(_820.getMarginBox(cn),mb);}this._contentBox=_825.marginBox2contentBox(cn,mb);}else{this._contentBox=_820.getContentBox(cn);}this._layoutChildren();},_layoutChildren:function(){this._checkIfSingleChild();if(this._singleChild&&this._singleChild.resize){var cb=this._contentBox||_820.getContentBox(this.containerNode);this._singleChild.resize({w:cb.w,h:cb.h});}else{var _830=this.getChildren(),_831,i=0;while(_831=_830[i++]){if(_831.resize){_831.resize();}}}},_isShown:function(){if(this._childOfLayoutWidget){if(this._resizeCalled&&"open" in this){return this.open;}return this._resizeCalled;}else{if("open" in this){return this.open;}else{var node=this.domNode,_832=this.domNode.parentNode;return (node.style.display!="none")&&(node.style.visibility!="hidden")&&!_81f.contains(node,"dijitHidden")&&_832&&_832.style&&(_832.style.display!="none");}}},_onShow:function(){this._wasShown=true;if(this._needLayout){this._layout(this._changeSize,this._resultSize);}this.inherited(arguments);}});});},"dijit/layout/utils":function(){define(["dojo/_base/array","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang"],function(_833,_834,_835,_836,lang){function _837(word){return word.substring(0,1).toUpperCase()+word.substring(1);};function size(_838,dim){var _839=_838.resize?_838.resize(dim):_835.setMarginBox(_838.domNode,dim);if(_839){lang.mixin(_838,_839);}else{lang.mixin(_838,_835.getMarginBox(_838.domNode));lang.mixin(_838,dim);}};var _83a={marginBox2contentBox:function(node,mb){var cs=_836.getComputedStyle(node);var me=_835.getMarginExtents(node,cs);var pb=_835.getPadBorderExtents(node,cs);return {l:_836.toPixelValue(node,cs.paddingLeft),t:_836.toPixelValue(node,cs.paddingTop),w:mb.w-(me.w+pb.w),h:mb.h-(me.h+pb.h)};},layoutChildren:function(_83b,dim,_83c,_83d,_83e){dim=lang.mixin({},dim);_834.add(_83b,"dijitLayoutContainer");_83c=_833.filter(_83c,function(item){return item.region!="center"&&item.layoutAlign!="client";}).concat(_833.filter(_83c,function(item){return item.region=="center"||item.layoutAlign=="client";}));_833.forEach(_83c,function(_83f){var elm=_83f.domNode,pos=(_83f.region||_83f.layoutAlign);if(!pos){throw new Error("No region setting for "+_83f.id);}var _840=elm.style;_840.left=dim.l+"px";_840.top=dim.t+"px";_840.position="absolute";_834.add(elm,"dijitAlign"+_837(pos));var _841={};if(_83d&&_83d==_83f.id){_841[_83f.region=="top"||_83f.region=="bottom"?"h":"w"]=_83e;}if(pos=="leading"){pos=_83f.isLeftToRight()?"left":"right";}if(pos=="trailing"){pos=_83f.isLeftToRight()?"right":"left";}if(pos=="top"||pos=="bottom"){_841.w=dim.w;size(_83f,_841);dim.h-=_83f.h;if(pos=="top"){dim.t+=_83f.h;}else{_840.top=dim.t+dim.h+"px";}}else{if(pos=="left"||pos=="right"){_841.h=dim.h;size(_83f,_841);dim.w-=_83f.w;if(pos=="left"){dim.l+=_83f.w;}else{_840.left=dim.l+dim.w+"px";}}else{if(pos=="client"||pos=="center"){size(_83f,dim);}}}});}};lang.setObject("dijit.layout.utils",_83a);return _83a;});},"dojo/html":function(){define(["./_base/kernel","./_base/lang","./_base/array","./_base/declare","./dom","./dom-construct","./parser"],function(_842,lang,_843,_844,dom,_845,_846){var _847=0;var html={_secureForInnerHtml:function(cont){return cont.replace(/(?:\s*<!DOCTYPE\s[^>]+>|<title[^>]*>[\s\S]*?<\/title>)/ig,"");},_emptyNode:_845.empty,_setNodeContent:function(node,cont){_845.empty(node);if(cont){if(typeof cont=="number"){cont=cont.toString();}if(typeof cont=="string"){cont=_845.toDom(cont,node.ownerDocument);}if(!cont.nodeType&&lang.isArrayLike(cont)){for(var _848=cont.length,i=0;i<cont.length;i=_848==cont.length?i+1:0){_845.place(cont[i],node,"last");}}else{_845.place(cont,node,"last");}}return node;},_ContentSetter:_844("dojo.html._ContentSetter",null,{node:"",content:"",id:"",cleanContent:false,extractContent:false,parseContent:false,parserScope:_842._scopeName,startup:true,constructor:function(_849,node){lang.mixin(this,_849||{});node=this.node=dom.byId(this.node||node);if(!this.id){this.id=["Setter",(node)?node.id||node.tagName:"",_847++].join("_");}},set:function(cont,_84a){if(undefined!==cont){this.content=cont;}if(typeof cont=="number"){cont=cont.toString();}if(_84a){this._mixin(_84a);}this.onBegin();this.setContent();var ret=this.onEnd();if(ret&&ret.then){return ret;}else{return this.node;}},setContent:function(){var node=this.node;if(!node){throw new Error(this.declaredClass+": setContent given no node");}try{node=html._setNodeContent(node,this.content);}catch(e){var _84b=this.onContentError(e);try{node.innerHTML=_84b;}catch(e){console.error("Fatal "+this.declaredClass+".setContent could not change content due to "+e.message,e);}}this.node=node;},empty:function(){if(this.parseDeferred){if(!this.parseDeferred.isResolved()){this.parseDeferred.cancel();}delete this.parseDeferred;}if(this.parseResults&&this.parseResults.length){_843.forEach(this.parseResults,function(w){if(w.destroy){w.destroy();}});delete this.parseResults;}_845.empty(this.node);},onBegin:function(){var cont=this.content;if(lang.isString(cont)){if(this.cleanContent){cont=html._secureForInnerHtml(cont);}if(this.extractContent){var _84c=cont.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_84c){cont=_84c[1];}}}this.empty();this.content=cont;return this.node;},onEnd:function(){if(this.parseContent){this._parse();}return this.node;},tearDown:function(){delete this.parseResults;delete this.parseDeferred;delete this.node;delete this.content;},onContentError:function(err){return "Error occurred setting content: "+err;},onExecError:function(err){return "Error occurred executing scripts: "+err;},_mixin:function(_84d){var _84e={},key;for(key in _84d){if(key in _84e){continue;}this[key]=_84d[key];}},_parse:function(){var _84f=this.node;try{var _850={};_843.forEach(["dir","lang","textDir"],function(name){if(this[name]){_850[name]=this[name];}},this);var self=this;this.parseDeferred=_846.parse({rootNode:_84f,noStart:!this.startup,inherited:_850,scope:this.parserScope}).then(function(_851){return self.parseResults=_851;},function(e){self._onError("Content",e,"Error parsing in _ContentSetter#"+self.id);});}catch(e){this._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);}},_onError:function(type,err,_852){var _853=this["on"+type+"Error"].call(this,err);if(_852){console.error(_852,err);}else{if(_853){html._setNodeContent(this.node,_853,true);}}}}),set:function(node,cont,_854){if(undefined==cont){console.warn("dojo.html.set: no cont argument provided, using empty string");cont="";}if(typeof cont=="number"){cont=cont.toString();}if(!_854){return html._setNodeContent(node,cont,true);}else{var op=new html._ContentSetter(lang.mixin(_854,{content:cont,node:node}));return op.set();}}};lang.setObject("dojo.html",html);return html;});},"dojo/parser":function(){define(["require","./_base/kernel","./_base/lang","./_base/array","./_base/config","./dom","./_base/window","./_base/url","./aspect","./promise/all","./date/stamp","./Deferred","./has","./json5","./query","./on","./ready"],function(_855,dojo,_856,_857,_858,dom,_859,_85a,_85b,all,_85c,_85d,has,_85e,_85f,don,_860){new Date("X");var _861;if(has("csp-restrictions")){_861=_85e.parse;}else{_861=function(text){return eval("("+text+")");};}var _862=0;_85b.after(_856,"extend",function(){_862++;},true);function _863(ctor){var map=ctor._nameCaseMap,_864=ctor.prototype;if(!map||map._extendCnt<_862){map=ctor._nameCaseMap={};for(var name in _864){if(name.charAt(0)==="_"){continue;}map[name.toLowerCase()]=name;}map._extendCnt=_862;}return map;};function _865(_866,_867){if(!_867){_867=_855;}var _868=_867._dojoParserCtorMap||(_867._dojoParserCtorMap={});var ts=_866.join();if(!_868[ts]){var _869=[];for(var i=0,l=_866.length;i<l;i++){var t=_866[i];_869[_869.length]=(_868[t]=_868[t]||(_856.getObject(t)||(~t.indexOf("/")&&_867(t))));}var ctor=_869.shift();_868[ts]=_869.length?(ctor.createSubclass?ctor.createSubclass(_869):ctor.extend.apply(ctor,_869)):ctor;}return _868[ts];};var _86a={_clearCache:function(){_862++;_ctorMap={};},_functionFromScript:function(_86b,_86c){var _86d="",_86e="",_86f=(_86b.getAttribute(_86c+"args")||_86b.getAttribute("args")),_870=_86b.getAttribute("with");var _871=(_86f||"").split(/\s*,\s*/);if(_870&&_870.length){_857.forEach(_870.split(/\s*,\s*/),function(part){_86d+="with("+part+"){";_86e+="}";});}return new Function(_871,_86d+_86b.innerHTML+_86e);},instantiate:function(_872,_873,_874){_873=_873||{};_874=_874||{};var _875=(_874.scope||dojo._scopeName)+"Type",_876="data-"+(_874.scope||dojo._scopeName)+"-",_877=_876+"type",_878=_876+"mixins";var list=[];_857.forEach(_872,function(node){var type=_875 in _873?_873[_875]:node.getAttribute(_877)||node.getAttribute(_875);if(type){var _879=node.getAttribute(_878),_87a=_879?[type].concat(_879.split(/\s*,\s*/)):[type];list.push({node:node,types:_87a});}});return this._instantiate(list,_873,_874);},_instantiate:function(_87b,_87c,_87d,_87e){var _87f=_857.map(_87b,function(obj){var ctor=obj.ctor||_865(obj.types,_87d.contextRequire);if(!ctor){throw new Error("Unable to resolve constructor for: '"+obj.types.join()+"'");}return this.construct(ctor,obj.node,_87c,_87d,obj.scripts,obj.inherited);},this);function _880(_881){if(!_87c._started&&!_87d.noStart){_857.forEach(_881,function(_882){if(typeof _882.startup==="function"&&!_882._started){_882.startup();}});}return _881;};if(_87e){return all(_87f).then(_880);}else{return _880(_87f);}},construct:function(ctor,node,_883,_884,_885,_886){var _887=ctor&&ctor.prototype;_884=_884||{};var _888={};if(_884.defaults){_856.mixin(_888,_884.defaults);}if(_886){_856.mixin(_888,_886);}var _889;if(has("dom-attributes-explicit")){_889=node.attributes;}else{if(has("dom-attributes-specified-flag")){_889=_857.filter(node.attributes,function(a){return a.specified;});}else{var _88a=/^input$|^img$/i.test(node.nodeName)?node:node.cloneNode(false),_88b=_88a.outerHTML.replace(/=[^\s"']+|="[^"]*"|='[^']*'/g,"").replace(/^\s*<[a-zA-Z0-9]*\s*/,"").replace(/\s*>.*$/,"");_889=_857.map(_88b.split(/\s+/),function(name){var _88c=name.toLowerCase();return {name:name,value:(node.nodeName=="LI"&&name=="value")||_88c=="enctype"?node.getAttribute(_88c):node.getAttributeNode(_88c).value};});}}var _88d=_884.scope||dojo._scopeName,_88e="data-"+_88d+"-",hash={};if(_88d!=="dojo"){hash[_88e+"props"]="data-dojo-props";hash[_88e+"type"]="data-dojo-type";hash[_88e+"mixins"]="data-dojo-mixins";hash[_88d+"type"]="dojotype";hash[_88e+"id"]="data-dojo-id";}var i=0,item,_88f=[],_890,_891;while(item=_889[i++]){var name=item.name,_892=name.toLowerCase(),_893=item.value;switch(hash[_892]||_892){case "data-dojo-type":case "dojotype":case "data-dojo-mixins":break;case "data-dojo-props":_891=_893;break;case "data-dojo-id":case "jsid":_890=_893;break;case "data-dojo-attach-point":case "dojoattachpoint":_888.dojoAttachPoint=_893;break;case "data-dojo-attach-event":case "dojoattachevent":_888.dojoAttachEvent=_893;break;case "class":_888["class"]=node.className;break;case "style":_888["style"]=node.style&&node.style.cssText;break;default:if(!(name in _887)){var map=_863(ctor);name=map[_892]||name;}if(name in _887){switch(typeof _887[name]){case "string":_888[name]=_893;break;case "number":_888[name]=_893.length?Number(_893):NaN;break;case "boolean":_888[name]=_893.toLowerCase()!="false";break;case "function":if(_893===""||_893.search(/[^\w\.]+/i)!=-1){_888[name]=new Function(_893);}else{_888[name]=_856.getObject(_893,false)||new Function(_893);}_88f.push(name);break;default:var pVal=_887[name];try{_888[name]=(pVal&&"length" in pVal)?(_893?_893.split(/\s*,\s*/):[]):(pVal instanceof Date)?(_893==""?new Date(""):_893=="now"?new Date():_85c.fromISOString(_893)):(pVal instanceof _85a)?(dojo.baseUrl+_893):_861(_893);}catch(error){console.error(error);}}}else{_888[name]=_893;}}}for(var j=0;j<_88f.length;j++){var _894=_88f[j].toLowerCase();node.removeAttribute(_894);node[_894]=null;}if(_891){try{_891=_861.call(_884.propsThis,"{"+_891+"}");_856.mixin(_888,_891);}catch(e){throw new Error(e.toString()+" in data-dojo-props='"+_891+"'");}}_856.mixin(_888,_883);if(!_885){_885=(ctor&&(ctor._noScript||_887._noScript)?[]:_85f("> script[type^='dojo/']",node));}var _895=[],_896=[],_897=[],ons=[];if(_885){for(i=0;i<_885.length;i++){var _898=_885[i];node.removeChild(_898);var _899=(_898.getAttribute(_88e+"event")||_898.getAttribute("event")),prop=_898.getAttribute(_88e+"prop"),_89a=_898.getAttribute(_88e+"method"),_89b=_898.getAttribute(_88e+"advice"),_89c=_898.getAttribute("type"),nf=this._functionFromScript(_898,_88e);if(_899){if(_89c=="dojo/connect"){_895.push({method:_899,func:nf});}else{if(_89c=="dojo/on"){ons.push({event:_899,func:nf});}else{_888[_899]=nf;}}}else{if(_89c=="dojo/aspect"){_895.push({method:_89a,advice:_89b,func:nf});}else{if(_89c=="dojo/watch"){_897.push({prop:prop,func:nf});}else{_896.push(nf);}}}}}var _89d=ctor.markupFactory||_887.markupFactory;var _89e=_89d?_89d(_888,node,ctor):new ctor(_888,node);function _89f(_8a0){if(_890){_856.setObject(_890,_8a0);}for(i=0;i<_895.length;i++){_85b[_895[i].advice||"after"](_8a0,_895[i].method,_856.hitch(_8a0,_895[i].func),true);}for(i=0;i<_896.length;i++){_896[i].call(_8a0);}for(i=0;i<_897.length;i++){_8a0.watch(_897[i].prop,_897[i].func);}for(i=0;i<ons.length;i++){don(_8a0,ons[i].event,ons[i].func);}return _8a0;};if(_89e.then){return _89e.then(_89f);}else{return _89f(_89e);}},scan:function(root,_8a1){var list=[],mids=[],_8a2={};var _8a3=(_8a1.scope||dojo._scopeName)+"Type",_8a4="data-"+(_8a1.scope||dojo._scopeName)+"-",_8a5=_8a4+"type",_8a6=_8a4+"textdir",_8a7=_8a4+"mixins";var node=root.firstChild;var _8a8=_8a1.inherited;if(!_8a8){var _8a9=function _8a9(node,attr){return (node.getAttribute&&node.getAttribute(attr))||(node.parentNode&&_8a9(node.parentNode,attr));};_8a8={dir:_8a9(root,"dir"),lang:_8a9(root,"lang"),textDir:_8a9(root,_8a6)};for(var key in _8a8){if(!_8a8[key]){delete _8a8[key];}}}var _8aa={inherited:_8a8};var _8ab;var _8ac;function _8ad(_8ae){if(!_8ae.inherited){_8ae.inherited={};var node=_8ae.node,_8af=_8ad(_8ae.parent);var _8b0={dir:node.getAttribute("dir")||_8af.dir,lang:node.getAttribute("lang")||_8af.lang,textDir:node.getAttribute(_8a6)||_8af.textDir};for(var key in _8b0){if(_8b0[key]){_8ae.inherited[key]=_8b0[key];}}}return _8ae.inherited;};while(true){if(!node){if(!_8aa||!_8aa.node){break;}node=_8aa.node.nextSibling;_8ac=false;_8aa=_8aa.parent;_8ab=_8aa.scripts;continue;}if(node.nodeType!=1){node=node.nextSibling;continue;}if(_8ab&&node.nodeName.toLowerCase()=="script"){type=node.getAttribute("type");if(type&&/^dojo\/\w/i.test(type)){_8ab.push(node);}node=node.nextSibling;continue;}if(_8ac){node=node.nextSibling;continue;}var type=node.getAttribute(_8a5)||node.getAttribute(_8a3);var _8b1=node.firstChild;if(!type&&(!_8b1||(_8b1.nodeType==3&&!_8b1.nextSibling))){node=node.nextSibling;continue;}var _8b2;var ctor=null;if(type){var _8b3=node.getAttribute(_8a7),_8b4=_8b3?[type].concat(_8b3.split(/\s*,\s*/)):[type];try{ctor=_865(_8b4,_8a1.contextRequire);}catch(e){}if(!ctor){_857.forEach(_8b4,function(t){if(~t.indexOf("/")&&!_8a2[t]){_8a2[t]=true;mids[mids.length]=t;}});}var _8b5=ctor&&!ctor.prototype._noScript?[]:null;_8b2={types:_8b4,ctor:ctor,parent:_8aa,node:node,scripts:_8b5};_8b2.inherited=_8ad(_8b2);list.push(_8b2);}else{_8b2={node:node,scripts:_8ab,parent:_8aa};}_8ab=_8b5;_8ac=node.stopParser||(ctor&&ctor.prototype.stopParser&&!(_8a1.template));_8aa=_8b2;node=_8b1;}var d=new _85d();if(mids.length){if(has("dojo-debug-messages")){console.warn("WARNING: Modules being Auto-Required: "+mids.join(", "));}var r=_8a1.contextRequire||_855;r(mids,function(){d.resolve(_857.filter(list,function(_8b6){if(!_8b6.ctor){try{_8b6.ctor=_865(_8b6.types,_8a1.contextRequire);}catch(e){}}var _8b7=_8b6.parent;while(_8b7&&!_8b7.types){_8b7=_8b7.parent;}var _8b8=_8b6.ctor&&_8b6.ctor.prototype;_8b6.instantiateChildren=!(_8b8&&_8b8.stopParser&&!(_8a1.template));_8b6.instantiate=!_8b7||(_8b7.instantiate&&_8b7.instantiateChildren);return _8b6.instantiate;}));});}else{d.resolve(list);}return d.promise;},_require:function(_8b9,_8ba){var hash=_861("{"+_8b9.innerHTML+"}"),vars=[],mids=[],d=new _85d();var _8bb=(_8ba&&_8ba.contextRequire)||_855;for(var name in hash){vars.push(name);mids.push(hash[name]);}_8bb(mids,function(){for(var i=0;i<vars.length;i++){_856.setObject(vars[i],arguments[i]);}d.resolve(arguments);});return d.promise;},_scanAmd:function(root,_8bc){var _8bd=new _85d(),_8be=_8bd.promise;_8bd.resolve(true);var self=this;_85f("script[type='dojo/require']",root).forEach(function(node){_8be=_8be.then(function(){return self._require(node,_8bc);});node.parentNode.removeChild(node);});return _8be;},parse:function(_8bf,_8c0){if(_8bf&&typeof _8bf!="string"&&!("nodeType" in _8bf)){_8c0=_8bf;_8bf=_8c0.rootNode;}var root=_8bf?dom.byId(_8bf):_859.body();_8c0=_8c0||{};var _8c1=_8c0.template?{template:true}:{},_8c2=[],self=this;var p=this._scanAmd(root,_8c0).then(function(){return self.scan(root,_8c0);}).then(function(_8c3){return self._instantiate(_8c3,_8c1,_8c0,true);}).then(function(_8c4){return _8c2=_8c2.concat(_8c4);}).otherwise(function(e){console.error("dojo/parser::parse() error",e);throw e;});_856.mixin(_8c2,p);return _8c2;}};if(1){dojo.parser=_86a;}if(_858.parseOnLoad){_860(100,_86a,"parse");}return _86a;});},"dojo/_base/url":function(){define(["./kernel"],function(dojo){var ore=new RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$"),ire=new RegExp("^((([^\\[:]+):)?([^@]+)@)?(\\[([^\\]]+)\\]|([^\\[:]*))(:([0-9]+))?$"),_8c5=function(){var n=null,_8c6=arguments,uri=[_8c6[0]];for(var i=1;i<_8c6.length;i++){if(!_8c6[i]){continue;}var _8c7=new _8c5(_8c6[i]+""),_8c8=new _8c5(uri[0]+"");if(_8c7.path==""&&!_8c7.scheme&&!_8c7.authority&&!_8c7.query){if(_8c7.fragment!=n){_8c8.fragment=_8c7.fragment;}_8c7=_8c8;}else{if(!_8c7.scheme){_8c7.scheme=_8c8.scheme;if(!_8c7.authority){_8c7.authority=_8c8.authority;if(_8c7.path.charAt(0)!="/"){var path=_8c8.path.substring(0,_8c8.path.lastIndexOf("/")+1)+_8c7.path;var segs=path.split("/");for(var j=0;j<segs.length;j++){if(segs[j]=="."){if(j==segs.length-1){segs[j]="";}else{segs.splice(j,1);j--;}}else{if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){if(j==(segs.length-1)){segs.splice(j,1);segs[j-1]="";}else{segs.splice(j-1,2);j-=2;}}}}_8c7.path=segs.join("/");}}}}uri=[];if(_8c7.scheme){uri.push(_8c7.scheme,":");}if(_8c7.authority){uri.push("//",_8c7.authority);}uri.push(_8c7.path);if(_8c7.query){uri.push("?",_8c7.query);}if(_8c7.fragment){uri.push("#",_8c7.fragment);}}this.uri=uri.join("");var r=this.uri.match(ore);this.scheme=r[2]||(r[1]?"":n);this.authority=r[4]||(r[3]?"":n);this.path=r[5];this.query=r[7]||(r[6]?"":n);this.fragment=r[9]||(r[8]?"":n);if(this.authority!=n){r=this.authority.match(ire);this.user=r[3]||n;this.password=r[4]||n;this.host=r[6]||r[7];this.port=r[9]||n;}};_8c5.prototype.toString=function(){return this.uri;};return dojo._Url=_8c5;});},"dojo/promise/all":function(){define(["../_base/array","../_base/lang","../Deferred","../when"],function(_8c9,lang,_8ca,when){"use strict";var some=_8c9.some;return function all(_8cb){var _8cc,_8c9;if(lang.isArray(_8cb)){_8c9=_8cb;}else{if(_8cb&&typeof _8cb==="object"){_8cc=_8cb;}}var _8cd;var _8ce=[];if(_8cc){_8c9=[];for(var key in _8cc){if(Object.hasOwnProperty.call(_8cc,key)){_8ce.push(key);_8c9.push(_8cc[key]);}}_8cd={};}else{if(_8c9){_8cd=[];}}if(!_8c9||!_8c9.length){return new _8ca().resolve(_8cd);}var _8cf=new _8ca();_8cf.promise.always(function(){_8cd=_8ce=null;});var _8d0=_8c9.length;some(_8c9,function(_8d1,_8d2){if(!_8cc){_8ce.push(_8d2);}when(_8d1,function(_8d3){if(!_8cf.isFulfilled()){_8cd[_8ce[_8d2]]=_8d3;if(--_8d0===0){_8cf.resolve(_8cd);}}},_8cf.reject);return _8cf.isFulfilled();});return _8cf.promise;};});},"dojo/json5":function(){define(["./json5/parse"],function(_8d4){return {parse:_8d4};});},"dojo/json5/parse":function(){define(["../string","./util"],function(_8d5,util){var _8d6;var _8d7;var _8d8;var pos;var line;var _8d9;var _8da;var key;var root;function _8db(text,_8dc){_8d6=String(text);_8d7="start";_8d8=[];pos=0;line=1;_8d9=0;_8da=undefined;key=undefined;root=undefined;do{_8da=lex();_8dd[_8d7]();}while(_8da.type!=="eof");if(typeof _8dc==="function"){return _8de({"":root},"",_8dc);}return root;};function _8de(_8df,name,_8e0){var _8e1=_8df[name];if(_8e1!=null&&typeof _8e1==="object"){for(var _8e2 in _8e1){var _8e3=_8de(_8e1,_8e2,_8e0);if(_8e3===undefined){delete _8e1[_8e2];}else{_8e1[_8e2]=_8e3;}}}return _8e0.call(_8df,name,_8e1);};var _8e4;var _8e5;var _8e6;var sign;var c;function lex(){_8e4="default";_8e5="";_8e6=false;sign=1;for(;;){c=peek();var _8e7=_8e8[_8e4]();if(_8e7){return _8e7;}}};function peek(){if(_8d6[pos]){return _8d5.fromCodePoint(_8d5.codePointAt(_8d6,pos));}};function read(){var c=peek();if(c==="\n"){line++;_8d9=0;}else{if(c){_8d9+=c.length;}else{_8d9++;}}if(c){pos+=c.length;}return c;};var _8e8={"default":function(){switch(c){case "\t":case "\v":case "\f":case " ":case " ":case "﻿":case "\n":case "\r":case " ":case " ":read();return;case "/":read();_8e4="comment";return;case undefined:read();return _8e9("eof");}if(util.isSpaceSeparator(c)){read();return;}return _8e8[_8d7]();},comment:function(){switch(c){case "*":read();_8e4="multiLineComment";return;case "/":read();_8e4="singleLineComment";return;}throw _8ea(read());},multiLineComment:function(){switch(c){case "*":read();_8e4="multiLineCommentAsterisk";return;case undefined:throw _8ea(read());}read();},multiLineCommentAsterisk:function(){switch(c){case "*":read();return;case "/":read();_8e4="default";return;case undefined:throw _8ea(read());}read();_8e4="multiLineComment";},singleLineComment:function(){switch(c){case "\n":case "\r":case " ":case " ":read();_8e4="default";return;case undefined:read();return _8e9("eof");}read();},value:function(){switch(c){case "{":case "[":return _8e9("punctuator",read());case "n":read();_8eb("ull");return _8e9("null",null);case "t":read();_8eb("rue");return _8e9("boolean",true);case "f":read();_8eb("alse");return _8e9("boolean",false);case "-":case "+":if(read()==="-"){sign=-1;}_8e4="sign";return;case ".":_8e5=read();_8e4="decimalPointLeading";return;case "0":_8e5=read();_8e4="zero";return;case "1":case "2":case "3":case "4":case "5":case "6":case "7":case "8":case "9":_8e5=read();_8e4="decimalInteger";return;case "I":read();_8eb("nfinity");return _8e9("numeric",Infinity);case "N":read();_8eb("aN");return _8e9("numeric",NaN);case "\"":case "'":_8e6=(read()==="\"");_8e5="";_8e4="string";return;}throw _8ea(read());},identifierNameStartEscape:function(){if(c!=="u"){throw _8ea(read());}read();var u=_8ec();switch(u){case "$":case "_":break;default:if(!util.isIdStartChar(u)){throw _8ed();}break;}_8e5+=u;_8e4="identifierName";},identifierName:function(){switch(c){case "$":case "_":case "‌":case "‍":_8e5+=read();return;case "\\":read();_8e4="identifierNameEscape";return;}if(util.isIdContinueChar(c)){_8e5+=read();return;}return _8e9("identifier",_8e5);},identifierNameEscape:function(){if(c!=="u"){throw _8ea(read());}read();var u=_8ec();switch(u){case "$":case "_":case "‌":case "‍":break;default:if(!util.isIdContinueChar(u)){throw _8ed();}break;}_8e5+=u;_8e4="identifierName";},sign:function(){switch(c){case ".":_8e5=read();_8e4="decimalPointLeading";return;case "0":_8e5=read();_8e4="zero";return;case "1":case "2":case "3":case "4":case "5":case "6":case "7":case "8":case "9":_8e5=read();_8e4="decimalInteger";return;case "I":read();_8eb("nfinity");return _8e9("numeric",sign*Infinity);case "N":read();_8eb("aN");return _8e9("numeric",NaN);}throw _8ea(read());},zero:function(){switch(c){case ".":_8e5+=read();_8e4="decimalPoint";return;case "e":case "E":_8e5+=read();_8e4="decimalExponent";return;case "x":case "X":_8e5+=read();_8e4="hexadecimal";return;}return _8e9("numeric",sign*0);},decimalInteger:function(){switch(c){case ".":_8e5+=read();_8e4="decimalPoint";return;case "e":case "E":_8e5+=read();_8e4="decimalExponent";return;}if(util.isDigit(c)){_8e5+=read();return;}return _8e9("numeric",sign*Number(_8e5));},decimalPointLeading:function(){if(util.isDigit(c)){_8e5+=read();_8e4="decimalFraction";return;}throw _8ea(read());},decimalPoint:function(){switch(c){case "e":case "E":_8e5+=read();_8e4="decimalExponent";return;}if(util.isDigit(c)){_8e5+=read();_8e4="decimalFraction";return;}return _8e9("numeric",sign*Number(_8e5));},decimalFraction:function(){switch(c){case "e":case "E":_8e5+=read();_8e4="decimalExponent";return;}if(util.isDigit(c)){_8e5+=read();return;}return _8e9("numeric",sign*Number(_8e5));},decimalExponent:function(){switch(c){case "+":case "-":_8e5+=read();_8e4="decimalExponentSign";return;}if(util.isDigit(c)){_8e5+=read();_8e4="decimalExponentInteger";return;}throw _8ea(read());},decimalExponentSign:function(){if(util.isDigit(c)){_8e5+=read();_8e4="decimalExponentInteger";return;}throw _8ea(read());},decimalExponentInteger:function(){if(util.isDigit(c)){_8e5+=read();return;}return _8e9("numeric",sign*Number(_8e5));},hexadecimal:function(){if(util.isHexDigit(c)){_8e5+=read();_8e4="hexadecimalInteger";return;}throw _8ea(read());},hexadecimalInteger:function(){if(util.isHexDigit(c)){_8e5+=read();return;}return _8e9("numeric",sign*Number(_8e5));},string:function(){switch(c){case "\\":read();_8e5+=_8ee();return;case "\"":if(_8e6){read();return _8e9("string",_8e5);}_8e5+=read();return;case "'":if(!_8e6){read();return _8e9("string",_8e5);}_8e5+=read();return;case "\n":case "\r":throw _8ea(read());case " ":case " ":_8ef(c);break;case undefined:throw _8ea(read());}_8e5+=read();},start:function(){switch(c){case "{":case "[":return _8e9("punctuator",read());}_8e4="value";},beforePropertyName:function(){switch(c){case "$":case "_":_8e5=read();_8e4="identifierName";return;case "\\":read();_8e4="identifierNameStartEscape";return;case "}":return _8e9("punctuator",read());case "\"":case "'":_8e6=(read()==="\"");_8e4="string";return;}if(util.isIdStartChar(c)){_8e5+=read();_8e4="identifierName";return;}throw _8ea(read());},afterPropertyName:function(){if(c===":"){return _8e9("punctuator",read());}throw _8ea(read());},beforePropertyValue:function(){_8e4="value";},afterPropertyValue:function(){switch(c){case ",":case "}":return _8e9("punctuator",read());}throw _8ea(read());},beforeArrayValue:function(){if(c==="]"){return _8e9("punctuator",read());}_8e4="value";},afterArrayValue:function(){switch(c){case ",":case "]":return _8e9("punctuator",read());}throw _8ea(read());},end:function(){throw _8ea(read());}};function _8e9(type,_8f0){return {type:type,value:_8f0,line:line,column:_8d9};};function _8eb(s){for(var _8f1=0,s_1=s;_8f1<s_1.length;_8f1++){var c_1=s_1[_8f1];var p=peek();if(p!==c_1){throw _8ea(read());}read();}};function _8ee(){var c=peek();switch(c){case "b":read();return "\b";case "f":read();return "\f";case "n":read();return "\n";case "r":read();return "\r";case "t":read();return "\t";case "v":read();return "\v";case "0":read();if(util.isDigit(peek())){throw _8ea(read());}return "\x00";case "x":read();return _8f2();case "u":read();return _8ec();case "\n":case " ":case " ":read();return "";case "\r":read();if(peek()==="\n"){read();}return "";case "1":case "2":case "3":case "4":case "5":case "6":case "7":case "8":case "9":throw _8ea(read());case undefined:throw _8ea(read());}return read();};function _8f2(){var _8f3="";var c=peek();if(!util.isHexDigit(c)){throw _8ea(read());}_8f3+=read();c=peek();if(!util.isHexDigit(c)){throw _8ea(read());}_8f3+=read();return _8d5.fromCodePoint(parseInt(_8f3,16));};function _8ec(){var _8f4="";var _8f5=4;while(_8f5-->0){var c_2=peek();if(!util.isHexDigit(c_2)){throw _8ea(read());}_8f4+=read();}return _8d5.fromCodePoint(parseInt(_8f4,16));};var _8dd={start:function(){if(_8da.type==="eof"){throw _8f6();}push();},beforePropertyName:function(){switch(_8da.type){case "identifier":case "string":key=_8da.value;_8d7="afterPropertyName";return;case "punctuator":pop();return;case "eof":throw _8f6();}},afterPropertyName:function(){if(_8da.type==="eof"){throw _8f6();}_8d7="beforePropertyValue";},beforePropertyValue:function(){if(_8da.type==="eof"){throw _8f6();}push();},beforeArrayValue:function(){if(_8da.type==="eof"){throw _8f6();}if(_8da.type==="punctuator"&&_8da.value==="]"){pop();return;}push();},afterPropertyValue:function(){if(_8da.type==="eof"){throw _8f6();}switch(_8da.value){case ",":_8d7="beforePropertyName";return;case "}":pop();}},afterArrayValue:function(){if(_8da.type==="eof"){throw _8f6();}switch(_8da.value){case ",":_8d7="beforeArrayValue";return;case "]":pop();}},end:function(){}};function push(){var _8f7;switch(_8da.type){case "punctuator":switch(_8da.value){case "{":_8f7={};break;case "[":_8f7=[];break;}break;case "null":case "boolean":case "numeric":case "string":_8f7=_8da.value;break;}if(root===undefined){root=_8f7;}else{var _8f8=_8d8[_8d8.length-1];if(Array.isArray(_8f8)){_8f8.push(_8f7);}else{_8f8[key]=_8f7;}}if(_8f7!==null&&typeof _8f7==="object"){_8d8.push(_8f7);if(Array.isArray(_8f7)){_8d7="beforeArrayValue";}else{_8d7="beforePropertyName";}}else{var _8f9=_8d8[_8d8.length-1];if(_8f9==null){_8d7="end";}else{if(Array.isArray(_8f9)){_8d7="afterArrayValue";}else{_8d7="afterPropertyValue";}}}};function pop(){_8d8.pop();var _8fa=_8d8[_8d8.length-1];if(_8fa==null){_8d7="end";}else{if(Array.isArray(_8fa)){_8d7="afterArrayValue";}else{_8d7="afterPropertyValue";}}};function _8ea(c){if(c===undefined){return _8fb("JSON5: invalid end of input at "+line+":"+_8d9);}return _8fb("JSON5: invalid character '"+_8fc(c)+"' at "+line+":"+_8d9);};function _8f6(){return _8fb("JSON5: invalid end of input at "+line+":"+_8d9);};function _8ed(){_8d9-=5;return _8fb("JSON5: invalid identifier character at "+line+":"+_8d9);};function _8ef(c){console.warn("JSON5: '"+_8fc(c)+"' in strings is not valid ECMAScript; consider escaping");};function _8fc(c){var _8fd={"'":"\\'","\"":"\\\"","\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t","\v":"\\v","\x00":"\\0"," ":"\\u2028"," ":"\\u2029"};if(_8fd[c]){return _8fd[c];}if(c<" "){var _8fe=c.charCodeAt(0).toString(16);return "\\x"+("00"+_8fe).substring(_8fe.length);}return c;};function _8fb(_8ff){var err=new SyntaxError(_8ff);err.lineNumber=line;err.columnNumber=_8d9;return err;};return _8db;});},"dojo/json5/util":function(){define(["./unicode"],function(_900){return {isSpaceSeparator:function(c){return typeof c==="string"&&_900.Space_Separator.test(c);},isIdStartChar:function(c){return typeof c==="string"&&((c>="a"&&c<="z")||(c>="A"&&c<="Z")||(c==="$")||(c==="_")||_900.ID_Start.test(c));},isIdContinueChar:function(c){return typeof c==="string"&&((c>="a"&&c<="z")||(c>="A"&&c<="Z")||(c>="0"&&c<="9")||(c==="$")||(c==="_")||(c==="‌")||(c==="‍")||_900.ID_Continue.test(c));},isDigit:function(c){return typeof c==="string"&&/[0-9]/.test(c);},isHexDigit:function(c){return typeof c==="string"&&/[0-9A-Fa-f]/.test(c);},};});},"dojo/json5/unicode":function(){define({Space_Separator:/[\u1680\u2000-\u200A\u202F\u205F\u3000]/,ID_Start:/[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u08A0-\u08B4\u08B6-\u08BD\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312E\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FEA\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AE\uA7B0-\uA7B7\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDE80-\uDE9C\uDEA0-\uDED0\uDF00-\uDF1F\uDF2D-\uDF4A\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCB0-\uDCD3\uDCD8-\uDCFB\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE4\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2]|\uD804[\uDC03-\uDC37\uDC83-\uDCAF\uDCD0-\uDCE8\uDD03-\uDD26\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE2B\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEDE\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF50\uDF5D-\uDF61]|\uD805[\uDC00-\uDC34\uDC47-\uDC4A\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDD80-\uDDAE\uDDD8-\uDDDB\uDE00-\uDE2F\uDE44\uDE80-\uDEAA\uDF00-\uDF19]|\uD806[\uDCA0-\uDCDF\uDCFF\uDE00\uDE0B-\uDE32\uDE3A\uDE50\uDE5C-\uDE83\uDE86-\uDE89\uDEC0-\uDEF8]|\uD807[\uDC00-\uDC08\uDC0A-\uDC2E\uDC40\uDC72-\uDC8F\uDD00-\uDD06\uDD08\uDD09\uDD0B-\uDD30\uDD46]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|[\uD80C\uD81C-\uD820\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872\uD874-\uD879][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50\uDF93-\uDF9F\uDFE0\uDFE1]|\uD821[\uDC00-\uDFEC]|\uD822[\uDC00-\uDEF2]|\uD82C[\uDC00-\uDD1E\uDD70-\uDEFB]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB]|\uD83A[\uDC00-\uDCC4\uDD00-\uDD43]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0]|\uD87E[\uDC00-\uDE1D]/,ID_Continue:/[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u0483-\u0487\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u05D0-\u05EA\u05F0-\u05F2\u0610-\u061A\u0620-\u0669\u066E-\u06D3\u06D5-\u06DC\u06DF-\u06E8\u06EA-\u06FC\u06FF\u0710-\u074A\u074D-\u07B1\u07C0-\u07F5\u07FA\u0800-\u082D\u0840-\u085B\u0860-\u086A\u08A0-\u08B4\u08B6-\u08BD\u08D4-\u08E1\u08E3-\u0963\u0966-\u096F\u0971-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09F1\u09FC\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A75\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AEF\u0AF9-\u0AFF\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B6F\u0B71\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BEF\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58-\u0C5A\u0C60-\u0C63\u0C66-\u0C6F\u0C80-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2\u0D00-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D44\u0D46-\u0D48\u0D4A-\u0D4E\u0D54-\u0D57\u0D5F-\u0D63\u0D66-\u0D6F\u0D7A-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E01-\u0E3A\u0E40-\u0E4E\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E-\u0F47\u0F49-\u0F6C\u0F71-\u0F84\u0F86-\u0F97\u0F99-\u0FBC\u0FC6\u1000-\u1049\u1050-\u109D\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u135F\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17D3\u17D7\u17DC\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u1820-\u1877\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19D9\u1A00-\u1A1B\u1A20-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA7\u1AB0-\u1ABD\u1B00-\u1B4B\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1BF3\u1C00-\u1C37\u1C40-\u1C49\u1C4D-\u1C7D\u1C80-\u1C88\u1CD0-\u1CD2\u1CD4-\u1CF9\u1D00-\u1DF9\u1DFB-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u203F\u2040\u2054\u2071\u207F\u2090-\u209C\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D7F-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2DFF\u2E2F\u3005-\u3007\u3021-\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u3099\u309A\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312E\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FEA\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66F\uA674-\uA67D\uA67F-\uA6F1\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AE\uA7B0-\uA7B7\uA7F7-\uA827\uA840-\uA873\uA880-\uA8C5\uA8D0-\uA8D9\uA8E0-\uA8F7\uA8FB\uA8FD\uA900-\uA92D\uA930-\uA953\uA960-\uA97C\uA980-\uA9C0\uA9CF-\uA9D9\uA9E0-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA60-\uAA76\uAA7A-\uAAC2\uAADB-\uAADD\uAAE0-\uAAEF\uAAF2-\uAAF6\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABEA\uABEC\uABED\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF3F\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDDFD\uDE80-\uDE9C\uDEA0-\uDED0\uDEE0\uDF00-\uDF1F\uDF2D-\uDF4A\uDF50-\uDF7A\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCA0-\uDCA9\uDCB0-\uDCD3\uDCD8-\uDCFB\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00-\uDE03\uDE05\uDE06\uDE0C-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE38-\uDE3A\uDE3F\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE6\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2]|\uD804[\uDC00-\uDC46\uDC66-\uDC6F\uDC7F-\uDCBA\uDCD0-\uDCE8\uDCF0-\uDCF9\uDD00-\uDD34\uDD36-\uDD3F\uDD50-\uDD73\uDD76\uDD80-\uDDC4\uDDCA-\uDDCC\uDDD0-\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE37\uDE3E\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEEA\uDEF0-\uDEF9\uDF00-\uDF03\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3C-\uDF44\uDF47\uDF48\uDF4B-\uDF4D\uDF50\uDF57\uDF5D-\uDF63\uDF66-\uDF6C\uDF70-\uDF74]|\uD805[\uDC00-\uDC4A\uDC50-\uDC59\uDC80-\uDCC5\uDCC7\uDCD0-\uDCD9\uDD80-\uDDB5\uDDB8-\uDDC0\uDDD8-\uDDDD\uDE00-\uDE40\uDE44\uDE50-\uDE59\uDE80-\uDEB7\uDEC0-\uDEC9\uDF00-\uDF19\uDF1D-\uDF2B\uDF30-\uDF39]|\uD806[\uDCA0-\uDCE9\uDCFF\uDE00-\uDE3E\uDE47\uDE50-\uDE83\uDE86-\uDE99\uDEC0-\uDEF8]|\uD807[\uDC00-\uDC08\uDC0A-\uDC36\uDC38-\uDC40\uDC50-\uDC59\uDC72-\uDC8F\uDC92-\uDCA7\uDCA9-\uDCB6\uDD00-\uDD06\uDD08\uDD09\uDD0B-\uDD36\uDD3A\uDD3C\uDD3D\uDD3F-\uDD47\uDD50-\uDD59]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|[\uD80C\uD81C-\uD820\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872\uD874-\uD879][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDE60-\uDE69\uDED0-\uDEED\uDEF0-\uDEF4\uDF00-\uDF36\uDF40-\uDF43\uDF50-\uDF59\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50-\uDF7E\uDF8F-\uDF9F\uDFE0\uDFE1]|\uD821[\uDC00-\uDFEC]|\uD822[\uDC00-\uDEF2]|\uD82C[\uDC00-\uDD1E\uDD70-\uDEFB]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99\uDC9D\uDC9E]|\uD834[\uDD65-\uDD69\uDD6D-\uDD72\uDD7B-\uDD82\uDD85-\uDD8B\uDDAA-\uDDAD\uDE42-\uDE44]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB\uDFCE-\uDFFF]|\uD836[\uDE00-\uDE36\uDE3B-\uDE6C\uDE75\uDE84\uDE9B-\uDE9F\uDEA1-\uDEAF]|\uD838[\uDC00-\uDC06\uDC08-\uDC18\uDC1B-\uDC21\uDC23\uDC24\uDC26-\uDC2A]|\uD83A[\uDC00-\uDCC4\uDCD0-\uDCD6\uDD00-\uDD4A\uDD50-\uDD59]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0]|\uD87E[\uDC00-\uDE1D]|\uDB40[\uDD00-\uDDEF]/});},"dojox/grid/enhanced/plugins/filter/FilterLayer":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/_base/kernel","dojo/_base/json","../_StoreLayer"],function(_901,lang,_902,json,_903){var _904="filter",_905="clear",_906=function(_907,func){return func?lang.hitch(_907||_902.global,func):function(){};},_908=function(obj){var res={};if(obj&&lang.isObject(obj)){for(var name in obj){res[name]=obj[name];}}return res;};var _909=_901("dojox.grid.enhanced.plugins.filter._FilterLayerMixin",null,{tags:["sizeChange"],name:function(){return "filter";},onFilterDefined:function(_90a){},onFiltered:function(_90b,_90c){}});var _90d=_901("dojox.grid.enhanced.plugins.filter.ServerSideFilterLayer",[_903._ServerSideLayer,_909],{constructor:function(args){this._onUserCommandLoad=args.setupFilterQuery||this._onUserCommandLoad;this.filterDef(null);},filterDef:function(_90e){if(_90e){this._filter=_90e;var obj=_90e.toObject();this.command(_904,this._isStateful?json.toJson(obj):obj);this.command(_905,null);this.useCommands(true);this.onFilterDefined(_90e);}else{if(_90e===null){this._filter=null;this.command(_904,null);this.command(_905,true);this.useCommands(true);this.onFilterDefined(null);}}return this._filter;},onCommandLoad:function(_90f,_910){this.inherited(arguments);var _911=_910.onBegin;if(this._isStateful){var _912;if(_90f){this.command(_904,null);this.command(_905,null);this.useCommands(false);var _913=_90f.split(",");if(_913.length>=2){_912=this._filteredSize=parseInt(_913[0],10);this.onFiltered(_912,parseInt(_913[1],10));}else{return;}}else{_912=this._filteredSize;}if(this.enabled()){_910.onBegin=function(size,req){_906(_910.scope,_911)(_912,req);};}}else{var _914=this;_910.onBegin=function(size,req){if(!_914._filter){_914._storeSize=size;}_914.onFiltered(size,_914._storeSize||size);req.onBegin=_911;_906(_910.scope,_911)(size,req);};}}});var _915=_901("dojox.grid.enhanced.plugins.filter.ClientSideFilterLayer",[_903._StoreLayer,_909],{_storeSize:-1,_fetchAll:true,constructor:function(args){this.filterDef(null);args=lang.isObject(args)?args:{};this.fetchAllOnFirstFilter(args.fetchAll);this._getter=lang.isFunction(args.getter)?args.getter:this._defaultGetter;},_defaultGetter:function(_916,_917,_918,_919){return _919.getValue(_916,_917);},filterDef:function(_91a){if(_91a!==undefined){this._filter=_91a;this.invalidate();this.onFilterDefined(_91a);}return this._filter;},setGetter:function(_91b){if(lang.isFunction(_91b)){this._getter=_91b;}},fetchAllOnFirstFilter:function(_91c){if(_91c!==undefined){this._fetchAll=!!_91c;}return this._fetchAll;},invalidate:function(){this._items=[];this._nextUnfetchedIdx=0;this._result=[];this._indexMap=[];this._resultStartIdx=0;},_fetch:function(_91d,_91e){if(!this._filter){var _91f=_91d.onBegin,_920=this;_91d.onBegin=function(size,r){_906(_91d.scope,_91f)(size,r);_920.onFiltered(size,size);};this.originFetch(_91d);return _91d;}try{var _921=_91e?_91e._nextResultItemIdx:_91d.start;_921=_921||0;if(!_91e){this._result=[];this._resultStartIdx=_921;var _922;if(lang.isArray(_91d.sort)&&_91d.sort.length>0&&(_922=json.toJson(_91d.sort))!=this._lastSortInfo){this.invalidate();this._lastSortInfo=_922;}}var end=typeof _91d.count=="number"?_921+_91d.count-this._result.length:this._items.length;if(this._result.length){this._result=this._result.concat(this._items.slice(_921,end));}else{this._result=this._items.slice(_91d.start,typeof _91d.count=="number"?_91d.start+_91d.count:this._items.length);}if(this._result.length>=_91d.count||this._hasReachedStoreEnd()){this._completeQuery(_91d);}else{if(!_91e){_91e=_908(_91d);_91e.onBegin=lang.hitch(this,this._onFetchBegin);_91e.onComplete=lang.hitch(this,function(_923,req){this._nextUnfetchedIdx+=_923.length;this._doFilter(_923,req.start,_91d);this._fetch(_91d,req);});}_91e.start=this._nextUnfetchedIdx;if(this._fetchAll){delete _91e.count;}_91e._nextResultItemIdx=end<this._items.length?end:this._items.length;this.originFetch(_91e);}}catch(e){if(_91d.onError){_906(_91d.scope,_91d.onError)(e,_91d);}else{throw e;}}return _91d;},_hasReachedStoreEnd:function(){return this._storeSize>=0&&this._nextUnfetchedIdx>=this._storeSize;},_applyFilter:function(_924,_925){var g=this._getter,s=this._store;try{return !!(this._filter.applyRow(_924,function(item,arg){return g(item,arg,_925,s);}).getValue());}catch(e){console.warn("FilterLayer._applyFilter() error: ",e);return false;}},_doFilter:function(_926,_927,_928){for(var i=0,cnt=0;i<_926.length;++i){if(this._applyFilter(_926[i],_927+i)){_906(_928.scope,_928.onItem)(_926[i],_928);cnt+=this._addCachedItems(_926[i],this._items.length);this._indexMap.push(_927+i);}}},_onFetchBegin:function(size,req){this._storeSize=size;},_completeQuery:function(_929){var size=this._items.length;if(this._nextUnfetchedIdx<this._storeSize){size++;}_906(_929.scope,_929.onBegin)(size,_929);this.onFiltered(this._items.length,this._storeSize);_906(_929.scope,_929.onComplete)(this._result,_929);},_addCachedItems:function(_92a,_92b){if(!lang.isArray(_92a)){_92a=[_92a];}for(var k=0;k<_92a.length;++k){this._items[_92b+k]=_92a[k];}return _92a.length;},onRowMappingChange:function(_92c){if(this._filter){var m=lang.clone(_92c),_92d={};for(var r in m){r=parseInt(r,10);_92c[this._indexMap[r]]=this._indexMap[m[r]];if(!_92d[this._indexMap[r]]){_92d[this._indexMap[r]]=true;}if(!_92d[r]){_92d[r]=true;delete _92c[r];}}}}});return lang.mixin({ServerSideFilterLayer:_90d,ClientSideFilterLayer:_915},_903);});},"dojox/grid/enhanced/plugins/_StoreLayer":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/_base/xhr"],function(_92e,_92f,lang,xhr){var ns=lang.getObject("grid.enhanced.plugins",true,dojox);var _930=function(tags){var _931=["reorder","sizeChange","normal","presentation"];var idx=_931.length;for(var i=tags.length-1;i>=0;--i){var p=_92f.indexOf(_931,tags[i]);if(p>=0&&p<=idx){idx=p;}}if(idx<_931.length-1){return _931.slice(0,idx+1);}else{return _931;}},_932=function(_933){var i,_934=this._layers,len=_934.length;if(_933){for(i=len-1;i>=0;--i){if(_934[i].name()==_933){_934[i]._unwrap(_934[i+1]);break;}}_934.splice(i,1);}else{for(i=len-1;i>=0;--i){_934[i]._unwrap();}}if(!_934.length){delete this._layers;delete this.layer;delete this.unwrap;delete this.forEachLayer;}return this;},_935=function(_936){var i,_937=this._layers;if(typeof _936=="undefined"){return _937.length;}if(typeof _936=="number"){return _937[_936];}for(i=_937.length-1;i>=0;--i){if(_937[i].name()==_936){return _937[i];}}return null;},_938=function(_939,_93a){var len=this._layers.length,_93b,end,dir;if(_93a){_93b=0;end=len;dir=1;}else{_93b=len-1;end=-1;dir=-1;}for(var i=_93b;i!=end;i+=dir){if(_939(this._layers[i],i)===false){return i;}}return end;};ns.wrap=function(_93c,_93d,_93e,_93f){if(!_93c._layers){_93c._layers=[];_93c.layer=lang.hitch(_93c,_935);_93c.unwrap=lang.hitch(_93c,_932);_93c.forEachLayer=lang.hitch(_93c,_938);}var _940=_930(_93e.tags);if(!_92f.some(_93c._layers,function(lyr,i){if(_92f.some(lyr.tags,function(tag){return _92f.indexOf(_940,tag)>=0;})){return false;}else{_93c._layers.splice(i,0,_93e);_93e._wrap(_93c,_93d,_93f,lyr);return true;}})){_93c._layers.push(_93e);_93e._wrap(_93c,_93d,_93f);}return _93c;};var _941=_92e("dojox.grid.enhanced.plugins._StoreLayer",null,{tags:["normal"],layerFuncName:"_fetch",constructor:function(){this._store=null;this._originFetch=null;this.__enabled=true;},initialize:function(_942){},uninitialize:function(_943){},invalidate:function(){},_wrap:function(_944,_945,_946,_947){this._store=_944;this._funcName=_945;var _948=lang.hitch(this,function(){return (this.enabled()?this[_946||this.layerFuncName]:this.originFetch).apply(this,arguments);});if(_947){this._originFetch=_947._originFetch;_947._originFetch=_948;}else{this._originFetch=_944[_945]||function(){};_944[_945]=_948;}this.initialize(_944);},_unwrap:function(_949){this.uninitialize(this._store);if(_949){_949._originFetch=this._originFetch;}else{this._store[this._funcName]=this._originFetch;}this._originFetch=null;this._store=null;},enabled:function(_94a){if(typeof _94a!="undefined"){this.__enabled=!!_94a;}return this.__enabled;},name:function(){if(!this.__name){var m=this.declaredClass.match(/(?:\.(?:_*)([^\.]+)Layer$)|(?:\.([^\.]+)$)/i);this.__name=m?(m[1]||m[2]).toLowerCase():this.declaredClass;}return this.__name;},originFetch:function(){return (lang.hitch(this._store,this._originFetch)).apply(this,arguments);}});var _94b=_92e("dojox.grid.enhanced.plugins._ServerSideLayer",_941,{constructor:function(args){args=args||{};this._url=args.url||"";this._isStateful=!!args.isStateful;this._onUserCommandLoad=args.onCommandLoad||function(){};this.__cmds={cmdlayer:this.name(),enable:true};this.useCommands(this._isStateful);},enabled:function(_94c){var res=this.inherited(arguments);this.__cmds.enable=this.__enabled;return res;},useCommands:function(_94d){if(typeof _94d!="undefined"){this.__cmds.cmdlayer=(_94d&&this._isStateful)?this.name():null;}return !!(this.__cmds.cmdlayer);},_fetch:function(_94e){if(this.__cmds.cmdlayer){xhr.post({url:this._url||this._store.url,content:this.__cmds,load:lang.hitch(this,function(_94f){this.onCommandLoad(_94f,_94e);this.originFetch(_94e);}),error:lang.hitch(this,this.onCommandError)});}else{this.onCommandLoad("",_94e);this.originFetch(_94e);}return _94e;},command:function(_950,_951){var cmds=this.__cmds;if(_951===null){delete cmds[_950];}else{if(typeof _951!=="undefined"){cmds[_950]=_951;}}return cmds[_950];},onCommandLoad:function(_952,_953){this._onUserCommandLoad(this.__cmds,_953,_952);},onCommandError:function(_954){throw _954;}});return {_StoreLayer:_941,_ServerSideLayer:_94b,wrap:ns.wrap};});},"dojox/grid/enhanced/plugins/filter/FilterBar":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/connect","dojo/_base/lang","dojo/_base/sniff","dojo/_base/event","dojo/_base/html","dojo/_base/window","dojo/query","dijit/_Widget","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin","dojo/fx","dojo/_base/fx","dojo/string","dijit/focus","dojo/text!../../templates/FilterBar.html"],function(_955,_956,_957,lang,has,_958,html,win,_959,_95a,_95b,_95c,fx,_95d,_95e,_95f,_960){var _961="dojoxGridFBarHover",_962="dojoxGridFBarFiltered",_963=function(evt){try{if(evt&&evt.preventDefault){_958.stop(evt);}}catch(e){}};return _955("dojox.grid.enhanced.plugins.filter.FilterBar",[_95a,_95b,_95c],{templateString:_960,widgetsInTemplate:true,_timeout_statusTooltip:300,_handle_statusTooltip:null,_curColIdx:-1,plugin:null,postMixInProperties:function(){var _964=this.plugin;var nls=_964.nls;this._filterBarDefBtnLabel=nls["filterBarDefButton"];this._filterBarClearBtnLabel=nls["filterBarClearButton"];this._closeFilterBarBtnLabel=nls["closeFilterBarBtn"];var _965=_964.args.itemsName||nls["defaultItemsName"];this._noFilterMsg=_95e.substitute(nls["filterBarMsgNoFilterTemplate"],["",_965]);var t=this.plugin.args.statusTipTimeout;if(typeof t=="number"){this._timeout_statusTooltip=t;}var g=_964.grid;g.showFilterBar=lang.hitch(this,"showFilterBar");g.toggleFilterBar=lang.hitch(this,"toggleFilterBar");g.isFilterBarShown=lang.hitch(this,"isFilterBarShown");},postCreate:function(){this.inherited(arguments);if(!this.plugin.args.closeFilterbarButton){html.style(this.closeFilterBarButton.domNode,"display","none");}var _966=this,g=this.plugin.grid,_967=this.oldGetHeaderHeight=lang.hitch(g,g._getHeaderHeight);this.placeAt(g.viewsHeaderNode,"after");this.connect(this.plugin.filterDefDialog,"showDialog","_onShowFilterDefDialog");this.connect(this.plugin.filterDefDialog,"closeDialog","_onCloseFilterDefDialog");this.connect(g.layer("filter"),"onFiltered",this._onFiltered);this.defineFilterButton.domNode.title=this.plugin.nls["filterBarDefButton"];if(html.hasClass(win.body(),"dijit_a11y")){this.defineFilterButton.set("label",this.plugin.nls["a11yFilterBarDefButton"]);}this.connect(this.defineFilterButton.domNode,"click",_963);this.connect(this.clearFilterButton.domNode,"click",_963);this.connect(this.closeFilterBarButton.domNode,"click",_963);this.toggleClearFilterBtn(true);this._initAriaInfo();g._getHeaderHeight=function(){return _967()+html.marginBox(_966.domNode).h;};g.focus.addArea({name:"filterbar",onFocus:lang.hitch(this,this._onFocusFilterBar,false),onBlur:lang.hitch(this,this._onBlurFilterBar)});g.focus.placeArea("filterbar","after","header");},uninitialize:function(){var g=this.plugin.grid;g._getHeaderHeight=this.oldGetHeaderHeight;g.focus.removeArea("filterbar");this.plugin=null;},isFilterBarShown:function(){return html.style(this.domNode,"display")!="none";},showFilterBar:function(_968,_969,_96a){var g=this.plugin.grid;if(_969){if(Boolean(_968)==this.isFilterBarShown()){return;}_96a=_96a||{};var _96b=[],_96c=500;_96b.push(fx[_968?"wipeIn":"wipeOut"](lang.mixin({"node":this.domNode,"duration":_96c},_96a)));var _96d=g.views.views[0].domNode.offsetHeight;var prop={"duration":_96c,"properties":{"height":{"end":lang.hitch(this,function(){var _96e=this.domNode.scrollHeight;if(has("ff")){_96e-=2;}return _968?(_96d-_96e):(_96d+_96e);})}}};_956.forEach(g.views.views,function(view){_96b.push(_95d.animateProperty(lang.mixin({"node":view.domNode},prop,_96a)),_95d.animateProperty(lang.mixin({"node":view.scrollboxNode},prop,_96a)));});_96b.push(_95d.animateProperty(lang.mixin({"node":g.viewsNode},prop,_96a)));fx.combine(_96b).play();}else{html.style(this.domNode,"display",_968?"":"none");g.update();}},toggleFilterBar:function(_96f,_970){this.showFilterBar(!this.isFilterBarShown(),_96f,_970);},getColumnIdx:function(_971){var _972=_959("[role='columnheader']",this.plugin.grid.viewsHeaderNode);var idx=-1;for(var i=_972.length-1;i>=0;--i){var _973=html.position(_972[i]);if(_971>=_973.x&&_971<_973.x+_973.w){idx=i;break;}}if(idx>=0&&this.plugin.grid.layout.cells[idx].filterable!==false){return idx;}else{return -1;}},toggleClearFilterBtn:function(_974){html.style(this.clearFilterButton.domNode,"display",_974?"none":"");},_closeFilterBar:function(e){_963(e);var _975=this.plugin.filterDefDialog.getCriteria();if(_975){var _976=_957.connect(this.plugin.filterDefDialog,"clearFilter",this,function(){this.showFilterBar(false,true);_957.disconnect(_976);});this._clearFilterDefDialog(e);}else{this.showFilterBar(false,true);}},_showFilterDefDialog:function(e){_963(e);this.plugin.filterDefDialog.showDialog(this._curColIdx);this.plugin.grid.focus.focusArea("filterbar");},_clearFilterDefDialog:function(e){_963(e);this.plugin.filterDefDialog.onClearFilter();this.plugin.grid.focus.focusArea("filterbar");},_onEnterButton:function(e){this._onBlurFilterBar();_963(e);},_onMoveButton:function(e){this._onBlurFilterBar();},_onLeaveButton:function(e){this._leavingBtn=true;},_onShowFilterDefDialog:function(_977){if(typeof _977=="number"){this._curColIdx=_977;}this._defPaneIsShown=true;},_onCloseFilterDefDialog:function(){this._defPaneIsShown=false;this._curColIdx=-1;_95f.focus(this.defineFilterButton.domNode);},_onClickFilterBar:function(e){_963(e);this._clearStatusTipTimeout();this.plugin.grid.focus.focusArea("filterbar");this.plugin.filterDefDialog.showDialog(this.getColumnIdx(e.clientX));},_onMouseEnter:function(e){this._onFocusFilterBar(true,null);this._updateTipPosition(e);this._setStatusTipTimeout();},_onMouseMove:function(e){if(this._leavingBtn){this._onFocusFilterBar(true,null);this._leavingBtn=false;}if(this._isFocused){this._setStatusTipTimeout();this._highlightHeader(this.getColumnIdx(e.clientX));if(this._handle_statusTooltip){this._updateTipPosition(e);}}},_onMouseLeave:function(e){this._onBlurFilterBar();},_updateTipPosition:function(evt){this._tippos={x:evt.pageX,y:evt.pageY};},_onFocusFilterBar:function(_978,evt,step){if(!this.isFilterBarShown()){return false;}this._isFocused=true;html.addClass(this.domNode,_961);if(!_978){var _979=html.style(this.clearFilterButton.domNode,"display")!=="none";var _97a=html.style(this.closeFilterBarButton.domNode,"display")!=="none";if(typeof this._focusPos=="undefined"){if(step>0){this._focusPos=0;}else{if(_97a){this._focusPos=1;}else{this._focusPos=0;}if(_979){++this._focusPos;}}}if(this._focusPos===0){_95f.focus(this.defineFilterButton.focusNode);}else{if(this._focusPos===1&&_979){_95f.focus(this.clearFilterButton.focusNode);}else{_95f.focus(this.closeFilterBarButton.focusNode);}}}_963(evt);return true;},_onBlurFilterBar:function(evt,step){if(this._isFocused){this._isFocused=false;html.removeClass(this.domNode,_961);this._clearStatusTipTimeout();this._clearHeaderHighlight();}var _97b=true;if(step){var _97c=3;if(html.style(this.closeFilterBarButton.domNode,"display")==="none"){--_97c;}if(html.style(this.clearFilterButton.domNode,"display")==="none"){--_97c;}if(_97c==1){delete this._focusPos;}else{var _97d=this._focusPos;for(var next=_97d+step;next<0;next+=_97c){}next%=_97c;if((step>0&&next<_97d)||(step<0&&next>_97d)){delete this._focusPos;}else{this._focusPos=next;_97b=false;}}}return _97b;},_onFiltered:function(_97e,_97f){var p=this.plugin,_980=p.args.itemsName||p.nls["defaultItemsName"],msg="",g=p.grid,_981=g.layer("filter");if(_981.filterDef()){msg=_95e.substitute(p.nls["filterBarMsgHasFilterTemplate"],[_97e,_97f,_980]);html.addClass(this.domNode,_962);}else{msg=_95e.substitute(p.nls["filterBarMsgNoFilterTemplate"],[_97f,_980]);html.removeClass(this.domNode,_962);}this.statusBarNode.innerHTML=msg;this._focusPos=0;},_initAriaInfo:function(){this.defineFilterButton.domNode.setAttribute("aria-label",this.plugin.nls["waiFilterBarDefButton"]);this.clearFilterButton.domNode.setAttribute("aria-label",this.plugin.nls["waiFilterBarClearButton"]);},_isInColumn:function(_982,_983,_984){var _985=html.position(_983);return _982>=_985.x&&_982<_985.x+_985.w;},_setStatusTipTimeout:function(){this._clearStatusTipTimeout();if(!this._defPaneIsShown){this._handle_statusTooltip=setTimeout(lang.hitch(this,this._showStatusTooltip),this._timeout_statusTooltip);}},_clearStatusTipTimeout:function(){clearTimeout(this._handle_statusTooltip);this._handle_statusTooltip=null;},_showStatusTooltip:function(){this._handle_statusTooltip=null;if(this.plugin){this.plugin.filterStatusTip.showDialog(this._tippos.x,this._tippos.y,this.getColumnIdx(this._tippos.x));}},_highlightHeader:function(_986){if(_986!=this._previousHeaderIdx){var g=this.plugin.grid,cell=g.getCell(this._previousHeaderIdx);if(cell){html.removeClass(cell.getHeaderNode(),"dojoxGridCellOver");}cell=g.getCell(_986);if(cell){html.addClass(cell.getHeaderNode(),"dojoxGridCellOver");}this._previousHeaderIdx=_986;}},_clearHeaderHighlight:function(){if(typeof this._previousHeaderIdx!="undefined"){var g=this.plugin.grid,cell=g.getCell(this._previousHeaderIdx);if(cell){g.onHeaderCellMouseOut({cellNode:cell.getHeaderNode()});}delete this._previousHeaderIdx;}}});});},"dijit/_WidgetsInTemplateMixin":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang","dojo/parser"],function(_987,_988,_989,lang,_98a){return _989("dijit._WidgetsInTemplateMixin",null,{_earlyTemplatedStartup:false,contextRequire:null,_beforeFillContent:function(){if(/dojoType|data-dojo-type/i.test(this.domNode.innerHTML)){var node=this.domNode;if(this.containerNode&&!this.searchContainerNode){this.containerNode.stopParser=true;}_98a.parse(node,{noStart:!this._earlyTemplatedStartup,template:true,inherited:{dir:this.dir,lang:this.lang,textDir:this.textDir},propsThis:this,contextRequire:this.contextRequire,scope:"dojo"}).then(lang.hitch(this,function(_98b){this._startupWidgets=_98b;for(var i=0;i<_98b.length;i++){this._processTemplateNode(_98b[i],function(n,p){return n[p];},function(_98c,type,_98d){if(type in _98c){return _98c.connect(_98c,type,_98d);}else{return _98c.on(type,_98d,true);}});}if(this.containerNode&&this.containerNode.stopParser){delete this.containerNode.stopParser;}}));if(!this._startupWidgets){throw new Error(this.declaredClass+": parser returned unfilled promise (probably waiting for module auto-load), "+"unsupported by _WidgetsInTemplateMixin.   Must pre-load all supporting widgets before instantiation.");}}},_processTemplateNode:function(_98e,_98f,_990){if(_98f(_98e,"dojoType")||_98f(_98e,"data-dojo-type")){return true;}return this.inherited(arguments);},startup:function(){_987.forEach(this._startupWidgets,function(w){if(w&&!w._started&&w.startup){w.startup();}});this._startupWidgets=null;this.inherited(arguments);}});});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./aspect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_991,dojo,_992,_993,_994,dom,_995,geom,_996,_997){if(!dojo.isAsync){_996(0,function(){var _998=["./fx/Toggler"];_997(_998);});}var _999=dojo.fx={};var _99a={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _99b=function(_99c){this._index=-1;this._animations=_99c||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_992.forEach(this._animations,function(a){if(a){if(typeof a.duration!="undefined"){this.duration+=a.duration;}if(a.delay){this.duration+=a.delay;}}},this);};_99b.prototype=new _991();lang.extend(_99b,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){this._onAnimateCtx.remove();this._onEndCtx.remove();this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_993.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);this._onEndCtx=_993.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play(0,true);}},play:function(_99d,_99e){if(!this._current){this._current=this._animations[this._index=0];}if(!_99e&&this._current.status()=="playing"){return this;}var _99f=_993.after(this._current,"beforeBegin",lang.hitch(this,function(){this._fire("beforeBegin");}),true),_9a0=_993.after(this._current,"onBegin",lang.hitch(this,function(arg){this._fire("onBegin",arguments);}),true),_9a1=_993.after(this._current,"onPlay",lang.hitch(this,function(arg){this._fire("onPlay",arguments);_99f.remove();_9a0.remove();_9a1.remove();}));if(this._onAnimateCtx){this._onAnimateCtx.remove();}this._onAnimateCtx=_993.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);if(this._onEndCtx){this._onEndCtx.remove();}this._onEndCtx=_993.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_993.after(this._current,"onPause",lang.hitch(this,function(arg){this._fire("onPause",arguments);e.remove();}),true);this._current.pause();}return this;},gotoPercent:function(_9a2,_9a3){this.pause();var _9a4=this.duration*_9a2;this._current=null;_992.some(this._animations,function(a,_9a5){if(_9a4<=a.duration){this._current=a;this._index=_9a5;return true;}_9a4-=a.duration;return false;},this);if(this._current){this._current.gotoPercent(_9a4/this._current.duration);}if(_9a3){this.play();}return this;},stop:function(_9a6){if(this._current){if(_9a6){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_993.after(this._current,"onStop",lang.hitch(this,function(arg){this._fire("onStop",arguments);e.remove();}),true);this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){this.stop();if(this._onAnimateCtx){this._onAnimateCtx.remove();}if(this._onEndCtx){this._onEndCtx.remove();}}});lang.extend(_99b,_99a);_999.chain=function(_9a7){return new _99b(lang.isArray(_9a7)?_9a7:Array.prototype.slice.call(_9a7,0));};var _9a8=function(_9a9){this._animations=_9a9||[];this._connects=[];this._finished=0;this.duration=0;_992.forEach(_9a9,function(a){var _9aa=a.duration;if(a.delay){_9aa+=a.delay;}if(this.duration<_9aa){this.duration=_9aa;}this._connects.push(_993.after(a,"onEnd",lang.hitch(this,"_onEnd"),true));},this);this._pseudoAnimation=new _994.Animation({curve:[0,1],duration:this.duration});var self=this;_992.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_993.after(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);},true));});};lang.extend(_9a8,{_doAction:function(_9ab,args){_992.forEach(this._animations,function(a){a[_9ab].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_9ac,args){var t=this._pseudoAnimation;t[_9ac].apply(t,args);},play:function(_9ad,_9ae){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_9af,_9b0){var ms=this.duration*_9af;_992.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_9b0);});this._call("gotoPercent",arguments);return this;},stop:function(_9b1){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){this.stop();_992.forEach(this._connects,function(_9b2){_9b2.remove();});}});lang.extend(_9a8,_99a);_999.combine=function(_9b3){return new _9a8(lang.isArray(_9b3)?_9b3:Array.prototype.slice.call(_9b3,0));};_999.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_994.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _9b4=_995.get(node,"height");return Math.max(_9b4,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_993.after(anim,"onStop",fini,true);_993.after(anim,"onEnd",fini,true);return anim;};_999.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_994.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_993.after(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";},true);var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_993.after(anim,"onStop",fini,true);_993.after(anim,"onEnd",fini,true);return anim;};_999.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_995.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_994.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_993.after(anim,"beforeBegin",init,true);return anim;};return _999;});},"dojox/grid/enhanced/plugins/filter/FilterDefDialog":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/connect","dojo/_base/lang","dojo/_base/event","dojo/_base/html","dojo/_base/sniff","dojo/keys","dojo/on","dojo/string","dojo/window","dojo/date/locale","./FilterBuilder","../Dialog","dijit/form/ComboBox","dijit/form/TextBox","dijit/form/NumberTextBox","dijit/form/DateTextBox","dijit/form/TimeTextBox","dijit/form/Button","dijit/layout/AccordionContainer","dijit/layout/ContentPane","dijit/_Widget","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin","dijit/focus","dojox/html/metrics","dijit/a11y","dojo/text!../../templates/FilterDefPane.html","dojo/text!../../templates/CriteriaBox.html","dojo/text!../../templates/FilterBoolValueBox.html","dijit/Tooltip","dijit/form/Select","dijit/form/RadioButton","dojox/html/ellipsis","../../../cells/dijit"],function(_9b5,_9b6,_9b7,lang,_9b8,html,has,keys,on,_9b9,win,_9ba,_9bb,_9bc,_9bd,_9be,_9bf,_9c0,_9c1,_9c2,_9c3,_9c4,_9c5,_9c6,_9c7,_9c8,_9c9,_9ca,_9cb,_9cc,_9cd){var _9ce={relSelect:60,accordionTitle:70,removeCBoxBtn:-1,colSelect:90,condSelect:95,valueBox:10,addCBoxBtn:20,filterBtn:30,clearBtn:40,cancelBtn:50};var _9cf=_9b5("dojox.grid.enhanced.plugins.filter.AccordionContainer",_9c3,{nls:null,addChild:function(_9d0,_9d1){var pane=arguments[0]=_9d0._pane=new _9c4({content:_9d0});this.inherited(arguments);this._modifyChild(pane);},removeChild:function(_9d2){var pane=_9d2,_9d3=false;if(_9d2._pane){_9d3=true;pane=arguments[0]=_9d2._pane;}this.inherited(arguments);if(_9d3){this._hackHeight(false,this._titleHeight);var _9d4=this.getChildren();if(_9d4.length===1){html.style(_9d4[0]._removeCBoxBtn.domNode,"display","none");}}pane.destroyRecursive();},selectChild:function(_9d5){if(_9d5._pane){arguments[0]=_9d5._pane;}this.inherited(arguments);},resize:function(){this.inherited(arguments);_9b6.forEach(this.getChildren(),this._setupTitleDom);},startup:function(){if(this._started){return;}this.inherited(arguments);if(parseInt(has("ie"),10)==7){_9b6.some(this._connects,function(cnnt){if((cnnt[0]||{})[1]=="onresize"){this.disconnect(cnnt);return true;}},this);}_9b6.forEach(this.getChildren(),function(_9d6){this._modifyChild(_9d6,true);},this);},_onKeyPress:function(e,_9d7){if(this.disabled||e.altKey||!(_9d7||e.ctrlKey)){return;}var k=keys,c=e.charOrCode,ltr=html._isBodyLtr(),_9d8=null;if((_9d7&&c==k.UP_ARROW)||(e.ctrlKey&&c==k.PAGE_UP)){_9d8=false;}else{if((_9d7&&c==k.DOWN_ARROW)||(e.ctrlKey&&(c==k.PAGE_DOWN||c==k.TAB))){_9d8=true;}else{if(c==(ltr?k.LEFT_ARROW:k.RIGHT_ARROW)){_9d8=this._focusOnRemoveBtn?null:false;this._focusOnRemoveBtn=!this._focusOnRemoveBtn;}else{if(c==(ltr?k.RIGHT_ARROW:k.LEFT_ARROW)){_9d8=this._focusOnRemoveBtn?true:null;this._focusOnRemoveBtn=!this._focusOnRemoveBtn;}else{return;}}}}if(_9d8!==null){this._adjacent(_9d8)._buttonWidget._onTitleClick();}_9b8.stop(e);win.scrollIntoView(this.selectedChildWidget._buttonWidget.domNode.parentNode);if(has("ie")){this.selectedChildWidget._removeCBoxBtn.focusNode.setAttribute("tabIndex",this._focusOnRemoveBtn?_9ce.accordionTitle:-1);}_9c8.focus(this.selectedChildWidget[this._focusOnRemoveBtn?"_removeCBoxBtn":"_buttonWidget"].focusNode);},_modifyChild:function(_9d9,_9da){if(!_9d9||!this._started){return;}html.style(_9d9.domNode,"overflow","hidden");_9d9._buttonWidget.connect(_9d9._buttonWidget,"_setSelectedAttr",function(){this.focusNode.setAttribute("tabIndex",this.selected?_9ce.accordionTitle:"-1");});var _9db=this;_9d9._buttonWidget.connect(_9d9._buttonWidget.domNode,"onclick",function(){_9db._focusOnRemoveBtn=false;});(_9d9._removeCBoxBtn=new _9c2({label:this.nls.removeRuleButton,showLabel:false,iconClass:"dojoxGridFCBoxRemoveCBoxBtnIcon",tabIndex:_9ce.removeCBoxBtn,onClick:lang.hitch(_9d9.content,"onRemove"),onKeyPress:function(e){_9db._onKeyPress(e,_9d9._buttonWidget.contentWidget);}})).placeAt(_9d9._buttonWidget.domNode);var i,_9dc=this.getChildren();if(_9dc.length===1){_9d9._buttonWidget.set("selected",true);html.style(_9d9._removeCBoxBtn.domNode,"display","none");}else{for(i=0;i<_9dc.length;++i){if(_9dc[i]._removeCBoxBtn){html.style(_9dc[i]._removeCBoxBtn.domNode,"display","");}}}this._setupTitleDom(_9d9);if(!this._titleHeight){for(i=0;i<_9dc.length;++i){if(_9dc[i]!=this.selectedChildWidget){this._titleHeight=html.marginBox(_9dc[i]._buttonWidget.domNode.parentNode).h;break;}}}if(!_9da){this._hackHeight(true,this._titleHeight);}},_hackHeight:function(_9dd,_9de){var _9df=this.getChildren(),dn=this.domNode,h=html.style(dn,"height");if(!_9dd){dn.style.height=(h-_9de)+"px";}else{if(_9df.length>1){dn.style.height=(h+_9de)+"px";}else{return;}}this.resize();},_setupTitleDom:function(_9e0){var w=html.contentBox(_9e0._buttonWidget.titleNode).w;if(has("ie")<8){w-=8;}html.style(_9e0._buttonWidget.titleTextNode,"width",w+"px");}});var _9e1=_9b5("dojox.grid.enhanced.plugins.filter.FilterDefPane",[_9c5,_9c6,_9c7],{templateString:_9cb,widgetsInTemplate:true,dlg:null,postMixInProperties:function(){this.plugin=this.dlg.plugin;var nls=this.plugin.nls;this._addRuleBtnLabel=nls.addRuleButton;this._cancelBtnLabel=nls.cancelButton;this._clearBtnLabel=nls.clearButton;this._filterBtnLabel=nls.filterButton;this._relAll=nls.relationAll;this._relAny=nls.relationAny;this._relMsgFront=nls.relationMsgFront;this._relMsgTail=nls.relationMsgTail;},postCreate:function(){this.inherited(arguments);on(this.domNode,"keydown",lang.hitch(this,"_onKey"));(this.cboxContainer=new _9cf({nls:this.plugin.nls})).placeAt(this.criteriaPane);this._relSelect.set("tabIndex",_9ce.relSelect);this._addCBoxBtn.set("tabIndex",_9ce.addCBoxBtn);this._cancelBtn.set("tabIndex",_9ce.cancelBtn);this._clearFilterBtn.set("tabIndex",_9ce.clearBtn);this._filterBtn.set("tabIndex",_9ce.filterBtn);var nls=this.plugin.nls;this._relSelect.domNode.setAttribute("aria-label",nls.waiRelAll);this._addCBoxBtn.domNode.setAttribute("aria-label",nls.waiAddRuleButton);this._cancelBtn.domNode.setAttribute("aria-label",nls.waiCancelButton);this._clearFilterBtn.domNode.setAttribute("aria-label",nls.waiClearButton);this._filterBtn.domNode.setAttribute("aria-label",nls.waiFilterButton);this._relSelect.set("value",this.dlg._relOpCls==="logicall"?"0":"1");},uninitialize:function(){this.cboxContainer.destroyRecursive();this.plugin=null;this.dlg=null;},_onRelSelectChange:function(val){this.dlg._relOpCls=val=="0"?"logicall":"logicany";this._relSelect.domNode.setAttribute("aria-label",this.plugin.nls[val=="0"?"waiRelAll":"waiRelAny"]);},_onAddCBox:function(){this.dlg.addCriteriaBoxes(1);},_onCancel:function(){this.dlg.onCancel();},_onClearFilter:function(){this.dlg.onClearFilter();},_onFilter:function(){this.dlg.onFilter();},_onKey:function(e){if(e.keyCode==keys.ENTER){this.dlg.onFilter();}}});var _9e2=_9b5("dojox.grid.enhanced.plugins.filter.CriteriaBox",[_9c5,_9c6,_9c7],{templateString:_9cc,widgetsInTemplate:true,dlg:null,postMixInProperties:function(){this.plugin=this.dlg.plugin;this._curValueBox=null;var nls=this.plugin.nls;this._colSelectLabel=nls.columnSelectLabel;this._condSelectLabel=nls.conditionSelectLabel;this._valueBoxLabel=nls.valueBoxLabel;this._anyColumnOption=nls.anyColumnOption;},postCreate:function(){var dlg=this.dlg,g=this.plugin.grid;this._colSelect.set("tabIndex",_9ce.colSelect);this._colOptions=this._getColumnOptions();this._colSelect.addOption([{label:this.plugin.nls.anyColumnOption,value:"anycolumn",selected:dlg.curColIdx<0},{value:""}].concat(this._colOptions));this._condSelect.set("tabIndex",_9ce.condSelect);this._condSelect.addOption(this._getUsableConditions(dlg.getColumnType(dlg.curColIdx)));this._showSelectOrLabel(this._condSelect,this._condSelectAlt);this.connect(g.layout,"moveColumn","onMoveColumn");var _9e3=this;setTimeout(function(){var type=dlg.getColumnType(dlg.curColIdx);_9e3._setValueBoxByType(type);},0);},_getColumnOptions:function(){var _9e4=this.dlg.curColIdx>=0?String(this.dlg.curColIdx):"anycolumn";return _9b6.map(_9b6.filter(this.plugin.grid.layout.cells,function(cell){return !(cell.filterable===false||cell.hidden);}),function(cell){return {label:cell.name||cell.field,value:String(cell.index),selected:_9e4==String(cell.index)};});},onMoveColumn:function(){var tmp=this._onChangeColumn;this._onChangeColumn=function(){};var _9e5=this._colSelect.get("selectedOptions");this._colSelect.removeOption(this._colOptions);this._colOptions=this._getColumnOptions();this._colSelect.addOption(this._colOptions);var i=0;for(;i<this._colOptions.length;++i){if(this._colOptions[i].label==_9e5.label){break;}}if(i<this._colOptions.length){this._colSelect.set("value",this._colOptions[i].value);}var _9e6=this;setTimeout(function(){_9e6._onChangeColumn=tmp;},0);},onRemove:function(){this.dlg.removeCriteriaBoxes(this);},uninitialize:function(){if(this._curValueBox){this._curValueBox.destroyRecursive();this._curValueBox=null;}this.plugin=null;this.dlg=null;},_showSelectOrLabel:function(sel,alt){var _9e7=sel.getOptions();if(_9e7.length==1){alt.innerHTML=_9e7[0].label;html.style(sel.domNode,"display","none");html.style(alt,"display","");}else{html.style(sel.domNode,"display","");html.style(alt,"display","none");}},_onChangeColumn:function(val){this._checkValidCriteria();var type=this.dlg.getColumnType(val);this._setConditionsByType(type);this._setValueBoxByType(type);this._updateValueBox();},_onChangeCondition:function(val){this._checkValidCriteria();var f=(val=="range");if(f^this._isRange){this._isRange=f;this._setValueBoxByType(this.dlg.getColumnType(this._colSelect.get("value")));}this._updateValueBox();},_updateValueBox:function(cond){this._curValueBox.set("disabled",this._condSelect.get("value")=="isempty");},_checkValidCriteria:function(){setTimeout(lang.hitch(this,function(){this.updateRuleTitle();this.dlg._updatePane();}),0);},_createValueBox:function(cls,arg){var func=lang.hitch(arg.cbox,"_checkValidCriteria");return new cls(lang.mixin(arg,{tabIndex:_9ce.valueBox,onKeyPress:func,onChange:func,"class":"dojoxGridFCBoxValueBox"}));},_createRangeBox:function(cls,arg){var func=lang.hitch(arg.cbox,"_checkValidCriteria");lang.mixin(arg,{tabIndex:_9ce.valueBox,onKeyPress:func,onChange:func});var div=html.create("div",{"class":"dojoxGridFCBoxValueBox"}),_9e8=new cls(arg),txt=html.create("span",{"class":"dojoxGridFCBoxRangeValueTxt","innerHTML":this.plugin.nls.rangeTo}),end=new cls(arg);html.addClass(_9e8.domNode,"dojoxGridFCBoxStartValue");html.addClass(end.domNode,"dojoxGridFCBoxEndValue");div.appendChild(_9e8.domNode);div.appendChild(txt);div.appendChild(end.domNode);div.domNode=div;div.set=function(_9e9,args){if(lang.isObject(args)){_9e8.set("value",args.start);end.set("value",args.end);}};div.get=function(){var s=_9e8.get("value"),e=end.get("value");return s&&e?{start:s,end:e}:"";};return div;},changeCurrentColumn:function(_9ea){var _9eb=this.dlg.curColIdx;this._colSelect.removeOption(this._colOptions);this._colOptions=this._getColumnOptions();this._colSelect.addOption(this._colOptions);this._colSelect.set("value",_9eb>=0?String(_9eb):"anycolumn");this.updateRuleTitle(true);},curColumn:function(){return this._colSelect.getOptions(this._colSelect.get("value")).label;},curCondition:function(){return this._condSelect.getOptions(this._condSelect.get("value")).label;},curValue:function(){var cond=this._condSelect.get("value");if(cond=="isempty"){return "";}return this._curValueBox?this._curValueBox.get("value"):"";},save:function(){if(this.isEmpty()){return null;}var _9ec=this._colSelect.get("value"),type=this.dlg.getColumnType(_9ec),_9ed=this.curValue(),cond=this._condSelect.get("value");return {"column":_9ec,"condition":cond,"value":_9ed,"formattedVal":this.formatValue(type,cond,_9ed),"type":type,"colTxt":this.curColumn(),"condTxt":this.curCondition()};},load:function(obj){var tmp=[this._onChangeColumn,this._onChangeCondition];this._onChangeColumn=this._onChangeCondition=function(){};if(obj.column){this._colSelect.set("value",obj.column);}if(obj.type){this._setConditionsByType(obj.type);this._setValueBoxByType(obj.type);}else{obj.type=this.dlg.getColumnType(this._colSelect.get("value"));}if(obj.condition){this._condSelect.set("value",obj.condition);}var _9ee=obj.value||"";if(_9ee||(obj.type!="date"&&obj.type!="time")){this._curValueBox.set("value",_9ee);}this._updateValueBox();setTimeout(lang.hitch(this,function(){this._onChangeColumn=tmp[0];this._onChangeCondition=tmp[1];}),0);},getExpr:function(){if(this.isEmpty()){return null;}var _9ef=this._colSelect.get("value");return this.dlg.getExprForCriteria({"type":this.dlg.getColumnType(_9ef),"column":_9ef,"condition":this._condSelect.get("value"),"value":this.curValue()});},isEmpty:function(){var cond=this._condSelect.get("value");if(cond=="isempty"){return false;}var v=this.curValue();return v===""||v===null||typeof v=="undefined"||(typeof v=="number"&&isNaN(v));},updateRuleTitle:function(_9f0){var node=this._pane._buttonWidget.titleTextNode;var _9f1=["<div class='dojoxEllipsis'>"];if(_9f0||this.isEmpty()){node.title=_9b9.substitute(this.plugin.nls.ruleTitleTemplate,[this._ruleIndex||1]);_9f1.push(node.title);}else{var type=this.dlg.getColumnType(this._colSelect.get("value"));var _9f2=this.curColumn();var _9f3=this.curCondition();var _9f4=this.formatValue(type,this._condSelect.get("value"),this.curValue());_9f1.push(_9f2,"&nbsp;<span class='dojoxGridRuleTitleCondition'>",_9f3,"</span>&nbsp;",_9f4);node.title=[_9f2," ",_9f3," ",_9f4].join("");}node.innerHTML=_9f1.join("");if(has("mozilla")){var tt=html.create("div",{"style":"width: 100%; height: 100%; position: absolute; top: 0; left: 0; z-index: 9999;"},node);tt.title=node.title;}},updateRuleIndex:function(_9f5){if(this._ruleIndex!=_9f5){this._ruleIndex=_9f5;if(this.isEmpty()){this.updateRuleTitle();}}},setAriaInfo:function(idx){var dss=_9b9.substitute,nls=this.plugin.nls;this._colSelect.domNode.setAttribute("aria-label",dss(nls.waiColumnSelectTemplate,[idx]));this._condSelect.domNode.setAttribute("aria-label",dss(nls.waiConditionSelectTemplate,[idx]));this._pane._removeCBoxBtn.domNode.setAttribute("aria-label",dss(nls.waiRemoveRuleButtonTemplate,[idx]));this._index=idx;},_getUsableConditions:function(type){var _9f6=lang.clone(this.dlg._dataTypeMap[type].conditions);var _9f7=(this.plugin.args.disabledConditions||{})[type];var _9f8=parseInt(this._colSelect.get("value"),10);var _9f9=isNaN(_9f8)?(this.plugin.args.disabledConditions||{})["anycolumn"]:this.plugin.grid.layout.cells[_9f8].disabledConditions;if(!lang.isArray(_9f7)){_9f7=[];}if(!lang.isArray(_9f9)){_9f9=[];}var arr=_9f7.concat(_9f9);if(arr.length){var _9fa={};_9b6.forEach(arr,function(c){if(lang.isString(c)){_9fa[c.toLowerCase()]=true;}});return _9b6.filter(_9f6,function(_9fb){return !(_9fb.value in _9fa);});}return _9f6;},_setConditionsByType:function(type){var _9fc=this._condSelect;_9fc.removeOption(_9fc.options);_9fc.addOption(this._getUsableConditions(type));this._showSelectOrLabel(this._condSelect,this._condSelectAlt);},_setValueBoxByType:function(type){if(this._curValueBox){this.valueNode.removeChild(this._curValueBox.domNode);try{this._curValueBox.destroyRecursive();}catch(e){}delete this._curValueBox;}var _9fd=this.dlg._dataTypeMap[type].valueBoxCls[this._getValueBoxClsInfo(this._colSelect.get("value"),type)],_9fe=this._getValueBoxArgByType(type);this._curValueBox=this[this._isRange?"_createRangeBox":"_createValueBox"](_9fd,_9fe);this.valueNode.appendChild(this._curValueBox.domNode);this._curValueBox.focusNode.setAttribute("aria-label",_9b9.substitute(this.plugin.nls.waiValueBoxTemplate,[this._index]));this.dlg.onRendered(this);},_getValueBoxArgByType:function(type){var g=this.plugin.grid,cell=g.layout.cells[parseInt(this._colSelect.get("value"),10)],res={cbox:this};if(type=="string"){if(cell&&(cell.suggestion||cell.autoComplete)){lang.mixin(res,{store:g.store,searchAttr:cell.field||cell.name,query:g.query||{},fetchProperties:{sort:[{"attribute":cell.field||cell.name}],queryOptions:lang.mixin({ignoreCase:true,deep:true},g.queryOptions||{})}});}}else{if(type=="boolean"){lang.mixin(res,this.dlg.builder.defaultArgs["boolean"]);}}if(cell&&cell.dataTypeArgs){lang.mixin(res,cell.dataTypeArgs);}return res;},formatValue:function(type,cond,v){if(cond=="isempty"){return "";}if(type=="date"||type=="time"){var opt={selector:type},fmt=_9ba.format;if(cond=="range"){return _9b9.substitute(this.plugin.nls.rangeTemplate,[fmt(v.start,opt),fmt(v.end,opt)]);}return fmt(v,opt);}else{if(type=="boolean"){return v?this._curValueBox._lblTrue:this._curValueBox._lblFalse;}}return v;},_getValueBoxClsInfo:function(_9ff,type){var cell=this.plugin.grid.layout.cells[parseInt(_9ff,10)];if(type=="string"){return (cell&&(cell.suggestion||cell.autoComplete))?"ac":"dft";}return "dft";}});var _a00=_9b5("dojox.grid.enhanced.plugins.filter.UniqueComboBox",_9bd,{_openResultList:function(_a01){var _a02={},s=this.store,_a03=this.searchAttr;arguments[0]=_9b6.filter(_a01,function(item){var key=s.getValue(item,_a03),_a04=_a02[key];_a02[key]=true;return !_a04;});this.inherited(arguments);},_onKey:function(evt){if(evt.charOrCode===keys.ENTER&&this._opened){_9b8.stop(evt);}this.inherited(arguments);}});var _a05=_9b5("dojox.grid.enhanced.plugins.filter.BooleanValueBox",[_9c5,_9c6,_9c7],{templateString:_9cd,widgetsInTemplate:true,constructor:function(args){var nls=args.cbox.plugin.nls;this._baseId=args.cbox.id;this._lblTrue=args.trueLabel||nls.trueLabel||"true";this._lblFalse=args.falseLabel||nls.falseLabel||"false";this.args=args;},postCreate:function(){this.onChange();},onChange:function(){},get:function(prop){return this.rbTrue.get("checked");},set:function(prop,v){this.inherited(arguments);if(prop=="value"){this.rbTrue.set("checked",!!v);this.rbFalse.set("checked",!v);}}});var _a06=_9b5("dojox.grid.enhanced.plugins.filter.FilterDefDialog",null,{curColIdx:-1,_relOpCls:"logicall",_savedCriterias:null,plugin:null,constructor:function(args){var _a07=this.plugin=args.plugin;this.builder=new _9bb();this._setupData();this._cboxes=[];this.defaultType=_a07.args.defaultType||"string";(this.filterDefPane=new _9e1({"dlg":this})).startup();(this._defPane=new _9bc({"refNode":this.plugin.grid.domNode,"title":_a07.nls.filterDefDialogTitle,"class":"dojoxGridFDTitlePane","iconClass":"dojoxGridFDPaneIcon","content":this.filterDefPane})).startup();this._defPane.connect(_a07.grid.layer("filter"),"filterDef",lang.hitch(this,"_onSetFilter"));_a07.grid.setFilter=lang.hitch(this,"setFilter");_a07.grid.getFilter=lang.hitch(this,"getFilter");_a07.grid.getFilterRelation=lang.hitch(this,function(){return this._relOpCls;});_a07.connect(_a07.grid.layout,"moveColumn",lang.hitch(this,"onMoveColumn"));},onMoveColumn:function(_a08,_a09,_a0a,_a0b,_a0c){if(this._savedCriterias&&_a0a!=_a0b){if(_a0c){--_a0b;}var min=_a0a<_a0b?_a0a:_a0b;var max=_a0a<_a0b?_a0b:_a0a;var dir=_a0b>min?1:-1;_9b6.forEach(this._savedCriterias,function(sc){var idx=parseInt(sc.column,10);if(!isNaN(idx)&&idx>=min&&idx<=max){sc.column=String(idx==_a0a?idx+(max-min)*dir:idx-dir);}});}},destroy:function(){this._defPane.destroyRecursive();this._defPane=null;this.filterDefPane=null;this.builder=null;this._dataTypeMap=null;this._cboxes=null;var g=this.plugin.grid;g.setFilter=null;g.getFilter=null;g.getFilterRelation=null;this.plugin=null;},_setupData:function(){var nls=this.plugin.nls;this._dataTypeMap={"number":{valueBoxCls:{dft:_9bf},conditions:[{label:nls.conditionEqual,value:"equalto",selected:true},{label:nls.conditionNotEqual,value:"notequalto"},{label:nls.conditionLess,value:"lessthan"},{label:nls.conditionLessEqual,value:"lessthanorequalto"},{label:nls.conditionLarger,value:"largerthan"},{label:nls.conditionLargerEqual,value:"largerthanorequalto"},{label:nls.conditionIsEmpty,value:"isempty"}]},"string":{valueBoxCls:{dft:_9be,ac:_a00},conditions:[{label:nls.conditionContains,value:"contains",selected:true},{label:nls.conditionIs,value:"equalto"},{label:nls.conditionStartsWith,value:"startswith"},{label:nls.conditionEndWith,value:"endswith"},{label:nls.conditionNotContain,value:"notcontains"},{label:nls.conditionIsNot,value:"notequalto"},{label:nls.conditionNotStartWith,value:"notstartswith"},{label:nls.conditionNotEndWith,value:"notendswith"},{label:nls.conditionIsEmpty,value:"isempty"}]},"date":{valueBoxCls:{dft:_9c0},conditions:[{label:nls.conditionIs,value:"equalto",selected:true},{label:nls.conditionBefore,value:"lessthan"},{label:nls.conditionAfter,value:"largerthan"},{label:nls.conditionRange,value:"range"},{label:nls.conditionIsEmpty,value:"isempty"}]},"time":{valueBoxCls:{dft:_9c1},conditions:[{label:nls.conditionIs,value:"equalto",selected:true},{label:nls.conditionBefore,value:"lessthan"},{label:nls.conditionAfter,value:"largerthan"},{label:nls.conditionRange,value:"range"},{label:nls.conditionIsEmpty,value:"isempty"}]},"boolean":{valueBoxCls:{dft:_a05},conditions:[{label:nls.conditionIs,value:"equalto",selected:true},{label:nls.conditionIsEmpty,value:"isempty"}]}};},setFilter:function(_a0d,_a0e){_a0d=_a0d||[];if(!lang.isArray(_a0d)){_a0d=[_a0d];}var func=function(){if(_a0d.length){this._savedCriterias=_9b6.map(_a0d,function(rule){var type=rule.type||this.defaultType;return {"type":type,"column":String(rule.column),"condition":rule.condition,"value":rule.value,"colTxt":this.getColumnLabelByValue(String(rule.column)),"condTxt":this.getConditionLabelByValue(type,rule.condition),"formattedVal":rule.formattedVal||rule.value};},this);this._criteriasChanged=true;if(_a0e==="logicall"||_a0e==="logicany"){this._relOpCls=_a0e;}var _a0f=_9b6.map(_a0d,this.getExprForCriteria,this);_a0f=this.builder.buildExpression(_a0f.length==1?_a0f[0]:{"op":this._relOpCls,"data":_a0f});this.plugin.grid.layer("filter").filterDef(_a0f);this.plugin.filterBar.toggleClearFilterBtn(false);}this._closeDlgAndUpdateGrid();};if(this._savedCriterias){this._clearWithoutRefresh=true;var _a10=_9b7.connect(this,"clearFilter",this,function(){_9b7.disconnect(_a10);this._clearWithoutRefresh=false;func.apply(this);});this.onClearFilter();}else{func.apply(this);}},getFilter:function(){return lang.clone(this._savedCriterias)||[];},getColumnLabelByValue:function(v){var nls=this.plugin.nls;if(v.toLowerCase()=="anycolumn"){return nls["anyColumnOption"];}else{var cell=this.plugin.grid.layout.cells[parseInt(v,10)];return cell?(cell.name||cell.field):"";}},getConditionLabelByValue:function(type,c){var _a11=this._dataTypeMap[type].conditions;for(var i=_a11.length-1;i>=0;--i){var cond=_a11[i];if(cond.value==c.toLowerCase()){return cond.label;}}return "";},addCriteriaBoxes:function(cnt){if(typeof cnt!="number"||cnt<=0){return;}var cbs=this._cboxes,cc=this.filterDefPane.cboxContainer,_a12=this.plugin.args.ruleCount,len=cbs.length,cbox;if(_a12>0&&len+cnt>_a12){cnt=_a12-len;}for(;cnt>0;--cnt){cbox=new _9e2({dlg:this});cbs.push(cbox);cc.addChild(cbox);}cc.startup();this._updatePane();this._updateCBoxTitles();cc.selectChild(cbs[cbs.length-1]);this.filterDefPane.criteriaPane.scrollTop=1000000;if(cbs.length===4){if(has("ie")<=6&&!this.__alreadyResizedForIE6){var size=html.position(cc.domNode);size.w-=_9c9.getScrollbar().w;cc.resize(size);this.__alreadyResizedForIE6=true;}else{cc.resize();}}},removeCriteriaBoxes:function(cnt,_a13){var cbs=this._cboxes,cc=this.filterDefPane.cboxContainer,len=cbs.length,_a14=len-cnt,end=len-1,cbox,_a15=_9b6.indexOf(cbs,cc.selectedChildWidget.content);if(lang.isArray(cnt)){var i,_a16=cnt;_a16.sort();cnt=_a16.length;for(i=len-1;i>=0&&_9b6.indexOf(_a16,i)>=0;--i){}if(i>=0){if(i!=_a15){cc.selectChild(cbs[i]);}for(i=cnt-1;i>=0;--i){if(_a16[i]>=0&&_a16[i]<len){cc.removeChild(cbs[_a16[i]]);cbs.splice(_a16[i],1);}}}_a14=cbs.length;}else{if(_a13===true){if(cnt>=0&&cnt<len){_a14=end=cnt;cnt=1;}else{return;}}else{if(cnt instanceof _9e2){cbox=cnt;cnt=1;_a14=end=_9b6.indexOf(cbs,cbox);}else{if(typeof cnt!="number"||cnt<=0){return;}else{if(cnt>=len){cnt=end;_a14=1;}}}}if(end<_a14){return;}if(_a15>=_a14&&_a15<=end){cc.selectChild(cbs[_a14?_a14-1:end+1]);}for(;end>=_a14;--end){cc.removeChild(cbs[end]);}cbs.splice(_a14,cnt);}this._updatePane();this._updateCBoxTitles();if(cbs.length===3){cc.resize();}},getCriteria:function(idx){if(typeof idx!="number"){return this._savedCriterias?this._savedCriterias.length:0;}if(this._savedCriterias&&this._savedCriterias[idx]){return lang.mixin({relation:this._relOpCls=="logicall"?this.plugin.nls.and:this.plugin.nls.or},this._savedCriterias[idx]);}return null;},getExprForCriteria:function(rule){if(rule.column=="anycolumn"){var _a17=_9b6.filter(this.plugin.grid.layout.cells,function(cell){return !(cell.filterable===false||cell.hidden);});return {"op":"logicany","data":_9b6.map(_a17,function(cell){return this.getExprForColumn(rule.value,cell.index,rule.type,rule.condition);},this)};}else{return this.getExprForColumn(rule.value,rule.column,rule.type,rule.condition);}},getExprForColumn:function(_a18,_a19,type,_a1a){_a19=parseInt(_a19,10);var cell=this.plugin.grid.layout.cells[_a19],_a1b=cell.field||cell.name,obj={"datatype":type||this.getColumnType(_a19),"args":cell.dataTypeArgs,"isColumn":true},_a1c=[lang.mixin({"data":this.plugin.args.isServerSide?_a1b:cell},obj)];obj.isColumn=false;if(_a1a=="range"){_a1c.push(lang.mixin({"data":_a18.start},obj),lang.mixin({"data":_a18.end},obj));}else{if(_a1a!="isempty"){_a1c.push(lang.mixin({"data":_a18},obj));}}return {"op":_a1a,"data":_a1c};},getColumnType:function(_a1d){var cell=this.plugin.grid.layout.cells[parseInt(_a1d,10)];if(!cell||!cell.datatype){return this.defaultType;}var type=String(cell.datatype).toLowerCase();return this._dataTypeMap[type]?type:this.defaultType;},clearFilter:function(_a1e){if(!this._savedCriterias){return;}this._savedCriterias=null;this.plugin.grid.layer("filter").filterDef(null);try{this.plugin.filterBar.toggleClearFilterBtn(true);this.filterDefPane._clearFilterBtn.set("disabled",true);this.removeCriteriaBoxes(this._cboxes.length-1);this._cboxes[0].load({});}catch(e){}if(_a1e){this.closeDialog();}else{this._closeDlgAndUpdateGrid();}},showDialog:function(_a1f){this._defPane.show();this.plugin.filterStatusTip.closeDialog();this._prepareDialog(_a1f);},closeDialog:function(){if(this._defPane.open){this._defPane.hide();}},onFilter:function(e){if(this.canFilter()){this._defineFilter();this._closeDlgAndUpdateGrid();this.plugin.filterBar.toggleClearFilterBtn(false);}},onClearFilter:function(e){if(this._savedCriterias){if(this._savedCriterias.length>=this.plugin.ruleCountToConfirmClearFilter){this.plugin.clearFilterDialog.show();}else{this.clearFilter(this._clearWithoutRefresh);}}},onCancel:function(e){var sc=this._savedCriterias;var cbs=this._cboxes;if(sc){this.addCriteriaBoxes(sc.length-cbs.length);this.removeCriteriaBoxes(cbs.length-sc.length);_9b6.forEach(sc,function(c,i){cbs[i].load(c);});}else{this.removeCriteriaBoxes(cbs.length-1);cbs[0].load({});}this.closeDialog();},onRendered:function(cbox){if(!has("ff")){var _a20=_9ca._getTabNavigable(html.byId(cbox.domNode));_9c8.focus(_a20.lowest||_a20.first);}else{var dp=this._defPane;dp._getFocusItems(dp.domNode);_9c8.focus(dp._firstFocusItem);}},_onSetFilter:function(_a21){if(_a21===null&&this._savedCriterias){this.clearFilter();}},_prepareDialog:function(_a22){var sc=this._savedCriterias,cbs=this._cboxes,i,cbox;this.curColIdx=_a22;if(!sc){if(cbs.length===0){this.addCriteriaBoxes(1);}else{for(i=0;(cbox=cbs[i]);++i){cbox.changeCurrentColumn();}}}else{if(this._criteriasChanged){this.filterDefPane._relSelect.set("value",this._relOpCls==="logicall"?"0":"1");this._criteriasChanged=false;var _a23=sc.length>cbs.length?sc.length-cbs.length:0;this.addCriteriaBoxes(_a23);this.removeCriteriaBoxes(cbs.length-sc.length);this.filterDefPane._clearFilterBtn.set("disabled",false);for(i=0;i<cbs.length-_a23;++i){cbs[i].load(sc[i]);}if(_a23>0){var _a24=[],_a25=_9b7.connect(this,"onRendered",function(cbox){var i=_9b6.indexOf(cbs,cbox);if(!_a24[i]){_a24[i]=true;if(--_a23===0){_9b7.disconnect(_a25);}cbox.load(sc[i]);}});}}}this.filterDefPane.cboxContainer.resize();},_defineFilter:function(){var cbs=this._cboxes,_a26=function(_a27){return _9b6.filter(_9b6.map(cbs,function(cbox){return cbox[_a27]();}),function(_a28){return !!_a28;});},_a29=_a26("getExpr");this._savedCriterias=_a26("save");_a29=_a29.length==1?_a29[0]:{"op":this._relOpCls,"data":_a29};_a29=this.builder.buildExpression(_a29);this.plugin.grid.layer("filter").filterDef(_a29);this.filterDefPane._clearFilterBtn.set("disabled",false);},_updateCBoxTitles:function(){for(var cbs=this._cboxes,i=cbs.length;i>0;--i){cbs[i-1].updateRuleIndex(i);cbs[i-1].setAriaInfo(i);}},_updatePane:function(){var cbs=this._cboxes,_a2a=this.filterDefPane;_a2a._addCBoxBtn.set("disabled",cbs.length==this.plugin.args.ruleCount);_a2a._filterBtn.set("disabled",!this.canFilter());},canFilter:function(){return _9b6.filter(this._cboxes,function(cbox){return !cbox.isEmpty();}).length>0;},_closeDlgAndUpdateGrid:function(){this.closeDialog();var g=this.plugin.grid;g.showMessage(g.loadingMessage);setTimeout(lang.hitch(g,g._refresh),this._defPane.duration+10);}});return _a06;});},"dojo/date/locale":function(){define(["../_base/lang","../_base/array","../date","../cldr/supplemental","../i18n","../regexp","../string","../i18n!../cldr/nls/gregorian","module"],function(lang,_a2b,date,_a2c,i18n,_a2d,_a2e,_a2f,_a30){var _a31={};lang.setObject(_a30.id.replace(/\//g,"."),_a31);function _a32(_a33,_a34,_a35,_a36){return _a36.replace(/([a-z])\1*/ig,function(_a37){var s,pad,c=_a37.charAt(0),l=_a37.length,_a38=["abbr","wide","narrow"];switch(c){case "G":s=_a34[(l<4)?"eraAbbr":"eraNames"][_a33.getFullYear()<0?0:1];break;case "y":s=_a33.getFullYear();switch(l){case 1:break;case 2:if(!_a35.fullYear){s=String(s);s=s.substr(s.length-2);break;}default:pad=true;}break;case "Q":case "q":s=Math.ceil((_a33.getMonth()+1)/3);pad=true;break;case "M":case "L":var m=_a33.getMonth();if(l<3){s=m+1;pad=true;}else{var _a39=["months",c=="L"?"standAlone":"format",_a38[l-3]].join("-");s=_a34[_a39][m];}break;case "w":var _a3a=0;s=_a31._getWeekOfYear(_a33,_a3a);pad=true;break;case "d":s=_a33.getDate();pad=true;break;case "D":s=_a31._getDayOfYear(_a33);pad=true;break;case "e":case "c":var d=_a33.getDay();if(l<2){s=(d-_a2c.getFirstDayOfWeek(_a35.locale)+8)%7;break;}case "E":d=_a33.getDay();if(l<3){s=d+1;pad=true;}else{var _a3b=["days",c=="c"?"standAlone":"format",_a38[l-3]].join("-");s=_a34[_a3b][d];}break;case "a":var _a3c=_a33.getHours()<12?"am":"pm";s=_a35[_a3c]||_a34["dayPeriods-format-wide-"+_a3c];break;case "h":case "H":case "K":case "k":var h=_a33.getHours();switch(c){case "h":s=(h%12)||12;break;case "H":s=h;break;case "K":s=(h%12);break;case "k":s=h||24;break;}pad=true;break;case "m":s=_a33.getMinutes();pad=true;break;case "s":s=_a33.getSeconds();pad=true;break;case "S":s=Math.round(_a33.getMilliseconds()*Math.pow(10,l-3));pad=true;break;case "v":case "z":s=_a31._getZone(_a33,true,_a35);if(s){break;}l=4;case "Z":var _a3d=_a31._getZone(_a33,false,_a35);var tz=[(_a3d<=0?"+":"-"),_a2e.pad(Math.floor(Math.abs(_a3d)/60),2),_a2e.pad(Math.abs(_a3d)%60,2)];if(l==4){tz.splice(0,0,"GMT");tz.splice(3,0,":");}s=tz.join("");break;default:throw new Error("dojo.date.locale.format: invalid pattern char: "+_a36);}if(pad){s=_a2e.pad(s,l);}return s;});};_a31._getZone=function(_a3e,_a3f,_a40){if(_a3f){return date.getTimezoneName(_a3e);}else{return _a3e.getTimezoneOffset();}};_a31.format=function(_a41,_a42){_a42=_a42||{};var _a43=i18n.normalizeLocale(_a42.locale),_a44=_a42.formatLength||"short",_a45=_a31._getGregorianBundle(_a43),str=[],_a46=lang.hitch(this,_a32,_a41,_a45,_a42);if(_a42.selector=="year"){return _a47(_a45["dateFormatItem-yyyy"]||"yyyy",_a46);}var _a48;if(_a42.selector!="date"){_a48=_a42.timePattern||_a45["timeFormat-"+_a44];if(_a48){str.push(_a47(_a48,_a46));}}if(_a42.selector!="time"){_a48=_a42.datePattern||_a45["dateFormat-"+_a44];if(_a48){str.push(_a47(_a48,_a46));}}return str.length==1?str[0]:_a45["dateTimeFormat-"+_a44].replace(/\'/g,"").replace(/\{(\d+)\}/g,function(_a49,key){return str[key];});};_a31.regexp=function(_a4a){return _a31._parseInfo(_a4a).regexp;};_a31._parseInfo=function(_a4b){_a4b=_a4b||{};var _a4c=i18n.normalizeLocale(_a4b.locale),_a4d=_a31._getGregorianBundle(_a4c),_a4e=_a4b.formatLength||"short",_a4f=_a4b.datePattern||_a4d["dateFormat-"+_a4e],_a50=_a4b.timePattern||_a4d["timeFormat-"+_a4e],_a51;if(_a4b.selector=="date"){_a51=_a4f;}else{if(_a4b.selector=="time"){_a51=_a50;}else{_a51=_a4d["dateTimeFormat-"+_a4e].replace(/\{(\d+)\}/g,function(_a52,key){return [_a50,_a4f][key];});}}var _a53=[],re=_a47(_a51,lang.hitch(this,_a54,_a53,_a4d,_a4b));return {regexp:re,tokens:_a53,bundle:_a4d};};_a31.parse=function(_a55,_a56){var _a57=/[\u200E\u200F\u202A\u202E]/g,info=_a31._parseInfo(_a56),_a58=info.tokens,_a59=info.bundle,re=new RegExp("^"+info.regexp.replace(_a57,"")+"$",info.strict?"":"i"),_a5a=re.exec(_a55&&_a55.replace(_a57,""));if(!_a5a){return null;}var _a5b=["abbr","wide","narrow"],_a5c=[1970,0,1,0,0,0,0],amPm="",_a5d=_a2b.every(_a5a,function(v,i){if(!i){return true;}var _a5e=_a58[i-1],l=_a5e.length,c=_a5e.charAt(0);switch(c){case "y":if(l!=2&&_a56.strict){_a5c[0]=v;}else{if(v<100){v=Number(v);var year=""+new Date().getFullYear(),_a5f=year.substring(0,2)*100,_a60=Math.min(Number(year.substring(2,4))+20,99);_a5c[0]=(v<_a60)?_a5f+v:_a5f-100+v;}else{if(_a56.strict){return false;}_a5c[0]=v;}}break;case "M":case "L":if(l>2){var _a61=_a59["months-"+(c=="L"?"standAlone":"format")+"-"+_a5b[l-3]].concat();if(!_a56.strict){v=v.replace(".","").toLowerCase();_a61=_a2b.map(_a61,function(s){return s.replace(".","").toLowerCase();});}v=_a2b.indexOf(_a61,v);if(v==-1){return false;}}else{v--;}_a5c[1]=v;break;case "E":case "e":case "c":var days=_a59["days-"+(c=="c"?"standAlone":"format")+"-"+_a5b[l-3]].concat();if(!_a56.strict){v=v.toLowerCase();days=_a2b.map(days,function(d){return d.toLowerCase();});}v=_a2b.indexOf(days,v);if(v==-1){return false;}break;case "D":_a5c[1]=0;case "d":_a5c[2]=v;break;case "a":var am=_a56.am||_a59["dayPeriods-format-wide-am"],pm=_a56.pm||_a59["dayPeriods-format-wide-pm"];if(!_a56.strict){var _a62=/\./g;v=v.replace(_a62,"").toLowerCase();am=am.replace(_a62,"").toLowerCase();pm=pm.replace(_a62,"").toLowerCase();}if(_a56.strict&&v!=am&&v!=pm){return false;}amPm=(v==pm)?"p":(v==am)?"a":"";break;case "K":if(v==24){v=0;}case "h":case "H":case "k":if(v>23){return false;}_a5c[3]=v;break;case "m":_a5c[4]=v;break;case "s":_a5c[5]=v;break;case "S":_a5c[6]=v;}return true;});var _a63=+_a5c[3];if(amPm==="p"&&_a63<12){_a5c[3]=_a63+12;}else{if(amPm==="a"&&_a63==12){_a5c[3]=0;}}var _a64=new Date(_a5c[0],_a5c[1],_a5c[2],_a5c[3],_a5c[4],_a5c[5],_a5c[6]);if(_a56.strict){_a64.setFullYear(_a5c[0]);}var _a65=_a58.join(""),_a66=_a65.indexOf("d")!=-1,_a67=_a65.indexOf("M")!=-1;if(!_a5d||(_a67&&_a64.getMonth()>_a5c[1])||(_a66&&_a64.getDate()>_a5c[2])){return null;}if((_a67&&_a64.getMonth()<_a5c[1])||(_a66&&_a64.getDate()<_a5c[2])){_a64=date.add(_a64,"hour",1);}return _a64;};function _a47(_a68,_a69,_a6a,_a6b){var _a6c=function(x){return x;};_a69=_a69||_a6c;_a6a=_a6a||_a6c;_a6b=_a6b||_a6c;var _a6d=_a68.match(/(''|[^'])+/g),_a6e=_a68.charAt(0)=="'";_a2b.forEach(_a6d,function(_a6f,i){if(!_a6f){_a6d[i]="";}else{_a6d[i]=(_a6e?_a6a:_a69)(_a6f.replace(/''/g,"'"));_a6e=!_a6e;}});return _a6b(_a6d.join(""));};var _a70=["abbr","wide","narrow"];function _a54(_a71,_a72,_a73,_a74){_a74=_a2d.escapeString(_a74);if(!_a73.strict){_a74=_a74.replace(" a"," ?a");}return _a74.replace(/([a-z])\1*/ig,function(_a75){var s,c=_a75.charAt(0),l=_a75.length,p2="",p3="";if(_a73.strict){if(l>1){p2="0"+"{"+(l-1)+"}";}if(l>2){p3="0"+"{"+(l-2)+"}";}}else{p2="0?";p3="0{0,2}";}switch(c){case "y":s="\\d{2,4}";break;case "M":case "L":if(l>2){var _a76=_a72["months-"+(c=="L"?"standAlone":"format")+"-"+_a70[l-3]].slice(0);s=_a76.join("|");if(!_a73.strict){s=s.replace(/\./g,"");s="(?:"+s+")\\.?";}}else{s="1[0-2]|"+p2+"[1-9]";}break;case "D":s="[12][0-9][0-9]|3[0-5][0-9]|36[0-6]|"+p2+"[1-9][0-9]|"+p3+"[1-9]";break;case "d":s="3[01]|[12]\\d|"+p2+"[1-9]";break;case "w":s="[1-4][0-9]|5[0-3]|"+p2+"[1-9]";break;case "E":case "e":case "c":s=".+?";break;case "h":s="1[0-2]|"+p2+"[1-9]";break;case "k":s="1[01]|"+p2+"\\d";break;case "H":s="1\\d|2[0-3]|"+p2+"\\d";break;case "K":s="1\\d|2[0-4]|"+p2+"[1-9]";break;case "m":case "s":s="[0-5]\\d";break;case "S":s="\\d{"+l+"}";break;case "a":var am=_a73.am||_a72["dayPeriods-format-wide-am"],pm=_a73.pm||_a72["dayPeriods-format-wide-pm"];s=am+"|"+pm;if(!_a73.strict){if(am!=am.toLowerCase()){s+="|"+am.toLowerCase();}if(pm!=pm.toLowerCase()){s+="|"+pm.toLowerCase();}if(s.indexOf(".")!=-1){s+="|"+s.replace(/\./g,"");}}s=s.replace(/\./g,"\\.");break;default:s=".*";}if(_a71){_a71.push(_a75);}return "("+s+")";}).replace(/[\xa0 ]/g,"[\\s\\xa0]");};var _a77=[];var _a78={};_a31.addCustomFormats=function(_a79,_a7a){_a77.push({pkg:_a79,name:_a7a});_a78={};};_a31._getGregorianBundle=function(_a7b){if(_a78[_a7b]){return _a78[_a7b];}var _a7c={};_a2b.forEach(_a77,function(desc){var _a7d=i18n.getLocalization(desc.pkg,desc.name,_a7b);_a7c=lang.mixin(_a7c,_a7d);},this);return _a78[_a7b]=_a7c;};_a31.addCustomFormats(_a30.id.replace(/\/date\/locale$/,".cldr"),"gregorian");_a31.getNames=function(item,type,_a7e,_a7f){var _a80,_a81=_a31._getGregorianBundle(_a7f),_a82=[item,_a7e,type];if(_a7e=="standAlone"){var key=_a82.join("-");_a80=_a81[key];if(_a80[0]==1){_a80=undefined;}}_a82[1]="format";return (_a80||_a81[_a82.join("-")]).concat();};_a31.isWeekend=function(_a83,_a84){var _a85=_a2c.getWeekend(_a84),day=(_a83||new Date()).getDay();if(_a85.end<_a85.start){_a85.end+=7;if(day<_a85.start){day+=7;}}return day>=_a85.start&&day<=_a85.end;};_a31._getDayOfYear=function(_a86){return date.difference(new Date(_a86.getFullYear(),0,1,_a86.getHours()),_a86)+1;};_a31._getWeekOfYear=function(_a87,_a88){if(arguments.length==1){_a88=0;}var _a89=new Date(_a87.getFullYear(),0,1).getDay(),adj=(_a89-_a88+7)%7,week=Math.floor((_a31._getDayOfYear(_a87)+adj-1)/7);if(_a89==_a88){week++;}return week;};return _a31;});},"dojo/date":function(){define(["./has","./_base/lang"],function(has,lang){var date={};date.getDaysInMonth=function(_a8a){var _a8b=_a8a.getMonth();var days=[31,28,31,30,31,30,31,31,30,31,30,31];if(_a8b==1&&date.isLeapYear(_a8a)){return 29;}return days[_a8b];};date.isLeapYear=function(_a8c){var year=_a8c.getFullYear();return !(year%400)||(!(year%4)&&!!(year%100));};date.getTimezoneName=function(_a8d){var str=_a8d.toString();var tz="";var _a8e;var pos=str.indexOf("(");if(pos>-1){tz=str.substring(++pos,str.indexOf(")"));}else{var pat=/([A-Z\/]+) \d{4}$/;if((_a8e=str.match(pat))){tz=_a8e[1];}else{str=_a8d.toLocaleString();pat=/ ([A-Z\/]+)$/;if((_a8e=str.match(pat))){tz=_a8e[1];}}}return (tz=="AM"||tz=="PM")?"":tz;};date.compare=function(_a8f,_a90,_a91){_a8f=new Date(+_a8f);_a90=new Date(+(_a90||new Date()));if(_a91=="date"){_a8f.setHours(0,0,0,0);_a90.setHours(0,0,0,0);}else{if(_a91=="time"){_a8f.setFullYear(0,0,0);_a90.setFullYear(0,0,0);}}if(_a8f>_a90){return 1;}if(_a8f<_a90){return -1;}return 0;};date.add=function(date,_a92,_a93){var sum=new Date(+date);var _a94=false;var _a95="Date";switch(_a92){case "day":break;case "weekday":var days,_a96;var mod=_a93%5;if(!mod){days=(_a93>0)?5:-5;_a96=(_a93>0)?((_a93-5)/5):((_a93+5)/5);}else{days=mod;_a96=parseInt(_a93/5);}var strt=date.getDay();var adj=0;if(strt==6&&_a93>0){adj=1;}else{if(strt==0&&_a93<0){adj=-1;}}var trgt=strt+days;if(trgt==0||trgt==6){adj=(_a93>0)?2:-2;}_a93=(7*_a96)+days+adj;break;case "year":_a95="FullYear";_a94=true;break;case "week":_a93*=7;break;case "quarter":_a93*=3;case "month":_a94=true;_a95="Month";break;default:_a95="UTC"+_a92.charAt(0).toUpperCase()+_a92.substring(1)+"s";}if(_a95){sum["set"+_a95](sum["get"+_a95]()+_a93);}if(_a94&&(sum.getDate()<date.getDate())){sum.setDate(0);}return sum;};date.difference=function(_a97,_a98,_a99){_a98=_a98||new Date();_a99=_a99||"day";var _a9a=_a98.getFullYear()-_a97.getFullYear();var _a9b=1;switch(_a99){case "quarter":var m1=_a97.getMonth();var m2=_a98.getMonth();var q1=Math.floor(m1/3)+1;var q2=Math.floor(m2/3)+1;q2+=(_a9a*4);_a9b=q2-q1;break;case "weekday":var days=Math.round(date.difference(_a97,_a98,"day"));var _a9c=parseInt(date.difference(_a97,_a98,"week"));var mod=days%7;if(mod==0){days=_a9c*5;}else{var adj=0;var aDay=_a97.getDay();var bDay=_a98.getDay();_a9c=parseInt(days/7);mod=days%7;var _a9d=new Date(_a97);_a9d.setDate(_a9d.getDate()+(_a9c*7));var _a9e=_a9d.getDay();if(days>0){switch(true){case aDay==6:adj=-1;break;case aDay==0:adj=0;break;case bDay==6:adj=-1;break;case bDay==0:adj=-2;break;case (_a9e+mod)>5:adj=-2;}}else{if(days<0){switch(true){case aDay==6:adj=0;break;case aDay==0:adj=1;break;case bDay==6:adj=2;break;case bDay==0:adj=1;break;case (_a9e+mod)<0:adj=2;}}}days+=adj;days-=(_a9c*2);}_a9b=days;break;case "year":_a9b=_a9a;break;case "month":_a9b=(_a98.getMonth()-_a97.getMonth())+(_a9a*12);break;case "week":_a9b=parseInt(date.difference(_a97,_a98,"day")/7);break;case "day":_a9b/=24;case "hour":_a9b/=60;case "minute":_a9b/=60;case "second":_a9b/=1000;case "millisecond":_a9b*=_a98.getTime()-_a97.getTime();}return Math.round(_a9b);};1&&lang.mixin(lang.getObject("dojo.date",true),date);return date;});},"dojo/cldr/supplemental":function(){define(["../_base/lang","../i18n"],function(lang,i18n){var _a9f={};lang.setObject("dojo.cldr.supplemental",_a9f);_a9f.getFirstDayOfWeek=function(_aa0){var _aa1={bd:5,mv:5,ae:6,af:6,bh:6,dj:6,dz:6,eg:6,iq:6,ir:6,jo:6,kw:6,ly:6,ma:6,om:6,qa:6,sa:6,sd:6,sy:6,ye:6,ag:0,ar:0,as:0,au:0,br:0,bs:0,bt:0,bw:0,by:0,bz:0,ca:0,cn:0,co:0,dm:0,"do":0,et:0,gt:0,gu:0,hk:0,hn:0,id:0,ie:0,il:0,"in":0,jm:0,jp:0,ke:0,kh:0,kr:0,la:0,mh:0,mm:0,mo:0,mt:0,mx:0,mz:0,ni:0,np:0,nz:0,pa:0,pe:0,ph:0,pk:0,pr:0,py:0,sg:0,sv:0,th:0,tn:0,tt:0,tw:0,um:0,us:0,ve:0,vi:0,ws:0,za:0,zw:0};var _aa2=_a9f._region(_aa0);var dow=_aa1[_aa2];return (dow===undefined)?1:dow;};_a9f._region=function(_aa3){_aa3=i18n.normalizeLocale(_aa3);var tags=_aa3.split("-");var _aa4=tags[1];if(!_aa4){_aa4={aa:"et",ab:"ge",af:"za",ak:"gh",am:"et",ar:"eg",as:"in",av:"ru",ay:"bo",az:"az",ba:"ru",be:"by",bg:"bg",bi:"vu",bm:"ml",bn:"bd",bo:"cn",br:"fr",bs:"ba",ca:"es",ce:"ru",ch:"gu",co:"fr",cr:"ca",cs:"cz",cv:"ru",cy:"gb",da:"dk",de:"de",dv:"mv",dz:"bt",ee:"gh",el:"gr",en:"us",es:"es",et:"ee",eu:"es",fa:"ir",ff:"sn",fi:"fi",fj:"fj",fo:"fo",fr:"fr",fy:"nl",ga:"ie",gd:"gb",gl:"es",gn:"py",gu:"in",gv:"gb",ha:"ng",he:"il",hi:"in",ho:"pg",hr:"hr",ht:"ht",hu:"hu",hy:"am",ia:"fr",id:"id",ig:"ng",ii:"cn",ik:"us","in":"id",is:"is",it:"it",iu:"ca",iw:"il",ja:"jp",ji:"ua",jv:"id",jw:"id",ka:"ge",kg:"cd",ki:"ke",kj:"na",kk:"kz",kl:"gl",km:"kh",kn:"in",ko:"kr",ks:"in",ku:"tr",kv:"ru",kw:"gb",ky:"kg",la:"va",lb:"lu",lg:"ug",li:"nl",ln:"cd",lo:"la",lt:"lt",lu:"cd",lv:"lv",mg:"mg",mh:"mh",mi:"nz",mk:"mk",ml:"in",mn:"mn",mo:"ro",mr:"in",ms:"my",mt:"mt",my:"mm",na:"nr",nb:"no",nd:"zw",ne:"np",ng:"na",nl:"nl",nn:"no",no:"no",nr:"za",nv:"us",ny:"mw",oc:"fr",om:"et",or:"in",os:"ge",pa:"in",pl:"pl",ps:"af",pt:"br",qu:"pe",rm:"ch",rn:"bi",ro:"ro",ru:"ru",rw:"rw",sa:"in",sd:"in",se:"no",sg:"cf",si:"lk",sk:"sk",sl:"si",sm:"ws",sn:"zw",so:"so",sq:"al",sr:"rs",ss:"za",st:"za",su:"id",sv:"se",sw:"tz",ta:"in",te:"in",tg:"tj",th:"th",ti:"et",tk:"tm",tl:"ph",tn:"za",to:"to",tr:"tr",ts:"za",tt:"ru",ty:"pf",ug:"cn",uk:"ua",ur:"pk",uz:"uz",ve:"za",vi:"vn",wa:"be",wo:"sn",xh:"za",yi:"il",yo:"ng",za:"cn",zh:"cn",zu:"za",ace:"id",ady:"ru",agq:"cm",alt:"ru",amo:"ng",asa:"tz",ast:"es",awa:"in",bal:"pk",ban:"id",bas:"cm",bax:"cm",bbc:"id",bem:"zm",bez:"tz",bfq:"in",bft:"pk",bfy:"in",bhb:"in",bho:"in",bik:"ph",bin:"ng",bjj:"in",bku:"ph",bqv:"ci",bra:"in",brx:"in",bss:"cm",btv:"pk",bua:"ru",buc:"yt",bug:"id",bya:"id",byn:"er",cch:"ng",ccp:"in",ceb:"ph",cgg:"ug",chk:"fm",chm:"ru",chp:"ca",chr:"us",cja:"kh",cjm:"vn",ckb:"iq",crk:"ca",csb:"pl",dar:"ru",dav:"ke",den:"ca",dgr:"ca",dje:"ne",doi:"in",dsb:"de",dua:"cm",dyo:"sn",dyu:"bf",ebu:"ke",efi:"ng",ewo:"cm",fan:"gq",fil:"ph",fon:"bj",fur:"it",gaa:"gh",gag:"md",gbm:"in",gcr:"gf",gez:"et",gil:"ki",gon:"in",gor:"id",grt:"in",gsw:"ch",guz:"ke",gwi:"ca",haw:"us",hil:"ph",hne:"in",hnn:"ph",hoc:"in",hoj:"in",ibb:"ng",ilo:"ph",inh:"ru",jgo:"cm",jmc:"tz",kaa:"uz",kab:"dz",kaj:"ng",kam:"ke",kbd:"ru",kcg:"ng",kde:"tz",kdt:"th",kea:"cv",ken:"cm",kfo:"ci",kfr:"in",kha:"in",khb:"cn",khq:"ml",kht:"in",kkj:"cm",kln:"ke",kmb:"ao",koi:"ru",kok:"in",kos:"fm",kpe:"lr",krc:"ru",kri:"sl",krl:"ru",kru:"in",ksb:"tz",ksf:"cm",ksh:"de",kum:"ru",lag:"tz",lah:"pk",lbe:"ru",lcp:"cn",lep:"in",lez:"ru",lif:"np",lis:"cn",lki:"ir",lmn:"in",lol:"cd",lua:"cd",luo:"ke",luy:"ke",lwl:"th",mad:"id",mag:"in",mai:"in",mak:"id",man:"gn",mas:"ke",mdf:"ru",mdh:"ph",mdr:"id",men:"sl",mer:"ke",mfe:"mu",mgh:"mz",mgo:"cm",min:"id",mni:"in",mnk:"gm",mnw:"mm",mos:"bf",mua:"cm",mwr:"in",myv:"ru",nap:"it",naq:"na",nds:"de","new":"np",niu:"nu",nmg:"cm",nnh:"cm",nod:"th",nso:"za",nus:"sd",nym:"tz",nyn:"ug",pag:"ph",pam:"ph",pap:"bq",pau:"pw",pon:"fm",prd:"ir",raj:"in",rcf:"re",rej:"id",rjs:"np",rkt:"in",rof:"tz",rwk:"tz",saf:"gh",sah:"ru",saq:"ke",sas:"id",sat:"in",saz:"in",sbp:"tz",scn:"it",sco:"gb",sdh:"ir",seh:"mz",ses:"ml",shi:"ma",shn:"mm",sid:"et",sma:"se",smj:"se",smn:"fi",sms:"fi",snk:"ml",srn:"sr",srr:"sn",ssy:"er",suk:"tz",sus:"gn",swb:"yt",swc:"cd",syl:"bd",syr:"sy",tbw:"ph",tcy:"in",tdd:"cn",tem:"sl",teo:"ug",tet:"tl",tig:"er",tiv:"ng",tkl:"tk",tmh:"ne",tpi:"pg",trv:"tw",tsg:"ph",tts:"th",tum:"mw",tvl:"tv",twq:"ne",tyv:"ru",tzm:"ma",udm:"ru",uli:"fm",umb:"ao",unr:"in",unx:"in",vai:"lr",vun:"tz",wae:"ch",wal:"et",war:"ph",xog:"ug",xsr:"np",yao:"mz",yap:"fm",yav:"cm",zza:"tr"}[tags[0]];}else{if(_aa4.length==4){_aa4=tags[2];}}return _aa4;};_a9f.getWeekend=function(_aa5){var _aa6={"in":0,af:4,dz:4,ir:4,om:4,sa:4,ye:4,ae:5,bh:5,eg:5,il:5,iq:5,jo:5,kw:5,ly:5,ma:5,qa:5,sd:5,sy:5,tn:5},_aa7={af:5,dz:5,ir:5,om:5,sa:5,ye:5,ae:6,bh:5,eg:6,il:6,iq:6,jo:6,kw:6,ly:6,ma:6,qa:6,sd:6,sy:6,tn:6},_aa8=_a9f._region(_aa5),_aa9=_aa6[_aa8],end=_aa7[_aa8];if(_aa9===undefined){_aa9=6;}if(end===undefined){end=0;}return {start:_aa9,end:end};};return _a9f;});},"dojo/regexp":function(){define(["./_base/kernel","./_base/lang"],function(dojo,lang){var _aaa={};lang.setObject("dojo.regexp",_aaa);_aaa.escapeString=function(str,_aab){return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+\-^])/g,function(ch){if(_aab&&_aab.indexOf(ch)!=-1){return ch;}return "\\"+ch;});};_aaa.buildGroupRE=function(arr,re,_aac){if(!(arr instanceof Array)){return re(arr);}var b=[];for(var i=0;i<arr.length;i++){b.push(re(arr[i]));}return _aaa.group(b.join("|"),_aac);};_aaa.group=function(_aad,_aae){return "("+(_aae?"?:":"")+_aad+")";};return _aaa;});},"dojox/grid/enhanced/plugins/filter/FilterBuilder":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","./_FilterExpr"],function(_aaf,_ab0,lang,_ab1){var bdr=function(_ab2){return lang.partial(function(cls,_ab3){return new _ab1[cls](_ab3);},_ab2);},_ab4=function(_ab5){return lang.partial(function(cls,_ab6){return new _ab1.LogicNOT(new _ab1[cls](_ab6));},_ab5);};return _aaf("dojox.grid.enhanced.plugins.filter.FilterBuilder",null,{buildExpression:function(def){if("op" in def){return this.supportedOps[def.op.toLowerCase()](_ab0.map(def.data,this.buildExpression,this));}else{var args=lang.mixin(this.defaultArgs[def.datatype],def.args||{});return new this.supportedTypes[def.datatype](def.data,def.isColumn,args);}},supportedOps:{"equalto":bdr("EqualTo"),"lessthan":bdr("LessThan"),"lessthanorequalto":bdr("LessThanOrEqualTo"),"largerthan":bdr("LargerThan"),"largerthanorequalto":bdr("LargerThanOrEqualTo"),"contains":bdr("Contains"),"startswith":bdr("StartsWith"),"endswith":bdr("EndsWith"),"notequalto":_ab4("EqualTo"),"notcontains":_ab4("Contains"),"notstartswith":_ab4("StartsWith"),"notendswith":_ab4("EndsWith"),"isempty":bdr("IsEmpty"),"range":function(_ab7){return new _ab1.LogicALL(new _ab1.LargerThanOrEqualTo(_ab7.slice(0,2)),new _ab1.LessThanOrEqualTo(_ab7[0],_ab7[2]));},"logicany":bdr("LogicANY"),"logicall":bdr("LogicALL")},supportedTypes:{"number":_ab1.NumberExpr,"string":_ab1.StringExpr,"boolean":_ab1.BooleanExpr,"date":_ab1.DateExpr,"time":_ab1.TimeExpr},defaultArgs:{"boolean":{"falseValue":"false","convert":function(_ab8,args){var _ab9=args.falseValue;var _aba=args.trueValue;if(lang.isString(_ab8)){if(_aba&&_ab8.toLowerCase()==_aba){return true;}if(_ab9&&_ab8.toLowerCase()==_ab9){return false;}}return !!_ab8;}}}});});},"dojox/grid/enhanced/plugins/filter/_FilterExpr":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/date","./_DataExprs"],function(_abb,lang,date,_abc){var _abd=_abb("dojox.grid.enhanced.plugins.filter.LogicAND",_abc._BiOpExpr,{_name:"and",_calculate:function(_abe,_abf,_ac0,_ac1){var res=_abe.applyRow(_ac0,_ac1).getValue()&&_abf.applyRow(_ac0,_ac1).getValue();return new _abc.BooleanExpr(res);}});var _ac2=_abb("dojox.grid.enhanced.plugins.filter.LogicOR",_abc._BiOpExpr,{_name:"or",_calculate:function(_ac3,_ac4,_ac5,_ac6){var res=_ac3.applyRow(_ac5,_ac6).getValue()||_ac4.applyRow(_ac5,_ac6).getValue();return new _abc.BooleanExpr(res);}});var _ac7=_abb("dojox.grid.enhanced.plugins.filter.LogicXOR",_abc._BiOpExpr,{_name:"xor",_calculate:function(_ac8,_ac9,_aca,_acb){var _acc=_ac8.applyRow(_aca,_acb).getValue();var _acd=_ac9.applyRow(_aca,_acb).getValue();return new _abc.BooleanExpr((!!_acc)!=(!!_acd));}});var _ace=_abb("dojox.grid.enhanced.plugins.filter.LogicNOT",_abc._UniOpExpr,{_name:"not",_calculate:function(_acf,_ad0,_ad1){return new _abc.BooleanExpr(!_acf.applyRow(_ad0,_ad1).getValue());}});var _ad2=_abb("dojox.grid.enhanced.plugins.filter.LogicALL",_abc._OperatorExpr,{_name:"all",applyRow:function(_ad3,_ad4){for(var i=0,res=true;res&&(this._operands[i] instanceof _abc._ConditionExpr);++i){res=this._operands[i].applyRow(_ad3,_ad4).getValue();}return new _abc.BooleanExpr(res);}});var _ad5=_abb("dojox.grid.enhanced.plugins.filter.LogicANY",_abc._OperatorExpr,{_name:"any",applyRow:function(_ad6,_ad7){for(var i=0,res=false;!res&&(this._operands[i] instanceof _abc._ConditionExpr);++i){res=this._operands[i].applyRow(_ad6,_ad7).getValue();}return new _abc.BooleanExpr(res);}});function _ad8(left,_ad9,row,_ada){left=left.applyRow(row,_ada);_ad9=_ad9.applyRow(row,_ada);var _adb=left.getValue();var _adc=_ad9.getValue();if(left instanceof _abc.TimeExpr){return date.compare(_adb,_adc,"time");}else{if(left instanceof _abc.DateExpr){return date.compare(_adb,_adc,"date");}else{if(left instanceof _abc.StringExpr){_adb=_adb.toLowerCase();_adc=String(_adc).toLowerCase();}return _adb==_adc?0:(_adb<_adc?-1:1);}}};var _add=_abb("dojox.grid.enhanced.plugins.filter.EqualTo",_abc._BiOpExpr,{_name:"equal",_calculate:function(_ade,_adf,_ae0,_ae1){var res=_ad8(_ade,_adf,_ae0,_ae1);return new _abc.BooleanExpr(res===0);}});var _ae2=_abb("dojox.grid.enhanced.plugins.filter.LessThan",_abc._BiOpExpr,{_name:"less",_calculate:function(_ae3,_ae4,_ae5,_ae6){var res=_ad8(_ae3,_ae4,_ae5,_ae6);return new _abc.BooleanExpr(res<0);}});var _ae7=_abb("dojox.grid.enhanced.plugins.filter.LessThanOrEqualTo",_abc._BiOpExpr,{_name:"lessEqual",_calculate:function(_ae8,_ae9,_aea,_aeb){var res=_ad8(_ae8,_ae9,_aea,_aeb);return new _abc.BooleanExpr(res<=0);}});var _aec=_abb("dojox.grid.enhanced.plugins.filter.LargerThan",_abc._BiOpExpr,{_name:"larger",_calculate:function(_aed,_aee,_aef,_af0){var res=_ad8(_aed,_aee,_aef,_af0);return new _abc.BooleanExpr(res>0);}});var _af1=_abb("dojox.grid.enhanced.plugins.filter.LargerThanOrEqualTo",_abc._BiOpExpr,{_name:"largerEqual",_calculate:function(_af2,_af3,_af4,_af5){var res=_ad8(_af2,_af3,_af4,_af5);return new _abc.BooleanExpr(res>=0);}});var _af6=_abb("dojox.grid.enhanced.plugins.filter.Contains",_abc._BiOpExpr,{_name:"contains",_calculate:function(_af7,_af8,_af9,_afa){var _afb=String(_af7.applyRow(_af9,_afa).getValue()).toLowerCase();var _afc=String(_af8.applyRow(_af9,_afa).getValue()).toLowerCase();return new _abc.BooleanExpr(_afb.indexOf(_afc)>=0);}});var _afd=_abb("dojox.grid.enhanced.plugins.filter.StartsWith",_abc._BiOpExpr,{_name:"startsWith",_calculate:function(_afe,_aff,_b00,_b01){var _b02=String(_afe.applyRow(_b00,_b01).getValue()).toLowerCase();var _b03=String(_aff.applyRow(_b00,_b01).getValue()).toLowerCase();return new _abc.BooleanExpr(_b02.substring(0,_b03.length)==_b03);}});var _b04=_abb("dojox.grid.enhanced.plugins.filter.EndsWith",_abc._BiOpExpr,{_name:"endsWith",_calculate:function(_b05,_b06,_b07,_b08){var _b09=String(_b05.applyRow(_b07,_b08).getValue()).toLowerCase();var _b0a=String(_b06.applyRow(_b07,_b08).getValue()).toLowerCase();return new _abc.BooleanExpr(_b09.substring(_b09.length-_b0a.length)==_b0a);}});var _b0b=_abb("dojox.grid.enhanced.plugins.filter.Matches",_abc._BiOpExpr,{_name:"matches",_calculate:function(_b0c,_b0d,_b0e,_b0f){var _b10=String(_b0c.applyRow(_b0e,_b0f).getValue());var _b11=new RegExp(_b0d.applyRow(_b0e,_b0f).getValue());return new _abc.BooleanExpr(_b10.search(_b11)>=0);}});var _b12=_abb("dojox.grid.enhanced.plugins.filter.IsEmpty",_abc._UniOpExpr,{_name:"isEmpty",_calculate:function(_b13,_b14,_b15){var res=_b13.applyRow(_b14,_b15).getValue();return new _abc.BooleanExpr(res===""||res==null);}});return lang.mixin({LogicAND:_abd,LogicOR:_ac2,LogicXOR:_ac7,LogicNOT:_ace,LogicALL:_ad2,LogicANY:_ad5,EqualTo:_add,LessThan:_ae2,LessThanOrEqualTo:_ae7,LargerThan:_aec,LargerThanOrEqualTo:_af1,Contains:_af6,StartsWith:_afd,EndsWith:_b04,Matches:_b0b,IsEmpty:_b12},_abc);});},"dojox/grid/enhanced/plugins/filter/_DataExprs":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/date/locale","./_ConditionExpr"],function(_b16,lang,_b17,_b18){var _b19=_b16("dojox.grid.enhanced.plugins.filter.BooleanExpr",_b18._DataExpr,{_name:"bool",_convertData:function(_b1a){return !!_b1a;}});var _b1b=_b16("dojox.grid.enhanced.plugins.filter.StringExpr",_b18._DataExpr,{_name:"string",_convertData:function(_b1c){return String(_b1c);}});var _b1d=_b16("dojox.grid.enhanced.plugins.filter.NumberExpr",_b18._DataExpr,{_name:"number",_convertDataToExpr:function(_b1e){return parseFloat(_b1e);}});var _b1f=_b16("dojox.grid.enhanced.plugins.filter.DateExpr",_b18._DataExpr,{_name:"date",_convertData:function(_b20){if(_b20 instanceof Date){return _b20;}else{if(typeof _b20=="number"){return new Date(_b20);}else{var res=_b17.parse(String(_b20),lang.mixin({selector:this._name},this._convertArgs));if(!res){throw new Error("Datetime parse failed: "+_b20);}return res;}}},toObject:function(){if(this._value instanceof Date){var tmp=this._value;this._value=this._value.valueOf();var res=this.inherited(arguments);this._value=tmp;return res;}else{return this.inherited(arguments);}}});var _b21=_b16("dojox.grid.enhanced.plugins.filter.TimeExpr",_b1f,{_name:"time"});return lang.mixin({BooleanExpr:_b19,StringExpr:_b1b,NumberExpr:_b1d,DateExpr:_b1f,TimeExpr:_b21},_b18);});},"dojox/grid/enhanced/plugins/filter/_ConditionExpr":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/_base/array"],function(_b22,lang,_b23){var _b24=_b22("dojox.grid.enhanced.plugins.filter._ConditionExpr",null,{_name:"expr",applyRow:function(_b25,_b26){throw new Error("_ConditionExpr.applyRow: unimplemented interface");},toObject:function(){return {};},getName:function(){return this._name;}});var _b27=_b22("dojox.grid.enhanced.plugins.filter._DataExpr",_b24,{_name:"data",constructor:function(_b28,_b29,_b2a){this._convertArgs=_b2a||{};if(lang.isFunction(this._convertArgs.convert)){this._convertData=lang.hitch(this._convertArgs.scope,this._convertArgs.convert);}if(_b29){this._colArg=_b28;}else{this._value=this._convertData(_b28,this._convertArgs);}},getValue:function(){return this._value;},applyRow:function(_b2b,_b2c){return typeof this._colArg=="undefined"?this:new (lang.getObject(this.declaredClass))(this._convertData(_b2c(_b2b,this._colArg),this._convertArgs));},_convertData:function(_b2d){return _b2d;},toObject:function(){return {op:this.getName(),data:this._colArg===undefined?this._value:this._colArg,isCol:this._colArg!==undefined};}});var _b2e=_b22("dojox.grid.enhanced.plugins.filter._OperatorExpr",_b24,{_name:"operator",constructor:function(){if(lang.isArray(arguments[0])){this._operands=arguments[0];}else{this._operands=[];for(var i=0;i<arguments.length;++i){this._operands.push(arguments[i]);}}},toObject:function(){return {op:this.getName(),data:_b23.map(this._operands,function(_b2f){return _b2f.toObject();})};}});var _b30=_b22("dojox.grid.enhanced.plugins.filter._UniOpExpr",_b2e,{_name:"uniOperator",applyRow:function(_b31,_b32){if(!(this._operands[0] instanceof _b24)){throw new Error("_UniOpExpr: operand is not expression.");}return this._calculate(this._operands[0],_b31,_b32);},_calculate:function(_b33,_b34,_b35){throw new Error("_UniOpExpr._calculate: unimplemented interface");}});var _b36=_b22("dojox.grid.enhanced.plugins.filter._BiOpExpr",_b2e,{_name:"biOperator",applyRow:function(_b37,_b38){if(!(this._operands[0] instanceof _b24)){throw new Error("_BiOpExpr: left operand is not expression.");}else{if(!(this._operands[1] instanceof _b24)){throw new Error("_BiOpExpr: right operand is not expression.");}}return this._calculate(this._operands[0],this._operands[1],_b37,_b38);},_calculate:function(_b39,_b3a,_b3b,_b3c){throw new Error("_BiOpExpr._calculate: unimplemented interface");}});return {_ConditionExpr:_b24,_DataExpr:_b27,_OperatorExpr:_b2e,_UniOpExpr:_b30,_BiOpExpr:_b36};});},"dijit/form/ComboBox":function(){define(["dojo/_base/declare","./ValidationTextBox","./ComboBoxMixin"],function(_b3d,_b3e,_b3f){return _b3d("dijit.form.ComboBox",[_b3e,_b3f],{});});},"dijit/form/ValidationTextBox":function(){define(["dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/i18n","./TextBox","../Tooltip","dojo/text!./templates/ValidationTextBox.html","dojo/i18n!./nls/validate"],function(_b40,_b41,lang,i18n,_b42,_b43,_b44){var _b45=_b40("dijit.form.ValidationTextBox",_b42,{templateString:_b44,required:false,promptMessage:"",invalidMessage:"$_unset_$",missingMessage:"$_unset_$",message:"",constraints:{},pattern:".*",regExp:"",regExpGen:function(){},state:"",tooltipPosition:[],_deprecateRegExp:function(attr,_b46){if(_b46!=_b45.prototype[attr]){_b41.deprecated("ValidationTextBox id="+this.id+", set('"+attr+"', ...) is deprecated.  Use set('pattern', ...) instead.","","2.0");this.set("pattern",_b46);}},_setRegExpGenAttr:function(_b47){this._deprecateRegExp("regExpGen",_b47);this._set("regExpGen",this._computeRegexp);},_setRegExpAttr:function(_b48){this._deprecateRegExp("regExp",_b48);},_setValueAttr:function(){this.inherited(arguments);this._refreshState();},validator:function(_b49,_b4a){return (new RegExp("^(?:"+this._computeRegexp(_b4a)+")"+(this.required?"":"?")+"$")).test(_b49)&&(!this.required||!this._isEmpty(_b49))&&(this._isEmpty(_b49)||this.parse(_b49,_b4a)!==undefined);},_isValidSubset:function(){return this.textbox.value.search(this._partialre)==0;},isValid:function(){return this.validator(this.textbox.value,this.get("constraints"));},_isEmpty:function(_b4b){return (this.trim?/^\s*$/:/^$/).test(_b4b);},getErrorMessage:function(){var _b4c=this.invalidMessage=="$_unset_$"?this.messages.invalidMessage:!this.invalidMessage?this.promptMessage:this.invalidMessage;var _b4d=this.missingMessage=="$_unset_$"?this.messages.missingMessage:!this.missingMessage?_b4c:this.missingMessage;return (this.required&&this._isEmpty(this.textbox.value))?_b4d:_b4c;},getPromptMessage:function(){return this.promptMessage;},_maskValidSubsetError:true,validate:function(_b4e){var _b4f="";var _b50=this.disabled||this.isValid(_b4e);if(_b50){this._maskValidSubsetError=true;}var _b51=this._isEmpty(this.textbox.value);var _b52=!_b50&&_b4e&&this._isValidSubset();this._set("state",_b50?"":(((((!this._hasBeenBlurred||_b4e)&&_b51)||_b52)&&(this._maskValidSubsetError||(_b52&&!this._hasBeenBlurred&&_b4e)))?"Incomplete":"Error"));this.focusNode.setAttribute("aria-invalid",this.state=="Error"?"true":"false");if(this.state=="Error"){this._maskValidSubsetError=_b4e&&_b52;_b4f=this.getErrorMessage(_b4e);}else{if(this.state=="Incomplete"){_b4f=this.getPromptMessage(_b4e);this._maskValidSubsetError=!this._hasBeenBlurred||_b4e;}else{if(_b51){_b4f=this.getPromptMessage(_b4e);}}}this.set("message",_b4f);return _b50;},displayMessage:function(_b53){if(_b53&&this.focused){_b43.show(_b53,this.domNode,this.tooltipPosition,!this.isLeftToRight());}else{_b43.hide(this.domNode);}},_refreshState:function(){if(this._created){this.validate(this.focused);}this.inherited(arguments);},constructor:function(_b54){this.constraints=lang.clone(this.constraints);this.baseClass+=" dijitValidationTextBox";},startup:function(){this.inherited(arguments);this._refreshState();},_setConstraintsAttr:function(_b55){if(!_b55.locale&&this.lang){_b55.locale=this.lang;}this._set("constraints",_b55);this._refreshState();},_setPatternAttr:function(_b56){this._set("pattern",_b56);this._refreshState();},_computeRegexp:function(_b57){var p=this.pattern;if(typeof p=="function"){p=p.call(this,_b57);}if(p!=this._lastRegExp){var _b58="";this._lastRegExp=p;if(p!=".*"){p.replace(/\\.|\[\]|\[.*?[^\\]{1}\]|\{.*?\}|\(\?[=:!]|./g,function(re){switch(re.charAt(0)){case "{":case "+":case "?":case "*":case "^":case "$":case "|":case "(":_b58+=re;break;case ")":_b58+="|$)";break;default:_b58+="(?:"+re+"|$)";break;}});}try{"".search(_b58);}catch(e){_b58=this.pattern;console.warn("RegExp error in "+this.declaredClass+": "+this.pattern);}this._partialre="^(?:"+_b58+")$";}return p;},postMixInProperties:function(){this.inherited(arguments);this.messages=i18n.getLocalization("dijit.form","validate",this.lang);this._setConstraintsAttr(this.constraints);},_setDisabledAttr:function(_b59){this.inherited(arguments);this._refreshState();},_setRequiredAttr:function(_b5a){this._set("required",_b5a);this.focusNode.setAttribute("aria-required",_b5a);this._refreshState();},_setMessageAttr:function(_b5b){this._set("message",_b5b);this.displayMessage(_b5b);},reset:function(){this._maskValidSubsetError=true;this.inherited(arguments);},_onBlur:function(){this.displayMessage("");this.inherited(arguments);},destroy:function(){_b43.hide(this.domNode);this.inherited(arguments);}});return _b45;});},"dijit/form/TextBox":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","./_FormValueWidget","./_TextBoxMixin","dojo/text!./templates/TextBox.html","../main"],function(_b5c,_b5d,_b5e,_b5f,lang,on,has,_b60,_b61,_b62,_b63){var _b64=_b5c("dijit.form.TextBox"+(has("dojo-bidi")?"_NoBidi":""),[_b60,_b61],{templateString:_b62,_singleNodeTemplate:"<input class=\"dijit dijitReset dijitLeft dijitInputField\" data-dojo-attach-point=\"textbox,focusNode\" autocomplete=\"off\" type=\"${type}\" ${!nameAttrSetting} />",_buttonInputDisabled:has("ie")?"disabled":"",baseClass:"dijitTextBox",postMixInProperties:function(){var type=this.type.toLowerCase();if(this.templateString&&this.templateString.toLowerCase()=="input"||((type=="hidden"||type=="file")&&this.templateString==this.constructor.prototype.templateString)){this.templateString=this._singleNodeTemplate;}this.inherited(arguments);},postCreate:function(){this.inherited(arguments);if(has("ie")<9){this.defer(function(){try{var s=_b5e.getComputedStyle(this.domNode);if(s){var ff=s.fontFamily;if(ff){var _b65=this.domNode.getElementsByTagName("INPUT");if(_b65){for(var i=0;i<_b65.length;i++){_b65[i].style.fontFamily=ff;}}}}}catch(e){}});}},_setPlaceHolderAttr:function(v){this._set("placeHolder",v);if(!this._phspan){this._attachPoints.push("_phspan");this._phspan=_b5d.create("span",{className:"dijitPlaceHolder dijitInputField"},this.textbox,"after");this.own(on(this._phspan,"mousedown",function(evt){evt.preventDefault();}),on(this._phspan,"touchend, pointerup, MSPointerUp",lang.hitch(this,function(){this.focus();})));}this._phspan.innerHTML="";this._phspan.appendChild(this._phspan.ownerDocument.createTextNode(v));this._updatePlaceHolder();},_onInput:function(evt){this.inherited(arguments);this._updatePlaceHolder();},_updatePlaceHolder:function(){if(this._phspan){this._phspan.style.display=(this.placeHolder&&!this.textbox.value)?"":"none";}},_setValueAttr:function(_b66,_b67,_b68){this.inherited(arguments);this._updatePlaceHolder();},getDisplayedValue:function(){_b5f.deprecated(this.declaredClass+"::getDisplayedValue() is deprecated. Use get('displayedValue') instead.","","2.0");return this.get("displayedValue");},setDisplayedValue:function(_b69){_b5f.deprecated(this.declaredClass+"::setDisplayedValue() is deprecated. Use set('displayedValue', ...) instead.","","2.0");this.set("displayedValue",_b69);},_onBlur:function(e){if(this.disabled){return;}this.inherited(arguments);this._updatePlaceHolder();if(has("mozilla")){if(this.selectOnClick){this.textbox.selectionStart=this.textbox.selectionEnd=undefined;}}},_onFocus:function(by){if(this.disabled||this.readOnly){return;}this.inherited(arguments);this._updatePlaceHolder();}});if(has("ie")<9){_b64.prototype._isTextSelected=function(){var _b6a=this.ownerDocument.selection.createRange();var _b6b=_b6a.parentElement();return _b6b==this.textbox&&_b6a.text.length>0;};_b63._setSelectionRange=_b61._setSelectionRange=function(_b6c,_b6d,stop){if(_b6c.createTextRange){var r=_b6c.createTextRange();r.collapse(true);r.moveStart("character",-99999);r.moveStart("character",_b6d);r.moveEnd("character",stop-_b6d);r.select();}};}if(has("dojo-bidi")){_b64=_b5c("dijit.form.TextBox",_b64,{_setPlaceHolderAttr:function(v){this.inherited(arguments);this.applyTextDir(this._phspan);}});}return _b64;});},"dijit/form/_FormValueWidget":function(){define(["dojo/_base/declare","dojo/sniff","./_FormWidget","./_FormValueMixin"],function(_b6e,has,_b6f,_b70){return _b6e("dijit.form._FormValueWidget",[_b6f,_b70],{_layoutHackIE7:function(){if(has("ie")==7){var _b71=this.domNode;var _b72=_b71.parentNode;var _b73=_b71.firstChild||_b71;var _b74=_b73.style.filter;var _b75=this;while(_b72&&_b72.clientHeight==0){(function ping(){var _b76=_b75.connect(_b72,"onscroll",function(){_b75.disconnect(_b76);_b73.style.filter=(new Date()).getMilliseconds();_b75.defer(function(){_b73.style.filter=_b74;});});})();_b72=_b72.parentNode;}}}});});},"dijit/form/_FormWidget":function(){define(["dojo/_base/declare","dojo/sniff","dojo/_base/kernel","dojo/ready","../_Widget","../_CssStateMixin","../_TemplatedMixin","./_FormWidgetMixin"],function(_b77,has,_b78,_b79,_b7a,_b7b,_b7c,_b7d){if(has("dijit-legacy-requires")){_b79(0,function(){var _b7e=["dijit/form/_FormValueWidget"];require(_b7e);});}return _b77("dijit.form._FormWidget",[_b7a,_b7c,_b7b,_b7d],{setDisabled:function(_b7f){_b78.deprecated("setDisabled("+_b7f+") is deprecated. Use set('disabled',"+_b7f+") instead.","","2.0");this.set("disabled",_b7f);},setValue:function(_b80){_b78.deprecated("dijit.form._FormWidget:setValue("+_b80+") is deprecated.  Use set('value',"+_b80+") instead.","","2.0");this.set("value",_b80);},getValue:function(){_b78.deprecated(this.declaredClass+"::getValue() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},postMixInProperties:function(){this.nameAttrSetting=(this.name&&!has("msapp"))?("name=\""+this.name.replace(/"/g,"&quot;")+"\""):"";this.inherited(arguments);}});});},"dijit/form/_FormWidgetMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","dojo/window","../a11y"],function(_b81,_b82,_b83,_b84,lang,_b85,on,has,_b86,a11y){return _b82("dijit.form._FormWidgetMixin",null,{name:"",alt:"",value:"",type:"text","aria-label":"focusNode",tabIndex:"0",_setTabIndexAttr:"focusNode",disabled:false,intermediateChanges:false,scrollOnFocus:true,_setIdAttr:"focusNode",_setDisabledAttr:function(_b87){this._set("disabled",_b87);if(/^(button|input|select|textarea|optgroup|option|fieldset)$/i.test(this.focusNode.tagName)){_b83.set(this.focusNode,"disabled",_b87);if(has("trident")&&"readOnly" in this){_b83.set(this.focusNode,"readonly",_b87||this.readOnly);}}else{this.focusNode.setAttribute("aria-disabled",_b87?"true":"false");}if(this.valueNode){_b83.set(this.valueNode,"disabled",_b87);}if(_b87){this._set("hovering",false);this._set("active",false);var _b88="tabIndex" in this.attributeMap?this.attributeMap.tabIndex:("_setTabIndexAttr" in this)?this._setTabIndexAttr:"focusNode";_b81.forEach(lang.isArray(_b88)?_b88:[_b88],function(_b89){var node=this[_b89];if(has("webkit")||a11y.hasDefaultTabStop(node)){node.setAttribute("tabIndex","-1");}else{node.removeAttribute("tabIndex");}},this);}else{if(this.tabIndex!=""){this.set("tabIndex",this.tabIndex);}}},_onFocus:function(by){if(by=="mouse"&&this.isFocusable()){var _b8a=this.own(on(this.focusNode,"focus",function(){_b8b.remove();_b8a.remove();}))[0];var _b8c=has("pointer-events")?"pointerup":has("MSPointer")?"MSPointerUp":has("touch-events")?"touchend, mouseup":"mouseup";var _b8b=this.own(on(this.ownerDocumentBody,_b8c,lang.hitch(this,function(evt){_b8b.remove();_b8a.remove();if(this.focused){if(evt.type=="touchend"){this.defer("focus");}else{this.focus();}}})))[0];}if(this.scrollOnFocus){this.defer(function(){_b86.scrollIntoView(this.domNode);});}this.inherited(arguments);},isFocusable:function(){return !this.disabled&&this.focusNode&&(_b84.get(this.domNode,"display")!="none");},focus:function(){if(!this.disabled&&this.focusNode.focus){try{this.focusNode.focus();}catch(e){}}},compare:function(val1,val2){if(typeof val1=="number"&&typeof val2=="number"){return (isNaN(val1)&&isNaN(val2))?0:val1-val2;}else{if(val1>val2){return 1;}else{if(val1<val2){return -1;}else{return 0;}}}},onChange:function(){},_onChangeActive:false,_handleOnChange:function(_b8d,_b8e){if(this._lastValueReported==undefined&&(_b8e===null||!this._onChangeActive)){this._resetValue=this._lastValueReported=_b8d;}this._pendingOnChange=this._pendingOnChange||(typeof _b8d!=typeof this._lastValueReported)||(this.compare(_b8d,this._lastValueReported)!=0);if((this.intermediateChanges||_b8e||_b8e===undefined)&&this._pendingOnChange){this._lastValueReported=_b8d;this._pendingOnChange=false;if(this._onChangeActive){if(this._onChangeHandle){this._onChangeHandle.remove();}this._onChangeHandle=this.defer(function(){this._onChangeHandle=null;this.onChange(_b8d);});}}},create:function(){this.inherited(arguments);this._onChangeActive=true;},destroy:function(){if(this._onChangeHandle){this._onChangeHandle.remove();this.onChange(this._lastValueReported);}this.inherited(arguments);}});});},"dijit/form/_FormValueMixin":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","./_FormWidgetMixin"],function(_b8f,_b90,keys,lang,on,has,_b91){return _b8f("dijit.form._FormValueMixin",_b91,{readOnly:false,_setReadOnlyAttr:function(_b92){if(has("trident")&&"disabled" in this){_b90.set(this.focusNode,"readOnly",_b92||this.disabled);}else{_b90.set(this.focusNode,"readOnly",_b92);}this._set("readOnly",_b92);},postCreate:function(){this.inherited(arguments);if(this._resetValue===undefined){this._lastValueReported=this._resetValue=this.value;}},_setValueAttr:function(_b93,_b94){this._handleOnChange(_b93,_b94);},_handleOnChange:function(_b95,_b96){this._set("value",_b95);this.inherited(arguments);},undo:function(){this._setValueAttr(this._lastValueReported,false);},reset:function(){this._hasBeenBlurred=false;this._setValueAttr(this._resetValue,true);}});});},"dijit/form/_TextBoxMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/sniff","dojo/keys","dojo/_base/lang","dojo/on","../main"],function(_b97,_b98,dom,has,keys,lang,on,_b99){var _b9a=_b98("dijit.form._TextBoxMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{trim:false,uppercase:false,lowercase:false,propercase:false,maxLength:"",selectOnClick:false,placeHolder:"",_getValueAttr:function(){return this.parse(this.get("displayedValue"),this.constraints);},_setValueAttr:function(_b9b,_b9c,_b9d){var _b9e;if(_b9b!==undefined){_b9e=this.filter(_b9b);if(typeof _b9d!="string"){if(_b9e!==null&&((typeof _b9e!="number")||!isNaN(_b9e))){_b9d=this.filter(this.format(_b9e,this.constraints));}else{_b9d="";}if(this.compare(_b9e,this.filter(this.parse(_b9d,this.constraints)))!=0){_b9d=null;}}}if(_b9d!=null&&((typeof _b9d)!="number"||!isNaN(_b9d))&&this.textbox.value!=_b9d){this.textbox.value=_b9d;this._set("displayedValue",this.get("displayedValue"));}this.inherited(arguments,[_b9e,_b9c]);},displayedValue:"",_getDisplayedValueAttr:function(){return this.filter(this.textbox.value);},_setDisplayedValueAttr:function(_b9f){if(_b9f==null){_b9f="";}else{if(typeof _b9f!="string"){_b9f=String(_b9f);}}this.textbox.value=_b9f;this._setValueAttr(this.get("value"),undefined);this._set("displayedValue",this.get("displayedValue"));},format:function(_ba0){return _ba0==null?"":(_ba0.toString?_ba0.toString():_ba0);},parse:function(_ba1){return _ba1;},_refreshState:function(){},onInput:function(){},_onInput:function(evt){this._lastInputEventValue=this.textbox.value;this._processInput(this._lastInputProducingEvent||evt);delete this._lastInputProducingEvent;if(this.intermediateChanges){this._handleOnChange(this.get("value"),false);}},_processInput:function(){this._refreshState();this._set("displayedValue",this.get("displayedValue"));},postCreate:function(){this.textbox.setAttribute("value",this.textbox.value);this.inherited(arguments);function _ba2(e){var _ba3;if(e.type=="keydown"&&e.keyCode!=229){_ba3=e.keyCode;switch(_ba3){case keys.SHIFT:case keys.ALT:case keys.CTRL:case keys.META:case keys.CAPS_LOCK:case keys.NUM_LOCK:case keys.SCROLL_LOCK:return;}if(!e.ctrlKey&&!e.metaKey&&!e.altKey){switch(_ba3){case keys.NUMPAD_0:case keys.NUMPAD_1:case keys.NUMPAD_2:case keys.NUMPAD_3:case keys.NUMPAD_4:case keys.NUMPAD_5:case keys.NUMPAD_6:case keys.NUMPAD_7:case keys.NUMPAD_8:case keys.NUMPAD_9:case keys.NUMPAD_MULTIPLY:case keys.NUMPAD_PLUS:case keys.NUMPAD_ENTER:case keys.NUMPAD_MINUS:case keys.NUMPAD_PERIOD:case keys.NUMPAD_DIVIDE:return;}if((_ba3>=65&&_ba3<=90)||(_ba3>=48&&_ba3<=57)||_ba3==keys.SPACE){return;}var _ba4=false;for(var i in keys){if(keys[i]===e.keyCode){_ba4=true;break;}}if(!_ba4){return;}}}_ba3=e.charCode>=32?String.fromCharCode(e.charCode):e.charCode;if(!_ba3){_ba3=(e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=48&&e.keyCode<=57)||e.keyCode==keys.SPACE?String.fromCharCode(e.keyCode):e.keyCode;}if(!_ba3){_ba3=229;}if(e.type=="keypress"){if(typeof _ba3!="string"){return;}if((_ba3>="a"&&_ba3<="z")||(_ba3>="A"&&_ba3<="Z")||(_ba3>="0"&&_ba3<="9")||(_ba3===" ")){if(e.ctrlKey||e.metaKey||e.altKey){return;}}}var faux={faux:true},attr;for(attr in e){if(!/^(layer[XY]|returnValue|keyLocation)$/.test(attr)){var v=e[attr];if(typeof v!="function"&&typeof v!="undefined"){faux[attr]=v;}}}lang.mixin(faux,{charOrCode:_ba3,_wasConsumed:false,preventDefault:function(){faux._wasConsumed=true;e.preventDefault();},stopPropagation:function(){e.stopPropagation();}});this._lastInputProducingEvent=faux;if(this.onInput(faux)===false){faux.preventDefault();faux.stopPropagation();}if(faux._wasConsumed){return;}if(has("ie")<=9){switch(e.keyCode){case keys.TAB:case keys.ESCAPE:case keys.DOWN_ARROW:case keys.UP_ARROW:case keys.LEFT_ARROW:case keys.RIGHT_ARROW:break;default:if(e.keyCode==keys.ENTER&&this.textbox.tagName.toLowerCase()!="textarea"){break;}this.defer(function(){if(this.textbox.value!==this._lastInputEventValue){on.emit(this.textbox,"input",{bubbles:true});}});}}};this.own(on(this.textbox,"keydown, keypress, paste, cut, compositionend",lang.hitch(this,_ba2)),on(this.textbox,"input",lang.hitch(this,"_onInput")),on(this.domNode,"keypress",function(e){e.stopPropagation();}));},_blankValue:"",filter:function(val){if(val===null){return this._blankValue;}if(typeof val!="string"){return val;}if(this.trim){val=lang.trim(val);}if(this.uppercase){val=val.toUpperCase();}if(this.lowercase){val=val.toLowerCase();}if(this.propercase){val=val.replace(/[^\s]+/g,function(word){return word.substring(0,1).toUpperCase()+word.substring(1);});}return val;},_setBlurValue:function(){this._setValueAttr(this.get("value"),true);},_onBlur:function(e){if(this.disabled){return;}this._setBlurValue();this.inherited(arguments);},_isTextSelected:function(){return this.textbox.selectionStart!=this.textbox.selectionEnd;},_onFocus:function(by){if(this.disabled||this.readOnly){return;}if(this.selectOnClick&&by=="mouse"){this._selectOnClickHandle=on.once(this.domNode,"mouseup, touchend",lang.hitch(this,function(evt){if(!this._isTextSelected()){_b9a.selectInputText(this.textbox);}}));this.own(this._selectOnClickHandle);this.defer(function(){if(this._selectOnClickHandle){this._selectOnClickHandle.remove();this._selectOnClickHandle=null;}},500);}this.inherited(arguments);this._refreshState();},reset:function(){this.textbox.value="";this.inherited(arguments);}});if(has("dojo-bidi")){_b9a=_b98("dijit.form._TextBoxMixin",_b9a,{_setValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.focusNode);},_setDisplayedValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.focusNode);},_onInput:function(){this.applyTextDir(this.focusNode);this.inherited(arguments);}});}_b9a._setSelectionRange=_b99._setSelectionRange=function(_ba5,_ba6,stop){if(_ba5.setSelectionRange){_ba5.setSelectionRange(_ba6,stop);}};_b9a.selectInputText=_b99.selectInputText=function(_ba7,_ba8,stop){_ba7=dom.byId(_ba7);if(isNaN(_ba8)){_ba8=0;}if(isNaN(stop)){stop=_ba7.value?_ba7.value.length:0;}try{_ba7.focus();_b9a._setSelectionRange(_ba7,_ba8,stop);}catch(e){}};return _b9a;});},"dijit/Tooltip":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_ba9,_baa,fx,dom,_bab,_bac,_bad,lang,_bae,on,has,_baf,_bb0,_bb1,_bb2,_bb3,_bb4,_bb5){var _bb6=_baa("dijit._MasterTooltip",[_bb1,_bb2],{duration:_baf.defaultDuration,templateString:_bb4,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _bb3(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_bb7,_bb8,_bb9,rtl,_bba,_bbb,_bbc){if(this.aroundNode&&this.aroundNode===_bb8&&this.containerNode.innerHTML==_bb7){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_bb7;if(_bba){this.set("textDir",_bba);}this.containerNode.align=rtl?"right":"left";var pos=_bb0.around(this.domNode,_bb8,_bb9&&_bb9.length?_bb9:_bbd.defaultPosition,!rtl,lang.hitch(this,"orient"));var _bbe=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_bbe.y+((_bbe.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_bbe.x+((_bbe.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_bad.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_bb8;this.onMouseEnter=_bbb||noop;this.onMouseLeave=_bbc||noop;},orient:function(node,_bbf,_bc0,_bc1,_bc2){this.connectorNode.style.top="";var _bc3=_bc1.h,_bc4=_bc1.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_bbf+"-"+_bc0];this.domNode.style.width="auto";var size=_bac.position(this.domNode);if(has("ie")||has("trident")){size.w+=2;}var _bc5=Math.min((Math.max(_bc4,1)),size.w);_bac.setMarginBox(this.domNode,{w:_bc5});if(_bc0.charAt(0)=="B"&&_bbf.charAt(0)=="B"){var bb=_bac.position(node);var _bc6=this.connectorNode.offsetHeight;if(bb.h>_bc3){var _bc7=_bc3-((_bc2.h+_bc6)>>1);this.connectorNode.style.top=_bc7+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_bc2.h/2-_bc6/2,0),bb.h-_bc6)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_bc4);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_bc8){if(this._onDeck&&this._onDeck[1]==_bc8){this._onDeck=null;}else{if(this.aroundNode===_bc8){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}this.onMouseEnter=this.onMouseLeave=noop;},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});if(has("dojo-bidi")){_bb6.extend({_setAutoTextDir:function(node){this.applyTextDir(node);_ba9.forEach(node.children,function(_bc9){this._setAutoTextDir(_bc9);},this);},_setTextDirAttr:function(_bca){this._set("textDir",_bca);if(_bca=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});}_bb5.showTooltip=function(_bcb,_bcc,_bcd,rtl,_bce,_bcf,_bd0){if(_bcd){_bcd=_ba9.map(_bcd,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_bbd._masterTT){_bb5._masterTT=_bbd._masterTT=new _bb6();}return _bbd._masterTT.show(_bcb,_bcc,_bcd,rtl,_bce,_bcf,_bd0);};_bb5.hideTooltip=function(_bd1){return _bbd._masterTT&&_bbd._masterTT.hide(_bd1);};var _bd2="DORMANT",_bd3="SHOW TIMER",_bd4="SHOWING",_bd5="HIDE TIMER";function noop(){};var _bbd=_baa("dijit.Tooltip",_bb1,{label:"",showDelay:400,hideDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_bd6){_ba9.forEach(this._connections||[],function(_bd7){_ba9.forEach(_bd7,function(_bd8){_bd8.remove();});},this);this._connectIds=_ba9.filter(lang.isArrayLike(_bd6)?_bd6:(_bd6?[_bd6]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_ba9.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_bd9=this.selector,_bda=_bd9?function(_bdb){return on.selector(_bd9,_bdb);}:function(_bdc){return _bdc;},self=this;return [on(node,_bda(_bae.enter),function(){self._onHover(this);}),on(node,_bda("focusin"),function(){self._onHover(this);}),on(node,_bda(_bae.leave),lang.hitch(self,"_onUnHover")),on(node,_bda("focusout"),lang.hitch(self,"set","state",_bd2))];},this);this._set("connectId",_bd6);},addTarget:function(node){var id=node.id||node;if(_ba9.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_ba9.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_bab.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_ba9.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},state:_bd2,_setStateAttr:function(val){if(this.state==val||(val==_bd3&&this.state==_bd4)||(val==_bd5&&this.state==_bd2)){return;}if(this._hideTimer){this._hideTimer.remove();delete this._hideTimer;}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}switch(val){case _bd2:if(this._connectNode){_bbd.hide(this._connectNode);delete this._connectNode;this.onHide();}break;case _bd3:if(this.state!=_bd4){this._showTimer=this.defer(function(){this.set("state",_bd4);},this.showDelay);}break;case _bd4:var _bdd=this.getContent(this._connectNode);if(!_bdd){this.set("state",_bd2);return;}_bbd.show(_bdd,this._connectNode,this.position,!this.isLeftToRight(),this.textDir,lang.hitch(this,"set","state",_bd4),lang.hitch(this,"set","state",_bd5));this.onShow(this._connectNode,this.position);break;case _bd5:this._hideTimer=this.defer(function(){this.set("state",_bd2);},this.hideDelay);break;}this._set("state",val);},_onHover:function(_bde){if(this._connectNode&&_bde!=this._connectNode){this.set("state",_bd2);}this._connectNode=_bde;this.set("state",_bd3);},_onUnHover:function(_bdf){this.set("state",_bd5);},open:function(_be0){this.set("state",_bd2);this._connectNode=_be0;this.set("state",_bd4);},close:function(){this.set("state",_bd2);},onShow:function(){},onHide:function(){},destroy:function(){this.set("state",_bd2);_ba9.forEach(this._connections||[],function(_be1){_ba9.forEach(_be1,function(_be2){_be2.remove();});},this);this.inherited(arguments);}});_bbd._MasterTooltip=_bb6;_bbd.show=_bb5.showTooltip;_bbd.hide=_bb5.hideTooltip;_bbd.defaultPosition=["after-centered","before-centered"];return _bbd;});},"dijit/place":function(){define(["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","./Viewport","./main"],function(_be3,_be4,_be5,_be6,win,_be7,_be8){function _be9(node,_bea,_beb,_bec){var view=_be7.getEffectiveBox(node.ownerDocument);if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){win.body(node.ownerDocument).appendChild(node);}var best=null;_be3.some(_bea,function(_bed){var _bee=_bed.corner;var pos=_bed.pos;var _bef=0;var _bf0={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_bee.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_bee.charAt(0)]};var s=node.style;s.left=s.right="auto";if(_beb){var res=_beb(node,_bed.aroundCorner,_bee,_bf0,_bec);_bef=typeof res=="undefined"?0:res;}var _bf1=node.style;var _bf2=_bf1.display;var _bf3=_bf1.visibility;if(_bf1.display=="none"){_bf1.visibility="hidden";_bf1.display="";}var bb=_be4.position(node);_bf1.display=_bf2;_bf1.visibility=_bf3;var _bf4={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(bb.w>>1))-bb.w)}[_bee.charAt(1)],_bf5={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(bb.h>>1))-bb.h)}[_bee.charAt(0)],_bf6=Math.max(view.l,_bf4),_bf7=Math.max(view.t,_bf5),endX=Math.min(view.l+view.w,_bf4+bb.w),endY=Math.min(view.t+view.h,_bf5+bb.h),_bf8=endX-_bf6,_bf9=endY-_bf7;_bef+=(bb.w-_bf8)+(bb.h-_bf9);if(best==null||_bef<best.overflow){best={corner:_bee,aroundCorner:_bed.aroundCorner,x:_bf6,y:_bf7,w:_bf8,h:_bf9,overflow:_bef,spaceAvailable:_bf0};}return !_bef;});if(best.overflow&&_beb){_beb(node,best.aroundCorner,best.corner,best.spaceAvailable,_bec);}var top=best.y,side=best.x,body=win.body(node.ownerDocument);if(/relative|absolute/.test(_be5.get(body,"position"))){top-=_be5.get(body,"marginTop");side-=_be5.get(body,"marginLeft");}var s=node.style;s.top=top+"px";s.left=side+"px";s.right="auto";return best;};var _bfa={"TL":"BR","TR":"BL","BL":"TR","BR":"TL"};var _bfb={at:function(node,pos,_bfc,_bfd,_bfe){var _bff=_be3.map(_bfc,function(_c00){var c={corner:_c00,aroundCorner:_bfa[_c00],pos:{x:pos.x,y:pos.y}};if(_bfd){c.pos.x+=_c00.charAt(1)=="L"?_bfd.x:-_bfd.x;c.pos.y+=_c00.charAt(0)=="T"?_bfd.y:-_bfd.y;}return c;});return _be9(node,_bff,_bfe);},around:function(node,_c01,_c02,_c03,_c04){var _c05;if(typeof _c01=="string"||"offsetWidth" in _c01||"ownerSVGElement" in _c01){_c05=_be4.position(_c01,true);if(/^(above|below)/.test(_c02[0])){var _c06=_be4.getBorderExtents(_c01),_c07=_c01.firstChild?_be4.getBorderExtents(_c01.firstChild):{t:0,l:0,b:0,r:0},_c08=_be4.getBorderExtents(node),_c09=node.firstChild?_be4.getBorderExtents(node.firstChild):{t:0,l:0,b:0,r:0};_c05.y+=Math.min(_c06.t+_c07.t,_c08.t+_c09.t);_c05.h-=Math.min(_c06.t+_c07.t,_c08.t+_c09.t)+Math.min(_c06.b+_c07.b,_c08.b+_c09.b);}}else{_c05=_c01;}if(_c01.parentNode){var _c0a=_be5.getComputedStyle(_c01).position=="absolute";var _c0b=_c01.parentNode;while(_c0b&&_c0b.nodeType==1&&_c0b.nodeName!="BODY"){var _c0c=_be4.position(_c0b,true),pcs=_be5.getComputedStyle(_c0b);if(/relative|absolute/.test(pcs.position)){_c0a=false;}if(!_c0a&&/hidden|auto|scroll/.test(pcs.overflow)){var _c0d=Math.min(_c05.y+_c05.h,_c0c.y+_c0c.h);var _c0e=Math.min(_c05.x+_c05.w,_c0c.x+_c0c.w);_c05.x=Math.max(_c05.x,_c0c.x);_c05.y=Math.max(_c05.y,_c0c.y);_c05.h=_c0d-_c05.y;_c05.w=_c0e-_c05.x;}if(pcs.position=="absolute"){_c0a=true;}_c0b=_c0b.parentNode;}}var x=_c05.x,y=_c05.y,_c0f="w" in _c05?_c05.w:(_c05.w=_c05.width),_c10="h" in _c05?_c05.h:(_be6.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_c05.height+", width:"+_c0f+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_c05.height+", w:"+_c0f+" }","","2.0"),_c05.h=_c05.height);var _c11=[];function push(_c12,_c13){_c11.push({aroundCorner:_c12,corner:_c13,pos:{x:{"L":x,"R":x+_c0f,"M":x+(_c0f>>1)}[_c12.charAt(1)],y:{"T":y,"B":y+_c10,"M":y+(_c10>>1)}[_c12.charAt(0)]}});};_be3.forEach(_c02,function(pos){var ltr=_c03;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after-centered":ltr=!ltr;case "before-centered":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "after":ltr=!ltr;case "before":push(ltr?"TL":"TR",ltr?"TR":"TL");push(ltr?"BL":"BR",ltr?"BR":"BL");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _c14=_be9(node,_c11,_c04,{w:_c0f,h:_c10});_c14.aroundNodePos=_c05;return _c14;}};return _be8.place=_bfb;});},"dijit/form/ComboBoxMixin":function(){define(["dojo/_base/declare","dojo/Deferred","dojo/_base/kernel","dojo/_base/lang","dojo/store/util/QueryResults","./_AutoCompleterMixin","./_ComboBoxMenu","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(_c15,_c16,_c17,lang,_c18,_c19,_c1a,_c1b,_c1c){return _c15("dijit.form.ComboBoxMixin",[_c1b,_c19],{dropDownClass:_c1a,hasDownArrow:true,templateString:_c1c,baseClass:"dijitTextBox dijitComboBox",cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},_setHasDownArrowAttr:function(val){this._set("hasDownArrow",val);this._buttonNode.style.display=val?"":"none";},_showResultList:function(){this.displayMessage("");this.inherited(arguments);},_setStoreAttr:function(_c1d){if(!_c1d.get){lang.mixin(_c1d,{_oldAPI:true,get:function(id){var _c1e=new _c16();this.fetchItemByIdentity({identity:id,onItem:function(_c1f){_c1e.resolve(_c1f);},onError:function(_c20){_c1e.reject(_c20);}});return _c1e.promise;},query:function(_c21,_c22){var _c23=new _c16(function(){_c24.abort&&_c24.abort();});_c23.total=new _c16();var _c24=this.fetch(lang.mixin({query:_c21,onBegin:function(_c25){_c23.total.resolve(_c25);},onComplete:function(_c26){_c23.resolve(_c26);},onError:function(_c27){_c23.reject(_c27);}},_c22));return _c18(_c23);}});}this._set("store",_c1d);},postMixInProperties:function(){var _c28=this.params.store||this.store;if(_c28){this._setStoreAttr(_c28);}this.inherited(arguments);if(!this.params.store&&this.store&&!this.store._oldAPI){var _c29=this.declaredClass;lang.mixin(this.store,{getValue:function(item,attr){_c17.deprecated(_c29+".store.getValue(item, attr) is deprecated for builtin store.  Use item.attr directly","","2.0");return item[attr];},getLabel:function(item){_c17.deprecated(_c29+".store.getLabel(item) is deprecated for builtin store.  Use item.label directly","","2.0");return item.name;},fetch:function(args){_c17.deprecated(_c29+".store.fetch() is deprecated for builtin store.","Use store.query()","2.0");var shim=["dojo/data/ObjectStore"];require(shim,lang.hitch(this,function(_c2a){new _c2a({objectStore:this}).fetch(args);}));}});}},buildRendering:function(){this.inherited(arguments);this.focusNode.setAttribute("aria-autocomplete",this.autoComplete?"both":"list");}});});},"dojo/store/util/QueryResults":function(){define(["../../_base/array","../../_base/lang","../../when"],function(_c2b,lang,when){var _c2c=function(_c2d){if(!_c2d){return _c2d;}var _c2e=!!_c2d.then;if(_c2e){_c2d=lang.delegate(_c2d);}function _c2f(_c30){_c2d[_c30]=function(){var args=arguments;var _c31=when(_c2d,function(_c32){Array.prototype.unshift.call(args,_c32);return _c2c(_c2b[_c30].apply(_c2b,args));});if(_c30!=="forEach"||_c2e){return _c31;}};};_c2f("forEach");_c2f("filter");_c2f("map");if(_c2d.total==null){_c2d.total=when(_c2d,function(_c33){return _c33.length;});}return _c2d;};lang.setObject("dojo.store.util.QueryResults",_c2c);return _c2c;});},"dijit/form/_AutoCompleterMixin":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/query","dojo/regexp","dojo/sniff","./DataList","./_TextBoxMixin","./_SearchMixin"],function(_c34,_c35,_c36,keys,lang,_c37,_c38,has,_c39,_c3a,_c3b){var _c3c=_c35("dijit.form._AutoCompleterMixin",_c3b,{item:null,autoComplete:true,highlightMatch:"first",labelAttr:"",labelType:"text",maxHeight:-1,_stopClickEvents:false,_getCaretPos:function(_c3d){var pos=0;if(typeof (_c3d.selectionStart)=="number"){pos=_c3d.selectionStart;}else{if(has("ie")){var tr=_c3d.ownerDocument.selection.createRange().duplicate();var ntr=_c3d.createTextRange();tr.move("character",0);ntr.move("character",0);try{ntr.setEndPoint("EndToEnd",tr);pos=String(ntr.text).replace(/\r/g,"").length;}catch(e){}}}return pos;},_setCaretPos:function(_c3e,_c3f){_c3f=parseInt(_c3f);_c3a.selectInputText(_c3e,_c3f,_c3f);},_setDisabledAttr:function(_c40){this.inherited(arguments);this.domNode.setAttribute("aria-disabled",_c40?"true":"false");},_onKey:function(evt){if(evt.charCode>=32){return;}var key=evt.charCode||evt.keyCode;if(key==keys.ALT||key==keys.CTRL||key==keys.META||key==keys.SHIFT){return;}var pw=this.dropDown;var _c41=null;this._abortQuery();this.inherited(arguments);if(evt.altKey||evt.ctrlKey||evt.metaKey){return;}if(this._opened){_c41=pw.getHighlightedOption();}switch(key){case keys.PAGE_DOWN:case keys.DOWN_ARROW:case keys.PAGE_UP:case keys.UP_ARROW:if(this._opened){this._announceOption(_c41);}evt.stopPropagation();evt.preventDefault();break;case keys.ENTER:if(_c41){if(_c41==pw.nextButton){this._nextSearch(1);evt.stopPropagation();evt.preventDefault();break;}else{if(_c41==pw.previousButton){this._nextSearch(-1);evt.stopPropagation();evt.preventDefault();break;}}evt.stopPropagation();evt.preventDefault();}else{this._setBlurValue();this._setCaretPos(this.focusNode,this.focusNode.value.length);}case keys.TAB:var _c42=this.get("displayedValue");if(pw&&(_c42==pw._messages["previousMessage"]||_c42==pw._messages["nextMessage"])){break;}if(_c41){this._selectOption(_c41);}case keys.ESCAPE:if(this._opened){this._lastQuery=null;this.closeDropDown();}break;}},_autoCompleteText:function(text){var fn=this.focusNode;_c3a.selectInputText(fn,fn.value.length);var _c43=this.ignoreCase?"toLowerCase":"substr";if(text[_c43](0).indexOf(this.focusNode.value[_c43](0))==0){var cpos=this.autoComplete?this._getCaretPos(fn):fn.value.length;if((cpos+1)>fn.value.length){fn.value=text;_c3a.selectInputText(fn,cpos);}}else{fn.value=text;_c3a.selectInputText(fn);}},_openResultList:function(_c44,_c45,_c46){var _c47=this.dropDown.getHighlightedOption();this.dropDown.clearResultList();if(!_c44.length&&_c46.start==0){this.closeDropDown();return;}this._nextSearch=this.dropDown.onPage=lang.hitch(this,function(_c48){_c44.nextPage(_c48!==-1);this.focus();});this.dropDown.createOptions(_c44,_c46,lang.hitch(this,"_getMenuLabelFromItem"));this._showResultList();if("direction" in _c46){if(_c46.direction){this.dropDown.highlightFirstOption();}else{if(!_c46.direction){this.dropDown.highlightLastOption();}}if(_c47){this._announceOption(this.dropDown.getHighlightedOption());}}else{if(this.autoComplete&&!this._prev_key_backspace&&!/^[*]+$/.test(_c45[this.searchAttr].toString())){this._announceOption(this.dropDown.containerNode.firstChild.nextSibling);}}},_showResultList:function(){this.closeDropDown(true);this.openDropDown();this.domNode.setAttribute("aria-expanded","true");},loadDropDown:function(){this._startSearchAll();},isLoaded:function(){return false;},closeDropDown:function(){this._abortQuery();if(this._opened){this.inherited(arguments);this.domNode.setAttribute("aria-expanded","false");}},_setBlurValue:function(){var _c49=this.get("displayedValue");var pw=this.dropDown;if(pw&&(_c49==pw._messages["previousMessage"]||_c49==pw._messages["nextMessage"])){this._setValueAttr(this._lastValueReported,true);}else{if(typeof this.item=="undefined"){this.item=null;this.set("displayedValue",_c49);}else{if(this.value!=this._lastValueReported){this._handleOnChange(this.value,true);}this._refreshState();}}this.focusNode.removeAttribute("aria-activedescendant");},_setItemAttr:function(item,_c4a,_c4b){var _c4c="";if(item){if(!_c4b){_c4b=this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr];}_c4c=this._getValueField()!=this.searchAttr?this.store.getIdentity(item):_c4b;}this.set("value",_c4c,_c4a,_c4b,item);},_announceOption:function(node){if(!node){return;}var _c4d;if(node==this.dropDown.nextButton||node==this.dropDown.previousButton){_c4d=node.innerHTML;this.item=undefined;this.value="";}else{var item=this.dropDown.items[node.getAttribute("item")];_c4d=(this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr]).toString();this.set("item",item,false,_c4d);}this.focusNode.value=this.focusNode.value.substring(0,this._lastInput.length);this.focusNode.setAttribute("aria-activedescendant",_c36.get(node,"id"));this._autoCompleteText(_c4d);},_selectOption:function(_c4e){this.closeDropDown();if(_c4e){this._announceOption(_c4e);}this._setCaretPos(this.focusNode,this.focusNode.value.length);this._handleOnChange(this.value,true);this.focusNode.removeAttribute("aria-activedescendant");},_startSearchAll:function(){this._startSearch("");},_startSearchFromInput:function(){this.item=undefined;this.inherited(arguments);},_startSearch:function(key){if(!this.dropDown){var _c4f=this.id+"_popup",_c50=lang.isString(this.dropDownClass)?lang.getObject(this.dropDownClass,false):this.dropDownClass;this.dropDown=new _c50({onChange:lang.hitch(this,this._selectOption),id:_c4f,dir:this.dir,textDir:this.textDir});}this._lastInput=key;this.inherited(arguments);},_getValueField:function(){return this.searchAttr;},postMixInProperties:function(){this.inherited(arguments);if(!this.store&&this.srcNodeRef){var _c51=this.srcNodeRef;this.store=new _c39({},_c51);if(!("value" in this.params)){var item=(this.item=this.store.fetchSelectedItem());if(item){var _c52=this._getValueField();this.value=this.store._oldAPI?this.store.getValue(item,_c52):item[_c52];}}}},postCreate:function(){var _c53=_c37("label[for=\""+this.id+"\"]");if(_c53.length){if(!_c53[0].id){_c53[0].id=this.id+"_label";}this.domNode.setAttribute("aria-labelledby",_c53[0].id);}this.inherited(arguments);_c34.after(this,"onSearch",lang.hitch(this,"_openResultList"),true);},_getMenuLabelFromItem:function(item){var _c54=this.labelFunc(item,this.store),_c55=this.labelType;if(this.highlightMatch!="none"&&this.labelType=="text"&&this._lastInput){_c54=this.doHighlight(_c54,this._lastInput);_c55="html";}return {html:_c55=="html",label:_c54};},doHighlight:function(_c56,find){var _c57=(this.ignoreCase?"i":"")+(this.highlightMatch=="all"?"g":""),i=this.queryExpr.indexOf("${0}");find=_c38.escapeString(find);return this._escapeHtml(_c56.replace(new RegExp((i==0?"^":"")+"("+find+")"+(i==(this.queryExpr.length-4)?"$":""),_c57),"\uffff$1\uffff")).replace(/\uFFFF([^\uFFFF]+)\uFFFF/g,"<span class=\"dijitComboBoxHighlightMatch\">$1</span>");},_escapeHtml:function(str){str=String(str).replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");return str;},reset:function(){this.item=null;this.inherited(arguments);},labelFunc:function(item,_c58){return (_c58._oldAPI?_c58.getValue(item,this.labelAttr||this.searchAttr):item[this.labelAttr||this.searchAttr]).toString();},_setValueAttr:function(_c59,_c5a,_c5b,item){this._set("item",item||null);if(_c59==null){_c59="";}this.inherited(arguments);}});if(has("dojo-bidi")){_c3c.extend({_setTextDirAttr:function(_c5c){this.inherited(arguments);if(this.dropDown){this.dropDown._set("textDir",_c5c);}}});}return _c3c;});},"dijit/form/DataList":function(){define(["dojo/_base/declare","dojo/dom","dojo/_base/lang","dojo/query","dojo/store/Memory","../registry"],function(_c5d,dom,lang,_c5e,_c5f,_c60){function _c61(_c62){return {id:_c62.value,value:_c62.value,name:lang.trim(_c62.innerText||_c62.textContent||"")};};return _c5d("dijit.form.DataList",_c5f,{constructor:function(_c63,_c64){this.domNode=dom.byId(_c64);lang.mixin(this,_c63);if(this.id){_c60.add(this);}this.domNode.style.display="none";this.inherited(arguments,[{data:_c5e("option",this.domNode).map(_c61)}]);},destroy:function(){_c60.remove(this.id);},fetchSelectedItem:function(){var _c65=_c5e("> option[selected]",this.domNode)[0]||_c5e("> option",this.domNode)[0];return _c65&&_c61(_c65);}});});},"dojo/store/Memory":function(){define(["../_base/declare","./util/QueryResults","./util/SimpleQueryEngine"],function(_c66,_c67,_c68){var base=null;return _c66("dojo.store.Memory",base,{constructor:function(_c69){for(var i in _c69){this[i]=_c69[i];}this.setData(this.data||[]);},data:null,idProperty:"id",index:null,queryEngine:_c68,get:function(id){return this.data[this.index[id]];},getIdentity:function(_c6a){return _c6a[this.idProperty];},put:function(_c6b,_c6c){var data=this.data;var _c6d=this.index;var _c6e=this.idProperty;var id=_c6b[_c6e]=(_c6c&&"id" in _c6c)?_c6c.id:_c6e in _c6b?_c6b[_c6e]:Math.random();var _c6f=data.length;var _c70;var _c71;var _c72=id in _c6d?"update":"add";if(_c72==="update"){if(_c6c&&_c6c.overwrite===false){throw new Error("Object already exists");}else{_c71=_c6d[id];_c6f=_c71;}}if(_c6c&&"before" in _c6c){if(_c6c.before==null){_c70=data.length;if(_c72==="update"){--_c70;}}else{_c70=_c6d[this.getIdentity(_c6c.before)];if(_c71<_c70){--_c70;}}}else{_c70=_c6f;}if(_c70===_c71){data[_c70]=_c6b;}else{if(_c71!==undefined){data.splice(_c71,1);}data.splice(_c70,0,_c6b);this._rebuildIndex(_c71===undefined?_c70:Math.min(_c71,_c70));}return id;},add:function(_c73,_c74){(_c74=_c74||{}).overwrite=false;return this.put(_c73,_c74);},remove:function(id){var _c75=this.index;var data=this.data;if(id in _c75){data.splice(_c75[id],1);this.index={};this._rebuildIndex();return true;}},query:function(_c76,_c77){return _c67(this.queryEngine(_c76,_c77)(this.data));},setData:function(data){if(data.items){this.idProperty=data.identifier||this.idProperty;data=this.data=data.items;}else{this.data=data;}this.index={};this._rebuildIndex();},_rebuildIndex:function(_c78){var data=this.data;var _c79=data.length;var i;_c78=_c78||0;for(i=_c78;i<_c79;i++){this.index[data[i][this.idProperty]]=i;}}});});},"dojo/store/util/SimpleQueryEngine":function(){define(["../../_base/array"],function(_c7a){return function(_c7b,_c7c){switch(typeof _c7b){default:throw new Error("Can not query with a "+typeof _c7b);case "object":case "undefined":var _c7d=_c7b;_c7b=function(_c7e){for(var key in _c7d){var _c7f=_c7d[key];if(_c7f&&_c7f.test){if(!_c7f.test(_c7e[key],_c7e)){return false;}}else{if(_c7f!=_c7e[key]){return false;}}}return true;};break;case "string":if(!this[_c7b]){throw new Error("No filter function "+_c7b+" was found in store");}_c7b=this[_c7b];case "function":}function _c80(_c81){var _c82=_c7a.filter(_c81,_c7b);var _c83=_c7c&&_c7c.sort;if(_c83){_c82.sort(typeof _c83=="function"?_c83:function(a,b){for(var sort,i=0;sort=_c83[i];i++){var _c84=a[sort.attribute];var _c85=b[sort.attribute];_c84=_c84!=null?_c84.valueOf():_c84;_c85=_c85!=null?_c85.valueOf():_c85;if(_c84!=_c85){return !!sort.descending==(_c84==null||_c84>_c85)?-1:1;}}return 0;});}if(_c7c&&(_c7c.start||_c7c.count)){var _c86=_c82.length;_c82=_c82.slice(_c7c.start||0,(_c7c.start||0)+(_c7c.count||Infinity));_c82.total=_c86;}return _c82;};_c80.matches=_c7b;return _c80;};});},"dijit/form/_SearchMixin":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","dojo/query","dojo/string","dojo/when","../registry"],function(_c87,keys,lang,_c88,_c89,when,_c8a){return _c87("dijit.form._SearchMixin",null,{pageSize:Infinity,store:null,fetchProperties:{},query:{},list:"",_setListAttr:function(list){this._set("list",list);},searchDelay:200,searchAttr:"name",queryExpr:"${0}*",ignoreCase:true,_patternToRegExp:function(_c8b){return new RegExp("^"+_c8b.replace(/(\\.)|(\*)|(\?)|\W/g,function(str,_c8c,star,_c8d){return star?".*":_c8d?".":_c8c?_c8c:"\\"+str;})+"$",this.ignoreCase?"mi":"m");},_abortQuery:function(){if(this.searchTimer){this.searchTimer=this.searchTimer.remove();}if(this._queryDeferHandle){this._queryDeferHandle=this._queryDeferHandle.remove();}if(this._fetchHandle){if(this._fetchHandle.abort){this._cancelingQuery=true;this._fetchHandle.abort();this._cancelingQuery=false;}if(this._fetchHandle.cancel){this._cancelingQuery=true;this._fetchHandle.cancel();this._cancelingQuery=false;}this._fetchHandle=null;}},_processInput:function(evt){if(this.disabled||this.readOnly){return;}var key=evt.charOrCode;this._prev_key_backspace=false;if(key===keys.DELETE||key===keys.BACKSPACE){this._prev_key_backspace=true;this._maskValidSubsetError=true;}if(!this.store){this.onSearch();}else{this.searchTimer=this.defer("_startSearchFromInput",1);}},onSearch:function(){},_startSearchFromInput:function(){this._startSearch(this.focusNode.value);},_startSearch:function(text){this._abortQuery();var _c8e=this,_c88=lang.clone(this.query),_c8f={start:0,count:this.pageSize,queryOptions:{ignoreCase:this.ignoreCase,deep:true}},qs=_c89.substitute(this.queryExpr,[text.replace(/([\\\*\?])/g,"\\$1")]),q,_c90=function(){var _c91=_c8e._fetchHandle=_c8e.store.query(_c88,_c8f);if(_c8e.disabled||_c8e.readOnly||(q!==_c8e._lastQuery)){return;}when(_c91,function(res){_c8e._fetchHandle=null;if(!_c8e.disabled&&!_c8e.readOnly&&(q===_c8e._lastQuery)){when(_c91.total,function(_c92){res.total=_c92;var _c93=_c8e.pageSize;if(isNaN(_c93)||_c93>res.total){_c93=res.total;}res.nextPage=function(_c94){_c8f.direction=_c94=_c94!==false;_c8f.count=_c93;if(_c94){_c8f.start+=res.length;if(_c8f.start>=res.total){_c8f.count=0;}}else{_c8f.start-=_c93;if(_c8f.start<0){_c8f.count=Math.max(_c93+_c8f.start,0);_c8f.start=0;}}if(_c8f.count<=0){res.length=0;_c8e.onSearch(res,_c88,_c8f);}else{_c90();}};_c8e.onSearch(res,_c88,_c8f);});}},function(err){_c8e._fetchHandle=null;if(!_c8e._cancelingQuery){console.error(_c8e.declaredClass+" "+err.toString());}});};lang.mixin(_c8f,this.fetchProperties);if(this.store._oldAPI){q=qs;}else{q=this._patternToRegExp(qs);q.toString=function(){return qs;};}this._lastQuery=_c88[this.searchAttr]=q;this._queryDeferHandle=this.defer(_c90,this.searchDelay);},constructor:function(){this.query={};this.fetchProperties={};},postMixInProperties:function(){if(!this.store){var list=this.list;if(list){this.store=_c8a.byId(list);}}this.inherited(arguments);}});});},"dijit/form/_ComboBoxMenu":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/dom-style","dojo/keys","../_WidgetBase","../_TemplatedMixin","./_ComboBoxMenuMixin","./_ListMouseMixin"],function(_c95,_c96,_c97,keys,_c98,_c99,_c9a,_c9b){return _c95("dijit.form._ComboBoxMenu",[_c98,_c99,_c9b,_c9a],{templateString:"<div class='dijitReset dijitMenu' data-dojo-attach-point='containerNode' style='overflow: auto; overflow-x: hidden;' role='listbox'>"+"<div class='dijitMenuItem dijitMenuPreviousButton' data-dojo-attach-point='previousButton' role='option'></div>"+"<div class='dijitMenuItem dijitMenuNextButton' data-dojo-attach-point='nextButton' role='option'></div>"+"</div>",baseClass:"dijitComboBoxMenu",postCreate:function(){this.inherited(arguments);if(!this.isLeftToRight()){_c96.add(this.previousButton,"dijitMenuItemRtl");_c96.add(this.nextButton,"dijitMenuItemRtl");}this.containerNode.setAttribute("role","listbox");},_createMenuItem:function(){var item=this.ownerDocument.createElement("div");item.className="dijitReset dijitMenuItem"+(this.isLeftToRight()?"":" dijitMenuItemRtl");item.setAttribute("role","option");return item;},onHover:function(node){_c96.add(node,"dijitMenuItemHover");},onUnhover:function(node){_c96.remove(node,"dijitMenuItemHover");},onSelect:function(node){_c96.add(node,"dijitMenuItemSelected");},onDeselect:function(node){_c96.remove(node,"dijitMenuItemSelected");},_page:function(up){var _c9c=0;var _c9d=this.domNode.scrollTop;var _c9e=_c97.get(this.domNode,"height");if(!this.getHighlightedOption()){this.selectNextNode();}while(_c9c<_c9e){var _c9f=this.getHighlightedOption();if(up){if(!_c9f.previousSibling||_c9f.previousSibling.style.display=="none"){break;}this.selectPreviousNode();}else{if(!_c9f.nextSibling||_c9f.nextSibling.style.display=="none"){break;}this.selectNextNode();}var _ca0=this.domNode.scrollTop;_c9c+=(_ca0-_c9d)*(up?-1:1);_c9d=_ca0;}},handleKey:function(evt){switch(evt.keyCode){case keys.DOWN_ARROW:this.selectNextNode();return false;case keys.PAGE_DOWN:this._page(false);return false;case keys.UP_ARROW:this.selectPreviousNode();return false;case keys.PAGE_UP:this._page(true);return false;default:return true;}}});});},"dijit/form/_ComboBoxMenuMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/i18n","dojo/i18n!./nls/ComboBox"],function(_ca1,_ca2,_ca3,has,i18n){var _ca4=_ca2("dijit.form._ComboBoxMenuMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{_messages:null,postMixInProperties:function(){this.inherited(arguments);this._messages=i18n.getLocalization("dijit.form","ComboBox",this.lang);},buildRendering:function(){this.inherited(arguments);this.previousButton.innerHTML=this._messages["previousMessage"];this.nextButton.innerHTML=this._messages["nextMessage"];},_setValueAttr:function(_ca5){this._set("value",_ca5);this.onChange(_ca5);},onClick:function(node){if(node==this.previousButton){this._setSelectedAttr(null);this.onPage(-1);}else{if(node==this.nextButton){this._setSelectedAttr(null);this.onPage(1);}else{this.onChange(node);}}},onChange:function(){},onPage:function(){},onClose:function(){this._setSelectedAttr(null);},_createOption:function(item,_ca6){var _ca7=this._createMenuItem();var _ca8=_ca6(item);if(_ca8.html){_ca7.innerHTML=_ca8.label;}else{_ca7.appendChild(_ca7.ownerDocument.createTextNode(_ca8.label));}if(_ca7.innerHTML==""){_ca7.innerHTML="&#160;";}return _ca7;},createOptions:function(_ca9,_caa,_cab){this.items=_ca9;this.previousButton.style.display=(_caa.start==0)?"none":"";_ca3.set(this.previousButton,"id",this.id+"_prev");_ca1.forEach(_ca9,function(item,i){var _cac=this._createOption(item,_cab);_cac.setAttribute("item",i);_ca3.set(_cac,"id",this.id+i);this.nextButton.parentNode.insertBefore(_cac,this.nextButton);},this);var _cad=false;if(_ca9.total&&!_ca9.total.then&&_ca9.total!=-1){if((_caa.start+_caa.count)<_ca9.total){_cad=true;}else{if((_caa.start+_caa.count)>_ca9.total&&_caa.count==_ca9.length){_cad=true;}}}else{if(_caa.count==_ca9.length){_cad=true;}}this.nextButton.style.display=_cad?"":"none";_ca3.set(this.nextButton,"id",this.id+"_next");},clearResultList:function(){var _cae=this.containerNode;while(_cae.childNodes.length>2){_cae.removeChild(_cae.childNodes[_cae.childNodes.length-2]);}this._setSelectedAttr(null);},highlightFirstOption:function(){this.selectFirstNode();},highlightLastOption:function(){this.selectLastNode();},selectFirstNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.previousButton){this.selectNextNode();}},selectLastNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.nextButton){this.selectPreviousNode();}},getHighlightedOption:function(){return this.selected;}});if(has("dojo-bidi")){_ca4=_ca2("dijit.form._ComboBoxMenuMixin",_ca4,{_createOption:function(){var _caf=this.inherited(arguments);this.applyTextDir(_caf);return _caf;}});}return _ca4;});},"dijit/form/_ListMouseMixin":function(){define(["dojo/_base/declare","dojo/on","dojo/touch","./_ListBase"],function(_cb0,on,_cb1,_cb2){return _cb0("dijit.form._ListMouseMixin",_cb2,{postCreate:function(){this.inherited(arguments);this.domNode.dojoClick=true;this._listConnect("click","_onClick");this._listConnect("mousedown","_onMouseDown");this._listConnect("mouseup","_onMouseUp");this._listConnect("mouseover","_onMouseOver");this._listConnect("mouseout","_onMouseOut");},_onClick:function(evt,_cb3){this._setSelectedAttr(_cb3,false);if(this._deferredClick){this._deferredClick.remove();}this._deferredClick=this.defer(function(){this._deferredClick=null;this.onClick(_cb3);});},_onMouseDown:function(evt,_cb4){if(this._hoveredNode){this.onUnhover(this._hoveredNode);this._hoveredNode=null;}this._isDragging=true;this._setSelectedAttr(_cb4,false);},_onMouseUp:function(evt,_cb5){this._isDragging=false;var _cb6=this.selected;var _cb7=this._hoveredNode;if(_cb6&&_cb5==_cb6){this.defer(function(){this._onClick(evt,_cb6);});}else{if(_cb7){this.defer(function(){this._onClick(evt,_cb7);});}}},_onMouseOut:function(evt,_cb8){if(this._hoveredNode){this.onUnhover(this._hoveredNode);this._hoveredNode=null;}if(this._isDragging){this._cancelDrag=(new Date()).getTime()+1000;}},_onMouseOver:function(evt,_cb9){if(this._cancelDrag){var time=(new Date()).getTime();if(time>this._cancelDrag){this._isDragging=false;}this._cancelDrag=null;}this._hoveredNode=_cb9;this.onHover(_cb9);if(this._isDragging){this._setSelectedAttr(_cb9,false);}}});});},"dijit/form/_ListBase":function(){define(["dojo/_base/declare","dojo/on","dojo/window"],function(_cba,on,_cbb){return _cba("dijit.form._ListBase",null,{selected:null,_listConnect:function(_cbc,_cbd){var self=this;return self.own(on(self.containerNode,on.selector(function(_cbe,_cbf,_cc0){return _cbe.parentNode==_cc0;},_cbc),function(evt){self[_cbd](evt,this);}));},selectFirstNode:function(){var _cc1=this.containerNode.firstChild;while(_cc1&&_cc1.style.display=="none"){_cc1=_cc1.nextSibling;}this._setSelectedAttr(_cc1,true);},selectLastNode:function(){var last=this.containerNode.lastChild;while(last&&last.style.display=="none"){last=last.previousSibling;}this._setSelectedAttr(last,true);},selectNextNode:function(){var _cc2=this.selected;if(!_cc2){this.selectFirstNode();}else{var next=_cc2.nextSibling;while(next&&next.style.display=="none"){next=next.nextSibling;}if(!next){this.selectFirstNode();}else{this._setSelectedAttr(next,true);}}},selectPreviousNode:function(){var _cc3=this.selected;if(!_cc3){this.selectLastNode();}else{var prev=_cc3.previousSibling;while(prev&&prev.style.display=="none"){prev=prev.previousSibling;}if(!prev){this.selectLastNode();}else{this._setSelectedAttr(prev,true);}}},_setSelectedAttr:function(node,_cc4){if(this.selected!=node){var _cc5=this.selected;if(_cc5){this.onDeselect(_cc5);}if(node){if(_cc4){_cbb.scrollIntoView(node);}this.onSelect(node);}this._set("selected",node);}else{if(node){this.onSelect(node);}}}});});},"dijit/_HasDropDown":function(){define(["dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","./registry","./focus","./popup","./_FocusMixin"],function(_cc6,_cc7,dom,_cc8,_cc9,_cca,_ccb,has,keys,lang,on,_ccc,_ccd,_cce,_ccf,_cd0){return _cc6("dijit._HasDropDown",_cd0,{_buttonNode:null,_arrowWrapperNode:null,_popupStateNode:null,_aroundNode:null,dropDown:null,autoWidth:true,forceWidth:false,maxHeight:-1,dropDownPosition:["below","above"],_stopClickEvents:true,_onDropDownMouseDown:function(e){if(this.disabled||this.readOnly){return;}if(e.type!="MSPointerDown"){e.preventDefault();}this.own(on.once(this.ownerDocument,_ccc.release,lang.hitch(this,"_onDropDownMouseUp")));this.toggleDropDown();},_onDropDownMouseUp:function(e){var _cd1=this.dropDown,_cd2=false;if(e&&this._opened){var c=_cca.position(this._buttonNode,true);if(!(e.pageX>=c.x&&e.pageX<=c.x+c.w)||!(e.pageY>=c.y&&e.pageY<=c.y+c.h)){var t=e.target;while(t&&!_cd2){if(_cc9.contains(t,"dijitPopup")){_cd2=true;}else{t=t.parentNode;}}if(_cd2){t=e.target;if(_cd1.onItemClick){var _cd3;while(t&&!(_cd3=_ccd.byNode(t))){t=t.parentNode;}if(_cd3&&_cd3.onClick&&_cd3.getParent){_cd3.getParent().onItemClick(_cd3,e);}}return;}}}if(this._opened){if(_cd1.focus&&(_cd1.autoFocus!==false||(e.type=="mouseup"&&!this.hovering))){this._focusDropDownTimer=this.defer(function(){_cd1.focus();delete this._focusDropDownTimer;});}}else{if(this.focus){this.defer("focus");}}},_onDropDownClick:function(e){if(this._stopClickEvents){e.stopPropagation();e.preventDefault();}},buildRendering:function(){this.inherited(arguments);this._buttonNode=this._buttonNode||this.focusNode||this.domNode;this._popupStateNode=this._popupStateNode||this.focusNode||this._buttonNode;var _cd4={"after":this.isLeftToRight()?"Right":"Left","before":this.isLeftToRight()?"Left":"Right","above":"Up","below":"Down","left":"Left","right":"Right"}[this.dropDownPosition[0]]||this.dropDownPosition[0]||"Down";_cc9.add(this._arrowWrapperNode||this._buttonNode,"dijit"+_cd4+"ArrowButton");},postCreate:function(){this.inherited(arguments);var _cd5=this.focusNode||this.domNode;this.own(on(this._buttonNode,_ccc.press,lang.hitch(this,"_onDropDownMouseDown")),on(this._buttonNode,"click",lang.hitch(this,"_onDropDownClick")),on(_cd5,"keydown",lang.hitch(this,"_onKey")),on(_cd5,"keyup",lang.hitch(this,"_onKeyUp")));},destroy:function(){if(this._opened){this.closeDropDown(true);}if(this.dropDown){if(!this.dropDown._destroyed){this.dropDown.destroyRecursive();}delete this.dropDown;}this.inherited(arguments);},_onKey:function(e){if(this.disabled||this.readOnly){return;}var d=this.dropDown,_cd6=e.target;if(d&&this._opened&&d.handleKey){if(d.handleKey(e)===false){e.stopPropagation();e.preventDefault();return;}}if(d&&this._opened&&e.keyCode==keys.ESCAPE){this.closeDropDown();e.stopPropagation();e.preventDefault();}else{if(!this._opened&&(e.keyCode==keys.DOWN_ARROW||((e.keyCode==keys.ENTER||(e.keyCode==keys.SPACE&&(!this._searchTimer||(e.ctrlKey||e.altKey||e.metaKey))))&&((_cd6.tagName||"").toLowerCase()!=="input"||(_cd6.type&&_cd6.type.toLowerCase()!=="text"))))){this._toggleOnKeyUp=true;e.stopPropagation();e.preventDefault();}}},_onKeyUp:function(){if(this._toggleOnKeyUp){delete this._toggleOnKeyUp;this.toggleDropDown();var d=this.dropDown;if(d&&d.focus){this.defer(lang.hitch(d,"focus"),1);}}},_onBlur:function(){this.closeDropDown(false);this.inherited(arguments);},isLoaded:function(){return true;},loadDropDown:function(_cd7){_cd7();},loadAndOpenDropDown:function(){var d=new _cc7(),_cd8=lang.hitch(this,function(){this.openDropDown();d.resolve(this.dropDown);});if(!this.isLoaded()){this.loadDropDown(_cd8);}else{_cd8();}return d;},toggleDropDown:function(){if(this.disabled||this.readOnly){return;}if(!this._opened){this.loadAndOpenDropDown();}else{this.closeDropDown(true);}},openDropDown:function(){var _cd9=this.dropDown,_cda=_cd9.domNode,_cdb=this._aroundNode||this.domNode,self=this;var _cdc=_ccf.open({parent:this,popup:_cd9,around:_cdb,orient:this.dropDownPosition,maxHeight:this.maxHeight,onExecute:function(){self.closeDropDown(true);},onCancel:function(){self.closeDropDown(true);},onClose:function(){_cc8.set(self._popupStateNode,"popupActive",false);_cc9.remove(self._popupStateNode,"dijitHasDropDownOpen");self._set("_opened",false);}});if(this.forceWidth||(this.autoWidth&&_cdb.offsetWidth>_cd9._popupWrapper.offsetWidth)){var _cdd=_cdb.offsetWidth-_cd9._popupWrapper.offsetWidth;var _cde={w:_cd9.domNode.offsetWidth+_cdd};this._origStyle=_cda.style.cssText;if(lang.isFunction(_cd9.resize)){_cd9.resize(_cde);}else{_cca.setMarginBox(_cda,_cde);}if(_cdc.corner[1]=="R"){_cd9._popupWrapper.style.left=(_cd9._popupWrapper.style.left.replace("px","")-_cdd)+"px";}}_cc8.set(this._popupStateNode,"popupActive","true");_cc9.add(this._popupStateNode,"dijitHasDropDownOpen");this._set("_opened",true);this._popupStateNode.setAttribute("aria-expanded","true");this._popupStateNode.setAttribute("aria-owns",_cd9.id);if(_cda.getAttribute("role")!=="presentation"&&!_cda.getAttribute("aria-labelledby")){_cda.setAttribute("aria-labelledby",this.id);}return _cdc;},closeDropDown:function(_cdf){if(this._focusDropDownTimer){this._focusDropDownTimer.remove();delete this._focusDropDownTimer;}if(this._opened){this._popupStateNode.setAttribute("aria-expanded","false");if(_cdf&&this.focus){this.focus();}_ccf.close(this.dropDown);this._opened=false;}if(this._origStyle){this.dropDown.domNode.style.cssText=this._origStyle;delete this._origStyle;}}});});},"dijit/popup":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","./place","./BackgroundIframe","./Viewport","./main","dojo/touch"],function(_ce0,_ce1,_ce2,dom,_ce3,_ce4,_ce5,_ce6,has,keys,lang,on,_ce7,_ce8,_ce9,_cea){function _ceb(){if(this._popupWrapper){_ce4.destroy(this._popupWrapper);delete this._popupWrapper;}};var _cec=_ce2(null,{_stack:[],_beginZIndex:1000,_idGen:1,_repositionAll:function(){if(this._firstAroundNode){var _ced=this._firstAroundPosition,_cee=_ce5.position(this._firstAroundNode,true),dx=_cee.x-_ced.x,dy=_cee.y-_ced.y;if(dx||dy){this._firstAroundPosition=_cee;for(var i=0;i<this._stack.length;i++){var _cef=this._stack[i].wrapper.style;_cef.top=(parseFloat(_cef.top)+dy)+"px";if(_cef.right=="auto"){_cef.left=(parseFloat(_cef.left)+dx)+"px";}else{_cef.right=(parseFloat(_cef.right)-dx)+"px";}}}this._aroundMoveListener=setTimeout(lang.hitch(this,"_repositionAll"),dx||dy?10:50);}},_createWrapper:function(_cf0){var _cf1=_cf0._popupWrapper,node=_cf0.domNode;if(!_cf1){_cf1=_ce4.create("div",{"class":"dijitPopup",style:{display:"none"},role:"region","aria-label":_cf0["aria-label"]||_cf0.label||_cf0.name||_cf0.id},_cf0.ownerDocumentBody);_cf1.appendChild(node);var s=node.style;s.display="";s.visibility="";s.position="";s.top="0px";_cf0._popupWrapper=_cf1;_ce1.after(_cf0,"destroy",_ceb,true);if("ontouchend" in document){on(_cf1,"touchend",function(evt){if(!/^(input|button|textarea)$/i.test(evt.target.tagName)){evt.preventDefault();}});}_cf1.dojoClick=true;}return _cf1;},moveOffScreen:function(_cf2){var _cf3=this._createWrapper(_cf2);var ltr=_ce5.isBodyLtr(_cf2.ownerDocument),_cf4={visibility:"hidden",top:"-9999px",display:""};_cf4[ltr?"left":"right"]="-9999px";_cf4[ltr?"right":"left"]="auto";_ce6.set(_cf3,_cf4);return _cf3;},hide:function(_cf5){var _cf6=this._createWrapper(_cf5);_ce6.set(_cf6,{display:"none",height:"auto",overflowY:"visible",border:""});var node=_cf5.domNode;if("_originalStyle" in node){node.style.cssText=node._originalStyle;}},getTopPopup:function(){var _cf7=this._stack;for(var pi=_cf7.length-1;pi>0&&_cf7[pi].parent===_cf7[pi-1].widget;pi--){}return _cf7[pi];},open:function(args){var _cf8=this._stack,_cf9=args.popup,node=_cf9.domNode,_cfa=args.orient||["below","below-alt","above","above-alt"],ltr=args.parent?args.parent.isLeftToRight():_ce5.isBodyLtr(_cf9.ownerDocument),_cfb=args.around,id=(args.around&&args.around.id)?(args.around.id+"_dropdown"):("popup_"+this._idGen++);while(_cf8.length&&(!args.parent||!dom.isDescendant(args.parent.domNode,_cf8[_cf8.length-1].widget.domNode))){this.close(_cf8[_cf8.length-1].widget);}var _cfc=this.moveOffScreen(_cf9);if(_cf9.startup&&!_cf9._started){_cf9.startup();}var _cfd,_cfe=_ce5.position(node);if("maxHeight" in args&&args.maxHeight!=-1){_cfd=args.maxHeight||Infinity;}else{var _cff=_ce9.getEffectiveBox(this.ownerDocument),_d00=_cfb?_ce5.position(_cfb,false):{y:args.y-(args.padding||0),h:(args.padding||0)*2};_cfd=Math.floor(Math.max(_d00.y,_cff.h-(_d00.y+_d00.h)));}if(_cfe.h>_cfd){var cs=_ce6.getComputedStyle(node),_d01=cs.borderLeftWidth+" "+cs.borderLeftStyle+" "+cs.borderLeftColor;_ce6.set(_cfc,{overflowY:"scroll",height:_cfd+"px",border:_d01});node._originalStyle=node.style.cssText;node.style.border="none";}_ce3.set(_cfc,{id:id,style:{zIndex:this._beginZIndex+_cf8.length},"class":"dijitPopup "+(_cf9.baseClass||_cf9["class"]||"").split(" ")[0]+"Popup",dijitPopupParent:args.parent?args.parent.id:""});if(_cf8.length==0&&_cfb){this._firstAroundNode=_cfb;this._firstAroundPosition=_ce5.position(_cfb,true);this._aroundMoveListener=setTimeout(lang.hitch(this,"_repositionAll"),50);}if(has("config-bgIframe")&&!_cf9.bgIframe){_cf9.bgIframe=new _ce8(_cfc);}var _d02=_cf9.orient?lang.hitch(_cf9,"orient"):null,best=_cfb?_ce7.around(_cfc,_cfb,_cfa,ltr,_d02):_ce7.at(_cfc,args,_cfa=="R"?["TR","BR","TL","BL"]:["TL","BL","TR","BR"],args.padding,_d02);_cfc.style.visibility="visible";node.style.visibility="visible";var _d03=[];_d03.push(on(_cfc,"keydown",lang.hitch(this,function(evt){if(evt.keyCode==keys.ESCAPE&&args.onCancel){evt.stopPropagation();evt.preventDefault();args.onCancel();}else{if(evt.keyCode==keys.TAB){evt.stopPropagation();evt.preventDefault();var _d04=this.getTopPopup();if(_d04&&_d04.onCancel){_d04.onCancel();}}}})));if(_cf9.onCancel&&args.onCancel){_d03.push(_cf9.on("cancel",args.onCancel));}_d03.push(_cf9.on(_cf9.onExecute?"execute":"change",lang.hitch(this,function(){var _d05=this.getTopPopup();if(_d05&&_d05.onExecute){_d05.onExecute();}})));_cf8.push({widget:_cf9,wrapper:_cfc,parent:args.parent,onExecute:args.onExecute,onCancel:args.onCancel,onClose:args.onClose,handlers:_d03});if(_cf9.onOpen){_cf9.onOpen(best);}return best;},close:function(_d06){var _d07=this._stack;while((_d06&&_ce0.some(_d07,function(elem){return elem.widget==_d06;}))||(!_d06&&_d07.length)){var top=_d07.pop(),_d08=top.widget,_d09=top.onClose;if(_d08.bgIframe){_d08.bgIframe.destroy();delete _d08.bgIframe;}if(_d08.onClose){_d08.onClose();}var h;while(h=top.handlers.pop()){h.remove();}if(_d08&&_d08.domNode){this.hide(_d08);}if(_d09){_d09();}}if(_d07.length==0&&this._aroundMoveListener){clearTimeout(this._aroundMoveListener);this._firstAroundNode=this._firstAroundPosition=this._aroundMoveListener=null;}}});return (_cea.popup=new _cec());});},"dijit/form/NumberTextBox":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/i18n","dojo/string","dojo/number","./RangeBoundTextBox"],function(_d0a,lang,i18n,_d0b,_d0c,_d0d){var _d0e=function(_d0f){var _d0f=_d0f||{},_d10=i18n.getLocalization("dojo.cldr","number",i18n.normalizeLocale(_d0f.locale)),_d11=_d0f.pattern?_d0f.pattern:_d10[(_d0f.type||"decimal")+"Format"];var _d12;if(typeof _d0f.places=="number"){_d12=_d0f.places;}else{if(typeof _d0f.places==="string"&&_d0f.places.length>0){_d12=_d0f.places.replace(/.*,/,"");}else{_d12=(_d11.indexOf(".")!=-1?_d11.split(".")[1].replace(/[^#0]/g,"").length:0);}}return {sep:_d10.decimal,places:_d12};};var _d13=_d0a("dijit.form.NumberTextBoxMixin",null,{pattern:function(_d14){return "("+(this.focused&&this.editOptions?this._regExpGenerator(lang.delegate(_d14,this.editOptions))+"|":"")+this._regExpGenerator(_d14)+")";},value:NaN,editOptions:{pattern:"#.######"},_formatter:_d0c.format,_regExpGenerator:_d0c.regexp,_decimalInfo:_d0e(),postMixInProperties:function(){this.inherited(arguments);this._set("type","text");},_setConstraintsAttr:function(_d15){var _d16=typeof _d15.places=="number"?_d15.places:0;if(_d16){_d16++;}if(typeof _d15.max!="number"){_d15.max=9*Math.pow(10,15-_d16);}if(typeof _d15.min!="number"){_d15.min=-9*Math.pow(10,15-_d16);}this.inherited(arguments,[_d15]);if(this.focusNode&&this.focusNode.value&&!isNaN(this.value)){this.set("value",this.value);}this._decimalInfo=_d0e(_d15);},_onFocus:function(by){if(this.disabled||this.readOnly){return;}var val=this.get("value");if(typeof val=="number"&&!isNaN(val)){var _d17=this.format(val,this.constraints);if(_d17!==undefined){this.textbox.value=_d17;if(by!=="mouse"){this.textbox.select();}}}this.inherited(arguments);},format:function(_d18,_d19){var _d1a=String(_d18);if(typeof _d18!="number"){return _d1a;}if(isNaN(_d18)){return "";}if(!("rangeCheck" in this&&this.rangeCheck(_d18,_d19))&&_d19.exponent!==false&&/\de[-+]?\d/i.test(_d1a)){return _d1a;}if(this.editOptions&&this.focused){_d19=lang.mixin({},_d19,this.editOptions);}return this._formatter(_d18,_d19);},_parser:_d0c.parse,parse:function(_d1b,_d1c){var _d1d=lang.mixin({},_d1c,(this.editOptions&&this.focused)?this.editOptions:{});if(this.focused&&_d1d.places!=null){var _d1e=_d1d.places;var _d1f=typeof _d1e==="number"?_d1e:Number(_d1e.split(",").pop());_d1d.places="0,"+_d1f;}var v=this._parser(_d1b,_d1d);if(this.editOptions&&this.focused&&isNaN(v)){v=this._parser(_d1b,_d1c);}return v;},_getDisplayedValueAttr:function(){var v=this.inherited(arguments);return isNaN(v)?this.textbox.value:v;},filter:function(_d20){if(_d20==null||typeof _d20=="string"&&_d20==""){return NaN;}else{if(typeof _d20=="number"&&!isNaN(_d20)&&_d20!=0){_d20=_d0c.round(_d20,this._decimalInfo.places);}}return this.inherited(arguments,[_d20]);},serialize:function(_d21,_d22){return (typeof _d21!="number"||isNaN(_d21))?"":this.inherited(arguments);},_setBlurValue:function(){var val=lang.hitch(lang.delegate(this,{focused:true}),"get")("value");this._setValueAttr(val,true);},_setValueAttr:function(_d23,_d24,_d25){if(_d23!==undefined&&_d25===undefined){_d25=String(_d23);if(typeof _d23=="number"){if(isNaN(_d23)){_d25="";}else{if(("rangeCheck" in this&&this.rangeCheck(_d23,this.constraints))||this.constraints.exponent===false||!/\de[-+]?\d/i.test(_d25)){_d25=undefined;}}}else{if(!_d23){_d25="";_d23=NaN;}else{_d23=undefined;}}}this.inherited(arguments,[_d23,_d24,_d25]);},_getValueAttr:function(){var v=this.inherited(arguments);if(isNaN(v)&&this.textbox.value!==""){if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)&&(new RegExp("^"+_d0c._realNumberRegexp(lang.delegate(this.constraints))+"$").test(this.textbox.value))){var n=Number(this.textbox.value);return isNaN(n)?undefined:n;}else{return undefined;}}else{return v;}},isValid:function(_d26){if(!this.focused||this._isEmpty(this.textbox.value)){return this.inherited(arguments);}else{var v=this.get("value");if(!isNaN(v)&&this.rangeCheck(v,this.constraints)){if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)){return true;}else{return this.inherited(arguments);}}else{return false;}}},_isValidSubset:function(){var _d27=(typeof this.constraints.min=="number"),_d28=(typeof this.constraints.max=="number"),_d29=this.get("value");if(isNaN(_d29)||(!_d27&&!_d28)){return this.inherited(arguments);}var _d2a=_d29|0,_d2b=_d29<0,_d2c=this.textbox.value.indexOf(this._decimalInfo.sep)!=-1,_d2d=this.maxLength||20,_d2e=_d2d-this.textbox.value.length,_d2f=_d2c?this.textbox.value.split(this._decimalInfo.sep)[1].replace(/[^0-9]/g,""):"";var _d30=_d2c?_d2a+"."+_d2f:_d2a+"";var _d31=_d0b.rep("9",_d2e),_d32=_d29,_d33=_d29;if(_d2b){_d32=Number(_d30+_d31);}else{_d33=Number(_d30+_d31);}return !((_d27&&_d33<this.constraints.min)||(_d28&&_d32>this.constraints.max));}});var _d34=_d0a("dijit.form.NumberTextBox",[_d0d,_d13],{baseClass:"dijitTextBox dijitNumberTextBox"});_d34.Mixin=_d13;return _d34;});},"dojo/number":function(){define(["./_base/lang","./i18n","./i18n!./cldr/nls/number","./string","./regexp"],function(lang,i18n,_d35,_d36,_d37){var _d38={};lang.setObject("dojo.number",_d38);_d38.format=function(_d39,_d3a){_d3a=lang.mixin({},_d3a||{});var _d3b=i18n.normalizeLocale(_d3a.locale),_d3c=i18n.getLocalization("dojo.cldr","number",_d3b);_d3a.customs=_d3c;var _d3d=_d3a.pattern||_d3c[(_d3a.type||"decimal")+"Format"];if(isNaN(_d39)||Math.abs(_d39)==Infinity){return null;}return _d38._applyPattern(_d39,_d3d,_d3a);};_d38._numberPatternRE=/[#0,]*[#0](?:\.0*#*)?/;_d38._applyPattern=function(_d3e,_d3f,_d40){_d40=_d40||{};var _d41=_d40.customs.group,_d42=_d40.customs.decimal,_d43=_d3f.split(";"),_d44=_d43[0];_d3f=_d43[(_d3e<0)?1:0]||("-"+_d44);if(_d3f.indexOf("%")!=-1){_d3e*=100;}else{if(_d3f.indexOf("‰")!=-1){_d3e*=1000;}else{if(_d3f.indexOf("¤")!=-1){_d41=_d40.customs.currencyGroup||_d41;_d42=_d40.customs.currencyDecimal||_d42;_d3f=_d3f.replace(/([\s\xa0\u202f]*)(\u00a4{1,3})([\s\xa0\u202f]*)/,function(_d45,_d46,_d47,_d48){var prop=["symbol","currency","displayName"][_d47.length-1],_d49=_d40[prop]||_d40.currency||"";if(!_d49){return "";}return _d46+_d49+_d48;});}else{if(_d3f.indexOf("E")!=-1){throw new Error("exponential notation not supported");}}}}var _d4a=_d38._numberPatternRE;var _d4b=_d44.match(_d4a);if(!_d4b){throw new Error("unable to find a number expression in pattern: "+_d3f);}if(_d40.fractional===false){_d40.places=0;}return _d3f.replace(_d4a,_d38._formatAbsolute(_d3e,_d4b[0],{decimal:_d42,group:_d41,places:_d40.places,round:_d40.round}));};_d38.round=function(_d4c,_d4d,_d4e){var _d4f=10/(_d4e||10);return (_d4f*+_d4c).toFixed(_d4d)/_d4f;};if((0.9).toFixed()==0){var _d50=_d38.round;_d38.round=function(v,p,m){var d=Math.pow(10,-p||0),a=Math.abs(v);if(!v||a>=d){d=0;}else{a/=d;if(a<0.5||a>=0.95){d=0;}}return _d50(v,p,m)+(v>0?d:-d);};}_d38._formatAbsolute=function(_d51,_d52,_d53){_d53=_d53||{};if(_d53.places===true){_d53.places=0;}if(_d53.places===Infinity){_d53.places=6;}var _d54=_d52.split("."),_d55=typeof _d53.places=="string"&&_d53.places.indexOf(","),_d56=_d53.places;if(_d55){_d56=_d53.places.substring(_d55+1);}else{if(!(_d56>=0)){_d56=(_d54[1]||[]).length;}}if(!(_d53.round<0)){_d51=_d38.round(_d51,_d56,_d53.round);}var _d57=String(Math.abs(_d51)).split("."),_d58=_d57[1]||"";if(_d54[1]||_d53.places){if(_d55){_d53.places=_d53.places.substring(0,_d55);}var pad=_d53.places!==undefined?_d53.places:(_d54[1]&&_d54[1].lastIndexOf("0")+1);if(pad>_d58.length){_d57[1]=_d36.pad(_d58,pad,"0",true);}if(_d56<_d58.length){_d57[1]=_d58.substr(0,_d56);}}else{if(_d57[1]){_d57.pop();}}var _d59=_d54[0].replace(",","");pad=_d59.indexOf("0");if(pad!=-1){pad=_d59.length-pad;if(pad>_d57[0].length){_d57[0]=_d36.pad(_d57[0],pad);}if(_d59.indexOf("#")==-1){_d57[0]=_d57[0].substr(_d57[0].length-pad);}}var _d5a=_d54[0].lastIndexOf(","),_d5b,_d5c;if(_d5a!=-1){_d5b=_d54[0].length-_d5a-1;var _d5d=_d54[0].substr(0,_d5a);_d5a=_d5d.lastIndexOf(",");if(_d5a!=-1){_d5c=_d5d.length-_d5a-1;}}var _d5e=[];for(var _d5f=_d57[0];_d5f;){var off=_d5f.length-_d5b;_d5e.push((off>0)?_d5f.substr(off):_d5f);_d5f=(off>0)?_d5f.slice(0,off):"";if(_d5c){_d5b=_d5c;_d5c=undefined;}}_d57[0]=_d5e.reverse().join(_d53.group||",");return _d57.join(_d53.decimal||".");};_d38.regexp=function(_d60){return _d38._parseInfo(_d60).regexp;};_d38._parseInfo=function(_d61){_d61=_d61||{};var _d62=i18n.normalizeLocale(_d61.locale),_d63=i18n.getLocalization("dojo.cldr","number",_d62),_d64=_d61.pattern||_d63[(_d61.type||"decimal")+"Format"],_d65=_d63.group,_d66=_d63.decimal,_d67=1;if(_d64.indexOf("%")!=-1){_d67/=100;}else{if(_d64.indexOf("‰")!=-1){_d67/=1000;}else{var _d68=_d64.indexOf("¤")!=-1;if(_d68){_d65=_d63.currencyGroup||_d65;_d66=_d63.currencyDecimal||_d66;}}}var _d69=_d64.split(";");if(_d69.length==1){_d69.push("-"+_d69[0]);}var re=_d37.buildGroupRE(_d69,function(_d6a){_d6a="(?:"+_d37.escapeString(_d6a,".")+")";return _d6a.replace(_d38._numberPatternRE,function(_d6b){var _d6c={signed:false,separator:_d61.strict?_d65:[_d65,""],fractional:_d61.fractional,decimal:_d66,exponent:false},_d6d=_d6b.split("."),_d6e=_d61.places;if(_d6d.length==1&&_d67!=1){_d6d[1]="###";}if(_d6d.length==1||_d6e===0){_d6c.fractional=false;}else{if(_d6e===undefined){_d6e=_d61.pattern?_d6d[1].lastIndexOf("0")+1:Infinity;}if(_d6e&&_d61.fractional==undefined){_d6c.fractional=true;}if(!_d61.places&&(_d6e<_d6d[1].length)){_d6e+=","+_d6d[1].length;}_d6c.places=_d6e;}var _d6f=_d6d[0].split(",");if(_d6f.length>1){_d6c.groupSize=_d6f.pop().length;if(_d6f.length>1){_d6c.groupSize2=_d6f.pop().length;}}return "("+_d38._realNumberRegexp(_d6c)+")";});},true);if(_d68){re=re.replace(/([\s\xa0\u202f]*)(\u00a4{1,3})([\s\xa0\u202f]*)/g,function(_d70,_d71,_d72,_d73){var prop=["symbol","currency","displayName"][_d72.length-1],_d74=_d37.escapeString(_d61[prop]||_d61.currency||"");if(!_d74){return "";}_d71=_d71?"[\\s\\xa0\\u202f]":"";_d73=_d73?"[\\s\\xa0\\u202f]":"";if(!_d61.strict){if(_d71){_d71+="*";}if(_d73){_d73+="*";}return "(?:"+_d71+_d74+_d73+")?";}return _d71+_d74+_d73;});}return {regexp:re.replace(/[\xa0\u202f ]/g,"[\\s\\xa0\\u202f]"),group:_d65,decimal:_d66,factor:_d67};};_d38.parse=function(_d75,_d76){var info=_d38._parseInfo(_d76),_d77=(new RegExp("^"+info.regexp+"$")).exec(_d75);if(!_d77){return NaN;}var _d78=_d77[1];if(!_d77[1]){if(!_d77[2]){return NaN;}_d78=_d77[2];info.factor*=-1;}_d78=_d78.replace(new RegExp("["+info.group+"\\s\\xa0\\u202f"+"]","g"),"").replace(info.decimal,".");return _d78*info.factor;};_d38._realNumberRegexp=function(_d79){_d79=_d79||{};if(!("places" in _d79)){_d79.places=Infinity;}if(typeof _d79.decimal!="string"){_d79.decimal=".";}if(!("fractional" in _d79)||/^0/.test(_d79.places)){_d79.fractional=[true,false];}if(!("exponent" in _d79)){_d79.exponent=[true,false];}if(!("eSigned" in _d79)){_d79.eSigned=[true,false];}var _d7a=_d38._integerRegexp(_d79),_d7b=_d37.buildGroupRE(_d79.fractional,function(q){var re="";if(q&&(_d79.places!==0)){re="\\"+_d79.decimal;if(_d79.places==Infinity){re="(?:"+re+"\\d+)?";}else{re+="\\d{"+_d79.places+"}";}}return re;},true);var _d7c=_d37.buildGroupRE(_d79.exponent,function(q){if(q){return "([eE]"+_d38._integerRegexp({signed:_d79.eSigned})+")";}return "";});var _d7d=_d7a+_d7b;if(_d7b){_d7d="(?:(?:"+_d7d+")|(?:"+_d7b+"))";}return _d7d+_d7c;};_d38._integerRegexp=function(_d7e){_d7e=_d7e||{};if(!("signed" in _d7e)){_d7e.signed=[true,false];}if(!("separator" in _d7e)){_d7e.separator="";}else{if(!("groupSize" in _d7e)){_d7e.groupSize=3;}}var _d7f=_d37.buildGroupRE(_d7e.signed,function(q){return q?"[-+]":"";},true);var _d80=_d37.buildGroupRE(_d7e.separator,function(sep){if(!sep){return "(?:\\d+)";}sep=_d37.escapeString(sep);if(sep==" "){sep="\\s";}else{if(sep==" "){sep="\\s\\xa0";}else{if(sep==" "){sep="\\s\\u202f";}}}var grp=_d7e.groupSize,grp2=_d7e.groupSize2;if(grp2){var _d81="(?:0|[1-9]\\d{0,"+(grp2-1)+"}(?:["+sep+"]\\d{"+grp2+"})*["+sep+"]\\d{"+grp+"})";return ((grp-grp2)>0)?"(?:"+_d81+"|(?:0|[1-9]\\d{0,"+(grp-1)+"}))":_d81;}return "(?:0|[1-9]\\d{0,"+(grp-1)+"}(?:["+sep+"]\\d{"+grp+"})*)";},true);return _d7f+_d80;};return _d38;});},"dijit/form/RangeBoundTextBox":function(){define(["dojo/_base/declare","dojo/i18n","./MappedTextBox","dojo/i18n!./nls/validate"],function(_d82,i18n,_d83){var _d84=_d82("dijit.form.RangeBoundTextBox",_d83,{rangeMessage:"",rangeCheck:function(_d85,_d86){return ("min" in _d86?(this.compare(_d85,_d86.min)>=0):true)&&("max" in _d86?(this.compare(_d85,_d86.max)<=0):true);},isInRange:function(){return this.rangeCheck(this.get("value"),this.constraints);},_isDefinitelyOutOfRange:function(){var val=this.get("value");if(val==null){return false;}var _d87=false;if("min" in this.constraints){var min=this.constraints.min;_d87=this.compare(val,((typeof min=="number")&&min>=0&&val!=0)?0:min)<0;}if(!_d87&&("max" in this.constraints)){var max=this.constraints.max;_d87=this.compare(val,((typeof max!="number")||max>0)?max:0)>0;}return _d87;},_isValidSubset:function(){return this.inherited(arguments)&&!this._isDefinitelyOutOfRange();},isValid:function(_d88){return this.inherited(arguments)&&((this._isEmpty(this.textbox.value)&&!this.required)||this.isInRange(_d88));},getErrorMessage:function(_d89){var v=this.get("value");if(v!=null&&v!==""&&(typeof v!="number"||!isNaN(v))&&!this.isInRange(_d89)){return this.rangeMessage;}return this.inherited(arguments);},postMixInProperties:function(){this.inherited(arguments);if(!this.rangeMessage){this.messages=i18n.getLocalization("dijit.form","validate",this.lang);this.rangeMessage=this.messages.rangeMessage;}}});return _d84;});},"dijit/form/MappedTextBox":function(){define(["dojo/_base/declare","dojo/sniff","dojo/dom-construct","./ValidationTextBox"],function(_d8a,has,_d8b,_d8c){return _d8a("dijit.form.MappedTextBox",_d8c,{postMixInProperties:function(){this.inherited(arguments);this.nameAttrSetting="";},_setNameAttr:"valueNode",serialize:function(val){return val.toString?val.toString():"";},toString:function(){var val=this.filter(this.get("value"));return val!=null?(typeof val=="string"?val:this.serialize(val,this.constraints)):"";},validate:function(){this.valueNode.value=this.toString();return this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);this.valueNode=_d8b.place("<input type='hidden'"+((this.name&&!has("msapp"))?" name=\""+this.name.replace(/"/g,"&quot;")+"\"":"")+"/>",this.textbox,"after");},reset:function(){this.valueNode.value="";this.inherited(arguments);}});});},"dijit/form/DateTextBox":function(){define(["dojo/_base/declare","../Calendar","./_DateTimeTextBox"],function(_d8d,_d8e,_d8f){return _d8d("dijit.form.DateTextBox",_d8f,{baseClass:"dijitTextBox dijitComboBox dijitDateTextBox",popupClass:_d8e,_selector:"date",maxHeight:Infinity,value:new Date("")});});},"dijit/Calendar":function(){define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","./CalendarLite","./_Widget","./_CssStateMixin","./_TemplatedMixin","./form/DropDownButton"],function(_d90,date,_d91,_d92,_d93,_d94,_d95,_d96,keys,lang,on,has,_d97,_d98,_d99,_d9a,_d9b){var _d9c=_d92("dijit.Calendar",[_d97,_d98,_d99],{baseClass:"dijitCalendar",cssStateNodes:{"decrementMonth":"dijitCalendarArrow","incrementMonth":"dijitCalendarArrow","previousYearLabelNode":"dijitCalendarPreviousYear","nextYearLabelNode":"dijitCalendarNextYear"},setValue:function(_d9d){_d96.deprecated("dijit.Calendar:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");this.set("value",_d9d);},_createMonthWidget:function(){return new _d9c._MonthDropDownButton({id:this.id+"_mddb",tabIndex:-1,onMonthSelect:lang.hitch(this,"_onMonthSelect"),lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKeyDown")),on(this.dateRowsNode,"mouseover",lang.hitch(this,"_onDayMouseOver")),on(this.dateRowsNode,"mouseout",lang.hitch(this,"_onDayMouseOut")),on(this.dateRowsNode,"mousedown",lang.hitch(this,"_onDayMouseDown")),on(this.dateRowsNode,"mouseup",lang.hitch(this,"_onDayMouseUp")));},_onMonthSelect:function(_d9e){var date=new this.dateClassObj(this.currentFocus);date.setDate(1);date.setMonth(_d9e);var _d9f=this.dateModule.getDaysInMonth(date);var _da0=this.currentFocus.getDate();date.setDate(Math.min(_da0,_d9f));this._setCurrentFocusAttr(date);},_onDayMouseOver:function(evt){var node=_d94.contains(evt.target,"dijitCalendarDateLabel")?evt.target.parentNode:evt.target;if(node&&((node.dijitDateValue&&!_d94.contains(node,"dijitCalendarDisabledDate"))||node==this.previousYearLabelNode||node==this.nextYearLabelNode)){_d94.add(node,"dijitCalendarHoveredDate");this._currentNode=node;}},_onDayMouseOut:function(evt){if(!this._currentNode){return;}if(evt.relatedTarget&&evt.relatedTarget.parentNode==this._currentNode){return;}var cls="dijitCalendarHoveredDate";if(_d94.contains(this._currentNode,"dijitCalendarActiveDate")){cls+=" dijitCalendarActiveDate";}_d94.remove(this._currentNode,cls);this._currentNode=null;},_onDayMouseDown:function(evt){var node=evt.target.parentNode;if(node&&node.dijitDateValue&&!_d94.contains(node,"dijitCalendarDisabledDate")){_d94.add(node,"dijitCalendarActiveDate");this._currentNode=node;}},_onDayMouseUp:function(evt){var node=evt.target.parentNode;if(node&&node.dijitDateValue){_d94.remove(node,"dijitCalendarActiveDate");}},handleKey:function(evt){var _da1=-1,_da2,_da3=this.currentFocus;switch(evt.keyCode){case keys.RIGHT_ARROW:_da1=1;case keys.LEFT_ARROW:_da2="day";if(!this.isLeftToRight()){_da1*=-1;}break;case keys.DOWN_ARROW:_da1=1;case keys.UP_ARROW:_da2="week";break;case keys.PAGE_DOWN:_da1=1;case keys.PAGE_UP:_da2=evt.ctrlKey||evt.altKey?"year":"month";break;case keys.END:_da3=this.dateModule.add(_da3,"month",1);_da2="day";case keys.HOME:_da3=new this.dateClassObj(_da3);_da3.setDate(1);break;default:return true;}if(_da2){_da3=this.dateModule.add(_da3,_da2,_da1);}this._setCurrentFocusAttr(_da3);return false;},_onKeyDown:function(evt){if(!this.handleKey(evt)){evt.stopPropagation();evt.preventDefault();}},onValueSelected:function(){},onChange:function(_da4){this.onValueSelected(_da4);},getClassForDate:function(){}});_d9c._MonthDropDownButton=_d92("dijit.Calendar._MonthDropDownButton",_d9b,{onMonthSelect:function(){},postCreate:function(){this.inherited(arguments);this.dropDown=new _d9c._MonthDropDown({id:this.id+"_mdd",onChange:this.onMonthSelect});},_setMonthAttr:function(_da5){var _da6=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_da5);this.dropDown.set("months",_da6);this.containerNode.innerHTML=(has("ie")==6?"":"<div class='dijitSpacer'>"+this.dropDown.domNode.innerHTML+"</div>")+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_da6[_da5.getMonth()]+"</div>";}});_d9c._MonthDropDown=_d92("dijit.Calendar._MonthDropDown",[_d98,_d9a,_d99],{months:[],baseClass:"dijitCalendarMonthMenu dijitMenu",templateString:"<div data-dojo-attach-event='ondijitclick:_onClick'></div>",_setMonthsAttr:function(_da7){this.domNode.innerHTML="";_d90.forEach(_da7,function(_da8,idx){var div=_d95.create("div",{className:"dijitCalendarMonthLabel",month:idx,innerHTML:_da8},this.domNode);div._cssState="dijitCalendarMonthLabel";},this);},_onClick:function(evt){this.onChange(_d93.get(evt.target,"month"));},onChange:function(){}});return _d9c;});},"dijit/CalendarLite":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/cldr/supplemental","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/dom","dojo/dom-class","dojo/dom-attr","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_WidgetBase","./_TemplatedMixin","dojo/text!./templates/Calendar.html","./a11yclick","./hccss"],function(_da9,_daa,_dab,date,_dac,_dad,dom,_dae,_daf,lang,on,has,_db0,_db1,_db2,_db3){var _db4=_daa("dijit.CalendarLite",[_db1,_db2],{templateString:_db3,dowTemplateString:"<th class=\"dijitReset dijitCalendarDayLabelTemplate\" role=\"columnheader\" scope=\"col\"><span class=\"dijitCalendarDayLabel\">${d}</span></th>",dateTemplateString:"<td class=\"dijitReset\" role=\"gridcell\" data-dojo-attach-point=\"dateCells\"><span class=\"dijitCalendarDateLabel\" data-dojo-attach-point=\"dateLabels\"></span></td>",weekTemplateString:"<tr class=\"dijitReset dijitCalendarWeekTemplate\" role=\"row\">${d}${d}${d}${d}${d}${d}${d}</tr>",value:new Date(""),datePackage:"",dayWidth:"narrow",tabIndex:"0",dayOffset:-1,currentFocus:new Date(),_setSummaryAttr:"gridNode",baseClass:"dijitCalendar dijitCalendarLite",_isValidDate:function(_db5){return _db5&&!isNaN(_db5)&&typeof _db5=="object"&&_db5.toString()!=this.constructor.prototype.value.toString();},_getValueAttr:function(){var _db6=this._get("value");if(_db6&&!isNaN(_db6)){var _db7=new this.dateClassObj(_db6);_db7.setHours(0,0,0,0);if(_db7.getDate()<_db6.getDate()){_db7=this.dateModule.add(_db7,"hour",1);}return _db7;}else{return null;}},_setValueAttr:function(_db8,_db9){if(typeof _db8=="string"){_db8=_dad.fromISOString(_db8);}_db8=this._patchDate(_db8);if(this._isValidDate(_db8)&&!this.isDisabledDate(_db8,this.lang)){this._set("value",_db8);this.set("currentFocus",_db8);this._markSelectedDates([_db8]);if(this._created&&(_db9||typeof _db9=="undefined")){this.onChange(this.get("value"));}}else{this._set("value",null);this._markSelectedDates([]);}},_patchDate:function(_dba){if(_dba||_dba===0){_dba=new this.dateClassObj(_dba);_dba.setHours(1,0,0,0);}return _dba;},_setText:function(node,text){while(node.firstChild){node.removeChild(node.firstChild);}node.appendChild(node.ownerDocument.createTextNode(text));},_populateGrid:function(){var _dbb=new this.dateClassObj(this.currentFocus);_dbb.setDate(1);_dbb=this._patchDate(_dbb);var _dbc=_dbb.getDay(),_dbd=this.dateModule.getDaysInMonth(_dbb),_dbe=this.dateModule.getDaysInMonth(this.dateModule.add(_dbb,"month",-1)),_dbf=new this.dateClassObj(),_dc0=this.dayOffset>=0?this.dayOffset:_dab.getFirstDayOfWeek(this.lang);if(_dc0>_dbc){_dc0-=7;}if(!this.summary){var _dc1=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_dbb);this.gridNode.setAttribute("summary",_dc1[_dbb.getMonth()]);}this._date2cell={};_da9.forEach(this.dateCells,function(_dc2,idx){var i=idx+_dc0;var date=new this.dateClassObj(_dbb),_dc3,_dc4="dijitCalendar",adj=0;if(i<_dbc){_dc3=_dbe-_dbc+i+1;adj=-1;_dc4+="Previous";}else{if(i>=(_dbc+_dbd)){_dc3=i-_dbc-_dbd+1;adj=1;_dc4+="Next";}else{_dc3=i-_dbc+1;_dc4+="Current";}}if(adj){date=this.dateModule.add(date,"month",adj);}date.setDate(_dc3);if(!this.dateModule.compare(date,_dbf,"date")){_dc4="dijitCalendarCurrentDate "+_dc4;}if(this.isDisabledDate(date,this.lang)){_dc4="dijitCalendarDisabledDate "+_dc4;_dc2.setAttribute("aria-disabled","true");}else{_dc4="dijitCalendarEnabledDate "+_dc4;_dc2.removeAttribute("aria-disabled");_dc2.setAttribute("aria-selected","false");}var _dc5=this.getClassForDate(date,this.lang);if(_dc5){_dc4=_dc5+" "+_dc4;}_dc2.className=_dc4+"Month dijitCalendarDateTemplate";var _dc6=date.valueOf();this._date2cell[_dc6]=_dc2;_dc2.dijitDateValue=_dc6;var _dc7=date.getDateLocalized?date.getDateLocalized(this.lang):date.getDate();this._setText(this.dateLabels[idx],_dc7);_daf.set(_dc2,"aria-label",_dac.format(date,{selector:"date",formatLength:"long"}));},this);},_populateControls:function(){var _dc8=new this.dateClassObj(this.currentFocus);_dc8.setDate(1);this.monthWidget.set("month",_dc8);var y=_dc8.getFullYear()-1;var d=new this.dateClassObj();_da9.forEach(["previous","current","next"],function(name){d.setFullYear(y++);this._setText(this[name+"YearLabelNode"],this.dateLocaleModule.format(d,{selector:"year",locale:this.lang}));},this);},goToToday:function(){this.set("value",new this.dateClassObj());},constructor:function(_dc9){this.dateModule=_dc9.datePackage?lang.getObject(_dc9.datePackage,false):date;this.dateClassObj=this.dateModule.Date||Date;this.dateLocaleModule=_dc9.datePackage?lang.getObject(_dc9.datePackage+".locale",false):_dac;},_createMonthWidget:function(){return _db4._MonthWidget({id:this.id+"_mddb",lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);},buildRendering:function(){var d=this.dowTemplateString,_dca=this.dateLocaleModule.getNames("days",this.dayWidth,"standAlone",this.lang),_dcb=this.dayOffset>=0?this.dayOffset:_dab.getFirstDayOfWeek(this.lang);this.dayCellsHtml=_db0.substitute([d,d,d,d,d,d,d].join(""),{d:""},function(){return _dca[_dcb++%7];});var r=_db0.substitute(this.weekTemplateString,{d:this.dateTemplateString});this.dateRowsHtml=[r,r,r,r,r,r].join("");this.dateCells=[];this.dateLabels=[];this.inherited(arguments);dom.setSelectable(this.domNode,false);var _dcc=new this.dateClassObj(this.currentFocus);this.monthWidget=this._createMonthWidget();this.set("currentFocus",_dcc,false);},postCreate:function(){this.inherited(arguments);this._connectControls();},_connectControls:function(){var _dcd=lang.hitch(this,function(_dce,part,_dcf){this[_dce].dojoClick=true;return on(this[_dce],"click",lang.hitch(this,function(){this._setCurrentFocusAttr(this.dateModule.add(this.currentFocus,part,_dcf));}));});this.own(_dcd("incrementMonth","month",1),_dcd("decrementMonth","month",-1),_dcd("nextYearLabelNode","year",1),_dcd("previousYearLabelNode","year",-1));},_setCurrentFocusAttr:function(date,_dd0){var _dd1=this.currentFocus,_dd2=this._getNodeByDate(_dd1);date=this._patchDate(date);this._set("currentFocus",date);if(!this._date2cell||this.dateModule.difference(_dd1,date,"month")!=0){this._populateGrid();this._populateControls();this._markSelectedDates([this.value]);}var _dd3=this._getNodeByDate(date);_dd3.setAttribute("tabIndex",this.tabIndex);if(this.focused||_dd0){_dd3.focus();}if(_dd2&&_dd2!=_dd3){if(has("webkit")){_dd2.setAttribute("tabIndex","-1");}else{_dd2.removeAttribute("tabIndex");}}},focus:function(){this._setCurrentFocusAttr(this.currentFocus,true);},_onDayClick:function(evt){evt.stopPropagation();evt.preventDefault();for(var node=evt.target;node&&!node.dijitDateValue&&node.dijitDateValue!==0;node=node.parentNode){}if(node&&!_dae.contains(node,"dijitCalendarDisabledDate")){this.set("value",node.dijitDateValue);}},_getNodeByDate:function(_dd4){_dd4=this._patchDate(_dd4);return _dd4&&this._date2cell?this._date2cell[_dd4.valueOf()]:null;},_markSelectedDates:function(_dd5){function mark(_dd6,cell){_dae.toggle(cell,"dijitCalendarSelectedDate",_dd6);cell.setAttribute("aria-selected",_dd6?"true":"false");};_da9.forEach(this._selectedCells||[],lang.partial(mark,false));this._selectedCells=_da9.filter(_da9.map(_dd5,this._getNodeByDate,this),function(n){return n;});_da9.forEach(this._selectedCells,lang.partial(mark,true));},onChange:function(){},isDisabledDate:function(){},getClassForDate:function(){}});_db4._MonthWidget=_daa("dijit.CalendarLite._MonthWidget",_db1,{_setMonthAttr:function(_dd7){var _dd8=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_dd7),_dd9=(has("ie")==6?"":"<div class='dijitSpacer'>"+_da9.map(_dd8,function(s){return "<div>"+s+"</div>";}).join("")+"</div>");this.domNode.innerHTML=_dd9+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_dd8[_dd7.getMonth()]+"</div>";}});return _db4;});},"dijit/form/DropDownButton":function(){define(["dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/query","../registry","../popup","./Button","../_Container","../_HasDropDown","dojo/text!./templates/DropDownButton.html","../a11yclick"],function(_dda,_ddb,lang,_ddc,_ddd,_dde,_ddf,_de0,_de1,_de2){return _dda("dijit.form.DropDownButton",[_ddf,_de0,_de1],{baseClass:"dijitDropDownButton",templateString:_de2,_fillContent:function(){var _de3=this.srcNodeRef;var dest=this.containerNode;if(_de3&&dest){while(_de3.hasChildNodes()){var _de4=_de3.firstChild;if(_de4.hasAttribute&&(_de4.hasAttribute("data-dojo-type")||_de4.hasAttribute("dojoType")||_de4.hasAttribute("data-"+_ddb._scopeName+"-type")||_de4.hasAttribute(_ddb._scopeName+"Type"))){this.dropDownContainer=this.ownerDocument.createElement("div");this.dropDownContainer.appendChild(_de4);}else{dest.appendChild(_de4);}}}},startup:function(){if(this._started){return;}if(!this.dropDown&&this.dropDownContainer){this.dropDown=_ddd.byNode(this.dropDownContainer.firstChild);delete this.dropDownContainer;}if(this.dropDown){_dde.hide(this.dropDown);}this.inherited(arguments);},isLoaded:function(){var _de5=this.dropDown;return (!!_de5&&(!_de5.href||_de5.isLoaded));},loadDropDown:function(_de6){var _de7=this.dropDown;var _de8=_de7.on("load",lang.hitch(this,function(){_de8.remove();_de6();}));_de7.refresh();},isFocusable:function(){return this.inherited(arguments)&&!this._mouseDown;}});});},"dijit/form/Button":function(){define(["require","dojo/_base/declare","dojo/dom-class","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/ready","./_FormWidget","./_ButtonMixin","dojo/text!./templates/Button.html","../a11yclick"],function(_de9,_dea,_deb,has,_dec,lang,_ded,_dee,_def,_df0){if(has("dijit-legacy-requires")){_ded(0,function(){var _df1=["dijit/form/DropDownButton","dijit/form/ComboButton","dijit/form/ToggleButton"];_de9(_df1);});}var _df2=_dea("dijit.form.Button"+(has("dojo-bidi")?"_NoBidi":""),[_dee,_def],{showLabel:true,iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitButton",templateString:_df0,_setValueAttr:"valueNode",_setNameAttr:function(name){if(this.valueNode){this.valueNode.setAttribute("name",name);}},postCreate:function(){this.inherited(arguments);this._setLabelFromContainer();},_setLabelFromContainer:function(){if(this.containerNode&&!this.label){this.label=lang.trim(this.containerNode.innerHTML);this.onLabelSet();}},_setShowLabelAttr:function(val){if(this.containerNode){_deb.toggle(this.containerNode,"dijitDisplayNone",!val);}this._set("showLabel",val);},setLabel:function(_df3){_dec.deprecated("dijit.form.Button.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_df3);},onLabelSet:function(){this.inherited(arguments);if(!this.showLabel&&!("title" in this.params)){this.titleNode.title=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");}}});if(has("dojo-bidi")){_df2=_dea("dijit.form.Button",_df2,{onLabelSet:function(){this.inherited(arguments);if(this.titleNode.title){this.applyTextDir(this.titleNode,this.titleNode.title);}},_setTextDirAttr:function(_df4){if(this._created&&this.textDir!=_df4){this._set("textDir",_df4);this._setLabelAttr(this.label);}}});}return _df2;});},"dijit/form/_ButtonMixin":function(){define(["dojo/_base/declare","dojo/dom","dojo/has","../registry"],function(_df5,dom,has,_df6){var _df7=_df5("dijit.form._ButtonMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{label:"",type:"button",__onClick:function(e){e.stopPropagation();e.preventDefault();if(!this.disabled){this.valueNode.click(e);}return false;},_onClick:function(e){if(this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.onClick(e)===false){e.preventDefault();}var _df8=e.defaultPrevented;if(!_df8&&this.type=="submit"&&!(this.valueNode||this.focusNode).form){for(var node=this.domNode;node.parentNode;node=node.parentNode){var _df9=_df6.byNode(node);if(_df9&&typeof _df9._onSubmit=="function"){_df9._onSubmit(e);e.preventDefault();_df8=true;break;}}}return !_df8;},postCreate:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},onClick:function(){return true;},_setLabelAttr:function(_dfa){this._set("label",_dfa);var _dfb=this.containerNode||this.focusNode;_dfb.innerHTML=_dfa;this.onLabelSet();},onLabelSet:function(){}});if(has("dojo-bidi")){_df7=_df5("dijit.form._ButtonMixin",_df7,{onLabelSet:function(){this.inherited(arguments);var _dfc=this.containerNode||this.focusNode;this.applyTextDir(_dfc);}});}return _df7;});},"dijit/form/_DateTimeTextBox":function(){define(["dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/_base/lang","./RangeBoundTextBox","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(date,_dfd,_dfe,_dff,lang,_e00,_e01,_e02){new Date("X");var _e03=_dff("dijit.form._DateTimeTextBox",[_e00,_e01],{templateString:_e02,hasDownArrow:true,cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},_unboundedConstraints:{},pattern:_dfd.regexp,datePackage:"",postMixInProperties:function(){this.inherited(arguments);this._set("type","text");},compare:function(val1,val2){var _e04=this._isInvalidDate(val1);var _e05=this._isInvalidDate(val2);if(_e04||_e05){return (_e04&&_e05)?0:(!_e04?1:-1);}var _e06=this.format(val1,this._unboundedConstraints),_e07=this.format(val2,this._unboundedConstraints),_e08=this.parse(_e06,this._unboundedConstraints),_e09=this.parse(_e07,this._unboundedConstraints);return _e06==_e07?0:date.compare(_e08,_e09,this._selector);},autoWidth:true,format:function(_e0a,_e0b){if(!_e0a){return "";}return this.dateLocaleModule.format(_e0a,_e0b);},"parse":function(_e0c,_e0d){return this.dateLocaleModule.parse(_e0c,_e0d)||(this._isEmpty(_e0c)?null:undefined);},serialize:function(val,_e0e){if(val.toGregorian){val=val.toGregorian();}return _dfe.toISOString(val,_e0e);},dropDownDefaultValue:new Date(),value:new Date(""),_blankValue:null,popupClass:"",_selector:"",constructor:function(_e0f){_e0f=_e0f||{};this.dateModule=_e0f.datePackage?lang.getObject(_e0f.datePackage,false):date;this.dateClassObj=this.dateModule.Date||Date;if(!(this.dateClassObj instanceof Date)){this.value=new this.dateClassObj(this.value);}this.dateLocaleModule=_e0f.datePackage?lang.getObject(_e0f.datePackage+".locale",false):_dfd;this._set("pattern",this.dateLocaleModule.regexp);this._invalidDate=this.constructor.prototype.value.toString();},buildRendering:function(){this.inherited(arguments);if(!this.hasDownArrow){this._buttonNode.style.display="none";}if(!this.hasDownArrow){this._buttonNode=this.domNode;this.baseClass+=" dijitComboBoxOpenOnClick";}},_setConstraintsAttr:function(_e10){_e10.selector=this._selector;_e10.fullYear=true;var _e11=_dfe.fromISOString;if(typeof _e10.min=="string"){_e10.min=_e11(_e10.min);if(!(this.dateClassObj instanceof Date)){_e10.min=new this.dateClassObj(_e10.min);}}if(typeof _e10.max=="string"){_e10.max=_e11(_e10.max);if(!(this.dateClassObj instanceof Date)){_e10.max=new this.dateClassObj(_e10.max);}}this.inherited(arguments);this._unboundedConstraints=lang.mixin({},this.constraints,{min:null,max:null});},_isDefinitelyOutOfRange:function(){var _e12=this.inherited(arguments);var _e13=false;var _e14;var _e15;var _e16;var _e17;var _e18;var _e19;if(_e12&&(this.constraints.min||this.constraints.max)){var _e1a=new RegExp(this._lastRegExp);_e14=_e1a.exec(this._lastInputEventValue);if(_e14!=null){_e15=_e14[3];if(this.constraints.min){_e19=this.constraints.min instanceof Date?this.constraints.min:new Date(String(this.constraints.min));minYear=_e19.getFullYear();_e16=parseInt((_e15+"9999").substr(0,4),10);_e13=_e16<minYear;}if(!_e13&&this.constraints.max){_e18=this.constraints.max instanceof Date?this.constraints.max:new Date(String(this.constraints.max));maxYear=_e18.getFullYear();_e17=parseInt((_e15+"0000").substr(0,4),10);_e13=_e17>maxYear;}_e12=_e13;}}return _e12;},_isInvalidDate:function(_e1b){return !_e1b||isNaN(_e1b)||typeof _e1b!="object"||_e1b.toString()==this._invalidDate;},_setValueAttr:function(_e1c,_e1d,_e1e){if(_e1c!==undefined){if(typeof _e1c=="string"){_e1c=_dfe.fromISOString(_e1c);}if(this._isInvalidDate(_e1c)){_e1c=null;}if(_e1c instanceof Date&&!(this.dateClassObj instanceof Date)){_e1c=new this.dateClassObj(_e1c);}}this.inherited(arguments,[_e1c,_e1d,_e1e]);if(this.value instanceof Date){this.filterString="";}if(_e1d!==false&&this.dropDown){this.dropDown.set("value",_e1c,false);}},_set:function(attr,_e1f){if(attr=="value"){if(_e1f instanceof Date&&!(this.dateClassObj instanceof Date)){_e1f=new this.dateClassObj(_e1f);}var _e20=this._get("value");if(_e20 instanceof this.dateClassObj&&this.compare(_e1f,_e20)==0){return;}}this.inherited(arguments);},_setDropDownDefaultValueAttr:function(val){if(this._isInvalidDate(val)){val=new this.dateClassObj();}this._set("dropDownDefaultValue",val);},openDropDown:function(_e21){if(this.dropDown){this.dropDown.destroy();}var _e22=lang.isString(this.popupClass)?lang.getObject(this.popupClass,false):this.popupClass,_e23=this,_e24=this.get("value");this.dropDown=new _e22({onChange:function(_e25){_e23.set("value",_e25,true);},id:this.id+"_popup",dir:_e23.dir,lang:_e23.lang,value:_e24,textDir:_e23.textDir,currentFocus:!this._isInvalidDate(_e24)?_e24:this.dropDownDefaultValue,constraints:_e23.constraints,filterString:_e23.filterString,datePackage:_e23.datePackage,isDisabledDate:function(date){return !_e23.rangeCheck(date,_e23.constraints);}});this.inherited(arguments);},_getDisplayedValueAttr:function(){return this.textbox.value;},_setDisplayedValueAttr:function(_e26,_e27){this._setValueAttr(this.parse(_e26,this.constraints),_e27,_e26);}});return _e03;});},"dijit/form/TimeTextBox":function(){define(["dojo/_base/declare","dojo/keys","dojo/query","dojo/_base/lang","../_TimePicker","./_DateTimeTextBox"],function(_e28,keys,_e29,lang,_e2a,_e2b){var _e2c=_e28("dijit.form.TimeTextBox",_e2b,{baseClass:"dijitTextBox dijitComboBox dijitTimeTextBox",popupClass:_e2a,_selector:"time",value:new Date(""),maxHeight:-1,openDropDown:function(_e2d){this.inherited(arguments);var _e2e=_e29(".dijitTimePickerItemSelected",this.dropDown.domNode),_e2f=this.dropDown.domNode.parentNode;if(_e2e[0]){_e2f.scrollTop=_e2e[0].offsetTop-(_e2f.clientHeight-_e2e[0].clientHeight)/2;}else{_e2f.scrollTop=(_e2f.scrollHeight-_e2f.clientHeight)/2;}this.dropDown.on("input",lang.hitch(this,function(){this.set("value",this.dropDown.get("value"),false);}));},_onInput:function(){this.inherited(arguments);var val=this.get("displayedValue");this.filterString=(val&&!this.parse(val,this.constraints))?val.toLowerCase():"";if(this._opened){this.closeDropDown();}this.openDropDown();}});return _e2c;});},"dijit/_TimePicker":function(){define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/query","dojo/mouse","dojo/on","./_WidgetBase","./form/_ListMouseMixin"],function(_e30,_e31,_e32,_e33,_e34,_e35,_e36,_e37,keys,lang,has,_e38,_e39,on,_e3a,_e3b){var _e3c=_e34("dijit._TimePicker",[_e3a,_e3b],{baseClass:"dijitTimePicker",pickerMin:"T00:00:00",pickerMax:"T23:59:59",clickableIncrement:"T00:15:00",visibleIncrement:"T01:00:00",value:new Date(),_visibleIncrement:2,_clickableIncrement:1,_totalIncrements:10,constraints:{},serialize:_e33.toISOString,buildRendering:function(){this.inherited(arguments);this.containerNode=this.domNode;this.timeMenu=this.domNode;},setValue:function(_e3d){_e37.deprecated("dijit._TimePicker:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");this.set("value",_e3d);},_setValueAttr:function(date){this._set("value",date);this._showText();},_setFilterStringAttr:function(val){this._set("filterString",val);this._showText();},isDisabledDate:function(){return false;},_getFilteredNodes:function(_e3e,_e3f,_e40,_e41){var _e42=this.ownerDocument.createDocumentFragment();for(var i=0;i<this._maxIncrement;i++){var n=this._createOption(i);if(n){_e42.appendChild(n);}}return _e42;},_showText:function(){var _e43=_e33.fromISOString;this.domNode.innerHTML="";this._clickableIncrementDate=_e43(this.clickableIncrement);this._visibleIncrementDate=_e43(this.visibleIncrement);var _e44=function(date){return date.getHours()*60*60+date.getMinutes()*60+date.getSeconds();},_e45=_e44(this._clickableIncrementDate),_e46=_e44(this._visibleIncrementDate),time=(this.value||this.currentFocus).getTime();this._refDate=_e43(this.pickerMin);this._refDate.setFullYear(1970,0,1);this._clickableIncrement=1;this._visibleIncrement=_e46/_e45;var _e47=_e43(this.pickerMax);_e47.setFullYear(1970,0,1);var _e48=(_e47.getTime()-this._refDate.getTime())*0.001;this._maxIncrement=Math.ceil((_e48+1)/_e45);var _e49=this._getFilteredNodes();if(!_e49.firstChild&&this.filterString){this.filterString="";this._showText();}else{this.domNode.appendChild(_e49);}},constructor:function(){this.constraints={};},postMixInProperties:function(){this.inherited(arguments);this._setConstraintsAttr(this.constraints);},_setConstraintsAttr:function(_e4a){for(var key in {clickableIncrement:1,visibleIncrement:1,pickerMin:1,pickerMax:1}){if(key in _e4a){this[key]=_e4a[key];}}if(!_e4a.locale){_e4a.locale=this.lang;}},_createOption:function(_e4b){var date=new Date(this._refDate);var _e4c=this._clickableIncrementDate;date.setHours(date.getHours()+_e4c.getHours()*_e4b,date.getMinutes()+_e4c.getMinutes()*_e4b,date.getSeconds()+_e4c.getSeconds()*_e4b);if(this.constraints.selector=="time"){date.setFullYear(1970,0,1);}var _e4d=_e32.format(date,this.constraints);if(this.filterString&&_e4d.toLowerCase().indexOf(this.filterString)!==0){return null;}var div=this.ownerDocument.createElement("div");div.className=this.baseClass+"Item";div.date=date;div.idx=_e4b;_e36.create("div",{"class":this.baseClass+"ItemInner",innerHTML:_e4d},div);var _e4e=_e4b%this._visibleIncrement<1&&_e4b%this._visibleIncrement>-1,tick=!_e4e&&!(_e4b%this._clickableIncrement);if(_e4e){div.className+=" "+this.baseClass+"Marker";}else{if(tick){div.className+=" "+this.baseClass+"Tick";}}if(this.isDisabledDate(date)){div.className+=" "+this.baseClass+"ItemDisabled";}if(this.value&&!_e31.compare(this.value,date,this.constraints.selector)){div.selected=true;div.className+=" "+this.baseClass+"ItemSelected";this._selectedDiv=div;if(_e4e){div.className+=" "+this.baseClass+"MarkerSelected";}else{if(tick){div.className+=" "+this.baseClass+"TickSelected";}}this._highlightOption(div,true);}return div;},onOpen:function(){this.inherited(arguments);this.set("selected",this._selectedDiv);},_onOptionSelected:function(tgt,_e4f){var _e50=tgt.target.date||tgt.target.parentNode.date;if(!_e50||this.isDisabledDate(_e50)){return;}this._set("value",_e50);this.emit("input");if(_e4f){this._highlighted_option=null;this.set("value",_e50);this.onChange(_e50);}},onChange:function(){},_highlightOption:function(node,_e51){if(!node){return;}if(_e51){if(this._highlighted_option){this._highlightOption(this._highlighted_option,false);}this._highlighted_option=node;}else{if(this._highlighted_option!==node){return;}else{this._highlighted_option=null;}}_e35.toggle(node,this.baseClass+"ItemHover",_e51);if(_e35.contains(node,this.baseClass+"Marker")){_e35.toggle(node,this.baseClass+"MarkerHover",_e51);}else{_e35.toggle(node,this.baseClass+"TickHover",_e51);}},handleKey:function(e){if(e.keyCode==keys.DOWN_ARROW){this.selectNextNode();this._onOptionSelected({target:this._highlighted_option},false);e.stopPropagation();e.preventDefault();return false;}else{if(e.keyCode==keys.UP_ARROW){this.selectPreviousNode();this._onOptionSelected({target:this._highlighted_option},false);e.stopPropagation();e.preventDefault();return false;}else{if(e.keyCode==keys.ENTER||e.keyCode===keys.TAB){if(!this._keyboardSelected&&e.keyCode===keys.TAB){return true;}if(this._highlighted_option){this._onOptionSelected({target:this._highlighted_option},true);}return e.keyCode===keys.TAB;}}}return undefined;},onHover:function(node){this._highlightOption(node,true);},onUnhover:function(node){this._highlightOption(node,false);},onSelect:function(node){this._highlightOption(node,true);},onDeselect:function(node){this._highlightOption(node,false);},onClick:function(node){this._onOptionSelected({target:node},true);}});return _e3c;});},"dijit/layout/AccordionContainer":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/topic","../focus","../_base/manager","dojo/ready","../_Widget","../_Container","../_TemplatedMixin","../_CssStateMixin","./StackContainer","./ContentPane","dojo/text!./templates/AccordionButton.html","../a11yclick"],function(_e52,_e53,_e54,fx,dom,_e55,_e56,_e57,_e58,keys,lang,has,_e59,_e5a,_e5b,_e5c,_e5d,_e5e,_e5f,_e60,_e61,_e62,_e63){function size(_e64,dim){_e64.resize?_e64.resize(dim):_e58.setMarginBox(_e64.domNode,dim);};var _e65=_e54("dijit.layout._AccordionButton",[_e5d,_e5f,_e60],{templateString:_e63,label:"",_setLabelAttr:{node:"titleTextNode",type:"innerHTML"},title:"",_setTitleAttr:{node:"titleTextNode",type:"attribute",attribute:"title"},iconClassAttr:"",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitAccordionTitle",getParent:function(){return this.parent;},buildRendering:function(){this.inherited(arguments);var _e66=this.id.replace(" ","_");_e55.set(this.titleTextNode,"id",_e66+"_title");this.focusNode.setAttribute("aria-labelledby",_e55.get(this.titleTextNode,"id"));dom.setSelectable(this.domNode,false);},getTitleHeight:function(){return _e58.getMarginSize(this.domNode).h;},_onTitleClick:function(){var _e67=this.getParent();_e67.selectChild(this.contentWidget,true);_e5a.focus(this.focusNode);},_onTitleKeyDown:function(evt){return this.getParent()._onKeyDown(evt,this.contentWidget);},_setSelectedAttr:function(_e68){this._set("selected",_e68);this.focusNode.setAttribute("aria-expanded",_e68?"true":"false");this.focusNode.setAttribute("aria-selected",_e68?"true":"false");this.focusNode.setAttribute("tabIndex",_e68?"0":"-1");}});if(has("dojo-bidi")){_e65.extend({_setLabelAttr:function(_e69){this._set("label",_e69);_e55.set(this.titleTextNode,"innerHTML",_e69);this.applyTextDir(this.titleTextNode);},_setTitleAttr:function(_e6a){this._set("title",_e6a);_e55.set(this.titleTextNode,"title",_e6a);this.applyTextDir(this.titleTextNode);}});}var _e6b=_e54("dijit.layout._AccordionInnerContainer"+(has("dojo-bidi")?"_NoBidi":""),[_e5d,_e60],{baseClass:"dijitAccordionInnerContainer",isLayoutContainer:true,buildRendering:function(){this.domNode=_e57.place("<div class='"+this.baseClass+"' role='presentation'>",this.contentWidget.domNode,"after");var _e6c=this.contentWidget,cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;this.button=_e6c._buttonWidget=(new cls({contentWidget:_e6c,label:_e6c.title,title:_e6c.tooltip,dir:_e6c.dir,lang:_e6c.lang,textDir:_e6c.textDir||this.textDir,iconClass:_e6c.iconClass,id:_e6c.id+"_button",parent:this.parent})).placeAt(this.domNode);this.containerNode=_e57.place("<div class='dijitAccordionChildWrapper' role='tabpanel' style='display:none'>",this.domNode);this.containerNode.setAttribute("aria-labelledby",this.button.id);_e57.place(this.contentWidget.domNode,this.containerNode);},postCreate:function(){this.inherited(arguments);var _e6d=this.button,cw=this.contentWidget;this._contentWidgetWatches=[cw.watch("title",lang.hitch(this,function(name,_e6e,_e6f){_e6d.set("label",_e6f);})),cw.watch("tooltip",lang.hitch(this,function(name,_e70,_e71){_e6d.set("title",_e71);})),cw.watch("iconClass",lang.hitch(this,function(name,_e72,_e73){_e6d.set("iconClass",_e73);}))];},_setSelectedAttr:function(_e74){this._set("selected",_e74);this.button.set("selected",_e74);if(_e74){var cw=this.contentWidget;if(cw.onSelected){cw.onSelected();}}},startup:function(){this.contentWidget.startup();},destroy:function(){this.button.destroyRecursive();_e53.forEach(this._contentWidgetWatches||[],function(w){w.unwatch();});delete this.contentWidget._buttonWidget;delete this.contentWidget._wrapperWidget;this.inherited(arguments);},destroyDescendants:function(_e75){this.contentWidget.destroyRecursive(_e75);}});if(has("dojo-bidi")){_e6b=_e54("dijit.layout._AccordionInnerContainer",_e6b,{postCreate:function(){this.inherited(arguments);var _e76=this.button;this._contentWidgetWatches.push(this.contentWidget.watch("textDir",function(name,_e77,_e78){_e76.set("textDir",_e78);}));}});}var _e79=_e54("dijit.layout.AccordionContainer",_e61,{duration:_e5b.defaultDuration,buttonWidget:_e65,baseClass:"dijitAccordionContainer",buildRendering:function(){this.inherited(arguments);this.domNode.style.overflow="hidden";this.domNode.setAttribute("role","tablist");},startup:function(){if(this._started){return;}this.inherited(arguments);if(this.selectedChildWidget){this.selectedChildWidget._wrapperWidget.set("selected",true);}},layout:function(){var _e7a=this.selectedChildWidget;if(!_e7a){return;}var _e7b=_e7a._wrapperWidget.domNode,_e7c=_e58.getMarginExtents(_e7b),_e7d=_e58.getPadBorderExtents(_e7b),_e7e=_e7a._wrapperWidget.containerNode,_e7f=_e58.getMarginExtents(_e7e),_e80=_e58.getPadBorderExtents(_e7e),_e81=this._contentBox;var _e82=0;_e53.forEach(this.getChildren(),function(_e83){if(_e83!=_e7a){_e82+=_e58.getMarginSize(_e83._wrapperWidget.domNode).h;}});this._verticalSpace=_e81.h-_e82-_e7c.h-_e7d.h-_e7f.h-_e80.h-_e7a._buttonWidget.getTitleHeight();this._containerContentBox={h:this._verticalSpace,w:this._contentBox.w-_e7c.w-_e7d.w-_e7f.w-_e80.w};if(_e7a){size(_e7a,this._containerContentBox);}},_setupChild:function(_e84){_e84._wrapperWidget=_e6b({contentWidget:_e84,buttonWidget:this.buttonWidget,id:_e84.id+"_wrapper",dir:_e84.dir,lang:_e84.lang,textDir:_e84.textDir||this.textDir,parent:this});this.inherited(arguments);_e57.place(_e84.domNode,_e84._wrapper,"replace");},removeChild:function(_e85){if(_e85._wrapperWidget){_e57.place(_e85.domNode,_e85._wrapperWidget.domNode,"after");_e85._wrapperWidget.destroy();delete _e85._wrapperWidget;}_e56.remove(_e85.domNode,"dijitHidden");this.inherited(arguments);},getChildren:function(){return _e53.map(this.inherited(arguments),function(_e86){return _e86.declaredClass=="dijit.layout._AccordionInnerContainer"?_e86.contentWidget:_e86;},this);},destroy:function(){if(this._animation){this._animation.stop();}_e53.forEach(this.getChildren(),function(_e87){if(_e87._wrapperWidget){_e87._wrapperWidget.destroy();}else{_e87.destroyRecursive();}});this.inherited(arguments);},_showChild:function(_e88){_e88._wrapperWidget.containerNode.style.display="block";return this.inherited(arguments);},_hideChild:function(_e89){_e89._wrapperWidget.containerNode.style.display="none";this.inherited(arguments);},_transition:function(_e8a,_e8b,_e8c){if(has("ie")<8){_e8c=false;}if(this._animation){this._animation.stop(true);delete this._animation;}var self=this;if(_e8a){_e8a._wrapperWidget.set("selected",true);var d=this._showChild(_e8a);if(this.doLayout){size(_e8a,this._containerContentBox);}}if(_e8b){_e8b._wrapperWidget.set("selected",false);if(!_e8c){this._hideChild(_e8b);}}if(_e8c){var _e8d=_e8a._wrapperWidget.containerNode,_e8e=_e8b._wrapperWidget.containerNode;var _e8f=_e8a._wrapperWidget.containerNode,_e90=_e58.getMarginExtents(_e8f),_e91=_e58.getPadBorderExtents(_e8f),_e92=_e90.h+_e91.h;_e8e.style.height=(self._verticalSpace-_e92)+"px";this._animation=new fx.Animation({node:_e8d,duration:this.duration,curve:[1,this._verticalSpace-_e92-1],onAnimate:function(_e93){_e93=Math.floor(_e93);_e8d.style.height=_e93+"px";_e8e.style.height=(self._verticalSpace-_e92-_e93)+"px";},onEnd:function(){delete self._animation;_e8d.style.height="auto";_e8b._wrapperWidget.containerNode.style.display="none";_e8e.style.height="auto";self._hideChild(_e8b);}});this._animation.onStop=this._animation.onEnd;this._animation.play();}return d;},_onKeyDown:function(e,_e94){if(this.disabled||e.altKey||!(_e94||e.ctrlKey)){return;}var c=e.keyCode;if((_e94&&(c==keys.LEFT_ARROW||c==keys.UP_ARROW))||(e.ctrlKey&&c==keys.PAGE_UP)){this._adjacent(false)._buttonWidget._onTitleClick();e.stopPropagation();e.preventDefault();}else{if((_e94&&(c==keys.RIGHT_ARROW||c==keys.DOWN_ARROW))||(e.ctrlKey&&(c==keys.PAGE_DOWN||c==keys.TAB))){this._adjacent(true)._buttonWidget._onTitleClick();e.stopPropagation();e.preventDefault();}}}});if(has("dijit-legacy-requires")){_e5c(0,function(){var _e95=["dijit/layout/AccordionPane"];_e52(_e95);});}_e79._InnerContainer=_e6b;_e79._Button=_e65;return _e79;});},"dijit/layout/StackContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/has","dojo/_base/lang","dojo/on","dojo/ready","dojo/topic","dojo/when","../registry","../_WidgetBase","./_LayoutWidget"],function(_e96,_e97,_e98,_e99,_e9a,has,lang,on,_e9b,_e9c,when,_e9d,_e9e,_e9f){if(has("dijit-legacy-requires")){_e9b(0,function(){var _ea0=["dijit/layout/StackController"];require(_ea0);});}var _ea1=_e98("dijit.layout.StackContainer",_e9f,{doLayout:true,persist:false,baseClass:"dijitStackContainer",buildRendering:function(){this.inherited(arguments);_e99.add(this.domNode,"dijitLayoutContainer");},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKeyDown")));},startup:function(){if(this._started){return;}var _ea2=this.getChildren();_e96.forEach(_ea2,this._setupChild,this);if(this.persist){this.selectedChildWidget=_e9d.byId(_e97(this.id+"_selectedChild"));}else{_e96.some(_ea2,function(_ea3){if(_ea3.selected){this.selectedChildWidget=_ea3;}return _ea3.selected;},this);}var _ea4=this.selectedChildWidget;if(!_ea4&&_ea2[0]){_ea4=this.selectedChildWidget=_ea2[0];_ea4.selected=true;}_e9c.publish(this.id+"-startup",{children:_ea2,selected:_ea4,textDir:this.textDir});this.inherited(arguments);},resize:function(){if(!this._hasBeenShown){this._hasBeenShown=true;var _ea5=this.selectedChildWidget;if(_ea5){this._showChild(_ea5);}}this.inherited(arguments);},_setupChild:function(_ea6){var _ea7=_ea6.domNode,_ea8=_e9a.place("<div role='tabpanel' class='"+this.baseClass+"ChildWrapper dijitHidden'>",_ea6.domNode,"replace"),_ea9=_ea6["aria-label"]||_ea6.title||_ea6.label;if(_ea9){_ea8.setAttribute("aria-label",_ea9);}_e9a.place(_ea7,_ea8);_ea6._wrapper=_ea8;this.inherited(arguments);if(_ea7.style.display=="none"){_ea7.style.display="block";}_ea6.domNode.removeAttribute("title");},addChild:function(_eaa,_eab){this.inherited(arguments);if(this._started){_e9c.publish(this.id+"-addChild",_eaa,_eab);this.layout();if(!this.selectedChildWidget){this.selectChild(_eaa);}}},removeChild:function(page){var idx=_e96.indexOf(this.getChildren(),page);this.inherited(arguments);_e9a.destroy(page._wrapper);delete page._wrapper;if(this._started){_e9c.publish(this.id+"-removeChild",page);}if(this._descendantsBeingDestroyed){return;}if(this.selectedChildWidget===page){this.selectedChildWidget=undefined;if(this._started){var _eac=this.getChildren();if(_eac.length){this.selectChild(_eac[Math.max(idx-1,0)]);}}}if(this._started){this.layout();}},selectChild:function(page,_ead){var d;page=_e9d.byId(page);if(this.selectedChildWidget!=page){d=this._transition(page,this.selectedChildWidget,_ead);this._set("selectedChildWidget",page);_e9c.publish(this.id+"-selectChild",page,this._focused);if(this.persist){_e97(this.id+"_selectedChild",this.selectedChildWidget.id);}}return when(d||true);},_transition:function(_eae,_eaf){if(_eaf){this._hideChild(_eaf);}var d=this._showChild(_eae);if(_eae.resize){if(this.doLayout){_eae.resize(this._containerContentBox||this._contentBox);}else{_eae.resize();}}return d;},_adjacent:function(_eb0){var _eb1=this.getChildren();var _eb2=_e96.indexOf(_eb1,this.selectedChildWidget);_eb2+=_eb0?1:_eb1.length-1;return _eb1[_eb2%_eb1.length];},forward:function(){return this.selectChild(this._adjacent(true),true);},back:function(){return this.selectChild(this._adjacent(false),true);},_onKeyDown:function(e){_e9c.publish(this.id+"-containerKeyDown",{e:e,page:this});},layout:function(){var _eb3=this.selectedChildWidget;if(_eb3&&_eb3.resize){if(this.doLayout){_eb3.resize(this._containerContentBox||this._contentBox);}else{_eb3.resize();}}},_showChild:function(page){var _eb4=this.getChildren();page.isFirstChild=(page==_eb4[0]);page.isLastChild=(page==_eb4[_eb4.length-1]);page._set("selected",true);if(page._wrapper){_e99.replace(page._wrapper,"dijitVisible","dijitHidden");}return (page._onShow&&page._onShow())||true;},_hideChild:function(page){page._set("selected",false);if(page._wrapper){_e99.replace(page._wrapper,"dijitHidden","dijitVisible");}page.onHide&&page.onHide();},closeChild:function(page){var _eb5=!page.onClose||page.onClose(this,page);if(_eb5){this.removeChild(page);page.destroyRecursive();}},destroyDescendants:function(_eb6){this._descendantsBeingDestroyed=true;this.selectedChildWidget=undefined;_e96.forEach(this.getChildren(),function(_eb7){if(!_eb6){this.removeChild(_eb7);}_eb7.destroyRecursive(_eb6);},this);this._descendantsBeingDestroyed=false;}});_ea1.ChildWidgetProperties={selected:false,disabled:false,closable:false,iconClass:"dijitNoIcon",showTitle:true};lang.extend(_e9e,_ea1.ChildWidgetProperties);return _ea1;});},"dojo/cookie":function(){define(["./_base/kernel","./regexp"],function(dojo,_eb8){dojo.cookie=function(name,_eb9,_eba){var c=document.cookie,ret;if(arguments.length==1){var _ebb=c.match(new RegExp("(?:^|; )"+_eb8.escapeString(name)+"=([^;]*)"));ret=_ebb?decodeURIComponent(_ebb[1]):undefined;}else{_eba=_eba||{};var exp=_eba.expires;if(typeof exp=="number"){var d=new Date();d.setTime(d.getTime()+exp*24*60*60*1000);exp=_eba.expires=d;}if(exp&&exp.toUTCString){_eba.expires=exp.toUTCString();}_eb9=encodeURIComponent(_eb9);var _ebc=name+"="+_eb9,_ebd;for(_ebd in _eba){_ebc+="; "+_ebd;var _ebe=_eba[_ebd];if(_ebe!==true){_ebc+="="+_ebe;}}document.cookie=_ebc;}return ret;};dojo.cookie.isSupported=function(){if(!("cookieEnabled" in navigator)){this("__djCookieTest__","CookiesAllowed");navigator.cookieEnabled=this("__djCookieTest__")=="CookiesAllowed";if(navigator.cookieEnabled){this("__djCookieTest__","",{expires:-1});}}return navigator.cookieEnabled;};return dojo.cookie;});},"dijit/layout/_LayoutWidget":function(){define(["dojo/_base/lang","../_Widget","../_Container","../_Contained","../Viewport","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style"],function(lang,_ebf,_ec0,_ec1,_ec2,_ec3,_ec4,_ec5,_ec6){return _ec3("dijit.layout._LayoutWidget",[_ebf,_ec0,_ec1],{baseClass:"dijitLayoutContainer",isLayoutContainer:true,_setTitleAttr:null,buildRendering:function(){this.inherited(arguments);_ec4.add(this.domNode,"dijitContainer");},startup:function(){if(this._started){return;}this.inherited(arguments);var _ec7=this.getParent&&this.getParent();if(!(_ec7&&_ec7.isLayoutContainer)){this.resize();this.own(_ec2.on("resize",lang.hitch(this,"resize")));}},resize:function(_ec8,_ec9){var node=this.domNode;if(_ec8){_ec5.setMarginBox(node,_ec8);}var mb=_ec9||{};lang.mixin(mb,_ec8||{});if(!("h" in mb)||!("w" in mb)){mb=lang.mixin(_ec5.getMarginBox(node),mb);}var cs=_ec6.getComputedStyle(node);var me=_ec5.getMarginExtents(node,cs);var be=_ec5.getBorderExtents(node,cs);var bb=(this._borderBox={w:mb.w-(me.w+be.w),h:mb.h-(me.h+be.h)});var pe=_ec5.getPadExtents(node,cs);this._contentBox={l:_ec6.toPixelValue(node,cs.paddingLeft),t:_ec6.toPixelValue(node,cs.paddingTop),w:bb.w-pe.w,h:bb.h-pe.h};this.layout();},layout:function(){},_setupChild:function(_eca){var cls=this.baseClass+"-child "+(_eca.baseClass?this.baseClass+"-"+_eca.baseClass:"");_ec4.add(_eca.domNode,cls);},addChild:function(_ecb,_ecc){this.inherited(arguments);if(this._started){this._setupChild(_ecb);}},removeChild:function(_ecd){var cls=this.baseClass+"-child"+(_ecd.baseClass?" "+this.baseClass+"-"+_ecd.baseClass:"");_ec4.remove(_ecd.domNode,cls);this.inherited(arguments);}});});},"dijit/form/Select":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/i18n","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","./_FormSelectWidget","../_HasDropDown","../DropDownMenu","../MenuItem","../MenuSeparator","../Tooltip","../_KeyNavMixin","../registry","dojo/text!./templates/Select.html","dojo/i18n!./nls/validate"],function(_ece,_ecf,_ed0,_ed1,_ed2,i18n,keys,lang,on,has,_ed3,_ed4,_ed5,_ed6,_ed7,_ed8,_ed9,_eda,_edb){var _edc=_ecf("dijit.form._SelectMenu",_ed5,{autoFocus:true,buildRendering:function(){this.inherited(arguments);this.domNode.setAttribute("role","listbox");},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"selectstart",function(evt){evt.preventDefault();evt.stopPropagation();}));},focus:function(){var _edd=false,val=this.parentWidget.value;if(lang.isArray(val)){val=val[val.length-1];}if(val){_ece.forEach(this.parentWidget._getChildren(),function(_ede){if(_ede.option&&(val===_ede.option.value)){_edd=true;this.focusChild(_ede,false);}},this);}if(!_edd){this.inherited(arguments);}}});var _edf=_ecf("dijit.form.Select"+(has("dojo-bidi")?"_NoBidi":""),[_ed3,_ed4,_ed9],{baseClass:"dijitSelect dijitValidationTextBox",templateString:_edb,_buttonInputDisabled:has("ie")?"disabled":"",required:false,state:"",message:"",tooltipPosition:[],emptyLabel:"&#160;",_isLoaded:false,_childrenLoaded:false,labelType:"html",_fillContent:function(){this.inherited(arguments);if(this.options.length&&!this.value&&this.srcNodeRef){var si=this.srcNodeRef.selectedIndex||0;this._set("value",this.options[si>=0?si:0].value);}this.dropDown=new _edc({id:this.id+"_menu",parentWidget:this});_ed1.add(this.dropDown.domNode,this.baseClass.replace(/\s+|$/g,"Menu "));},_getMenuItemForOption:function(_ee0){if(!_ee0.value&&!_ee0.label){return new _ed7({ownerDocument:this.ownerDocument});}else{var _ee1=lang.hitch(this,"_setValueAttr",_ee0);var item=new _ed6({option:_ee0,label:(this.labelType==="text"?(_ee0.label||"").toString().replace(/&/g,"&amp;").replace(/</g,"&lt;"):_ee0.label)||this.emptyLabel,onClick:_ee1,ownerDocument:this.ownerDocument,dir:this.dir,textDir:this.textDir,disabled:_ee0.disabled||false});item.focusNode.setAttribute("role","option");return item;}},_addOptionItem:function(_ee2){if(this.dropDown){this.dropDown.addChild(this._getMenuItemForOption(_ee2));}},_getChildren:function(){if(!this.dropDown){return [];}return this.dropDown.getChildren();},focus:function(){if(!this.disabled&&this.focusNode.focus){try{this.focusNode.focus();}catch(e){}}},focusChild:function(_ee3){if(_ee3){this.set("value",_ee3.option);}},_getFirst:function(){var _ee4=this._getChildren();return _ee4.length?_ee4[0]:null;},_getLast:function(){var _ee5=this._getChildren();return _ee5.length?_ee5[_ee5.length-1]:null;},childSelector:function(node){var node=_eda.byNode(node);return node&&node.getParent()==this.dropDown;},onKeyboardSearch:function(item,evt,_ee6,_ee7){if(item){this.focusChild(item);}},_loadChildren:function(_ee8){if(_ee8===true){if(this.dropDown){delete this.dropDown.focusedChild;this.focusedChild=null;}if(this.options.length){this.inherited(arguments);}else{_ece.forEach(this._getChildren(),function(_ee9){_ee9.destroyRecursive();});var item=new _ed6({ownerDocument:this.ownerDocument,label:this.emptyLabel});this.dropDown.addChild(item);}}else{this._updateSelection();}this._isLoaded=false;this._childrenLoaded=true;if(!this._loadingStore){this._setValueAttr(this.value,false);}},_refreshState:function(){if(this._started){this.validate(this.focused);}},startup:function(){this.inherited(arguments);this._refreshState();},_setValueAttr:function(_eea){this.inherited(arguments);_ed0.set(this.valueNode,"value",this.get("value"));this._refreshState();},_setNameAttr:"valueNode",_setDisabledAttr:function(_eeb){this.inherited(arguments);this._refreshState();},_setRequiredAttr:function(_eec){this._set("required",_eec);this.focusNode.setAttribute("aria-required",_eec);this._refreshState();},_setOptionsAttr:function(_eed){this._isLoaded=false;this._set("options",_eed);},_setDisplay:function(_eee){var lbl=(this.labelType==="text"?(_eee||"").replace(/&/g,"&amp;").replace(/</g,"&lt;"):_eee)||this.emptyLabel;this.containerNode.innerHTML="<span role=\"option\" aria-selected=\"true\" class=\"dijitReset dijitInline "+this.baseClass.replace(/\s+|$/g,"Label ")+"\">"+lbl+"</span>";},validate:function(_eef){var _ef0=this.disabled||this.isValid(_eef);this._set("state",_ef0?"":(this._hasBeenBlurred?"Error":"Incomplete"));this.focusNode.setAttribute("aria-invalid",_ef0?"false":"true");var _ef1=_ef0?"":this._missingMsg;if(_ef1&&this.focused&&this._hasBeenBlurred){_ed8.show(_ef1,this.domNode,this.tooltipPosition,!this.isLeftToRight());}else{_ed8.hide(this.domNode);}this._set("message",_ef1);return _ef0;},isValid:function(){return (!this.required||this.value===0||!(/^\s*$/.test(this.value||"")));},reset:function(){this.inherited(arguments);_ed8.hide(this.domNode);this._refreshState();},postMixInProperties:function(){this.inherited(arguments);this._missingMsg=i18n.getLocalization("dijit.form","validate",this.lang).missingMessage;},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"selectstart",function(evt){evt.preventDefault();evt.stopPropagation();}));this.domNode.setAttribute("aria-expanded","false");var _ef2=this._keyNavCodes;delete _ef2[keys.LEFT_ARROW];delete _ef2[keys.RIGHT_ARROW];},_setStyleAttr:function(_ef3){this.inherited(arguments);_ed1.toggle(this.domNode,this.baseClass.replace(/\s+|$/g,"FixedWidth "),!!this.domNode.style.width);},isLoaded:function(){return this._isLoaded;},loadDropDown:function(_ef4){this._loadChildren(true);this._isLoaded=true;_ef4();},destroy:function(_ef5){if(this.dropDown&&!this.dropDown._destroyed){this.dropDown.destroyRecursive(_ef5);delete this.dropDown;}_ed8.hide(this.domNode);this.inherited(arguments);},_onFocus:function(){this.validate(true);},_onBlur:function(){_ed8.hide(this.domNode);this.inherited(arguments);this.validate(false);}});if(has("dojo-bidi")){_edf=_ecf("dijit.form.Select",_edf,{_setDisplay:function(_ef6){this.inherited(arguments);this.applyTextDir(this.containerNode);}});}_edf._Menu=_edc;function _ef7(_ef8){return function(evt){if(!this._isLoaded){this.loadDropDown(lang.hitch(this,_ef8,evt));}else{this.inherited(_ef8,arguments);}};};_edf.prototype._onContainerKeydown=_ef7("_onContainerKeydown");_edf.prototype._onContainerKeypress=_ef7("_onContainerKeypress");return _edf;});},"dijit/form/_FormSelectWidget":function(){define(["dojo/_base/array","dojo/_base/Deferred","dojo/aspect","dojo/data/util/sorter","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/when","dojo/store/util/QueryResults","./_FormValueWidget"],function(_ef9,_efa,_efb,_efc,_efd,dom,_efe,_eff,lang,_f00,when,_f01,_f02){var _f03=_efd("dijit.form._FormSelectWidget",_f02,{multiple:false,options:null,store:null,_setStoreAttr:function(val){if(this._created){this._deprecatedSetStore(val);}},query:null,_setQueryAttr:function(_f04){if(this._created){this._deprecatedSetStore(this.store,this.selectedValue,{query:_f04});}},queryOptions:null,_setQueryOptionsAttr:function(_f05){if(this._created){this._deprecatedSetStore(this.store,this.selectedValue,{queryOptions:_f05});}},labelAttr:"",onFetch:null,sortByLabel:true,loadChildrenOnOpen:false,onLoadDeferred:null,getOptions:function(_f06){var opts=this.options||[];if(_f06==null){return opts;}if(lang.isArrayLike(_f06)){return _ef9.map(_f06,function(item){return this.getOptions(item);},this);}if(lang.isString(_f06)){_f06={value:_f06};}if(lang.isObject(_f06)){if(!_ef9.some(opts,function(_f07,idx){for(var a in _f06){if(!(a in _f07)||_f07[a]!=_f06[a]){return false;}}_f06=idx;return true;})){_f06=-1;}}if(_f06>=0&&_f06<opts.length){return opts[_f06];}return null;},addOption:function(_f08){_ef9.forEach(lang.isArrayLike(_f08)?_f08:[_f08],function(i){if(i&&lang.isObject(i)){this.options.push(i);}},this);this._loadChildren();},removeOption:function(_f09){var _f0a=this.getOptions(lang.isArrayLike(_f09)?_f09:[_f09]);_ef9.forEach(_f0a,function(_f0b){if(_f0b){this.options=_ef9.filter(this.options,function(node){return (node.value!==_f0b.value||node.label!==_f0b.label);});this._removeOptionItem(_f0b);}},this);this._loadChildren();},updateOption:function(_f0c){_ef9.forEach(lang.isArrayLike(_f0c)?_f0c:[_f0c],function(i){var _f0d=this.getOptions({value:i.value}),k;if(_f0d){for(k in i){_f0d[k]=i[k];}}},this);this._loadChildren();},setStore:function(_f0e,_f0f,_f10){_eff.deprecated(this.declaredClass+"::setStore(store, selectedValue, fetchArgs) is deprecated. Use set('query', fetchArgs.query), set('queryOptions', fetchArgs.queryOptions), set('store', store), or set('value', selectedValue) instead.","","2.0");this._deprecatedSetStore(_f0e,_f0f,_f10);},_deprecatedSetStore:function(_f11,_f12,_f13){var _f14=this.store;_f13=_f13||{};if(_f14!==_f11){var h;while((h=this._notifyConnections.pop())){h.remove();}if(!_f11.get){lang.mixin(_f11,{_oldAPI:true,get:function(id){var _f15=new _efa();this.fetchItemByIdentity({identity:id,onItem:function(_f16){_f15.resolve(_f16);},onError:function(_f17){_f15.reject(_f17);}});return _f15.promise;},query:function(_f18,_f19){var _f1a=new _efa(function(){if(_f1b.abort){_f1b.abort();}});_f1a.total=new _efa();var _f1b=this.fetch(lang.mixin({query:_f18,onBegin:function(_f1c){_f1a.total.resolve(_f1c);},onComplete:function(_f1d){_f1a.resolve(_f1d);},onError:function(_f1e){_f1a.reject(_f1e);}},_f19));return new _f01(_f1a);}});if(_f11.getFeatures()["dojo.data.api.Notification"]){this._notifyConnections=[_efb.after(_f11,"onNew",lang.hitch(this,"_onNewItem"),true),_efb.after(_f11,"onDelete",lang.hitch(this,"_onDeleteItem"),true),_efb.after(_f11,"onSet",lang.hitch(this,"_onSetItem"),true)];}}this._set("store",_f11);}if(this.options&&this.options.length){this.removeOption(this.options);}if(this._queryRes&&this._queryRes.close){this._queryRes.close();}if(this._observeHandle&&this._observeHandle.remove){this._observeHandle.remove();this._observeHandle=null;}if(_f13.query){this._set("query",_f13.query);}if(_f13.queryOptions){this._set("queryOptions",_f13.queryOptions);}if(_f11&&_f11.query){this._loadingStore=true;this.onLoadDeferred=new _efa();this._queryRes=_f11.query(this.query,this.queryOptions);when(this._queryRes,lang.hitch(this,function(_f1f){if(this.sortByLabel&&!_f13.sort&&_f1f.length){if(_f11.getValue){_f1f.sort(_efc.createSortFunction([{attribute:_f11.getLabelAttributes(_f1f[0])[0]}],_f11));}else{var _f20=this.labelAttr;_f1f.sort(function(a,b){return a[_f20]>b[_f20]?1:b[_f20]>a[_f20]?-1:0;});}}if(_f13.onFetch){_f1f=_f13.onFetch.call(this,_f1f,_f13);}_ef9.forEach(_f1f,function(i){this._addOptionForItem(i);},this);if(this._queryRes.observe){this._observeHandle=this._queryRes.observe(lang.hitch(this,function(_f21,_f22,_f23){if(_f22==_f23){this._onSetItem(_f21);}else{if(_f22!=-1){this._onDeleteItem(_f21);}if(_f23!=-1){this._onNewItem(_f21);}}}),true);}this._loadingStore=false;this.set("value","_pendingValue" in this?this._pendingValue:_f12);delete this._pendingValue;if(!this.loadChildrenOnOpen){this._loadChildren();}else{this._pseudoLoadChildren(_f1f);}this.onLoadDeferred.resolve(true);this.onSetStore();}),lang.hitch(this,function(err){console.error("dijit.form.Select: "+err.toString());this.onLoadDeferred.reject(err);}));}return _f14;},_setValueAttr:function(_f24,_f25){if(!this._onChangeActive){_f25=null;}if(this._loadingStore){this._pendingValue=_f24;return;}if(_f24==null){return;}if(lang.isArrayLike(_f24)){_f24=_ef9.map(_f24,function(_f26){return lang.isObject(_f26)?_f26:{value:_f26};});}else{if(lang.isObject(_f24)){_f24=[_f24];}else{_f24=[{value:_f24}];}}_f24=_ef9.filter(this.getOptions(_f24),function(i){return i&&i.value;});var opts=this.getOptions()||[];if(!this.multiple&&(!_f24[0]||!_f24[0].value)&&!!opts.length){_f24[0]=opts[0];}_ef9.forEach(opts,function(opt){opt.selected=_ef9.some(_f24,function(v){return v.value===opt.value;});});var val=_ef9.map(_f24,function(opt){return opt.value;});if(typeof val=="undefined"||typeof val[0]=="undefined"){return;}var disp=_ef9.map(_f24,function(opt){return opt.label;});this._setDisplay(this.multiple?disp:disp[0]);this.inherited(arguments,[this.multiple?val:val[0],_f25]);this._updateSelection();},_getDisplayedValueAttr:function(){var ret=_ef9.map([].concat(this.get("selectedOptions")),function(v){if(v&&"label" in v){return v.label;}else{if(v){return v.value;}}return null;},this);return this.multiple?ret:ret[0];},_setDisplayedValueAttr:function(_f27){this.set("value",this.getOptions(typeof _f27=="string"?{label:_f27}:_f27));},_loadChildren:function(){if(this._loadingStore){return;}_ef9.forEach(this._getChildren(),function(_f28){_f28.destroyRecursive();});_ef9.forEach(this.options,this._addOptionItem,this);this._updateSelection();},_updateSelection:function(){this.focusedChild=null;this._set("value",this._getValueFromOpts());var val=[].concat(this.value);if(val&&val[0]){var self=this;_ef9.forEach(this._getChildren(),function(_f29){var _f2a=_ef9.some(val,function(v){return _f29.option&&(v===_f29.option.value);});if(_f2a&&!self.multiple){self.focusedChild=_f29;}_efe.toggle(_f29.domNode,this.baseClass.replace(/\s+|$/g,"SelectedOption "),_f2a);_f29.domNode.setAttribute("aria-selected",_f2a?"true":"false");},this);}},_getValueFromOpts:function(){var opts=this.getOptions()||[];if(!this.multiple&&opts.length){var opt=_ef9.filter(opts,function(i){return i.selected;})[0];if(opt&&opt.value){return opt.value;}else{opts[0].selected=true;return opts[0].value;}}else{if(this.multiple){return _ef9.map(_ef9.filter(opts,function(i){return i.selected;}),function(i){return i.value;})||[];}}return "";},_onNewItem:function(item,_f2b){if(!_f2b||!_f2b.parent){this._addOptionForItem(item);}},_onDeleteItem:function(item){var _f2c=this.store;this.removeOption({value:_f2c.getIdentity(item)});},_onSetItem:function(item){this.updateOption(this._getOptionObjForItem(item));},_getOptionObjForItem:function(item){var _f2d=this.store,_f2e=(this.labelAttr&&this.labelAttr in item)?item[this.labelAttr]:_f2d.getLabel(item),_f2f=(_f2e?_f2d.getIdentity(item):null);return {value:_f2f,label:_f2e,item:item};},_addOptionForItem:function(item){var _f30=this.store;if(_f30.isItemLoaded&&!_f30.isItemLoaded(item)){_f30.loadItem({item:item,onItem:function(i){this._addOptionForItem(i);},scope:this});return;}var _f31=this._getOptionObjForItem(item);this.addOption(_f31);},constructor:function(_f32){this._oValue=(_f32||{}).value||null;this._notifyConnections=[];},buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},_fillContent:function(){if(!this.options){this.options=this.srcNodeRef?_f00("> *",this.srcNodeRef).map(function(node){if(node.getAttribute("type")==="separator"){return {value:"",label:"",selected:false,disabled:false};}return {value:(node.getAttribute("data-"+_eff._scopeName+"-value")||node.getAttribute("value")),label:String(node.innerHTML),selected:node.getAttribute("selected")||false,disabled:node.getAttribute("disabled")||false};},this):[];}if(!this.value){this._set("value",this._getValueFromOpts());}else{if(this.multiple&&typeof this.value=="string"){this._set("value",this.value.split(","));}}},postCreate:function(){this.inherited(arguments);_efb.after(this,"onChange",lang.hitch(this,"_updateSelection"));var _f33=this.store;if(_f33&&(_f33.getIdentity||_f33.getFeatures()["dojo.data.api.Identity"])){this.store=null;this._deprecatedSetStore(_f33,this._oValue,{query:this.query,queryOptions:this.queryOptions});}this._storeInitialized=true;},startup:function(){this._loadChildren();this.inherited(arguments);},destroy:function(){var h;while((h=this._notifyConnections.pop())){h.remove();}if(this._queryRes&&this._queryRes.close){this._queryRes.close();}if(this._observeHandle&&this._observeHandle.remove){this._observeHandle.remove();this._observeHandle=null;}this.inherited(arguments);},_addOptionItem:function(){},_removeOptionItem:function(){},_setDisplay:function(){},_getChildren:function(){return [];},_getSelectedOptionsAttr:function(){return this.getOptions({selected:true});},_pseudoLoadChildren:function(){},onSetStore:function(){}});return _f03;});},"dijit/DropDownMenu":function(){define(["dojo/_base/declare","dojo/keys","dojo/text!./templates/Menu.html","./_MenuBase"],function(_f34,keys,_f35,_f36){return _f34("dijit.DropDownMenu",_f36,{templateString:_f35,baseClass:"dijitMenu",_onUpArrow:function(){this.focusPrev();},_onDownArrow:function(){this.focusNext();},_onRightArrow:function(evt){this._moveToPopup(evt);evt.stopPropagation();evt.preventDefault();},_onLeftArrow:function(evt){if(this.parentMenu){if(this.parentMenu._isMenuBar){this.parentMenu.focusPrev();}else{this.onCancel(false);}}else{evt.stopPropagation();evt.preventDefault();}}});});},"dijit/_MenuBase":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/lang","dojo/mouse","dojo/on","dojo/window","./a11yclick","./registry","./_Widget","./_CssStateMixin","./_KeyNavContainer","./_TemplatedMixin"],function(_f37,_f38,dom,_f39,_f3a,lang,_f3b,on,_f3c,_f3d,_f3e,_f3f,_f40,_f41,_f42){return _f38("dijit._MenuBase",[_f3f,_f42,_f41,_f40],{selected:null,_setSelectedAttr:function(item){if(this.selected!=item){if(this.selected){this.selected._setSelected(false);this._onChildDeselect(this.selected);}if(item){item._setSelected(true);}this._set("selected",item);}},activated:false,_setActivatedAttr:function(val){_f3a.toggle(this.domNode,"dijitMenuActive",val);_f3a.toggle(this.domNode,"dijitMenuPassive",!val);this._set("activated",val);},parentMenu:null,popupDelay:500,passivePopupDelay:Infinity,autoFocus:false,childSelector:function(node){var _f43=_f3e.byNode(node);return node.parentNode==this.containerNode&&_f43&&_f43.focus;},postCreate:function(){var self=this,_f44=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");this.own(on(this.containerNode,on.selector(_f44,_f3b.enter),function(){self.onItemHover(_f3e.byNode(this));}),on(this.containerNode,on.selector(_f44,_f3b.leave),function(){self.onItemUnhover(_f3e.byNode(this));}),on(this.containerNode,on.selector(_f44,_f3d),function(evt){self.onItemClick(_f3e.byNode(this),evt);evt.stopPropagation();}),on(this.containerNode,on.selector(_f44,"focusin"),function(){self._onItemFocus(_f3e.byNode(this));}));this.inherited(arguments);},onKeyboardSearch:function(item,evt,_f45,_f46){this.inherited(arguments);if(!!item&&(_f46==-1||(!!item.popup&&_f46==1))){this.onItemClick(item,evt);}},_keyboardSearchCompare:function(item,_f47){if(!!item.shortcutKey){return _f47==item.shortcutKey.toLowerCase()?-1:0;}return this.inherited(arguments)?1:0;},onExecute:function(){},onCancel:function(){},_moveToPopup:function(evt){if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){this.onItemClick(this.focusedChild,evt);}else{var _f48=this._getTopMenu();if(_f48&&_f48._isMenuBar){_f48.focusNext();}}},_onPopupHover:function(){this.set("selected",this.currentPopupItem);this._stopPendingCloseTimer();},onItemHover:function(item){if(this.activated){this.set("selected",item);if(item.popup&&!item.disabled&&!this.hover_timer){this.hover_timer=this.defer(function(){this._openItemPopup(item);},this.popupDelay);}}else{if(this.passivePopupDelay<Infinity){if(this.passive_hover_timer){this.passive_hover_timer.remove();}this.passive_hover_timer=this.defer(function(){this.onItemClick(item,{type:"click"});},this.passivePopupDelay);}}this._hoveredChild=item;item._set("hovering",true);},_onChildDeselect:function(item){this._stopPopupTimer();if(this.currentPopupItem==item){this._stopPendingCloseTimer();this._pendingClose_timer=this.defer(function(){this._pendingClose_timer=null;this.currentPopupItem=null;item._closePopup();},this.popupDelay);}},onItemUnhover:function(item){if(this._hoveredChild==item){this._hoveredChild=null;}if(this.passive_hover_timer){this.passive_hover_timer.remove();this.passive_hover_timer=null;}item._set("hovering",false);},_stopPopupTimer:function(){if(this.hover_timer){this.hover_timer=this.hover_timer.remove();}},_stopPendingCloseTimer:function(){if(this._pendingClose_timer){this._pendingClose_timer=this._pendingClose_timer.remove();}},_getTopMenu:function(){for(var top=this;top.parentMenu;top=top.parentMenu){}return top;},onItemClick:function(item,evt){if(this.passive_hover_timer){this.passive_hover_timer.remove();}this.focusChild(item);if(item.disabled){return false;}if(item.popup){this.set("selected",item);this.set("activated",true);var _f49=/^key/.test(evt._origType||evt.type)||(evt.clientX==0&&evt.clientY==0);this._openItemPopup(item,_f49);}else{this.onExecute();item._onClick?item._onClick(evt):item.onClick(evt);}},_openItemPopup:function(_f4a,_f4b){if(_f4a==this.currentPopupItem){return;}if(this.currentPopupItem){this._stopPendingCloseTimer();this.currentPopupItem._closePopup();}this._stopPopupTimer();var _f4c=_f4a.popup;_f4c.parentMenu=this;this.own(this._mouseoverHandle=on.once(_f4c.domNode,"mouseover",lang.hitch(this,"_onPopupHover")));var self=this;_f4a._openPopup({parent:this,orient:this._orient||["after","before"],onCancel:function(){if(_f4b){self.focusChild(_f4a);}self._cleanUp();},onExecute:lang.hitch(this,"_cleanUp",true),onClose:function(){if(self._mouseoverHandle){self._mouseoverHandle.remove();delete self._mouseoverHandle;}}},_f4b);this.currentPopupItem=_f4a;},onOpen:function(){this.isShowingNow=true;this.set("activated",true);},onClose:function(){this.set("activated",false);this.set("selected",null);this.isShowingNow=false;this.parentMenu=null;},_closeChild:function(){this._stopPopupTimer();if(this.currentPopupItem){if(this.focused){_f39.set(this.selected.focusNode,"tabIndex",this.tabIndex);this.selected.focusNode.focus();}this.currentPopupItem._closePopup();this.currentPopupItem=null;}},_onItemFocus:function(item){if(this._hoveredChild&&this._hoveredChild!=item){this.onItemUnhover(this._hoveredChild);}this.set("selected",item);},_onBlur:function(){this._cleanUp(true);this.inherited(arguments);},_cleanUp:function(_f4d){this._closeChild();if(typeof this.isShowingNow=="undefined"){this.set("activated",false);}if(_f4d){this.set("selected",null);}}});});},"dijit/_KeyNavContainer":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/kernel","dojo/keys","dojo/_base/lang","./registry","./_Container","./_FocusMixin","./_KeyNavMixin"],function(_f4e,_f4f,_f50,_f51,keys,lang,_f52,_f53,_f54,_f55){return _f4f("dijit._KeyNavContainer",[_f54,_f55,_f53],{connectKeyNavHandlers:function(_f56,_f57){var _f58=(this._keyNavCodes={});var prev=lang.hitch(this,"focusPrev");var next=lang.hitch(this,"focusNext");_f4e.forEach(_f56,function(code){_f58[code]=prev;});_f4e.forEach(_f57,function(code){_f58[code]=next;});_f58[keys.HOME]=lang.hitch(this,"focusFirstChild");_f58[keys.END]=lang.hitch(this,"focusLastChild");},startupKeyNavChildren:function(){_f51.deprecated("startupKeyNavChildren() call no longer needed","","2.0");},startup:function(){this.inherited(arguments);_f4e.forEach(this.getChildren(),lang.hitch(this,"_startupChild"));},addChild:function(_f59,_f5a){this.inherited(arguments);this._startupChild(_f59);},_startupChild:function(_f5b){_f5b.set("tabIndex","-1");},_getFirst:function(){var _f5c=this.getChildren();return _f5c.length?_f5c[0]:null;},_getLast:function(){var _f5d=this.getChildren();return _f5d.length?_f5d[_f5d.length-1]:null;},focusNext:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,1));},focusPrev:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,-1),true);},childSelector:function(node){var node=_f52.byNode(node);return node&&node.getParent()==this;}});});},"dijit/_KeyNavMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/on","dijit/registry","dijit/_FocusMixin"],function(_f5e,_f5f,_f60,keys,lang,on,_f61,_f62){return _f5f("dijit._KeyNavMixin",_f62,{tabIndex:"0",childSelector:null,postCreate:function(){this.inherited(arguments);_f60.set(this.domNode,"tabIndex",this.tabIndex);if(!this._keyNavCodes){var _f63=this._keyNavCodes={};_f63[keys.HOME]=lang.hitch(this,"focusFirstChild");_f63[keys.END]=lang.hitch(this,"focusLastChild");_f63[this.isLeftToRight()?keys.LEFT_ARROW:keys.RIGHT_ARROW]=lang.hitch(this,"_onLeftArrow");_f63[this.isLeftToRight()?keys.RIGHT_ARROW:keys.LEFT_ARROW]=lang.hitch(this,"_onRightArrow");_f63[keys.UP_ARROW]=lang.hitch(this,"_onUpArrow");_f63[keys.DOWN_ARROW]=lang.hitch(this,"_onDownArrow");}var self=this,_f64=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");this.own(on(this.domNode,"keypress",lang.hitch(this,"_onContainerKeypress")),on(this.domNode,"keydown",lang.hitch(this,"_onContainerKeydown")),on(this.domNode,"focus",lang.hitch(this,"_onContainerFocus")),on(this.containerNode,on.selector(_f64,"focusin"),function(evt){self._onChildFocus(_f61.getEnclosingWidget(this),evt);}));},_onLeftArrow:function(){},_onRightArrow:function(){},_onUpArrow:function(){},_onDownArrow:function(){},focus:function(){this.focusFirstChild();},_getFirstFocusableChild:function(){return this._getNextFocusableChild(null,1);},_getLastFocusableChild:function(){return this._getNextFocusableChild(null,-1);},focusFirstChild:function(){this.focusChild(this._getFirstFocusableChild());},focusLastChild:function(){this.focusChild(this._getLastFocusableChild());},focusChild:function(_f65,last){if(!_f65){return;}if(this.focusedChild&&_f65!==this.focusedChild){this._onChildBlur(this.focusedChild);}_f65.set("tabIndex",this.tabIndex);_f65.focus(last?"end":"start");},_onContainerFocus:function(evt){if(evt.target!==this.domNode||this.focusedChild){return;}this.focus();},_onFocus:function(){_f60.set(this.domNode,"tabIndex","-1");this.inherited(arguments);},_onBlur:function(evt){_f60.set(this.domNode,"tabIndex",this.tabIndex);if(this.focusedChild){this.focusedChild.set("tabIndex","-1");this.lastFocusedChild=this.focusedChild;this._set("focusedChild",null);}this.inherited(arguments);},_onChildFocus:function(_f66){if(_f66&&_f66!=this.focusedChild){if(this.focusedChild&&!this.focusedChild._destroyed){this.focusedChild.set("tabIndex","-1");}_f66.set("tabIndex",this.tabIndex);this.lastFocused=_f66;this._set("focusedChild",_f66);}},_searchString:"",multiCharSearchDuration:1000,onKeyboardSearch:function(item,evt,_f67,_f68){if(item){this.focusChild(item);}},_keyboardSearchCompare:function(item,_f69){var _f6a=item.domNode,text=item.label||(_f6a.focusNode?_f6a.focusNode.label:"")||_f6a.innerText||_f6a.textContent||"",_f6b=text.replace(/^\s+/,"").substr(0,_f69.length).toLowerCase();return (!!_f69.length&&_f6b==_f69)?-1:0;},_onContainerKeydown:function(evt){var func=this._keyNavCodes[evt.keyCode];if(func){func(evt,this.focusedChild);evt.stopPropagation();evt.preventDefault();this._searchString="";}else{if(evt.keyCode==keys.SPACE&&this._searchTimer&&!(evt.ctrlKey||evt.altKey||evt.metaKey)){evt.stopImmediatePropagation();evt.preventDefault();this._keyboardSearch(evt," ");}}},_onContainerKeypress:function(evt){if(evt.charCode<=keys.SPACE||evt.ctrlKey||evt.altKey||evt.metaKey){return;}evt.preventDefault();evt.stopPropagation();this._keyboardSearch(evt,String.fromCharCode(evt.charCode).toLowerCase());},_keyboardSearch:function(evt,_f6c){var _f6d=null,_f6e,_f6f=0,_f70=lang.hitch(this,function(){if(this._searchTimer){this._searchTimer.remove();}this._searchString+=_f6c;var _f71=/^(.)\1*$/.test(this._searchString);var _f72=_f71?1:this._searchString.length;_f6e=this._searchString.substr(0,_f72);this._searchTimer=this.defer(function(){this._searchTimer=null;this._searchString="";},this.multiCharSearchDuration);var _f73=this.focusedChild||null;if(_f72==1||!_f73){_f73=this._getNextFocusableChild(_f73,1);if(!_f73){return;}}var stop=_f73;do{var rc=this._keyboardSearchCompare(_f73,_f6e);if(!!rc&&_f6f++==0){_f6d=_f73;}if(rc==-1){_f6f=-1;break;}_f73=this._getNextFocusableChild(_f73,1);}while(_f73&&_f73!=stop);});_f70();this.onKeyboardSearch(_f6d,evt,_f6e,_f6f);},_onChildBlur:function(){},_getNextFocusableChild:function(_f74,dir){var _f75=_f74;do{if(!_f74){_f74=this[dir>0?"_getFirst":"_getLast"]();if(!_f74){break;}}else{_f74=this._getNext(_f74,dir);}if(_f74!=null&&_f74!=_f75&&_f74.isFocusable()){return _f74;}}while(_f74!=_f75);return null;},_getFirst:function(){return null;},_getLast:function(){return null;},_getNext:function(_f76,dir){if(_f76){_f76=_f76.domNode;while(_f76){_f76=_f76[dir<0?"previousSibling":"nextSibling"];if(_f76&&"getAttribute" in _f76){var w=_f61.byNode(_f76);if(w){return w;}}}}return null;}});});},"dijit/MenuSeparator":function(){define(["dojo/_base/declare","dojo/dom","./_WidgetBase","./_TemplatedMixin","./_Contained","dojo/text!./templates/MenuSeparator.html"],function(_f77,dom,_f78,_f79,_f7a,_f7b){return _f77("dijit.MenuSeparator",[_f78,_f79,_f7a],{templateString:_f7b,buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/form/RadioButton":function(){define(["dojo/_base/declare","./CheckBox","./_RadioButtonMixin"],function(_f7c,_f7d,_f7e){return _f7c("dijit.form.RadioButton",[_f7d,_f7e],{baseClass:"dijitRadio"});});},"dijit/form/CheckBox":function(){define(["require","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/query","dojo/ready","./ToggleButton","./_CheckBoxMixin","dojo/text!./templates/CheckBox.html","dojo/NodeList-dom","../a11yclick"],function(_f7f,_f80,_f81,has,_f82,_f83,_f84,_f85,_f86){if(has("dijit-legacy-requires")){_f83(0,function(){var _f87=["dijit/form/RadioButton"];_f7f(_f87);});}return _f80("dijit.form.CheckBox",[_f84,_f85],{templateString:_f86,baseClass:"dijitCheckBox",_setValueAttr:function(_f88,_f89){if(typeof _f88=="string"){this.inherited(arguments);_f88=true;}if(this._created){this.set("checked",_f88,_f89);}},_getValueAttr:function(){return this.checked&&this._get("value");},_setIconClassAttr:null,_setNameAttr:"focusNode",postMixInProperties:function(){this.inherited(arguments);this.checkedAttrSetting="";},_fillContent:function(){},_onFocus:function(){if(this.id){_f82("label[for='"+this.id+"']").addClass("dijitFocusedLabel");}this.inherited(arguments);},_onBlur:function(){if(this.id){_f82("label[for='"+this.id+"']").removeClass("dijitFocusedLabel");}this.inherited(arguments);}});});},"dijit/form/ToggleButton":function(){define(["dojo/_base/declare","dojo/_base/kernel","./Button","./_ToggleButtonMixin"],function(_f8a,_f8b,_f8c,_f8d){return _f8a("dijit.form.ToggleButton",[_f8c,_f8d],{baseClass:"dijitToggleButton",setChecked:function(_f8e){_f8b.deprecated("setChecked("+_f8e+") is deprecated. Use set('checked',"+_f8e+") instead.","","2.0");this.set("checked",_f8e);}});});},"dijit/form/_ToggleButtonMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_f8f,_f90){return _f8f("dijit.form._ToggleButtonMixin",null,{checked:false,_aria_attr:"aria-pressed",_onClick:function(evt){var _f91=this.checked;this._set("checked",!_f91);var ret=this.inherited(arguments);this.set("checked",ret?this.checked:_f91);return ret;},_setCheckedAttr:function(_f92,_f93){this._set("checked",_f92);var node=this.focusNode||this.domNode;if(this._created){if(_f90.get(node,"checked")!=!!_f92){_f90.set(node,"checked",!!_f92);}}node.setAttribute(this._aria_attr,String(_f92));this._handleOnChange(_f92,_f93);},postCreate:function(){this.inherited(arguments);var node=this.focusNode||this.domNode;if(this.checked){node.setAttribute("checked","checked");}if(this._resetValue===undefined){this._lastValueReported=this._resetValue=this.checked;}},reset:function(){this._hasBeenBlurred=false;this.set("checked",this.params.checked||false);}});});},"dijit/form/_CheckBoxMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_f94,_f95){return _f94("dijit.form._CheckBoxMixin",null,{type:"checkbox",value:"on",readOnly:false,_aria_attr:"aria-checked",_setReadOnlyAttr:function(_f96){this._set("readOnly",_f96);_f95.set(this.focusNode,"readOnly",_f96);},_setLabelAttr:undefined,_getSubmitValue:function(_f97){return (_f97==null||_f97==="")?"on":_f97;},_setValueAttr:function(_f98){_f98=this._getSubmitValue(_f98);this._set("value",_f98);_f95.set(this.focusNode,"value",_f98);},reset:function(){this.inherited(arguments);this._set("value",this._getSubmitValue(this.params.value));_f95.set(this.focusNode,"value",this.value);},_onClick:function(e){if(this.readOnly){e.stopPropagation();e.preventDefault();return false;}return this.inherited(arguments);}});});},"dijit/form/_RadioButtonMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/lang","dojo/query!css2","../registry"],function(_f99,_f9a,_f9b,lang,_f9c,_f9d){return _f9a("dijit.form._RadioButtonMixin",null,{type:"radio",_getRelatedWidgets:function(){var ary=[];_f9c("input[type=radio]",this.focusNode.form||this.ownerDocument).forEach(lang.hitch(this,function(_f9e){if(_f9e.name==this.name&&_f9e.form==this.focusNode.form){var _f9f=_f9d.getEnclosingWidget(_f9e);if(_f9f){ary.push(_f9f);}}}));return ary;},_setCheckedAttr:function(_fa0){this.inherited(arguments);if(!this._created){return;}if(_fa0){_f99.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_fa1){if(_fa1!=this&&_fa1.checked){_fa1.set("checked",false);}}));}},_getSubmitValue:function(_fa2){return _fa2==null?"on":_fa2;},_onClick:function(e){if(this.checked||this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.readOnly){e.stopPropagation();e.preventDefault();_f99.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_fa3){_f9b.set(this.focusNode||this.domNode,"checked",_fa3.checked);}));return false;}var _fa4=false;var _fa5;_f99.some(this._getRelatedWidgets(),function(_fa6){if(_fa6.checked){_fa5=_fa6;return true;}return false;});this.checked=true;_fa5&&(_fa5.checked=false);if(this.onClick(e)===false||e.defaultPrevented){_fa4=true;}this.checked=false;_fa5&&(_fa5.checked=true);if(_fa4){e.preventDefault();}else{this.set("checked",true);}return !_fa4;}});});},"dojox/html/ellipsis":function(){define("dojox/html/ellipsis",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojo/colors"],function(d){if(d.isFF<7){var _fa7=1;if("dojoxFFEllipsisDelay" in d.config){_fa7=Number(d.config.dojoxFFEllipsisDelay);if(isNaN(_fa7)){_fa7=1;}}try{var _fa8=(function(){var sNS="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";var xml=document.createElementNS(sNS,"window");var _fa9=document.createElementNS(sNS,"description");_fa9.setAttribute("crop","end");xml.appendChild(_fa9);return function(n){var x=xml.cloneNode(true);x.firstChild.setAttribute("value",n.textContent);n.innerHTML="";n.appendChild(x);};})();}catch(e){}var _faa=d.create;var dd=d.doc;var dp=d.place;var _fab=_faa("iframe",{className:"dojoxEllipsisIFrame",src:"javascript:'<html><head><script>if(\"loadFirebugConsole\" in window){window.loadFirebugConsole();}</script></head><body></body></html>'",style:{display:"none"}});var _fac=function(r,cnt){if(r.collapsed){return;}if(cnt>0){do{_fac(r);cnt--;}while(cnt);return;}if(r.endContainer.nodeType==3&&r.endOffset>0){r.setEnd(r.endContainer,r.endOffset-1);}else{if(r.endContainer.nodeType==3){r.setEndBefore(r.endContainer);_fac(r);return;}else{if(r.endOffset&&r.endContainer.childNodes.length>=r.endOffset){var _fad=r.endContainer.childNodes[r.endOffset-1];if(_fad.nodeType==3){r.setEnd(_fad,_fad.length-1);}else{if(_fad.childNodes.length){r.setEnd(_fad,_fad.childNodes.length);_fac(r);return;}else{r.setEndBefore(_fad);_fac(r);return;}}}else{r.setEndBefore(r.endContainer);_fac(r);return;}}}};var _fae=function(n){var c=_faa("div",{className:"dojoxEllipsisContainer"});var e=_faa("div",{className:"dojoxEllipsisShown",style:{display:"none"}});n.parentNode.replaceChild(c,n);c.appendChild(n);c.appendChild(e);var i=_fab.cloneNode(true);var ns=n.style;var es=e.style;var _faf;var _fb0=function(){ns.display="";es.display="none";if(n.scrollWidth<=n.offsetWidth){return;}var r=dd.createRange();r.selectNodeContents(n);ns.display="none";es.display="";var done=false;do{var _fb1=1;dp(r.cloneContents(),e,"only");var sw=e.scrollWidth,ow=e.offsetWidth;done=(sw<=ow);var pct=(1-((ow*1)/sw));if(pct>0){_fb1=Math.max(Math.round(e.textContent.length*pct)-1,1);}_fac(r,_fb1);}while(!r.collapsed&&!done);};i.onload=function(){i.contentWindow.onresize=_fb0;_fb0();};c.appendChild(i);};var hc=d.hasClass;var doc=d.doc;var s,fn,opt;if(doc.querySelectorAll){s=doc;fn="querySelectorAll";opt=".dojoxEllipsis";}else{if(doc.getElementsByClassName){s=doc;fn="getElementsByClassName";opt="dojoxEllipsis";}else{s=d;fn="query";opt=".dojoxEllipsis";}}fx=function(){d.forEach(s[fn].apply(s,[opt]),function(n){if(!n||n._djx_ellipsis_done){return;}n._djx_ellipsis_done=true;if(_fa8&&n.textContent==n.innerHTML&&!hc(n,"dojoxEllipsisSelectable")){_fa8(n);}else{_fae(n);}});};d.addOnLoad(function(){var t=null;var c=null;var _fb2=function(){if(c){d.disconnect(c);c=null;}if(t){clearTimeout(t);}t=setTimeout(function(){t=null;fx();c=d.connect(d.body(),"DOMSubtreeModified",_fb2);},_fa7);};_fb2();});}});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_fb3,_fb4){var _fb5={};lang.setObject("dojo.colors",_fb5);var _fb6=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_fb3.fromRgb=function(_fb7,obj){var m=_fb7.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_fb4.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _fb3.fromArray(a,obj);}return _fb3.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_fb6(m1,m2,H+1/3)*256,_fb6(m1,m2,H)*256,_fb6(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _fb3.fromArray(a,obj);}}return null;};var _fb8=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_fb3.prototype.sanitize=function(){var t=this;t.r=Math.round(_fb8(t.r,0,255));t.g=Math.round(_fb8(t.g,0,255));t.b=Math.round(_fb8(t.b,0,255));t.a=_fb8(t.a,0,1);return this;};_fb5.makeGrey=_fb3.makeGrey=function(g,a){return _fb3.fromArray([g,g,g,a]);};lang.mixin(_fb3.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _fb3;});},"dojox/grid/cells/dijit":function(){define(["dojo/_base/kernel","../../main","dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/_base/json","dojo/_base/connect","dojo/_base/sniff","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/dom-style","dojo/dom-geometry","dojo/data/ItemFileReadStore","dijit/form/DateTextBox","dijit/form/TimeTextBox","dijit/form/ComboBox","dijit/form/CheckBox","dijit/form/TextBox","dijit/form/NumberSpinner","dijit/form/NumberTextBox","dijit/form/CurrencyTextBox","dijit/form/HorizontalSlider","dijit/form/_TextBoxMixin","dijit/Editor","../util","./_base"],function(dojo,_fb9,_fba,_fbb,lang,json,_fbc,has,dom,_fbd,_fbe,_fbf,_fc0,_fc1,_fc2,_fc3,_fc4,_fc5,_fc6,_fc7,_fc8,_fc9,_fca,_fcb,_fcc,util,_fcd){var _fce={};var _fcf=_fce._Widget=_fba("dojox.grid.cells._Widget",_fcd,{widgetClass:_fc6,constructor:function(_fd0){this.widget=null;if(typeof this.widgetClass=="string"){dojo.deprecated("Passing a string to widgetClass is deprecated","pass the widget class object instead","2.0");this.widgetClass=lang.getObject(this.widgetClass);}},formatEditing:function(_fd1,_fd2){this.needFormatNode(_fd1,_fd2);return "<div></div>";},getValue:function(_fd3){return this.widget.get("value");},_unescapeHTML:function(_fd4){return (_fd4&&_fd4.replace&&this.grid.escapeHTMLInData)?_fd4.replace(/&lt;/g,"<").replace(/&amp;/g,"&"):_fd4;},setValue:function(_fd5,_fd6){if(this.widget&&this.widget.set){_fd6=this._unescapeHTML(_fd6);if(this.widget.onLoadDeferred){var self=this;this.widget.onLoadDeferred.addCallback(function(){self.widget.set("value",_fd6===null?"":_fd6);});}else{this.widget.set("value",_fd6);}}else{this.inherited(arguments);}},getWidgetProps:function(_fd7){return lang.mixin({dir:this.dir,lang:this.lang},this.widgetProps||{},{constraints:lang.mixin({},this.constraint)||{},required:(this.constraint||{}).required,value:this._unescapeHTML(_fd7)});},createWidget:function(_fd8,_fd9,_fda){return new this.widgetClass(this.getWidgetProps(_fd9),_fd8);},attachWidget:function(_fdb,_fdc,_fdd){_fdb.appendChild(this.widget.domNode);this.setValue(_fdd,_fdc);},formatNode:function(_fde,_fdf,_fe0){if(!this.widgetClass){return _fdf;}if(!this.widget){this.widget=this.createWidget.apply(this,arguments);}else{this.attachWidget.apply(this,arguments);}this.sizeWidget.apply(this,arguments);this.grid.views.renormalizeRow(_fe0);this.grid.scroller.rowHeightChanged(_fe0,true);this.focus();return undefined;},sizeWidget:function(_fe1,_fe2,_fe3){var p=this.getNode(_fe3);dojo.marginBox(this.widget.domNode,{w:_fbf.get(p,"width")});},focus:function(_fe4,_fe5){if(this.widget){setTimeout(lang.hitch(this.widget,function(){util.fire(this,"focus");if(this.focusNode&&this.focusNode.tagName==="INPUT"){_fcb.selectInputText(this.focusNode);}}),0);}},_finish:function(_fe6){this.inherited(arguments);util.removeNode(this.widget.domNode);if(has("ie")){dom.setSelectable(this.widget.domNode,true);}}});_fcf.markupFactory=function(node,cell){_fcd.markupFactory(node,cell);var _fe7=lang.trim(_fbd.get(node,"widgetProps")||"");var _fe8=lang.trim(_fbd.get(node,"constraint")||"");var _fe9=lang.trim(_fbd.get(node,"widgetClass")||"");if(_fe7){cell.widgetProps=json.fromJson(_fe7);}if(_fe8){cell.constraint=json.fromJson(_fe8);}if(_fe9){cell.widgetClass=lang.getObject(_fe9);}};var _fc4=_fce.ComboBox=_fba("dojox.grid.cells.ComboBox",_fcf,{widgetClass:_fc4,getWidgetProps:function(_fea){var _feb=[];_fbb.forEach(this.options,function(o){_feb.push({name:o,value:o});});var _fec=new _fc1({data:{identifier:"name",items:_feb}});return lang.mixin({},this.widgetProps||{},{value:_fea,store:_fec});},getValue:function(){var e=this.widget;e.set("displayedValue",e.get("displayedValue"));return e.get("value");}});_fc4.markupFactory=function(node,cell){_fcf.markupFactory(node,cell);var _fed=lang.trim(_fbd.get(node,"options")||"");if(_fed){var o=_fed.split(",");if(o[0]!=_fed){cell.options=o;}}};var _fc2=_fce.DateTextBox=_fba("dojox.grid.cells.DateTextBox",_fcf,{widgetClass:_fc2,setValue:function(_fee,_fef){if(this.widget){this.widget.set("value",new Date(_fef));}else{this.inherited(arguments);}},getWidgetProps:function(_ff0){return lang.mixin(this.inherited(arguments),{value:new Date(_ff0)});}});_fc2.markupFactory=function(node,cell){_fcf.markupFactory(node,cell);};var _fc5=_fce.CheckBox=_fba("dojox.grid.cells.CheckBox",_fcf,{widgetClass:_fc5,getValue:function(){return this.widget.checked;},setValue:function(_ff1,_ff2){if(this.widget&&this.widget.attributeMap.checked){this.widget.set("checked",_ff2);}else{this.inherited(arguments);}},sizeWidget:function(_ff3,_ff4,_ff5){return;}});_fc5.markupFactory=function(node,cell){_fcf.markupFactory(node,cell);};var _fcc=_fce.Editor=_fba("dojox.grid.cells.Editor",_fcf,{widgetClass:_fcc,getWidgetProps:function(_ff6){return lang.mixin({},this.widgetProps||{},{height:this.widgetHeight||"100px"});},createWidget:function(_ff7,_ff8,_ff9){var _ffa=new this.widgetClass(this.getWidgetProps(_ff8),_ff7);_ffa.onLoadDeferred.then(lang.hitch(this,"populateEditor"));return _ffa;},formatNode:function(_ffb,_ffc,_ffd){this.content=_ffc;this.inherited(arguments);if(has("mozilla")){var e=this.widget;e.open();if(this.widgetToolbar){_fbe.place(e.toolbar.domNode,e.editingArea,"before");}}},populateEditor:function(){this.widget.set("value",this.content);this.widget.placeCursorAtEnd();}});_fcc.markupFactory=function(node,cell){_fcf.markupFactory(node,cell);var h=lang.trim(_fbd.get(node,"widgetHeight")||"");if(h){if((h!="auto")&&(h.substr(-2)!="em")){h=parseInt(h,10)+"px";}cell.widgetHeight=h;}};return _fce;});},"dijit/form/NumberSpinner":function(){define(["dojo/_base/declare","dojo/keys","./_Spinner","./NumberTextBox"],function(_ffe,keys,_fff,_1000){return _ffe("dijit.form.NumberSpinner",[_fff,_1000.Mixin],{baseClass:"dijitTextBox dijitSpinner dijitNumberTextBox",adjust:function(val,delta){var tc=this.constraints,v=isNaN(val),_1001=!isNaN(tc.max),_1002=!isNaN(tc.min);if(v&&delta!=0){val=(delta>0)?_1002?tc.min:_1001?tc.max:0:_1001?this.constraints.max:_1002?tc.min:0;}var _1003=val+delta;if(v||isNaN(_1003)){return val;}if(_1001&&(_1003>tc.max)){_1003=tc.max;}if(_1002&&(_1003<tc.min)){_1003=tc.min;}return _1003;},_onKeyDown:function(e){if(this.disabled||this.readOnly){return;}if((e.keyCode==keys.HOME||e.keyCode==keys.END)&&!(e.ctrlKey||e.altKey||e.metaKey)&&typeof this.get("value")!="undefined"){var value=this.constraints[(e.keyCode==keys.HOME?"min":"max")];if(typeof value=="number"){this._setValueAttr(value,false);}e.stopPropagation();e.preventDefault();}}});});},"dijit/form/_Spinner":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/mouse","dojo/on","../typematic","./RangeBoundTextBox","dojo/text!./templates/Spinner.html","./_TextBoxMixin"],function(_1004,keys,lang,has,mouse,on,_1005,_1006,_1007,_1008){return _1004("dijit.form._Spinner",_1006,{defaultTimeout:500,minimumTimeout:10,timeoutChangeRate:0.9,smallDelta:1,largeDelta:10,templateString:_1007,baseClass:"dijitTextBox dijitSpinner",cssStateNodes:{"upArrowNode":"dijitUpArrowButton","downArrowNode":"dijitDownArrowButton"},adjust:function(val){return val;},_arrowPressed:function(_1009,_100a,_100b){if(this.disabled||this.readOnly){return;}this._setValueAttr(this.adjust(this.get("value"),_100a*_100b),false);_1008.selectInputText(this.textbox,this.textbox.value.length);},_arrowReleased:function(){this._wheelTimer=null;},_typematicCallback:function(count,node,evt){var inc=this.smallDelta;if(node==this.textbox){var key=evt.keyCode;inc=(key==keys.PAGE_UP||key==keys.PAGE_DOWN)?this.largeDelta:this.smallDelta;node=(key==keys.UP_ARROW||key==keys.PAGE_UP)?this.upArrowNode:this.downArrowNode;}if(count==-1){this._arrowReleased(node);}else{this._arrowPressed(node,(node==this.upArrowNode)?1:-1,inc);}},_wheelTimer:null,_mouseWheeled:function(evt){if(!this.focused){return;}evt.stopPropagation();evt.preventDefault();var _100c=evt.wheelDelta/120;if(Math.floor(_100c)!=_100c){_100c=evt.wheelDelta>0?1:-1;}var _100d=evt.detail?(evt.detail*-1):_100c;if(_100d!==0){var node=this[(_100d>0?"upArrowNode":"downArrowNode")];this._arrowPressed(node,_100d,this.smallDelta);if(this._wheelTimer){this._wheelTimer.remove();}this._wheelTimer=this.defer(function(){this._arrowReleased(node);},50);}},_setConstraintsAttr:function(_100e){this.inherited(arguments);if(this.focusNode){if(this.constraints.min!==undefined){this.focusNode.setAttribute("aria-valuemin",this.constraints.min);}else{this.focusNode.removeAttribute("aria-valuemin");}if(this.constraints.max!==undefined){this.focusNode.setAttribute("aria-valuemax",this.constraints.max);}else{this.focusNode.removeAttribute("aria-valuemax");}}},_setValueAttr:function(value,_100f){this.focusNode.setAttribute("aria-valuenow",value);this.inherited(arguments);},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,mouse.wheel,lang.hitch(this,"_mouseWheeled")),_1005.addListener(this.upArrowNode,this.textbox,{keyCode:keys.UP_ARROW,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_1005.addListener(this.downArrowNode,this.textbox,{keyCode:keys.DOWN_ARROW,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_1005.addListener(this.upArrowNode,this.textbox,{keyCode:keys.PAGE_UP,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_1005.addListener(this.downArrowNode,this.textbox,{keyCode:keys.PAGE_DOWN,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout));}});});},"dijit/typematic":function(){define(["dojo/_base/array","dojo/_base/connect","dojo/_base/lang","dojo/on","dojo/sniff","./main"],function(array,_1010,lang,on,has,dijit){var _1011=(dijit.typematic={_fireEventAndReload:function(){this._timer=null;this._callback(++this._count,this._node,this._evt);this._currentTimeout=Math.max(this._currentTimeout<0?this._initialDelay:(this._subsequentDelay>1?this._subsequentDelay:Math.round(this._currentTimeout*this._subsequentDelay)),this._minDelay);this._timer=setTimeout(lang.hitch(this,"_fireEventAndReload"),this._currentTimeout);},trigger:function(evt,_1012,node,_1013,obj,_1014,_1015,_1016){if(obj!=this._obj){this.stop();this._initialDelay=_1015||500;this._subsequentDelay=_1014||0.9;this._minDelay=_1016||10;this._obj=obj;this._node=node;this._currentTimeout=-1;this._count=-1;this._callback=lang.hitch(_1012,_1013);this._evt={faux:true};for(var attr in evt){if(attr!="layerX"&&attr!="layerY"){var v=evt[attr];if(typeof v!="function"&&typeof v!="undefined"){this._evt[attr]=v;}}}this._fireEventAndReload();}},stop:function(){if(this._timer){clearTimeout(this._timer);this._timer=null;}if(this._obj){this._callback(-1,this._node,this._evt);this._obj=null;}},addKeyListener:function(node,_1017,_1018,_1019,_101a,_101b,_101c){var type="keyCode" in _1017?"keydown":"charCode" in _1017?"keypress":_1010._keypress,attr="keyCode" in _1017?"keyCode":"charCode" in _1017?"charCode":"charOrCode";var _101d=[on(node,type,lang.hitch(this,function(evt){if(evt[attr]==_1017[attr]&&(_1017.ctrlKey===undefined||_1017.ctrlKey==evt.ctrlKey)&&(_1017.altKey===undefined||_1017.altKey==evt.altKey)&&(_1017.metaKey===undefined||_1017.metaKey==(evt.metaKey||false))&&(_1017.shiftKey===undefined||_1017.shiftKey==evt.shiftKey)){evt.stopPropagation();evt.preventDefault();_1011.trigger(evt,_1018,node,_1019,_1017,_101a,_101b,_101c);}else{if(_1011._obj==_1017){_1011.stop();}}})),on(node,"keyup",lang.hitch(this,function(){if(_1011._obj==_1017){_1011.stop();}}))];return {remove:function(){array.forEach(_101d,function(h){h.remove();});}};},addMouseListener:function(node,_101e,_101f,_1020,_1021,_1022){var _1023=[on(node,"mousedown",lang.hitch(this,function(evt){evt.preventDefault();_1011.trigger(evt,_101e,node,_101f,node,_1020,_1021,_1022);})),on(node,"mouseup",lang.hitch(this,function(evt){if(this._obj){evt.preventDefault();}_1011.stop();})),on(node,"mouseout",lang.hitch(this,function(evt){if(this._obj){evt.preventDefault();}_1011.stop();})),on(node,"dblclick",lang.hitch(this,function(evt){evt.preventDefault();if(has("ie")<9){_1011.trigger(evt,_101e,node,_101f,node,_1020,_1021,_1022);setTimeout(lang.hitch(this,_1011.stop),50);}}))];return {remove:function(){array.forEach(_1023,function(h){h.remove();});}};},addListener:function(_1024,_1025,_1026,_1027,_1028,_1029,_102a,_102b){var _102c=[this.addKeyListener(_1025,_1026,_1027,_1028,_1029,_102a,_102b),this.addMouseListener(_1024,_1027,_1028,_1029,_102a,_102b)];return {remove:function(){array.forEach(_102c,function(h){h.remove();});}};}});return _1011;});},"dijit/form/CurrencyTextBox":function(){define(["dojo/currency","dojo/_base/declare","dojo/_base/lang","./NumberTextBox"],function(_102d,_102e,lang,_102f){var _1030=_102e("dijit.form.CurrencyTextBox",_102f,{currency:"",baseClass:"dijitTextBox dijitCurrencyTextBox",_formatter:_102d.format,_parser:_102d.parse,_regExpGenerator:_102d.regexp,parse:function(value,_1031){var v=this.inherited(arguments);if(isNaN(v)&&/\d+/.test(value)){v=lang.hitch(lang.delegate(this,{_parser:_102f.prototype._parser}),"inherited")(arguments);}return v;},_setConstraintsAttr:function(_1032){if(!_1032.currency&&this.currency){_1032.currency=this.currency;}this.inherited(arguments,[_102d._mixInDefaults(lang.mixin(_1032,{exponent:false}))]);}});return _1030;});},"dojo/currency":function(){define(["./_base/array","./_base/lang","./number","./i18n","./i18n!./cldr/nls/currency","./cldr/monetary"],function(_1033,lang,_1034,i18n,_1035,_1036){var _1037={};lang.setObject("dojo.currency",_1037);_1037._mixInDefaults=function(_1038){_1038=_1038||{};_1038.type="currency";var _1039=i18n.getLocalization("dojo.cldr","currency",_1038.locale)||{};var iso=_1038.currency;var data=_1036.getData(iso);_1033.forEach(["displayName","symbol","group","decimal"],function(prop){data[prop]=_1039[iso+"_"+prop];});data.fractional=[true,false];return lang.mixin(data,_1038);};_1037.format=function(value,_103a){return _1034.format(value,_1037._mixInDefaults(_103a));};_1037.regexp=function(_103b){return _1034.regexp(_1037._mixInDefaults(_103b));};_1037.parse=function(_103c,_103d){return _1034.parse(_103c,_1037._mixInDefaults(_103d));};return _1037;});},"dojo/cldr/monetary":function(){define(["../_base/kernel","../_base/lang"],function(dojo,lang){var _103e={};lang.setObject("dojo.cldr.monetary",_103e);_103e.getData=function(code){var _103f={ADP:0,AFN:0,ALL:0,AMD:0,BHD:3,BIF:0,BYR:0,CLF:0,CLP:0,COP:2,CRC:0,DJF:0,ESP:0,GNF:0,GYD:0,HUF:0,IDR:0,IQD:0,IRR:3,ISK:0,ITL:0,JOD:3,JPY:0,KMF:0,KPW:0,KRW:0,KWD:3,LAK:0,LBP:0,LUF:0,LYD:3,MGA:0,MGF:0,MMK:0,MNT:0,MRO:0,MUR:0,OMR:3,PKR:2,PYG:0,RSD:0,RWF:0,SLL:0,SOS:0,STD:0,SYP:0,TMM:0,TND:3,TRL:0,TZS:0,UGX:0,UZS:0,VND:0,VUV:0,XAF:0,XOF:0,XPF:0,YER:0,ZMK:0,ZWD:0};var _1040={};var _1041=_103f[code],round=_1040[code];if(typeof _1041=="undefined"){_1041=2;}if(typeof round=="undefined"){round=0;}return {places:_1041,round:round};};return _103e;});},"dijit/form/HorizontalSlider":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dnd/move","dojo/_base/fx","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/dnd/Moveable","dojo/dnd/Mover","dojo/query","dojo/mouse","dojo/on","../_base/manager","../focus","../typematic","./Button","./_FormValueWidget","../_Container","dojo/text!./templates/HorizontalSlider.html"],function(array,_1042,move,fx,_1043,_1044,keys,lang,has,_1045,Mover,query,mouse,on,_1046,focus,_1047,_1048,_1049,_104a,_104b){var _104c=_1042("dijit.form._SliderMover",Mover,{onMouseMove:function(e){var _104d=this.widget;var _104e=_104d._abspos;if(!_104e){_104e=_104d._abspos=_1043.position(_104d.sliderBarContainer,true);_104d._setPixelValue_=lang.hitch(_104d,"_setPixelValue");_104d._isReversed_=_104d._isReversed();}var _104f=e[_104d._mousePixelCoord]-_104e[_104d._startingPixelCoord];_104d._setPixelValue_(_104d._isReversed_?(_104e[_104d._pixelCount]-_104f):_104f,_104e[_104d._pixelCount],false);},destroy:function(e){Mover.prototype.destroy.apply(this,arguments);var _1050=this.widget;_1050._abspos=null;_1050._setValueAttr(_1050.value,true);}});var _1051=_1042("dijit.form.HorizontalSlider",[_1049,_104a],{templateString:_104b,value:0,showButtons:true,minimum:0,maximum:100,discreteValues:Infinity,pageIncrement:2,clickSelect:true,slideDuration:_1046.defaultDuration,_setIdAttr:"",_setNameAttr:"valueNode",baseClass:"dijitSlider",cssStateNodes:{incrementButton:"dijitSliderIncrementButton",decrementButton:"dijitSliderDecrementButton",focusNode:"dijitSliderThumb"},_mousePixelCoord:"pageX",_pixelCount:"w",_startingPixelCoord:"x",_handleOffsetCoord:"left",_progressPixelSize:"width",_onKeyUp:function(e){if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){return;}this._setValueAttr(this.value,true);},_onKeyDown:function(e){if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){return;}switch(e.keyCode){case keys.HOME:this._setValueAttr(this.minimum,false);break;case keys.END:this._setValueAttr(this.maximum,false);break;case ((this._descending||this.isLeftToRight())?keys.RIGHT_ARROW:keys.LEFT_ARROW):case (this._descending===false?keys.DOWN_ARROW:keys.UP_ARROW):case (this._descending===false?keys.PAGE_DOWN:keys.PAGE_UP):this.increment(e);break;case ((this._descending||this.isLeftToRight())?keys.LEFT_ARROW:keys.RIGHT_ARROW):case (this._descending===false?keys.UP_ARROW:keys.DOWN_ARROW):case (this._descending===false?keys.PAGE_UP:keys.PAGE_DOWN):this.decrement(e);break;default:return;}e.stopPropagation();e.preventDefault();},_onHandleClick:function(e){if(this.disabled||this.readOnly){return;}if(!has("ie")){focus.focus(this.sliderHandle);}e.stopPropagation();e.preventDefault();},_isReversed:function(){return !this.isLeftToRight();},_onBarClick:function(e){if(this.disabled||this.readOnly||!this.clickSelect){return;}focus.focus(this.sliderHandle);e.stopPropagation();e.preventDefault();var _1052=_1043.position(this.sliderBarContainer,true);var _1053=e[this._mousePixelCoord]-_1052[this._startingPixelCoord];this._setPixelValue(this._isReversed()?(_1052[this._pixelCount]-_1053):_1053,_1052[this._pixelCount],true);this._movable.onMouseDown(e);},_setPixelValue:function(_1054,_1055,_1056){if(this.disabled||this.readOnly){return;}var count=this.discreteValues;if(count<=1||count==Infinity){count=_1055;}count--;var _1057=_1055/count;var _1058=Math.round(_1054/_1057);this._setValueAttr(Math.max(Math.min((this.maximum-this.minimum)*_1058/count+this.minimum,this.maximum),this.minimum),_1056);},_setValueAttr:function(value,_1059){this._set("value",value);this.valueNode.value=value;this.focusNode.setAttribute("aria-valuenow",value);this.inherited(arguments);var _105a=this.maximum>this.minimum?((value-this.minimum)/(this.maximum-this.minimum)):0;var _105b=(this._descending===false)?this.remainingBar:this.progressBar;var _105c=(this._descending===false)?this.progressBar:this.remainingBar;if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){this._inProgressAnim.stop(true);}if(_1059&&this.slideDuration>0&&_105b.style[this._progressPixelSize]){var _105d=this;var props={};var start=parseFloat(_105b.style[this._progressPixelSize]);var _105e=this.slideDuration*(_105a-start/100);if(_105e==0){return;}if(_105e<0){_105e=0-_105e;}props[this._progressPixelSize]={start:start,end:_105a*100,units:"%"};this._inProgressAnim=fx.animateProperty({node:_105b,duration:_105e,onAnimate:function(v){_105c.style[_105d._progressPixelSize]=(100-parseFloat(v[_105d._progressPixelSize]))+"%";},onEnd:function(){delete _105d._inProgressAnim;},properties:props});this._inProgressAnim.play();}else{_105b.style[this._progressPixelSize]=(_105a*100)+"%";_105c.style[this._progressPixelSize]=((1-_105a)*100)+"%";}},_bumpValue:function(_105f,_1060){if(this.disabled||this.readOnly||(this.maximum<=this.minimum)){return;}var s=_1044.getComputedStyle(this.sliderBarContainer);var c=_1043.getContentBox(this.sliderBarContainer,s);var count=this.discreteValues;if(count<=1||count==Infinity){count=c[this._pixelCount];}count--;var value=Math.round((this.value-this.minimum)*count/(this.maximum-this.minimum))+_105f;if(value<0){value=0;}if(value>count){value=count;}value=value*(this.maximum-this.minimum)/count+this.minimum;this._setValueAttr(value,_1060);},_onClkBumper:function(val){if(this.disabled||this.readOnly||!this.clickSelect){return;}this._setValueAttr(val,true);},_onClkIncBumper:function(){this._onClkBumper(this._descending===false?this.minimum:this.maximum);},_onClkDecBumper:function(){this._onClkBumper(this._descending===false?this.maximum:this.minimum);},decrement:function(e){this._bumpValue(e.keyCode==keys.PAGE_DOWN?-this.pageIncrement:-1);},increment:function(e){this._bumpValue(e.keyCode==keys.PAGE_UP?this.pageIncrement:1);},_mouseWheeled:function(evt){if(!this.focused){return;}evt.stopPropagation();evt.preventDefault();this._bumpValue(evt.wheelDelta<0?-1:1,true);},startup:function(){if(this._started){return;}array.forEach(this.getChildren(),function(child){if(this[child.container]!=this.containerNode){this[child.container].appendChild(child.domNode);}},this);this.inherited(arguments);},_typematicCallback:function(count,_1061,e){if(count==-1){this._setValueAttr(this.value,true);}else{this[(_1061==(this._descending?this.incrementButton:this.decrementButton))?"decrement":"increment"](e);}},buildRendering:function(){this.inherited(arguments);if(this.showButtons){this.incrementButton.style.display="";this.decrementButton.style.display="";}var label=query("label[for=\""+this.id+"\"]");if(label.length){if(!label[0].id){label[0].id=this.id+"_label";}this.focusNode.setAttribute("aria-labelledby",label[0].id);}this.focusNode.setAttribute("aria-valuemin",this.minimum);this.focusNode.setAttribute("aria-valuemax",this.maximum);},postCreate:function(){this.inherited(arguments);if(this.showButtons){this.own(_1047.addMouseListener(this.decrementButton,this,"_typematicCallback",25,500),_1047.addMouseListener(this.incrementButton,this,"_typematicCallback",25,500));}this.own(on(this.domNode,mouse.wheel,lang.hitch(this,"_mouseWheeled")));var mover=_1042(_104c,{widget:this});this._movable=new _1045(this.sliderHandle,{mover:mover});this._layoutHackIE7();},destroy:function(){this._movable.destroy();if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){this._inProgressAnim.stop(true);}this.inherited(arguments);}});_1051._Mover=_104c;return _1051;});},"dojo/dnd/move":function(){define(["../_base/declare","../dom-geometry","../dom-style","./common","./Mover","./Moveable"],function(_1062,_1063,_1064,dnd,Mover,_1065){var _1066=_1062("dojo.dnd.move.constrainedMoveable",_1065,{constraints:function(){},within:false,constructor:function(node,_1067){if(!_1067){_1067={};}this.constraints=_1067.constraints;this.within=_1067.within;},onFirstMove:function(mover){var c=this.constraintBox=this.constraints.call(this,mover);c.r=c.l+c.w;c.b=c.t+c.h;if(this.within){var mb=_1063.getMarginSize(mover.node);c.r-=mb.w;c.b-=mb.h;}},onMove:function(mover,_1068){var c=this.constraintBox,s=mover.node.style;this.onMoving(mover,_1068);_1068.l=_1068.l<c.l?c.l:c.r<_1068.l?c.r:_1068.l;_1068.t=_1068.t<c.t?c.t:c.b<_1068.t?c.b:_1068.t;s.left=_1068.l+"px";s.top=_1068.t+"px";this.onMoved(mover,_1068);}});var _1069=_1062("dojo.dnd.move.boxConstrainedMoveable",_1066,{box:{},constructor:function(node,_106a){var box=_106a&&_106a.box;this.constraints=function(){return box;};}});var _106b=_1062("dojo.dnd.move.parentConstrainedMoveable",_1066,{area:"content",constructor:function(node,_106c){var area=_106c&&_106c.area;this.constraints=function(){var n=this.node.parentNode,s=_1064.getComputedStyle(n),mb=_1063.getMarginBox(n,s);if(area=="margin"){return mb;}var t=_1063.getMarginExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="border"){return mb;}t=_1063.getBorderExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="padding"){return mb;}t=_1063.getPadExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;return mb;};}});return {constrainedMoveable:_1066,boxConstrainedMoveable:_1069,parentConstrainedMoveable:_106b};});},"dijit/Editor":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/Deferred","dojo/i18n","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/string","dojo/topic","./_Container","./Toolbar","./ToolbarSeparator","./layout/_LayoutWidget","./form/ToggleButton","./_editor/_Plugin","./_editor/plugins/EnterKeyHandling","./_editor/html","./_editor/range","./_editor/RichText","./main","dojo/i18n!./_editor/nls/commands"],function(_106d,array,_106e,_106f,i18n,_1070,_1071,_1072,_1073,keys,lang,has,_1074,topic,_1075,_1076,_1077,_1078,_1079,_107a,_107b,html,_107c,_107d,dijit){var _107e=_106e("dijit.Editor",_107d,{plugins:null,extraPlugins:null,constructor:function(){if(!lang.isArray(this.plugins)){this.plugins=["undo","redo","|","cut","copy","paste","|","bold","italic","underline","strikethrough","|","insertOrderedList","insertUnorderedList","indent","outdent","|","justifyLeft","justifyRight","justifyCenter","justifyFull",_107b];}this._plugins=[];this._editInterval=this.editActionInterval*1000;if(has("ie")||has("trident")||has("edge")){this.events.push("onBeforeDeactivate");this.events.push("onBeforeActivate");}},postMixInProperties:function(){this.setValueDeferred=new _106f();this.inherited(arguments);},postCreate:function(){this.inherited(arguments);this._steps=this._steps.slice(0);this._undoedSteps=this._undoedSteps.slice(0);if(lang.isArray(this.extraPlugins)){this.plugins=this.plugins.concat(this.extraPlugins);}this.commands=i18n.getLocalization("dijit._editor","commands",this.lang);if(has("webkit")){_1073.set(this.domNode,"KhtmlUserSelect","none");}},startup:function(){this.inherited(arguments);if(!this.toolbar){this.toolbar=new _1076({ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,"aria-label":this.id});this.header.appendChild(this.toolbar.domNode);}array.forEach(this.plugins,this.addPlugin,this);this.setValueDeferred.resolve(true);_1071.add(this.iframe.parentNode,"dijitEditorIFrameContainer");_1071.add(this.iframe,"dijitEditorIFrame");_1070.set(this.iframe,"allowTransparency",true);this.toolbar.startup();this.onNormalizedDisplayChanged();},destroy:function(){array.forEach(this._plugins,function(p){if(p&&p.destroy){p.destroy();}});this._plugins=[];this.toolbar.destroyRecursive();delete this.toolbar;this.inherited(arguments);},addPlugin:function(_107f,index){var args=lang.isString(_107f)?{name:_107f}:lang.isFunction(_107f)?{ctor:_107f}:_107f;if(!args.setEditor){var o={"args":args,"plugin":null,"editor":this};if(args.name){if(_107a.registry[args.name]){o.plugin=_107a.registry[args.name](args);}else{topic.publish(dijit._scopeName+".Editor.getPlugin",o);}}if(!o.plugin){try{var pc=args.ctor||lang.getObject(args.name)||_106d(args.name);if(pc){o.plugin=new pc(args);}}catch(e){throw new Error(this.id+": cannot find plugin ["+args.name+"]");}}if(!o.plugin){throw new Error(this.id+": cannot find plugin ["+args.name+"]");}_107f=o.plugin;}if(arguments.length>1){this._plugins[index]=_107f;}else{this._plugins.push(_107f);}_107f.setEditor(this);if(lang.isFunction(_107f.setToolbar)){_107f.setToolbar(this.toolbar);}},resize:function(size){if(size){_1078.prototype.resize.apply(this,arguments);}},layout:function(){var _1080=(this._contentBox.h-(this.getHeaderHeight()+this.getFooterHeight()+_1072.getPadBorderExtents(this.iframe.parentNode).h+_1072.getMarginExtents(this.iframe.parentNode).h));this.editingArea.style.height=_1080+"px";if(this.iframe){this.iframe.style.height="100%";}this._layoutMode=true;},_onIEMouseDown:function(e){var _1081;var b=this.document.body;var _1082=b.clientWidth;var _1083=b.clientHeight;var _1084=b.clientLeft;var _1085=b.offsetWidth;var _1086=b.offsetHeight;var _1087=b.offsetLeft;if(/^rtl$/i.test(b.dir||"")){if(_1082<_1085&&e.x>_1082&&e.x<_1085){_1081=true;}}else{if(e.x<_1084&&e.x>_1087){_1081=true;}}if(!_1081){if(_1083<_1086&&e.y>_1083&&e.y<_1086){_1081=true;}}if(!_1081){delete this._cursorToStart;delete this._savedSelection;if(e.target.tagName=="BODY"){this.defer("placeCursorAtEnd");}this.inherited(arguments);}},onBeforeActivate:function(){this._restoreSelection();},onBeforeDeactivate:function(e){if(this.customUndo){this.endEditing(true);}if(e.target.tagName!="BODY"){this._saveSelection();}},customUndo:true,editActionInterval:3,beginEditing:function(cmd){if(!this._inEditing){this._inEditing=true;this._beginEditing(cmd);}if(this.editActionInterval>0){if(this._editTimer){this._editTimer.remove();}this._editTimer=this.defer("endEditing",this._editInterval);}},_steps:[],_undoedSteps:[],execCommand:function(cmd){if(this.customUndo&&(cmd=="undo"||cmd=="redo")){return this[cmd]();}else{if(this.customUndo){this.endEditing();this._beginEditing();}var r=this.inherited(arguments);if(this.customUndo){this._endEditing();}return r;}},_pasteImpl:function(){return this._clipboardCommand("paste");},_cutImpl:function(){return this._clipboardCommand("cut");},_copyImpl:function(){return this._clipboardCommand("copy");},_clipboardCommand:function(cmd){var r;try{r=this.document.execCommand(cmd,false,null);if(has("webkit")&&!r){throw {};}}catch(e){var sub=_1074.substitute,accel={cut:"X",copy:"C",paste:"V"};alert(sub(this.commands.systemShortcut,[this.commands[cmd],sub(this.commands[has("mac")?"appleKey":"ctrlKey"],[accel[cmd]])]));r=false;}return r;},queryCommandEnabled:function(cmd){if(this.customUndo&&(cmd=="undo"||cmd=="redo")){return cmd=="undo"?(this._steps.length>1):(this._undoedSteps.length>0);}else{return this.inherited(arguments);}},_moveToBookmark:function(b){var _1088=b.mark;var mark=b.mark;var col=b.isCollapsed;var r,sNode,eNode,sel;if(mark){if(has("ie")<9||(has("ie")===9&&has("quirks"))){if(lang.isArray(mark)){_1088=[];array.forEach(mark,function(n){_1088.push(_107c.getNode(n,this.editNode));},this);this.selection.moveToBookmark({mark:_1088,isCollapsed:col});}else{if(mark.startContainer&&mark.endContainer){sel=_107c.getSelection(this.window);if(sel&&sel.removeAllRanges){sel.removeAllRanges();r=_107c.create(this.window);sNode=_107c.getNode(mark.startContainer,this.editNode);eNode=_107c.getNode(mark.endContainer,this.editNode);if(sNode&&eNode){r.setStart(sNode,mark.startOffset);r.setEnd(eNode,mark.endOffset);sel.addRange(r);}}}}}else{sel=_107c.getSelection(this.window);if(sel&&sel.removeAllRanges){sel.removeAllRanges();r=_107c.create(this.window);sNode=_107c.getNode(mark.startContainer,this.editNode);eNode=_107c.getNode(mark.endContainer,this.editNode);if(sNode&&eNode){r.setStart(sNode,mark.startOffset);r.setEnd(eNode,mark.endOffset);sel.addRange(r);}}}}},_changeToStep:function(from,to){this.setValue(to.text);var b=to.bookmark;if(!b){return;}this._moveToBookmark(b);},undo:function(){var ret=false;if(!this._undoRedoActive){this._undoRedoActive=true;this.endEditing(true);var s=this._steps.pop();if(s&&this._steps.length>0){this.focus();this._changeToStep(s,this._steps[this._steps.length-1]);this._undoedSteps.push(s);this.onDisplayChanged();delete this._undoRedoActive;ret=true;}delete this._undoRedoActive;}return ret;},redo:function(){var ret=false;if(!this._undoRedoActive){this._undoRedoActive=true;this.endEditing(true);var s=this._undoedSteps.pop();if(s&&this._steps.length>0){this.focus();this._changeToStep(this._steps[this._steps.length-1],s);this._steps.push(s);this.onDisplayChanged();ret=true;}delete this._undoRedoActive;}return ret;},endEditing:function(_1089){if(this._editTimer){this._editTimer=this._editTimer.remove();}if(this._inEditing){this._endEditing(_1089);this._inEditing=false;}},_getBookmark:function(){var b=this.selection.getBookmark();var tmp=[];if(b&&b.mark){var mark=b.mark;if(has("ie")<9||(has("ie")===9&&has("quirks"))){var sel=_107c.getSelection(this.window);if(!lang.isArray(mark)){if(sel){var range;if(sel.rangeCount){range=sel.getRangeAt(0);}if(range){b.mark=range.cloneRange();}else{b.mark=this.selection.getBookmark();}}}else{array.forEach(b.mark,function(n){tmp.push(_107c.getIndex(n,this.editNode).o);},this);b.mark=tmp;}}try{if(b.mark&&b.mark.startContainer){tmp=_107c.getIndex(b.mark.startContainer,this.editNode).o;b.mark={startContainer:tmp,startOffset:b.mark.startOffset,endContainer:b.mark.endContainer===b.mark.startContainer?tmp:_107c.getIndex(b.mark.endContainer,this.editNode).o,endOffset:b.mark.endOffset};}}catch(e){b.mark=null;}}return b;},_beginEditing:function(){if(this._steps.length===0){this._steps.push({"text":html.getChildrenHtml(this.editNode),"bookmark":this._getBookmark()});}},_endEditing:function(){var v=html.getChildrenHtml(this.editNode);this._undoedSteps=[];this._steps.push({text:v,bookmark:this._getBookmark()});},onKeyDown:function(e){if(!has("ie")&&!this.iframe&&e.keyCode==keys.TAB&&!this.tabIndent){this._saveSelection();}if(!this.customUndo){this.inherited(arguments);return;}var k=e.keyCode;if(e.ctrlKey&&!e.shiftKey&&!e.altKey){if(k==90||k==122){e.stopPropagation();e.preventDefault();this.undo();return;}else{if(k==89||k==121){e.stopPropagation();e.preventDefault();this.redo();return;}}}this.inherited(arguments);switch(k){case keys.ENTER:case keys.BACKSPACE:case keys.DELETE:this.beginEditing();break;case 88:case 86:if(e.ctrlKey&&!e.altKey&&!e.metaKey){this.endEditing();if(e.keyCode==88){this.beginEditing("cut");}else{this.beginEditing("paste");}this.defer("endEditing",1);break;}default:if(!e.ctrlKey&&!e.altKey&&!e.metaKey&&(e.keyCode<keys.F1||e.keyCode>keys.F15)){this.beginEditing();break;}case keys.ALT:this.endEditing();break;case keys.UP_ARROW:case keys.DOWN_ARROW:case keys.LEFT_ARROW:case keys.RIGHT_ARROW:case keys.HOME:case keys.END:case keys.PAGE_UP:case keys.PAGE_DOWN:this.endEditing(true);break;case keys.CTRL:case keys.SHIFT:case keys.TAB:break;}},_onBlur:function(){this.inherited(arguments);this.endEditing(true);},_saveSelection:function(){try{this._savedSelection=this._getBookmark();}catch(e){}},_restoreSelection:function(){if(this._savedSelection){delete this._cursorToStart;if(this.selection.isCollapsed()){this._moveToBookmark(this._savedSelection);}delete this._savedSelection;}},onClick:function(){this.endEditing(true);this.inherited(arguments);},replaceValue:function(html){if(!this.customUndo){this.inherited(arguments);}else{if(this.isClosed){this.setValue(html);}else{this.beginEditing();if(!html){html="&#160;";}this.setValue(html);this.endEditing();}}},_setDisabledAttr:function(value){this.setValueDeferred.then(lang.hitch(this,function(){if((!this.disabled&&value)||(!this._buttonEnabledPlugins&&value)){array.forEach(this._plugins,function(p){p.set("disabled",true);});}else{if(this.disabled&&!value){array.forEach(this._plugins,function(p){p.set("disabled",false);});}}}));this.inherited(arguments);},_setStateClass:function(){try{this.inherited(arguments);if(this.document&&this.document.body){_1073.set(this.document.body,"color",_1073.get(this.iframe,"color"));_1073.set(this.document.body,"background-color",_1073.get(this.iframe,"background-color"));}}catch(e){}}});function _108a(args){return new _107a({command:args.name});};function _108b(args){return new _107a({buttonClass:_1079,command:args.name});};lang.mixin(_107a.registry,{"undo":_108a,"redo":_108a,"cut":_108a,"copy":_108a,"paste":_108a,"insertOrderedList":_108a,"insertUnorderedList":_108a,"indent":_108a,"outdent":_108a,"justifyCenter":_108a,"justifyFull":_108a,"justifyLeft":_108a,"justifyRight":_108a,"delete":_108a,"selectAll":_108a,"removeFormat":_108a,"unlink":_108a,"insertHorizontalRule":_108a,"bold":_108b,"italic":_108b,"underline":_108b,"strikethrough":_108b,"subscript":_108b,"superscript":_108b,"|":function(){return new _107a({setEditor:function(_108c){this.editor=_108c;this.button=new _1077({ownerDocument:_108c.ownerDocument});}});}});return _107e;});},"dijit/Toolbar":function(){define(["require","dojo/_base/declare","dojo/has","dojo/keys","dojo/ready","./_Widget","./_KeyNavContainer","./_TemplatedMixin"],function(_108d,_108e,has,keys,ready,_108f,_1090,_1091){if(has("dijit-legacy-requires")){ready(0,function(){var _1092=["dijit/ToolbarSeparator"];_108d(_1092);});}return _108e("dijit.Toolbar",[_108f,_1091,_1090],{templateString:"<div class=\"dijit\" role=\"toolbar\" tabIndex=\"${tabIndex}\" data-dojo-attach-point=\"containerNode\">"+"</div>",baseClass:"dijitToolbar",_onLeftArrow:function(){this.focusPrev();},_onRightArrow:function(){this.focusNext();}});});},"dijit/ToolbarSeparator":function(){define(["dojo/_base/declare","dojo/dom","./_Widget","./_TemplatedMixin"],function(_1093,dom,_1094,_1095){return _1093("dijit.ToolbarSeparator",[_1094,_1095],{templateString:"<div class=\"dijitToolbarSeparator dijitInline\" role=\"presentation\"></div>",buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/_editor/_Plugin":function(){define(["dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","../Destroyable","../form/Button"],function(_1096,_1097,lang,_1098,_1099){var _109a=_1097("dijit._editor._Plugin",_1098,{constructor:function(args){this.params=args||{};lang.mixin(this,this.params);this._attrPairNames={};},editor:null,iconClassPrefix:"dijitEditorIcon",button:null,command:"",useDefaultCommand:true,buttonClass:_1099,disabled:false,getLabel:function(key){return this.editor.commands[key];},_initButton:function(){if(this.command.length){var label=this.getLabel(this.command),_109b=this.editor,_109c=this.iconClassPrefix+" "+this.iconClassPrefix+this.command.charAt(0).toUpperCase()+this.command.substr(1);if(!this.button){var props=lang.mixin({label:label,ownerDocument:_109b.ownerDocument,dir:_109b.dir,lang:_109b.lang,showLabel:false,iconClass:_109c,dropDown:this.dropDown,tabIndex:"-1"},this.params||{});delete props.name;this.button=new this.buttonClass(props);}}if(this.get("disabled")&&this.button){this.button.set("disabled",this.get("disabled"));}},destroy:function(){if(this.dropDown){this.dropDown.destroyRecursive();}this.inherited(arguments);},connect:function(o,f,tf){this.own(_1096.connect(o,f,this,tf));},updateState:function(){var e=this.editor,c=this.command,_109d,_109e;if(!e||!e.isLoaded||!c.length){return;}var _109f=this.get("disabled");if(this.button){try{var _10a0=e._implCommand(c);_109e=!_109f&&(this[_10a0]?this[_10a0](c):e.queryCommandEnabled(c));if(this.enabled!==_109e){this.enabled=_109e;this.button.set("disabled",!_109e);}if(_109e){if(typeof this.button.checked=="boolean"){_109d=e.queryCommandState(c);if(this.checked!==_109d){this.checked=_109d;this.button.set("checked",e.queryCommandState(c));}}}}catch(e){}}},setEditor:function(_10a1){this.editor=_10a1;this._initButton();if(this.button&&this.useDefaultCommand){if(this.editor.queryCommandAvailable(this.command)){this.own(this.button.on("click",lang.hitch(this.editor,"execCommand",this.command,this.commandArg)));}else{this.button.domNode.style.display="none";}}this.own(this.editor.on("NormalizedDisplayChanged",lang.hitch(this,"updateState")));},setToolbar:function(_10a2){if(this.button){_10a2.addChild(this.button);}},set:function(name,value){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var names=this._getAttrNames(name);if(this[names.s]){var _10a3=this[names.s].apply(this,Array.prototype.slice.call(arguments,1));}else{this._set(name,value);}return _10a3||this;},get:function(name){var names=this._getAttrNames(name);return this[names.g]?this[names.g]():this[name];},_setDisabledAttr:function(_10a4){this._set("disabled",_10a4);this.updateState();},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.charAt(0).toUpperCase()+name.substr(1);return (apn[name]={s:"_set"+uc+"Attr",g:"_get"+uc+"Attr"});},_set:function(name,value){this[name]=value;}});_109a.registry={};return _109a;});},"dijit/_editor/plugins/EnterKeyHandling":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","../_Plugin","../RichText","../range"],function(_10a5,_10a6,keys,lang,on,has,win,_10a7,_10a8,_10a9,_10aa){return _10a5("dijit._editor.plugins.EnterKeyHandling",_10a8,{blockNodeForEnter:"BR",constructor:function(args){if(args){if("blockNodeForEnter" in args){args.blockNodeForEnter=args.blockNodeForEnter.toUpperCase();}lang.mixin(this,args);}},setEditor:function(_10ab){if(this.editor===_10ab){return;}this.editor=_10ab;if(this.blockNodeForEnter=="BR"){this.editor.customUndo=true;_10ab.onLoadDeferred.then(lang.hitch(this,function(d){this.own(on(_10ab.document,"keydown",lang.hitch(this,function(e){if(e.keyCode==keys.ENTER){var ne=lang.mixin({},e);ne.shiftKey=true;if(!this.handleEnterKey(ne)){e.stopPropagation();e.preventDefault();}}})));if(has("ie")>=9&&has("ie")<=10){this.own(on(_10ab.document,"paste",lang.hitch(this,function(e){setTimeout(lang.hitch(this,function(){var r=this.editor.document.selection.createRange();r.move("character",-1);r.select();r.move("character",1);r.select();}),0);})));}return d;}));}else{if(this.blockNodeForEnter){var h=lang.hitch(this,"handleEnterKey");_10ab.addKeyHandler(13,0,0,h);_10ab.addKeyHandler(13,0,1,h);this.own(this.editor.on("KeyPressed",lang.hitch(this,"onKeyPressed")));}}},onKeyPressed:function(){if(this._checkListLater){if(this.editor.selection.isCollapsed()){var _10ac=this.editor.selection.getAncestorElement("LI");if(!_10ac){_10a9.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);var block=this.editor.selection.getAncestorElement(this.blockNodeForEnter);if(block){block.innerHTML=this.bogusHtmlContent;if(has("ie")<=9){var r=this.editor.document.selection.createRange();r.move("character",-1);r.select();}}else{console.error("onKeyPressed: Cannot find the new block node");}}else{if(has("mozilla")){if(_10ac.parentNode.parentNode.nodeName=="LI"){_10ac=_10ac.parentNode.parentNode;}}var fc=_10ac.firstChild;if(fc&&fc.nodeType==1&&(fc.nodeName=="UL"||fc.nodeName=="OL")){_10ac.insertBefore(fc.ownerDocument.createTextNode(" "),fc);var _10ad=_10aa.create(this.editor.window);_10ad.setStart(_10ac.firstChild,0);var _10ae=_10aa.getSelection(this.editor.window,true);_10ae.removeAllRanges();_10ae.addRange(_10ad);}}}this._checkListLater=false;}if(this._pressedEnterInBlock){if(this._pressedEnterInBlock.previousSibling){this.removeTrailingBr(this._pressedEnterInBlock.previousSibling);}delete this._pressedEnterInBlock;}},bogusHtmlContent:"&#160;",blockNodes:/^(?:P|H1|H2|H3|H4|H5|H6|LI)$/,handleEnterKey:function(e){var _10af,range,_10b0,_10b1,_10b2,_10b3,doc=this.editor.document,br,rs,txt;if(e.shiftKey){var _10b4=this.editor.selection.getParentElement();var _10b5=_10aa.getAncestor(_10b4,this.blockNodes);if(_10b5){if(_10b5.tagName=="LI"){return true;}_10af=_10aa.getSelection(this.editor.window);range=_10af.getRangeAt(0);if(!range.collapsed){range.deleteContents();_10af=_10aa.getSelection(this.editor.window);range=_10af.getRangeAt(0);}if(_10aa.atBeginningOfContainer(_10b5,range.startContainer,range.startOffset)){br=doc.createElement("br");_10b0=_10aa.create(this.editor.window);_10b5.insertBefore(br,_10b5.firstChild);_10b0.setStartAfter(br);_10af.removeAllRanges();_10af.addRange(_10b0);}else{if(_10aa.atEndOfContainer(_10b5,range.startContainer,range.startOffset)){_10b0=_10aa.create(this.editor.window);br=doc.createElement("br");_10b5.appendChild(br);_10b5.appendChild(doc.createTextNode(" "));_10b0.setStart(_10b5.lastChild,0);_10af.removeAllRanges();_10af.addRange(_10b0);}else{rs=range.startContainer;if(rs&&rs.nodeType==3){txt=rs.nodeValue;_10b1=doc.createTextNode(txt.substring(0,range.startOffset));_10b2=doc.createTextNode(txt.substring(range.startOffset));_10b3=doc.createElement("br");if(_10b2.nodeValue==""&&has("webkit")){_10b2=doc.createTextNode(" ");}_10a6.place(_10b1,rs,"after");_10a6.place(_10b3,_10b1,"after");_10a6.place(_10b2,_10b3,"after");_10a6.destroy(rs);_10b0=_10aa.create(this.editor.window);_10b0.setStart(_10b2,0);_10af.removeAllRanges();_10af.addRange(_10b0);return false;}return true;}}}else{_10af=_10aa.getSelection(this.editor.window);if(_10af.rangeCount){range=_10af.getRangeAt(0);if(range&&range.startContainer){if(!range.collapsed){range.deleteContents();_10af=_10aa.getSelection(this.editor.window);range=_10af.getRangeAt(0);}rs=range.startContainer;if(rs&&rs.nodeType==3){var _10b6=range.startOffset;if(rs.length<_10b6){ret=this._adjustNodeAndOffset(rs,_10b6);rs=ret.node;_10b6=ret.offset;}txt=rs.nodeValue;_10b1=doc.createTextNode(txt.substring(0,_10b6));_10b2=doc.createTextNode(txt.substring(_10b6));_10b3=doc.createElement("br");if(!_10b2.length){_10b2=doc.createTextNode(" ");}if(_10b1.length){_10a6.place(_10b1,rs,"after");}else{_10b1=rs;}_10a6.place(_10b3,_10b1,"after");_10a6.place(_10b2,_10b3,"after");_10a6.destroy(rs);_10b0=_10aa.create(this.editor.window);_10b0.setStart(_10b2,0);_10b0.setEnd(_10b2,_10b2.length);_10af.removeAllRanges();_10af.addRange(_10b0);this.editor.selection.collapse(true);}else{var _10b7;if(range.startOffset>=0){_10b7=rs.childNodes[range.startOffset];}var _10b3=doc.createElement("br");var _10b2=doc.createTextNode(" ");if(!_10b7){rs.appendChild(_10b3);rs.appendChild(_10b2);}else{_10a6.place(_10b3,_10b7,"before");_10a6.place(_10b2,_10b3,"after");}_10b0=_10aa.create(this.editor.window);_10b0.setStart(_10b2,0);_10b0.setEnd(_10b2,_10b2.length);_10af.removeAllRanges();_10af.addRange(_10b0);this.editor.selection.collapse(true);}}}else{_10a9.prototype.execCommand.call(this.editor,"inserthtml","<br>");}}return false;}var _10b8=true;_10af=_10aa.getSelection(this.editor.window);range=_10af.getRangeAt(0);if(!range.collapsed){range.deleteContents();_10af=_10aa.getSelection(this.editor.window);range=_10af.getRangeAt(0);}var block=_10aa.getBlockAncestor(range.endContainer,null,this.editor.editNode);var _10b9=block.blockNode;if((this._checkListLater=(_10b9&&(_10b9.nodeName=="LI"||_10b9.parentNode.nodeName=="LI")))){if(has("mozilla")){this._pressedEnterInBlock=_10b9;}if(/^(\s|&nbsp;|&#160;|\xA0|<span\b[^>]*\bclass=['"]Apple-style-span['"][^>]*>(\s|&nbsp;|&#160;|\xA0)<\/span>)?(<br>)?$/.test(_10b9.innerHTML)){_10b9.innerHTML="";if(has("webkit")){_10b0=_10aa.create(this.editor.window);_10b0.setStart(_10b9,0);_10af.removeAllRanges();_10af.addRange(_10b0);}this._checkListLater=false;}return true;}if(!block.blockNode||block.blockNode===this.editor.editNode){try{_10a9.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);}catch(e2){}block={blockNode:this.editor.selection.getAncestorElement(this.blockNodeForEnter),blockContainer:this.editor.editNode};if(block.blockNode){if(block.blockNode!=this.editor.editNode&&(!(block.blockNode.textContent||block.blockNode.innerHTML).replace(/^\s+|\s+$/g,"").length)){this.removeTrailingBr(block.blockNode);return false;}}else{block.blockNode=this.editor.editNode;}_10af=_10aa.getSelection(this.editor.window);range=_10af.getRangeAt(0);}var _10ba=doc.createElement(this.blockNodeForEnter);_10ba.innerHTML=this.bogusHtmlContent;this.removeTrailingBr(block.blockNode);var _10bb=range.endOffset;var node=range.endContainer;if(node.length<_10bb){var ret=this._adjustNodeAndOffset(node,_10bb);node=ret.node;_10bb=ret.offset;}if(_10aa.atEndOfContainer(block.blockNode,node,_10bb)){if(block.blockNode===block.blockContainer){block.blockNode.appendChild(_10ba);}else{_10a6.place(_10ba,block.blockNode,"after");}_10b8=false;_10b0=_10aa.create(this.editor.window);_10b0.setStart(_10ba,0);_10af.removeAllRanges();_10af.addRange(_10b0);if(this.editor.height){_10a7.scrollIntoView(_10ba);}}else{if(_10aa.atBeginningOfContainer(block.blockNode,range.startContainer,range.startOffset)){_10a6.place(_10ba,block.blockNode,block.blockNode===block.blockContainer?"first":"before");if(_10ba.nextSibling&&this.editor.height){_10b0=_10aa.create(this.editor.window);_10b0.setStart(_10ba.nextSibling,0);_10af.removeAllRanges();_10af.addRange(_10b0);_10a7.scrollIntoView(_10ba.nextSibling);}_10b8=false;}else{if(block.blockNode===block.blockContainer){block.blockNode.appendChild(_10ba);}else{_10a6.place(_10ba,block.blockNode,"after");}_10b8=false;if(block.blockNode.style){if(_10ba.style){if(block.blockNode.style.cssText){_10ba.style.cssText=block.blockNode.style.cssText;}}}rs=range.startContainer;var _10bc;if(rs&&rs.nodeType==3){var _10bd,tNode;_10bb=range.endOffset;if(rs.length<_10bb){ret=this._adjustNodeAndOffset(rs,_10bb);rs=ret.node;_10bb=ret.offset;}txt=rs.nodeValue;_10b1=doc.createTextNode(txt.substring(0,_10bb));_10b2=doc.createTextNode(txt.substring(_10bb,txt.length));_10a6.place(_10b1,rs,"before");_10a6.place(_10b2,rs,"after");_10a6.destroy(rs);var _10be=_10b1.parentNode;while(_10be!==block.blockNode){var tg=_10be.tagName;var newTg=doc.createElement(tg);if(_10be.style){if(newTg.style){if(_10be.style.cssText){newTg.style.cssText=_10be.style.cssText;}}}if(_10be.tagName==="FONT"){if(_10be.color){newTg.color=_10be.color;}if(_10be.face){newTg.face=_10be.face;}if(_10be.size){newTg.size=_10be.size;}}_10bd=_10b2;while(_10bd){tNode=_10bd.nextSibling;newTg.appendChild(_10bd);_10bd=tNode;}_10a6.place(newTg,_10be,"after");_10b1=_10be;_10b2=newTg;_10be=_10be.parentNode;}_10bd=_10b2;if(_10bd.nodeType==1||(_10bd.nodeType==3&&_10bd.nodeValue)){_10ba.innerHTML="";}_10bc=_10bd;while(_10bd){tNode=_10bd.nextSibling;_10ba.appendChild(_10bd);_10bd=tNode;}}_10b0=_10aa.create(this.editor.window);var _10bf;var _10c0=_10bc;if(this.blockNodeForEnter!=="BR"){while(_10c0){_10bf=_10c0;tNode=_10c0.firstChild;_10c0=tNode;}if(_10bf&&_10bf.parentNode){_10ba=_10bf.parentNode;_10b0.setStart(_10ba,0);_10af.removeAllRanges();_10af.addRange(_10b0);if(this.editor.height){_10a7.scrollIntoView(_10ba);}if(has("mozilla")){this._pressedEnterInBlock=block.blockNode;}}else{_10b8=true;}}else{_10b0.setStart(_10ba,0);_10af.removeAllRanges();_10af.addRange(_10b0);if(this.editor.height){_10a7.scrollIntoView(_10ba);}if(has("mozilla")){this._pressedEnterInBlock=block.blockNode;}}}}return _10b8;},_adjustNodeAndOffset:function(node,_10c1){while(node.length<_10c1&&node.nextSibling&&node.nextSibling.nodeType==3){_10c1=_10c1-node.length;node=node.nextSibling;}return {"node":node,"offset":_10c1};},removeTrailingBr:function(_10c2){var para=/P|DIV|LI/i.test(_10c2.tagName)?_10c2:this.editor.selection.getParentOfType(_10c2,["P","DIV","LI"]);if(!para){return;}if(para.lastChild){if((para.childNodes.length>1&&para.lastChild.nodeType==3&&/^[\s\xAD]*$/.test(para.lastChild.nodeValue))||para.lastChild.tagName=="BR"){_10a6.destroy(para.lastChild);}}if(!para.childNodes.length){para.innerHTML=this.bogusHtmlContent;}}});});},"dijit/_editor/RichText":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/query","dojo/domReady","dojo/sniff","dojo/string","dojo/topic","dojo/_base/unload","dojo/_base/url","dojo/window","../_Widget","../_CssStateMixin","../selection","./range","./html","../focus","../main"],function(array,_10c3,_10c4,_10c5,dom,_10c6,_10c7,_10c8,_10c9,_10ca,_10cb,keys,lang,on,query,_10cc,has,_10cd,topic,_10ce,_10cf,_10d0,_10d1,_10d2,_10d3,_10d4,_10d5,focus,dijit){var _10d6=_10c4("dijit._editor.RichText",[_10d1,_10d2],{constructor:function(_10d7){this.contentPreFilters=[];this.contentPostFilters=[];this.contentDomPreFilters=[];this.contentDomPostFilters=[];this.editingAreaStyleSheets=[];this.events=[].concat(this.events);this._keyHandlers={};if(_10d7&&lang.isString(_10d7.value)){this.value=_10d7.value;}this.onLoadDeferred=new _10c5();},baseClass:"dijitEditor",inheritWidth:false,focusOnLoad:false,name:"",styleSheets:"",height:"300px",minHeight:"1em",isClosed:true,isLoaded:false,_SEPARATOR:"@@**%%__RICHTEXTBOUNDRY__%%**@@",_NAME_CONTENT_SEP:"@@**%%:%%**@@",onLoadDeferred:null,isTabIndent:false,disableSpellCheck:false,postCreate:function(){if("textarea"===this.domNode.tagName.toLowerCase()){console.warn("RichText should not be used with the TEXTAREA tag.  See dijit._editor.RichText docs.");}this.contentPreFilters=[lang.trim,lang.hitch(this,"_preFixUrlAttributes")].concat(this.contentPreFilters);if(has("mozilla")){this.contentPreFilters=[this._normalizeFontStyle].concat(this.contentPreFilters);this.contentPostFilters=[this._removeMozBogus].concat(this.contentPostFilters);}if(has("webkit")){this.contentPreFilters=[this._removeWebkitBogus].concat(this.contentPreFilters);this.contentPostFilters=[this._removeWebkitBogus].concat(this.contentPostFilters);}if(has("ie")||has("trident")){this.contentPostFilters=[this._normalizeFontStyle].concat(this.contentPostFilters);this.contentDomPostFilters=[lang.hitch(this,"_stripBreakerNodes")].concat(this.contentDomPostFilters);}this.contentDomPostFilters=[lang.hitch(this,"_stripTrailingEmptyNodes")].concat(this.contentDomPostFilters);this.inherited(arguments);topic.publish(dijit._scopeName+"._editor.RichText::init",this);},startup:function(){this.inherited(arguments);this.open();this.setupDefaultShortcuts();},setupDefaultShortcuts:function(){var exec=lang.hitch(this,function(cmd,arg){return function(){return !this.execCommand(cmd,arg);};});var _10d8={b:exec("bold"),i:exec("italic"),u:exec("underline"),a:exec("selectall"),s:function(){this.save(true);},m:function(){this.isTabIndent=!this.isTabIndent;},"1":exec("formatblock","h1"),"2":exec("formatblock","h2"),"3":exec("formatblock","h3"),"4":exec("formatblock","h4"),"\\":exec("insertunorderedlist")};if(!has("ie")){_10d8.Z=exec("redo");}var key;for(key in _10d8){this.addKeyHandler(key,true,false,_10d8[key]);}},events:["onKeyDown","onKeyUp"],captureEvents:[],_editorCommandsLocalized:false,_localizeEditorCommands:function(){if(_10d6._editorCommandsLocalized){this._local2NativeFormatNames=_10d6._local2NativeFormatNames;this._native2LocalFormatNames=_10d6._native2LocalFormatNames;return;}_10d6._editorCommandsLocalized=true;_10d6._local2NativeFormatNames={};_10d6._native2LocalFormatNames={};this._local2NativeFormatNames=_10d6._local2NativeFormatNames;this._native2LocalFormatNames=_10d6._native2LocalFormatNames;var _10d9=["div","p","pre","h1","h2","h3","h4","h5","h6","ol","ul","address"];var _10da="",_10db,i=0;while((_10db=_10d9[i++])){if(_10db.charAt(1)!=="l"){_10da+="<"+_10db+"><span>content</span></"+_10db+"><br/>";}else{_10da+="<"+_10db+"><li>content</li></"+_10db+"><br/>";}}var style={position:"absolute",top:"0px",zIndex:10,opacity:0.01};var div=_10c8.create("div",{style:style,innerHTML:_10da});this.ownerDocumentBody.appendChild(div);var _10dc=lang.hitch(this,function(){var node=div.firstChild;while(node){try{this.selection.selectElement(node.firstChild);var _10dd=node.tagName.toLowerCase();this._local2NativeFormatNames[_10dd]=document.queryCommandValue("formatblock");this._native2LocalFormatNames[this._local2NativeFormatNames[_10dd]]=_10dd;node=node.nextSibling.nextSibling;}catch(e){}}_10c8.destroy(div);});this.defer(_10dc);},open:function(_10de){if(!this.onLoadDeferred||this.onLoadDeferred.fired>=0){this.onLoadDeferred=new _10c5();}if(!this.isClosed){this.close();}topic.publish(dijit._scopeName+"._editor.RichText::open",this);if(arguments.length===1&&_10de.nodeName){this.domNode=_10de;}var dn=this.domNode;var html;if(lang.isString(this.value)){html=this.value;dn.innerHTML="";}else{if(dn.nodeName&&dn.nodeName.toLowerCase()=="textarea"){var ta=(this.textarea=dn);this.name=ta.name;html=ta.value;dn=this.domNode=this.ownerDocument.createElement("div");dn.setAttribute("widgetId",this.id);ta.removeAttribute("widgetId");dn.cssText=ta.cssText;dn.className+=" "+ta.className;_10c8.place(dn,ta,"before");var _10df=lang.hitch(this,function(){_10ca.set(ta,{display:"block",position:"absolute",top:"-1000px"});if(has("ie")){var s=ta.style;this.__overflow=s.overflow;s.overflow="hidden";}});if(has("ie")){this.defer(_10df,10);}else{_10df();}if(ta.form){var _10e0=ta.value;this.reset=function(){var _10e1=this.getValue();if(_10e1!==_10e0){this.replaceValue(_10e0);}};on(ta.form,"submit",lang.hitch(this,function(){_10c6.set(ta,"disabled",this.disabled);ta.value=this.getValue();}));}}else{html=_10d5.getChildrenHtml(dn);dn.innerHTML="";}}this.value=html;if(dn.nodeName&&dn.nodeName==="LI"){dn.innerHTML=" <br>";}this.header=dn.ownerDocument.createElement("div");dn.appendChild(this.header);this.editingArea=dn.ownerDocument.createElement("div");dn.appendChild(this.editingArea);this.footer=dn.ownerDocument.createElement("div");dn.appendChild(this.footer);if(!this.name){this.name=this.id+"_AUTOGEN";}if(this.name!==""&&(!_10c3["useXDomain"]||_10c3["allowXdRichTextSave"])){var _10e2=dom.byId(dijit._scopeName+"._editor.RichText.value");if(_10e2&&_10e2.value!==""){var datas=_10e2.value.split(this._SEPARATOR),i=0,dat;while((dat=datas[i++])){var data=dat.split(this._NAME_CONTENT_SEP);if(data[0]===this.name){this.value=data[1];datas=datas.splice(i,1);_10e2.value=datas.join(this._SEPARATOR);break;}}}if(!_10d6._globalSaveHandler){_10d6._globalSaveHandler={};_10ce.addOnUnload(function(){var id;for(id in _10d6._globalSaveHandler){var f=_10d6._globalSaveHandler[id];if(lang.isFunction(f)){f();}}});}_10d6._globalSaveHandler[this.id]=lang.hitch(this,"_saveContent");}this.isClosed=false;var ifr=(this.editorObject=this.iframe=this.ownerDocument.createElement("iframe"));ifr.id=this.id+"_iframe";ifr.style.border="none";ifr.style.width="100%";if(this._layoutMode){ifr.style.height="100%";}else{if(has("ie")>=7){if(this.height){ifr.style.height=this.height;}if(this.minHeight){ifr.style.minHeight=this.minHeight;}}else{ifr.style.height=this.height?this.height:this.minHeight;}}ifr.frameBorder=0;ifr._loadFunc=lang.hitch(this,function(w){this.window=w;this.document=w.document;this.selection=new _10d3.SelectionManager(w);if(has("ie")){this._localizeEditorCommands();}this.onLoad(this.get("value"));});var src=this._getIframeDocTxt().replace(/\\/g,"\\\\").replace(/'/g,"\\'"),s;if(has("ie")<11){s="javascript:document.open();try{parent.window;}catch(e){document.domain=\""+document.domain+"\";}"+"document.write('"+src+"');document.close()";}else{s="javascript: '"+src+"'";}this.editingArea.appendChild(ifr);ifr.src=s;if(dn.nodeName==="LI"){dn.lastChild.style.marginTop="-1.2em";}_10c7.add(this.domNode,this.baseClass);},_local2NativeFormatNames:{},_native2LocalFormatNames:{},_getIframeDocTxt:function(){var _10e3=_10ca.getComputedStyle(this.domNode);var title;if(this["aria-label"]){title=this["aria-label"];}else{var _10e4=query("label[for=\""+this.id+"\"]",this.ownerDocument)[0]||dom.byId(this["aria-labelledby"],this.ownerDocument);if(_10e4){title=_10e4.textContent||_10e4.innerHTML||"";}}var html="<div id='dijitEditorBody' role='textbox' aria-multiline='true' "+(title?" aria-label='"+_10cd.escape(title)+"'":"")+"></div>";var font=[_10e3.fontWeight,_10e3.fontSize,_10e3.fontFamily].join(" ");var _10e5=_10e3.lineHeight;if(_10e5.indexOf("px")>=0){_10e5=parseFloat(_10e5)/parseFloat(_10e3.fontSize);}else{if(_10e5.indexOf("em")>=0){_10e5=parseFloat(_10e5);}else{_10e5="normal";}}var _10e6="";var self=this;this.style.replace(/(^|;)\s*(line-|font-?)[^;]+/ig,function(match){match=match.replace(/^;/ig,"")+";";var s=match.split(":")[0];if(s){s=lang.trim(s);s=s.toLowerCase();var i;var sC="";for(i=0;i<s.length;i++){var c=s.charAt(i);switch(c){case "-":i++;c=s.charAt(i).toUpperCase();default:sC+=c;}}_10ca.set(self.domNode,sC,"");}_10e6+=match+";";});this.iframe.setAttribute("title",title);var _10e7=this.lang||_10cb.locale.replace(/-.*/,"");return ["<!DOCTYPE html>","<html lang='"+_10e7+"'"+(this.isLeftToRight()?"":" dir='rtl'")+">\n","<head>\n","<meta http-equiv='Content-Type' content='text/html'>\n",title?"<title>"+_10cd.escape(title)+"</title>":"","<style>\n","\tbody,html {\n","\t\tbackground:transparent;\n","\t\tpadding: 1px 0 0 0;\n","\t\tmargin: -1px 0 0 0;\n","\t}\n","\tbody,html,#dijitEditorBody { outline: none; }","html { height: 100%; width: 100%; overflow: hidden; }\n",this.height?"\tbody,#dijitEditorBody { height: 100%; width: 100%; overflow: auto; }\n":"\tbody,#dijitEditorBody { min-height: "+this.minHeight+"; width: 100%; overflow-x: auto; overflow-y: hidden; }\n","\tbody{\n","\t\ttop:0px;\n","\t\tleft:0px;\n","\t\tright:0px;\n","\t\tfont:",font,";\n",((this.height||has("opera"))?"":"\t\tposition: fixed;\n"),"\t\tline-height:",_10e5,";\n","\t}\n","\tp{ margin: 1em 0; }\n","\tli > ul:-moz-first-node, li > ol:-moz-first-node{ padding-top: 1.2em; }\n",(has("ie")||has("trident")||has("edge")?"":"\tli{ min-height:1.2em; }\n"),"</style>\n",this._applyEditingAreaStyleSheets(),"\n","</head>\n<body role='application'",title?" aria-label='"+_10cd.escape(title)+"'":"","onload='try{frameElement && frameElement._loadFunc(window,document)}catch(e){document.domain=\""+document.domain+"\";frameElement._loadFunc(window,document)}' ","style='"+_10e6+"'>",html,"</body>\n</html>"].join("");},_applyEditingAreaStyleSheets:function(){var files=[];if(this.styleSheets){files=this.styleSheets.split(";");this.styleSheets="";}files=files.concat(this.editingAreaStyleSheets);this.editingAreaStyleSheets=[];var text="",i=0,url,_10e8=_10d0.get(this.ownerDocument);while((url=files[i++])){var _10e9=(new _10cf(_10e8.location,url)).toString();this.editingAreaStyleSheets.push(_10e9);text+="<link rel=\"stylesheet\" type=\"text/css\" href=\""+_10e9+"\"/>";}return text;},addStyleSheet:function(uri){var url=uri.toString(),_10ea=_10d0.get(this.ownerDocument);if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){url=(new _10cf(_10ea.location,url)).toString();}if(array.indexOf(this.editingAreaStyleSheets,url)>-1){return;}this.editingAreaStyleSheets.push(url);this.onLoadDeferred.then(lang.hitch(this,function(){if(this.document.createStyleSheet){this.document.createStyleSheet(url);}else{var head=this.document.getElementsByTagName("head")[0];var _10eb=this.document.createElement("link");_10eb.rel="stylesheet";_10eb.type="text/css";_10eb.href=url;head.appendChild(_10eb);}}));},removeStyleSheet:function(uri){var url=uri.toString(),_10ec=_10d0.get(this.ownerDocument);if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){url=(new _10cf(_10ec.location,url)).toString();}var index=array.indexOf(this.editingAreaStyleSheets,url);if(index===-1){return;}delete this.editingAreaStyleSheets[index];query("link[href=\""+url+"\"]",this.window.document).orphan();},disabled:false,_mozSettingProps:{"styleWithCSS":false},_setDisabledAttr:function(value){value=!!value;this._set("disabled",value);if(!this.isLoaded){return;}var _10ed=has("ie")&&(this.isLoaded||!this.focusOnLoad);if(_10ed){this.editNode.unselectable="on";}this.editNode.contentEditable=!value;this.editNode.tabIndex=value?"-1":this.tabIndex;if(_10ed){this.defer(function(){if(this.editNode){this.editNode.unselectable="off";}});}if(has("mozilla")&&!value&&this._mozSettingProps){var ps=this._mozSettingProps;var n;for(n in ps){if(ps.hasOwnProperty(n)){try{this.document.execCommand(n,false,ps[n]);}catch(e2){}}}}this._disabledOK=true;},onLoad:function(html){if(!this.window.__registeredWindow){this.window.__registeredWindow=true;this._iframeRegHandle=focus.registerIframe(this.iframe);}this.editNode=this.document.body.firstChild;var _10ee=this;this.beforeIframeNode=_10c8.place("<div tabIndex=-1></div>",this.iframe,"before");this.afterIframeNode=_10c8.place("<div tabIndex=-1></div>",this.iframe,"after");this.iframe.onfocus=this.document.onfocus=function(){_10ee.editNode.focus();};this.focusNode=this.editNode;var _10ef=this.events.concat(this.captureEvents);var ap=this.iframe?this.document:this.editNode;this.own.apply(this,array.map(_10ef,function(item){var type=item.toLowerCase().replace(/^on/,"");return on(ap,type,lang.hitch(this,item));},this));this.own(on(ap,"mouseup",lang.hitch(this,"onClick")));if(has("ie")){this.own(on(this.document,"mousedown",lang.hitch(this,"_onIEMouseDown")));this.editNode.style.zoom=1;}if(has("webkit")){this._webkitListener=this.own(on(this.document,"mouseup",lang.hitch(this,"onDisplayChanged")))[0];this.own(on(this.document,"mousedown",lang.hitch(this,function(e){var t=e.target;if(t&&(t===this.document.body||t===this.document)){this.defer("placeCursorAtEnd");}})));}if(has("ie")){try{this.document.execCommand("RespectVisibilityInDesign",true,null);}catch(e){}}this.isLoaded=true;this.set("disabled",this.disabled);var _10f0=lang.hitch(this,function(){this.setValue(html);if(this.onLoadDeferred&&!this.onLoadDeferred.isFulfilled()){this.onLoadDeferred.resolve(true);}this.onDisplayChanged();if(this.focusOnLoad){_10cc(lang.hitch(this,"defer","focus",this.updateInterval));}this.value=this.getValue(true);});if(this.setValueDeferred){this.setValueDeferred.then(_10f0);}else{_10f0();}},onKeyDown:function(e){if(e.keyCode===keys.SHIFT||e.keyCode===keys.ALT||e.keyCode===keys.META||e.keyCode===keys.CTRL){return true;}if(e.keyCode===keys.TAB&&this.isTabIndent){e.stopPropagation();e.preventDefault();if(this.queryCommandEnabled((e.shiftKey?"outdent":"indent"))){this.execCommand((e.shiftKey?"outdent":"indent"));}}if(e.keyCode==keys.TAB&&!this.isTabIndent&&!e.ctrlKey&&!e.altKey){if(e.shiftKey){this.beforeIframeNode.focus();}else{this.afterIframeNode.focus();}return true;}if(has("ie")<9&&e.keyCode===keys.BACKSPACE&&this.document.selection.type==="Control"){e.stopPropagation();e.preventDefault();this.execCommand("delete");}if(has("ff")){if(e.keyCode===keys.PAGE_UP||e.keyCode===keys.PAGE_DOWN){if(this.editNode.clientHeight>=this.editNode.scrollHeight){e.preventDefault();}}}var _10f1=this._keyHandlers[e.keyCode],args=arguments;if(_10f1&&!e.altKey){array.some(_10f1,function(h){if(!(h.shift^e.shiftKey)&&!(h.ctrl^(e.ctrlKey||e.metaKey))){if(!h.handler.apply(this,args)){e.preventDefault();}return true;}},this);}this.defer("onKeyPressed",1);return true;},onKeyUp:function(){},setDisabled:function(_10f2){_10cb.deprecated("dijit.Editor::setDisabled is deprecated","use dijit.Editor::attr(\"disabled\",boolean) instead",2);this.set("disabled",_10f2);},_setValueAttr:function(value){this.setValue(value);},_setDisableSpellCheckAttr:function(_10f3){if(this.document){_10c6.set(this.document.body,"spellcheck",!_10f3);}else{this.onLoadDeferred.then(lang.hitch(this,function(){_10c6.set(this.document.body,"spellcheck",!_10f3);}));}this._set("disableSpellCheck",_10f3);},addKeyHandler:function(key,ctrl,shift,_10f4){if(typeof key=="string"){key=key.toUpperCase().charCodeAt(0);}if(!lang.isArray(this._keyHandlers[key])){this._keyHandlers[key]=[];}this._keyHandlers[key].push({shift:shift||false,ctrl:ctrl||false,handler:_10f4});},onKeyPressed:function(){this.onDisplayChanged();},onClick:function(e){this.onDisplayChanged(e);},_onIEMouseDown:function(){if(!this.focused&&!this.disabled){this.focus();}},_onBlur:function(e){if(has("ie")||has("trident")){this.defer(function(){if(!focus.curNode){this.ownerDocumentBody.focus();}});}this.inherited(arguments);var _10f5=this.getValue(true);if(_10f5!==this.value){this.onChange(_10f5);}this._set("value",_10f5);},_onFocus:function(e){if(!this.disabled){if(!this._disabledOK){this.set("disabled",false);}this.inherited(arguments);}},blur:function(){if(!has("ie")&&this.window.document.documentElement&&this.window.document.documentElement.focus){this.window.document.documentElement.focus();}else{if(this.ownerDocumentBody.focus){this.ownerDocumentBody.focus();}}},focus:function(){if(!this.isLoaded){this.focusOnLoad=true;return;}if(has("ie")<9){this.iframe.fireEvent("onfocus",document.createEventObject());}else{this.editNode.focus();}},updateInterval:200,_updateTimer:null,onDisplayChanged:function(){if(this._updateTimer){this._updateTimer.remove();}this._updateTimer=this.defer("onNormalizedDisplayChanged",this.updateInterval);},onNormalizedDisplayChanged:function(){delete this._updateTimer;},onChange:function(){},_normalizeCommand:function(cmd,_10f6){var _10f7=cmd.toLowerCase();if(_10f7==="formatblock"){if(has("safari")&&_10f6===undefined){_10f7="heading";}}else{if(_10f7==="hilitecolor"&&!has("mozilla")){_10f7="backcolor";}}return _10f7;},_implCommand:function(cmd){return "_"+this._normalizeCommand(cmd)+"EnabledImpl";},_qcaCache:{},queryCommandAvailable:function(_10f8){var ca=this._qcaCache[_10f8];if(ca!==undefined){return ca;}return (this._qcaCache[_10f8]=this._queryCommandAvailable(_10f8));},_queryCommandAvailable:function(_10f9){switch(_10f9.toLowerCase()){case "bold":case "italic":case "underline":case "subscript":case "superscript":case "fontname":case "fontsize":case "forecolor":case "hilitecolor":case "justifycenter":case "justifyfull":case "justifyleft":case "justifyright":case "delete":case "selectall":case "toggledir":case "createlink":case "unlink":case "removeformat":case "inserthorizontalrule":case "insertimage":case "insertorderedlist":case "insertunorderedlist":case "indent":case "outdent":case "formatblock":case "inserthtml":case "undo":case "redo":case "strikethrough":case "tabindent":case "cut":case "copy":case "paste":return true;case "blockdirltr":case "blockdirrtl":case "dirltr":case "dirrtl":case "inlinedirltr":case "inlinedirrtl":return has("ie")||has("trident")||has("edge");case "inserttable":case "insertcell":case "insertcol":case "insertrow":case "deletecells":case "deletecols":case "deleterows":case "mergecells":case "splitcell":return !has("webkit");default:return false;}},execCommand:function(_10fa,_10fb){var _10fc;if(this.focused){this.focus();}_10fa=this._normalizeCommand(_10fa,_10fb);if(_10fb!==undefined){if(_10fa==="heading"){throw new Error("unimplemented");}else{if(_10fa==="formatblock"&&(has("ie")||has("trident"))){_10fb="<"+_10fb+">";}}}var _10fd="_"+_10fa+"Impl";if(this[_10fd]){_10fc=this[_10fd](_10fb);}else{_10fb=arguments.length>1?_10fb:null;if(_10fb||_10fa!=="createlink"){_10fc=this.document.execCommand(_10fa,false,_10fb);}}this.onDisplayChanged();return _10fc;},queryCommandEnabled:function(_10fe){if(this.disabled||!this._disabledOK){return false;}_10fe=this._normalizeCommand(_10fe);var _10ff=this._implCommand(_10fe);if(this[_10ff]){return this[_10ff](_10fe);}else{return this._browserQueryCommandEnabled(_10fe);}},queryCommandState:function(_1100){if(this.disabled||!this._disabledOK){return false;}_1100=this._normalizeCommand(_1100);try{return this.document.queryCommandState(_1100);}catch(e){return false;}},queryCommandValue:function(_1101){if(this.disabled||!this._disabledOK){return false;}var r;_1101=this._normalizeCommand(_1101);if(has("ie")&&_1101==="formatblock"){r=this._native2LocalFormatNames[this.document.queryCommandValue(_1101)];}else{if(has("mozilla")&&_1101==="hilitecolor"){var _1102;try{_1102=this.document.queryCommandValue("styleWithCSS");}catch(e){_1102=false;}this.document.execCommand("styleWithCSS",false,true);r=this.document.queryCommandValue(_1101);this.document.execCommand("styleWithCSS",false,_1102);}else{r=this.document.queryCommandValue(_1101);}}return r;},_sCall:function(name,args){return this.selection[name].apply(this.selection,args);},placeCursorAtStart:function(){this.focus();var _1103=false;if(has("mozilla")){var first=this.editNode.firstChild;while(first){if(first.nodeType===3){if(first.nodeValue.replace(/^\s+|\s+$/g,"").length>0){_1103=true;this.selection.selectElement(first);break;}}else{if(first.nodeType===1){_1103=true;var tg=first.tagName?first.tagName.toLowerCase():"";if(/br|input|img|base|meta|area|basefont|hr|link/.test(tg)){this.selection.selectElement(first);}else{this.selection.selectElementChildren(first);}break;}}first=first.nextSibling;}}else{_1103=true;this.selection.selectElementChildren(this.editNode);}if(_1103){this.selection.collapse(true);}},placeCursorAtEnd:function(){this.focus();var _1104=false;if(has("mozilla")){var last=this.editNode.lastChild;while(last){if(last.nodeType===3){if(last.nodeValue.replace(/^\s+|\s+$/g,"").length>0){_1104=true;this.selection.selectElement(last);break;}}else{if(last.nodeType===1){_1104=true;this.selection.selectElement(last.lastChild||last);break;}}last=last.previousSibling;}}else{_1104=true;this.selection.selectElementChildren(this.editNode);}if(_1104){this.selection.collapse(false);}},getValue:function(_1105){if(this.textarea){if(this.isClosed||!this.isLoaded){return this.textarea.value;}}return this.isLoaded?this._postFilterContent(null,_1105):this.value;},_getValueAttr:function(){return this.getValue(true);},setValue:function(html){if(!this.isLoaded){this.onLoadDeferred.then(lang.hitch(this,function(){this.setValue(html);}));return;}if(this.textarea&&(this.isClosed||!this.isLoaded)){this.textarea.value=html;}else{html=this._preFilterContent(html);var node=this.isClosed?this.domNode:this.editNode;node.innerHTML=html;this._preDomFilterContent(node);}this.onDisplayChanged();this._set("value",this.getValue(true));},replaceValue:function(html){if(this.isClosed){this.setValue(html);}else{if(this.window&&this.window.getSelection&&!has("mozilla")){this.setValue(html);}else{if(this.window&&this.window.getSelection){html=this._preFilterContent(html);this.execCommand("selectall");this.execCommand("inserthtml",html);this._preDomFilterContent(this.editNode);}else{if(this.document&&this.document.selection){this.setValue(html);}}}}this._set("value",this.getValue(true));},_preFilterContent:function(html){var ec=html;array.forEach(this.contentPreFilters,function(ef){if(ef){ec=ef(ec);}});return ec;},_preDomFilterContent:function(dom){dom=dom||this.editNode;array.forEach(this.contentDomPreFilters,function(ef){if(ef&&lang.isFunction(ef)){ef(dom);}},this);},_postFilterContent:function(dom,_1106){var ec;if(!lang.isString(dom)){dom=dom||this.editNode;if(this.contentDomPostFilters.length){if(_1106){dom=lang.clone(dom);}array.forEach(this.contentDomPostFilters,function(ef){dom=ef(dom);});}ec=_10d5.getChildrenHtml(dom);}else{ec=dom;}if(!lang.trim(ec.replace(/^\xA0\xA0*/,"").replace(/\xA0\xA0*$/,"")).length){ec="";}array.forEach(this.contentPostFilters,function(ef){ec=ef(ec);});return ec;},_saveContent:function(){var _1107=dom.byId(dijit._scopeName+"._editor.RichText.value");if(_1107){if(_1107.value){_1107.value+=this._SEPARATOR;}_1107.value+=this.name+this._NAME_CONTENT_SEP+this.getValue(true);}},escapeXml:function(str,_1108){str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");if(!_1108){str=str.replace(/'/gm,"&#39;");}return str;},getNodeHtml:function(node){_10cb.deprecated("dijit.Editor::getNodeHtml is deprecated","use dijit/_editor/html::getNodeHtml instead",2);return _10d5.getNodeHtml(node);},getNodeChildrenHtml:function(dom){_10cb.deprecated("dijit.Editor::getNodeChildrenHtml is deprecated","use dijit/_editor/html::getChildrenHtml instead",2);return _10d5.getChildrenHtml(dom);},close:function(save){if(this.isClosed){return;}if(!arguments.length){save=true;}if(save){this._set("value",this.getValue(true));}if(this.interval){clearInterval(this.interval);}if(this._webkitListener){this._webkitListener.remove();delete this._webkitListener;}if(has("ie")){this.iframe.onfocus=null;}this.iframe._loadFunc=null;if(this._iframeRegHandle){this._iframeRegHandle.remove();delete this._iframeRegHandle;}if(this.textarea){var s=this.textarea.style;s.position="";s.left=s.top="";if(has("ie")){s.overflow=this.__overflow;this.__overflow=null;}this.textarea.value=this.value;_10c8.destroy(this.domNode);this.domNode=this.textarea;}else{this.domNode.innerHTML=this.value;}delete this.iframe;_10c7.remove(this.domNode,this.baseClass);this.isClosed=true;this.isLoaded=false;delete this.editNode;delete this.focusNode;if(this.window&&this.window._frameElement){this.window._frameElement=null;}this.window=null;this.document=null;this.editingArea=null;this.editorObject=null;},destroy:function(){if(!this.isClosed){this.close(false);}if(this._updateTimer){this._updateTimer.remove();}this.inherited(arguments);if(_10d6._globalSaveHandler){delete _10d6._globalSaveHandler[this.id];}},_removeMozBogus:function(html){return html.replace(/\stype="_moz"/gi,"").replace(/\s_moz_dirty=""/gi,"").replace(/_moz_resizing="(true|false)"/gi,"");},_removeWebkitBogus:function(html){html=html.replace(/\sclass="webkit-block-placeholder"/gi,"");html=html.replace(/\sclass="apple-style-span"/gi,"");html=html.replace(/<meta charset=\"utf-8\" \/>/gi,"");return html;},_normalizeFontStyle:function(html){return html.replace(/<(\/)?strong([ \>])/gi,"<$1b$2").replace(/<(\/)?em([ \>])/gi,"<$1i$2");},_preFixUrlAttributes:function(html){return html.replace(/(?:(<a(?=\s).*?\shref=)("|')(.*?)\2)|(?:(<a\s.*?href=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2").replace(/(?:(<img(?=\s).*?\ssrc=)("|')(.*?)\2)|(?:(<img\s.*?src=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2");},_browserQueryCommandEnabled:function(_1109){if(!_1109){return false;}var elem=has("ie")<9?this.document.selection.createRange():this.document;try{return elem.queryCommandEnabled(_1109);}catch(e){return false;}},_createlinkEnabledImpl:function(){var _110a=true;if(has("opera")){var sel=this.window.getSelection();if(sel.isCollapsed){_110a=true;}else{_110a=this.document.queryCommandEnabled("createlink");}}else{_110a=this._browserQueryCommandEnabled("createlink");}return _110a;},_unlinkEnabledImpl:function(){var _110b=true;if(has("mozilla")||has("webkit")){_110b=this.selection.hasAncestorElement("a");}else{_110b=this._browserQueryCommandEnabled("unlink");}return _110b;},_inserttableEnabledImpl:function(){var _110c=true;if(has("mozilla")||has("webkit")){_110c=true;}else{_110c=this._browserQueryCommandEnabled("inserttable");}return _110c;},_cutEnabledImpl:function(){var _110d=true;if(has("webkit")){var sel=this.window.getSelection();if(sel){sel=sel.toString();}_110d=!!sel;}else{_110d=this._browserQueryCommandEnabled("cut");}return _110d;},_copyEnabledImpl:function(){var _110e=true;if(has("webkit")){var sel=this.window.getSelection();if(sel){sel=sel.toString();}_110e=!!sel;}else{_110e=this._browserQueryCommandEnabled("copy");}return _110e;},_pasteEnabledImpl:function(){var _110f=true;if(has("webkit")){return true;}else{_110f=this._browserQueryCommandEnabled("paste");}return _110f;},_inserthorizontalruleImpl:function(_1110){if(has("ie")){return this._inserthtmlImpl("<hr>");}return this.document.execCommand("inserthorizontalrule",false,_1110);},_unlinkImpl:function(_1111){if((this.queryCommandEnabled("unlink"))&&(has("mozilla")||has("webkit"))){var a=this.selection.getAncestorElement("a");this.selection.selectElement(a);return this.document.execCommand("unlink",false,null);}return this.document.execCommand("unlink",false,_1111);},_hilitecolorImpl:function(_1112){var _1113;var _1114=this._handleTextColorOrProperties("hilitecolor",_1112);if(!_1114){if(has("mozilla")){this.document.execCommand("styleWithCSS",false,true);_1113=this.document.execCommand("hilitecolor",false,_1112);this.document.execCommand("styleWithCSS",false,false);}else{_1113=this.document.execCommand("hilitecolor",false,_1112);}}return _1113;},_backcolorImpl:function(_1115){if(has("ie")){_1115=_1115?_1115:null;}var _1116=this._handleTextColorOrProperties("backcolor",_1115);if(!_1116){_1116=this.document.execCommand("backcolor",false,_1115);}return _1116;},_forecolorImpl:function(_1117){if(has("ie")){_1117=_1117?_1117:null;}var _1118=false;_1118=this._handleTextColorOrProperties("forecolor",_1117);if(!_1118){_1118=this.document.execCommand("forecolor",false,_1117);}return _1118;},_inserthtmlImpl:function(_1119){_1119=this._preFilterContent(_1119);var rv=true;if(has("ie")<9){var _111a=this.document.selection.createRange();if(this.document.selection.type.toUpperCase()==="CONTROL"){var n=_111a.item(0);while(_111a.length){_111a.remove(_111a.item(0));}n.outerHTML=_1119;}else{_111a.pasteHTML(_1119);}_111a.select();}else{if(has("trident")<8){var _111a;var _111b=_10d4.getSelection(this.window);if(_111b&&_111b.rangeCount&&_111b.getRangeAt){_111a=_111b.getRangeAt(0);_111a.deleteContents();var div=_10c8.create("div");div.innerHTML=_1119;var node,_111c;var n=this.document.createDocumentFragment();while((node=div.firstChild)){_111c=n.appendChild(node);}_111a.insertNode(n);if(_111c){_111a=_111a.cloneRange();_111a.setStartAfter(_111c);_111a.collapse(false);_111b.removeAllRanges();_111b.addRange(_111a);}}}else{if(has("mozilla")&&!_1119.length){this.selection.remove();}else{rv=this.document.execCommand("inserthtml",false,_1119);}}}return rv;},_boldImpl:function(_111d){var _111e=false;if(has("ie")||has("trident")){this._adaptIESelection();_111e=this._adaptIEFormatAreaAndExec("bold");}if(!_111e){_111e=this.document.execCommand("bold",false,_111d);}return _111e;},_italicImpl:function(_111f){var _1120=false;if(has("ie")||has("trident")){this._adaptIESelection();_1120=this._adaptIEFormatAreaAndExec("italic");}if(!_1120){_1120=this.document.execCommand("italic",false,_111f);}return _1120;},_underlineImpl:function(_1121){var _1122=false;if(has("ie")||has("trident")){this._adaptIESelection();_1122=this._adaptIEFormatAreaAndExec("underline");}if(!_1122){_1122=this.document.execCommand("underline",false,_1121);}return _1122;},_strikethroughImpl:function(_1123){var _1124=false;if(has("ie")||has("trident")){this._adaptIESelection();_1124=this._adaptIEFormatAreaAndExec("strikethrough");}if(!_1124){_1124=this.document.execCommand("strikethrough",false,_1123);}return _1124;},_superscriptImpl:function(_1125){var _1126=false;if(has("ie")||has("trident")){this._adaptIESelection();_1126=this._adaptIEFormatAreaAndExec("superscript");}if(!_1126){_1126=this.document.execCommand("superscript",false,_1125);}return _1126;},_subscriptImpl:function(_1127){var _1128=false;if(has("ie")||has("trident")){this._adaptIESelection();_1128=this._adaptIEFormatAreaAndExec("subscript");}if(!_1128){_1128=this.document.execCommand("subscript",false,_1127);}return _1128;},_fontnameImpl:function(_1129){var _112a;if(has("ie")||has("trident")){_112a=this._handleTextColorOrProperties("fontname",_1129);}if(!_112a){_112a=this.document.execCommand("fontname",false,_1129);}return _112a;},_fontsizeImpl:function(_112b){var _112c;if(has("ie")||has("trident")){_112c=this._handleTextColorOrProperties("fontsize",_112b);}if(!_112c){_112c=this.document.execCommand("fontsize",false,_112b);}return _112c;},_insertorderedlistImpl:function(_112d){var _112e=false;if(has("ie")||has("trident")||has("edge")){_112e=this._adaptIEList("insertorderedlist",_112d);}if(!_112e){_112e=this.document.execCommand("insertorderedlist",false,_112d);}return _112e;},_insertunorderedlistImpl:function(_112f){var _1130=false;if(has("ie")||has("trident")||has("edge")){_1130=this._adaptIEList("insertunorderedlist",_112f);}if(!_1130){_1130=this.document.execCommand("insertunorderedlist",false,_112f);}return _1130;},getHeaderHeight:function(){return this._getNodeChildrenHeight(this.header);},getFooterHeight:function(){return this._getNodeChildrenHeight(this.footer);},_getNodeChildrenHeight:function(node){var h=0;if(node&&node.childNodes){var i;for(i=0;i<node.childNodes.length;i++){var size=_10c9.position(node.childNodes[i]);h+=size.h;}}return h;},_isNodeEmpty:function(node,_1131){if(node.nodeType===1){if(node.childNodes.length>0){return this._isNodeEmpty(node.childNodes[0],_1131);}return true;}else{if(node.nodeType===3){return (node.nodeValue.substring(_1131)==="");}}return false;},_removeStartingRangeFromRange:function(node,range){if(node.nextSibling){range.setStart(node.nextSibling,0);}else{var _1132=node.parentNode;while(_1132&&_1132.nextSibling==null){_1132=_1132.parentNode;}if(_1132){range.setStart(_1132.nextSibling,0);}}return range;},_adaptIESelection:function(){var _1133=_10d4.getSelection(this.window);if(_1133&&_1133.rangeCount&&!_1133.isCollapsed){var range=_1133.getRangeAt(0);var _1134=range.startContainer;var _1135=range.startOffset;while(_1134.nodeType===3&&_1135>=_1134.length&&_1134.nextSibling){_1135=_1135-_1134.length;_1134=_1134.nextSibling;}var _1136=null;while(this._isNodeEmpty(_1134,_1135)&&_1134!==_1136){_1136=_1134;range=this._removeStartingRangeFromRange(_1134,range);_1134=range.startContainer;_1135=0;}_1133.removeAllRanges();_1133.addRange(range);}},_adaptIEFormatAreaAndExec:function(_1137){var _1138=_10d4.getSelection(this.window);var doc=this.document;var rs,ret,range,txt,_1139,_113a,_113b,sNode;if(_1137&&_1138&&_1138.isCollapsed){var _113c=this.queryCommandValue(_1137);if(_113c){var _113d=this._tagNamesForCommand(_1137);range=_1138.getRangeAt(0);var fs=range.startContainer;if(fs.nodeType===3){var _113e=range.endOffset;if(fs.length<_113e){ret=this._adjustNodeAndOffset(rs,_113e);fs=ret.node;_113e=ret.offset;}}var _113f;while(fs&&fs!==this.editNode){var tName=fs.tagName?fs.tagName.toLowerCase():"";if(array.indexOf(_113d,tName)>-1){_113f=fs;break;}fs=fs.parentNode;}if(_113f){rs=range.startContainer;var _1140=doc.createElement(_113f.tagName);_10c8.place(_1140,_113f,"after");if(rs&&rs.nodeType===3){var _1141,tNode;var _1142=range.endOffset;if(rs.length<_1142){ret=this._adjustNodeAndOffset(rs,_1142);rs=ret.node;_1142=ret.offset;}txt=rs.nodeValue;_1139=doc.createTextNode(txt.substring(0,_1142));var _1143=txt.substring(_1142,txt.length);if(_1143){_113a=doc.createTextNode(_1143);}_10c8.place(_1139,rs,"before");if(_113a){_113b=doc.createElement("span");_113b.className="ieFormatBreakerSpan";_10c8.place(_113b,rs,"after");_10c8.place(_113a,_113b,"after");_113a=_113b;}_10c8.destroy(rs);var _1144=_1139.parentNode;var _1145=[];var _1146;while(_1144!==_113f){var tg=_1144.tagName;_1146={tagName:tg};_1145.push(_1146);var newTg=doc.createElement(tg);if(_1144.style){if(newTg.style){if(_1144.style.cssText){newTg.style.cssText=_1144.style.cssText;_1146.cssText=_1144.style.cssText;}}}if(_1144.tagName==="FONT"){if(_1144.color){newTg.color=_1144.color;_1146.color=_1144.color;}if(_1144.face){newTg.face=_1144.face;_1146.face=_1144.face;}if(_1144.size){newTg.size=_1144.size;_1146.size=_1144.size;}}if(_1144.className){newTg.className=_1144.className;_1146.className=_1144.className;}if(_113a){_1141=_113a;while(_1141){tNode=_1141.nextSibling;newTg.appendChild(_1141);_1141=tNode;}}if(newTg.tagName==_1144.tagName){_113b=doc.createElement("span");_113b.className="ieFormatBreakerSpan";_10c8.place(_113b,_1144,"after");_10c8.place(newTg,_113b,"after");}else{_10c8.place(newTg,_1144,"after");}_1139=_1144;_113a=newTg;_1144=_1144.parentNode;}if(_113a){_1141=_113a;if(_1141.nodeType===1||(_1141.nodeType===3&&_1141.nodeValue)){_1140.innerHTML="";}while(_1141){tNode=_1141.nextSibling;_1140.appendChild(_1141);_1141=tNode;}}var _1147;if(_1145.length){_1146=_1145.pop();var _1148=doc.createElement(_1146.tagName);if(_1146.cssText&&_1148.style){_1148.style.cssText=_1146.cssText;}if(_1146.className){_1148.className=_1146.className;}if(_1146.tagName==="FONT"){if(_1146.color){_1148.color=_1146.color;}if(_1146.face){_1148.face=_1146.face;}if(_1146.size){_1148.size=_1146.size;}}_10c8.place(_1148,_1140,"before");while(_1145.length){_1146=_1145.pop();var _1149=doc.createElement(_1146.tagName);if(_1146.cssText&&_1149.style){_1149.style.cssText=_1146.cssText;}if(_1146.className){_1149.className=_1146.className;}if(_1146.tagName==="FONT"){if(_1146.color){_1149.color=_1146.color;}if(_1146.face){_1149.face=_1146.face;}if(_1146.size){_1149.size=_1146.size;}}_1148.appendChild(_1149);_1148=_1149;}sNode=doc.createTextNode(".");_113b.appendChild(sNode);_1148.appendChild(sNode);_1147=_10d4.create(this.window);_1147.setStart(sNode,0);_1147.setEnd(sNode,sNode.length);_1138.removeAllRanges();_1138.addRange(_1147);this.selection.collapse(false);sNode.parentNode.innerHTML="";}else{_113b=doc.createElement("span");_113b.className="ieFormatBreakerSpan";sNode=doc.createTextNode(".");_113b.appendChild(sNode);_10c8.place(_113b,_1140,"before");_1147=_10d4.create(this.window);_1147.setStart(sNode,0);_1147.setEnd(sNode,sNode.length);_1138.removeAllRanges();_1138.addRange(_1147);this.selection.collapse(false);sNode.parentNode.innerHTML="";}if(!_1140.firstChild){_10c8.destroy(_1140);}return true;}}return false;}else{range=_1138.getRangeAt(0);rs=range.startContainer;if(rs&&rs.nodeType===3){var _113e=range.startOffset;if(rs.length<_113e){ret=this._adjustNodeAndOffset(rs,_113e);rs=ret.node;_113e=ret.offset;}txt=rs.nodeValue;_1139=doc.createTextNode(txt.substring(0,_113e));var _1143=txt.substring(_113e);if(_1143!==""){_113a=doc.createTextNode(txt.substring(_113e));}_113b=doc.createElement("span");sNode=doc.createTextNode(".");_113b.appendChild(sNode);if(_1139.length){_10c8.place(_1139,rs,"after");}else{_1139=rs;}_10c8.place(_113b,_1139,"after");if(_113a){_10c8.place(_113a,_113b,"after");}_10c8.destroy(rs);var _1147=_10d4.create(this.window);_1147.setStart(sNode,0);_1147.setEnd(sNode,sNode.length);_1138.removeAllRanges();_1138.addRange(_1147);doc.execCommand(_1137);_10c8.place(_113b.firstChild,_113b,"before");_10c8.destroy(_113b);_1147.setStart(sNode,0);_1147.setEnd(sNode,sNode.length);_1138.removeAllRanges();_1138.addRange(_1147);this.selection.collapse(false);sNode.parentNode.innerHTML="";return true;}}}else{return false;}},_adaptIEList:function(_114a){var _114b=_10d4.getSelection(this.window);if(_114b.isCollapsed){if(_114b.rangeCount&&!this.queryCommandValue(_114a)){var range=_114b.getRangeAt(0);var sc=range.startContainer;if(sc&&sc.nodeType==3){if(!range.startOffset){var lType="ul";if(_114a==="insertorderedlist"){lType="ol";}var list=this.document.createElement(lType);var li=_10c8.create("li",null,list);_10c8.place(list,sc,"before");li.appendChild(sc);_10c8.create("br",null,list,"after");var _114c=_10d4.create(this.window);_114c.setStart(sc,0);_114c.setEnd(sc,sc.length);_114b.removeAllRanges();_114b.addRange(_114c);this.selection.collapse(true);return true;}}}}return false;},_handleTextColorOrProperties:function(_114d,_114e){var _114f=_10d4.getSelection(this.window);var doc=this.document;var rs,ret,range,txt,_1150,_1151,_1152,sNode;_114e=_114e||null;if(_114d&&_114f&&_114f.isCollapsed){if(_114f.rangeCount){range=_114f.getRangeAt(0);rs=range.startContainer;if(rs&&rs.nodeType===3){var _1153=range.startOffset;if(rs.length<_1153){ret=this._adjustNodeAndOffset(rs,_1153);rs=ret.node;_1153=ret.offset;}txt=rs.nodeValue;_1150=doc.createTextNode(txt.substring(0,_1153));var _1154=txt.substring(_1153);if(_1154!==""){_1151=doc.createTextNode(txt.substring(_1153));}_1152=doc.createElement("span");sNode=doc.createTextNode(".");_1152.appendChild(sNode);var _1155=doc.createElement("span");_1152.appendChild(_1155);if(_1150.length){_10c8.place(_1150,rs,"after");}else{_1150=rs;}_10c8.place(_1152,_1150,"after");if(_1151){_10c8.place(_1151,_1152,"after");}_10c8.destroy(rs);var _1156=_10d4.create(this.window);_1156.setStart(sNode,0);_1156.setEnd(sNode,sNode.length);_114f.removeAllRanges();_114f.addRange(_1156);if(has("webkit")){var style="color";if(_114d==="hilitecolor"||_114d==="backcolor"){style="backgroundColor";}_10ca.set(_1152,style,_114e);this.selection.remove();_10c8.destroy(_1155);_1152.innerHTML="&#160;";this.selection.selectElement(_1152);this.focus();}else{this.execCommand(_114d,_114e);_10c8.place(_1152.firstChild,_1152,"before");_10c8.destroy(_1152);_1156.setStart(sNode,0);_1156.setEnd(sNode,sNode.length);_114f.removeAllRanges();_114f.addRange(_1156);this.selection.collapse(false);sNode.parentNode.removeChild(sNode);}return true;}}}return false;},_adjustNodeAndOffset:function(node,_1157){while(node.length<_1157&&node.nextSibling&&node.nextSibling.nodeType===3){_1157=_1157-node.length;node=node.nextSibling;}return {"node":node,"offset":_1157};},_tagNamesForCommand:function(_1158){if(_1158==="bold"){return ["b","strong"];}else{if(_1158==="italic"){return ["i","em"];}else{if(_1158==="strikethrough"){return ["s","strike"];}else{if(_1158==="superscript"){return ["sup"];}else{if(_1158==="subscript"){return ["sub"];}else{if(_1158==="underline"){return ["u"];}}}}}}return [];},_stripBreakerNodes:function(node){if(!this.isLoaded){return;}query(".ieFormatBreakerSpan",node).forEach(function(b){while(b.firstChild){_10c8.place(b.firstChild,b,"before");}_10c8.destroy(b);});return node;},_stripTrailingEmptyNodes:function(node){function _1159(node){return (/^(p|div|br)$/i.test(node.nodeName)&&node.children.length==0&&/^[\s\xA0]*$/.test(node.textContent||node.innerText||""))||(node.nodeType===3&&/^[\s\xA0]*$/.test(node.nodeValue));};while(node.lastChild&&_1159(node.lastChild)){_10c8.destroy(node.lastChild);}return node;},_setTextDirAttr:function(value){this._set("textDir",value);this.onLoadDeferred.then(lang.hitch(this,function(){this.editNode.dir=value;}));}});return _10d6;});},"dijit/selection":function(){define(["dojo/_base/array","dojo/dom","dojo/_base/lang","dojo/sniff","dojo/_base/window","dijit/focus"],function(array,dom,lang,has,_115a,focus){var _115b=function(win){var doc=win.document;this.getType=function(){if(doc.getSelection){var stype="text";var oSel;try{oSel=win.getSelection();}catch(e){}if(oSel&&oSel.rangeCount==1){var _115c=oSel.getRangeAt(0);if((_115c.startContainer==_115c.endContainer)&&((_115c.endOffset-_115c.startOffset)==1)&&(_115c.startContainer.nodeType!=3)){stype="control";}}return stype;}else{return doc.selection.type.toLowerCase();}};this.getSelectedText=function(){if(doc.getSelection){var _115d=win.getSelection();return _115d?_115d.toString():"";}else{if(this.getType()=="control"){return null;}return doc.selection.createRange().text;}};this.getSelectedHtml=function(){if(doc.getSelection){var _115e=win.getSelection();if(_115e&&_115e.rangeCount){var i;var html="";for(i=0;i<_115e.rangeCount;i++){var frag=_115e.getRangeAt(i).cloneContents();var div=doc.createElement("div");div.appendChild(frag);html+=div.innerHTML;}return html;}return null;}else{if(this.getType()=="control"){return null;}return doc.selection.createRange().htmlText;}};this.getSelectedElement=function(){if(this.getType()=="control"){if(doc.getSelection){var _115f=win.getSelection();return _115f.anchorNode.childNodes[_115f.anchorOffset];}else{var range=doc.selection.createRange();if(range&&range.item){return doc.selection.createRange().item(0);}}}return null;};this.getParentElement=function(){if(this.getType()=="control"){var p=this.getSelectedElement();if(p){return p.parentNode;}}else{if(doc.getSelection){var _1160=doc.getSelection();if(_1160){var node=_1160.anchorNode;while(node&&(node.nodeType!=1)){node=node.parentNode;}return node;}}else{var r=doc.selection.createRange();r.collapse(true);return r.parentElement();}}return null;};this.hasAncestorElement=function(_1161){return this.getAncestorElement.apply(this,arguments)!=null;};this.getAncestorElement=function(_1162){var node=this.getSelectedElement()||this.getParentElement();return this.getParentOfType(node,arguments);};this.isTag=function(node,tags){if(node&&node.tagName){var _1163=node.tagName.toLowerCase();for(var i=0;i<tags.length;i++){var _1164=String(tags[i]).toLowerCase();if(_1163==_1164){return _1164;}}}return "";};this.getParentOfType=function(node,tags){while(node){if(this.isTag(node,tags).length){return node;}node=node.parentNode;}return null;};this.collapse=function(_1165){if(doc.getSelection){var _1166=win.getSelection();if(_1166.removeAllRanges){if(_1165){_1166.collapseToStart();}else{_1166.collapseToEnd();}}else{_1166.collapse(_1165);}}else{var range=doc.selection.createRange();range.collapse(_1165);range.select();}};this.remove=function(){var sel=doc.selection;if(doc.getSelection){sel=win.getSelection();sel.deleteFromDocument();return sel;}else{if(sel.type.toLowerCase()!="none"){sel.clear();}return sel;}};this.selectElementChildren=function(_1167,_1168){var range;_1167=dom.byId(_1167);if(doc.getSelection){var _1169=win.getSelection();if(has("opera")){if(_1169.rangeCount){range=_1169.getRangeAt(0);}else{range=doc.createRange();}range.setStart(_1167,0);range.setEnd(_1167,(_1167.nodeType==3)?_1167.length:_1167.childNodes.length);_1169.addRange(range);}else{_1169.selectAllChildren(_1167);}}else{range=_1167.ownerDocument.body.createTextRange();range.moveToElementText(_1167);if(!_1168){try{range.select();}catch(e){}}}};this.selectElement=function(_116a,_116b){var range;_116a=dom.byId(_116a);if(doc.getSelection){var _116c=doc.getSelection();range=doc.createRange();if(_116c.removeAllRanges){if(has("opera")){if(_116c.getRangeAt(0)){range=_116c.getRangeAt(0);}}range.selectNode(_116a);_116c.removeAllRanges();_116c.addRange(range);}}else{try{var tg=_116a.tagName?_116a.tagName.toLowerCase():"";if(tg==="img"||tg==="table"){range=_115a.body(doc).createControlRange();}else{range=_115a.body(doc).createRange();}range.addElement(_116a);if(!_116b){range.select();}}catch(e){this.selectElementChildren(_116a,_116b);}}};this.inSelection=function(node){if(node){var _116d;var range;if(doc.getSelection){var sel=win.getSelection();if(sel&&sel.rangeCount>0){range=sel.getRangeAt(0);}if(range&&range.compareBoundaryPoints&&doc.createRange){try{_116d=doc.createRange();_116d.setStart(node,0);if(range.compareBoundaryPoints(range.START_TO_END,_116d)===1){return true;}}catch(e){}}}else{range=doc.selection.createRange();try{_116d=node.ownerDocument.body.createTextRange();_116d.moveToElementText(node);}catch(e2){}if(range&&_116d){if(range.compareEndPoints("EndToStart",_116d)===1){return true;}}}}return false;};this.getBookmark=function(){var bm,rg,tg,sel=doc.selection,cf=focus.curNode;if(doc.getSelection){sel=win.getSelection();if(sel){if(sel.isCollapsed){tg=cf?cf.tagName:"";if(tg){tg=tg.toLowerCase();if(tg=="textarea"||(tg=="input"&&(!cf.type||cf.type.toLowerCase()=="text"))){sel={start:cf.selectionStart,end:cf.selectionEnd,node:cf,pRange:true};return {isCollapsed:(sel.end<=sel.start),mark:sel};}}bm={isCollapsed:true};if(sel.rangeCount){bm.mark=sel.getRangeAt(0).cloneRange();}}else{rg=sel.getRangeAt(0);bm={isCollapsed:false,mark:rg.cloneRange()};}}}else{if(sel){tg=cf?cf.tagName:"";tg=tg.toLowerCase();if(cf&&tg&&(tg=="button"||tg=="textarea"||tg=="input")){if(sel.type&&sel.type.toLowerCase()=="none"){return {isCollapsed:true,mark:null};}else{rg=sel.createRange();return {isCollapsed:rg.text&&rg.text.length?false:true,mark:{range:rg,pRange:true}};}}bm={};try{rg=sel.createRange();bm.isCollapsed=!(sel.type=="Text"?rg.htmlText.length:rg.length);}catch(e){bm.isCollapsed=true;return bm;}if(sel.type.toUpperCase()=="CONTROL"){if(rg.length){bm.mark=[];var i=0,len=rg.length;while(i<len){bm.mark.push(rg.item(i++));}}else{bm.isCollapsed=true;bm.mark=null;}}else{bm.mark=rg.getBookmark();}}else{console.warn("No idea how to store the current selection for this browser!");}}return bm;};this.moveToBookmark=function(_116e){var mark=_116e.mark;if(mark){if(doc.getSelection){var sel=win.getSelection();if(sel&&sel.removeAllRanges){if(mark.pRange){var n=mark.node;n.selectionStart=mark.start;n.selectionEnd=mark.end;}else{sel.removeAllRanges();sel.addRange(mark);}}else{console.warn("No idea how to restore selection for this browser!");}}else{if(doc.selection&&mark){var rg;if(mark.pRange){rg=mark.range;}else{if(lang.isArray(mark)){rg=doc.body.createControlRange();array.forEach(mark,function(n){rg.addElement(n);});}else{rg=doc.body.createTextRange();rg.moveToBookmark(mark);}}rg.select();}}}};this.isCollapsed=function(){return this.getBookmark().isCollapsed;};};var _116f=new _115b(window);_116f.SelectionManager=_115b;return _116f;});},"dijit/_editor/range":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/lang"],function(array,_1170,lang){var _1171={getIndex:function(node,_1172){var ret=[],retR=[];var onode=node;var pnode,n;while(node!=_1172){var i=0;pnode=node.parentNode;while((n=pnode.childNodes[i++])){if(n===node){--i;break;}}ret.unshift(i);retR.unshift(i-pnode.childNodes.length);node=pnode;}if(ret.length>0&&onode.nodeType==3){n=onode.previousSibling;while(n&&n.nodeType==3){ret[ret.length-1]--;n=n.previousSibling;}n=onode.nextSibling;while(n&&n.nodeType==3){retR[retR.length-1]++;n=n.nextSibling;}}return {o:ret,r:retR};},getNode:function(index,_1173){if(!lang.isArray(index)||index.length==0){return _1173;}var node=_1173;array.every(index,function(i){if(i>=0&&i<node.childNodes.length){node=node.childNodes[i];}else{node=null;return false;}return true;});return node;},getCommonAncestor:function(n1,n2,root){root=root||n1.ownerDocument.body;var _1174=function(n){var as=[];while(n){as.unshift(n);if(n!==root){n=n.parentNode;}else{break;}}return as;};var n1as=_1174(n1);var n2as=_1174(n2);var m=Math.min(n1as.length,n2as.length);var com=n1as[0];for(var i=1;i<m;i++){if(n1as[i]===n2as[i]){com=n1as[i];}else{break;}}return com;},getAncestor:function(node,regex,root){root=root||node.ownerDocument.body;while(node&&node!==root){var name=node.nodeName.toUpperCase();if(regex.test(name)){return node;}node=node.parentNode;}return null;},BlockTagNames:/^(?:P|DIV|H1|H2|H3|H4|H5|H6|ADDRESS|PRE|OL|UL|LI|DT|DE)$/,getBlockAncestor:function(node,regex,root){root=root||node.ownerDocument.body;regex=regex||_1171.BlockTagNames;var block=null,_1175;while(node&&node!==root){var name=node.nodeName.toUpperCase();if(!block&&regex.test(name)){block=node;}if(!_1175&&(/^(?:BODY|TD|TH|CAPTION)$/).test(name)){_1175=node;}node=node.parentNode;}return {blockNode:block,blockContainer:_1175||node.ownerDocument.body};},atBeginningOfContainer:function(_1176,node,_1177){var _1178=false;var _1179=(_1177==0);if(!_1179&&node.nodeType==3){if(/^[\s\xA0]+$/.test(node.nodeValue.substr(0,_1177))){_1179=true;}}if(_1179){var cnode=node;_1178=true;while(cnode&&cnode!==_1176){if(cnode.previousSibling){_1178=false;break;}cnode=cnode.parentNode;}}return _1178;},atEndOfContainer:function(_117a,node,_117b){var atEnd=false;var _117c=(_117b==(node.length||node.childNodes.length));if(!_117c&&node.nodeType==3){if(/^[\s\xA0]+$/.test(node.nodeValue.substr(_117b))){_117c=true;}}if(_117c){var cnode=node;atEnd=true;while(cnode&&cnode!==_117a){if(cnode.nextSibling){atEnd=false;break;}cnode=cnode.parentNode;}}return atEnd;},adjacentNoneTextNode:function(_117d,next){var node=_117d;var len=(0-_117d.length)||0;var prop=next?"nextSibling":"previousSibling";while(node){if(node.nodeType!=3){break;}len+=node.length;node=node[prop];}return [node,len];},create:function(win){win=win||window;if(win.getSelection){return win.document.createRange();}else{return new _117e();}},getSelection:function(_117f,_1180){if(_117f.getSelection){return _117f.getSelection();}else{var s=new ie.selection(_117f);if(!_1180){s._getCurrentSelection();}return s;}}};if(!window.getSelection){var ie=_1171.ie={cachedSelection:{},selection:function(_1181){this._ranges=[];this.addRange=function(r,_1182){this._ranges.push(r);if(!_1182){r._select();}this.rangeCount=this._ranges.length;};this.removeAllRanges=function(){this._ranges=[];this.rangeCount=0;};var _1183=function(){var r=_1181.document.selection.createRange();var type=_1181.document.selection.type.toUpperCase();if(type=="CONTROL"){return new _117e(ie.decomposeControlRange(r));}else{return new _117e(ie.decomposeTextRange(r));}};this.getRangeAt=function(i){return this._ranges[i];};this._getCurrentSelection=function(){this.removeAllRanges();var r=_1183();if(r){this.addRange(r,true);this.isCollapsed=r.collapsed;}else{this.isCollapsed=true;}};},decomposeControlRange:function(range){var _1184=range.item(0),_1185=range.item(range.length-1);var _1186=_1184.parentNode,_1187=_1185.parentNode;var _1188=_1171.getIndex(_1184,_1186).o[0];var _1189=_1171.getIndex(_1185,_1187).o[0]+1;return [_1186,_1188,_1187,_1189];},getEndPoint:function(range,end){var _118a=range.duplicate();_118a.collapse(!end);var _118b="EndTo"+(end?"End":"Start");var _118c=_118a.parentElement();var _118d,_118e,_118f;if(_118c.childNodes.length>0){array.every(_118c.childNodes,function(node,i){var _1190;if(node.nodeType!=3){_118a.moveToElementText(node);if(_118a.compareEndPoints(_118b,range)>0){if(_118f&&_118f.nodeType==3){_118d=_118f;_1190=true;}else{_118d=_118c;_118e=i;return false;}}else{if(i==_118c.childNodes.length-1){_118d=_118c;_118e=_118c.childNodes.length;return false;}}}else{if(i==_118c.childNodes.length-1){_118d=node;_1190=true;}}if(_1190&&_118d){var _1191=_1171.adjacentNoneTextNode(_118d)[0];if(_1191){_118d=_1191.nextSibling;}else{_118d=_118c.firstChild;}var _1192=_1171.adjacentNoneTextNode(_118d);_1191=_1192[0];var _1193=_1192[1];if(_1191){_118a.moveToElementText(_1191);_118a.collapse(false);}else{_118a.moveToElementText(_118c);}_118a.setEndPoint(_118b,range);_118e=_118a.text.length-_1193;return false;}_118f=node;return true;});}else{_118d=_118c;_118e=0;}if(!end&&_118d.nodeType==1&&_118e==_118d.childNodes.length){var _1194=_118d.nextSibling;if(_1194&&_1194.nodeType==3){_118d=_1194;_118e=0;}}return [_118d,_118e];},setEndPoint:function(range,_1195,_1196){var _1197=range.duplicate(),node,len;if(_1195.nodeType!=3){if(_1196>0){node=_1195.childNodes[_1196-1];if(node){if(node.nodeType==3){_1195=node;_1196=node.length;}else{if(node.nextSibling&&node.nextSibling.nodeType==3){_1195=node.nextSibling;_1196=0;}else{_1197.moveToElementText(node.nextSibling?node:_1195);var _1198=node.parentNode;var _1199=_1198.insertBefore(node.ownerDocument.createTextNode(" "),node.nextSibling);_1197.collapse(false);_1198.removeChild(_1199);}}}}else{_1197.moveToElementText(_1195);_1197.collapse(true);}}if(_1195.nodeType==3){var _119a=_1171.adjacentNoneTextNode(_1195);var _119b=_119a[0];len=_119a[1];if(_119b){_1197.moveToElementText(_119b);_1197.collapse(false);if(_119b.contentEditable!="inherit"){len++;}}else{_1197.moveToElementText(_1195.parentNode);_1197.collapse(true);_1197.move("character",1);_1197.move("character",-1);}_1196+=len;if(_1196>0){if(_1197.move("character",_1196)!=_1196){console.error("Error when moving!");}}}return _1197;},decomposeTextRange:function(range){var _119c=ie.getEndPoint(range);var _119d=_119c[0],_119e=_119c[1];var _119f=_119c[0],_11a0=_119c[1];if(range.htmlText.length){if(range.htmlText==range.text){_11a0=_119e+range.text.length;}else{_119c=ie.getEndPoint(range,true);_119f=_119c[0],_11a0=_119c[1];}}return [_119d,_119e,_119f,_11a0];},setRange:function(range,_11a1,_11a2,_11a3,_11a4,_11a5){var start=ie.setEndPoint(range,_11a1,_11a2);range.setEndPoint("StartToStart",start);if(!_11a5){var end=ie.setEndPoint(range,_11a3,_11a4);}range.setEndPoint("EndToEnd",end||start);return range;}};var _117e=_1171.W3CRange=_1170(null,{constructor:function(){if(arguments.length>0){this.setStart(arguments[0][0],arguments[0][1]);this.setEnd(arguments[0][2],arguments[0][3]);}else{this.commonAncestorContainer=null;this.startContainer=null;this.startOffset=0;this.endContainer=null;this.endOffset=0;this.collapsed=true;}},_updateInternal:function(){if(this.startContainer!==this.endContainer){this.commonAncestorContainer=_1171.getCommonAncestor(this.startContainer,this.endContainer);}else{this.commonAncestorContainer=this.startContainer;}this.collapsed=(this.startContainer===this.endContainer)&&(this.startOffset==this.endOffset);},setStart:function(node,_11a6){_11a6=parseInt(_11a6);if(this.startContainer===node&&this.startOffset==_11a6){return;}delete this._cachedBookmark;this.startContainer=node;this.startOffset=_11a6;if(!this.endContainer){this.setEnd(node,_11a6);}else{this._updateInternal();}},setEnd:function(node,_11a7){_11a7=parseInt(_11a7);if(this.endContainer===node&&this.endOffset==_11a7){return;}delete this._cachedBookmark;this.endContainer=node;this.endOffset=_11a7;if(!this.startContainer){this.setStart(node,_11a7);}else{this._updateInternal();}},setStartAfter:function(node,_11a8){this._setPoint("setStart",node,_11a8,1);},setStartBefore:function(node,_11a9){this._setPoint("setStart",node,_11a9,0);},setEndAfter:function(node,_11aa){this._setPoint("setEnd",node,_11aa,1);},setEndBefore:function(node,_11ab){this._setPoint("setEnd",node,_11ab,0);},_setPoint:function(what,node,_11ac,ext){var index=_1171.getIndex(node,node.parentNode).o;this[what](node.parentNode,index.pop()+ext);},_getIERange:function(){var r=(this._body||this.endContainer.ownerDocument.body).createTextRange();ie.setRange(r,this.startContainer,this.startOffset,this.endContainer,this.endOffset,this.collapsed);return r;},getBookmark:function(){this._getIERange();return this._cachedBookmark;},_select:function(){var r=this._getIERange();r.select();},deleteContents:function(){var s=this.startContainer,r=this._getIERange();if(s.nodeType===3&&!this.startOffset){this.setStartBefore(s);}r.pasteHTML("");this.endContainer=this.startContainer;this.endOffset=this.startOffset;this.collapsed=true;},cloneRange:function(){var r=new _117e([this.startContainer,this.startOffset,this.endContainer,this.endOffset]);r._body=this._body;return r;},detach:function(){this._body=null;this.commonAncestorContainer=null;this.startContainer=null;this.startOffset=0;this.endContainer=null;this.endOffset=0;this.collapsed=true;}});}lang.setObject("dijit.range",_1171);return _1171;});},"dijit/_editor/html":function(){define(["dojo/_base/array","dojo/_base/lang","dojo/sniff"],function(array,lang,has){var _11ad={};lang.setObject("dijit._editor.html",_11ad);var _11ae=_11ad.escapeXml=function(str,_11af){str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");if(!_11af){str=str.replace(/'/gm,"&#39;");}return str;};_11ad.getNodeHtml=function(node){var _11b0=[];_11ad.getNodeHtmlHelper(node,_11b0);return _11b0.join("");};_11ad.getNodeHtmlHelper=function(node,_11b1){switch(node.nodeType){case 1:var lName=node.nodeName.toLowerCase();if(!lName||lName.charAt(0)=="/"){return "";}_11b1.push("<",lName);var _11b2=[],_11b3={};var attr;if(has("dom-attributes-explicit")||has("dom-attributes-specified-flag")){var i=0;while((attr=node.attributes[i++])){var n=attr.name;if(n.substr(0,3)!=="_dj"&&(!has("dom-attributes-specified-flag")||attr.specified)&&!(n in _11b3)){var v=attr.value;if(n=="src"||n=="href"){if(node.getAttribute("_djrealurl")){v=node.getAttribute("_djrealurl");}}if(has("ie")===8&&n==="style"){v=v.replace("HEIGHT:","height:").replace("WIDTH:","width:");}_11b2.push([n,v]);_11b3[n]=v;}}}else{var clone=/^input$|^img$/i.test(node.nodeName)?node:node.cloneNode(false);var s=clone.outerHTML;var _11b4=/[\w-]+=("[^"]*"|'[^']*'|\S*)/gi;var _11b5=s.match(_11b4);s=s.substr(0,s.indexOf(">"));array.forEach(_11b5,function(attr){if(attr){var idx=attr.indexOf("=");if(idx>0){var key=attr.substring(0,idx);if(key.substr(0,3)!="_dj"){if(key=="src"||key=="href"){if(node.getAttribute("_djrealurl")){_11b2.push([key,node.getAttribute("_djrealurl")]);return;}}var val,match;switch(key){case "style":val=node.style.cssText.toLowerCase();break;case "class":val=node.className;break;case "width":if(lName==="img"){match=/width=(\S+)/i.exec(s);if(match){val=match[1];}break;}case "height":if(lName==="img"){match=/height=(\S+)/i.exec(s);if(match){val=match[1];}break;}default:val=node.getAttribute(key);}if(val!=null){_11b2.push([key,val.toString()]);}}}}},this);}_11b2.sort(function(a,b){return a[0]<b[0]?-1:(a[0]==b[0]?0:1);});var j=0;while((attr=_11b2[j++])){_11b1.push(" ",attr[0],"=\"",(typeof attr[1]==="string"?_11ae(attr[1],true):attr[1]),"\"");}switch(lName){case "br":case "hr":case "img":case "input":case "base":case "meta":case "area":case "basefont":_11b1.push(" />");break;case "script":_11b1.push(">",node.innerHTML,"</",lName,">");break;default:_11b1.push(">");if(node.hasChildNodes()){_11ad.getChildrenHtmlHelper(node,_11b1);}_11b1.push("</",lName,">");}break;case 4:case 3:_11b1.push(_11ae(node.nodeValue,true));break;case 8:_11b1.push("<!--",_11ae(node.nodeValue,true),"-->");break;default:_11b1.push("<!-- Element not recognized - Type: ",node.nodeType," Name: ",node.nodeName,"-->");}};_11ad.getChildrenHtml=function(node){var _11b6=[];_11ad.getChildrenHtmlHelper(node,_11b6);return _11b6.join("");};_11ad.getChildrenHtmlHelper=function(dom,_11b7){if(!dom){return;}var nodes=dom["childNodes"]||dom;var _11b8=!has("ie")||nodes!==dom;var node,i=0;while((node=nodes[i++])){if(!_11b8||node.parentNode==dom){_11ad.getNodeHtmlHelper(node,_11b7);}}};return _11ad;});},"dojox/grid/enhanced/plugins/filter/FilterStatusTip":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/query","dojo/string","dojo/date/locale","dijit/_Widget","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin","dijit/TooltipDialog","dijit/form/Button","dijit/_base/popup","dojo/text!../../templates/FilterStatusPane.html","dojo/i18n!../../nls/Filter"],function(_11b9,array,lang,query,_11ba,_11bb,_11bc,_11bd,_11be,_11bf,_11c0,popup,_11c1){var _11c2="",_11c3="",_11c4="",_11c5="",_11c6="dojoxGridFStatusTipOddRow",_11c7="dojoxGridFStatusTipHandle",_11c8="dojoxGridFStatusTipCondition",_11c9="dojoxGridFStatusTipDelRuleBtnIcon",_11ca="</tbody></table>";var _11cb=_11b9("dojox.grid.enhanced.plugins.filter.FilterStatusPane",[_11bc,_11bd],{templateString:_11c1});return _11b9("dojox.grid.enhanced.plugins.filter.FilterStatusTip",null,{constructor:function(args){var _11cc=this.plugin=args.plugin;this._statusHeader=["<table border='0' cellspacing='0' class='",_11c2,"'><thead><tr class='",_11c3,"'><th class='",_11c4,"'><div>",_11cc.nls["statusTipHeaderColumn"],"</div></th><th class='",_11c4," lastColumn'><div>",_11cc.nls["statusTipHeaderCondition"],"</div></th></tr></thead><tbody>"].join("");this._removedCriterias=[];this._rules=[];this.statusPane=new _11cb();this._dlg=new _11bf({"class":"dijitTooltipBelow dojoxGridFStatusTipDialog",content:this.statusPane,autofocus:false});this._dlg.connect(this._dlg.domNode,"onmouseleave",lang.hitch(this,this.closeDialog));this._dlg.connect(this._dlg.domNode,"click",lang.hitch(this,this._modifyFilter));},destroy:function(){this._dlg.destroyRecursive();},showDialog:function(pos_x,pos_y,_11cd){this._pos={x:pos_x,y:pos_y};popup.close(this._dlg);this._removedCriterias=[];this._rules=[];this._updateStatus(_11cd);popup.open({popup:this._dlg,parent:this.plugin.filterBar,onCancel:function(){},x:pos_x-12,y:pos_y-3});},closeDialog:function(){popup.close(this._dlg);if(this._removedCriterias.length){this.plugin.filterDefDialog.removeCriteriaBoxes(this._removedCriterias);this._removedCriterias=[];this.plugin.filterDefDialog.onFilter();}},_updateStatus:function(_11ce){var res,p=this.plugin,nls=p.nls,sp=this.statusPane,fdg=p.filterDefDialog;if(fdg.getCriteria()===0){sp.statusTitle.innerHTML=nls["statusTipTitleNoFilter"];sp.statusRel.innerHTML="";var cell=p.grid.layout.cells[_11ce];var _11cf=cell?"'"+(cell.name||cell.field)+"'":nls["anycolumn"];res=_11ba.substitute(nls["statusTipMsg"],[_11cf]);}else{sp.statusTitle.innerHTML=nls["statusTipTitleHasFilter"];sp.statusRel.innerHTML=fdg._relOpCls=="logicall"?nls["statusTipRelAll"]:nls["statusTipRelAny"];this._rules=[];var i=0,c=fdg.getCriteria(i++);while(c){c.index=i-1;this._rules.push(c);c=fdg.getCriteria(i++);}res=this._createStatusDetail();}sp.statusDetailNode.innerHTML=res;this._addButtonForRules();},_createStatusDetail:function(){return this._statusHeader+array.map(this._rules,function(rule,i){return this._getCriteriaStr(rule,i);},this).join("")+_11ca;},_addButtonForRules:function(){if(this._rules.length>1){query("."+_11c7,this.statusPane.statusDetailNode).forEach(lang.hitch(this,function(nd,idx){(new _11c0({label:this.plugin.nls["removeRuleButton"],showLabel:false,iconClass:_11c9,onClick:lang.hitch(this,function(e){e.stopPropagation();this._removedCriterias.push(this._rules[idx].index);this._rules.splice(idx,1);this.statusPane.statusDetailNode.innerHTML=this._createStatusDetail();this._addButtonForRules();})})).placeAt(nd,"last");}));}},_getCriteriaStr:function(c,_11d0){var res=["<tr class='",_11c5," ",(_11d0%2?_11c6:""),"'><td class='",_11c4,"'>",c.colTxt,"</td><td class='",_11c4,"'><div class='",_11c7,"'><span class='",_11c8,"'>",c.condTxt,"&nbsp;</span>",c.formattedVal,"</div></td></tr>"];return res.join("");},_modifyFilter:function(){this.closeDialog();var p=this.plugin;p.filterDefDialog.showDialog(p.filterBar.getColumnIdx(this._pos.x));}});});},"dijit/TooltipDialog":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","./focus","./layout/ContentPane","./_DialogMixin","./form/_FormMixin","./_TemplatedMixin","dojo/text!./templates/TooltipDialog.html","./main"],function(_11d1,_11d2,has,keys,lang,on,focus,_11d3,_11d4,_11d5,_11d6,_11d7,dijit){var _11d8=_11d1("dijit.TooltipDialog",[_11d3,_11d6,_11d5,_11d4],{title:"",doLayout:false,autofocus:true,baseClass:"dijitTooltipDialog",_firstFocusItem:null,_lastFocusItem:null,templateString:_11d7,_setTitleAttr:"containerNode",postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKey")));},orient:function(node,_11d9,_11da){var newC={"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft","BR-TL":"dijitTooltipBelow dijitTooltipABLeft","BL-TR":"dijitTooltipBelow dijitTooltipABRight","TL-BR":"dijitTooltipAbove dijitTooltipABRight","TR-BL":"dijitTooltipAbove dijitTooltipABLeft"}[_11d9+"-"+_11da];_11d2.replace(this.domNode,newC,this._currentOrientClass||"");this._currentOrientClass=newC;},focus:function(){this._getFocusItems();focus.focus(this._firstFocusItem);},onOpen:function(pos){this.orient(this.domNode,pos.aroundCorner,pos.corner);var _11db=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_11db.y+((_11db.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_11db.x+((_11db.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}}this._onShow();},onClose:function(){this.onHide();},_onKey:function(evt){if(evt.keyCode==keys.ESCAPE){this.defer("onCancel");evt.stopPropagation();evt.preventDefault();}else{if(evt.keyCode==keys.TAB){var node=evt.target;this._getFocusItems();if(this._firstFocusItem==this._lastFocusItem){evt.stopPropagation();evt.preventDefault();}else{if(node==this._firstFocusItem&&evt.shiftKey){focus.focus(this._lastFocusItem);evt.stopPropagation();evt.preventDefault();}else{if(node==this._lastFocusItem&&!evt.shiftKey){focus.focus(this._firstFocusItem);evt.stopPropagation();evt.preventDefault();}else{evt.stopPropagation();}}}}}}});if(has("dojo-bidi")){_11d8.extend({_setTitleAttr:function(title){this.containerNode.title=(this.textDir&&this.enforceTextDirWithUcc)?this.enforceTextDirWithUcc(null,title):title;this._set("title",title);},_setTextDirAttr:function(_11dc){if(!this._created||this.textDir!=_11dc){this._set("textDir",_11dc);if(this.textDir&&this.title){this.containerNode.title=this.enforceTextDirWithUcc(null,this.title);}}}});}return _11d8;});},"dijit/_base/popup":function(){define(["dojo/dom-class","dojo/_base/window","../popup","../BackgroundIframe"],function(_11dd,win,popup){var _11de=popup._createWrapper;popup._createWrapper=function(_11df){if(!_11df.declaredClass){_11df={_popupWrapper:(_11df.parentNode&&_11dd.contains(_11df.parentNode,"dijitPopup"))?_11df.parentNode:null,domNode:_11df,destroy:function(){},ownerDocument:_11df.ownerDocument,ownerDocumentBody:win.body(_11df.ownerDocument)};}return _11de.call(this,_11df);};var _11e0=popup.open;popup.open=function(args){if(args.orient&&typeof args.orient!="string"&&!("length" in args.orient)){var ary=[];for(var key in args.orient){ary.push({aroundCorner:key,corner:args.orient[key]});}args.orient=ary;}return _11e0.call(this,args);};return popup;});},"dojox/grid/enhanced/plugins/filter/ClearFilterConfirm":function(){define(["dojo/_base/declare","dijit/_Widget","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin","dojo/text!../../templates/ClearFilterConfirmPane.html"],function(_11e1,_11e2,_11e3,_11e4,_11e5){return _11e1("dojox.grid.enhanced.plugins.filter.ClearFilterConfirm",[_11e2,_11e3,_11e4],{templateString:_11e5,widgetsInTemplate:true,plugin:null,postMixInProperties:function(){var nls=this.plugin.nls;this._clearBtnLabel=nls["clearButton"];this._cancelBtnLabel=nls["cancelButton"];this._clearFilterMsg=nls["clearFilterMsg"];},postCreate:function(){this.inherited(arguments);this.cancelBtn.domNode.setAttribute("aria-label",this.plugin.nls["waiCancelButton"]);this.clearBtn.domNode.setAttribute("aria-label",this.plugin.nls["waiClearButton"]);},uninitialize:function(){this.plugin=null;},_onCancel:function(){this.plugin.clearFilterDialog.hide();},_onClear:function(){this.plugin.clearFilterDialog.hide();this.plugin.filterDefDialog.clearFilter(this.plugin.filterDefDialog._clearWithoutRefresh);}});});},"dojox/grid/enhanced/plugins/exporter/CSVWriter":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/_base/array","./_ExportWriter","../Exporter"],function(_11e6,lang,array,_11e7,_11e8){_11e8.registerWriter("csv","dojox.grid.enhanced.plugins.exporter.CSVWriter");return _11e6("dojox.grid.enhanced.plugins.exporter.CSVWriter",_11e7,{_separator:",",_newline:"\r\n",constructor:function(_11e9){if(_11e9){this._separator=_11e9.separator?_11e9.separator:this._separator;this._newline=_11e9.newline?_11e9.newline:this._newline;}this._headers=[];this._dataRows=[];},_formatCSVCell:function(_11ea){if(_11ea===null||_11ea===undefined){return "";}var _11eb=String(_11ea).replace(/"/g,"\"\"");if(_11eb.indexOf(this._separator)>=0||_11eb.search(/[" \t\r\n]/)>=0){_11eb="\""+_11eb+"\"";}return _11eb;},beforeContentRow:function(_11ec){var row=[],func=lang.hitch(this,this._formatCSVCell);array.forEach(_11ec.grid.layout.cells,function(cell){if(!cell.hidden&&array.indexOf(_11ec.spCols,cell.index)<0){row.push(func(this._getExportDataForCell(_11ec.rowIndex,_11ec.row,cell,_11ec.grid)));}},this);this._dataRows.push(row);return false;},handleCell:function(_11ed){var cell=_11ed.cell;if(_11ed.isHeader&&!cell.hidden&&array.indexOf(_11ed.spCols,cell.index)<0){this._headers.push(cell.name||cell.field);}},toString:function(){var _11ee=this._headers.join(this._separator);for(var i=this._dataRows.length-1;i>=0;--i){this._dataRows[i]=this._dataRows[i].join(this._separator);}return _11ee+this._newline+this._dataRows.join(this._newline);}});});},"dojox/grid/enhanced/plugins/exporter/_ExportWriter":function(){define(["dojo/_base/declare"],function(_11ef){return _11ef("dojox.grid.enhanced.plugins.exporter._ExportWriter",null,{constructor:function(_11f0){},_getExportDataForCell:function(_11f1,_11f2,cell,grid){var data=(cell.get||grid.get).call(cell,_11f1,_11f2);if(this.formatter){return this.formatter(data,cell,_11f1,_11f2);}else{return data;}},beforeHeader:function(grid){return true;},afterHeader:function(){},beforeContent:function(items){return true;},afterContent:function(){},beforeContentRow:function(_11f3){return true;},afterContentRow:function(_11f4){},beforeView:function(_11f5){return true;},afterView:function(_11f6){},beforeSubrow:function(_11f7){return true;},afterSubrow:function(_11f8){},handleCell:function(_11f9){},toString:function(){return "";}});});},"dojox/grid/enhanced/plugins/Exporter":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","../_Plugin","../../_RowSelector","../../EnhancedGrid","../../cells/_base"],function(_11fa,array,lang,_11fb,_11fc,_11fd){var _11fe=lang.getObject("dojox.grid.cells");var _11ff=_11fa("dojox.grid.enhanced.plugins.Exporter",_11fb,{name:"exporter",constructor:function(grid,args){this.grid=grid;this.formatter=(args&&lang.isObject(args))&&args.exportFormatter;this._mixinGrid();},_mixinGrid:function(){var g=this.grid;g.exportTo=lang.hitch(this,this.exportTo);g.exportGrid=lang.hitch(this,this.exportGrid);g.exportSelected=lang.hitch(this,this.exportSelected);g.setExportFormatter=lang.hitch(this,this.setExportFormatter);},setExportFormatter:function(_1200){this.formatter=_1200;},exportGrid:function(type,args,_1201){if(lang.isFunction(args)){_1201=args;args={};}if(!lang.isString(type)||!lang.isFunction(_1201)){return;}args=args||{};var g=this.grid,_1202=this,_1203=this._getExportWriter(type,args.writerArgs),_1204=(args.fetchArgs&&lang.isObject(args.fetchArgs))?args.fetchArgs:{},_1205=_1204.onComplete;if(g.store){_1204.onComplete=function(items,_1206){if(_1205){_1205(items,_1206);}_1201(_1202._goThroughGridData(items,_1203));};_1204.sort=_1204.sort||g.getSortProps();g._storeLayerFetch(_1204);}else{var start=_1204.start||0,count=_1204.count||-1,items=[];for(var i=start;i!=start+count&&i<g.rowCount;++i){items.push(g.getItem(i));}_1201(this._goThroughGridData(items,_1203));}},exportSelected:function(type,_1207,_1208){if(!lang.isString(type)){return "";}var _1209=this._getExportWriter(type,_1207);return _1208(this._goThroughGridData(this.grid.selection.getSelected(),_1209));},_buildRow:function(_120a,_120b){var _120c=this;array.forEach(_120a._views,function(view,vIdx){_120a.view=view;_120a.viewIdx=vIdx;if(_120b.beforeView(_120a)){array.forEach(view.structure.cells,function(_120d,srIdx){_120a.subrow=_120d;_120a.subrowIdx=srIdx;if(_120b.beforeSubrow(_120a)){array.forEach(_120d,function(cell,cIdx){if(_120a.isHeader&&_120c._isSpecialCol(cell)){_120a.spCols.push(cell.index);}_120a.cell=cell;_120a.cellIdx=cIdx;_120b.handleCell(_120a);});_120b.afterSubrow(_120a);}});_120b.afterView(_120a);}});},_goThroughGridData:function(items,_120e){var grid=this.grid,views=array.filter(grid.views.views,function(view){return !(view instanceof _11fc);}),_120f={"grid":grid,"isHeader":true,"spCols":[],"_views":views,"colOffset":(views.length<grid.views.views.length?-1:0)};if(_120e.beforeHeader(grid)){this._buildRow(_120f,_120e);_120e.afterHeader();}_120f.isHeader=false;if(_120e.beforeContent(items)){array.forEach(items,function(item,rIdx){_120f.row=item;_120f.rowIdx=rIdx;if(_120e.beforeContentRow(_120f)){this._buildRow(_120f,_120e);_120e.afterContentRow(_120f);}},this);_120e.afterContent();}return _120e.toString();},_isSpecialCol:function(_1210){return _1210.isRowSelector||_1210 instanceof _11fe.RowIndex;},_getExportWriter:function(_1211,_1212){var _1213,cls,_1214=_11ff;if(_1214.writerNames){_1213=_1214.writerNames[_1211.toLowerCase()];cls=lang.getObject(_1213);if(cls){var _1215=new cls(_1212);_1215.formatter=this.formatter;return _1215;}else{throw new Error("Please make sure class \""+_1213+"\" is required.");}}throw new Error("The writer for \""+_1211+"\" has not been registered.");}});_11ff.registerWriter=function(_1216,_1217){_11ff.writerNames=_11ff.writerNames||{};_11ff.writerNames[_1216]=_1217;};_11fd.registerPlugin(_11ff);return _11ff;});},"dojox/grid/enhanced/plugins/Printer":function(){define(["dojo/_base/declare","dojo/_base/html","dojo/_base/Deferred","dojo/_base/lang","dojo/_base/sniff","dojo/_base/xhr","dojo/_base/array","dojo/query","dojo/DeferredList","../_Plugin","../../EnhancedGrid","./exporter/TableWriter"],function(_1218,html,_1219,lang,has,xhr,array,query,_121a,_121b,_121c,_121d){var _121e=_1218("dojox.grid.enhanced.plugins.Printer",_121b,{name:"printer",constructor:function(grid){this.grid=grid;this._mixinGrid(grid);grid.setExportFormatter(function(data,cell,_121f,_1220){return cell.format(_121f,_1220);});},_mixinGrid:function(){var g=this.grid;g.printGrid=lang.hitch(this,this.printGrid);g.printSelected=lang.hitch(this,this.printSelected);g.exportToHTML=lang.hitch(this,this.exportToHTML);g.exportSelectedToHTML=lang.hitch(this,this.exportSelectedToHTML);g.normalizePrintedGrid=lang.hitch(this,this.normalizeRowHeight);},printGrid:function(args){this.exportToHTML(args,lang.hitch(this,this._print));},printSelected:function(args){this.exportSelectedToHTML(args,lang.hitch(this,this._print));},exportToHTML:function(args,_1221){args=this._formalizeArgs(args);var _1222=this;this.grid.exportGrid("table",args,function(str){_1222._wrapHTML(args.title,args.cssFiles,args.titleInBody+str).then(_1221);});},exportSelectedToHTML:function(args,_1223){args=this._formalizeArgs(args);var _1224=this;this.grid.exportSelected("table",args.writerArgs,function(str){_1224._wrapHTML(args.title,args.cssFiles,args.titleInBody+str).then(_1223);});},_loadCSSFiles:function(_1225){var dl=array.map(_1225,function(_1226){_1226=lang.trim(_1226);if(_1226.substring(_1226.length-4).toLowerCase()===".css"){return xhr.get({url:_1226});}else{var d=new _1219();d.callback(_1226);return d;}});return _121a.prototype.gatherResults(dl);},_print:function(_1227){var win,_1228=this,_1229=function(w){var doc=w.document;doc.open();doc.write(_1227);doc.close();_1228.normalizeRowHeight(doc);};if(!window.print){return;}else{if(has("chrome")||has("opera")){win=window.open("javascript: ''","","status=0,menubar=0,location=0,toolbar=0,width=1,height=1,resizable=0,scrollbars=0");_1229(win);win.print();win.close();}else{var fn=this._printFrame,dn=this.grid.domNode;if(!fn){var _122a=dn.id+"_print_frame";if(!(fn=html.byId(_122a))){fn=html.create("iframe");fn.id=_122a;fn.frameBorder=0;html.style(fn,{width:"1px",height:"1px",position:"absolute",right:0,bottom:0,border:"none",overflow:"hidden"});if(!has("ie")){html.style(fn,"visibility","hidden");}dn.appendChild(fn);}this._printFrame=fn;}win=fn.contentWindow;_1229(win);win.focus();win.print();}}},_wrapHTML:function(title,_122b,_122c){return this._loadCSSFiles(_122b).then(function(_122d){var i,sb=["<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">","<html ",html._isBodyLtr()?"":"dir=\"rtl\"","><head><title>",title,"</title><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></meta>"];for(i=0;i<_122d.length;++i){sb.push("<style type=\"text/css\">",_122d[i],"</style>");}sb.push("</head>");if(_122c.search(/^\s*<body/i)<0){_122c="<body>"+_122c+"</body>";}sb.push(_122c,"</html>");return sb.join("");});},normalizeRowHeight:function(doc){var views=query(".grid_view",doc.body);var _122e=array.map(views,function(view){return query(".grid_header",view)[0];});var _122f=array.map(views,function(view){return query(".grid_row",view);});var _1230=_122f[0].length;var i,v,h,_1231=0;for(v=views.length-1;v>=0;--v){h=html.contentBox(_122e[v]).h;if(h>_1231){_1231=h;}}for(v=views.length-1;v>=0;--v){html.style(_122e[v],"height",_1231+"px");}for(i=0;i<_1230;++i){_1231=0;for(v=views.length-1;v>=0;--v){h=html.contentBox(_122f[v][i]).h;if(h>_1231){_1231=h;}}for(v=views.length-1;v>=0;--v){html.style(_122f[v][i],"height",_1231+"px");}}var left=0,ltr=html._isBodyLtr();for(v=0;v<views.length;++v){html.style(views[v],ltr?"left":"right",left+"px");left+=html.marginBox(views[v]).w;}},_formalizeArgs:function(args){args=(args&&lang.isObject(args))?args:{};args.title=String(args.title)||"";if(!lang.isArray(args.cssFiles)){args.cssFiles=[args.cssFiles];}args.titleInBody=args.title?["<h1>",args.title,"</h1>"].join(""):"";return args;}});_121c.registerPlugin(_121e,{"dependency":["exporter"]});return _121e;});},"dojo/DeferredList":function(){define(["./_base/kernel","./_base/Deferred","./_base/array"],function(dojo,_1232,_1233){dojo.DeferredList=function(list,_1234,_1235,_1236,_1237){var _1238=[];_1232.call(this);var self=this;if(list.length===0&&!_1234){this.resolve([0,[]]);}var _1239=0;_1233.forEach(list,function(item,i){item.then(function(_123a){if(_1234){self.resolve([i,_123a]);}else{_123b(true,_123a);}},function(error){if(_1235){self.reject(error);}else{_123b(false,error);}if(_1236){return null;}throw error;});function _123b(_123c,_123d){_1238[i]=[_123c,_123d];_1239++;if(_1239===list.length){self.resolve(_1238);}};});};dojo.DeferredList.prototype=new _1232();dojo.DeferredList.prototype.gatherResults=function(_123e){var d=new dojo.DeferredList(_123e,false,true,false);d.addCallback(function(_123f){var ret=[];_1233.forEach(_123f,function(_1240){ret.push(_1240[1]);});return ret;});return d;};return dojo.DeferredList;});},"dojox/grid/enhanced/plugins/exporter/TableWriter":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/dom-geometry","./_ExportWriter","../Exporter"],function(_1241,array,_1242,_1243,_1244){_1244.registerWriter("table","dojox.grid.enhanced.plugins.exporter.TableWriter");return _1241("dojox.grid.enhanced.plugins.exporter.TableWriter",_1243,{constructor:function(_1245){this._viewTables=[];this._tableAttrs=_1245||{};},_getTableAttrs:function(_1246){var attrs=this._tableAttrs[_1246]||"";if(attrs&&attrs[0]!=" "){attrs=" "+attrs;}return attrs;},_getRowClass:function(_1247){return _1247.isHeader?" grid_header":[" grid_row grid_row_",_1247.rowIdx+1,_1247.rowIdx%2?" grid_even_row":" grid_odd_row"].join("");},_getColumnClass:function(_1248){var _1249=_1248.cell.index+_1248.colOffset+1;return [" grid_column grid_column_",_1249,_1249%2?" grid_odd_column":" grid_even_column"].join("");},beforeView:function(_124a){var _124b=_124a.viewIdx,table=this._viewTables[_124b],_124c,width=_1242.getMarginBox(_124a.view.contentNode).w;if(!table){var left=0;for(var i=0;i<_124b;++i){left+=this._viewTables[i]._width;}table=this._viewTables[_124b]=["<div class=\"grid_view\" style=\"position: absolute; top: 0; ",_1242.isBodyLtr()?"left":"right",":",left,"px;\">"];}table._width=width;if(_124a.isHeader){_124c=_1242.getContentBox(_124a.view.headerContentNode).h;}else{var _124d=_124a.grid.getRowNode(_124a.rowIdx);if(_124d){_124c=_1242.getContentBox(_124d).h;}else{_124c=_124a.grid.scroller.averageRowHeight;}}table.push("<table class=\"",this._getRowClass(_124a),"\" style=\"table-layout:fixed; height:",_124c,"px; width:",width,"px;\" ","border=\"0\" cellspacing=\"0\" cellpadding=\"0\" ",this._getTableAttrs("table"),"><tbody ",this._getTableAttrs("tbody"),">");return true;},afterView:function(_124e){this._viewTables[_124e.viewIdx].push("</tbody></table>");},beforeSubrow:function(_124f){this._viewTables[_124f.viewIdx].push("<tr",this._getTableAttrs("tr"),">");return true;},afterSubrow:function(_1250){this._viewTables[_1250.viewIdx].push("</tr>");},handleCell:function(_1251){var cell=_1251.cell;if(cell.hidden||array.indexOf(_1251.spCols,cell.index)>=0){return;}var _1252=_1251.isHeader?"th":"td",attrs=[cell.colSpan?" colspan=\""+cell.colSpan+"\"":"",cell.rowSpan?" rowspan=\""+cell.rowSpan+"\"":""," style=\"width: ",_1242.getContentBox(cell.getHeaderNode()).w,"px;\"",this._getTableAttrs(_1252)," class=\"",this._getColumnClass(_1251),"\""].join(""),table=this._viewTables[_1251.viewIdx];table.push("<",_1252,attrs,">");if(_1251.isHeader){table.push(cell.name||cell.field);}else{table.push(this._getExportDataForCell(_1251.rowIdx,_1251.row,cell,_1251.grid));}table.push("</",_1252,">");},afterContent:function(){array.forEach(this._viewTables,function(table){table.push("</div>");});},toString:function(){var _1253=array.map(this._viewTables,function(table){return table.join("");}).join("");return ["<div style=\"position: relative;\">",_1253,"</div>"].join("");}});});},"dojox/grid/enhanced/plugins/Cookie":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/_base/sniff","dojo/_base/html","dojo/_base/json","dojo/_base/window","dojo/_base/unload","dojo/cookie","../_Plugin","../../_RowSelector","../../EnhancedGrid","../../cells/_base"],function(_1254,array,lang,has,html,json,win,_1255,_1256,_1257,_1258,_1259){var _125a=lang.getObject("dojox.grid.cells");var _125b=function(grid){return window.location+"/"+grid.id;};var _125c=function(_125d){var cells=[];if(!lang.isArray(_125d)){_125d=[_125d];}array.forEach(_125d,function(_125e){if(lang.isArray(_125e)){_125e={"cells":_125e};}var rows=_125e.rows||_125e.cells;if(lang.isArray(rows)){if(!lang.isArray(rows[0])){rows=[rows];}array.forEach(rows,function(row){if(lang.isArray(row)){array.forEach(row,function(cell){cells.push(cell);});}});}});return cells;};var _125f=function(_1260,grid){if(lang.isArray(_1260)){var _1261=grid._setStructureAttr;grid._setStructureAttr=function(_1262){if(!grid._colWidthLoaded){grid._colWidthLoaded=true;var cells=_125c(_1262);for(var i=cells.length-1;i>=0;--i){if(typeof _1260[i]=="number"){cells[i].width=_1260[i]+"px";}else{if(_1260[i]=="hidden"){cells[i].hidden=true;}}}}_1261.call(grid,_1262);grid._setStructureAttr=_1261;};}};var _1263=function(grid){return array.map(array.filter(grid.layout.cells,function(cell){return !(cell.isRowSelector||cell instanceof _125a.RowIndex);}),function(cell){return cell.hidden?"hidden":html[has("webkit")?"marginBox":"contentBox"](cell.getHeaderNode()).w;});};var _1264=function(_1265,grid){if(_1265&&array.every(_1265,function(_1266){return lang.isArray(_1266)&&array.every(_1266,function(_1267){return lang.isArray(_1267)&&_1267.length>0;});})){var _1268=grid._setStructureAttr;var _1269=function(def){return ("name" in def||"field" in def||"get" in def);};var _126a=function(def){return (def!==null&&lang.isObject(def)&&("cells" in def||"rows" in def||("type" in def&&!_1269(def))));};grid._setStructureAttr=function(_126b){if(!grid._colOrderLoaded){grid._colOrderLoaded=true;grid._setStructureAttr=_1268;_126b=lang.clone(_126b);if(lang.isArray(_126b)&&!array.some(_126b,_126a)){_126b=[{cells:_126b}];}else{if(_126a(_126b)){_126b=[_126b];}}var cells=_125c(_126b);array.forEach(lang.isArray(_126b)?_126b:[_126b],function(_126c,_126d){var _126e=_126c;if(lang.isArray(_126c)){_126c.splice(0,_126c.length);}else{delete _126c.rows;_126e=_126c.cells=[];}array.forEach(_1265[_126d],function(_126f){array.forEach(_126f,function(_1270){var i,cell;for(i=0;i<cells.length;++i){cell=cells[i];if(json.toJson({"name":cell.name,"field":cell.field})==json.toJson(_1270)){break;}}if(i<cells.length){_126e.push(cell);}});});});}_1268.call(grid,_126b);};}};var _1271=function(grid){var _1272=array.map(array.filter(grid.views.views,function(view){return !(view instanceof _1258);}),function(view){return array.map(view.structure.cells,function(_1273){return array.map(array.filter(_1273,function(cell){return !(cell.isRowSelector||cell instanceof _125a.RowIndex);}),function(cell){return {"name":cell.name,"field":cell.field};});});});return _1272;};var _1274=function(_1275,grid){try{if(_1275&&lang.isObject(_1275)){grid.setSortIndex(_1275.idx,_1275.asc);}}catch(e){}};var _1276=function(grid){return {idx:grid.getSortIndex(),asc:grid.getSortAsc()};};if(!has("ie")){_1255.addOnWindowUnload(function(){array.forEach(dijit.findWidgets(win.body()),function(_1277){if(_1277 instanceof _1259&&!_1277._destroyed){_1277.destroyRecursive();}});});}var _1278=_1254("dojox.grid.enhanced.plugins.Cookie",_1257,{name:"cookie",_cookieEnabled:true,constructor:function(grid,args){this.grid=grid;args=(args&&lang.isObject(args))?args:{};this.cookieProps=args.cookieProps;this._cookieHandlers=[];this._mixinGrid();this.addCookieHandler({name:"columnWidth",onLoad:_125f,onSave:_1263});this.addCookieHandler({name:"columnOrder",onLoad:_1264,onSave:_1271});this.addCookieHandler({name:"sortOrder",onLoad:_1274,onSave:_1276});array.forEach(this._cookieHandlers,function(_1279){if(args[_1279.name]===false){_1279.enable=false;}},this);},destroy:function(){this._saveCookie();this._cookieHandlers=null;this.inherited(arguments);},_mixinGrid:function(){var g=this.grid;g.addCookieHandler=lang.hitch(this,"addCookieHandler");g.removeCookie=lang.hitch(this,"removeCookie");g.setCookieEnabled=lang.hitch(this,"setCookieEnabled");g.getCookieEnabled=lang.hitch(this,"getCookieEnabled");},_saveCookie:function(){if(this.getCookieEnabled()){var ck={},chs=this._cookieHandlers,_127a=this.cookieProps,_127b=_125b(this.grid);for(var i=chs.length-1;i>=0;--i){if(chs[i].enabled){ck[chs[i].name]=chs[i].onSave(this.grid);}}_127a=lang.isObject(this.cookieProps)?this.cookieProps:{};_1256(_127b,json.toJson(ck),_127a);}else{this.removeCookie();}},onPreInit:function(){var grid=this.grid,chs=this._cookieHandlers,_127c=_125b(grid),ck=_1256(_127c);if(ck){ck=json.fromJson(ck);for(var i=0;i<chs.length;++i){if(chs[i].name in ck&&chs[i].enabled){chs[i].onLoad(ck[chs[i].name],grid);}}}this._cookie=ck||{};this._cookieStartedup=true;},addCookieHandler:function(args){if(args.name){var dummy=function(){};args.onLoad=args.onLoad||dummy;args.onSave=args.onSave||dummy;if(!("enabled" in args)){args.enabled=true;}for(var i=this._cookieHandlers.length-1;i>=0;--i){if(this._cookieHandlers[i].name==args.name){this._cookieHandlers.splice(i,1);}}this._cookieHandlers.push(args);if(this._cookieStartedup&&args.name in this._cookie){args.onLoad(this._cookie[args.name],this.grid);}}},removeCookie:function(){var key=_125b(this.grid);_1256(key,null,{expires:-1});},setCookieEnabled:function(_127d,_127e){if(typeof _127d=="string"){var chs=this._cookieHandlers;for(var i=chs.length-1;i>=0;--i){if(chs[i].name===_127d){chs[i].enabled=!!_127e;}}}else{this._cookieEnabled=!!_127d;if(!this._cookieEnabled){this.removeCookie();}}},getCookieEnabled:function(_127f){if(lang.isString(_127f)){var chs=this._cookieHandlers;for(var i=chs.length-1;i>=0;--i){if(chs[i].name==_127f){return chs[i].enabled;}}return false;}return this._cookieEnabled;}});_1259.registerPlugin(_1278,{"preInit":true});return _1278;});},"dojox/grid/enhanced/plugins/IndirectSelection":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/event","dojo/_base/lang","dojo/_base/html","dojo/_base/window","dojo/_base/connect","dojo/_base/sniff","dojo/query","dojo/keys","dojo/string","../_Plugin","../../EnhancedGrid","../../cells/dijit"],function(_1280,array,evt,lang,html,win,_1281,has,query,keys,_1282,_1283,_1284){var _1285=lang.getObject("dojox.grid.cells");var _1286=_1280("dojox.grid.cells.RowSelector",_1285._Widget,{inputType:"",map:null,disabledMap:null,isRowSelector:true,_connects:null,_subscribes:null,checkedText:"&#10003;",unCheckedText:"O",constructor:function(){this.map={};this.disabledMap={};this.disabledCount=0;this._connects=[];this._subscribes=[];this.inA11YMode=html.hasClass(win.body(),"dijit_a11y");this.baseClass="dojoxGridRowSelector dijitReset dijitInline dijit"+this.inputType;this.checkedClass=" dijit"+this.inputType+"Checked";this.disabledClass=" dijit"+this.inputType+"Disabled";this.checkedDisabledClass=" dijit"+this.inputType+"CheckedDisabled";this.statusTextClass=" dojoxGridRowSelectorStatusText";this._connects.push(_1281.connect(this.grid,"dokeyup",this,"_dokeyup"));this._connects.push(_1281.connect(this.grid.selection,"onSelected",this,"_onSelected"));this._connects.push(_1281.connect(this.grid.selection,"onDeselected",this,"_onDeselected"));this._connects.push(_1281.connect(this.grid.scroller,"invalidatePageNode",this,"_pageDestroyed"));this._connects.push(_1281.connect(this.grid,"onCellClick",this,"_onClick"));this._connects.push(_1281.connect(this.grid,"updateRow",this,"_onUpdateRow"));},formatter:function(data,_1287,scope){var _1288=scope;var clazz=_1288.baseClass;var _1289=!!_1288.getValue(_1287);var _128a=!!_1288.disabledMap[_1287];if(_1289){clazz+=_1288.checkedClass;if(_128a){clazz+=_1288.checkedDisabledClass;}}else{if(_128a){clazz+=_1288.disabledClass;}}return ["<div tabindex = -1 ","id = '"+_1288.grid.id+"_rowSelector_"+_1287+"' ","name = '"+_1288.grid.id+"_rowSelector' class = '"+clazz+"' ","role = "+_1288.inputType.toLowerCase()+" aria-checked = '"+_1289+"' aria-disabled = '"+_128a+"' aria-label = '"+_1282.substitute(_1288.grid._nls["indirectSelection"+_1288.inputType],[_1287+1])+"'>","<span class = '"+_1288.statusTextClass+"'>"+(_1289?_1288.checkedText:_1288.unCheckedText)+"</span>","</div>"].join("");},setValue:function(_128b,_128c){},getValue:function(_128d){return this.grid.selection.isSelected(_128d);},toggleRow:function(index,value){this._nativeSelect(index,value);},setDisabled:function(index,_128e){if(index<0){return;}this._toggleDisabledStyle(index,_128e);},disabled:function(index){return !!this.disabledMap[index];},_onClick:function(e){if(e.cell===this){this._selectRow(e);}},_dokeyup:function(e){if(e.cellIndex==this.index&&e.rowIndex>=0&&e.keyCode==keys.SPACE){this._selectRow(e);}},focus:function(_128f){var _1290=this.map[_128f];if(_1290){_1290.focus();}},_focusEndingCell:function(_1291,_1292){var cell=this.grid.getCell(_1292);this.grid.focus.setFocusCell(cell,_1291);},_nativeSelect:function(index,value){this.grid.selection[value?"select":"deselect"](index);},_onSelected:function(index){this._toggleCheckedStyle(index,true);},_onDeselected:function(index){this._toggleCheckedStyle(index,false);},_onUpdateRow:function(index){delete this.map[index];},_toggleCheckedStyle:function(index,value){var _1293=this._getSelector(index);if(_1293){html.toggleClass(_1293,this.checkedClass,value);if(this.disabledMap[index]){html.toggleClass(_1293,this.checkedDisabledClass,value);}_1293.setAttribute("aria-checked",value);if(this.inA11YMode){_1293.firstChild.innerHTML=(value?this.checkedText:this.unCheckedText);}}},_toggleDisabledStyle:function(index,_1294){var _1295=this._getSelector(index);if(_1295){html.toggleClass(_1295,this.disabledClass,_1294);if(this.getValue(index)){html.toggleClass(_1295,this.checkedDisabledClass,_1294);}_1295.setAttribute("aria-disabled",_1294);}this.disabledMap[index]=_1294;if(index>=0){this.disabledCount+=_1294?1:-1;}},_getSelector:function(index){var _1296=this.map[index];if(!_1296){var _1297=this.view.rowNodes[index];if(_1297){_1296=query(".dojoxGridRowSelector",_1297)[0];if(_1296){this.map[index]=_1296;}}}return _1296;},_pageDestroyed:function(_1298){var _1299=this.grid.scroller.rowsPerPage;var start=_1298*_1299,end=start+_1299-1;for(var i=start;i<=end;i++){if(!this.map[i]){continue;}html.destroy(this.map[i]);delete this.map[i];}},destroy:function(){for(var i in this.map){html.destroy(this.map[i]);delete this.map[i];}for(i in this.disabledMap){delete this.disabledMap[i];}array.forEach(this._connects,_1281.disconnect);array.forEach(this._subscribes,_1281.unsubscribe);delete this._connects;delete this._subscribes;}});var _129a=_1280("dojox.grid.cells.SingleRowSelector",_1286,{inputType:"Radio",_selectRow:function(e){var index=e.rowIndex;if(this.disabledMap[index]){return;}this._focusEndingCell(index,e.cellIndex);this._nativeSelect(index,!this.grid.selection.selected[index]);}});var _129b=_1280("dojox.grid.cells.MultipleRowSelector",_1286,{inputType:"CheckBox",swipeStartRowIndex:-1,swipeMinRowIndex:-1,swipeMaxRowIndex:-1,toSelect:false,lastClickRowIdx:-1,unCheckedText:"&#9633;",constructor:function(){this._connects.push(_1281.connect(win.doc,"onmouseup",this,"_domouseup"));this._connects.push(_1281.connect(this.grid,"onRowMouseOver",this,"_onRowMouseOver"));this._connects.push(_1281.connect(this.grid.focus,"move",this,"_swipeByKey"));this._connects.push(_1281.connect(this.grid,"onCellMouseDown",this,"_onMouseDown"));if(this.headerSelector){this._connects.push(_1281.connect(this.grid.views,"render",this,"_addHeaderSelector"));this._connects.push(_1281.connect(this.grid,"_onFetchComplete",this,"_addHeaderSelector"));this._connects.push(_1281.connect(this.grid,"onSelectionChanged",this,"_onSelectionChanged"));this._connects.push(_1281.connect(this.grid,"onKeyDown",this,function(e){if(e.rowIndex==-1&&e.cellIndex==this.index&&e.keyCode==keys.SPACE){this._toggletHeader();}}));}},toggleAllSelection:function(_129c){var grid=this.grid,_129d=grid.selection;if(_129c){_129d.selectRange(0,grid.rowCount-1);}else{_129d.deselectAll();}},_onMouseDown:function(e){if(e.cell==this){this._startSelection(e.rowIndex);evt.stop(e);}},_onRowMouseOver:function(e){this._updateSelection(e,0);},_domouseup:function(e){if(has("ie")){this.view.content.decorateEvent(e);}var _129e=e.cellIndex>=0&&this.inSwipeSelection()&&!this.grid.edit.isEditRow(e.rowIndex);if(_129e){this._focusEndingCell(e.rowIndex,e.cellIndex);}this._finishSelect();},_dokeyup:function(e){this.inherited(arguments);if(!e.shiftKey){this._finishSelect();}},_startSelection:function(_129f){this.swipeStartRowIndex=this.swipeMinRowIndex=this.swipeMaxRowIndex=_129f;this.toSelect=!this.getValue(_129f);},_updateSelection:function(e,delta){if(!this.inSwipeSelection()){return;}var byKey=delta!==0;var _12a0=e.rowIndex,_12a1=_12a0-this.swipeStartRowIndex+delta;if(_12a1>0&&this.swipeMaxRowIndex<_12a0+delta){this.swipeMaxRowIndex=_12a0+delta;}if(_12a1<0&&this.swipeMinRowIndex>_12a0+delta){this.swipeMinRowIndex=_12a0+delta;}var min=_12a1>0?this.swipeStartRowIndex:_12a0+delta;var max=_12a1>0?_12a0+delta:this.swipeStartRowIndex;for(var i=this.swipeMinRowIndex;i<=this.swipeMaxRowIndex;i++){if(this.disabledMap[i]||i<0){continue;}if(i>=min&&i<=max){this._nativeSelect(i,this.toSelect);}else{if(!byKey){this._nativeSelect(i,!this.toSelect);}}}},_swipeByKey:function(_12a2,_12a3,e){if(!e||_12a2===0||!e.shiftKey||e.cellIndex!=this.index||this.grid.focus.rowIndex<0){return;}var _12a4=e.rowIndex;if(this.swipeStartRowIndex<0){this.swipeStartRowIndex=_12a4;if(_12a2>0){this.swipeMaxRowIndex=_12a4+_12a2;this.swipeMinRowIndex=_12a4;}else{this.swipeMinRowIndex=_12a4+_12a2;this.swipeMaxRowIndex=_12a4;}this.toSelect=this.getValue(_12a4);}this._updateSelection(e,_12a2);},_finishSelect:function(){this.swipeStartRowIndex=-1;this.swipeMinRowIndex=-1;this.swipeMaxRowIndex=-1;this.toSelect=false;},inSwipeSelection:function(){return this.swipeStartRowIndex>=0;},_nativeSelect:function(index,value){this.grid.selection[value?"addToSelection":"deselect"](index);},_selectRow:function(e){var _12a5=e.rowIndex;if(this.disabledMap[_12a5]){return;}evt.stop(e);this._focusEndingCell(_12a5,e.cellIndex);var delta=_12a5-this.lastClickRowIdx;var _12a6=!this.grid.selection.selected[_12a5];if(this.lastClickRowIdx>=0&&!e.ctrlKey&&!e.altKey&&e.shiftKey){var min=delta>0?this.lastClickRowIdx:_12a5;var max=delta>0?_12a5:this.lastClickRowIdx;for(var i=min;i>=0&&i<=max;i++){this._nativeSelect(i,_12a6);}}else{this._nativeSelect(_12a5,_12a6);}this.lastClickRowIdx=_12a5;},getValue:function(_12a7){if(_12a7==-1){var g=this.grid;return g.rowCount>0&&g.rowCount<=g.selection.getSelectedCount();}return this.inherited(arguments);},_addHeaderSelector:function(){var _12a8=this.view.getHeaderCellNode(this.index);if(!_12a8){return;}html.empty(_12a8);var g=this.grid;var _12a9=_12a8.appendChild(html.create("div",{"aria-label":g._nls["selectAll"],"tabindex":-1,"id":g.id+"_rowSelector_-1","class":this.baseClass,"role":"checkbox","innerHTML":"<span class = '"+this.statusTextClass+"'></span><span style='height: 0; width: 0; overflow: hidden; display: block;'>"+g._nls["selectAll"]+"</span>"}));this.map[-1]=_12a9;var idx=this._headerSelectorConnectIdx;if(idx!==undefined){_1281.disconnect(this._connects[idx]);this._connects.splice(idx,1);}this._headerSelectorConnectIdx=this._connects.length;this._connects.push(_1281.connect(_12a9,"onclick",this,"_toggletHeader"));this._onSelectionChanged();},_toggletHeader:function(){if(!!this.disabledMap[-1]){return;}this.grid._selectingRange=true;this.toggleAllSelection(!this.getValue(-1));this._onSelectionChanged();this.grid._selectingRange=false;},_onSelectionChanged:function(){var g=this.grid;if(!this.map[-1]||g._selectingRange){return;}g.allItemsSelected=this.getValue(-1);this._toggleCheckedStyle(-1,g.allItemsSelected);},_toggleDisabledStyle:function(index,_12aa){this.inherited(arguments);if(this.headerSelector){var _12ab=(this.grid.rowCount==this.disabledCount);if(_12ab!=!!this.disabledMap[-1]){arguments[0]=-1;arguments[1]=_12ab;this.inherited(arguments);}}}});var _12ac=_1280("dojox.grid.enhanced.plugins.IndirectSelection",_1283,{name:"indirectSelection",constructor:function(){var _12ad=this.grid.layout;this.connect(_12ad,"setStructure",lang.hitch(_12ad,this.addRowSelectCell,this.option));},addRowSelectCell:function(_12ae){if(!this.grid.indirectSelection||this.grid.selectionMode=="none"){return;}var _12af=false,_12b0=["get","formatter","field","fields"],_12b1={type:_129b,name:"",width:"30px",styles:"text-align: center;"};if(_12ae.headerSelector){_12ae.name="";}if(this.grid.rowSelectCell){this.grid.rowSelectCell.destroy();}array.forEach(this.structure,function(view){var cells=view.cells;if(cells&&cells.length>0&&!_12af){var _12b2=cells[0];if(_12b2[0]&&_12b2[0].isRowSelector){_12af=true;return;}var _12b3,_12b4=this.grid.selectionMode=="single"?_129a:_129b;_12b3=lang.mixin(_12b1,_12ae,{type:_12b4,editable:false,notselectable:true,filterable:false,navigatable:true,nosort:true});array.forEach(_12b0,function(field){if(field in _12b3){delete _12b3[field];}});if(cells.length>1){_12b3.rowSpan=cells.length;}array.forEach(this.cells,function(cell,i){if(cell.index>=0){cell.index+=1;}else{console.warn("Error:IndirectSelection.addRowSelectCell()-  cell "+i+" has no index!");}});var _12b5=this.addCellDef(0,0,_12b3);_12b5.index=0;_12b2.unshift(_12b5);this.cells.unshift(_12b5);this.grid.rowSelectCell=_12b5;_12af=true;}},this);this.cellCount=this.cells.length;},destroy:function(){this.grid.rowSelectCell.destroy();delete this.grid.rowSelectCell;this.inherited(arguments);}});_1284.registerPlugin(_12ac,{"preInit":true});return _12ac;});},"dojox/grid/enhanced/plugins/NestedSorting":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/connect","dojo/_base/lang","dojo/_base/html","dojo/_base/event","dojo/_base/window","dojo/keys","dojo/query","dojo/string","../_Plugin","../../EnhancedGrid"],function(_12b6,array,_12b7,lang,html,evt,win,keys,query,_12b8,_12b9,_12ba){var _12bb=_12b6("dojox.grid.enhanced.plugins.NestedSorting",_12b9,{name:"nestedSorting",_currMainSort:"none",_currRegionIdx:-1,_a11yText:{"dojoxGridDescending":"&#9662;","dojoxGridAscending":"&#9652;","dojoxGridAscendingTip":"&#1784;","dojoxGridDescendingTip":"&#1783;","dojoxGridUnsortedTip":"x"},constructor:function(){this._sortDef=[];this._sortData={};this._headerNodes={};this._excludedColIdx=[];this.nls=this.grid._nls;this.grid.setSortInfo=function(){};this.grid.setSortIndex=lang.hitch(this,"_setGridSortIndex");this.grid.getSortIndex=function(){};this.grid.getSortProps=lang.hitch(this,"getSortProps");if(this.grid.sortFields){this._setGridSortIndex(this.grid.sortFields,null,true);}this.connect(this.grid.views,"render","_initSort");this.initCookieHandler();if(this.grid.plugin("rearrange")){this.subscribe("dojox/grid/rearrange/move/"+this.grid.id,lang.hitch(this,"_onColumnDnD"));}else{this.connect(this.grid.layout,"moveColumn","_onMoveColumn");}},onStartUp:function(){this.inherited(arguments);this.connect(this.grid,"onHeaderCellClick","_onHeaderCellClick");this.connect(this.grid,"onHeaderCellMouseOver","_onHeaderCellMouseOver");this.connect(this.grid,"onHeaderCellMouseOut","_onHeaderCellMouseOut");},_onMoveColumn:function(_12bc,_12bd,_12be,_12bf,_12c0){var cr=this._getCurrentRegion(),idx=cr&&this._getRegionHeader(cr).getAttribute("idx"),c=this._headerNodes[idx],_12c1=this._sortData,_12c2={},_12c3,data;if(cr){this._blurRegion(cr);this._currRegionIdx=array.indexOf(this._getRegions(),c.firstChild);}if(_12bf<_12be){for(_12c3 in _12c1){_12c3=parseInt(_12c3,10);data=_12c1[_12c3];if(data){if(_12c3>=_12bf&&_12c3<_12be){_12c2[_12c3+1]=data;}else{if(_12c3==_12be){_12c2[_12bf]=data;}else{_12c2[_12c3]=data;}}}}}else{if(_12bf>_12be+1){if(!_12c0){_12bf++;}for(_12c3 in _12c1){_12c3=parseInt(_12c3,10);data=_12c1[_12c3];if(data){if(_12c3>_12be&&_12c3<_12bf){_12c2[_12c3-1]=data;}else{if(_12c3==_12be){_12c2[_12bf-1]=data;}else{_12c2[_12c3]=data;}}}}}}this._sortData=_12c2;this._initSort(false);},_onColumnDnD:function(type,_12c4){if(type!=="col"){return;}var m=_12c4,obj={},d=this._sortData,p;var cr=this._getCurrentRegion();this._blurRegion(cr);var idx=this._getRegionHeader(cr).getAttribute("idx");for(p in m){if(d[p]){obj[m[p]]=d[p];delete d[p];}if(p===idx){idx=m[p];}}for(p in obj){d[p]=obj[p];}var c=this._headerNodes[idx];this._currRegionIdx=array.indexOf(this._getRegions(),c.firstChild);this._initSort(false);},_setGridSortIndex:function(_12c5,inAsc,_12c6){if(lang.isArray(_12c5)){var i,d,cell;for(i=0;i<_12c5.length;i++){d=_12c5[i];cell=this.grid.getCellByField(d.attribute);if(!cell){console.warn("Invalid sorting option, column ",d.attribute," not found.");return;}if(cell["nosort"]||!this.grid.canSort(cell.index,cell.field)){console.warn("Invalid sorting option, column ",d.attribute," is unsortable.");return;}}this.clearSort();array.forEach(_12c5,function(d,i){cell=this.grid.getCellByField(d.attribute);this.setSortData(cell.index,"index",i);this.setSortData(cell.index,"order",d.descending?"desc":"asc");},this);}else{if(!isNaN(_12c5)){if(inAsc===undefined){return;}this.setSortData(_12c5,"order",inAsc?"asc":"desc");}else{return;}}this._updateSortDef();if(!_12c6){this.grid.sort();}},getSortProps:function(){return this._sortDef.length?this._sortDef:null;},_initSort:function(_12c7){var g=this.grid,n=g.domNode,len=this._sortDef.length;html.toggleClass(n,"dojoxGridSorted",!!len);html.toggleClass(n,"dojoxGridSingleSorted",len===1);html.toggleClass(n,"dojoxGridNestSorted",len>1);if(len>0){this._currMainSort=this._sortDef[0].descending?"desc":"asc";}var idx,_12c8=this._excludedCoIdx=[];this._headerNodes=query("th",g.viewsHeaderNode).forEach(function(n){idx=parseInt(n.getAttribute("idx"),10);if(html.style(n,"display")==="none"||g.layout.cells[idx]["nosort"]||(g.canSort&&!g.canSort(idx,g.layout.cells[idx]["field"]))){_12c8.push(idx);}});this._headerNodes.forEach(this._initHeaderNode,this);this._initFocus();if(_12c7){this._focusHeader();}},_initHeaderNode:function(node){html.toggleClass(node,"dojoxGridSortNoWrap",true);var _12c9=query(".dojoxGridSortNode",node)[0];if(_12c9){html.toggleClass(_12c9,"dojoxGridSortNoWrap",true);}if(array.indexOf(this._excludedCoIdx,node.getAttribute("idx"))>=0){html.addClass(node,"dojoxGridNoSort");return;}if(!query(".dojoxGridSortBtn",node).length){this._connects=array.filter(this._connects,function(conn){if(conn._sort){_12b7.disconnect(conn);return false;}return true;});var n=html.create("a",{className:"dojoxGridSortBtn dojoxGridSortBtnNested",title:_12b8.substitute(this.nls.sortingState,[this.nls.nestedSort,this.nls.ascending]),innerHTML:"1"},node.firstChild,"last");n.onmousedown=evt.stop;n=html.create("a",{className:"dojoxGridSortBtn dojoxGridSortBtnSingle",title:_12b8.substitute(this.nls.sortingState,[this.nls.singleSort,this.nls.ascending])},node.firstChild,"last");n.onmousedown=evt.stop;}else{var a1=query(".dojoxGridSortBtnSingle",node)[0];var a2=query(".dojoxGridSortBtnNested",node)[0];a1.className="dojoxGridSortBtn dojoxGridSortBtnSingle";a2.className="dojoxGridSortBtn dojoxGridSortBtnNested";a2.innerHTML="1";html.removeClass(node,"dojoxGridCellShowIndex");html.removeClass(node.firstChild,"dojoxGridSortNodeSorted");html.removeClass(node.firstChild,"dojoxGridSortNodeAsc");html.removeClass(node.firstChild,"dojoxGridSortNodeDesc");html.removeClass(node.firstChild,"dojoxGridSortNodeMain");html.removeClass(node.firstChild,"dojoxGridSortNodeSub");}this._updateHeaderNodeUI(node);},_onHeaderCellClick:function(e){this._focusRegion(e.target);if(html.hasClass(e.target,"dojoxGridSortBtn")){this._onSortBtnClick(e);evt.stop(e);this._focusRegion(this._getCurrentRegion());}},_onHeaderCellMouseOver:function(e){if(!e.cell){return;}if(this._sortDef.length>1){return;}if(this._sortData[e.cellIndex]&&this._sortData[e.cellIndex].index===0){return;}var p;for(p in this._sortData){if(this._sortData[p]&&this._sortData[p].index===0){html.addClass(this._headerNodes[p],"dojoxGridCellShowIndex");break;}}if(!html.hasClass(win.body(),"dijit_a11y")){return;}var i=e.cell.index,node=e.cellNode;var _12ca=query(".dojoxGridSortBtnSingle",node)[0];var _12cb=query(".dojoxGridSortBtnNested",node)[0];var _12cc="none";if(html.hasClass(this.grid.domNode,"dojoxGridSingleSorted")){_12cc="single";}else{if(html.hasClass(this.grid.domNode,"dojoxGridNestSorted")){_12cc="nested";}}var _12cd=_12cb.getAttribute("orderIndex");if(_12cd===null||_12cd===undefined){_12cb.setAttribute("orderIndex",_12cb.innerHTML);_12cd=_12cb.innerHTML;}if(this.isAsc(i)){_12cb.innerHTML=_12cd+this._a11yText.dojoxGridDescending;}else{if(this.isDesc(i)){_12cb.innerHTML=_12cd+this._a11yText.dojoxGridUnsortedTip;}else{_12cb.innerHTML=_12cd+this._a11yText.dojoxGridAscending;}}if(this._currMainSort==="none"){_12ca.innerHTML=this._a11yText.dojoxGridAscending;}else{if(this._currMainSort==="asc"){_12ca.innerHTML=this._a11yText.dojoxGridDescending;}else{if(this._currMainSort==="desc"){_12ca.innerHTML=this._a11yText.dojoxGridUnsortedTip;}}}},_onHeaderCellMouseOut:function(e){var p;for(p in this._sortData){if(this._sortData[p]&&this._sortData[p].index===0){html.removeClass(this._headerNodes[p],"dojoxGridCellShowIndex");break;}}},_onSortBtnClick:function(e){var _12ce=e.cell.index;if(html.hasClass(e.target,"dojoxGridSortBtnSingle")){this._prepareSingleSort(_12ce);}else{if(html.hasClass(e.target,"dojoxGridSortBtnNested")){this._prepareNestedSort(_12ce);}else{return;}}evt.stop(e);this._doSort(_12ce);},_doSort:function(_12cf){if(!this._sortData[_12cf]||!this._sortData[_12cf].order){this.setSortData(_12cf,"order","asc");}else{if(this.isAsc(_12cf)){this.setSortData(_12cf,"order","desc");}else{if(this.isDesc(_12cf)){this.removeSortData(_12cf);}}}this._updateSortDef();this.grid.sort();this._initSort(true);},setSortData:function(_12d0,attr,value){var sd=this._sortData[_12d0];if(!sd){sd=this._sortData[_12d0]={};}sd[attr]=value;},removeSortData:function(_12d1){var d=this._sortData,i=d[_12d1].index,p;delete d[_12d1];for(p in d){if(d[p].index>i){d[p].index--;}}},_prepareSingleSort:function(_12d2){var d=this._sortData,p;for(p in d){delete d[p];}this.setSortData(_12d2,"index",0);this.setSortData(_12d2,"order",this._currMainSort==="none"?null:this._currMainSort);if(!this._sortData[_12d2]||!this._sortData[_12d2].order){this._currMainSort="asc";}else{if(this.isAsc(_12d2)){this._currMainSort="desc";}else{if(this.isDesc(_12d2)){this._currMainSort="none";}}}},_prepareNestedSort:function(_12d3){var i=this._sortData[_12d3]?this._sortData[_12d3].index:null;if(i===0||!!i){return;}this.setSortData(_12d3,"index",this._sortDef.length);},_updateSortDef:function(){this._sortDef.length=0;var d=this._sortData,p;for(p in d){this._sortDef[d[p].index]={attribute:this.grid.layout.cells[p].field,descending:d[p].order==="desc"};}},_updateHeaderNodeUI:function(node){var cell=this._getCellByNode(node);var _12d4=cell.index;var data=this._sortData[_12d4];var _12d5=query(".dojoxGridSortNode",node)[0];var _12d6=query(".dojoxGridSortBtnSingle",node)[0];var _12d7=query(".dojoxGridSortBtnNested",node)[0];html.toggleClass(_12d6,"dojoxGridSortBtnAsc",this._currMainSort==="asc");html.toggleClass(_12d6,"dojoxGridSortBtnDesc",this._currMainSort==="desc");if(this._currMainSort==="asc"){_12d6.title=_12b8.substitute(this.nls.sortingState,[this.nls.singleSort,this.nls.descending]);}else{if(this._currMainSort==="desc"){_12d6.title=_12b8.substitute(this.nls.sortingState,[this.nls.singleSort,this.nls.unsorted]);}else{_12d6.title=_12b8.substitute(this.nls.sortingState,[this.nls.singleSort,this.nls.ascending]);}}var _12d8=this;function _12d9(){var _12da="Column "+(cell.index+1)+" "+cell.field;var _12db="none";var _12dc="ascending";if(data){_12db=data.order==="asc"?"ascending":"descending";_12dc=data.order==="asc"?"descending":"none";}var _12dd=_12da+" - is sorted by "+_12db;var _12de=_12da+" - is nested sorted by "+_12db;var _12df=_12da+" - choose to sort by "+_12dc;var _12e0=_12da+" - choose to nested sort by "+_12dc;_12d6.setAttribute("aria-label",_12dd);_12d7.setAttribute("aria-label",_12de);var _12e1=[_12d8.connect(_12d6,"onmouseover",function(){_12d6.setAttribute("aria-label",_12df);}),_12d8.connect(_12d6,"onmouseout",function(){_12d6.setAttribute("aria-label",_12dd);}),_12d8.connect(_12d7,"onmouseover",function(){_12d7.setAttribute("aria-label",_12e0);}),_12d8.connect(_12d7,"onmouseout",function(){_12d7.setAttribute("aria-label",_12de);})];array.forEach(_12e1,function(_12e2){_12e2._sort=true;});};_12d9();var a11y=html.hasClass(win.body(),"dijit_a11y");if(!data){_12d7.innerHTML=this._sortDef.length+1;_12d7.title=_12b8.substitute(this.nls.sortingState,[this.nls.nestedSort,this.nls.ascending]);if(a11y){_12d5.innerHTML=this._a11yText.dojoxGridUnsortedTip;}return;}if(data.index||(data.index===0&&this._sortDef.length>1)){_12d7.innerHTML=data.index+1;}html.addClass(_12d5,"dojoxGridSortNodeSorted");if(this.isAsc(_12d4)){html.addClass(_12d5,"dojoxGridSortNodeAsc");_12d7.title=_12b8.substitute(this.nls.sortingState,[this.nls.nestedSort,this.nls.descending]);if(a11y){_12d5.innerHTML=this._a11yText.dojoxGridAscendingTip;}}else{if(this.isDesc(_12d4)){html.addClass(_12d5,"dojoxGridSortNodeDesc");_12d7.title=_12b8.substitute(this.nls.sortingState,[this.nls.nestedSort,this.nls.unsorted]);if(a11y){_12d5.innerHTML=this._a11yText.dojoxGridDescendingTip;}}}html.addClass(_12d5,(data.index===0?"dojoxGridSortNodeMain":"dojoxGridSortNodeSub"));},isAsc:function(_12e3){return this._sortData[_12e3].order==="asc";},isDesc:function(_12e4){return this._sortData[_12e4].order==="desc";},_getCellByNode:function(node){var i;for(i=0;i<this._headerNodes.length;i++){if(this._headerNodes[i]===node){return this.grid.layout.cells[i];}}return null;},clearSort:function(){this._sortData={};this._sortDef.length=0;},initCookieHandler:function(){if(this.grid.addCookieHandler){this.grid.addCookieHandler({name:"sortOrder",onLoad:lang.hitch(this,"_loadNestedSortingProps"),onSave:lang.hitch(this,"_saveNestedSortingProps")});}},_loadNestedSortingProps:function(_12e5,grid){this._setGridSortIndex(_12e5);},_saveNestedSortingProps:function(grid){return this.getSortProps();},_initFocus:function(){var f=this.focus=this.grid.focus;this._focusRegions=this._getRegions();if(!this._headerArea){var area=this._headerArea=f.getArea("header");area.onFocus=f.focusHeader=lang.hitch(this,"_focusHeader");area.onBlur=f.blurHeader=f._blurHeader=lang.hitch(this,"_blurHeader");area.onMove=lang.hitch(this,"_onMove");area.onKeyDown=lang.hitch(this,"_onKeyDown");area._regions=[];area.getRegions=null;this.connect(this.grid,"onBlur","_blurHeader");}},_focusHeader:function(e){if(this._currRegionIdx===-1){this._onMove(0,1,null);}else{var _12e6=this._getCurrentRegion();this._focusRegion(_12e6);var view=this._getRegionView(_12e6);view.scrollboxNode.scrollLeft=view.headerNode.scrollLeft;}try{if(e){evt.stop(e);}}catch(e){}return true;},_blurHeader:function(e){this._blurRegion(this._getCurrentRegion());return true;},_onMove:function(_12e7,_12e8,e){var curr=this._currRegionIdx||0,_12e9=this._focusRegions;var _12ea=_12e9[curr+_12e8];if(!_12ea){return;}else{if(html.style(_12ea,"display")==="none"||html.style(_12ea,"visibility")==="hidden"){this._onMove(_12e7,_12e8+(_12e8>0?1:-1),e);return;}}this._focusRegion(_12ea);var view=this._getRegionView(_12ea);view.scrollboxNode.scrollLeft=view.headerNode.scrollLeft;},_onKeyDown:function(e,_12eb){if(_12eb){switch(e.keyCode){case keys.ENTER:case keys.SPACE:if(html.hasClass(e.target,"dojoxGridSortBtnSingle")||html.hasClass(e.target,"dojoxGridSortBtnNested")){this._onSortBtnClick(e);}}}},_getRegionView:function(_12ec){var _12ed=_12ec;while(_12ed&&!html.hasClass(_12ed,"dojoxGridHeader")){_12ed=_12ed.parentNode;}if(_12ed){return array.filter(this.grid.views.views,function(view){return view.headerNode===_12ed;})[0]||null;}return null;},_getRegions:function(){var _12ee=[],cells=this.grid.layout.cells;this._headerNodes.forEach(function(n,i){if(html.style(n,"display")==="none"){return;}if(cells[i]["isRowSelector"]){_12ee.push(n);return;}query(".dojoxGridSortNode,.dojoxGridSortBtnNested,.dojoxGridSortBtnSingle",n).forEach(function(node){node.setAttribute("tabindex",0);_12ee.push(node);});},this);return _12ee;},_focusRegion:function(_12ef){if(!_12ef){return;}var _12f0=this._getCurrentRegion();if(_12f0&&_12ef!==_12f0){this._blurRegion(_12f0);}var _12f1=this._getRegionHeader(_12ef);html.addClass(_12f1,"dojoxGridCellSortFocus");if(html.hasClass(_12ef,"dojoxGridSortNode")){html.addClass(_12ef,"dojoxGridSortNodeFocus");}else{if(html.hasClass(_12ef,"dojoxGridSortBtn")){html.addClass(_12ef,"dojoxGridSortBtnFocus");}}try{_12ef.focus();}catch(e){}this.focus.currentArea("header");this._currRegionIdx=array.indexOf(this._focusRegions,_12ef);},_blurRegion:function(_12f2){if(!_12f2){return;}var _12f3=this._getRegionHeader(_12f2);html.removeClass(_12f3,"dojoxGridCellSortFocus");if(html.hasClass(_12f2,"dojoxGridSortNode")){html.removeClass(_12f2,"dojoxGridSortNodeFocus");}else{if(html.hasClass(_12f2,"dojoxGridSortBtn")){html.removeClass(_12f2,"dojoxGridSortBtnFocus");}}_12f2.blur();},_getCurrentRegion:function(){return this._focusRegions?this._focusRegions[this._currRegionIdx]:null;},_getRegionHeader:function(_12f4){while(_12f4&&!html.hasClass(_12f4,"dojoxGridCell")){_12f4=_12f4.parentNode;}return _12f4;},destroy:function(){this._sortDef=this._sortData=null;this._headerNodes=this._focusRegions=null;this.inherited(arguments);}});_12ba.registerPlugin(_12bb);return _12bb;});},"dojox/grid/enhanced/plugins/Selector":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/_base/event","dojo/keys","dojo/query","dojo/_base/html","dojo/_base/window","dijit/focus","../../_RowSelector","../_Plugin","../../EnhancedGrid","../../cells/_base","./AutoScroll"],function(dojo,lang,_12f5,array,event,keys,query,html,win,_12f6,_12f7,_12f8,_12f9){var _12fa=0,_12fb=1,MULTI=2,_12fc={col:"row",row:"col"},_12fd=function(type,value,start,end,_12fe){if(type!=="cell"){value=value[type];start=start[type];end=end[type];if(typeof value!=="number"||typeof start!=="number"||typeof end!=="number"){return false;}return _12fe?((value>=start&&value<end)||(value>end&&value<=start)):((value>=start&&value<=end)||(value>=end&&value<=start));}else{return _12fd("col",value,start,end,_12fe)&&_12fd("row",value,start,end,_12fe);}},_12ff=function(type,v1,v2){try{if(v1&&v2){switch(type){case "col":case "row":return v1[type]==v2[type]&&typeof v1[type]=="number"&&!(_12fc[type] in v1)&&!(_12fc[type] in v2);case "cell":return v1.col==v2.col&&v1.row==v2.row&&typeof v1.col=="number"&&typeof v1.row=="number";}}}catch(e){}return false;},_1300=function(evt){try{if(evt&&evt.preventDefault){event.stop(evt);}}catch(e){}},_1301=function(type,_1302,_1303){switch(type){case "col":return {"col":typeof _1303=="undefined"?_1302:_1303,"except":[]};case "row":return {"row":_1302,"except":[]};case "cell":return {"row":_1302,"col":_1303};}return null;};var _1304=_12f5("dojox.grid.enhanced.plugins.Selector",_12f8,{name:"selector",constructor:function(grid,args){this.grid=grid;this._config={row:MULTI,col:MULTI,cell:MULTI};this.noClear=args&&args.noClear;this.setupConfig(args);if(grid.selectionMode==="single"){this._config.row=_12fb;}this._enabled=true;this._selecting={};this._selected={"col":[],"row":[],"cell":[]};this._startPoint={};this._currentPoint={};this._lastAnchorPoint={};this._lastEndPoint={};this._lastSelectedAnchorPoint={};this._lastSelectedEndPoint={};this._keyboardSelect={};this._lastType=null;this._selectedRowModified={};this._hacks();this._initEvents();this._initAreas();this._mixinGrid();},destroy:function(){this.inherited(arguments);},setupConfig:function(_1305){if(!_1305||!lang.isObject(_1305)){return;}var types=["row","col","cell"];for(var type in _1305){if(array.indexOf(types,type)>=0){if(!_1305[type]||_1305[type]=="disabled"){this._config[type]=_12fa;}else{if(_1305[type]=="single"){this._config[type]=_12fb;}else{this._config[type]=MULTI;}}}}var mode=["none","single","extended"][this._config.row];this.grid.selection.setMode(mode);},isSelected:function(type,_1306,_1307){return this._isSelected(type,_1301(type,_1306,_1307));},toggleSelect:function(type,_1308,_1309){this._startSelect(type,_1301(type,_1308,_1309),this._config[type]===MULTI,false,false,!this.isSelected(type,_1308,_1309));this._endSelect(type);},select:function(type,_130a,_130b){if(!this.isSelected(type,_130a,_130b)){this.toggleSelect(type,_130a,_130b);}},deselect:function(type,_130c,_130d){if(this.isSelected(type,_130c,_130d)){this.toggleSelect(type,_130c,_130d);}},selectRange:function(type,start,end,_130e){this.grid._selectingRange=true;var _130f=type=="cell"?_1301(type,start.row,start.col):_1301(type,start),_1310=type=="cell"?_1301(type,end.row,end.col):_1301(type,end);this._startSelect(type,_130f,false,false,false,_130e);this._highlight(type,_1310,_130e===undefined?true:_130e);this._endSelect(type);this.grid._selectingRange=false;},clear:function(type){this._clearSelection(type||"all");},isSelecting:function(type){if(typeof type=="undefined"){return this._selecting.col||this._selecting.row||this._selecting.cell;}return this._selecting[type];},selectEnabled:function(_1311){if(typeof _1311!="undefined"&&!this.isSelecting()){this._enabled=!!_1311;}return this._enabled;},getSelected:function(type,_1312){switch(type){case "cell":return array.map(this._selected[type],function(item){return item;});case "col":case "row":return array.map(_1312?this._selected[type]:array.filter(this._selected[type],function(item){return item.except.length===0;}),function(item){return _1312?item:item[type];});}return [];},getSelectedCount:function(type,_1313){switch(type){case "cell":return this._selected[type].length;case "col":case "row":return (_1313?this._selected[type]:array.filter(this._selected[type],function(item){return item.except.length===0;})).length;}return 0;},getSelectedType:function(){var s=this._selected;return ["","cell","row","row|cell","col","col|cell","col|row","col|row|cell"][(!!s.cell.length)|(!!s.row.length<<1)|(!!s.col.length<<2)];},getLastSelectedRange:function(type){return this._lastAnchorPoint[type]?{"start":this._lastAnchorPoint[type],"end":this._lastEndPoint[type]}:null;},_hacks:function(){var g=this.grid;var _1314=function(e){if(e.cellNode){g.onMouseUp(e);}g.onMouseUpRow(e);};var _1315=lang.hitch(g,"onMouseUp");var _1316=lang.hitch(g,"onMouseDown");var _1317=function(e){e.cellNode.style.border="solid 1px";};array.forEach(g.views.views,function(view){view.content.domouseup=_1314;view.header.domouseup=_1315;if(view.declaredClass=="dojox.grid._RowSelector"){view.domousedown=_1316;view.domouseup=_1315;view.dofocus=_1317;}});g.selection.clickSelect=function(){};this._oldDeselectAll=g.selection.deselectAll;var _1318=this;g.selection.selectRange=function(from,to){_1318.selectRange("row",from,to,true);if(g.selection.preserver){g.selection.preserver._updateMapping(true,true,false,from,to);}g.selection.onChanged();};g.selection.deselectRange=function(from,to){_1318.selectRange("row",from,to,false);if(g.selection.preserver){g.selection.preserver._updateMapping(true,false,false,from,to);}g.selection.onChanged();};g.selection.deselectAll=function(){g._selectingRange=true;_1318._oldDeselectAll.apply(g.selection,arguments);_1318._clearSelection("all");g._selectingRange=false;if(g.selection.preserver){g.selection.preserver._updateMapping(true,false,true);}g.selection.onChanged();};var _1319=g.views.views[0];if(_1319 instanceof _12f7){_1319.doStyleRowNode=function(_131a,_131b){html.removeClass(_131b,"dojoxGridRow");html.addClass(_131b,"dojoxGridRowbar");html.addClass(_131b,"dojoxGridNonNormalizedCell");html.toggleClass(_131b,"dojoxGridRowbarOver",g.rows.isOver(_131a));html.toggleClass(_131b,"dojoxGridRowbarSelected",!!g.selection.isSelected(_131a));};}this.connect(g,"updateRow",function(_131c){array.forEach(g.layout.cells,function(cell){if(this.isSelected("cell",_131c,cell.index)){this._highlightNode(cell.getNode(_131c),true);}},this);});},_mixinGrid:function(){var g=this.grid;g.setupSelectorConfig=lang.hitch(this,this.setupConfig);g.onStartSelect=function(){};g.onEndSelect=function(){};g.onStartDeselect=function(){};g.onEndDeselect=function(){};g.onSelectCleared=function(){};},_initEvents:function(){var g=this.grid,_131d=this,dp=lang.partial,_131e=function(type,e){if(type==="row"){_131d._isUsingRowSelector=true;}if(_131d.selectEnabled()&&_131d._config[type]&&e.button!=2){if(_131d._keyboardSelect.col||_131d._keyboardSelect.row||_131d._keyboardSelect.cell){_131d._endSelect("all");_131d._keyboardSelect.col=_131d._keyboardSelect.row=_131d._keyboardSelect.cell=0;}if(_131d._usingKeyboard){_131d._usingKeyboard=false;}var _131f=_1301(type,e.rowIndex,e.cell&&e.cell.index);_131d._startSelect(type,_131f,e.ctrlKey,e.shiftKey);}},ender=lang.hitch(this,"_endSelect");this.connect(g,"onHeaderCellMouseDown",dp(_131e,"col"));this.connect(g,"onHeaderCellMouseUp",dp(ender,"col"));this.connect(g,"onRowSelectorMouseDown",dp(_131e,"row"));this.connect(g,"onRowSelectorMouseUp",dp(ender,"row"));this.connect(g,"onCellMouseDown",function(e){if(e.cell&&e.cell.isRowSelector){return;}if(g.singleClickEdit){_131d._singleClickEdit=true;g.singleClickEdit=false;}_131e(_131d._config["cell"]==_12fa?"row":"cell",e);});this.connect(g,"onCellMouseUp",function(e){if(_131d._singleClickEdit){delete _131d._singleClickEdit;g.singleClickEdit=true;}ender("all",e);});this.connect(g,"onCellMouseOver",function(e){if(_131d._curType!="row"&&_131d._selecting[_131d._curType]&&_131d._config[_131d._curType]==MULTI){_131d._highlight("col",_1301("col",e.cell.index),_131d._toSelect);if(!_131d._keyboardSelect.cell){_131d._highlight("cell",_1301("cell",e.rowIndex,e.cell.index),_131d._toSelect);}}});this.connect(g,"onHeaderCellMouseOver",function(e){if(_131d._selecting.col&&_131d._config.col==MULTI){_131d._highlight("col",_1301("col",e.cell.index),_131d._toSelect);}});this.connect(g,"onRowMouseOver",function(e){if(_131d._selecting.row&&_131d._config.row==MULTI){_131d._highlight("row",_1301("row",e.rowIndex),_131d._toSelect);}});this.connect(g,"onSelectedById","_onSelectedById");this.connect(g,"_onFetchComplete",function(){if(!g._notRefreshSelection){this._refreshSelected(true);}});this.connect(g.scroller,"buildPage",function(){if(!g._notRefreshSelection){this._refreshSelected(true);}});this.connect(win.doc,"onmouseup",dp(ender,"all"));this.connect(g,"onEndAutoScroll",function(_1320,_1321,view,_1322){var _1323=_131d._selecting.cell,type,_1324,dir=_1321?1:-1;if(_1320&&(_1323||_131d._selecting.row)){type=_1323?"cell":"row";_1324=_131d._currentPoint[type];_131d._highlight(type,_1301(type,_1324.row+dir,_1324.col),_131d._toSelect);}else{if(!_1320&&(_1323||_131d._selecting.col)){type=_1323?"cell":"col";_1324=_131d._currentPoint[type];_131d._highlight(type,_1301(type,_1324.row,_1322),_131d._toSelect);}}});this.subscribe("dojox/grid/rearrange/move/"+g.id,"_onInternalRearrange");this.subscribe("dojox/grid/rearrange/copy/"+g.id,"_onInternalRearrange");this.subscribe("dojox/grid/rearrange/change/"+g.id,"_onExternalChange");this.subscribe("dojox/grid/rearrange/insert/"+g.id,"_onExternalChange");this.subscribe("dojox/grid/rearrange/remove/"+g.id,"clear");this.connect(g,"onSelected",function(_1325){if(this._selectedRowModified&&this._isUsingRowSelector){delete this._selectedRowModified;}else{if(!this.grid._selectingRange){this.select("row",_1325);}}});this.connect(g,"onDeselected",function(_1326){if(this._selectedRowModified&&this._isUsingRowSelector){delete this._selectedRowModified;}else{if(!this.grid._selectingRange){this.deselect("row",_1326);}}});},_onSelectedById:function(id,_1327,_1328){if(this.grid._noInternalMapping){return;}var _1329=[this._lastAnchorPoint.row,this._lastEndPoint.row,this._lastSelectedAnchorPoint.row,this._lastSelectedEndPoint.row];_1329=_1329.concat(this._selected.row);var found=false;array.forEach(_1329,function(item){if(item){if(item.id===id){found=true;item.row=_1327;}else{if(item.row===_1327&&item.id){item.row=-1;}}}});if(!found&&_1328){array.some(this._selected.row,function(item){if(item&&!item.id&&!item.except.length){item.id=id;item.row=_1327;return true;}return false;});}found=false;_1329=[this._lastAnchorPoint.cell,this._lastEndPoint.cell,this._lastSelectedAnchorPoint.cell,this._lastSelectedEndPoint.cell];_1329=_1329.concat(this._selected.cell);array.forEach(_1329,function(item){if(item){if(item.id===id){found=true;item.row=_1327;}else{if(item.row===_1327&&item.id){item.row=-1;}}}});},onSetStore:function(){this._clearSelection("all");},_onInternalRearrange:function(type,_132a){try{this._refresh("col",false);array.forEach(this._selected.row,function(item){array.forEach(this.grid.layout.cells,function(cell){this._highlightNode(cell.getNode(item.row),false);},this);},this);query(".dojoxGridRowSelectorSelected").forEach(function(node){html.removeClass(node,"dojoxGridRowSelectorSelected");html.removeClass(node,"dojoxGridRowSelectorSelectedUp");html.removeClass(node,"dojoxGridRowSelectorSelectedDown");});var _132b=function(item){if(item){delete item.converted;}},_132c=[this._lastAnchorPoint[type],this._lastEndPoint[type],this._lastSelectedAnchorPoint[type],this._lastSelectedEndPoint[type]];if(type==="cell"){this.selectRange("cell",_132a.to.min,_132a.to.max);var cells=this.grid.layout.cells;array.forEach(_132c,function(item){if(item.converted){return;}for(var r=_132a.from.min.row,tr=_132a.to.min.row;r<=_132a.from.max.row;++r,++tr){for(var c=_132a.from.min.col,tc=_132a.to.min.col;c<=_132a.from.max.col;++c,++tc){while(cells[c].hidden){++c;}while(cells[tc].hidden){++tc;}if(item.row==r&&item.col==c){item.row=tr;item.col=tc;item.converted=true;return;}}}});}else{_132c=this._selected.cell.concat(this._selected[type]).concat(_132c).concat([this._lastAnchorPoint.cell,this._lastEndPoint.cell,this._lastSelectedAnchorPoint.cell,this._lastSelectedEndPoint.cell]);array.forEach(_132c,function(item){if(item&&!item.converted){var from=item[type];if(from in _132a){item[type]=_132a[from];}item.converted=true;}});array.forEach(this._selected[_12fc[type]],function(item){for(var i=0,len=item.except.length;i<len;++i){var from=item.except[i];if(from in _132a){item.except[i]=_132a[from];}}});}array.forEach(_132c,_132b);this._refreshSelected(true);this._focusPoint(type,this._lastEndPoint);}catch(e){console.warn("Selector._onInternalRearrange() error",e);}},_onExternalChange:function(type,_132d){var start=type=="cell"?_132d.min:_132d[0],end=type=="cell"?_132d.max:_132d[_132d.length-1];this.selectRange(type,start,end);},_refresh:function(type,_132e){if(!this._keyboardSelect[type]){array.forEach(this._selected[type],function(item){this._highlightSingle(type,_132e,item,undefined,true);},this);}},_refreshSelected:function(){this._refresh("col",true);this._refresh("row",true);this._refresh("cell",true);},_initAreas:function(){var g=this.grid,f=g.focus,_132f=this,_1330=1,_1331=2,_1332=function(type,_1333,_1334,_1335,evt){var ks=_132f._keyboardSelect;if(evt.shiftKey&&ks[type]){if(ks[type]===_1330){if(type==="cell"){var item=_132f._lastEndPoint[type];if(f.cell!=g.layout.cells[item.col+_1335]||f.rowIndex!=item.row+_1334){ks[type]=0;return;}}_132f._startSelect(type,_132f._lastAnchorPoint[type],true,false,true);_132f._highlight(type,_132f._lastEndPoint[type],_132f._toSelect);ks[type]=_1331;}var _1336=_1333(type,_1334,_1335,evt);if(_132f._isValid(type,_1336,g)){_132f._highlight(type,_1336,_132f._toSelect);}_1300(evt);}},_1337=function(type,_1338,evt,_1339){if(_1339&&_132f.selectEnabled()&&_132f._config[type]!=_12fa){switch(evt.keyCode){case keys.SPACE:_132f._startSelect(type,_1338(),evt.ctrlKey,evt.shiftKey);_132f._endSelect(type);break;case keys.SHIFT:if(_132f._config[type]==MULTI&&_132f._isValid(type,_132f._lastAnchorPoint[type],g)){_132f._endSelect(type);_132f._keyboardSelect[type]=_1330;_132f._usingKeyboard=true;}}}},_133a=function(type,evt,_133b){if(_133b&&evt.keyCode==keys.SHIFT&&_132f._keyboardSelect[type]){_132f._endSelect(type);_132f._keyboardSelect[type]=0;}};if(g.views.views[0] instanceof _12f7){this._lastFocusedRowBarIdx=0;f.addArea({name:"rowHeader",onFocus:function(evt,step){var view=g.views.views[0];if(view instanceof _12f7){var _133c=view.getCellNode(_132f._lastFocusedRowBarIdx,0);if(_133c){html.toggleClass(_133c,f.focusClass,false);}if(evt&&"rowIndex" in evt){if(evt.rowIndex>=0){_132f._lastFocusedRowBarIdx=evt.rowIndex;}else{if(!_132f._lastFocusedRowBarIdx){_132f._lastFocusedRowBarIdx=0;}}}_133c=view.getCellNode(_132f._lastFocusedRowBarIdx,0);if(_133c){_12f6.focus(_133c);html.toggleClass(_133c,f.focusClass,true);}f.rowIndex=_132f._lastFocusedRowBarIdx;_1300(evt);return true;}return false;},onBlur:function(evt,step){var view=g.views.views[0];if(view instanceof _12f7){var _133d=view.getCellNode(_132f._lastFocusedRowBarIdx,0);if(_133d){html.toggleClass(_133d,f.focusClass,false);}_1300(evt);}return true;},onMove:function(_133e,_133f,evt){var view=g.views.views[0];if(_133e&&view instanceof _12f7){var next=_132f._lastFocusedRowBarIdx+_133e;if(next>=0&&next<g.rowCount){_1300(evt);var _1340=view.getCellNode(_132f._lastFocusedRowBarIdx,0);html.toggleClass(_1340,f.focusClass,false);var sc=g.scroller;var _1341=sc.getLastPageRow(sc.page);var rc=g.rowCount-1,row=Math.min(rc,next);if(next>_1341){g.setScrollTop(g.scrollTop+sc.findScrollTop(row)-sc.findScrollTop(_132f._lastFocusedRowBarIdx));}_1340=view.getCellNode(next,0);_12f6.focus(_1340);html.toggleClass(_1340,f.focusClass,true);_132f._lastFocusedRowBarIdx=next;f.cell=_1340;f.cell.view=view;f.cell.getNode=function(index){return f.cell;};f.rowIndex=_132f._lastFocusedRowBarIdx;f.scrollIntoView();f.cell=null;}}}});f.placeArea("rowHeader","before","content");}f.addArea({name:"cellselect",onMove:lang.partial(_1332,"cell",function(type,_1342,_1343,evt){var _1344=_132f._currentPoint[type];return _1301("cell",_1344.row+_1342,_1344.col+_1343);}),onKeyDown:lang.partial(_1337,"cell",function(){return _1301("cell",f.rowIndex,f.cell.index);}),onKeyUp:lang.partial(_133a,"cell")});f.placeArea("cellselect","below","content");f.addArea({name:"colselect",onMove:lang.partial(_1332,"col",function(type,_1345,_1346,evt){var _1347=_132f._currentPoint[type];return _1301("col",_1347.col+_1346);}),onKeyDown:lang.partial(_1337,"col",function(){return _1301("col",f.getHeaderIndex());}),onKeyUp:lang.partial(_133a,"col")});f.placeArea("colselect","below","header");f.addArea({name:"rowselect",onMove:lang.partial(_1332,"row",function(type,_1348,_1349,evt){return _1301("row",f.rowIndex);}),onKeyDown:lang.partial(_1337,"row",function(){return _1301("row",f.rowIndex);}),onKeyUp:lang.partial(_133a,"row")});f.placeArea("rowselect","below","rowHeader");},_clearSelection:function(type,_134a){if(type=="all"){this._clearSelection("cell",_134a);this._clearSelection("col",_134a);this._clearSelection("row",_134a);return;}this._isUsingRowSelector=true;array.forEach(this._selected[type],function(item){if(!_12ff(type,_134a,item)){this._highlightSingle(type,false,item);}},this);this._blurPoint(type,this._currentPoint);this._selecting[type]=false;this._startPoint[type]=this._currentPoint[type]=null;this._selected[type]=[];if(type=="row"&&!this.grid._selectingRange){this._oldDeselectAll.call(this.grid.selection);this.grid.selection._selectedById={};}this.grid.onEndDeselect(type,null,null,this._selected);this.grid.onSelectCleared(type);},_startSelect:function(type,start,_134b,_134c,_134d,_134e){if(!this._isValid(type,start)){return;}var _134f=this._isSelected(type,this._lastEndPoint[type]),_1350=this._isSelected(type,start);if(this.noClear&&!_134b){this._toSelect=_134e===undefined?true:_134e;}else{this._toSelect=_134d?_1350:!_1350;}if(!_134b||(!_1350&&this._config[type]==_12fb)){this._clearSelection("col",start);this._clearSelection("cell",start);if(!this.noClear||(type==="row"&&this._config[type]==_12fb)){this._clearSelection("row",start);}this._toSelect=_134e===undefined?true:_134e;}this._selecting[type]=true;this._currentPoint[type]=null;if(_134c&&this._lastType==type&&_134f==this._toSelect&&this._config[type]==MULTI){if(type==="row"){this._isUsingRowSelector=true;}this._startPoint[type]=this._lastAnchorPoint[type];this._highlight(type,this._startPoint[type]);this._isUsingRowSelector=false;}else{this._startPoint[type]=start;}this._curType=type;this._fireEvent("start",type);this._isStartFocus=true;this._isUsingRowSelector=true;this._highlight(type,start,this._toSelect);this._isStartFocus=false;},_endSelect:function(type){if(type==="row"){delete this._isUsingRowSelector;}if(type=="all"){this._endSelect("col");this._endSelect("row");this._endSelect("cell");}else{if(this._selecting[type]){this._addToSelected(type);this._lastAnchorPoint[type]=this._startPoint[type];this._lastEndPoint[type]=this._currentPoint[type];if(this._toSelect){this._lastSelectedAnchorPoint[type]=this._lastAnchorPoint[type];this._lastSelectedEndPoint[type]=this._lastEndPoint[type];}this._startPoint[type]=this._currentPoint[type]=null;this._selecting[type]=false;this._lastType=type;this._fireEvent("end",type);}}},_fireEvent:function(_1351,type){switch(_1351){case "start":this.grid[this._toSelect?"onStartSelect":"onStartDeselect"](type,this._startPoint[type],this._selected);break;case "end":this.grid[this._toSelect?"onEndSelect":"onEndDeselect"](type,this._lastAnchorPoint[type],this._lastEndPoint[type],this._selected);break;}},_calcToHighlight:function(type,_1352,_1353,_1354){if(_1354!==undefined){var sltd;if(this._usingKeyboard&&!_1353){var last=this._isInLastRange(this._lastType,_1352);if(last){sltd=this._isSelected(type,_1352);if(_1354&&sltd){return false;}if(!_1354&&!sltd&&this._isInLastRange(this._lastType,_1352,true)){return true;}}}return _1353?_1354:(sltd||this._isSelected(type,_1352));}return _1353;},_highlightNode:function(node,_1355){if(node){var _1356="dojoxGridRowSelected";var _1357="dojoxGridCellSelected";html.toggleClass(node,_1356,_1355);html.toggleClass(node,_1357,_1355);}},_highlightHeader:function(_1358,_1359){var cells=this.grid.layout.cells;var node=cells[_1358].getHeaderNode();var _135a="dojoxGridHeaderSelected";html.toggleClass(node,_135a,_1359);},_highlightRowSelector:function(_135b,_135c){var _135d=this.grid.views.views[0];if(_135d instanceof _12f7){var node=_135d.getRowNode(_135b);if(node){var _135e="dojoxGridRowSelectorSelected";html.toggleClass(node,_135e,_135c);}}},_highlightSingle:function(type,_135f,_1360,_1361,_1362){var _1363=this,toHL,g=_1363.grid,cells=g.layout.cells;switch(type){case "cell":toHL=this._calcToHighlight(type,_1360,_135f,_1361);var c=cells[_1360.col];if(!c.hidden&&!c.notselectable){this._highlightNode(_1360.node||c.getNode(_1360.row),toHL);}break;case "col":toHL=this._calcToHighlight(type,_1360,_135f,_1361);this._highlightHeader(_1360.col,toHL);query("td[idx='"+_1360.col+"']",g.domNode).forEach(function(_1364){var _1365=cells[_1360.col].view.content.findRowTarget(_1364);if(_1365){var _1366=_1365[dojox.grid.util.rowIndexTag];_1363._highlightSingle("cell",toHL,{"row":_1366,"col":_1360.col,"node":_1364});}});break;case "row":toHL=this._calcToHighlight(type,_1360,_135f,_1361);this._highlightRowSelector(_1360.row,toHL);if(this._config.cell){array.forEach(cells,function(cell){_1363._highlightSingle("cell",toHL,{"row":_1360.row,"col":cell.index,"node":cell.getNode(_1360.row)});});}this._selectedRowModified=true;if(!_1362){g.selection.setSelected(_1360.row,toHL);}}},_highlight:function(type,_1367,_1368){if(this._selecting[type]&&_1367!==null){var start=this._startPoint[type],_1369=this._currentPoint[type],_136a=this,_136b=function(from,to,toHL){_136a._forEach(type,from,to,function(item){_136a._highlightSingle(type,toHL,item,_1368);},true);};switch(type){case "col":case "row":if(_1369!==null){if(_12fd(type,_1367,start,_1369,true)){_136b(_1369,_1367,false);}else{if(_12fd(type,start,_1367,_1369,true)){_136b(_1369,start,false);_1369=start;}_136b(_1367,_1369,true);}}else{this._highlightSingle(type,true,_1367,_1368);}break;case "cell":if(_1369!==null){if(_12fd("row",_1367,start,_1369,true)||_12fd("col",_1367,start,_1369,true)||_12fd("row",start,_1367,_1369,true)||_12fd("col",start,_1367,_1369,true)){_136b(start,_1369,false);}}_136b(start,_1367,true);}this._currentPoint[type]=_1367;this._focusPoint(type,this._currentPoint);}},_focusPoint:function(type,point){if(!this._isStartFocus){var _136c=point[type],f=this.grid.focus;if(type=="col"){f._colHeadFocusIdx=_136c.col;f.focusArea("header");}else{if(type=="row"){f.focusArea("rowHeader",{"rowIndex":_136c.row});}else{if(type=="cell"){f.setFocusIndex(_136c.row,_136c.col);}}}}},_blurPoint:function(type,point){var f=this.grid.focus;if(type=="cell"){f._blurContent();}},_addToSelected:function(type){var _136d=this._toSelect,_136e=this,toAdd=[],_136f=[],start=this._startPoint[type],end=this._currentPoint[type];if(this._usingKeyboard){this._forEach(type,this._lastAnchorPoint[type],this._lastEndPoint[type],function(item){if(!_12fd(type,item,start,end)){(_136d?_136f:toAdd).push(item);}});}this._forEach(type,start,end,function(item){var _1370=_136e._isSelected(type,item);if(_136d&&!_1370){toAdd.push(item);}else{if(!_136d){_136f.push(item);}}});this._add(type,toAdd);this._remove(type,_136f);array.forEach(this._selected.row,function(item){if(item.except.length>0){this._selectedRowModified=true;this.grid.selection.setSelected(item.row,false);}},this);},_forEach:function(type,start,end,func,_1371){if(!this._isValid(type,start,true)||!this._isValid(type,end,true)){return;}switch(type){case "col":case "row":start=start[type];end=end[type];var dir=end>start?1:-1;if(!_1371){end+=dir;}for(;start!=end;start+=dir){func(_1301(type,start));}break;case "cell":var _1372=end.col>start.col?1:-1,_1373=end.row>start.row?1:-1;for(var i=start.row,p=end.row+_1373;i!=p;i+=_1373){for(var j=start.col,q=end.col+_1372;j!=q;j+=_1372){func(_1301(type,i,j));}}}},_makeupForExceptions:function(type,_1374){var _1375=[];array.forEach(this._selected[type],function(v1){array.forEach(_1374,function(v2){if(v1[type]==v2[type]){var pos=array.indexOf(v1.except,v2[_12fc[type]]);if(pos>=0){v1.except.splice(pos,1);}_1375.push(v2);}});});return _1375;},_makeupForCells:function(type,_1376){var _1377=[];array.forEach(this._selected.cell,function(v1){array.some(_1376,function(v2){if(v1[type]==v2[type]){_1377.push(v1);return true;}return false;});});this._remove("cell",_1377);array.forEach(this._selected[_12fc[type]],function(v1){array.forEach(_1376,function(v2){var pos=array.indexOf(v1.except,v2[type]);if(pos>=0){v1.except.splice(pos,1);}});});},_addException:function(type,items){array.forEach(this._selected[type],function(v1){array.forEach(items,function(v2){v1.except.push(v2[_12fc[type]]);});});},_addCellException:function(type,items){array.forEach(this._selected[type],function(v1){array.forEach(items,function(v2){if(v1[type]==v2[type]){v1.except.push(v2[_12fc[type]]);}});});},_add:function(type,items){var cells=this.grid.layout.cells;if(type=="cell"){var _1378=this._makeupForExceptions("col",items);var _1379=this._makeupForExceptions("row",items);items=array.filter(items,function(item){return array.indexOf(_1378,item)<0&&array.indexOf(_1379,item)<0&&!cells[item.col].hidden&&!cells[item.col].notselectable;});}else{if(type=="col"){items=array.filter(items,function(item){return !cells[item.col].hidden&&!cells[item.col].notselectable;});}this._makeupForCells(type,items);this._selected[type]=array.filter(this._selected[type],function(v){return array.every(items,function(item){return v[type]!==item[type];});});}if(type!="col"&&this.grid._hasIdentity){array.forEach(items,function(item){var _137a=this.grid._by_idx[item.row];if(_137a){item.id=_137a.idty;}},this);}this._selected[type]=this._selected[type].concat(items);},_remove:function(type,items){var comp=lang.partial(_12ff,type);this._selected[type]=array.filter(this._selected[type],function(v1){return !array.some(items,function(v2){return comp(v1,v2);});});if(type=="cell"){this._addCellException("col",items);this._addCellException("row",items);}else{if(this._config.cell){this._addException(_12fc[type],items);}}},_isCellNotInExcept:function(type,item){var attr=item[type],_137b=item[_12fc[type]];return array.some(this._selected[type],function(v){return v[type]==attr&&array.indexOf(v.except,_137b)<0;});},_isSelected:function(type,item){if(!item){return false;}var res=array.some(this._selected[type],function(v){var ret=_12ff(type,item,v);if(ret&&type!=="cell"){return v.except.length===0;}return ret;});if(!res&&type==="cell"){res=(this._isCellNotInExcept("col",item)||this._isCellNotInExcept("row",item));if(type==="cell"){res=res&&!this.grid.layout.cells[item.col].notselectable;}}return res;},_isInLastRange:function(type,item,_137c){var start=this[_137c?"_lastSelectedAnchorPoint":"_lastAnchorPoint"][type],end=this[_137c?"_lastSelectedEndPoint":"_lastEndPoint"][type];if(!item||!start||!end){return false;}return _12fd(type,item,start,end);},_isValid:function(type,item,_137d){if(!item){return false;}try{var g=this.grid,index=item[type];switch(type){case "col":return index>=0&&index<g.layout.cells.length&&lang.isArray(item.except)&&(_137d||!g.layout.cells[index].notselectable);case "row":return index>=0&&index<g.rowCount&&lang.isArray(item.except);case "cell":return item.col>=0&&item.col<g.layout.cells.length&&item.row>=0&&item.row<g.rowCount&&(_137d||!g.layout.cells[item.col].notselectable);}}catch(e){}return false;}});_12f9.registerPlugin(_1304,{"dependency":["autoScroll"]});return _1304;});},"dojox/grid/enhanced/plugins/AutoScroll":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/_base/html","dojo/_base/window","../_Plugin","../../_RowSelector","../../EnhancedGrid"],function(_137e,array,lang,html,win,_137f,_1380,_1381){var _1382=_137e("dojox.grid.enhanced.plugins.AutoScroll",_137f,{name:"autoScroll",autoScrollInterval:1000,autoScrollMargin:30,constructor:function(grid,args){this.grid=grid;this.readyForAutoScroll=false;this._scrolling=false;args=lang.isObject(args)?args:{};if("interval" in args){this.autoScrollInterval=args.interval;}if("margin" in args){this.autoScrollMargin=args.margin;}this._initEvents();this._mixinGrid();},_initEvents:function(){var g=this.grid;this.connect(g,"onCellMouseDown",function(){this.readyForAutoScroll=true;});this.connect(g,"onHeaderCellMouseDown",function(){this.readyForAutoScroll=true;});this.connect(g,"onRowSelectorMouseDown",function(){this.readyForAutoScroll=true;});this.connect(win.doc,"onmouseup",function(evt){this._manageAutoScroll(true);this.readyForAutoScroll=false;});this.connect(win.doc,"onmousemove",function(evt){if(this.readyForAutoScroll){this._event=evt;var _1383=html.position(g.domNode),hh=g._getHeaderHeight(),_1384=this.autoScrollMargin,ey=evt.clientY,ex=evt.clientX,gy=_1383.y,gx=_1383.x,gh=_1383.h,gw=_1383.w;if(ex>=gx&&ex<=gx+gw){if(ey>=gy+hh&&ey<gy+hh+_1384){this._manageAutoScroll(false,true,false);return;}else{if(ey>gy+gh-_1384&&ey<=gy+gh){this._manageAutoScroll(false,true,true);return;}else{if(ey>=gy&&ey<=gy+gh){var _1385=array.some(g.views.views,function(view,i){if(view instanceof _1380){return false;}var _1386=html.position(view.domNode);if(ex<_1386.x+_1384&&ex>=_1386.x){this._manageAutoScroll(false,false,false,view);return true;}else{if(ex>_1386.x+_1386.w-_1384&&ex<_1386.x+_1386.w){this._manageAutoScroll(false,false,true,view);return true;}}return false;},this);if(_1385){return;}}}}}this._manageAutoScroll(true);}});},_mixinGrid:function(){var g=this.grid;g.onStartAutoScroll=function(){};g.onEndAutoScroll=function(){};},_fireEvent:function(_1387,args){var g=this.grid;switch(_1387){case "start":g.onStartAutoScroll.apply(g,args);break;case "end":g.onEndAutoScroll.apply(g,args);break;}},_manageAutoScroll:function(_1388,_1389,_138a,view){if(_1388){this._scrolling=false;clearInterval(this._handler);}else{if(!this._scrolling){this._scrolling=true;this._fireEvent("start",[_1389,_138a,view]);this._autoScroll(_1389,_138a,view);this._handler=setInterval(lang.hitch(this,"_autoScroll",_1389,_138a,view),this.autoScrollInterval);}}},_autoScroll:function(_138b,_138c,view){var g=this.grid,_138d=null;if(_138b){var _138e=g.scroller.firstVisibleRow+(_138c?1:-1);if(_138e>=0&&_138e<g.rowCount){g.scrollToRow(_138e);_138d=_138e;}}else{_138d=this._scrollColumn(_138c,view);}if(_138d!==null){this._fireEvent("end",[_138b,_138c,view,_138d,this._event]);}},_scrollColumn:function(_138f,view){var node=view.scrollboxNode,_1390=null;if(node.clientWidth<node.scrollWidth){var cells=array.filter(this.grid.layout.cells,function(cell){return !cell.hidden;});var _1391=html.position(view.domNode);var limit,edge,_1392,i;if(_138f){limit=node.clientWidth;for(i=0;i<cells.length;++i){_1392=html.position(cells[i].getHeaderNode());edge=_1392.x-_1391.x+_1392.w;if(edge>limit){_1390=cells[i].index;node.scrollLeft+=edge-limit+10;break;}}}else{limit=0;for(i=cells.length-1;i>=0;--i){_1392=html.position(cells[i].getHeaderNode());edge=_1392.x-_1391.x;if(edge<limit){_1390=cells[i].index;node.scrollLeft+=edge-limit-10;break;}}}}return _1390;}});_1381.registerPlugin(_1382);return _1382;});},"dojox/grid/enhanced/plugins/Menu":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/_base/html","dojo/_base/event","dojo/keys","../_Plugin","../../EnhancedGrid"],function(_1393,array,lang,html,evt,keys,_1394,_1395){var Menu=_1393("dojox.grid.enhanced.plugins.Menu",_1394,{name:"menus",types:["headerMenu","rowMenu","cellMenu","selectedRegionMenu"],constructor:function(){var g=this.grid;g.showMenu=lang.hitch(g,this.showMenu);g._setRowMenuAttr=lang.hitch(this,"_setRowMenuAttr");g._setCellMenuAttr=lang.hitch(this,"_setCellMenuAttr");g._setSelectedRegionMenuAttr=lang.hitch(this,"_setSelectedRegionMenuAttr");},onStartUp:function(){var type,_1396=this.option;for(type in _1396){if(array.indexOf(this.types,type)>=0&&_1396[type]){this._initMenu(type,_1396[type]);}}},_initMenu:function(_1397,menu){var g=this.grid;if(!g[_1397]){var m=this._getMenuWidget(menu);if(!m){return;}g.set(_1397,m);if(_1397!="headerMenu"){m._scheduleOpen=function(){return;};}else{g.setupHeaderMenu();}}},_getMenuWidget:function(menu){return (menu instanceof dijit.Menu)?menu:dijit.byId(menu);},_setRowMenuAttr:function(menu){this._setMenuAttr(menu,"rowMenu");},_setCellMenuAttr:function(menu){this._setMenuAttr(menu,"cellMenu");},_setSelectedRegionMenuAttr:function(menu){this._setMenuAttr(menu,"selectedRegionMenu");},_setMenuAttr:function(menu,_1398){var g=this.grid,n=g.domNode;if(!menu||!(menu instanceof dijit.Menu)){console.warn(_1398," of Grid ",g.id," is not existed!");return;}if(g[_1398]){g[_1398].unBindDomNode(n);}g[_1398]=menu;g[_1398].bindDomNode(n);},showMenu:function(e){var _1399=(e.cellNode&&html.hasClass(e.cellNode,"dojoxGridRowSelected")||e.rowNode&&(html.hasClass(e.rowNode,"dojoxGridRowSelected")||html.hasClass(e.rowNode,"dojoxGridRowbarSelected")));if(_1399&&this.selectedRegionMenu){this.onSelectedRegionContextMenu(e);return;}var info={target:e.target,coords:e.keyCode!==keys.F10&&"pageX" in e?{x:e.pageX,y:e.pageY}:null};if(this.rowMenu&&(!this.cellMenu||this.selection.isSelected(e.rowIndex)||e.rowNode&&html.hasClass(e.rowNode,"dojoxGridRowbar"))){this.rowMenu._openMyself(info);evt.stop(e);return;}if(this.cellMenu){this.cellMenu._openMyself(info);}evt.stop(e);},destroy:function(){var g=this.grid;if(g.headerMenu){g.headerMenu.unBindDomNode(g.viewsHeaderNode);}if(g.rowMenu){g.rowMenu.unBindDomNode(g.domNode);}if(g.cellMenu){g.cellMenu.unBindDomNode(g.domNode);}if(g.selectedRegionMenu){g.selectedRegionMenu.destroy();}this.inherited(arguments);}});_1395.registerPlugin(Menu);return Menu;});},"dojox/grid/enhanced/plugins/DnD":function(){define(["dojo/_base/kernel","dojo/_base/declare","dojo/_base/connect","dojo/_base/array","dojo/_base/lang","dojo/_base/html","dojo/_base/json","dojo/_base/window","dojo/query","dojo/keys","dojo/dnd/Source","dojo/dnd/Avatar","../_Plugin","../../EnhancedGrid","dojo/dnd/Manager","./Selector","./Rearrange"],function(dojo,_139a,_139b,array,lang,html,json,win,query,keys,_139c,_139d,_139e,_139f,_13a0){var _13a1=function(a){a.sort(function(v1,v2){return v1-v2;});var arr=[[a[0]]];for(var i=1,j=0;i<a.length;++i){if(a[i]==a[i-1]+1){arr[j].push(a[i]);}else{arr[++j]=[a[i]];}}return arr;},_13a2=function(_13a3){var a=_13a3[0];for(var i=1;i<_13a3.length;++i){a=a.concat(_13a3[i]);}return a;};var _13a4=_139a("dojox.grid.enhanced.plugins.GridDnDElement",null,{constructor:function(_13a5){this.plugin=_13a5;this.node=html.create("div");this._items={};},destroy:function(){this.plugin=null;html.destroy(this.node);this.node=null;this._items=null;},createDnDNodes:function(_13a6){this.destroyDnDNodes();var _13a7=["grid/"+_13a6.type+"s"];var _13a8=this.plugin.grid.id+"_dndItem";array.forEach(_13a6.selected,function(range,i){var id=_13a8+i;this._items[id]={"type":_13a7,"data":range,"dndPlugin":this.plugin};this.node.appendChild(html.create("div",{"id":id}));},this);},getDnDNodes:function(){return array.map(this.node.childNodes,function(node){return node;});},destroyDnDNodes:function(){html.empty(this.node);this._items={};},getItem:function(_13a9){return this._items[_13a9];}});var _13aa=_139a("dojox.grid.enhanced.plugins.GridDnDSource",_139c,{accept:["grid/cells","grid/rows","grid/cols"],constructor:function(node,param){this.grid=param.grid;this.dndElem=param.dndElem;this.dndPlugin=param.dnd;this.sourcePlugin=null;},destroy:function(){this.inherited(arguments);this.grid=null;this.dndElem=null;this.dndPlugin=null;this.sourcePlugin=null;},getItem:function(_13ab){return this.dndElem.getItem(_13ab);},checkAcceptance:function(_13ac,nodes){if(this!=_13ac&&nodes[0]){var item=_13ac.getItem(nodes[0].id);if(item.dndPlugin){var type=item.type;for(var j=0;j<type.length;++j){if(type[j] in this.accept){if(this.dndPlugin._canAccept(item.dndPlugin)){this.sourcePlugin=item.dndPlugin;}else{return false;}break;}}}else{if("grid/rows" in this.accept){var rows=[];array.forEach(nodes,function(node){var item=_13ac.getItem(node.id);if(item.data&&array.indexOf(item.type,"grid/rows")>=0){var _13ad=item.data;if(typeof item.data=="string"){_13ad=json.fromJson(item.data);}if(_13ad){rows.push(_13ad);}}});if(rows.length){this.sourcePlugin={_dndRegion:{type:"row",selected:[rows]}};}else{return false;}}}}return this.inherited(arguments);},onDraggingOver:function(){this.dndPlugin.onDraggingOver(this.sourcePlugin);},onDraggingOut:function(){this.dndPlugin.onDraggingOut(this.sourcePlugin);},onDndDrop:function(_13ae,nodes,copy,_13af){this.onDndCancel();if(this!=_13ae&&this==_13af){this.dndPlugin.onDragIn(this.sourcePlugin,copy);}}});var _13b0=_139a("dojox.grid.enhanced.plugins.GridDnDAvatar",_139d,{construct:function(){this._itemType=this.manager._dndPlugin._dndRegion.type;this._itemCount=this._getItemCount();this.isA11y=html.hasClass(win.body(),"dijit_a11y");var a=html.create("table",{"border":"0","cellspacing":"0","class":"dojoxGridDndAvatar","style":{position:"absolute",zIndex:"1999",margin:"0px"}}),_13b1=this.manager.source,b=html.create("tbody",null,a),tr=html.create("tr",null,b),td=html.create("td",{"class":"dojoxGridDnDIcon"},tr);if(this.isA11y){html.create("span",{"id":"a11yIcon","innerHTML":this.manager.copy?"+":"<"},td);}td=html.create("td",{"class":"dojoxGridDnDItemIcon "+this._getGridDnDIconClass()},tr);td=html.create("td",null,tr);html.create("span",{"class":"dojoxGridDnDItemCount","innerHTML":_13b1.generateText?this._generateText():""},td);html.style(tr,{"opacity":0.9});this.node=a;},_getItemCount:function(){var _13b2=this.manager._dndPlugin._dndRegion.selected,count=0;switch(this._itemType){case "cell":_13b2=_13b2[0];var cells=this.manager._dndPlugin.grid.layout.cells,_13b3=_13b2.max.col-_13b2.min.col+1,_13b4=_13b2.max.row-_13b2.min.row+1;if(_13b3>1){for(var i=_13b2.min.col;i<=_13b2.max.col;++i){if(cells[i].hidden){--_13b3;}}}count=_13b3*_13b4;break;case "row":case "col":count=_13a2(_13b2).length;}return count;},_getGridDnDIconClass:function(){return {"row":["dojoxGridDnDIconRowSingle","dojoxGridDnDIconRowMulti"],"col":["dojoxGridDnDIconColSingle","dojoxGridDnDIconColMulti"],"cell":["dojoxGridDnDIconCellSingle","dojoxGridDnDIconCellMulti"]}[this._itemType][this._itemCount==1?0:1];},_generateText:function(){return "("+this._itemCount+")";}});var DnD=_139a("dojox.grid.enhanced.plugins.DnD",_139e,{name:"dnd",_targetAnchorBorderWidth:2,_copyOnly:false,_config:{"row":{"within":true,"in":true,"out":true},"col":{"within":true,"in":true,"out":true},"cell":{"within":true,"in":true,"out":true}},constructor:function(grid,args){this.grid=grid;this._config=lang.clone(this._config);args=lang.isObject(args)?args:{};this.setupConfig(args.dndConfig);this._copyOnly=!!args.copyOnly;this._mixinGrid();this.selector=grid.pluginMgr.getPlugin("selector");this.rearranger=grid.pluginMgr.getPlugin("rearrange");this.rearranger.setArgs(args);this._clear();this._elem=new _13a4(this);this._source=new _13aa(this._elem.node,{"grid":grid,"dndElem":this._elem,"dnd":this});this._container=query(".dojoxGridMasterView",this.grid.domNode)[0];this._initEvents();},destroy:function(){this.inherited(arguments);this._clear();this._source.destroy();this._elem.destroy();this._container=null;this.grid=null;this.selector=null;this.rearranger=null;this._config=null;},_mixinGrid:function(){this.grid.setupDnDConfig=lang.hitch(this,"setupConfig");this.grid.dndCopyOnly=lang.hitch(this,"copyOnly");},setupConfig:function(_13b5){if(_13b5&&lang.isObject(_13b5)){var _13b6=["row","col","cell"],_13b7=["within","in","out"],cfg=this._config;array.forEach(_13b6,function(type){if(type in _13b5){var t=_13b5[type];if(t&&lang.isObject(t)){array.forEach(_13b7,function(mode){if(mode in t){cfg[type][mode]=!!t[mode];}});}else{array.forEach(_13b7,function(mode){cfg[type][mode]=!!t;});}}});array.forEach(_13b7,function(mode){if(mode in _13b5){var m=_13b5[mode];if(m&&lang.isObject(m)){array.forEach(_13b6,function(type){if(type in m){cfg[type][mode]=!!m[type];}});}else{array.forEach(_13b6,function(type){cfg[type][mode]=!!m;});}}});}},copyOnly:function(_13b8){if(typeof _13b8!="undefined"){this._copyOnly=!!_13b8;}return this._copyOnly;},_isOutOfGrid:function(evt){var _13b9=html.position(this.grid.domNode),x=evt.clientX,y=evt.clientY;return y<_13b9.y||y>_13b9.y+_13b9.h||x<_13b9.x||x>_13b9.x+_13b9.w;},_onMouseMove:function(evt){if(this._dndRegion&&!this._dnding&&!this._externalDnd){this._dnding=true;this._startDnd(evt);}else{if(this._isMouseDown&&!this._dndRegion){delete this._isMouseDown;this._oldCursor=html.style(win.body(),"cursor");html.style(win.body(),"cursor","not-allowed");}var isOut=this._isOutOfGrid(evt);if(!this._alreadyOut&&isOut){this._alreadyOut=true;if(this._dnding){this._destroyDnDUI(true,false);}this._moveEvent=evt;this._source.onOutEvent();}else{if(this._alreadyOut&&!isOut){this._alreadyOut=false;if(this._dnding){this._createDnDUI(evt,true);}this._moveEvent=evt;this._source.onOverEvent();}}}},_onMouseUp:function(){if(!this._extDnding&&!this._isSource){var _13ba=this._dnding&&!this._alreadyOut;if(_13ba&&this._config[this._dndRegion.type]["within"]){this._rearrange();}this._endDnd(_13ba);}html.style(win.body(),"cursor",this._oldCursor||"");delete this._isMouseDown;},_initEvents:function(){var g=this.grid,s=this.selector;this.connect(win.doc,"onmousemove","_onMouseMove");this.connect(win.doc,"onmouseup","_onMouseUp");this.connect(g,"onCellMouseOver",function(evt){if(!this._dnding&&!s.isSelecting()&&!evt.ctrlKey){this._dndReady=s.isSelected("cell",evt.rowIndex,evt.cell.index);s.selectEnabled(!this._dndReady);}});this.connect(g,"onHeaderCellMouseOver",function(evt){if(this._dndReady){s.selectEnabled(true);}});this.connect(g,"onRowMouseOver",function(evt){if(this._dndReady&&!evt.cell){s.selectEnabled(true);}});this.connect(g,"onCellMouseDown",function(evt){if(!evt.ctrlKey&&this._dndReady){this._dndRegion=this._getDnDRegion(evt.rowIndex,evt.cell.index);this._isMouseDown=true;}});this.connect(g,"onCellMouseUp",function(evt){if(!this._dndReady&&!s.isSelecting()&&evt.cell){this._dndReady=s.isSelected("cell",evt.rowIndex,evt.cell.index);s.selectEnabled(!this._dndReady);}});this.connect(g,"onCellClick",function(evt){if(this._dndReady&&!evt.ctrlKey&&!evt.shiftKey){s.select("cell",evt.rowIndex,evt.cell.index);}});this.connect(g,"onEndAutoScroll",function(_13bb,_13bc,view,_13bd,evt){if(this._dnding){this._markTargetAnchor(evt);}});this.connect(win.doc,"onkeydown",function(evt){if(evt.keyCode==keys.ESCAPE){this._endDnd(false);}else{if(evt.keyCode==keys.CTRL){s.selectEnabled(true);this._isCopy=true;}}});this.connect(win.doc,"onkeyup",function(evt){if(evt.keyCode==keys.CTRL){s.selectEnabled(!this._dndReady);this._isCopy=false;}});},_clear:function(){this._dndRegion=null;this._target=null;this._moveEvent=null;this._targetAnchor={};this._dnding=false;this._externalDnd=false;this._isSource=false;this._alreadyOut=false;this._extDnding=false;},_getDnDRegion:function(_13be,_13bf){var s=this.selector,_13c0=s._selected,flag=(!!_13c0.cell.length)|(!!_13c0.row.length<<1)|(!!_13c0.col.length<<2),type;switch(flag){case 1:type="cell";if(!this._config[type]["within"]&&!this._config[type]["out"]){return null;}var cells=this.grid.layout.cells,_13c1=function(range){var _13c2=0;for(var i=range.min.col;i<=range.max.col;++i){if(cells[i].hidden){++_13c2;}}return (range.max.row-range.min.row+1)*(range.max.col-range.min.col+1-_13c2);},_13c3=function(item,range){return item.row>=range.min.row&&item.row<=range.max.row&&item.col>=range.min.col&&item.col<=range.max.col;},range={max:{row:-1,col:-1},min:{row:Infinity,col:Infinity}};array.forEach(_13c0[type],function(item){if(item.row<range.min.row){range.min.row=item.row;}if(item.row>range.max.row){range.max.row=item.row;}if(item.col<range.min.col){range.min.col=item.col;}if(item.col>range.max.col){range.max.col=item.col;}});if(array.some(_13c0[type],function(item){return item.row==_13be&&item.col==_13bf;})){if(_13c1(range)==_13c0[type].length&&array.every(_13c0[type],function(item){return _13c3(item,range);})){return {"type":type,"selected":[range],"handle":{"row":_13be,"col":_13bf}};}}return null;case 2:case 4:type=flag==2?"row":"col";if(!this._config[type]["within"]&&!this._config[type]["out"]){return null;}var res=s.getSelected(type);if(res.length){return {"type":type,"selected":_13a1(res),"handle":flag==2?_13be:_13bf};}return null;}return null;},_startDnd:function(evt){this._createDnDUI(evt);},_endDnd:function(_13c4){this._destroyDnDUI(false,_13c4);this._clear();},_createDnDUI:function(evt,_13c5){var _13c6=html.position(this.grid.views.views[0].domNode);html.style(this._container,"height",_13c6.h+"px");try{if(!_13c5){this._createSource(evt);}this._createMoveable(evt);this._oldCursor=html.style(win.body(),"cursor");html.style(win.body(),"cursor","default");}catch(e){console.warn("DnD._createDnDUI() error:",e);}},_destroyDnDUI:function(_13c7,_13c8){try{if(_13c8){this._destroySource();}this._unmarkTargetAnchor();if(!_13c7){this._destroyMoveable();}html.style(win.body(),"cursor",this._oldCursor);}catch(e){console.warn("DnD._destroyDnDUI() error:",this.grid.id,e);}},_createSource:function(evt){this._elem.createDnDNodes(this._dndRegion);var m=_13a0.manager();var _13c9=m.makeAvatar;m._dndPlugin=this;m.makeAvatar=function(){var _13ca=new _13b0(m);delete m._dndPlugin;return _13ca;};m.startDrag(this._source,this._elem.getDnDNodes(),evt.ctrlKey);m.makeAvatar=_13c9;m.onMouseMove(evt);},_destroySource:function(){_139b.publish("/dnd/cancel");},_createMoveable:function(evt){if(!this._markTagetAnchorHandler){this._markTagetAnchorHandler=this.connect(win.doc,"onmousemove","_markTargetAnchor");}},_destroyMoveable:function(){this.disconnect(this._markTagetAnchorHandler);delete this._markTagetAnchorHandler;},_calcColTargetAnchorPos:function(evt,_13cb){var i,_13cc,left,_13cd,ex=evt.clientX,cells=this.grid.layout.cells,ltr=html._isBodyLtr(),_13ce=this._getVisibleHeaders();for(i=0;i<_13ce.length;++i){_13cc=html.position(_13ce[i].node);if(ltr?((i===0||ex>=_13cc.x)&&ex<_13cc.x+_13cc.w):((i===0||ex<_13cc.x+_13cc.w)&&ex>=_13cc.x)){left=_13cc.x+(ltr?0:_13cc.w);break;}else{if(ltr?(i===_13ce.length-1&&ex>=_13cc.x+_13cc.w):(i===_13ce.length-1&&ex<_13cc.x)){++i;left=_13cc.x+(ltr?_13cc.w:0);break;}}}if(i<_13ce.length){_13cd=_13ce[i].cell.index;if(this.selector.isSelected("col",_13cd)&&this.selector.isSelected("col",_13cd-1)){var _13cf=this._dndRegion.selected;for(i=0;i<_13cf.length;++i){if(array.indexOf(_13cf[i],_13cd)>=0){_13cd=_13cf[i][0];_13cc=html.position(cells[_13cd].getHeaderNode());left=_13cc.x+(ltr?0:_13cc.w);break;}}}}else{_13cd=cells.length;}this._target=_13cd;return left-_13cb.x;},_calcRowTargetAnchorPos:function(evt,_13d0){var g=this.grid,top,i=0,cells=g.layout.cells;while(cells[i].hidden){++i;}var cell=g.layout.cells[i],_13d1=g.scroller.firstVisibleRow,_13d2=cell.getNode(_13d1);if(!_13d2){this._target=-1;return 0;}var _13d3=html.position(_13d2);while(_13d3.y+_13d3.h<evt.clientY){if(++_13d1>=g.rowCount){break;}_13d3=html.position(cell.getNode(_13d1));}if(_13d1<g.rowCount){if(this.selector.isSelected("row",_13d1)&&this.selector.isSelected("row",_13d1-1)){var _13d4=this._dndRegion.selected;for(i=0;i<_13d4.length;++i){if(array.indexOf(_13d4[i],_13d1)>=0){_13d1=_13d4[i][0];_13d3=html.position(cell.getNode(_13d1));break;}}}top=_13d3.y;}else{top=_13d3.y+_13d3.h;}this._target=_13d1;return top-_13d0.y;},_calcCellTargetAnchorPos:function(evt,_13d5,_13d6){var s=this._dndRegion.selected[0],_13d7=this._dndRegion.handle,g=this.grid,ltr=html._isBodyLtr(),cells=g.layout.cells,_13d8,_13d9,_13da,_13db,_13dc,width,left,top,_13dd,_13de,i,_13df=_13d7.col-s.min.col,_13e0=s.max.col-_13d7.col,_13e1,_13e2;if(!_13d6.childNodes.length){_13e1=html.create("div",{"class":"dojoxGridCellBorderLeftTopDIV"},_13d6);_13e2=html.create("div",{"class":"dojoxGridCellBorderRightBottomDIV"},_13d6);}else{_13e1=query(".dojoxGridCellBorderLeftTopDIV",_13d6)[0];_13e2=query(".dojoxGridCellBorderRightBottomDIV",_13d6)[0];}for(i=s.min.col+1;i<_13d7.col;++i){if(cells[i].hidden){--_13df;}}for(i=_13d7.col+1;i<s.max.col;++i){if(cells[i].hidden){--_13e0;}}_13db=this._getVisibleHeaders();for(i=_13df;i<_13db.length-_13e0;++i){_13d8=html.position(_13db[i].node);if((evt.clientX>=_13d8.x&&evt.clientX<_13d8.x+_13d8.w)||(i==_13df&&(ltr?evt.clientX<_13d8.x:evt.clientX>=_13d8.x+_13d8.w))||(i==_13db.length-_13e0-1&&(ltr?evt.clientX>=_13d8.x+_13d8.w:evt<_13d8.x))){_13dd=_13db[i-_13df];_13de=_13db[i+_13e0];_13d9=html.position(_13dd.node);_13da=html.position(_13de.node);_13dd=_13dd.cell.index;_13de=_13de.cell.index;left=ltr?_13d9.x:_13da.x;width=ltr?(_13da.x+_13da.w-_13d9.x):(_13d9.x+_13d9.w-_13da.x);break;}}i=0;while(cells[i].hidden){++i;}var cell=cells[i],_13e3=g.scroller.firstVisibleRow,_13e4=html.position(cell.getNode(_13e3));while(_13e4.y+_13e4.h<evt.clientY){if(++_13e3<g.rowCount){_13e4=html.position(cell.getNode(_13e3));}else{break;}}var _13e5=_13e3>=_13d7.row-s.min.row?_13e3-_13d7.row+s.min.row:0;var _13e6=_13e5+s.max.row-s.min.row;if(_13e6>=g.rowCount){_13e6=g.rowCount-1;_13e5=_13e6-s.max.row+s.min.row;}_13d9=html.position(cell.getNode(_13e5));_13da=html.position(cell.getNode(_13e6));top=_13d9.y;_13dc=_13da.y+_13da.h-_13d9.y;this._target={"min":{"row":_13e5,"col":_13dd},"max":{"row":_13e6,"col":_13de}};var _13e7=(html.marginBox(_13e1).w-html.contentBox(_13e1).w)/2;var _13e8=html.position(cells[_13dd].getNode(_13e5));html.style(_13e1,{"width":(_13e8.w-_13e7)+"px","height":(_13e8.h-_13e7)+"px"});var _13e9=html.position(cells[_13de].getNode(_13e6));html.style(_13e2,{"width":(_13e9.w-_13e7)+"px","height":(_13e9.h-_13e7)+"px"});return {h:_13dc,w:width,l:left-_13d5.x,t:top-_13d5.y};},_markTargetAnchor:function(evt){try{var t=this._dndRegion.type;if(this._alreadyOut||(this._dnding&&!this._config[t]["within"])||(this._extDnding&&!this._config[t]["in"])){return;}var _13ea,width,left,top,_13eb=this._targetAnchor[t],pos=html.position(this._container);if(!_13eb){_13eb=this._targetAnchor[t]=html.create("div",{"class":(t=="cell")?"dojoxGridCellBorderDIV":"dojoxGridBorderDIV"});html.style(_13eb,"display","none");this._container.appendChild(_13eb);}switch(t){case "col":_13ea=pos.h;width=this._targetAnchorBorderWidth;left=this._calcColTargetAnchorPos(evt,pos);top=0;break;case "row":_13ea=this._targetAnchorBorderWidth;width=pos.w;left=0;top=this._calcRowTargetAnchorPos(evt,pos);break;case "cell":var _13ec=this._calcCellTargetAnchorPos(evt,pos,_13eb);_13ea=_13ec.h;width=_13ec.w;left=_13ec.l;top=_13ec.t;}if(typeof _13ea=="number"&&typeof width=="number"&&typeof left=="number"&&typeof top=="number"){html.style(_13eb,{"height":_13ea+"px","width":width+"px","left":left+"px","top":top+"px"});html.style(_13eb,"display","");}else{this._target=null;}}catch(e){console.warn("DnD._markTargetAnchor() error:",e);}},_unmarkTargetAnchor:function(){if(this._dndRegion){var _13ed=this._targetAnchor[this._dndRegion.type];if(_13ed){html.style(this._targetAnchor[this._dndRegion.type],"display","none");}}},_getVisibleHeaders:function(){return array.map(array.filter(this.grid.layout.cells,function(cell){return !cell.hidden;}),function(cell){return {"node":cell.getHeaderNode(),"cell":cell};});},_rearrange:function(){if(this._target===null){return;}var t=this._dndRegion.type;var _13ee=this._dndRegion.selected;if(t==="cell"){this.rearranger[(this._isCopy||this._copyOnly)?"copyCells":"moveCells"](_13ee[0],this._target===-1?null:this._target);}else{this.rearranger[t=="col"?"moveColumns":"moveRows"](_13a2(_13ee),this._target===-1?null:this._target);}this._target=null;},onDraggingOver:function(_13ef){if(!this._dnding&&_13ef){_13ef._isSource=true;this._extDnding=true;if(!this._externalDnd){this._externalDnd=true;this._dndRegion=this._mapRegion(_13ef.grid,_13ef._dndRegion);}this._createDnDUI(this._moveEvent,true);this.grid.pluginMgr.getPlugin("autoScroll").readyForAutoScroll=true;}},_mapRegion:function(_13f0,_13f1){if(_13f1.type==="cell"){var _13f2=_13f1.selected[0];var cells=this.grid.layout.cells;var _13f3=_13f0.layout.cells;var c,cnt=0;for(c=_13f2.min.col;c<=_13f2.max.col;++c){if(!_13f3[c].hidden){++cnt;}}for(c=0;cnt>0;++c){if(!cells[c].hidden){--cnt;}}var _13f4=lang.clone(_13f1);_13f4.selected[0].min.col=0;_13f4.selected[0].max.col=c-1;for(c=_13f2.min.col;c<=_13f1.handle.col;++c){if(!_13f3[c].hidden){++cnt;}}for(c=0;cnt>0;++c){if(!cells[c].hidden){--cnt;}}_13f4.handle.col=c;}return _13f1;},onDraggingOut:function(_13f5){if(this._externalDnd){this._extDnding=false;this._destroyDnDUI(true,false);if(_13f5){_13f5._isSource=false;}}},onDragIn:function(_13f6,_13f7){var _13f8=false;if(this._target!==null){var type=_13f6._dndRegion.type;var _13f9=_13f6._dndRegion.selected;switch(type){case "cell":this.rearranger.changeCells(_13f6.grid,_13f9[0],this._target);break;case "row":var range=_13a2(_13f9);this.rearranger.insertRows(_13f6.grid,range,this._target);break;}_13f8=true;}this._endDnd(true);if(_13f6.onDragOut){_13f6.onDragOut(_13f8&&!_13f7);}},onDragOut:function(_13fa){if(_13fa&&!this._copyOnly){var type=this._dndRegion.type;var _13fb=this._dndRegion.selected;switch(type){case "cell":this.rearranger.clearCells(_13fb[0]);break;case "row":this.rearranger.removeRows(_13a2(_13fb));break;}}this._endDnd(true);},_canAccept:function(_13fc){if(!_13fc){return false;}var _13fd=_13fc._dndRegion;var type=_13fd.type;if(!this._config[type]["in"]||!_13fc._config[type]["out"]){return false;}var g=this.grid;var _13fe=_13fd.selected;var _13ff=array.filter(g.layout.cells,function(cell){return !cell.hidden;}).length;var _1400=g.rowCount;var res=true;switch(type){case "cell":_13fe=_13fe[0];res=g.store.getFeatures()["dojo.data.api.Write"]&&(_13fe.max.row-_13fe.min.row)<=_1400&&array.filter(_13fc.grid.layout.cells,function(cell){return cell.index>=_13fe.min.col&&cell.index<=_13fe.max.col&&!cell.hidden;}).length<=_13ff;case "row":if(_13fc._allDnDItemsLoaded()){return res;}}return false;},_allDnDItemsLoaded:function(){if(this._dndRegion){var type=this._dndRegion.type,_1401=this._dndRegion.selected,rows=[];switch(type){case "cell":for(var i=_1401[0].min.row,max=_1401[0].max.row;i<=max;++i){rows.push(i);}break;case "row":rows=_13a2(_1401);break;default:return false;}var cache=this.grid._by_idx;return array.every(rows,function(_1402){return !!cache[_1402];});}return false;}});_139f.registerPlugin(DnD,{"dependency":["selector","rearrange"]});return DnD;});},"dojox/grid/enhanced/plugins/Rearrange":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/_base/connect","../../EnhancedGrid","../_Plugin","./_RowMapLayer"],function(dojo,lang,_1403,array,_1404,_1405,_1406,_1407){var _1408=_1403("dojox.grid.enhanced.plugins.Rearrange",_1406,{name:"rearrange",constructor:function(grid,args){this.grid=grid;this.setArgs(args);var _1409=new _1407(grid);dojox.grid.enhanced.plugins.wrap(grid,"_storeLayerFetch",_1409);},setArgs:function(args){this.args=lang.mixin(this.args||{},args||{});this.args.setIdentifierForNewItem=this.args.setIdentifierForNewItem||function(v){return v;};},destroy:function(){this.inherited(arguments);this.grid.unwrap("rowmap");},onSetStore:function(store){this.grid.layer("rowmap").clearMapping();},_hasIdentity:function(_140a){var g=this.grid,s=g.store,cells=g.layout.cells;if(s.getFeatures()["dojo.data.api.Identity"]){if(array.some(_140a,function(point){return s.getIdentityAttributes(g._by_idx[point.r].item)==cells[point.c].field;})){return true;}}return false;},moveColumns:function(_140b,_140c){var g=this.grid,_140d=g.layout,cells=_140d.cells,_140e,i,delta=0,_140f=true,tmp={},_1410={};_140b.sort(function(a,b){return a-b;});for(i=0;i<_140b.length;++i){tmp[_140b[i]]=i;if(_140b[i]<_140c){++delta;}}var _1411=0,_1412=0;var _1413=Math.max(_140b[_140b.length-1],_140c);if(_1413==cells.length){--_1413;}var _1414=Math.min(_140b[0],_140c);for(i=_1414;i<=_1413;++i){var j=tmp[i];if(j>=0){_1410[i]=_140c-delta+j;}else{if(i<_140c){_1410[i]=_1414+_1411;++_1411;}else{if(i>=_140c){_1410[i]=_140c+_140b.length-delta+_1412;++_1412;}}}}delta=0;if(_140c==cells.length){--_140c;_140f=false;}g._notRefreshSelection=true;for(i=0;i<_140b.length;++i){_140e=_140b[i];if(_140e<_140c){_140e-=delta;}++delta;if(_140e!=_140c){_140d.moveColumn(cells[_140e].view.idx,cells[_140c].view.idx,_140e,_140c,_140f);cells=_140d.cells;}if(_140c<=_140e){++_140c;}}delete g._notRefreshSelection;_1404.publish("dojox/grid/rearrange/move/"+g.id,["col",_1410,_140b]);},moveRows:function(_1415,_1416){var g=this.grid,_1417={},_1418=[],_1419=[],len=_1415.length,i,r,k,arr,_141a,_141b;for(i=0;i<len;++i){r=_1415[i];if(r>=_1416){break;}_1418.push(r);}_1419=_1415.slice(i);arr=_1418;len=arr.length;if(len){_141a={};array.forEach(arr,function(r){_141a[r]=true;});_1417[arr[0]]=_1416-len;for(k=0,i=arr[k]+1,_141b=i-1;i<_1416;++i){if(!_141a[i]){_1417[i]=_141b;++_141b;}else{++k;_1417[i]=_1416-len+k;}}}arr=_1419;len=arr.length;if(len){_141a={};array.forEach(arr,function(r){_141a[r]=true;});_1417[arr[len-1]]=_1416+len-1;for(k=len-1,i=arr[k]-1,_141b=i+1;i>=_1416;--i){if(!_141a[i]){_1417[i]=_141b;--_141b;}else{--k;_1417[i]=_1416+k;}}}var _141c=lang.clone(_1417);g.layer("rowmap").setMapping(_1417);g.forEachLayer(function(layer){if(layer.name()!="rowmap"){layer.invalidate();return true;}else{return false;}},false);g.selection.selected=[];g._noInternalMapping=true;g._refresh();setTimeout(function(){_1404.publish("dojox/grid/rearrange/move/"+g.id,["row",_141c,_1415]);g._noInternalMapping=false;},0);},moveCells:function(_141d,_141e){var g=this.grid,s=g.store;if(s.getFeatures()["dojo.data.api.Write"]){if(_141d.min.row==_141e.min.row&&_141d.min.col==_141e.min.col){return;}var cells=g.layout.cells,cnt=_141d.max.row-_141d.min.row+1,r,c,tr,tc,_141f=[],_1420=[];for(r=_141d.min.row,tr=_141e.min.row;r<=_141d.max.row;++r,++tr){for(c=_141d.min.col,tc=_141e.min.col;c<=_141d.max.col;++c,++tc){while(cells[c]&&cells[c].hidden){++c;}while(cells[tc]&&cells[tc].hidden){++tc;}_141f.push({"r":r,"c":c});_1420.push({"r":tr,"c":tc,"v":cells[c].get(r,g._by_idx[r].item)});}}if(this._hasIdentity(_141f.concat(_1420))){console.warn("Can not write to identity!");return;}array.forEach(_141f,function(point){s.setValue(g._by_idx[point.r].item,cells[point.c].field,"");});array.forEach(_1420,function(point){s.setValue(g._by_idx[point.r].item,cells[point.c].field,point.v);});s.save({onComplete:function(){_1404.publish("dojox/grid/rearrange/move/"+g.id,["cell",{"from":_141d,"to":_141e}]);}});}},copyCells:function(_1421,_1422){var g=this.grid,s=g.store;if(s.getFeatures()["dojo.data.api.Write"]){if(_1421.min.row==_1422.min.row&&_1421.min.col==_1422.min.col){return;}var cells=g.layout.cells,cnt=_1421.max.row-_1421.min.row+1,r,c,tr,tc,_1423=[];for(r=_1421.min.row,tr=_1422.min.row;r<=_1421.max.row;++r,++tr){for(c=_1421.min.col,tc=_1422.min.col;c<=_1421.max.col;++c,++tc){while(cells[c]&&cells[c].hidden){++c;}while(cells[tc]&&cells[tc].hidden){++tc;}_1423.push({"r":tr,"c":tc,"v":cells[c].get(r,g._by_idx[r].item)});}}if(this._hasIdentity(_1423)){console.warn("Can not write to identity!");return;}array.forEach(_1423,function(point){s.setValue(g._by_idx[point.r].item,cells[point.c].field,point.v);});s.save({onComplete:function(){setTimeout(function(){_1404.publish("dojox/grid/rearrange/copy/"+g.id,["cell",{"from":_1421,"to":_1422}]);},0);}});}},changeCells:function(_1424,_1425,_1426){var g=this.grid,s=g.store;if(s.getFeatures()["dojo.data.api.Write"]){var srcg=_1424,cells=g.layout.cells,_1427=srcg.layout.cells,cnt=_1425.max.row-_1425.min.row+1,r,c,tr,tc,_1428=[];for(r=_1425.min.row,tr=_1426.min.row;r<=_1425.max.row;++r,++tr){for(c=_1425.min.col,tc=_1426.min.col;c<=_1425.max.col;++c,++tc){while(_1427[c]&&_1427[c].hidden){++c;}while(cells[tc]&&cells[tc].hidden){++tc;}_1428.push({"r":tr,"c":tc,"v":_1427[c].get(r,srcg._by_idx[r].item)});}}if(this._hasIdentity(_1428)){console.warn("Can not write to identity!");return;}array.forEach(_1428,function(point){s.setValue(g._by_idx[point.r].item,cells[point.c].field,point.v);});s.save({onComplete:function(){_1404.publish("dojox/grid/rearrange/change/"+g.id,["cell",_1426]);}});}},clearCells:function(_1429){var g=this.grid,s=g.store;if(s.getFeatures()["dojo.data.api.Write"]){var cells=g.layout.cells,cnt=_1429.max.row-_1429.min.row+1,r,c,_142a=[];for(r=_1429.min.row;r<=_1429.max.row;++r){for(c=_1429.min.col;c<=_1429.max.col;++c){while(cells[c]&&cells[c].hidden){++c;}_142a.push({"r":r,"c":c});}}if(this._hasIdentity(_142a)){console.warn("Can not write to identity!");return;}array.forEach(_142a,function(point){s.setValue(g._by_idx[point.r].item,cells[point.c].field,"");});s.save({onComplete:function(){_1404.publish("dojox/grid/rearrange/change/"+g.id,["cell",_1429]);}});}},insertRows:function(_142b,_142c,_142d){try{var g=this.grid,s=g.store,_142e=g.rowCount,_142f={},obj={idx:0},_1430=[],i,_1431=_142d<0,_1432=this,len=_142c.length;if(_1431){_142d=0;}else{for(i=_142d;i<g.rowCount;++i){_142f[i]=i+len;}}if(s.getFeatures()["dojo.data.api.Write"]){if(_142b){var srcg=_142b,srcs=srcg.store,_1433,attrs;if(!_1431){for(i=0;!_1433;++i){_1433=g._by_idx[i];}attrs=s.getAttributes(_1433.item);}else{attrs=array.filter(array.map(g.layout.cells,function(cell){return cell.field;}),function(field){return field;});}var _1434=[];array.forEach(_142c,function(_1435,i){var item={};var _1436=srcg._by_idx[_1435];if(_1436){array.forEach(attrs,function(attr){item[attr]=srcs.getValue(_1436.item,attr);});item=_1432.args.setIdentifierForNewItem(item,s,_142e+obj.idx)||item;try{s.newItem(item);_1430.push(_142d+i);_142f[_142e+obj.idx]=_142d+i;++obj.idx;}catch(e){}}else{_1434.push(_1435);}});}else{if(_142c.length&&lang.isObject(_142c[0])){array.forEach(_142c,function(_1437,i){var item=_1432.args.setIdentifierForNewItem(_1437,s,_142e+obj.idx)||_1437;try{s.newItem(item);_1430.push(_142d+i);_142f[_142e+obj.idx]=_142d+i;++obj.idx;}catch(e){}});}else{return;}}g.layer("rowmap").setMapping(_142f);s.save({onComplete:function(){g._refresh();setTimeout(function(){_1404.publish("dojox/grid/rearrange/insert/"+g.id,["row",_1430]);},0);}});}}catch(e){}},removeRows:function(_1438){var g=this.grid;var s=g.store;try{array.forEach(array.map(_1438,function(_1439){return g._by_idx[_1439];}),function(row){if(row){s.deleteItem(row.item);}});s.save({onComplete:function(){_1404.publish("dojox/grid/rearrange/remove/"+g.id,["row",_1438]);}});}catch(e){}},_getPageInfo:function(){var _143a=this.grid.scroller,_143b=_143a.page,_143c=_143a.page,_143d=_143a.firstVisibleRow,_143e=_143a.lastVisibleRow,_143f=_143a.rowsPerPage,_1440=_143a.pageNodes[0],_1441,_1442,_1443,_1444=[];array.forEach(_1440,function(page,_1445){if(!page){return;}_1443=false;_1441=_1445*_143f;_1442=(_1445+1)*_143f-1;if(_143d>=_1441&&_143d<=_1442){_143b=_1445;_1443=true;}if(_143e>=_1441&&_143e<=_1442){_143c=_1445;_1443=true;}if(!_1443&&(_1441>_143e||_1442<_143d)){_1444.push(_1445);}});return {topPage:_143b,bottomPage:_143c,invalidPages:_1444};}});_1405.registerPlugin(_1408);return _1408;});},"dojox/grid/enhanced/plugins/_RowMapLayer":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","./_StoreLayer"],function(array,_1446,_1447,lang,_1448){var _1449=function(a){a.sort(function(v1,v2){return v1-v2;});var arr=[[a[0]]];for(var i=1,j=0;i<a.length;++i){if(a[i]==a[i-1]+1){arr[j].push(a[i]);}else{arr[++j]=[a[i]];}}return arr;},_144a=function(scope,func){return func?lang.hitch(scope||_1447.global,func):function(){};};return _1446("dojox.grid.enhanced.plugins._RowMapLayer",_1448._StoreLayer,{tags:["reorder"],constructor:function(grid){this._map={};this._revMap={};this.grid=grid;this._oldOnDelete=grid._onDelete;var _144b=this;grid._onDelete=function(item){_144b._onDelete(item);_144b._oldOnDelete.call(grid,item);};this._oldSort=grid.sort;grid.sort=function(){_144b.clearMapping();_144b._oldSort.apply(grid,arguments);};},uninitialize:function(){this.grid._onDelete=this._oldOnDelete;this.grid.sort=this._oldSort;},setMapping:function(_144c){this._store.forEachLayer(function(layer){if(layer.name()==="rowmap"){return false;}else{if(layer.onRowMappingChange){layer.onRowMappingChange(_144c);}}return true;},false);var from,to,_144d,_144e={};for(from in _144c){from=parseInt(from,10);to=_144c[from];if(typeof to=="number"){if(from in this._revMap){_144d=this._revMap[from];delete this._revMap[from];}else{_144d=from;}if(_144d==to){delete this._map[_144d];_144e[to]="eq";}else{this._map[_144d]=to;_144e[to]=_144d;}}}for(to in _144e){if(_144e[to]==="eq"){delete this._revMap[parseInt(to,10)];}else{this._revMap[parseInt(to,10)]=_144e[to];}}},clearMapping:function(){this._map={};this._revMap={};},_onDelete:function(item){var idx=this.grid._getItemIndex(item,true);if(idx in this._revMap){var _144f=[],r,i,_1450=this._revMap[idx];delete this._map[_1450];delete this._revMap[idx];for(r in this._revMap){r=parseInt(r,10);if(this._revMap[r]>_1450){--this._revMap[r];}}for(r in this._revMap){r=parseInt(r,10);if(r>idx){_144f.push(r);}}_144f.sort(function(a,b){return b-a;});for(i=_144f.length-1;i>=0;--i){r=_144f[i];this._revMap[r-1]=this._revMap[r];delete this._revMap[r];}this._map={};for(r in this._revMap){this._map[this._revMap[r]]=r;}}},_fetch:function(_1451){var _1452=0,r;var start=_1451.start||0;for(r in this._revMap){r=parseInt(r,10);if(r>=start){++_1452;}}if(_1452>0){var rows=[],i,map={},count=_1451.count>0?_1451.count:-1;if(count>0){for(i=0;i<count;++i){r=start+i;r=r in this._revMap?this._revMap[r]:r;map[r]=i;rows.push(r);}}else{for(i=0;;++i){r=start+i;if(r in this._revMap){--_1452;r=this._revMap[r];}map[r]=i;rows.push(r);if(_1452<=0){break;}}}this._subFetch(_1451,this._getRowArrays(rows),0,[],map,_1451.onComplete,start,count);return _1451;}else{return lang.hitch(this._store,this._originFetch)(_1451);}},_getRowArrays:function(rows){return _1449(rows);},_subFetch:function(_1453,_1454,index,_1455,map,_1456,start,count){var arr=_1454[index],_1457=this;var _1458=_1453.start=arr[0];_1453.count=arr[arr.length-1]-arr[0]+1;_1453.onComplete=function(items){array.forEach(items,function(item,i){var r=_1458+i;if(r in map){_1455[map[r]]=item;}});if(++index==_1454.length){if(count>0){_1453.start=start;_1453.count=count;_1453.onComplete=_1456;_144a(_1453.scope,_1456)(_1455,_1453);}else{_1453.start=_1453.start+items.length;delete _1453.count;_1453.onComplete=function(items){_1455=_1455.concat(items);_1453.start=start;_1453.onComplete=_1456;_144a(_1453.scope,_1456)(_1455,_1453);};_1457.originFetch(_1453);}}else{_1457._subFetch(_1453,_1454,index,_1455,map,_1456,start,count);}};_1457.originFetch(_1453);}});});},"dojox/grid/enhanced/plugins/Search":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/data/util/filter","../../EnhancedGrid","../_Plugin"],function(dojo,lang,_1459,array,_145a,_145b,_145c){var _145d=_1459("dojox.grid.enhanced.plugins.Search",_145c,{name:"search",constructor:function(grid,args){this.grid=grid;args=(args&&lang.isObject(args))?args:{};this._cacheSize=args.cacheSize||-1;grid.searchRow=lang.hitch(this,"searchRow");},searchRow:function(_145e,_145f){if(!lang.isFunction(_145f)){return;}if(lang.isString(_145e)){_145e=_145a.patternToRegExp(_145e);}var _1460=false;if(_145e instanceof RegExp){_1460=true;}else{if(lang.isObject(_145e)){var _1461=true;for(var field in _145e){if(lang.isString(_145e[field])){_145e[field]=_145a.patternToRegExp(_145e[field]);}_1461=false;}if(_1461){return;}}else{return;}}this._search(_145e,0,_145f,_1460);},_search:function(_1462,start,_1463,_1464){var _1465=this,cnt=this._cacheSize,args={start:start,query:this.grid.query,sort:this.grid.getSortProps(),queryOptions:this.grid.queryOptions,onBegin:function(size){_1465._storeSize=size;},onComplete:function(items){if(!array.some(items,function(item,i){if(_1465._checkRow(item,_1462,_1464)){_1463(start+i,item);return true;}return false;})){if(cnt>0&&start+cnt<_1465._storeSize){_1465._search(_1462,start+cnt,_1463,_1464);}else{_1463(-1,null);}}}};if(cnt>0){args.count=cnt;}this.grid._storeLayerFetch(args);},_checkRow:function(item,_1466,_1467){var g=this.grid,s=g.store,i,field,cells=array.filter(g.layout.cells,function(cell){return !cell.hidden;});if(_1467){return array.some(cells,function(cell){try{if(cell.field){return String(s.getValue(item,cell.field)).search(_1466)>=0;}}catch(e){}return false;});}else{for(field in _1466){if(_1466[field] instanceof RegExp){for(i=cells.length-1;i>=0;--i){if(cells[i].field==field){try{if(String(s.getValue(item,field)).search(_1466[field])<0){return false;}break;}catch(e){return false;}}}if(i<0){return false;}}}return true;}}});_145b.registerPlugin(_145d);return _145d;});},"dojox/grid/enhanced/plugins/CellMerge":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/_base/html","../_Plugin","../../EnhancedGrid"],function(_1468,array,lang,html,_1469,_146a){var _146b=_1468("dojox.grid.enhanced.plugins.CellMerge",_1469,{name:"cellMerge",constructor:function(grid,args){this.grid=grid;this._records=[];this._merged={};if(args&&lang.isObject(args)){this._setupConfig(args.mergedCells);}this._initEvents();this._mixinGrid();},mergeCells:function(_146c,_146d,_146e,_146f){var item=this._createRecord({"row":_146c,"start":_146d,"end":_146e,"major":_146f});if(item){this._updateRows(item);}return item;},unmergeCells:function(_1470){var idx;if(_1470&&(idx=array.indexOf(this._records,_1470))>=0){this._records.splice(idx,1);this._updateRows(_1470);}},getMergedCells:function(){var res=[];for(var i in this._merged){res=res.concat(this._merged[i]);}return res;},getMergedCellsByRow:function(_1471){return this._merged[_1471]||[];},_setupConfig:function(_1472){array.forEach(_1472,this._createRecord,this);},_initEvents:function(){array.forEach(this.grid.views.views,function(view){this.connect(view,"onAfterRow",lang.hitch(this,"_onAfterRow",view.index));},this);},_mixinGrid:function(){var g=this.grid;g.mergeCells=lang.hitch(this,"mergeCells");g.unmergeCells=lang.hitch(this,"unmergeCells");g.getMergedCells=lang.hitch(this,"getMergedCells");g.getMergedCellsByRow=lang.hitch(this,"getMergedCellsByRow");},_getWidth:function(_1473){var node=this.grid.layout.cells[_1473].getHeaderNode();return html.position(node).w;},_onAfterRow:function(_1474,_1475,_1476){try{if(_1475<0){return;}var _1477=[],i,j,len=this._records.length,cells=this.grid.layout.cells;for(i=0;i<len;++i){var item=this._records[i];var _1478=this.grid._by_idx[_1475];if(item.view==_1474&&item.row(_1475,_1478&&_1478.item,this.grid.store)){var res={record:item,hiddenCells:[],totalWidth:0,majorNode:cells[item.major].getNode(_1475),majorHeaderNode:cells[item.major].getHeaderNode()};for(j=item.start;j<=item.end;++j){var w=this._getWidth(j,_1475);res.totalWidth+=w;if(j!=item.major){res.hiddenCells.push(cells[j].getNode(_1475));}}if(_1476.length!=1||res.totalWidth>0){for(j=_1477.length-1;j>=0;--j){var r=_1477[j].record;if((r.start>=item.start&&r.start<=item.end)||(r.end>=item.start&&r.end<=item.end)){_1477.splice(j,1);}}_1477.push(res);}}}this._merged[_1475]=[];array.forEach(_1477,function(res){array.forEach(res.hiddenCells,function(node){html.style(node,"display","none");});var pbm=html.marginBox(res.majorHeaderNode).w-html.contentBox(res.majorHeaderNode).w;var tw=res.totalWidth;if(!html.isWebKit){tw-=pbm;}html.style(res.majorNode,"width",tw+"px");res.majorNode.setAttribute("colspan",res.hiddenCells.length+1);this._merged[_1475].push({"row":_1475,"start":res.record.start,"end":res.record.end,"major":res.record.major,"handle":res.record});},this);}catch(e){console.warn("CellMerge._onAfterRow() error: ",_1475,e);}},_createRecord:function(item){if(this._isValid(item)){item={"row":item.row,"start":item.start,"end":item.end,"major":item.major};var cells=this.grid.layout.cells;item.view=cells[item.start].view.index;item.major=typeof item.major=="number"&&!isNaN(item.major)?item.major:item.start;if(typeof item.row=="number"){var r=item.row;item.row=function(_1479){return _1479===r;};}else{if(typeof item.row=="string"){var id=item.row;item.row=function(_147a,_147b,store){try{if(store&&_147b&&store.getFeatures()["dojo.data.api.Identity"]){return store.getIdentity(_147b)==id;}}catch(e){console.error(e);}return false;};}}if(lang.isFunction(item.row)){this._records.push(item);return item;}}return null;},_isValid:function(item){var cells=this.grid.layout.cells,_147c=cells.length;return (lang.isObject(item)&&("row" in item)&&("start" in item)&&("end" in item)&&item.start>=0&&item.start<_147c&&item.end>item.start&&item.end<_147c&&cells[item.start].view.index==cells[item.end].view.index&&cells[item.start].subrow==cells[item.end].subrow&&!(typeof item.major=="number"&&(item.major<item.start||item.major>item.end)));},_updateRows:function(item){var min=null;for(var i=0,count=this.grid.rowCount;i<count;++i){var _147d=this.grid._by_idx[i];if(_147d&&item.row(i,_147d&&_147d.item,this.grid.store)){this.grid.views.updateRow(i);if(min===null){min=i;}}}if(min>=0){this.grid.scroller.rowHeightChanged(min);}}});_146a.registerPlugin(_146b);return _146b;});},"dojox/grid/enhanced/plugins/Pagination":function(){define(["dojo/_base/kernel","dojo/_base/declare","dojo/_base/array","dojo/_base/connect","dojo/_base/lang","dojo/_base/html","dojo/_base/event","dojo/query","dojo/string","dojo/keys","dojo/text!../templates/Pagination.html","./Dialog","./_StoreLayer","../_Plugin","../../EnhancedGrid","dijit/form/Button","dijit/form/NumberTextBox","dijit/focus","dijit/_Widget","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin","dojox/html/metrics","dojo/i18n!../nls/Pagination"],function(_147e,_147f,array,_1480,lang,html,event,query,_1481,keys,_1482,_1483,_1484,_1485,_1486,_1487,_1488,_1489,_148a,_148b,_148c,_148d,nls){var _148e=_147f("dojox.grid.enhanced.plugins.pagination._GotoPagePane",[_148a,_148b,_148c],{templateString:"<div>"+"<div class='dojoxGridDialogMargin' dojoAttachPoint='_mainMsgNode'></div>"+"<div class='dojoxGridDialogMargin'>"+"<input dojoType='dijit.form.NumberTextBox' style='width: 50px;' dojoAttachPoint='_pageInputBox' dojoAttachEvent='onKeyUp: _onKey'></input>"+"<label dojoAttachPoint='_pageLabelNode'></label>"+"</div>"+"<div class='dojoxGridDialogButton'>"+"<button dojoType='dijit.form.Button' dojoAttachPoint='_confirmBtn' dojoAttachEvent='onClick: _onConfirm'></button>"+"<button dojoType='dijit.form.Button' dojoAttachPoint='_cancelBtn' dojoAttachEvent='onClick: _onCancel'></button>"+"</div>"+"</div>",widgetsInTemplate:true,dlg:null,postMixInProperties:function(){this.plugin=this.dlg.plugin;},postCreate:function(){this.inherited(arguments);this._mainMsgNode.innerHTML=this.plugin._nls[12];this._confirmBtn.set("label",this.plugin._nls[14]);this._confirmBtn.set("disabled",true);this._cancelBtn.set("label",this.plugin._nls[15]);},_onConfirm:function(evt){if(this._pageInputBox.isValid()&&this._pageInputBox.getDisplayedValue()!==""){this.plugin.currentPage(this._pageInputBox.parse(this._pageInputBox.getDisplayedValue()));this.dlg._gotoPageDialog.hide();this._pageInputBox.reset();}_148f(evt);},_onCancel:function(evt){this._pageInputBox.reset();this.dlg._gotoPageDialog.hide();_148f(evt);},_onKey:function(evt){this._confirmBtn.set("disabled",!this._pageInputBox.isValid()||this._pageInputBox.getDisplayedValue()=="");if(!evt.altKey&&!evt.metaKey&&evt.keyCode===keys.ENTER){this._onConfirm(evt);}}});var _1490=_147f("dojox.grid.enhanced.plugins.pagination._GotoPageDialog",null,{pageCount:0,dlgPane:null,constructor:function(_1491){this.plugin=_1491;this.dlgPane=new _148e({"dlg":this});this.dlgPane.startup();this._gotoPageDialog=new _1483({"refNode":_1491.grid.domNode,"title":this.plugin._nls[11],"content":this.dlgPane});this._gotoPageDialog.startup();},_updatePageCount:function(){this.pageCount=this.plugin.getTotalPageNum();this.dlgPane._pageInputBox.constraints={fractional:false,min:1,max:this.pageCount};this.dlgPane._pageLabelNode.innerHTML=_1481.substitute(this.plugin._nls[13],[this.pageCount]);},showDialog:function(){this._updatePageCount();this._gotoPageDialog.show();},destroy:function(){this._gotoPageDialog.destroy();}});var _1492=_147f("dojox.grid.enhanced.plugins._ForcedPageStoreLayer",_1484._StoreLayer,{tags:["presentation"],constructor:function(_1493){this._plugin=_1493;},_fetch:function(_1494){var _1495=this,_1496=_1495._plugin,grid=_1496.grid,scope=_1494.scope||_147e.global,_1497=_1494.onBegin;_1494.start=(_1496._currentPage-1)*_1496._currentPageSize+_1494.start;_1495.startIdx=_1494.start;_1495.endIdx=_1494.start+_1496._currentPageSize-1;var p=_1496._paginator;if(!_1496._showAll){_1496._showAll=!p.sizeSwitch&&!p.pageStepper&&!p.gotoButton;}if(_1497&&_1496._showAll){_1494.onBegin=function(size,req){_1496._maxSize=_1496._currentPageSize=size;_1495.startIdx=0;_1495.endIdx=size-1;_1496._paginator._update();req.onBegin=_1497;req.onBegin.call(scope,size,req);};}else{if(_1497){_1494.onBegin=function(size,req){req.start=0;req.count=_1496._currentPageSize;_1496._maxSize=size;_1495.endIdx=_1495.endIdx>=size?(size-1):_1495.endIdx;if(_1495.startIdx>size&&size!==0){grid._pending_requests[req.start]=false;_1496.firstPage();}_1496._paginator._update();req.onBegin=_1497;req.onBegin.call(scope,Math.min(_1496._currentPageSize,(size-_1495.startIdx)),req);};}}return lang.hitch(this._store,this._originFetch)(_1494);}});var _148f=function(evt){try{if(evt){event.stop(evt);}}catch(e){}};var _1498=_147f("dojox.grid.enhanced.plugins.pagination._Focus",null,{_focusedNode:null,_isFocused:false,constructor:function(_1499){this._pager=_1499;var _149a=_1499.plugin.grid.focus;_1499.plugin.connect(_1499,"onSwitchPageSize",lang.hitch(this,"_onActive"));_1499.plugin.connect(_1499,"onPageStep",lang.hitch(this,"_onActive"));_1499.plugin.connect(_1499,"onShowGotoPageDialog",lang.hitch(this,"_onActive"));_1499.plugin.connect(_1499,"_update",lang.hitch(this,"_moveFocus"));},_onFocus:function(evt,step){var node,nodes;if(!this._isFocused){node=this._focusedNode||query("[tabindex]",this._pager.domNode)[0];}else{if(step&&this._focusedNode){var dir=step>0?-1:1,_149b=parseInt(this._focusedNode.getAttribute("tabindex"),10)+dir;while(_149b>=-3&&_149b<0){node=query("[tabindex="+_149b+"]",this._pager.domNode)[0];if(node){break;}else{_149b+=dir;}}}}return this._focus(node,evt);},_onBlur:function(evt,step){if(!step||!this._focusedNode){this._isFocused=false;if(this._focusedNode&&html.hasClass(this._focusedNode,"dojoxGridButtonFocus")){html.removeClass(this._focusedNode,"dojoxGridButtonFocus");}return true;}var node,dir=step>0?-1:1,_149c=parseInt(this._focusedNode.getAttribute("tabindex"),10)+dir;while(_149c>=-3&&_149c<0){node=query("[tabindex="+_149c+"]",this._pager.domNode)[0];if(node){break;}else{_149c+=dir;}}if(!node){this._isFocused=false;if(html.hasClass(this._focusedNode,"dojoxGridButtonFocus")){html.removeClass(this._focusedNode,"dojoxGridButtonFocus");}}return node?false:true;},_onMove:function(_149d,_149e,evt){if(this._focusedNode){var _149f=this._focusedNode.getAttribute("tabindex"),delta=_149e==1?"nextSibling":"previousSibling",node=this._focusedNode[delta];while(node){if(node.getAttribute("tabindex")==_149f){this._focus(node);break;}node=node[delta];}}},_focus:function(node,evt){if(node){this._isFocused=true;if(_147e.isIE&&this._focusedNode){html.removeClass(this._focusedNode,"dojoxGridButtonFocus");}this._focusedNode=node;node.focus();if(_147e.isIE){html.addClass(node,"dojoxGridButtonFocus");}_148f(evt);return true;}return false;},_onActive:function(e){this._focusedNode=e.target;if(!this._isFocused){this._pager.plugin.grid.focus.focusArea("pagination"+this._pager.position);}},_moveFocus:function(){if(this._focusedNode&&!this._focusedNode.getAttribute("tabindex")){var next=this._focusedNode.nextSibling;while(next){if(next.getAttribute("tabindex")){this._focus(next);return;}next=next.nextSibling;}var prev=this._focusedNode.previousSibling;while(prev){if(prev.getAttribute("tabindex")){this._focus(prev);return;}prev=prev.previousSibling;}this._focusedNode=null;this._onBlur();}else{if(_147e.isIE&&this._focusedNode){html.addClass(this._focusedNode,"dojoxGridButtonFocus");}}}});var _14a0=_147f("dojox.grid.enhanced.plugins._Paginator",[_148a,_148b],{templateString:_1482,constructor:function(_14a1){lang.mixin(this,_14a1);this.grid=this.plugin.grid;},postCreate:function(){this.inherited(arguments);var _14a2=this,g=this.grid;this.plugin.connect(g,"_resize",lang.hitch(this,"_resetGridHeight"));this._originalResize=g.resize;g.resize=function(_14a3,_14a4){_14a2._changeSize=_14a3;_14a2._resultSize=_14a4;_14a2._originalResize.apply(g,arguments);};this.focus=_1498(this);this._placeSelf();},destroy:function(){this.inherited(arguments);this.grid.focus.removeArea("pagination"+this.position);if(this._gotoPageDialog){this._gotoPageDialog.destroy();}this.grid.resize=this._originalResize;},onSwitchPageSize:function(evt){},onPageStep:function(evt){},onShowGotoPageDialog:function(evt){},_update:function(){this._updateDescription();this._updatePageStepper();this._updateSizeSwitch();this._updateGotoButton();},_registerFocus:function(isTop){var _14a5=this.grid.focus,name="pagination"+this.position,f=this.focus;_14a5.addArea({name:name,onFocus:lang.hitch(this.focus,"_onFocus"),onBlur:lang.hitch(this.focus,"_onBlur"),onMove:lang.hitch(this.focus,"_onMove")});_14a5.placeArea(name,isTop?"before":"after",isTop?"header":"content");},_placeSelf:function(){var g=this.grid,isTop=this.position=="top";this.placeAt(isTop?g.viewsHeaderNode:g.viewsNode,isTop?"before":"after");this._registerFocus(isTop);},_resetGridHeight:function(_14a6,_14a7){var g=this.grid;_14a6=_14a6||this._changeSize;_14a7=_14a7||this._resultSize;delete this._changeSize;delete this._resultSize;if(g._autoHeight){return;}var _14a8=g._getPadBorder().h;if(!this.plugin.gh){this.plugin.gh=(g.domNode.clientHeight||html.style(g.domNode,"height"))+2*_14a8;}if(_14a7){_14a6=_14a7;}if(_14a6){this.plugin.gh=html.contentBox(g.domNode).h+2*_14a8;}var gh=this.plugin.gh,hh=g._getHeaderHeight(),ph=html.marginBox(this.domNode).h;if(typeof g.autoHeight==="number"){var cgh=gh+ph-_14a8;html.style(g.domNode,"height",cgh+"px");html.style(g.viewsNode,"height",(cgh-ph-hh)+"px");this._styleMsgNode(hh,html.marginBox(g.viewsNode).w,cgh-ph-hh);}else{var h=gh-ph-hh-_14a8;html.style(g.viewsNode,"height",h+"px");var _14a9=array.some(g.views.views,function(v){return v.hasHScrollbar();});array.forEach(g.viewsNode.childNodes,function(c){html.style(c,"height",h+"px");});array.forEach(g.views.views,function(v){if(v.scrollboxNode){if(!v.hasHScrollbar()&&_14a9){html.style(v.scrollboxNode,"height",(h-_148d.getScrollbar().h)+"px");}else{html.style(v.scrollboxNode,"height",h+"px");}}});this._styleMsgNode(hh,html.marginBox(g.viewsNode).w,h);}},_styleMsgNode:function(top,width,_14aa){var _14ab=this.grid.messagesNode;html.style(_14ab,{"position":"absolute","top":top+"px","width":width+"px","height":_14aa+"px","z-Index":"100"});},_updateDescription:function(){var s=this.plugin.forcePageStoreLayer,_14ac=this.plugin._maxSize,nls=this.plugin._nls,_14ad=function(){return _14ac<=0||_14ac==1?nls[5]:nls[4];};if(this.description&&this.descriptionDiv){this.descriptionDiv.innerHTML=_14ac>0?_1481.substitute(nls[0],[_14ad(),_14ac,s.startIdx+1,s.endIdx+1]):"0 "+_14ad();}},_updateSizeSwitch:function(){html.style(this.sizeSwitchTd,"display",this.sizeSwitch?"":"none");if(!this.sizeSwitch){return;}if(this.sizeSwitchTd.childNodes.length<1){this._createSizeSwitchNodes();}this._updateSwitchNodesStyle();},_createSizeSwitchNodes:function(){var node=null,nls=this.plugin._nls,_1480=lang.hitch(this.plugin,"connect");array.forEach(this.pageSizes,function(size){var _14ae=isFinite(size)?_1481.substitute(nls[2],[size]):nls[1],value=isFinite(size)?size:nls[16];node=html.create("span",{innerHTML:value,title:_14ae,value:size,tabindex:"-1"},this.sizeSwitchTd,"last");node.setAttribute("aria-label",_14ae);_1480(node,"onclick",lang.hitch(this,"_onSwitchPageSize"));_1480(node,"onkeydown",lang.hitch(this,"_onSwitchPageSize"));_1480(node,"onmouseover",function(e){html.addClass(e.target,"dojoxGridPageTextHover");});_1480(node,"onmouseout",function(e){html.removeClass(e.target,"dojoxGridPageTextHover");});node=html.create("span",{innerHTML:"|"},this.sizeSwitchTd,"last");html.addClass(node,"dojoxGridSeparator");},this);html.destroy(node);},_updateSwitchNodesStyle:function(){var size=null;var _14af=function(node,_14b0){if(_14b0){html.addClass(node,"dojoxGridActivedSwitch");html.removeAttr(node,"tabindex");}else{html.addClass(node,"dojoxGridInactiveSwitch");node.setAttribute("tabindex","-1");}};array.forEach(this.sizeSwitchTd.childNodes,function(node){if(node.value){html.removeClass(node);size=node.value;if(this.plugin._showAll){_14af(node,isNaN(parseInt(size,10)));}else{_14af(node,this.plugin._currentPageSize==size);}}},this);},_updatePageStepper:function(){html.style(this.pageStepperTd,"display",this.pageStepper?"":"none");if(!this.pageStepper){return;}if(this.pageStepperDiv.childNodes.length<1){this._createPageStepNodes();this._createWardBtns();}else{this._resetPageStepNodes();}this._updatePageStepNodesStyle();},_createPageStepNodes:function(){var _14b1=this._getStartPage(),_14b2=this._getStepPageSize(),label="",node=null,i=_14b1,_1480=lang.hitch(this.plugin,"connect");for(;i<_14b1+this.maxPageStep+1;i++){label=_1481.substitute(this.plugin._nls[3],[i]);node=html.create("div",{innerHTML:i,value:i,title:label},this.pageStepperDiv,"last");node.setAttribute("aria-label",label);_1480(node,"onclick",lang.hitch(this,"_onPageStep"));_1480(node,"onkeydown",lang.hitch(this,"_onPageStep"));_1480(node,"onmouseover",function(e){html.addClass(e.target,"dojoxGridPageTextHover");});_1480(node,"onmouseout",function(e){html.removeClass(e.target,"dojoxGridPageTextHover");});html.style(node,"display",i<_14b1+_14b2?"":"none");}},_createWardBtns:function(){var _14b3=this,nls=this.plugin._nls;var _14b4={prevPage:"&#60;",firstPage:"&#171;",nextPage:"&#62;",lastPage:"&#187;"};var _14b5=function(value,label,_14b6){var node=html.create("div",{value:value,title:label,tabindex:"-2"},_14b3.pageStepperDiv,_14b6);_14b3.plugin.connect(node,"onclick",lang.hitch(_14b3,"_onPageStep"));_14b3.plugin.connect(node,"onkeydown",lang.hitch(_14b3,"_onPageStep"));node.setAttribute("aria-label",label);var _14b7=html.create("span",{value:value,title:label,innerHTML:_14b4[value]},node,_14b6);html.addClass(_14b7,"dojoxGridWardButtonInner");};_14b5("prevPage",nls[6],"first");_14b5("firstPage",nls[7],"first");_14b5("nextPage",nls[8],"last");_14b5("lastPage",nls[9],"last");},_resetPageStepNodes:function(){var _14b8=this._getStartPage(),_14b9=this._getStepPageSize(),_14ba=this.pageStepperDiv.childNodes,node=null,i=_14b8,j=2,tip;for(;j<_14ba.length-2;j++,i++){node=_14ba[j];if(i<_14b8+_14b9){tip=_1481.substitute(this.plugin._nls[3],[i]);html.attr(node,{"innerHTML":i,"title":tip,"value":i});html.style(node,"display","");node.setAttribute("aria-label",tip);}else{html.style(node,"display","none");}}},_updatePageStepNodesStyle:function(){var value=null,_14bb=this.plugin.currentPage(),_14bc=this.plugin.getTotalPageNum();var _14bd=function(node,_14be,_14bf){var value=node.value,_14c0=_14be?"dojoxGrid"+value+"Btn":"dojoxGridInactived",_14c1=_14be?"dojoxGrid"+value+"BtnDisable":"dojoxGridActived";if(_14bf){html.addClass(node,_14c1);html.removeAttr(node,"tabindex");}else{html.addClass(node,_14c0);node.setAttribute("tabindex","-2");}};array.forEach(this.pageStepperDiv.childNodes,function(node){html.removeClass(node);if(isNaN(parseInt(node.value,10))){html.addClass(node,"dojoxGridWardButton");var _14c2=node.value=="prevPage"||node.value=="firstPage"?1:_14bc;_14bd(node,true,(_14bb===_14c2));}else{value=parseInt(node.value,10);_14bd(node,false,(value===_14bb||html.style(node,"display")==="none"));}},this);},_showGotoButton:function(flag){this.gotoButton=flag;this._updateGotoButton();},_updateGotoButton:function(){if(!this.gotoButton){if(this._gotoPageDialog){this._gotoPageDialog.destroy();}html.removeAttr(this.gotoPageDiv,"tabindex");html.style(this.gotoPageTd,"display","none");return;}if(html.style(this.gotoPageTd,"display")=="none"){html.style(this.gotoPageTd,"display","");}this.gotoPageDiv.setAttribute("title",this.plugin._nls[10]);html.toggleClass(this.gotoPageDiv,"dojoxGridPaginatorGotoDivDisabled",this.plugin.getTotalPageNum()<=1);if(this.plugin.getTotalPageNum()<=1){html.removeAttr(this.gotoPageDiv,"tabindex");}else{this.gotoPageDiv.setAttribute("tabindex","-3");}},_openGotopageDialog:function(e){if(this.plugin.getTotalPageNum()<=1){return;}if(e.type==="keydown"&&e.keyCode!==keys.ENTER&&e.keyCode!==keys.SPACE){return;}if(!this._gotoPageDialog){this._gotoPageDialog=new _1490(this.plugin);}this._gotoPageDialog.showDialog();this.onShowGotoPageDialog(e);},_onSwitchPageSize:function(e){if(e.type==="keydown"&&e.keyCode!==keys.ENTER&&e.keyCode!==keys.SPACE){return;}this.onSwitchPageSize(e);this.plugin.currentPageSize(e.target.value);},_onPageStep:function(e){if(e.type==="keydown"&&e.keyCode!==keys.ENTER&&e.keyCode!==keys.SPACE){return;}var p=this.plugin,value=e.target.value;this.onPageStep(e);if(!isNaN(parseInt(value,10))){p.currentPage(parseInt(value,10));}else{p[value]();}},_getStartPage:function(){var cp=this.plugin.currentPage(),ms=this.maxPageStep,hs=parseInt(ms/2,10),tp=this.plugin.getTotalPageNum();if(cp<hs||(cp-hs)<1||tp<=ms){return 1;}else{return tp-cp<hs&&cp-ms>=0?tp-ms+1:cp-hs;}},_getStepPageSize:function(){var sp=this._getStartPage(),tp=this.plugin.getTotalPageNum(),ms=this.maxPageStep;return sp+ms>tp?tp-sp+1:ms;}});var _14c3=_147f("dojox.grid.enhanced.plugins.Pagination",_1485,{name:"pagination",defaultPageSize:25,defaultPage:1,description:true,sizeSwitch:true,pageStepper:true,gotoButton:false,pageSizes:[10,25,50,100,Infinity],maxPageStep:7,position:"bottom",init:function(){var g=this.grid;g.usingPagination=true;this._initOptions();this._currentPage=this.defaultPage;this._currentPageSize=this.grid.rowsPerPage=this.defaultPageSize;this._store=g.store;this.forcePageStoreLayer=new _1492(this);_1484.wrap(g,"_storeLayerFetch",this.forcePageStoreLayer);this._paginator=this.option.position!="top"?new _14a0(lang.mixin(this.option,{position:"bottom",plugin:this})):new _14a0(lang.mixin(this.option,{position:"top",plugin:this}));this._regApis();},destroy:function(){this.inherited(arguments);this._paginator.destroy();var g=this.grid;g.unwrap(this.forcePageStoreLayer.name());g.scrollToRow=this._gridOriginalfuncs[0];g._onNew=this._gridOriginalfuncs[1];g.removeSelectedRows=this._gridOriginalfuncs[2];this._paginator=null;this._nls=null;},currentPage:function(page){if(page<=this.getTotalPageNum()&&page>0&&this._currentPage!==page){this._currentPage=page;this.grid._refresh(true);this.grid.resize();}return this._currentPage;},nextPage:function(){this.currentPage(this._currentPage+1);},prevPage:function(){this.currentPage(this._currentPage-1);},firstPage:function(){this.currentPage(1);},lastPage:function(){this.currentPage(this.getTotalPageNum());},currentPageSize:function(size){if(!isNaN(size)){var g=this.grid,_14c4=this._currentPageSize*(this._currentPage-1),_14c5;this._showAll=!isFinite(size);this.grid.usingPagination=!this._showAll;this._currentPageSize=this._showAll?this._maxSize:size;g.rowsPerPage=this._showAll?this._defaultRowsPerPage:size;_14c5=_14c4+Math.min(this._currentPageSize,this._maxSize);if(_14c5>this._maxSize){this.lastPage();}else{var cp=Math.ceil(_14c4/this._currentPageSize)+1;if(cp!==this._currentPage){this.currentPage(cp);}else{this.grid._refresh(true);}}this.grid.resize();}return this._currentPageSize;},getTotalPageNum:function(){return Math.ceil(this._maxSize/this._currentPageSize);},getTotalRowCount:function(){return this._maxSize;},scrollToRow:function(_14c6){var page=parseInt(_14c6/this._currentPageSize,10)+1;if(page>this.getTotalPageNum()){return;}this.currentPage(page);var _14c7=_14c6%this._currentPageSize;return this._gridOriginalfuncs[0](_14c7);},removeSelectedRows:function(){this._multiRemoving=true;this._gridOriginalfuncs[2].apply();this._multiRemoving=false;if(this.grid.store.save){this.grid.store.save();}this.grid.resize();this.grid._refresh();},showGotoPageButton:function(flag){this._paginator.gotoButton=flag;this._paginator._updateGotoButton();},gotoPage:function(page){_147e.deprecated("dojox.grid.enhanced.EnhancedGrid.gotoPage(page)","use dojox.grid.enhanced.EnhancedGrid.currentPage(page) instead","1.8");this.currentPage(page);},gotoFirstPage:function(){_147e.deprecated("dojox.grid.enhanced.EnhancedGrid.gotoFirstPage()","use dojox.grid.enhanced.EnhancedGrid.firstPage() instead","1.8");this.firstPage();},gotoLastPage:function(){_147e.deprecated("dojox.grid.enhanced.EnhancedGrid.gotoLastPage()","use dojox.grid.enhanced.EnhancedGrid.lastPage() instead","1.8");this.lastPage();},changePageSize:function(size){_147e.deprecated("dojox.grid.enhanced.EnhancedGrid.changePageSize(size)","use dojox.grid.enhanced.EnhancedGrid.currentPageSize(size) instead","1.8");this.currentPageSize(size);},_nls:null,_showAll:false,_maxSize:0,_defaultRowsPerPage:25,_currentPage:1,_currentPageSize:25,_initOptions:function(){this._defaultRowsPerPage=this.grid.rowsPerPage||25;this.defaultPage=this.option.defaultPage>=1?parseInt(this.option.defaultPage,10):1;this.option.description=this.option.description!==undefined?!!this.option.description:this.description;this.option.sizeSwitch=this.option.sizeSwitch!==undefined?!!this.option.sizeSwitch:this.sizeSwitch;this.option.pageStepper=this.option.pageStepper!==undefined?!!this.option.pageStepper:this.pageStepper;this.option.gotoButton=this.option.gotoButton!==undefined?!!this.option.gotoButton:this.gotoButton;if(lang.isArray(this.option.pageSizes)){var _14c8=[];array.forEach(this.option.pageSizes,function(size){size=typeof size=="number"?size:parseInt(size,10);if(!isNaN(size)&&size>0){_14c8.push(size);}else{if(array.indexOf(_14c8,Infinity)<0){_14c8.push(Infinity);}}},this);this.option.pageSizes=_14c8.sort(function(a,b){return a-b;});}else{this.option.pageSizes=this.pageSizes;}this.defaultPageSize=this.option.defaultPageSize>=1?parseInt(this.option.defaultPageSize,10):this.option.pageSizes[0];this.option.maxPageStep=this.option.maxPageStep>0?this.option.maxPageStep:this.maxPageStep;this.option.position=lang.isString(this.option.position)?this.option.position.toLowerCase():this.position;this._nls=[nls.descTemplate,nls.allItemsLabelTemplate,nls.pageSizeLabelTemplate,nls.pageStepLabelTemplate,nls.itemTitle,nls.singularItemTitle,nls.prevTip,nls.firstTip,nls.nextTip,nls.lastTip,nls.gotoButtonTitle,nls.dialogTitle,nls.dialogIndication,nls.pageCountIndication,nls.dialogConfirm,nls.dialogCancel,nls.all];},_regApis:function(){var g=this.grid;g.currentPage=lang.hitch(this,this.currentPage);g.nextPage=lang.hitch(this,this.nextPage);g.prevPage=lang.hitch(this,this.prevPage);g.firstPage=lang.hitch(this,this.firstPage);g.lastPage=lang.hitch(this,this.lastPage);g.currentPageSize=lang.hitch(this,this.currentPageSize);g.showGotoPageButton=lang.hitch(this,this.showGotoPageButton);g.getTotalRowCount=lang.hitch(this,this.getTotalRowCount);g.getTotalPageNum=lang.hitch(this,this.getTotalPageNum);g.gotoPage=lang.hitch(this,this.gotoPage);g.gotoFirstPage=lang.hitch(this,this.gotoFirstPage);g.gotoLastPage=lang.hitch(this,this.gotoLastPage);g.changePageSize=lang.hitch(this,this.changePageSize);this._gridOriginalfuncs=[lang.hitch(g,g.scrollToRow),lang.hitch(g,g._onNew),lang.hitch(g,g.removeSelectedRows)];g.scrollToRow=lang.hitch(this,this.scrollToRow);g.removeSelectedRows=lang.hitch(this,this.removeSelectedRows);g._onNew=lang.hitch(this,this._onNew);this.connect(g,"_onDelete",lang.hitch(this,this._onDelete));},_onNew:function(item,_14c9){var _14ca=this.getTotalPageNum();if(((this._currentPage===_14ca||_14ca===0)&&this.grid.get("rowCount")<this._currentPageSize)||this._showAll){lang.hitch(this.grid,this._gridOriginalfuncs[1])(item,_14c9);this.forcePageStoreLayer.endIdx++;}this._maxSize++;if(this._showAll){this._currentPageSize++;}if(this._showAll&&this.grid.autoHeight){this.grid._refresh();}else{this._paginator._update();}},_onDelete:function(){if(!this._multiRemoving){this.grid.resize();if(this._showAll){this.grid._refresh();}}if(this.grid.get("rowCount")===0){this.prevPage();}}});_1486.registerPlugin(_14c3);return _14c3;});},"url:dojox/grid/resources/View.html":"<div class=\"dojoxGridView\" role=\"presentation\">\n\t<div class=\"dojoxGridHeader\" dojoAttachPoint=\"headerNode\" role=\"presentation\">\n\t\t<div dojoAttachPoint=\"headerNodeContainer\" style=\"width:9000em\" role=\"presentation\">\n\t\t\t<div dojoAttachPoint=\"headerContentNode\" role=\"row\"></div>\n\t\t</div>\n\t</div>\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" dojoAttachPoint=\"hiddenFocusNode\" aria-hidden=\"true\" />\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" aria-hidden=\"true\" />\n\t<div class=\"dojoxGridScrollbox\" dojoAttachPoint=\"scrollboxNode\" role=\"presentation\">\n\t\t<div class=\"dojoxGridContent\" dojoAttachPoint=\"contentNode\" hidefocus=\"hidefocus\" role=\"presentation\"></div>\n\t</div>\n</div>\n","url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,textDirNode\"\n\t\trole=\"presentation\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<span data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<span class=\"dijitInline dijitIcon dijitMenuExpand\"></span>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</span>\n\t</td>\n</tr>\n","url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset\" data-dojo-attach-point=\"focusNode\" role=\"${role}\" tabIndex=\"-1\" aria-checked=\"${checked}\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<span class=\"dijitInline dijitIcon dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t\t<span class=\"dijitMenuItemIconChar dijitCheckedMenuItemIconChar\">${!checkedChar}</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode,textDirNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n","url:dojox/grid/resources/_Grid.html":"<div hidefocus=\"hidefocus\" role=\"grid\" dojoAttachEvent=\"onmouseout:_mouseOut\">\n\t<div class=\"dojoxGridMasterHeader\" dojoAttachPoint=\"viewsHeaderNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterView\" dojoAttachPoint=\"viewsNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterMessages\" style=\"display: none;\" dojoAttachPoint=\"messagesNode\"></div>\n\t<span dojoAttachPoint=\"lastFocusNode\" tabindex=\"0\"></span>\n</div>\n","url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabindex=\"-1\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n\t${!actionBarTemplate}\n</div>\n\n","url:dojox/grid/enhanced/templates/FilterBar.html":"<table class=\"dojoxGridFBar\" border=\"0\" cellspacing=\"0\" role=\"presentation\" dojoAttachEvent=\"onclick:_onClickFilterBar, onmouseenter:_onMouseEnter, onmouseleave:_onMouseLeave, onmousemove:_onMouseMove\"\n\t><tr><td class=\"dojoxGridFBarBtnTD\"\n\t\t><span dojoType=\"dijit.form.Button\" class=\"dojoxGridFBarBtn\" dojoAttachPoint=\"defineFilterButton\" label=\"...\" iconClass=\"dojoxGridFBarDefFilterBtnIcon\" showLabel=\"true\" dojoAttachEvent=\"onClick:_showFilterDefDialog, onMouseEnter:_onEnterButton, onMouseLeave:_onLeaveButton, onMouseMove:_onMoveButton\"></span\n\t></td><td class=\"dojoxGridFBarInfoTD\"\n\t\t><span class=\"dojoxGridFBarInner\"\n\t\t\t><span class=\"dojoxGridFBarStatus\" dojoAttachPoint=\"statusBarNode\">${_noFilterMsg}</span\n\t\t\t><span dojoType=\"dijit.form.Button\" class=\"dojoxGridFBarClearFilterBtn\" dojoAttachPoint=\"clearFilterButton\" \n\t\t\t\tlabel=\"${_filterBarClearBtnLabel}\" iconClass=\"dojoxGridFBarClearFilterBtnIcon\" showLabel=\"true\" \n\t\t\t\tdojoAttachEvent=\"onClick:_clearFilterDefDialog, onMouseEnter:_onEnterButton, onMouseLeave:_onLeaveButton, onMouseMove:_onMoveButton\"></span\n\t\t\t><span dojotype=\"dijit.form.Button\" class=\"dojoxGridFBarCloseBtn\" dojoAttachPoint=\"closeFilterBarButton\" \n\t\t\t\tlabel=\"${_closeFilterBarBtnLabel}\" iconClass=\"dojoxGridFBarCloseBtnIcon\" showLabel=\"false\" \n\t\t\t\tdojoAttachEvent=\"onClick:_closeFilterBar, onMouseEnter:_onEnterButton, onMouseLeave:_onLeaveButton, onMouseMove:_onMoveButton\"></span\n\t\t></span\n\t></td></tr\n></table>\n","url:dijit/form/templates/TextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\" data-dojo-attach-event=\"mouseenter:onMouseEnter,mouseleave:onMouseLeave\"\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n></div>\n","url:dijit/form/templates/ValidationTextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","url:dijit/form/templates/DropDownBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\"\n\trole=\"combobox\"\n\taria-haspopup=\"true\"\n\tdata-dojo-attach-point=\"_popupStateNode\"\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\n\t\tdata-dojo-attach-point=\"_buttonNode\" role=\"presentation\"\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"button presentation\" aria-hidden=\"true\"\n\t\t\t${_buttonInputDisabled}\n\t/></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"${type}\" autocomplete=\"off\"\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\"\n\t/></div\n></div>\n","url:dijit/templates/Calendar.html":"<div class=\"dijitCalendarContainer dijitInline\" role=\"presentation\" aria-labelledby=\"${id}_mddb ${id}_year\">\n\t<div class=\"dijitReset dijitCalendarMonthContainer\" role=\"presentation\">\n\t\t<div class='dijitReset dijitCalendarArrow dijitCalendarDecrementArrow' data-dojo-attach-point=\"decrementMonth\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitCalendarIncrementControl dijitCalendarDecrease\" role=\"presentation\"/>\n\t\t\t<span data-dojo-attach-point=\"decreaseArrowNode\" class=\"dijitA11ySideArrow\">-</span>\n\t\t</div>\n\t\t<div class='dijitReset dijitCalendarArrow dijitCalendarIncrementArrow' data-dojo-attach-point=\"incrementMonth\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitCalendarIncrementControl dijitCalendarIncrease\" role=\"presentation\"/>\n\t\t\t<span data-dojo-attach-point=\"increaseArrowNode\" class=\"dijitA11ySideArrow\">+</span>\n\t\t</div>\n\t\t<div data-dojo-attach-point=\"monthNode\" class=\"dijitInline\"></div>\n\t</div>\n\t<table cellspacing=\"0\" cellpadding=\"0\" role=\"grid\" data-dojo-attach-point=\"gridNode\">\n\t\t<thead>\n\t\t\t<tr role=\"row\">\n\t\t\t\t${!dayCellsHtml}\n\t\t\t</tr>\n\t\t</thead>\n\t\t<tbody data-dojo-attach-point=\"dateRowsNode\" data-dojo-attach-event=\"ondijitclick: _onDayClick\" class=\"dijitReset dijitCalendarBodyContainer\">\n\t\t\t\t${!dateRowsHtml}\n\t\t</tbody>\n\t</table>\n\t<div class=\"dijitReset dijitCalendarYearContainer\" role=\"presentation\">\n\t\t<div class=\"dijitCalendarYearLabel\">\n\t\t\t<span data-dojo-attach-point=\"previousYearLabelNode\" class=\"dijitInline dijitCalendarPreviousYear\" role=\"button\"></span>\n\t\t\t<span data-dojo-attach-point=\"currentYearLabelNode\" class=\"dijitInline dijitCalendarSelectedYear\" role=\"button\" id=\"${id}_year\"></span>\n\t\t\t<span data-dojo-attach-point=\"nextYearLabelNode\" class=\"dijitInline dijitCalendarNextYear\" role=\"button\"></span>\n\t\t</div>\n\t</div>\n</div>\n","url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:__onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\ttabIndex=\"-1\" aria-hidden=\"true\" data-dojo-attach-point=\"valueNode\"\n/></span>\n","url:dijit/form/templates/DropDownButton.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:__onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode,_popupStateNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-event=\"onclick:_onClick\" data-dojo-attach-point=\"valueNode\" aria-hidden=\"true\"\n/></span>\n","url:dijit/layout/templates/AccordionButton.html":"<div data-dojo-attach-event='ondijitclick:_onTitleClick' class='dijitAccordionTitle' role=\"presentation\">\n\t<div data-dojo-attach-point='titleNode,focusNode' data-dojo-attach-event='onkeydown:_onTitleKeyDown'\n\t\t\tclass='dijitAccordionTitleFocus' role=\"tab\" aria-expanded=\"false\"\n\t\t><span class='dijitInline dijitAccordionArrow' role=\"presentation\"></span\n\t\t><span class='arrowTextUp' role=\"presentation\">+</span\n\t\t><span class='arrowTextDown' role=\"presentation\">-</span\n\t\t><span role=\"presentation\" class=\"dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t\t<span role=\"presentation\" data-dojo-attach-point='titleTextNode, textDirNode' class='dijitAccordionText'></span>\n\t</div>\n</div>\n","url:dojox/grid/enhanced/templates/FilterDefPane.html":"<div class=\"dojoxGridFDPane\">\n\t<div class=\"dojoxGridFDPaneRelation\">${_relMsgFront}\n\t<span class=\"dojoxGridFDPaneModes\" dojoAttachPoint=\"criteriaModeNode\">\n\t\t<select dojoAttachPoint=\"_relSelect\" dojoType=\"dijit.form.Select\" dojoAttachEvent=\"onChange: _onRelSelectChange\">\n\t\t\t<option value=\"0\">${_relAll}</option>\n\t\t\t<option value=\"1\">${_relAny}</option>\n\t\t</select>\n\t</span>\n\t${_relMsgTail}\n\t</div>\n\t<div dojoAttachPoint=\"criteriaPane\" class=\"dojoxGridFDPaneRulePane\"></div>\n\t<div dojoAttachPoint=\"_addCBoxBtn\" dojoType=\"dijit.form.Button\" \n\t\tclass=\"dojoxGridFDPaneAddCBoxBtn\" iconClass=\"dojoxGridFDPaneAddCBoxBtnIcon\"\n\t\tdojoAttachEvent=\"onClick:_onAddCBox\" label=\"${_addRuleBtnLabel}\" showLabel=\"false\">\n\t</div>\n\t<div class=\"dojoxGridFDPaneBtns\" dojoAttachPoint=\"buttonsPane\">\n\t\t<span dojoAttachPoint=\"_cancelBtn\" dojoType=\"dijit.form.Button\" \n\t\t\tdojoAttachEvent=\"onClick:_onCancel\" label=\"${_cancelBtnLabel}\">\n\t\t</span>\n\t\t<span dojoAttachPoint=\"_clearFilterBtn\" dojoType=\"dijit.form.Button\" \n\t\t\tdojoAttachEvent=\"onClick:_onClearFilter\" label=\"${_clearBtnLabel}\" disabled=\"true\">\n\t\t</span>\n\t\t<span dojoAttachPoint=\"_filterBtn\" dojoType=\"dijit.form.Button\" \n\t\t\tdojoAttachEvent=\"onClick:_onFilter\" label=\"${_filterBtnLabel}\" disabled=\"true\">\n\t\t</span>\n\t</div>\n</div>\n","url:dojox/grid/enhanced/templates/CriteriaBox.html":"<div class=\"dojoxGridFCBox\">\n\t<div class=\"dojoxGridFCBoxSelCol\" dojoAttachPoint=\"selColNode\">\n\t\t<span class=\"dojoxGridFCBoxField\">${_colSelectLabel}</span>\n\t\t<select dojoAttachPoint=\"_colSelect\" dojoType=\"dijit.form.Select\" \n\t\t\tclass=\"dojoxGridFCBoxColSelect\"\n\t\t\tdojoAttachEvent=\"onChange:_onChangeColumn\">\n\t\t</select>\n\t</div>\n\t<div class=\"dojoxGridFCBoxCondition\" dojoAttachPoint=\"condNode\">\n\t\t<span class=\"dojoxGridFCBoxField\">${_condSelectLabel}</span>\n\t\t<select dojoAttachPoint=\"_condSelect\" dojoType=\"dijit.form.Select\" \n\t\t\tclass=\"dojoxGridFCBoxCondSelect\"\n\t\t\tdojoAttachEvent=\"onChange:_onChangeCondition\">\n\t\t</select>\n\t\t<div class=\"dojoxGridFCBoxCondSelectAlt\" dojoAttachPoint=\"_condSelectAlt\" style=\"display:none;\"></div>\n\t</div>\n\t<div class=\"dojoxGridFCBoxValue\" dojoAttachPoint=\"valueNode\">\n\t\t<span class=\"dojoxGridFCBoxField\">${_valueBoxLabel}</span>\n\t</div>\n</div>\n","url:dojox/grid/enhanced/templates/FilterBoolValueBox.html":"<div class=\"dojoxGridBoolValueBox\">\n\t<div class=\"dojoxGridTrueBox\">\n\t\t<input dojoType=\"dijit.form.RadioButton\" type='radio' name='a1' id='${_baseId}_rbTrue' checked=\"true\" \n\t\t\tdojoAttachPoint=\"rbTrue\" dojoAttachEvent=\"onChange: onChange\"/>\n\t\t<div class=\"dojoxGridTrueLabel\" for='${_baseId}_rbTrue'>${_lblTrue}</div>\n\t</div>\n\t<div class=\"dojoxGridFalseBox\">\n\t\t<input dojoType=\"dijit.form.RadioButton\" dojoAttachPoint=\"rbFalse\" type='radio' name='a1' id='${_baseId}_rbFalse'/>\n\t\t<div class=\"dojoxGridTrueLabel\" for='${_baseId}_rbFalse'>${_lblFalse}</div>\n\t</div>\n</div>\n","url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\"\n\t   cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n","url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\" role=\"separator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>\n","url:dijit/form/templates/Select.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tdata-dojo-attach-point=\"_buttonNode,tableNode,focusNode,_popupStateNode\" cellspacing='0' cellpadding='0'\n\trole=\"listbox\" aria-haspopup=\"true\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonContents\" role=\"presentation\"\n\t\t\t><div class=\"dijitReset dijitInputField dijitButtonText\"  data-dojo-attach-point=\"containerNode,textDirNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitValidationContainer\"\n\t\t\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t/></div\n\t\t\t><input type=\"hidden\" ${!nameAttrSetting} data-dojo-attach-point=\"valueNode\" value=\"${value}\" aria-hidden=\"true\"\n\t\t/></td\n\t\t><td class=\"dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer\"\n\t\t\tdata-dojo-attach-point=\"titleNode\" role=\"presentation\"\n\t\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t${_buttonInputDisabled}\n\t\t/></td\n\t></tr></tbody\n></table>\n","url:dijit/form/templates/CheckBox.html":"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" role=\"${type}\" aria-checked=\"false\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"ondijitclick:_onClick\"\n/></div>\n","url:dijit/form/templates/Spinner.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitButtonNode dijitSpinnerButtonContainer\"\n\t\t><input class=\"dijitReset dijitInputField dijitSpinnerButtonInner\" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t/><div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitUpArrowButton\"\n\t\t\tdata-dojo-attach-point=\"upArrowNode\"\n\t\t\t><div class=\"dijitArrowButtonInner\"\n\t\t\t\t><input class=\"dijitReset dijitInputField\" value=\"&#9650; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t\t${_buttonInputDisabled}\n\t\t\t/></div\n\t\t></div\n\t\t><div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitDownArrowButton\"\n\t\t\tdata-dojo-attach-point=\"downArrowNode\"\n\t\t\t><div class=\"dijitArrowButtonInner\"\n\t\t\t\t><input class=\"dijitReset dijitInputField\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t\t${_buttonInputDisabled}\n\t\t\t/></div\n\t\t></div\n\t></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' data-dojo-attach-point=\"textbox,focusNode\" type=\"${type}\" data-dojo-attach-event=\"onkeydown:_onKeyDown\"\n\t\t\trole=\"spinbutton\" autocomplete=\"off\" ${!nameAttrSetting}\n\t/></div\n></div>\n","url:dijit/form/templates/HorizontalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderH\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeydown:_onKeyDown, onkeyup:_onKeyUp\"\n\trole=\"presentation\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"topDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationT dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderDecrementIconH\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderLeftBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><div class=\"dijitReset dijitSliderBarContainerH\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderProgressBar dijitSliderProgressBarH\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableH\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleH\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderRemainingBar dijitSliderRemainingBarH\" data-dojo-attach-event=\"press:_onBarClick\"></div\n\t\t\t></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderRightBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderIncrementIconH\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"containerNode,bottomDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationB dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n></table>\n","url:dijit/templates/TooltipDialog.html":"<div role=\"alertdialog\" tabIndex=\"-1\">\n\t<div class=\"dijitTooltipContainer\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"contentsNode\" class=\"dijitTooltipContents dijitTooltipFocusNode\">\n\t\t\t<div data-dojo-attach-point=\"containerNode\"></div>\n\t\t\t${!actionBarTemplate}\n\t\t</div>\n\t</div>\n\t<div class=\"dijitTooltipConnector\" role=\"presentation\" data-dojo-attach-point=\"connectorNode\"></div>\n</div>\n","url:dojox/grid/enhanced/templates/FilterStatusPane.html":"<div class=\"dojoxGridFStatusTip\"\n\t><div class=\"dojoxGridFStatusTipHead\"\n\t\t><span class=\"dojoxGridFStatusTipTitle\" dojoAttachPoint=\"statusTitle\"></span\n\t\t><span class=\"dojoxGridFStatusTipRel\" dojoAttachPoint=\"statusRel\"></span\n\t></div\n\t><div class=\"dojoxGridFStatusTipDetail\" dojoAttachPoint=\"statusDetailNode\"\n\t></div\n></div>\n","url:dojox/grid/enhanced/templates/ClearFilterConfirmPane.html":"<div class=\"dojoxGridClearFilterConfirm\">\n\t<div class=\"dojoxGridClearFilterMsg\">\n\t\t${_clearFilterMsg}\n\t</div>\n\t<div class=\"dojoxGridClearFilterBtns\" dojoAttachPoint=\"btnsNode\">\n\t\t<span dojoType=\"dijit.form.Button\" label=\"${_cancelBtnLabel}\" dojoAttachPoint=\"cancelBtn\" dojoAttachEvent=\"onClick:_onCancel\"></span>\n\t\t<span dojoType=\"dijit.form.Button\" label=\"${_clearBtnLabel}\" dojoAttachPoint=\"clearBtn\" dojoAttachEvent=\"onClick:_onClear\"></span>\n\t</div>\n</div>\n","url:dojox/grid/enhanced/templates/Pagination.html":"<div dojoAttachPoint=\"paginatorBar\"\n\t><table cellpadding=\"0\" cellspacing=\"0\"  class=\"dojoxGridPaginator\"\n\t\t><tr\n\t\t\t><td dojoAttachPoint=\"descriptionTd\" class=\"dojoxGridDescriptionTd\"\n\t\t\t\t><div dojoAttachPoint=\"descriptionDiv\" class=\"dojoxGridDescription\"></div\n\t\t\t></div></td\n\t\t\t><td dojoAttachPoint=\"sizeSwitchTd\"></td\n\t\t\t><td dojoAttachPoint=\"pageStepperTd\" class=\"dojoxGridPaginatorFastStep\"\n\t\t\t\t><div dojoAttachPoint=\"pageStepperDiv\" class=\"dojoxGridPaginatorStep\"></div\n\t\t\t></td\n\t\t\t><td dojoAttachPoint=\"gotoPageTd\" class=\"dojoxGridPaginatorGotoTd\"\n\t\t\t\t><div dojoAttachPoint=\"gotoPageDiv\" class=\"dojoxGridPaginatorGotoDiv\" dojoAttachEvent=\"onclick:_openGotopageDialog, onkeydown:_openGotopageDialog\"\n\t\t\t\t\t><span class=\"dojoxGridWardButtonInner\">&#8869;</span\n\t\t\t\t></div\n\t\t\t></td\n\t\t></tr\n\t></table\n></div>\n","*now":function(r){r(["dojo/i18n!*preload*demos/grid/nls/src*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);}}});require(["dojo/data/ItemFileWriteStore","dojox/grid/EnhancedGrid","dojox/grid/enhanced/plugins/Filter","dojox/grid/enhanced/plugins/exporter/CSVWriter","dojox/grid/enhanced/plugins/Printer","dojox/grid/enhanced/plugins/Cookie","dojox/grid/enhanced/plugins/IndirectSelection","dojox/grid/enhanced/plugins/NestedSorting","dojox/grid/enhanced/plugins/Selector","dojox/grid/enhanced/plugins/Menu","dojox/grid/enhanced/plugins/DnD","dojox/grid/enhanced/plugins/Search","dojox/grid/enhanced/plugins/CellMerge","dojox/grid/enhanced/plugins/Pagination"],function(){var _14cb={rowsPerPage:5,keepSelection:true,plugins:{}};var _14cc={"nestedSorting":{},"indirectSelection":{headerSelector:true},"menus":{headerMenu:"headerMenu",rowMenu:"rowMenu",cellMenu:"cellMenu",selectedRegionMenu:"selectedRegionMenu"},"exporter":{},"printer":{},"filter":{closeFilterbarButton:true,ruleCount:0},"selector":{},"dnd":{copyOnly:true},"cellMerge":{"mergedCells":[{row:"3",start:1,end:10,major:3}]},"search":{},"pagination":{pageSizes:["5","10","20","50","All"],description:true,sizeSwitch:true,pageStepper:true,gotoButton:true,maxPageStep:10,position:"bottom"}};var _14cd={"canSort":{label:"disable canSort",value:function(_14ce){return false;}},"rowSelector":{value:"20px"},"autoWidth":{value:true},"singleClickEdit":{value:true},"selectionMode":{label:"single selectionMode",value:"single"}};function _14cf(){var sb=["<table><tbody>"];for(var _14d0 in _14cd){sb.push("<tr>");sb.push("<td><input id='cbid",_14d0,"' dojoType='dijit.form.CheckBox' dojoAttachPoint='cb",_14d0,"'><label id='lbl",_14d0,"' for='cbid",_14d0,"'>",_14cd[_14d0].label||_14d0,"</label></input></td>");sb.push("</tr>");}sb.push("<tr><td><hr/></td></tr>","<tr><td><button id='selectAllOptions' >Select All</button>","<button id='deselectAllOptions'>Deselect All</button></td></tr>");for(var _14d1 in _14cc){sb.push("<tr>");sb.push("<td><input id='cbid",_14d1,"' dojoType='dijit.form.CheckBox' dojoAttachPoint='cb",_14d1,"'><label id='lbl",_14d1,"' for='cbid",_14d1,"'>",_14d1,"</label></input></td>");sb.push("</tr>");}sb.push("</tbody></table>");return sb.join("");};dojo.declare("PluginTable",[dijit._Widget,dijit._TemplatedMixin,dijit._WidgetsInTemplateMixin],{templateString:_14cf(),widgetsInTemplate:true,_onChangePlugin:function(_14d2,cb,e){var _14d3=cb.get("checked");_14cb.plugins[_14d2]=_14d3?_14cc[_14d2]:false;var nd=dojo.byId(_14d2+"Support");if(nd){dojo.style(nd,"display",_14d3?"":"none");}},_onChangeFeature:function(_14d4,cb,e){var _14d5=cb.get("checked");if(_14d5){_14cb[_14d4]=_14cd[_14d4].value;}else{delete _14cb[_14d4];}},postCreate:function(){var cb;for(var _14d6 in _14cd){cb=this["cb"+_14d6];this.connect(cb,"onChange",dojo.hitch(this,"_onChangeFeature",_14d6,cb));}for(var _14d7 in _14cc){cb=this["cb"+_14d7];this.connect(cb,"onChange",dojo.hitch(this,"_onChangePlugin",_14d7,cb));}}});function _14d8(){for(var _14d9 in _14cc){dijit.byId("cbid"+_14d9).set("checked",true);}};function _14da(){for(var _14db in _14cc){dijit.byId("cbid"+_14db).set("checked",false);}};function _14dc(){var g=dijit.byId("grid");g&&g.exportGrid("csv",{writerArgs:{separator:dojo.byId("sep").value}},function(str){dojo.byId("csvResults").value=str;});};function _14dd(){var g=dijit.byId("grid");if(g){dojo.byId("csvResults").value=g.exportSelected("csv",{separator:dojo.byId("sep").value});}};function _14de(){var g=dijit.byId("grid");if(g){g.printGrid({title:dojo.byId("print_title").value,cssFiles:["support/print_style1.css","support/print_style2.css"]});}};function _14df(){var g=dijit.byId("grid");g&&g.printSelected({title:dojo.byId("print_title").value,cssFiles:["support/print_style1.css","support/print_style2.css"]});};function _14e0(){var g=dijit.byId("grid");g&&g.exportToHTML({title:dojo.byId("print_title").value,cssFiles:["support/print_style1.css","support/print_style2.css"]},function(str){var win=window.open();win.document.open();win.document.write(str);g.normalizePrintedGrid(win.document);win.document.close();});};function _14e1(){var _14e2=parseInt(dojo.byId("inputRow").value,10)-1;var start=parseInt(dojo.byId("inputStart").value,10);var end=parseInt(dojo.byId("inputEnd").value,10);var major=parseInt(dojo.byId("inputMajor").value,10);var grid=dijit.byId("grid");grid.mergeCells(_14e2,start,end,major);};function _14e3(key,_14e4){try{var g=dijit.byId("grid");if(g){if(key){g.setCookieEnabled(key,_14e4);}else{g.setCookieEnabled(_14e4);}}}catch(e){}};function _14e5(){var g=dijit.byId("grid");if(g){var idx=parseInt(dojo.byId("inputScrollToRowIdx").value,10);g.scrollToRow(idx);}};dojo.ready(function(){dojo.connect(dojo.byId("selectAllOptions"),"click",_14d8);dojo.connect(dojo.byId("deselectAllOptions"),"click",_14da);dojo.connect(dojo.byId("exportAllCSV"),"click",_14dc);dojo.connect(dojo.byId("exportSelectedCSV"),"click",_14dd);dojo.connect(dojo.byId("mergeCell"),"click",_14e1);dojo.connect(dojo.byId("scrollToRow"),"click",_14e5);var btns=dojo.byId("ctrlBtns2");btns.appendChild(dojo.create("button",{"innerHTML":"Refresh","onclick":function(){var g=dijit.byId("grid");g&&g._refresh();}}));btns.appendChild(dojo.create("button",{"innerHTML":"Delete Selected","onclick":function(){var g=dijit.byId("grid");g&&g.removeSelectedRows();}}));btns.appendChild(dojo.create("button",{"innerHTML":"resize","onclick":function(){var g=dijit.byId("grid");if(g){var cc=dojo.byId("gridContainer");dojo.style(cc,"height",(dojo.contentBox(cc).h+10)+"px");dojo.style(cc,"width",(dojo.contentBox(cc).w-10)+"px");g.resize(dojo.contentBox(cc));}}}));btns.appendChild(dojo.create("button",{"innerHTML":"Select All","onclick":function(){var g=dijit.byId("grid");if(g){var t1=(new Date()).getTime();g.selection.selectRange(0,g.rowCount-1);}}}));var _14e6=true;btns.appendChild(dojo.create("button",{"innerHTML":"Disable 4th row selector","onclick":function(){var g=dijit.byId("grid");if(g){var cell=g.layout.cells[0];if(cell.setDisabled){cell.setDisabled(3,_14e6);_14e6=!_14e6;}}}}));btns.appendChild(dojo.create("button",{"innerHTML":"clear sort","onclick":function(){var g=dijit.byId("grid");if(g){g.setSortIndex([]);}}}));});var data={identifier:"id",label:"id",items:[]};var _14e7=[{"Heard":true,"Checked":"True","Genre":"Easy Listening","Artist":"Bette Midler","Year":2003,"Album":"Bette Midler Sings the Rosemary Clooney Songbook","Name":"Hey There","Length":"03:31","Track":4,"Composer":"Ross, Jerry 1926-1956 -w Adler, Richard 1921-","Download Date":"1923/4/9","Last Played":"04:32:49"},{"Heard":true,"Checked":"True","Genre":"Classic Rock","Artist":"Jimi Hendrix","Year":1993,"Album":"Are You Experienced","Name":"Love Or Confusion","Length":"03:15","Track":4,"Composer":"Jimi Hendrix","Download Date":"1947/12/6","Last Played":"03:47:49"},{"Heard":true,"Checked":"True","Genre":"Jazz","Artist":"Andy Narell","Year":1992,"Album":"Down the Road","Name":"Sugar Street","Length":"07:00","Track":8,"Composer":"Andy Narell","Download Date":"1906/3/22","Last Played":"21:56:15"},{"Heard":true,"Checked":"True","Genre":"Progressive Rock","Artist":"Emerson, Lake & Palmer","Year":1992,"Album":"The Atlantic Years","Name":"Tarkus","Length":"20:40","Track":5,"Composer":"Greg Lake/Keith Emerson","Download Date":"1994/11/29","Last Played":"03:25:19"},{"Heard":true,"Checked":"True","Genre":"Rock","Artist":"Blood, Sweat & Tears","Year":1968,"Album":"Child Is Father To The Man","Name":"Somethin' Goin' On","Length":"08:00","Track":9,"Composer":"","Download Date":"1973/9/11","Last Played":"19:49:41"},{"Heard":true,"Checked":"True","Genre":"Jazz","Artist":"Andy Narell","Year":1989,"Album":"Little Secrets","Name":"Armchair Psychology","Length":"08:20","Track":5,"Composer":"Andy Narell","Download Date":"2010/4/15","Last Played":"01:13:08"},{"Heard":true,"Checked":"True","Genre":"Easy Listening","Artist":"Frank Sinatra","Year":1991,"Album":"Sinatra Reprise: The Very Good Years","Name":"Luck Be A Lady","Length":"05:16","Track":4,"Composer":"F. Loesser","Download Date":"2035/4/12","Last Played":"06:16:53"},{"Heard":true,"Checked":"True","Genre":"Progressive Rock","Artist":"Dixie dregs","Year":1977,"Album":"Free Fall","Name":"Sleep","Length":"01:58","Track":6,"Composer":"Steve Morse","Download Date":"2032/11/21","Last Played":"08:23:26"}];var len=_14e7.length;var _14e8=25;for(var i=0;i<_14e8*len;++i){data.items.push(dojo.mixin({"id":i+1},_14e7[i%len]));}var store=new dojo.data.ItemFileWriteStore({data:data});var _14e9=function(_14ea){var dtb=new dijit.form.DateTextBox({});var res=dojo.date.locale.parse(_14ea,{selector:"date",datePattern:"yyyy/MM/dd"});dtb.set("value",res);return dtb;};var _14eb=[[{defaultCell:{editable:true,autoComplete:true,type:dojox.grid.cells._Widget},cells:[{field:"id",name:"Index",datatype:"number",width:4},{field:"Genre",name:"Genre",datatype:"string",width:10},{field:"Artist",name:"Artist",datatype:"string",width:10},{field:"Year",name:"Year",datatype:"string",width:6},{field:"Album",name:"Album",datatype:"string",width:10},{field:"Name",name:"Name",datatype:"string",width:8,disabledConditions:["contains","notcontains"]},{field:"Length",name:"Length",datatype:"string",width:6},{field:"Track",name:"Track",datatype:"number",width:5},{field:"Composer",name:"Composer",datatype:"string",width:12},{field:"Download Date",name:"Download Date",datatype:"date",width:12,navigatable:true,editable:false,dataTypeArgs:{datePattern:"yyyy/M/d"}},{field:"Last Played",name:"Last Played",datatype:"time",width:6,dataTypeArgs:{timePattern:"HH:mm:ss"}},{field:"Heard",name:"Checked",datatype:"boolean",width:6},{field:"Checked",name:"Checked (Customized Label)",editable:false,datatype:"boolean",width:15,dataTypeArgs:{trueLabel:"This sounds like a very old song.",falseLabel:"Never heard of this song."}}]}],[{defaultCell:{},rows:[[{field:"id",name:"Index(1)",hidden:false},{field:"Genre",name:"Genre(2)",hidden:false},{field:"Artist",name:"Artist(3)",hidden:false},{field:"Year",name:"Year(4)",hidden:false},{field:"Album",name:"Album(5)",hidden:false},{field:"Name",name:"Name(6)",hidden:false},{field:"Length",name:"Length(7)",hidden:false},{field:"Track",name:"Track(8)",hidden:false},{field:"Composer",name:"Composer(9)",hidden:false},{field:"Download Date",name:"Download Date(10)",cellFormatter:{selector:"date",parse:{datePattern:"yyyy/M/d"},format:{datePattern:"MMMM d, yyyy"}},hidden:false},{field:"Last Played",name:"Last Played(11)",hidden:false}]]}],[{width:"300px",rows:[{field:"Genre",width:"6"},{field:"Artist",width:"5"},{field:"Year",width:"6"},{field:"Album",width:"10"}]},{rows:[{field:"Name",width:"17"},{field:"Length",width:"6"},{field:"Track",width:"6"},{field:"Composer",width:"15"}]}],[{rows:[{field:"Genre",width:"8"},{field:"Artist",width:"6"},{field:"Year",width:"6"},{field:"Album",width:"10"},{field:"Name",width:"10"},{field:"Length",width:"6"},{field:"Track",width:"6"},{field:"Composer",width:"13"},{field:"Download Date",width:"10"},{field:"Last Played",width:"10"}]}],[{rows:[[{field:"Genre"},{field:"Artist"},{field:"Year"},{field:"Album"},{field:"Name"}],[{field:"Length"},{field:"Track"},{field:"Composer"},{field:"Download Date"},{field:"Last Played"}]]}],[{rows:[[{field:"Genre",width:"10",rowSpan:2},{field:"Artist",width:"15"},{field:"Year",width:"15"}],[{field:"Album",colSpan:2}]]},{rows:[[{field:"Name",width:"20",rowSpan:2},{field:"Length",width:"20"},{field:"Track"}],[{field:"Composer",colSpan:2}],[{field:"Download Date"},{field:"Last Played"},{field:"Checked"}]]}]];var _14ec=0;var _14ed=1000;var _14ee=500;function _14ef(step){try{var g=dijit.byId("grid");g&&g.destroyRecursive();for(_14ec+=step;_14ec<0;_14ec+=_14eb.length){}_14ec%=_14eb.length;var t1=(new Date()).getTime();g=new dojox.grid.EnhancedGrid(dojo.mixin({"id":"grid","store":store,"structure":_14eb[_14ec]},_14cb||{}));g.placeAt(dojo.byId("gridContainer"));g.startup();dojo.byId("num").value=_14ec;return g;}catch(e){}};var cnt=_14ed;function start(){if(cnt>0){--cnt;_14ef(1);setTimeout(start,_14ee);}else{var g=dijit.byId("grid");g&&g.destroyRecursive();cnt=_14ed;}};function stop(){cnt=0;};function _14f0(){var id=parseInt(dojo.byId("num").value)%_14eb.length;_14ec=isNaN(id)?_14ec:id;_14ef(0);};function _14f1(){var g=dijit.byId("grid");g&&g.destroyRecursive();};dojo.addOnLoad(function(){var btns=dojo.byId("ctrlBtns");btns.appendChild(dojo.create("button",{"innerHTML":"Play","onclick":start}));btns.appendChild(dojo.create("button",{"innerHTML":"Stop","onclick":stop}));btns.appendChild(dojo.create("button",{"innerHTML":"Prev","onclick":dojo.partial(_14ef,-1)}));btns.appendChild(dojo.create("button",{"innerHTML":"Next","onclick":dojo.partial(_14ef,1)}));btns.appendChild(dojo.create("input",{"id":"num","value":_14ec,"type":"text"}));btns.appendChild(dojo.create("button",{"innerHTML":"Create","onclick":_14f0}));btns.appendChild(dojo.create("button",{"innerHTML":"Destroy","onclick":_14f1}));_14f0();});});