//>>built
require({cache:{"demos/shippingRoutes/src/Ecr":function(){define(["dojo/_base/kernel","dojo/_base/declare","dojo/_base/html","dojo/_base/array","dojo/_base/lang","dojo/dom","dojox/geo/openlayers/Map","dojox/geo/openlayers/GfxLayer","dojo/data/ItemFileReadStore","./PortRenderer","./LegsRenderer"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b){return _2(null,{constructor:function(){var _c=new _7("map");_c.fitTo([-160,70,160,-70]);this._map=_c;layer=new _8("legs");this._legLayer=layer;_c.addLayer(layer);layer=new _8("ports");this._portLayer=layer;_c.addLayer(layer);this.loadData("data/ecr.json");},fitTo:function(_d){this._map.fitTo(_d);},clearLayer:function(_e){var fa=_e.getFeatures();_e.removeFeature(fa);},clearEcr:function(_f){var _10=this._portLayer;this.clearLayer(_10);_10=this._legLayer;this.clearLayer(_10);this.fillPortChooser(null);},setDataSet:function(_11){var o=_6.byId(_11);var ds=o.value;var _12=this._portLayer;this.clearLayer(_12);_12=this._legLayer;this.clearLayer(_12);this.loadData(ds);},log:function(o){},loadError:function(){this.log(arguments[0]);},_portStyle:[{type:"circle",depth:"{radius}",radius:function(ctx){var _13=ctx.store.getValue(this,"offer");var ret=Math.max(1,Math.log(_13));return 3*ret;},stroke:{color:"#4c9a06",width:1}},{type:"circle",depth:"{radius}",radius:function(ctx){var _14=ctx.store.getValue(this,"demand");return 3*Math.max(1,Math.log(_14));},stroke:{color:"#bb0000",width:1}}],gotPorts:function(_15,_16){this.log("got ports "+_15.length);var _17=_16.store;var ctx={store:_17};var _18=new _a(this._portStyle,ctx);var _19=this._portLayer;_4.forEach(_15,function(_1a,_1b,_1c){var f=_18.render(_1a);if(f!=null){_19.addFeature(f);}});this.fillPortChooser(_15);this.portChange("portChooser");_19.redraw();},_legsStyle:{type:"polyline",stroke:{color:[255,165,0]}},gotLegs:function(_1d,_1e){var ctx={store:_1e.store};var _1f=new _b(this._legsStyle,ctx);_1f.setGeodetic(true);var _20=this._legLayer;_4.forEach(_1d,function(_21,_22,_23){var f=_1f.render(_21);if(f!=null){_20.addFeature(f);}});_20.redraw();},loadData:function(_24){var _25=new _9({url:_24,urlPreventCache:true});_25.fetch({query:{type:"legs"},onComplete:_5.hitch(this,this.gotLegs),onError:_5.hitch(this,this.loadError),queryOptions:{deep:true}});_25.fetch({query:{type:"port"},onComplete:_5.hitch(this,this.gotPorts),onError:_5.hitch(this,this.loadError)});},regionChange:function(_26){this.fitTo(_26.currentTarget.value);},portChange:function(_27){var o=_6.byId(_27);this.fitTo(o.value);},fillPortChooser:function(_28){var ps=_6.byId("portChooser");var _29=ps.options;var ws="{\"position\": [0, 0], \"extent\": 70}";if(_28==null){_29.length=1;_29[0]=new Option("World",ws);}else{_29.length=_28.length+1;_29[0]=new Option("World",ws);var s="{\"position\": [%lo, %la], \"extent\": 0.2}";for(var i=0;i<_28.length;i++){var _2a=_28[i];var lon=parseFloat(_2a.longitude);var lat=parseFloat(_2a.latitude);var os=s.replace("%lo",lon).replace("%la",lat);_29[i+1]=new Option(_2a.name,os);}}},toggleLayerVisibility:function(_2b){var cb=_6.byId(_2b);var a=this._map.getLayer("name",_2b);_4.forEach(a,function(_2c,_2d,_2e){_2c.olLayer.setVisibility(cb.checked);});}});});},"dojox/geo/openlayers/Map":function(){define(["dojo/_base/kernel","dojo/_base/declare","dojo/_base/lang","dojo/_base/array","dojo/_base/json","dojo/dom","dojo/dom-style","./_base","./TouchInteractionSupport","./Layer","./Patch"],function(_2f,_30,_31,_32,_33,dom,_34,_35,_36,_37,_38){_2f.experimental("dojox.geo.openlayers.Map");_38.patchGFX();return _30("dojox.geo.openlayers.Map",null,{olMap:null,_tp:null,constructor:function(div,_39){if(!_39){_39={};}div=dom.byId(div);this._tp={x:0,y:0};var _3a=_39.openLayersMapOptions;if(!_3a){_3a={controls:[new OpenLayers.Control.ScaleLine({maxWidth:200}),new OpenLayers.Control.Navigation()]};}if(_39.accessible){var kbd=new OpenLayers.Control.KeyboardDefaults();if(!_3a.controls){_3a.controls=[];}_3a.controls.push(kbd);}var _3b=_39.baseLayerType;if(!_3b){_3b=_35.BaseLayerType.OSM;}var map=new OpenLayers.Map(div,_3a);this.olMap=map;this._layerDictionary={olLayers:[],layers:[]};if(_39.touchHandler){this._touchControl=new _36(map);}var _3c=this._createBaseLayer(_39);this.addLayer(_3c);this.initialFit(_39);},initialFit:function(_3d){var o=_3d.initialLocation;if(!o){o=[-160,70,160,-70];}this.fitTo(o);},setBaseLayerType:function(_3e){if(_3e==this.baseLayerType){return null;}var o=null;if(typeof _3e=="string"){o={baseLayerName:_3e,baseLayerType:_3e};this.baseLayerType=_3e;}else{if(typeof _3e=="object"){o=_3e;this.baseLayerType=o.baseLayerType;}}var bl=null;if(o!=null){bl=this._createBaseLayer(o);if(bl!=null){var olm=this.olMap;var ob=olm.getZoom();var oc=olm.getCenter();var _3f=!!oc&&!!olm.baseLayer&&!!olm.baseLayer.map;if(_3f){var _40=olm.getProjectionObject();if(_40!=null){oc=oc.transform(_40,_35.EPSG4326);}}var old=olm.baseLayer;if(old!=null){var l=this._getLayer(old);this.removeLayer(l);}if(bl!=null){this.addLayer(bl);}if(_3f){_40=olm.getProjectionObject();if(_40!=null){oc=oc.transform(_35.EPSG4326,_40);}olm.setCenter(oc,ob);}}}return bl;},getBaseLayerType:function(){return this.baseLayerType;},getScale:function(_41){var _42=null;var om=this.olMap;if(_41){var _43=om.getUnits();if(!_43){return null;}var _44=OpenLayers.INCHES_PER_UNIT;_42=(om.getGeodesicPixelSize().w||0.000001)*_44["km"]*OpenLayers.DOTS_PER_INCH;}else{_42=om.getScale();}return _42;},getOLMap:function(){return this.olMap;},_createBaseLayer:function(_45){var _46=null;var _47=_45.baseLayerType;var url=_45.baseLayerUrl;var _48=_45.baseLayerName;var _49=_45.baseLayerOptions;if(!_48){_48=_47;}if(!_49){_49={};}switch(_47){case _35.BaseLayerType.OSM:_49.transitionEffect="resize";_46=new _37(_48,{olLayer:new OpenLayers.Layer.OSM(_48,url,_49)});break;case _35.BaseLayerType.Transport:_49.transitionEffect="resize";_46=new _37(_48,{olLayer:new OpenLayers.Layer.OSM.TransportMap(_48,url,_49)});break;case _35.BaseLayerType.WMS:if(!url){url="http://labs.metacarta.com/wms/vmap0";if(!_49.layers){_49.layers="basic";}}_46=new _37(_48,{olLayer:new OpenLayers.Layer.WMS(_48,url,_49,{transitionEffect:"resize"})});break;case _35.BaseLayerType.GOOGLE:_46=new _37(_48,{olLayer:new OpenLayers.Layer.Google(_48,_49)});break;case _35.BaseLayerType.VIRTUAL_EARTH:_46=new _37(_48,{olLayer:new OpenLayers.Layer.VirtualEarth(_48,_49)});break;case _35.BaseLayerType.YAHOO:_46=new _37(_48,{olLayer:new OpenLayers.Layer.Yahoo(_48,_49)});break;case _35.BaseLayerType.ARCGIS:if(!url){url="http://server.arcgisonline.com/ArcGIS/rest/services/ESRI_StreetMap_World_2D/MapServer/export";}_46=new _37(_48,{olLayer:new OpenLayers.Layer.ArcGIS93Rest(_48,url,_49,{})});break;}if(_46==null){if(_47 instanceof OpenLayers.Layer){_46=_47;}else{_49.transitionEffect="resize";_46=new _37(_48,{olLayer:new OpenLayers.Layer.OSM(_48,url,_49)});this.baseLayerType=_35.BaseLayerType.OSM;}}return _46;},removeLayer:function(_4a){var om=this.olMap;var i=_32.indexOf(this._layerDictionary.layers,_4a);if(i>0){this._layerDictionary.layers.splice(i,1);}var oll=_4a.olLayer;var j=_32.indexOf(this._layerDictionary.olLayers,oll);if(j>0){this._layerDictionary.olLayers.splice(i,j);}om.removeLayer(oll,false);},layerIndex:function(_4b,_4c){var olm=this.olMap;if(!_4c){return olm.getLayerIndex(_4b.olLayer);}olm.setLayerIndex(_4b.olLayer,_4c);this._layerDictionary.layers.sort(function(l1,l2){return olm.getLayerIndex(l1.olLayer)-olm.getLayerIndex(l2.olLayer);});this._layerDictionary.olLayers.sort(function(l1,l2){return olm.getLayerIndex(l1)-olm.getLayerIndex(l2);});return _4c;},addLayer:function(_4d){_4d.dojoMap=this;var om=this.olMap;var ol=_4d.olLayer;this._layerDictionary.olLayers.push(ol);this._layerDictionary.layers.push(_4d);om.addLayer(ol);_4d.added();},_getLayer:function(ol){var i=_32.indexOf(this._layerDictionary.olLayers,ol);if(i!=-1){return this._layerDictionary.layers[i];}return null;},getLayer:function(_4e,_4f){var om=this.olMap;var ols=om.getBy("layers",_4e,_4f);var ret=new Array();_32.forEach(ols,function(ol){ret.push(this._getLayer(ol));},this);return ret;},getLayerCount:function(){var om=this.olMap;if(om.layers==null){return 0;}return om.layers.length;},fitTo:function(o){var map=this.olMap;var _50=_35.EPSG4326;if(o==null){var c=this.transformXY(0,0,_50);map.setCenter(new OpenLayers.LonLat(c.x,c.y));return;}var b=null;if(typeof o=="string"){var j=_33.fromJson(o);}else{j=o;}var ul;var lr;if(j.hasOwnProperty("bounds")){var a=j.bounds;b=new OpenLayers.Bounds();ul=this.transformXY(a[0],a[1],_50);b.left=ul.x;b.top=ul.y;lr=this.transformXY(a[2],a[3],_50);b.right=lr.x;b.bottom=lr.y;}if(b==null){if(j.hasOwnProperty("position")){var p=j.position;var e=j.hasOwnProperty("extent")?j.extent:1;if(typeof e=="string"){e=parseFloat(e);}b=new OpenLayers.Bounds();ul=this.transformXY(p[0]-e,p[1]+e,_50);b.left=ul.x;b.top=ul.y;lr=this.transformXY(p[0]+e,p[1]-e,_50);b.right=lr.x;b.bottom=lr.y;}}if(b==null){if(o.length==4){b=new OpenLayers.Bounds();if(false){b.left=o[0];b.top=o[1];b.right=o[2];b.bottom=o[3];}else{ul=this.transformXY(o[0],o[1],_50);b.left=ul.x;b.top=ul.y;lr=this.transformXY(o[2],o[3],_50);b.right=lr.x;b.bottom=lr.y;}}}if(b!=null){map.zoomToExtent(b,true);}},transform:function(p,_51,to){return this.transformXY(p.x,p.y,_51,to);},transformXY:function(x,y,_52,to){var tp=this._tp;tp.x=x;tp.y=y;if(!_52){_52=_35.EPSG4326;}if(!to){to=this.olMap.getProjectionObject();}tp=OpenLayers.Projection.transform(tp,_52,to);return tp;}});});},"dojox/geo/openlayers/_base":function(){define(["dojo/_base/lang"],function(_53){var _54=_53.getObject("dojox.geo.openlayers",true);_54.BaseLayerType={OSM:"OSM",Transport:"OSM.Transport",WMS:"WMS",GOOGLE:"Google",VIRTUAL_EARTH:"VirtualEarth",BING:"VirtualEarth",YAHOO:"Yahoo",ARCGIS:"ArcGIS"};_54.EPSG4326=new OpenLayers.Projection("EPSG:4326");var re=/^\s*(\d{1,3})[D°]\s*(\d{1,2})[M']\s*(\d{1,2}\.?\d*)\s*(S|"|'')\s*([NSEWnsew]{0,1})\s*$/i;_54.parseDMS=function(v,_55){var res=re.exec(v);if(res==null||res.length<5){return parseFloat(v);}var d=parseFloat(res[1]);var m=parseFloat(res[2]);var s=parseFloat(res[3]);var _56=res[5];if(_55){var lc=_56.toLowerCase();var dd=d+(m+s/60)/60;if(lc=="w"||lc=="s"){dd=-dd;}return dd;}return [d,m,s,_56];};return _54;});},"dojox/geo/openlayers/TouchInteractionSupport":function(){define(["dojo/_base/declare","dojo/_base/connect","dojo/_base/html","dojo/_base/lang","dojo/_base/event","dojo/_base/window"],function(_57,_58,_59,_5a,_5b,win){return _57("dojox.geo.openlayers.TouchInteractionSupport",null,{_map:null,_centerTouchLocation:null,_touchMoveListener:null,_touchEndListener:null,_initialFingerSpacing:null,_initialScale:null,_tapCount:null,_tapThreshold:null,_lastTap:null,constructor:function(map){this._map=map;this._centerTouchLocation=new OpenLayers.LonLat(0,0);var div=this._map.div;_58.connect(div,"touchstart",this,this._touchStartHandler);_58.connect(div,"touchmove",this,this._touchMoveHandler);_58.connect(div,"touchend",this,this._touchEndHandler);this._tapCount=0;this._lastTap={x:0,y:0};this._tapThreshold=100;},_getTouchBarycenter:function(_5c){var _5d=_5c.touches;var _5e=_5d[0];var _5f=null;if(_5d.length>1){_5f=_5d[1];}else{_5f=_5d[0];}var _60=_59.marginBox(this._map.div);var _61=(_5e.pageX+_5f.pageX)/2-_60.l;var _62=(_5e.pageY+_5f.pageY)/2-_60.t;return {x:_61,y:_62};},_getFingerSpacing:function(_63){var _64=_63.touches;var _65=-1;if(_64.length>=2){var dx=(_64[1].pageX-_64[0].pageX);var dy=(_64[1].pageY-_64[0].pageY);_65=Math.sqrt(dx*dx+dy*dy);}return _65;},_isDoubleTap:function(_66){var _67=false;var _68=_66.touches;if((this._tapCount>0)&&_68.length==1){var dx=(_68[0].pageX-this._lastTap.x);var dy=(_68[0].pageY-this._lastTap.y);var _69=dx*dx+dy*dy;if(_69<this._tapThreshold){_67=true;}else{this._tapCount=0;}}this._tapCount++;this._lastTap.x=_68[0].pageX;this._lastTap.y=_68[0].pageY;setTimeout(_5a.hitch(this,function(){this._tapCount=0;}),300);return _67;},_doubleTapHandler:function(_6a){var _6b=_6a.touches;var _6c=_59.marginBox(this._map.div);var _6d=_6b[0].pageX-_6c.l;var _6e=_6b[0].pageY-_6c.t;var _6f=this._map.getLonLatFromPixel(new OpenLayers.Pixel(_6d,_6e));this._map.setCenter(new OpenLayers.LonLat(_6f.lon,_6f.lat),this._map.getZoom()+1);},_touchStartHandler:function(_70){_5b.stop(_70);if(this._isDoubleTap(_70)){this._doubleTapHandler(_70);return;}var _71=this._getTouchBarycenter(_70);this._centerTouchLocation=this._map.getLonLatFromPixel(new OpenLayers.Pixel(_71.x,_71.y));this._initialFingerSpacing=this._getFingerSpacing(_70);this._initialScale=this._map.getScale();if(!this._touchMoveListener){this._touchMoveListener=_58.connect(win.global,"touchmove",this,this._touchMoveHandler);}if(!this._touchEndListener){this._touchEndListener=_58.connect(win.global,"touchend",this,this._touchEndHandler);}},_touchEndHandler:function(_72){_5b.stop(_72);var _73=_72.touches;if(_73.length==0){if(this._touchMoveListener){_58.disconnect(this._touchMoveListener);this._touchMoveListener=null;}if(this._touchEndListener){_58.disconnect(this._touchEndListener);this._touchEndListener=null;}}else{var _74=this._getTouchBarycenter(_72);this._centerTouchLocation=this._map.getLonLatFromPixel(new OpenLayers.Pixel(_74.x,_74.y));}},_touchMoveHandler:function(_75){_5b.stop(_75);var _76=this._getTouchBarycenter(_75);var _77=this._map.getLonLatFromPixel(new OpenLayers.Pixel(_76.x,_76.y));var _78=_77.lon-this._centerTouchLocation.lon;var _79=_77.lat-this._centerTouchLocation.lat;var _7a=1;var _7b=_75.touches;if(_7b.length>=2){var _7c=this._getFingerSpacing(_75);_7a=_7c/this._initialFingerSpacing;this._map.zoomToScale(this._initialScale/_7a);}var _7d=this._map.getCenter();this._map.setCenter(new OpenLayers.LonLat(_7d.lon-_78,_7d.lat-_79));}});});},"dojox/geo/openlayers/Layer":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/_base/array","dojo/_base/sniff","./Feature"],function(_7e,_7f,_80,_81,_82){return _7e("dojox.geo.openlayers.Layer",null,{constructor:function(_83,_84){var ol=_84?_84.olLayer:null;if(!ol){ol=_7f.delegate(new OpenLayers.Layer(_83,_84));}this.olLayer=ol;this._features=null;this.olLayer.events.register("moveend",this,_7f.hitch(this,this.moveTo));},renderFeature:function(f){f.render();},getDojoMap:function(){return this.dojoMap;},addFeature:function(f){if(_7f.isArray(f)){_80.forEach(f,function(_85){this.addFeature(_85);},this);return;}if(this._features==null){this._features=[];}this._features.push(f);f._setLayer(this);},removeFeature:function(f){var ft=this._features;if(ft==null){return;}if(f instanceof Array){f=f.slice(0);_80.forEach(f,function(_86){this.removeFeature(_86);},this);return;}var i=_80.indexOf(ft,f);if(i!=-1){ft.splice(i,1);}f._setLayer(null);f.remove();},removeFeatureAt:function(_87){var ft=this._features;var f=ft[_87];if(!f){return;}ft.splice(_87,1);f._setLayer(null);f.remove();},getFeatures:function(){return this._features;},getFeatureAt:function(i){if(this._features==null){return undefined;}return this._features[i];},getFeatureCount:function(){if(this._features==null){return 0;}return this._features.length;},clear:function(){var fa=this.getFeatures();this.removeFeature(fa);},moveTo:function(_88){if(_88.zoomChanged){if(this._features==null){return;}_80.forEach(this._features,function(f){this.renderFeature(f);},this);}},redraw:function(){if(_81.isIE){setTimeout(_7f.hitch(this,function(){this.olLayer.redraw();},0));}else{this.olLayer.redraw();}},added:function(){}});});},"dojox/geo/openlayers/Feature":function(){define(["dojo/_base/kernel","dojo/_base/declare","./_base"],function(_89,_8a,_8b){return _8a("dojox.geo.openlayers.Feature",null,{constructor:function(){this._layer=null;this._coordSys=_8b.EPSG4326;},getCoordinateSystem:function(){return this._coordSys;},setCoordinateSystem:function(cs){this._coordSys=cs;},getLayer:function(){return this._layer;},_setLayer:function(l){this._layer=l;},render:function(){},remove:function(){},_getLocalXY:function(p){var x=p.x;var y=p.y;var _8c=this.getLayer();var _8d=_8c.olLayer.map.getResolution();var _8e=_8c.olLayer.getExtent();var rx=(x/_8d+(-_8e.left/_8d));var ry=((_8e.top/_8d)-y/_8d);return [rx,ry];}});});},"dojox/geo/openlayers/Patch":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/sniff","dojox/gfx","dojox/gfx/shape"],function(_8f,_90,_91,gfx,_92){var dgo=_90.getObject("geo.openlayers",true,dojox);dgo.Patch={patchMethod:function(_93,_94,_95,_96){var old=_93.prototype[_94];_93.prototype[_94]=function(){var _97=_94;if(_95){_95.call(this,_97,arguments);}var ret=old.apply(this,arguments);if(_96){ret=_96.call(this,_97,ret,arguments)||ret;}return ret;};},patchGFX:function(){var _98=function(){if(!this.rawNode.path){this.rawNode.path={};}};var _99=function(){if(this.rawNode.fill&&!this.rawNode.fill.colors){this.rawNode.fill.colors={};}};if(_91.isIE<=8&&gfx.renderer==="vml"){this.patchMethod(gfx.Line,"setShape",_98,null);this.patchMethod(gfx.Polyline,"setShape",_98,null);this.patchMethod(gfx.Path,"setShape",_98,null);this.patchMethod(_92.Shape,"setFill",_99,null);}}};return dgo.Patch;});},"dojox/gfx":function(){define(["dojo/_base/lang","./gfx/_base","./gfx/renderer!"],function(_9a,_9b,_9c){_9b.switchTo(_9c);return _9b;});},"dojox/gfx/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(_9d,_9e,_9f,has,win,arr,dom,_a0,_a1){var g=_9e.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(_a2,_a3){var cls=_a2.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_a3+" ")>=0;};g._addClass=function(_a4,_a5){var cls=_a4.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_a5+" ")<0){_a4.setAttribute("className",cls+(cls?" ":"")+_a5);}};g._removeClass=function(_a6,_a7){var cls=_a6.getAttribute("className");if(cls){_a6.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_a7+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _a8={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p,_a9;if(has("ie")){_a9=win.doc.documentElement.style.fontSize||"";if(!_a9){win.doc.documentElement.style.fontSize="100%";}}var div=_a0.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _a8){div.style.fontSize=p;_a8[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}if(has("ie")){win.doc.documentElement.style.fontSize=_a9;}win.body().removeChild(div);return _a8;};var _aa=null;b._getCachedFontMeasurements=function(_ab){if(_ab||!_aa){_aa=b._getFontMeasurements();}return _aa;};var _ac=null,_ad={};b._getTextBox=function(_ae,_af,_b0){var m,s,al=arguments.length;var i,box;if(!_ac){_ac=_a0.create("div",{style:{position:"absolute",top:"-10000px",left:"0",visibility:"hidden"}},win.body());}m=_ac;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_af){for(i in _af){if(i in _ad){continue;}s[i]=_af[i];}}if(al>2&&_b0){m.className=_b0;}m.innerHTML=_ae;if(m.getBoundingClientRect){var bcr=m.getBoundingClientRect();box={l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{box=_a1.getMarginBox(m);}m.innerHTML="";return box;};b._computeTextLocation=function(_b1,_b2,_b3,_b4){var loc={},_b5=_b1.align;switch(_b5){case "end":loc.x=_b1.x-_b2;break;case "middle":loc.x=_b1.x-_b2/2;break;default:loc.x=_b1.x;break;}var c=_b4?0.75:1;loc.y=_b1.y-_b3*c;return loc;};b._computeTextBoundingBox=function(s){if(!g._base._isRendered(s)){return {x:0,y:0,width:0,height:0};}var loc,_b6=s.getShape(),_b7=s.getFont()||g.defaultFont,w=s.getTextWidth(),h=g.normalizedLength(_b7.size);loc=b._computeTextLocation(_b6,w,h,true);return {x:loc.x,y:loc.y,width:w,height:h};};b._isRendered=function(s){var p=s.parent;while(p&&p.getParent){p=p.parent;}return p!==null;};var _b8=0;b._getUniqueId=function(){var id;do{id=_9d._scopeName+"xUnique"+(++_b8);}while(dom.byId(id));return id;};var _b9=has("pointer-events")?"touchAction":has("MSPointer")?"msTouchAction":null;b._fixMsTouchAction=_b9?function(_ba){_ba.rawNode.style[_b9]="none";}:function(){};_9e.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _bb={};return function(_bc){var t=_bb[_bc];if(t){return new t();}t=_bb[_bc]=function(){};t.prototype=g["default"+_bc];return new t();};})(),normalizeColor:function(_bd){return (_bd instanceof _9f)?_bd:new _9f(_bd);},normalizeParameters:function(_be,_bf){var x;if(_bf){var _c0={};for(x in _be){if(x in _bf&&!(x in _c0)){_be[x]=_bf[x];}}}return _be;},makeParameters:function(_c1,_c2){var i=null;if(!_c2){return _9e.delegate(_c1);}var _c3={};for(i in _c1){if(!(i in _c3)){_c3[i]=_9e.clone((i in _c2)?_c2[i]:_c1[i]);}}return _c3;},formatNumber:function(x,_c4){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _c5=val.indexOf(".");if(_c5>=0&&val.length-_c5>5){val=x.toFixed(4);}}if(x<0){return val;}return _c4?" "+val:val;},makeFontString:function(_c6){return _c6.style+" "+_c6.variant+" "+_c6.weight+" "+_c6.size+" "+_c6.family;},splitFontString:function(str){var _c7=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}_c7.style=t[0];_c7.variant=t[1];_c7.weight=t[2];var i=t[3].indexOf("/");_c7.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){_c7.family=t.slice(j).join(" ");}}while(false);return _c7;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _c8=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_c8;case "in":return val*72*_c8;case "pc":return val*12*_c8;case "mm":return val*g.mm_in_pt*_c8;case "cm":return val*g.cm_in_pt*_c8;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-DF-Za-df-z])|([-+]?\d*[.]?\d+(?:[eE][-+]?\d+)?)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_c9){var ns=typeof _c9=="string"?g[_c9]:_c9;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(_ca){g[_ca]=ns[_ca];});if(typeof _c9=="string"){g.renderer=_c9;}else{arr.some(["svg","vml","canvas","canvasWithEvents","silverlight"],function(r){return (g.renderer=g[r]&&g[r].Surface===g.Surface?r:null);});}}}});return g;});},"dojox/gfx/renderer":function(){define(["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,_cb,has,win,_cc){var _cd=null;has.add("vml",function(_ce,_cf,_d0){_d0.innerHTML="<v:shape adj=\"1\"/>";var _d1=("adj" in _d0.firstChild);_d0.innerHTML="";return _d1;});return {load:function(id,_d2,_d3){if(_cd&&id!="force"){_d3(_cd);return;}var _d4=_cc.forceGfxRenderer,_d5=!_d4&&(_cb.isString(_cc.gfxRenderer)?_cc.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_d6,_d7;while(!_d4&&_d5.length){switch(_d5.shift()){case "svg":if("SVGAngle" in win.global){_d4="svg";}break;case "vml":if(has("vml")){_d4="vml";}break;case "silverlight":try{if(has("ie")){_d6=new ActiveXObject("AgControl.AgControl");if(_d6&&_d6.IsVersionSupported("1.0")){_d7=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_d7=true;}}}catch(e){_d7=false;}finally{_d6=null;}if(_d7){_d4="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_d4="canvas";}break;}}if(_d4==="canvas"&&_cc.canvasEvents!==false){_d4="canvasWithEvents";}if(_cc.isDebug){}function _d8(){_d2(["dojox/gfx/"+_d4],function(_d9){g.renderer=_d4;_cd=_d9;_d3(_d9);});};if(_d4=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_d8);}else{_d8();}}};});},"dojox/gfx/shape":function(){define(["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/kernel","dojo/_base/sniff","dojo/on","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,_da,_db,_dc,has,on,arr,_dd,_de,_df){function _e0(a,_e1){var len=(a.length-1);while(_e1<len){a[_e1]=a[++_e1];}a.length=len;};var _e2=g.shape={};_e2.Shape=_db("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;if(has("gfxRegistry")){var uid=_e2.register(this);this.getUID=function(){return uid;};}},destroy:function(){if(has("gfxRegistry")){_e2.dispose(this);}if(this.rawNode&&"__gfxObject__" in this.rawNode){this.rawNode.__gfxObject__=null;}this.rawNode=null;},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_df;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setClip:function(_e3){this.clip=_e3;},getClip:function(){return this.clip;},setShape:function(_e4){this.shape=g.makeParameters(this.shape,_e4);this.bbox=null;return this;},setFill:function(_e5){if(!_e5){this.fillStyle=null;return this;}var f=null;if(typeof (_e5)=="object"&&"type" in _e5){switch(_e5.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,_e5);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,_e5);break;case "pattern":f=g.makeParameters(g.defaultPattern,_e5);break;}}else{f=g.normalizeColor(_e5);}this.fillStyle=f;return this;},setStroke:function(_e6){if(!_e6){this.strokeStyle=null;return this;}if(typeof _e6=="string"||_da.isArray(_e6)||_e6 instanceof _de){_e6={color:_e6};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_e6);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_e7){this.matrix=_df.clone(_e7?_df.normalize(_e7):_df.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_e8){return _e8?this.setTransform([this.matrix,_e8]):this;},applyLeftTransform:function(_e9){return _e9?this.setTransform([_e9,this.matrix]):this;},applyTransform:function(_ea){return _ea?this.setTransform([this.matrix,_ea]):this;},removeShape:function(_eb){if(this.parent){this.parent.remove(this,_eb);}return this;},_setParent:function(_ec,_ed){this.parent=_ec;return this._updateParentMatrix(_ed);},_updateParentMatrix:function(_ee){this.parentMatrix=_ee?_df.clone(_ee):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_df.multiply(p.matrix,m);}p=p.parent;}return m;}});_e2._eventsProcessing={on:function(_ef,_f0){return on(this.getEventSource(),_ef,_e2.fixCallback(this,g.fixTarget,_f0));},connect:function(_f1,_f2,_f3){if(_f1.substring(0,2)=="on"){_f1=_f1.substring(2);}return this.on(_f1,_f3?_da.hitch(_f2,_f3):_f2);},disconnect:function(_f4){return _f4.remove();}};_e2.fixCallback=function(_f5,_f6,_f7,_f8){if(!_f8){_f8=_f7;_f7=null;}if(_da.isString(_f8)){_f7=_f7||_dc.global;if(!_f7[_f8]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_f8,"\"] is null (scope=\"",_f7,"\")"].join(""));}return function(e){return _f6(e,_f5)?_f7[_f8].apply(_f7,arguments||[]):undefined;};}return !_f7?function(e){return _f6(e,_f5)?_f8.apply(_f7,arguments):undefined;}:function(e){return _f6(e,_f5)?_f8.apply(_f7,arguments||[]):undefined;};};_da.extend(_e2.Shape,_e2._eventsProcessing);_e2.Container={_init:function(){this.children=[];this._batch=0;},openBatch:function(){return this;},closeBatch:function(){return this;},add:function(_f9){var _fa=_f9.getParent();if(_fa){_fa.remove(_f9,true);}this.children.push(_f9);return _f9._setParent(this,this._getRealMatrix());},remove:function(_fb,_fc){for(var i=0;i<this.children.length;++i){if(this.children[i]==_fb){if(_fc){}else{_fb.parent=null;_fb.parentMatrix=null;}_e0(this.children,i);break;}}return this;},clear:function(_fd){var _fe;for(var i=0;i<this.children.length;++i){_fe=this.children[i];_fe.parent=null;_fe.parentMatrix=null;if(_fd){_fe.destroy();}}this.children=[];return this;},getBoundingBox:function(){if(this.children){var _ff=null;arr.forEach(this.children,function(_100){var bb=_100.getBoundingBox();if(bb){var ct=_100.getTransform();if(ct){bb=_df.multiplyRectangle(ct,bb);}if(_ff){_ff.x=Math.min(_ff.x,bb.x);_ff.y=Math.min(_ff.y,bb.y);_ff.endX=Math.max(_ff.endX,bb.x+bb.width);_ff.endY=Math.max(_ff.endY,bb.y+bb.height);}else{_ff={x:bb.x,y:bb.y,endX:bb.x+bb.width,endY:bb.y+bb.height};}}});if(_ff){_ff.width=_ff.endX-_ff.x;_ff.height=_ff.endY-_ff.y;}return _ff;}return null;},_moveChildToFront:function(_101){for(var i=0;i<this.children.length;++i){if(this.children[i]==_101){_e0(this.children,i);this.children.push(_101);break;}}return this;},_moveChildToBack:function(_102){for(var i=0;i<this.children.length;++i){if(this.children[i]==_102){_e0(this.children,i);this.children.unshift(_102);break;}}return this;}};_e2.Surface=_db("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){arr.forEach(this._nodes,_dd.destroy);this._nodes=[];arr.forEach(this._events,function(h){if(h){h.remove();}});this._events=[];this.rawNode=null;if(has("ie")){while(this._parent.lastChild){_dd.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_103){},whenLoaded:function(_104,_105){var f=_da.hitch(_104,_105);if(this.isLoaded){f(this);}else{on.once(this,"load",function(_106){f(_106);});}}});_da.extend(_e2.Surface,_e2._eventsProcessing);_e2.Rect=_db("dojox.gfx.shape.Rect",_e2.Shape,{constructor:function(_107){this.shape=g.getDefault("Rect");this.rawNode=_107;},getBoundingBox:function(){return this.shape;}});_e2.Ellipse=_db("dojox.gfx.shape.Ellipse",_e2.Shape,{constructor:function(_108){this.shape=g.getDefault("Ellipse");this.rawNode=_108;},getBoundingBox:function(){if(!this.bbox){var _109=this.shape;this.bbox={x:_109.cx-_109.rx,y:_109.cy-_109.ry,width:2*_109.rx,height:2*_109.ry};}return this.bbox;}});_e2.Circle=_db("dojox.gfx.shape.Circle",_e2.Shape,{constructor:function(_10a){this.shape=g.getDefault("Circle");this.rawNode=_10a;},getBoundingBox:function(){if(!this.bbox){var _10b=this.shape;this.bbox={x:_10b.cx-_10b.r,y:_10b.cy-_10b.r,width:2*_10b.r,height:2*_10b.r};}return this.bbox;}});_e2.Line=_db("dojox.gfx.shape.Line",_e2.Shape,{constructor:function(_10c){this.shape=g.getDefault("Line");this.rawNode=_10c;},getBoundingBox:function(){if(!this.bbox){var _10d=this.shape;this.bbox={x:Math.min(_10d.x1,_10d.x2),y:Math.min(_10d.y1,_10d.y2),width:Math.abs(_10d.x2-_10d.x1),height:Math.abs(_10d.y2-_10d.y1)};}return this.bbox;}});_e2.Polyline=_db("dojox.gfx.shape.Polyline",_e2.Shape,{constructor:function(_10e){this.shape=g.getDefault("Polyline");this.rawNode=_10e;},setShape:function(_10f,_110){if(_10f&&_10f instanceof Array){this.inherited(arguments,[{points:_10f}]);if(_110&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_10f]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _111=[];for(var i=0;i<l;i+=2){_111.push({x:p[i],y:p[i+1]});}this.shape.points=_111;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var bbox={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(bbox.l>t.x){bbox.l=t.x;}if(bbox.r<t.x){bbox.r=t.x;}if(bbox.t>t.y){bbox.t=t.y;}if(bbox.b<t.y){bbox.b=t.y;}}this.bbox={x:bbox.l,y:bbox.t,width:bbox.r-bbox.l,height:bbox.b-bbox.t};}return this.bbox;}});_e2.Image=_db("dojox.gfx.shape.Image",_e2.Shape,{constructor:function(_112){this.shape=g.getDefault("Image");this.rawNode=_112;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_e2.Text=_db(_e2.Shape,{constructor:function(_113){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_113;},getFont:function(){return this.fontStyle;},setFont:function(_114){this.fontStyle=typeof _114=="string"?g.splitFontString(_114):g.makeParameters(g.defaultFont,_114);this._setFont();return this;},getBoundingBox:function(){var bbox=null,s=this.getShape();if(s.text){bbox=g._base._computeTextBoundingBox(this);}return bbox;}});_e2.Creator={createShape:function(_115){switch(_115.type){case g.defaultPath.type:return this.createPath(_115);case g.defaultRect.type:return this.createRect(_115);case g.defaultCircle.type:return this.createCircle(_115);case g.defaultEllipse.type:return this.createEllipse(_115);case g.defaultLine.type:return this.createLine(_115);case g.defaultPolyline.type:return this.createPolyline(_115);case g.defaultImage.type:return this.createImage(_115);case g.defaultText.type:return this.createText(_115);case g.defaultTextPath.type:return this.createTextPath(_115);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(rect){return this.createObject(g.Rect,rect);},createEllipse:function(_116){return this.createObject(g.Ellipse,_116);},createCircle:function(_117){return this.createObject(g.Circle,_117);},createLine:function(line){return this.createObject(g.Line,line);},createPolyline:function(_118){return this.createObject(g.Polyline,_118);},createImage:function(_119){return this.createObject(g.Image,_119);},createText:function(text){return this.createObject(g.Text,text);},createPath:function(path){return this.createObject(g.Path,path);},createTextPath:function(text){return this.createObject(g.TextPath,{}).setText(text);},createObject:function(_11a,_11b){return null;}};return _e2;});},"dojox/gfx/matrix":function(){define(["./_base","dojo/_base/lang"],function(g,lang){var m=g.matrix={};var _11c={};m._degToRad=function(_11d){return _11c[_11d]||(_11c[_11d]=(Math.PI*_11d/180));};m._radToDeg=function(_11e){return _11e/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else{if(arg instanceof Array){if(arg.length>0){var _11f=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=_11f,r=m.normalize(arg[i]);_11f=new m.Matrix2D();_11f.xx=l.xx*r.xx+l.xy*r.yx;_11f.xy=l.xx*r.xy+l.xy*r.yy;_11f.yx=l.yx*r.xx+l.yy*r.yx;_11f.yy=l.yx*r.xy+l.yy*r.yy;_11f.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_11f.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}lang.mixin(this,_11f);}}else{lang.mixin(this,arg);}}}};lang.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});lang.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_120){var c=Math.cos(_120);var s=Math.sin(_120);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_121){return m.rotate(m._degToRad(_121));},skewX:function(_122){return new m.Matrix2D({xy:Math.tan(_122)});},skewXg:function(_123){return m.skewX(m._degToRad(_123));},skewY:function(_124){return new m.Matrix2D({yx:Math.tan(_124)});},skewYg:function(_125){return m.skewY(m._degToRad(_125));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_126){return (_126 instanceof m.Matrix2D)?_126:new m.Matrix2D(_126);},isIdentity:function(_127){return _127.xx==1&&_127.xy==0&&_127.yx==0&&_127.yy==1&&_127.dx==0&&_127.dy==0;},clone:function(_128){var obj=new m.Matrix2D();for(var i in _128){if(typeof (_128[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_128[i]){obj[i]=_128[i];}}return obj;},invert:function(_129){var M=m.normalize(_129),D=M.xx*M.yy-M.xy*M.yx;M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_12a,x,y){return {x:_12a.xx*x+_12a.xy*y+_12a.dx,y:_12a.yx*x+_12a.yy*y+_12a.dy};},multiplyPoint:function(_12b,a,b){var M=m.normalize(_12b);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiplyRectangle:function(_12c,rect){var M=m.normalize(_12c);rect=rect||{x:0,y:0,width:0,height:0};if(m.isIdentity(M)){return {x:rect.x,y:rect.y,width:rect.width,height:rect.height};}var p0=m.multiplyPoint(M,rect.x,rect.y),p1=m.multiplyPoint(M,rect.x,rect.y+rect.height),p2=m.multiplyPoint(M,rect.x+rect.width,rect.y),p3=m.multiplyPoint(M,rect.x+rect.width,rect.y+rect.height),minx=Math.min(p0.x,p1.x,p2.x,p3.x),miny=Math.min(p0.y,p1.y,p2.y,p3.y),maxx=Math.max(p0.x,p1.x,p2.x,p3.x),maxy=Math.max(p0.y,p1.y,p2.y,p3.y);return {x:minx,y:miny,width:maxx-minx,height:maxy-miny};},multiply:function(_12d){var M=m.normalize(_12d);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_12e,x,y){return m.multiply(m.translate(x,y),_12e,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_12f,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_12f),a,b);}return m._sandwich(m.rotate(_12f),a.x,a.y);},rotategAt:function(_130,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_130),a,b);}return m._sandwich(m.rotateg(_130),a.x,a.y);},skewXAt:function(_131,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_131),a,b);}return m._sandwich(m.skewX(_131),a.x,a.y);},skewXgAt:function(_132,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_132),a,b);}return m._sandwich(m.skewXg(_132),a.x,a.y);},skewYAt:function(_133,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_133),a,b);}return m._sandwich(m.skewY(_133),a.x,a.y);},skewYgAt:function(_134,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_134),a,b);}return m._sandwich(m.skewYg(_134),a.x,a.y);}});g.Matrix2D=m.Matrix2D;return m;});},"dojox/geo/openlayers/GfxLayer":function(){define(["dojo/_base/declare","dojo/_base/connect","dojo/dom-style","dojox/gfx","dojox/gfx/matrix","./Feature","./Layer"],function(_135,_136,_137,gfx,_138,_139,_13a){return _135("dojox.geo.openlayers.GfxLayer",_13a,{_viewport:null,constructor:function(name,_13b){var s=gfx.createSurface(this.olLayer.div,100,100);this._surface=s;var vp;if(_13b&&_13b.viewport){vp=_13b.viewport;}else{vp=s.createGroup();}this.setViewport(vp);_136.connect(this.olLayer,"onMapResize",this,"onMapResize");this.olLayer.getDataExtent=this.getDataExtent;},getViewport:function(){return this._viewport;},setViewport:function(g){if(this._viewport){this._viewport.removeShape();}this._viewport=g;this._surface.add(g);},onMapResize:function(){this._surfaceSize();},setMap:function(map){this.inherited(arguments);this._surfaceSize();},getDataExtent:function(){var ret=this._surface.getDimensions();return ret;},getSurface:function(){return this._surface;},_surfaceSize:function(){var s=this.olLayer.map.getSize();this._surface.setDimensions(s.w,s.h);},moveTo:function(_13c){var s=_137.get(this.olLayer.map.layerContainerDiv);var left=parseInt(s.left);var top=parseInt(s.top);if(_13c.zoomChanged||left||top){var d=this.olLayer.div;_137.set(d,{left:-left+"px",top:-top+"px"});if(this._features==null){return;}var vp=this.getViewport();vp.setTransform(_138.translate(left,top));this.inherited(arguments);}},added:function(){this.inherited(arguments);this._surfaceSize();}});});},"dojo/data/ItemFileReadStore":function(){define(["../_base/kernel","../_base/lang","../_base/declare","../_base/array","../_base/xhr","../Evented","./util/filter","./util/simpleFetch","../date/stamp"],function(_13d,lang,_13e,_13f,xhr,_140,_141,_142,_143){var _144=_13e("dojo.data.ItemFileReadStore",[_140],{constructor:function(_145){this._arrayOfAllItems=[];this._arrayOfTopLevelItems=[];this._loadFinished=false;this._jsonFileUrl=_145.url;this._ccUrl=_145.url;this.url=_145.url;this._jsonData=_145.data;this.data=null;this._datatypeMap=_145.typeMap||{};if(!this._datatypeMap["Date"]){this._datatypeMap["Date"]={type:Date,deserialize:function(_146){return _143.fromISOString(_146);}};}this._features={"dojo.data.api.Read":true,"dojo.data.api.Identity":true};this._itemsByIdentity=null;this._storeRefPropName="_S";this._itemNumPropName="_0";this._rootItemPropName="_RI";this._reverseRefMap="_RRM";this._loadInProgress=false;this._queuedFetches=[];if(_145.urlPreventCache!==undefined){this.urlPreventCache=_145.urlPreventCache?true:false;}if(_145.hierarchical!==undefined){this.hierarchical=_145.hierarchical?true:false;}if(_145.clearOnClose){this.clearOnClose=true;}if("failOk" in _145){this.failOk=_145.failOk?true:false;}},url:"",_ccUrl:"",data:null,typeMap:null,clearOnClose:false,urlPreventCache:false,failOk:false,hierarchical:true,_assertIsItem:function(item){if(!this.isItem(item)){throw new Error(this.declaredClass+": Invalid item argument.");}},_assertIsAttribute:function(_147){if(typeof _147!=="string"){throw new Error(this.declaredClass+": Invalid attribute argument.");}},getValue:function(item,_148,_149){var _14a=this.getValues(item,_148);return (_14a.length>0)?_14a[0]:_149;},getValues:function(item,_14b){this._assertIsItem(item);this._assertIsAttribute(_14b);return (item[_14b]||[]).slice(0);},getAttributes:function(item){this._assertIsItem(item);var _14c=[];for(var key in item){if((key!==this._storeRefPropName)&&(key!==this._itemNumPropName)&&(key!==this._rootItemPropName)&&(key!==this._reverseRefMap)){_14c.push(key);}}return _14c;},hasAttribute:function(item,_14d){this._assertIsItem(item);this._assertIsAttribute(_14d);return (_14d in item);},containsValue:function(item,_14e,_14f){var _150=undefined;if(typeof _14f==="string"){_150=_141.patternToRegExp(_14f,false);}return this._containsValue(item,_14e,_14f,_150);},_containsValue:function(item,_151,_152,_153){return _13f.some(this.getValues(item,_151),function(_154){if(_154!==null&&!lang.isObject(_154)&&_153){if(_154.toString().match(_153)){return true;}}else{if(_152===_154){return true;}}});},isItem:function(_155){if(_155&&_155[this._storeRefPropName]===this){if(this._arrayOfAllItems[_155[this._itemNumPropName]]===_155){return true;}}return false;},isItemLoaded:function(_156){return this.isItem(_156);},loadItem:function(_157){this._assertIsItem(_157.item);},getFeatures:function(){return this._features;},getLabel:function(item){if(this._labelAttr&&this.isItem(item)){return this.getValue(item,this._labelAttr);}return undefined;},getLabelAttributes:function(item){if(this._labelAttr){return [this._labelAttr];}return null;},filter:function(_158,_159,_15a){var _15b=[],i,key;if(_158.query){var _15c,_15d=_158.queryOptions?_158.queryOptions.ignoreCase:false;var _15e={};for(key in _158.query){_15c=_158.query[key];if(typeof _15c==="string"){_15e[key]=_141.patternToRegExp(_15c,_15d);}else{if(_15c instanceof RegExp){_15e[key]=_15c;}}}for(i=0;i<_159.length;++i){var _15f=true;var _160=_159[i];if(_160===null){_15f=false;}else{for(key in _158.query){_15c=_158.query[key];if(!this._containsValue(_160,key,_15c,_15e[key])){_15f=false;}}}if(_15f){_15b.push(_160);}}_15a(_15b,_158);}else{for(i=0;i<_159.length;++i){var item=_159[i];if(item!==null){_15b.push(item);}}_15a(_15b,_158);}},_fetchItems:function(_161,_162,_163){var self=this;if(this._loadFinished){this.filter(_161,this._getItemsArray(_161.queryOptions),_162);}else{if(this._jsonFileUrl!==this._ccUrl){_13d.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");this._ccUrl=this._jsonFileUrl;this.url=this._jsonFileUrl;}else{if(this.url!==this._ccUrl){this._jsonFileUrl=this.url;this._ccUrl=this.url;}}if(this.data!=null){this._jsonData=this.data;this.data=null;}if(this._jsonFileUrl){if(this._loadInProgress){this._queuedFetches.push({args:_161,filter:lang.hitch(self,"filter"),findCallback:lang.hitch(self,_162)});}else{this._loadInProgress=true;var _164={url:self._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk};var _165=xhr.get(_164);_165.addCallback(function(data){try{self._getItemsFromLoadedData(data);self._loadFinished=true;self._loadInProgress=false;self.filter(_161,self._getItemsArray(_161.queryOptions),_162);self._handleQueuedFetches();}catch(e){self._loadFinished=true;self._loadInProgress=false;_163(e,_161);}});_165.addErrback(function(_166){self._loadInProgress=false;_163(_166,_161);});var _167=null;if(_161.abort){_167=_161.abort;}_161.abort=function(){var df=_165;if(df&&df.fired===-1){df.cancel();df=null;}if(_167){_167.call(_161);}};}}else{if(this._jsonData){try{this._loadFinished=true;this._getItemsFromLoadedData(this._jsonData);this._jsonData=null;self.filter(_161,this._getItemsArray(_161.queryOptions),_162);}catch(e){_163(e,_161);}}else{_163(new Error(this.declaredClass+": No JSON source data was provided as either URL or a nested Javascript object."),_161);}}}},_handleQueuedFetches:function(){if(this._queuedFetches.length>0){for(var i=0;i<this._queuedFetches.length;i++){var _168=this._queuedFetches[i],_169=_168.args,_16a=_168.filter,_16b=_168.findCallback;if(_16a){_16a(_169,this._getItemsArray(_169.queryOptions),_16b);}else{this.fetchItemByIdentity(_169);}}this._queuedFetches=[];}},_getItemsArray:function(_16c){if(_16c&&_16c.deep){return this._arrayOfAllItems;}return this._arrayOfTopLevelItems;},close:function(_16d){if(this.clearOnClose&&this._loadFinished&&!this._loadInProgress){if(((this._jsonFileUrl==""||this._jsonFileUrl==null)&&(this.url==""||this.url==null))&&this.data==null){}this._arrayOfAllItems=[];this._arrayOfTopLevelItems=[];this._loadFinished=false;this._itemsByIdentity=null;this._loadInProgress=false;this._queuedFetches=[];}},_getItemsFromLoadedData:function(_16e){var _16f=false,self=this;function _170(_171){return (_171!==null)&&(typeof _171==="object")&&(!lang.isArray(_171)||_16f)&&(!lang.isFunction(_171))&&(_171.constructor==Object||lang.isArray(_171))&&(typeof _171._reference==="undefined")&&(typeof _171._type==="undefined")&&(typeof _171._value==="undefined")&&self.hierarchical;};function _172(_173){self._arrayOfAllItems.push(_173);for(var _174 in _173){var _175=_173[_174];if(_175){if(lang.isArray(_175)){var _176=_175;for(var k=0;k<_176.length;++k){var _177=_176[k];if(_170(_177)){_172(_177);}}}else{if(_170(_175)){_172(_175);}}}}};this._labelAttr=_16e.label;var i,item;this._arrayOfAllItems=[];this._arrayOfTopLevelItems=_16e.items;for(i=0;i<this._arrayOfTopLevelItems.length;++i){item=this._arrayOfTopLevelItems[i];if(lang.isArray(item)){_16f=true;}_172(item);item[this._rootItemPropName]=true;}var _178={},key;for(i=0;i<this._arrayOfAllItems.length;++i){item=this._arrayOfAllItems[i];for(key in item){if(key!==this._rootItemPropName){var _179=item[key];if(_179!==null){if(!lang.isArray(_179)){item[key]=[_179];}}else{item[key]=[null];}}_178[key]=key;}}while(_178[this._storeRefPropName]){this._storeRefPropName+="_";}while(_178[this._itemNumPropName]){this._itemNumPropName+="_";}while(_178[this._reverseRefMap]){this._reverseRefMap+="_";}var _17a;var _17b=_16e.identifier;if(_17b){this._itemsByIdentity={};this._features["dojo.data.api.Identity"]=_17b;for(i=0;i<this._arrayOfAllItems.length;++i){item=this._arrayOfAllItems[i];_17a=item[_17b];var _17c=_17a[0];if(!Object.hasOwnProperty.call(this._itemsByIdentity,_17c)){this._itemsByIdentity[_17c]=item;}else{if(this._jsonFileUrl){throw new Error(this.declaredClass+":  The json data as specified by: ["+this._jsonFileUrl+"] is malformed.  Items within the list have identifier: ["+_17b+"].  Value collided: ["+_17c+"]");}else{if(this._jsonData){throw new Error(this.declaredClass+":  The json data provided by the creation arguments is malformed.  Items within the list have identifier: ["+_17b+"].  Value collided: ["+_17c+"]");}}}}}else{this._features["dojo.data.api.Identity"]=Number;}for(i=0;i<this._arrayOfAllItems.length;++i){item=this._arrayOfAllItems[i];item[this._storeRefPropName]=this;item[this._itemNumPropName]=i;}for(i=0;i<this._arrayOfAllItems.length;++i){item=this._arrayOfAllItems[i];for(key in item){_17a=item[key];for(var j=0;j<_17a.length;++j){_179=_17a[j];if(_179!==null&&typeof _179=="object"){if(("_type" in _179)&&("_value" in _179)){var type=_179._type;var _17d=this._datatypeMap[type];if(!_17d){throw new Error("dojo.data.ItemFileReadStore: in the typeMap constructor arg, no object class was specified for the datatype '"+type+"'");}else{if(lang.isFunction(_17d)){_17a[j]=new _17d(_179._value);}else{if(lang.isFunction(_17d.deserialize)){_17a[j]=_17d.deserialize(_179._value);}else{throw new Error("dojo.data.ItemFileReadStore: Value provided in typeMap was neither a constructor, nor a an object with a deserialize function");}}}}if(_179._reference){var _17e=_179._reference;if(!lang.isObject(_17e)){_17a[j]=this._getItemByIdentity(_17e);}else{for(var k=0;k<this._arrayOfAllItems.length;++k){var _17f=this._arrayOfAllItems[k],_180=true;for(var _181 in _17e){if(_17f[_181]!=_17e[_181]){_180=false;}}if(_180){_17a[j]=_17f;}}}if(this.referenceIntegrity){var _182=_17a[j];if(this.isItem(_182)){this._addReferenceToMap(_182,item,key);}}}else{if(this.isItem(_179)){if(this.referenceIntegrity){this._addReferenceToMap(_179,item,key);}}}}}}}},_addReferenceToMap:function(_183,_184,_185){},getIdentity:function(item){var _186=this._features["dojo.data.api.Identity"];if(_186===Number){return item[this._itemNumPropName];}else{var _187=item[_186];if(_187){return _187[0];}}return null;},fetchItemByIdentity:function(_188){var item,_189;if(!this._loadFinished){var self=this;if(this._jsonFileUrl!==this._ccUrl){_13d.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");this._ccUrl=this._jsonFileUrl;this.url=this._jsonFileUrl;}else{if(this.url!==this._ccUrl){this._jsonFileUrl=this.url;this._ccUrl=this.url;}}if(this.data!=null&&this._jsonData==null){this._jsonData=this.data;this.data=null;}if(this._jsonFileUrl){if(this._loadInProgress){this._queuedFetches.push({args:_188});}else{this._loadInProgress=true;var _18a={url:self._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk};var _18b=xhr.get(_18a);_18b.addCallback(function(data){var _18c=_188.scope?_188.scope:_13d.global;try{self._getItemsFromLoadedData(data);self._loadFinished=true;self._loadInProgress=false;item=self._getItemByIdentity(_188.identity);if(_188.onItem){_188.onItem.call(_18c,item);}self._handleQueuedFetches();}catch(error){self._loadInProgress=false;if(_188.onError){_188.onError.call(_18c,error);}}});_18b.addErrback(function(_18d){self._loadInProgress=false;if(_188.onError){var _18e=_188.scope?_188.scope:_13d.global;_188.onError.call(_18e,_18d);}});}}else{if(this._jsonData){self._getItemsFromLoadedData(self._jsonData);self._jsonData=null;self._loadFinished=true;item=self._getItemByIdentity(_188.identity);if(_188.onItem){_189=_188.scope?_188.scope:_13d.global;_188.onItem.call(_189,item);}}}}else{item=this._getItemByIdentity(_188.identity);if(_188.onItem){_189=_188.scope?_188.scope:_13d.global;_188.onItem.call(_189,item);}}},_getItemByIdentity:function(_18f){var item=null;if(this._itemsByIdentity){if(Object.hasOwnProperty.call(this._itemsByIdentity,_18f)){item=this._itemsByIdentity[_18f];}}else{if(Object.hasOwnProperty.call(this._arrayOfAllItems,_18f)){item=this._arrayOfAllItems[_18f];}}if(item===undefined){item=null;}return item;},getIdentityAttributes:function(item){var _190=this._features["dojo.data.api.Identity"];if(_190===Number){return null;}else{return [_190];}},_forceLoad:function(){var self=this;if(this._jsonFileUrl!==this._ccUrl){_13d.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");this._ccUrl=this._jsonFileUrl;this.url=this._jsonFileUrl;}else{if(this.url!==this._ccUrl){this._jsonFileUrl=this.url;this._ccUrl=this.url;}}if(this.data!=null){this._jsonData=this.data;this.data=null;}if(this._jsonFileUrl){var _191={url:this._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk,sync:true};var _192=xhr.get(_191);_192.addCallback(function(data){try{if(self._loadInProgress!==true&&!self._loadFinished){self._getItemsFromLoadedData(data);self._loadFinished=true;}else{if(self._loadInProgress){throw new Error(this.declaredClass+":  Unable to perform a synchronous load, an async load is in progress.");}}}catch(e){throw e;}});_192.addErrback(function(_193){throw _193;});}else{if(this._jsonData){self._getItemsFromLoadedData(self._jsonData);self._jsonData=null;self._loadFinished=true;}}}});lang.extend(_144,_142);return _144;});},"dojo/data/util/filter":function(){define(["../../_base/lang"],function(lang){var _194={};lang.setObject("dojo.data.util.filter",_194);_194.patternToRegExp=function(_195,_196){var rxp="^";var c=null;for(var i=0;i<_195.length;i++){c=_195.charAt(i);switch(c){case "\\":rxp+=c;i++;rxp+=_195.charAt(i);break;case "*":rxp+=".*";break;case "?":rxp+=".";break;case "$":case "^":case "/":case "+":case ".":case "|":case "(":case ")":case "{":case "}":case "[":case "]":rxp+="\\";default:rxp+=c;}}rxp+="$";if(_196){return new RegExp(rxp,"mi");}else{return new RegExp(rxp,"m");}};return _194;});},"dojo/data/util/simpleFetch":function(){define(["../../_base/lang","../../_base/kernel","./sorter"],function(lang,_197,_198){var _199={};lang.setObject("dojo.data.util.simpleFetch",_199);_199.errorHandler=function(_19a,_19b){if(_19b.onError){var _19c=_19b.scope||_197.global;_19b.onError.call(_19c,_19a,_19b);}};_199.fetchHandler=function(_19d,_19e){var _19f=_19e.abort||null,_1a0=false,_1a1=_19e.start?_19e.start:0,_1a2=(_19e.count&&(_19e.count!==Infinity))?(_1a1+_19e.count):_19d.length;_19e.abort=function(){_1a0=true;if(_19f){_19f.call(_19e);}};var _1a3=_19e.scope||_197.global;if(!_19e.store){_19e.store=this;}if(_19e.onBegin){_19e.onBegin.call(_1a3,_19d.length,_19e);}if(_19e.sort){_19d.sort(_198.createSortFunction(_19e.sort,this));}if(_19e.onItem){for(var i=_1a1;(i<_19d.length)&&(i<_1a2);++i){var item=_19d[i];if(!_1a0){_19e.onItem.call(_1a3,item,_19e);}}}if(_19e.onComplete&&!_1a0){var _1a4=null;if(!_19e.onItem){_1a4=_19d.slice(_1a1,_1a2);}_19e.onComplete.call(_1a3,_1a4,_19e);}};_199.fetch=function(_1a5){_1a5=_1a5||{};if(!_1a5.store){_1a5.store=this;}this._fetchItems(_1a5,lang.hitch(this,"fetchHandler"),lang.hitch(this,"errorHandler"));return _1a5;};return _199;});},"dojo/data/util/sorter":function(){define(["../../_base/lang"],function(lang){var _1a6={};lang.setObject("dojo.data.util.sorter",_1a6);_1a6.basicComparator=function(a,b){var r=-1;if(a===null){a=undefined;}if(b===null){b=undefined;}if(a==b){r=0;}else{if(a>b||a==null){r=1;}}return r;};_1a6.createSortFunction=function(_1a7,_1a8){var _1a9=[];function _1aa(attr,dir,comp,s){return function(_1ab,_1ac){var a=s.getValue(_1ab,attr);var b=s.getValue(_1ac,attr);return dir*comp(a,b);};};var _1ad;var map=_1a8.comparatorMap;var bc=_1a6.basicComparator;for(var i=0;i<_1a7.length;i++){_1ad=_1a7[i];var attr=_1ad.attribute;if(attr){var dir=(_1ad.descending)?-1:1;var comp=bc;if(map){if(typeof attr!=="string"&&("toString" in attr)){attr=attr.toString();}comp=map[attr]||bc;}_1a9.push(_1aa(attr,dir,comp,_1a8));}}return function(rowA,rowB){var i=0;while(i<_1a9.length){var ret=_1a9[i++](rowA,rowB);if(ret!==0){return ret;}}return 0;};};return _1a6;});},"dojo/date/stamp":function(){define(["../_base/lang","../_base/array"],function(lang,_1ae){var _1af={};lang.setObject("dojo.date.stamp",_1af);_1af.fromISOString=function(_1b0,_1b1){if(!_1af._isoRegExp){_1af._isoRegExp=/^(?:(\d{4})(?:-(\d{2})(?:-(\d{2}))?)?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(.\d+)?)?((?:[+-](\d{2}):(\d{2}))|Z)?)?$/;}var _1b2=_1af._isoRegExp.exec(_1b0),_1b3=null;if(_1b2){_1b2.shift();if(_1b2[1]){_1b2[1]--;}if(_1b2[6]){_1b2[6]*=1000;}if(_1b1){_1b1=new Date(_1b1);_1ae.forEach(_1ae.map(["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],function(prop){return _1b1["get"+prop]();}),function(_1b4,_1b5){_1b2[_1b5]=_1b2[_1b5]||_1b4;});}_1b3=new Date(_1b2[0]||1970,_1b2[1]||0,_1b2[2]||1,_1b2[3]||0,_1b2[4]||0,_1b2[5]||0,_1b2[6]||0);if(_1b2[0]<100){_1b3.setFullYear(_1b2[0]||1970);}var _1b6=0,_1b7=_1b2[7]&&_1b2[7].charAt(0);if(_1b7!="Z"){_1b6=((_1b2[8]||0)*60)+(Number(_1b2[9])||0);if(_1b7!="-"){_1b6*=-1;}}if(_1b7){_1b6-=_1b3.getTimezoneOffset();}if(_1b6){_1b3.setTime(_1b3.getTime()+_1b6*60000);}}return _1b3;};_1af.toISOString=function(_1b8,_1b9){var _1ba=function(n){return (n<10)?"0"+n:n;};_1b9=_1b9||{};var _1bb=[],_1bc=_1b9.zulu?"getUTC":"get",date="";if(_1b9.selector!="time"){var year=_1b8[_1bc+"FullYear"]();date=["0000".substr((year+"").length)+year,_1ba(_1b8[_1bc+"Month"]()+1),_1ba(_1b8[_1bc+"Date"]())].join("-");}_1bb.push(date);if(_1b9.selector!="date"){var time=[_1ba(_1b8[_1bc+"Hours"]()),_1ba(_1b8[_1bc+"Minutes"]()),_1ba(_1b8[_1bc+"Seconds"]())].join(":");var _1bd=_1b8[_1bc+"Milliseconds"]();if(_1b9.milliseconds){time+="."+(_1bd<100?"0":"")+_1ba(_1bd);}if(_1b9.zulu){time+="Z";}else{if(_1b9.selector!="time"){var _1be=_1b8.getTimezoneOffset();var _1bf=Math.abs(_1be);time+=(_1be>0?"-":"+")+_1ba(Math.floor(_1bf/60))+":"+_1ba(_1bf%60);}}_1bb.push(time);}return _1bb.join("T");};return _1af;});},"demos/shippingRoutes/src/PortRenderer":function(){define(["dojo/_base/kernel","dojo/_base/declare","./EcrRenderer","dojox/geo/openlayers/GeometryFeature","dojox/geo/openlayers/Point"],function(dojo,_1c0,_1c1,_1c2,_1c3){return _1c0(_1c1,{constructor:function(opts,_1c4){},_renderItem:function(o,item){var gf=null;if(o.type=="circle"){var _1c5=this.getCoordinates(item);var g=new _1c3({x:_1c5[0],y:_1c5[1]});gf=new _1c2(g);gf.setShapeProperties({r:o.radius});}return gf;}});});},"demos/shippingRoutes/src/EcrRenderer":function(){define(["dojo/_base/kernel","dojo/_base/declare","dojo/_base/array","dojo/_base/lang"],function(dojo,_1c6,arr,lang){return _1c6(null,{constructor:function(opts,_1c7){this._options=opts;this._context=_1c7;},render:function(item){var o=this._options;return this._render(o,item);},_render:function(o,item){if(o instanceof Array){var _1c8=[];o.sort(function(i1,i2){var d1=i1.depth;var d2=i2.depth;if(d1!=undefined&&d2!=undefined){var id1=parseInt(d1);var id2=parseInt(d2);if(id1==id2){return 0;}if(id1<id2){return -1;}return 1;}return 0;});arr.forEach(o,function(oi,_1c9,_1ca){var co=lang.clone(oi);this._callFunctions(co,item);this._solveReferences(co,item);var f=this._render(co,item);if(f!=null){f.setStroke(co.stroke);f.setFill(co.fill);_1c8.push(f);}},this);return _1c8;}var co=lang.clone(o);this._callFunctions(co,item);this._solveReferences(co,item);var gf=this._renderItem(co,item);if(gf!=null){gf.setStroke(co.stroke);gf.setFill(co.fill);}return gf;},_renderItem:function(o,item){return null;},_callFunctions:function(o,item){for(var prop in o){if(o.hasOwnProperty(prop)){var v=o[prop];if(typeof v=="function"){o[prop]=v.call(item,this._context);}else{if(typeof v=="object"){this._callFunctions(v,item);}}}}},getContext:function(){return this._context;},getContextValue:function(name){if(this._context){return this._context[name];}return undefined;},getValue:function(item,_1cb){var s=this.getContextValue("store");if((s!=undefined)&&s.isItem(item)){return s.getValue(item,_1cb);}if(item.hasOwnProperty(_1cb)){return item[_1cb];}return undefined;},_coords:[0,0],getCoordinates:function(item){var lon=this.getValue(item,"longitude");var lat=this.getValue(item,"latitude");var flon=parseFloat(lon);var flat=parseFloat(lat);var a=this._coords;a[0]=flon;a[1]=flat;return a;},_findAttributeValue:function(o,a,item){var v=undefined;if(item!=null){v=this.getValue(item,a);}if(v!=undefined){return v;}v=o[a];if(v!=undefined){return v;}for(var i in o){var ov=o[i];if(typeof (ov)=="object"){var vv=this._findAttributeValue(ov,a,null);if(vv!=undefined){return vv;}}}return undefined;},_solveReferences:function(o,item){this.__solveReferences(o,o,item);},__solveReferences:function(oo,o,item){for(var a in o){var v=o[a];if(typeof (v)=="object"){this.__solveReferences(oo,v,item);}if(typeof (v)=="string"){var re=/{(.*)}/;if(v.match(re)){v=v.replace(re,"$1");var r=this._findAttributeValue(oo,v,item);if(r!=undefined){var ps=parseFloat(r);if(isNaN(ps)){o[a]=r;}else{o[a]=ps;}}}}}}});});},"dojox/geo/openlayers/GeometryFeature":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojox/gfx/matrix","./Point","./LineString","./Collection","./Feature"],function(_1cc,_1cd,lang,_1ce,_1cf,_1d0,_1d1,_1d2){return _1cc("dojox.geo.openlayers.GeometryFeature",_1d2,{constructor:function(_1d3){this._geometry=_1d3;this._shapeProperties={};this._fill=null;this._stroke=null;},_createCollection:function(g){var _1d4=this.getLayer();var s=_1d4.getSurface();var c=this.createShape(s,g);var vp=_1d4.getViewport();vp.add(c);return c;},_getCollectionShape:function(g){var s=g.shape;if(s==null){s=this._createCollection(g);g.shape=s;}return s;},renderCollection:function(g){if(g==undefined){g=this._geometry;}s=this._getCollectionShape(g);var prop=this.getShapeProperties();s.setShape(prop);_1cd.forEach(g.coordinates,function(item){if(item instanceof _1cf){this.renderPoint(item);}else{if(item instanceof _1d0){this.renderLineString(item);}else{if(item instanceof _1d1){this.renderCollection(item);}else{throw new Error();}}}},this);this._applyStyle(g);},render:function(g){if(g==undefined){g=this._geometry;}if(g instanceof _1cf){this.renderPoint(g);}else{if(g instanceof _1d0){this.renderLineString(g);}else{if(g instanceof _1d1){this.renderCollection(g);}else{throw new Error();}}}},getShapeProperties:function(){return this._shapeProperties;},setShapeProperties:function(s){this._shapeProperties=s;return this;},createShape:function(s,g){if(!g){g=this._geometry;}var _1d5=null;if(g instanceof _1cf){_1d5=s.createCircle();}else{if(g instanceof _1d0){_1d5=s.createPolyline();}else{if(g instanceof _1d1){var grp=s.createGroup();_1cd.forEach(g.coordinates,function(item){var shp=this.createShape(s,item);grp.add(shp);},this);_1d5=grp;}else{throw new Error();}}}return _1d5;},getShape:function(){var g=this._geometry;if(!g){return null;}if(g.shape){return g.shape;}this.render();return g.shape;},_createPoint:function(g){var _1d6=this.getLayer();var s=_1d6.getSurface();var c=this.createShape(s,g);var vp=_1d6.getViewport();vp.add(c);return c;},_getPointShape:function(g){var s=g.shape;if(s==null){s=this._createPoint(g);g.shape=s;}return s;},renderPoint:function(g){if(g==undefined){g=this._geometry;}var _1d7=this.getLayer();var map=_1d7.getDojoMap();s=this._getPointShape(g);var prop=lang.mixin({},this._defaults.pointShape);prop=lang.mixin(prop,this.getShapeProperties());s.setShape(prop);var from=this.getCoordinateSystem();var p=map.transform(g.coordinates,from);var a=this._getLocalXY(p);var cx=a[0];var cy=a[1];var tr=_1d7.getViewport().getTransform();if(tr){s.setTransform(_1ce.translate(cx-tr.dx,cy-tr.dy));}this._applyStyle(g);},_createLineString:function(g){var _1d8=this.getLayer();var s=_1d8._surface;var _1d9=this.createShape(s,g);var vp=_1d8.getViewport();vp.add(_1d9);g.shape=_1d9;return _1d9;},_getLineStringShape:function(g){var s=g.shape;if(s==null){s=this._createLineString(g);g.shape=s;}return s;},renderLineString:function(g){if(g==undefined){g=this._geometry;}var _1da=this.getLayer();var map=_1da.getDojoMap();var lss=this._getLineStringShape(g);var from=this.getCoordinateSystem();var _1db=new Array(g.coordinates.length);var tr=_1da.getViewport().getTransform();_1cd.forEach(g.coordinates,function(c,i,_1dc){var p=map.transform(c,from);var a=this._getLocalXY(p);if(tr){a[0]-=tr.dx;a[1]-=tr.dy;}_1db[i]={x:a[0],y:a[1]};},this);var prop=lang.mixin({},this._defaults.lineStringShape);prop=lang.mixin(prop,this.getShapeProperties());prop=lang.mixin(prop,{points:_1db});lss.setShape(prop);this._applyStyle(g);},_applyStyle:function(g){if(!g||!g.shape){return;}var f=this.getFill();var fill;if(!f||lang.isString(f)||lang.isArray(f)){fill=f;}else{fill=lang.mixin({},this._defaults.fill);fill=lang.mixin(fill,f);}var s=this.getStroke();var _1dd;if(!s||lang.isString(s)||lang.isArray(s)){_1dd=s;}else{_1dd=lang.mixin({},this._defaults.stroke);_1dd=lang.mixin(_1dd,s);}this._applyRecusiveStyle(g,_1dd,fill);},_applyRecusiveStyle:function(g,_1de,fill){var shp=g.shape;if(shp.setFill){shp.setFill(fill);}if(shp.setStroke){shp.setStroke(_1de);}if(g instanceof _1d1){_1cd.forEach(g.coordinates,function(i){this._applyRecusiveStyle(i,_1de,fill);},this);}},setStroke:function(s){this._stroke=s;return this;},getStroke:function(){return this._stroke;},setFill:function(f){this._fill=f;return this;},getFill:function(){return this._fill;},remove:function(){var g=this._geometry;var shp=g.shape;g.shape=null;if(shp){shp.removeShape();}if(g instanceof _1d1){_1cd.forEach(g.coordinates,function(i){this.remove(i);},this);}},_defaults:{fill:null,stroke:null,pointShape:{r:30},lineStringShape:null}});});},"dojox/geo/openlayers/Point":function(){define(["dojo/_base/declare","./Geometry"],function(_1df,_1e0){return _1df("dojox.geo.openlayers.Point",_1e0,{setPoint:function(p){this.coordinates=p;},getPoint:function(){return this.coordinates;}});});},"dojox/geo/openlayers/Geometry":function(){define(["dojo/_base/declare"],function(_1e1){return _1e1("dojox.geo.openlayers.Geometry",null,{coordinates:null,shape:null,constructor:function(_1e2){this.coordinates=_1e2;}});});},"dojox/geo/openlayers/LineString":function(){define(["dojo/_base/declare","./Geometry"],function(_1e3,_1e4){return _1e3("dojox.geo.openlayers.LineString",_1e4,{setPoints:function(p){this.coordinates=p;},getPoints:function(){return this.coordinates;}});});},"dojox/geo/openlayers/Collection":function(){define(["dojo/_base/declare","./Geometry"],function(_1e5,_1e6){return _1e5("dojox.geo.openlayers.Collection",_1e6,{coordinates:null,setGeometries:function(g){this.coordinates=g;},getGeometries:function(){return this.coordinates;}});});},"demos/shippingRoutes/src/LegsRenderer":function(){define(["dojo/_base/declare","dojo/_base/array","./EcrRenderer","dojox/geo/openlayers/GeometryFeature","dojox/geo/openlayers/LineString","dojox/geo/openlayers/Point","dojox/geo/openlayers/GreatCircle"],function(_1e7,arr,_1e8,_1e9,_1ea,_1eb,_1ec){return _1e7(_1e8,{constructor:function(opts,_1ed){this._geodetic=false;this._greatCircle=null;},setGeodetic:function(_1ee){this._geodetic=_1ee;},getGeodetic:function(){return this._geodetic;},_renderItem:function(o,item){var gf=null;if(o.type=="polyline"){var _1ef=this.getContextValue("store");var _1f0=_1ef.getValues(item,"stops");var pts=[];var _1f1=null;arr.forEach(_1f0,function(it,_1f2,_1f3){if(_1ef.isItem(it)){var port=this.getValue(it,"port");var _1f4=this.getCoordinates(port);if(this.getGeodetic()){if(_1f1!=null){var _1f5={x:_1f4[0],y:_1f4[1]};var _1f6=_1ec.toPointArray(_1f1,_1f5,5);pts=pts.concat(_1f6);}}else{var p=new _1eb({x:_1f4[0],y:_1f4[1]});pts.push(p);}_1f1={x:_1f4[0],y:_1f4[1]};}},this);var g=new _1ea(pts);gf=new _1e9(g);}return gf;}});});},"dojox/geo/openlayers/GreatCircle":function(){define(["dojo/_base/lang","./_base","./GeometryFeature"],function(lang,_1f7,_1f8){var gc=_1f7.GreatCircle={toPointArray:function(p1,p2,_1f9){var _1fa=p1.x;var _1fb=p2.x;var sl=Math.min(_1fa,_1fb);var el=Math.max(_1fa,_1fb);var d2r=this.DEG2RAD;var lat1=p1.y*d2r;var lon1=p1.x*d2r;var lat2=p2.y*d2r;var lon2=p2.x*d2r;if(Math.abs(lon1-lon2)<=this.TOLERANCE){var l=Math.min(lon1,lon2);lon2=l+Math.PI;}if(Math.abs(lon2-lon1)==Math.PI){if(lat1+lat2==0){lat2+=Math.PI/180000000;}}var lon=sl*d2r;var elon=el*d2r;var incr=_1f9*d2r;var wp=[];var k=0;var r2d=this.RAD2DEG;while(lon<=elon){lat=Math.atan((Math.sin(lat1)*Math.cos(lat2)*Math.sin(lon-lon2)-Math.sin(lat2)*Math.cos(lat1)*Math.sin(lon-lon1))/(Math.cos(lat1)*Math.cos(lat2)*Math.sin(lon1-lon2)));var p={x:lon*r2d,y:lat*r2d};wp[k++]=p;if(lon<elon&&(lon+incr)>=elon){lon=elon;}else{lon=lon+incr;}}return wp;},toLineString:function(p1,p2,_1fc){var wp=this.toPointArray(p1,p2,_1fc);var ls=new OpenLayers.Geometry.LineString(wp);return ls;},toGeometryFeature:function(p1,p2,_1fd){var ls=this.toLineString(p1,p2,_1fd);return new _1f8(ls);},DEG2RAD:Math.PI/180,RAD2DEG:180/Math.PI,TOLERANCE:0.00001};return gc;});}}});var _ecr;require(["dojo/ready","demos/shippingRoutes/src/Ecr"],function(_1fe,Ecr){_1fe(function(){_ecr=new Ecr();});});